

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetDeviceCount.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetDeviceCount.sp,v $ $Id: APPGetDeviceCount.sp,v 1.1.4.5 2018/10/22 19:47:21 pankajkumar Exp $";
--	+===================================================================+
--	| APPGetLaptopClientList - Get Laptop Client list 					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetDeviceCount')
BEGIN
	print '>>> Drop Stored Procedure: APPGetDeviceCount <<<'
	drop procedure APPGetDeviceCount
END
IF EXISTS (select * from GxQscripts where name='APPGetDeviceCount')
	delete from GxQscripts where name = 'APPGetDeviceCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDeviceCount')
	delete from GXDBVersions where aliasname = 'APPGetDeviceCount'
GO
print '... Creating Procedure: APPGetDeviceCount'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetDeviceCount
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_userId INT
-----------------------------------------------------------
AS
  DECLARE @count INT
BEGIN
	SET NOCOUNT ON
	-- AEB:	ProdCS incurring high level of blocking waits on JM Tables.
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @allAssociation int =0
	IF object_id('tempdb.dbo.#clientListTmp') is not null DROP TABLE #clientListTmp
	create table  #clientListTmp ( [capabilities]  bigint NOT null, [flag]      int NOT null default 0, [commCellId]    int NOT null default 2, [clientGroupId] int NOT null default 0, [clientId]      int NOT null default 0, [appTypeId]     int NOT null default 0, [instanceId]    int NOT null default 0, [backupsetId]   int NOT null default 0, [subClientId]   int NOT null default 0, [mediaAgentId]  int NOT null default 0, [libraryId]     int NOT null default 0, [archGroupId]   int NOT null default 0, [vtContainerId] int NOT null default 0, [vtPolicyId]    int NOT null default 0, [vtShelfId]     int NOT null default 0, [reviewSetId]   int NOT null default 0, [querySetId]    int NOT null default 0, [downloadSetId] int NOT null default 0, [ermId]       int NOT null default 0, [legalHoldId]   int NOT null default 0, [tagId]     int NOT null default 0, [cdPolicyId]    int NOT null default 0, [complianceReportId]   int  NOT null default 0, [taskId]        int NOT null default 0, [workflowId]    int NOT null default 0, [logMonitoringPolicyId] int NOT null default 0, [arrayId]       int NOT null default 0, [cloudId]       int NOT null default 0, [userGroupId]   int NOT null default 0, [providerId]    int NOT null default 0, [entityId1]     int NOT null default 0, [entityId2]     int NOT null default 0, [entityId3]     int NOT null default 0, [entityId4]     int NOT null default 0, [entityId5]     int NOT null default 0, [entityId6]     int NOT null default 0, [entityId7]     int NOT null default 0, [entityId8]     int NOT null default 0, [entityId9]     int NOT null default 0  )
	EXEC sec_getUserObjects @i_userId, 2009, 0, '#clientListTmp'
	DECLARE @clientTbl TABLE (
	clientId INT PRIMARY KEY)
	IF  EXISTS(SELECT    1
				  FROM      #clientListTmp AO
				  WHERE     AO.commCellId = 2         AND AO.clientGroupId = 0 AND AO.clientId = 0      AND AO.appTypeId = 0             AND AO.instanceId = 0  AND
							AO.backupsetId = 0        AND AO.subClientId = 0   AND AO.mediaAgentId = 0  AND AO.libraryId = 0             AND AO.archGroupId = 0 AND
							AO.vtContainerId = 0      AND AO.vtPolicyId = 0    AND AO.vtShelfId = 0     AND AO.reviewSetId = 0           AND AO.querySetId = 0  AND
							AO.downloadSetId = 0      AND AO.ermId = 0         AND AO.legalHoldId = 0   AND AO.tagId = 0                 AND AO.cdPolicyId = 0  AND
							AO.complianceReportId = 0 AND AO.taskId = 0        AND AO.workflowId = 0    AND AO.logMonitoringPolicyId = 0 AND AO.arrayId = 0     AND
							AO.cloudId = 0            AND AO.userGroupId = 0   AND AO.providerId = 0    AND AO.entityId1 = 0             AND AO.entityId2 = 0   AND
							AO.entityId3 = 0          AND AO.entityId4 = 0     AND AO.entityId5 = 0     AND AO.entityId6 = 0             AND AO.entityId7 = 0   AND
							AO.entityId8 = 0          AND AO.entityId9 = 0)
	BEGIN
	  SET @allAssociation =1
	END
	IF ( @allAssociation =1)
	BEGIN
	INSERT INTO @clientTbl
	SELECT  C.id
	FROM
		APP_Client C
		LEFT OUTER JOIN APP_ClientProp ACP
ON ACP.componentNameId=C.id AND ACP.attrName='Index Server Type' AND ACP.attrVal IN (15,8)
	WHERE
		c.specialClientFlags & 0x1 <> 0x1
		AND NOT EXISTS (SELECT APP_VMToPMMap.PMClientId FROM APP_VMToPMMap WHERE APP_VMToPMMap.PMClientId = C.id AND APP_VMToPMMap.VMClientId = 2)
		AND (ACP.attrVal IS NULL)
	INSERT INTO @clientTbl
	SELECT  C.id
		FROM
			APP_Client C
			INNER JOIN APP_ClientProp ACP1
				ON ACP1.componentNameId=C.id AND ACP1.attrName='Virtual Server Discovered Clients'
			INNER JOIN APP_ClientProp ACP2 ON ACP2.componentNameId=C.id AND ACP2.attrName='Last Backup JobID'
			LEFT JOIN @clientTbl Cl
			ON Cl.clientId =C.id
			WHERE  Cl.ClientID is null and   (ACP1.attrVal='1'  AND ACP1.Modified=0) AND  (ACP2.attrVal <>'0' AND  ACP2.Modified=0)
	END
	ELSE
	BEGIN
	INSERT INTO @clientTbl
	SELECT  C.id
	FROM
		APP_Client C
		INNER JOIN #clientListTmp CT ON C.id = CT.clientId
		LEFT OUTER JOIN APP_ClientProp ACP
ON ACP.componentNameId=C.id AND ACP.attrName='Index Server Type' AND ACP.attrVal IN (15,8)
	WHERE
		c.specialClientFlags & 0x1 <> 0x1
		AND NOT EXISTS (SELECT APP_VMToPMMap.PMClientId FROM APP_VMToPMMap WHERE APP_VMToPMMap.PMClientId = C.id AND APP_VMToPMMap.VMClientId = 2)
			AND (ACP.attrVal IS NULL)
	INSERT INTO @clientTbl
	SELECT  C.id
		FROM
			APP_Client C
			INNER JOIN #clientListTmp CT ON C.id = CT.clientId
			INNER JOIN APP_ClientProp ACP1
				ON ACP1.componentNameId=C.id AND ACP1.attrName='Virtual Server Discovered Clients'
			INNER JOIN APP_ClientProp ACP2 ON ACP2.componentNameId=C.id AND ACP2.attrName='Last Backup JobID'
			LEFT JOIN @clientTbl Cl
			ON Cl.clientId =C.id
				WHERE  Cl.ClientID is null and   (ACP1.attrVal='1'  AND ACP1.Modified=0) AND  (ACP2.attrVal <>'0' AND  ACP2.Modified=0)
	END
	DELETE ct
	FROM  @clientTbl ct
	  LEFT OUTER JOIN APP_Platform p WITH(NOLOCK) ON
		p.clientId = ct.clientId
		AND p.platformType = 4
	WHERE
	  p.clientId IS NULL
	SELECT COUNT(*) 'Device Count' FROM @clientTbl
	DROP TABLE #clientListTmp
	SET NOCOUNT OFF
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetDeviceCount')
	delete from GxQscripts where name = 'APPGetDeviceCount'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDeviceCount')
	delete from GXDBVersions where aliasname = 'APPGetDeviceCount'
GO

insert into GXDBVersions values(2, 'APPGetDeviceCount',  '00010001000400050000', 'APPGetDeviceCount', '00010001000400050000')
GO

