

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetDM2CloudMetaProp.sp] ---------- 

--  +========================================================================+
--  |		 		 Name:  APPGetDM2CloudMetaProp
--  |				get meta properties (eg. Index location) for input index server
--  +========================================================================+
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetDM2CloudMetaProp.sp,v $ $Id: APPGetDM2CloudMetaProp.sp,v 1.1.4.5 2020/05/07 14:59:32 pankajkumar Exp $";
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetDM2CloudMetaProp')
BEGIN
	print '>>> Drop Stored Procedure: APPGetDM2CloudMetaProp <<<'
	drop procedure APPGetDM2CloudMetaProp
END
IF EXISTS (select * from GxQscripts where name='APPGetDM2CloudMetaProp')
	delete from GxQscripts where name = 'APPGetDM2CloudMetaProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDM2CloudMetaProp')
	delete from GXDBVersions where aliasname = 'APPGetDM2CloudMetaProp'
GO
print '... Creating Procedure: APPGetDM2CloudMetaProp'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetDM2CloudMetaProp
  @i_cloudID INT,
  @i_propertyName VARCHAR(128) = ''    
AS
  DECLARE @o_propertyName VARCHAR(128) = ''
  DECLARE @o_propertyValue VARCHAR(1024) = ''
	  DECLARE @o_outputTable TABLE (name NVARCHAR(256), value nvarchar(1024))
      DECLARE @cloudPropXml XML
       IF(@i_cloudID > 0)
       BEGIN
		  --INDEXLOCATION
			INSERT INTO @o_outputTable
			SELECT 'INDEXLOCATION', dbo.SEGetIndexLocation(@i_cloudID, 0)
            SELECT @cloudPropXml = cloudProps FROM DM2Cloud  WITH (NOLOCK) WHERE cloudId = @i_cloudID AND ISNULL(CloudProps,'') <> ''
            IF(@cloudPropXml IS NOT NULL)
            BEGIN
                    INSERT INTO @o_outputTable
                    SELECT  ref.value('@name', 'NVARCHAR(1024)'),ref.value('@value', 'NVARCHAR(1024)')
                    FROM @cloudPropXml.nodes ('CloudMetaProp/cloudMetaInfos') R(ref)
					WHERE ref.value('@name', 'NVARCHAR(1024)') != 'INDEXLOCATION'
            END
       END
       SELECT * FROM @o_outputTable WHERE ISNULL(@i_propertyName, '') = '' OR name = @i_propertyName
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetDM2CloudMetaProp')
	delete from GxQscripts where name = 'APPGetDM2CloudMetaProp'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDM2CloudMetaProp')
	delete from GXDBVersions where aliasname = 'APPGetDM2CloudMetaProp'
GO

insert into GXDBVersions values(2, 'APPGetDM2CloudMetaProp',  '00010001000400050000', 'APPGetDM2CloudMetaProp', '00010001000400050000')
GO

