

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetDAGProxyClients.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetDAGProxyClients.sp,v $ $Id: APPGetDAGProxyClients.sp,v 1.4.88.4 2018/07/10 18:52:20 nuppu Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 04/30/2012
-- Description:	Get all the 2010 exchange DB
-- clients that can be used as DAG proxy
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetDAGProxyClients <<<'

IF EXISTS (select * from sysobjects where name='APPGetDAGProxyClients')
	drop procedure APPGetDAGProxyClients
IF EXISTS (select * from GxQscripts where name='APPGetDAGProxyClients')
	delete from GxQscripts where name = 'APPGetDAGProxyClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDAGProxyClients')
	delete from GXDBVersions where aliasname = 'APPGetDAGProxyClients'
GO
print '... Creating Procedure: APPGetDAGProxyClients'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetDAGProxyClients
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
BEGIN
SET NOCOUNT ON
	DECLARE @userId int = 0
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS client
	FROM    @xmlText.nodes('Ida_DAGProxyReq/processinginstructioninfo/user') R ( ref )),0)
	IF object_id('tempdb.dbo.#userClients') IS NOT null DROP TABLE #userClients
	CREATE TABLE #userClients
	(
		t_clientId INT, t_appTypeId INT, t_instanceId INT, t_backupsetId INT, t_subclientId INT
	)
EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
	SET @xmlText = (
		SELECT
(SELECT CL.id '@clientId', CL.name '@clientName', 3 '@_type_'
				FROM APP_Client CL WITH (NOLOCK)
				JOIN simInstalledPackages Sim WITH (NOLOCK) ON CL.id = Sim.ClientId
				JOIN #userClients UC ON CL.id = UC.t_clientId
				WHERE Sim.simPackageID = 151 AND UC.t_clientId = Sim.ClientId
				FOR XML PATH ('proxyClients'), TYPE)
		FOR XML PATH(''),
		ROOT('Ida_DAGProxyResp'))
	DROP TABLE #userClients
	SELECT @xmlText
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetDAGProxyClients')
	delete from GxQscripts where name = 'APPGetDAGProxyClients'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetDAGProxyClients')
	delete from GXDBVersions where aliasname = 'APPGetDAGProxyClients'
GO

insert into GXDBVersions values(2, 'APPGetDAGProxyClients',  '00010004008800040000', 'APPGetDAGProxyClients', '00010004008800040000')
GO

