

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetCloudCollectionsForSearch.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetCloudCollectionsForSearch.sp,v $ $Id: APPGetCloudCollectionsForSearch.sp,v 1.1.2.3 2020/04/20 03:26:30 pankajkumar Exp $";
--
--  +========================================================================+
--  |   Procedure:  APPGetCloudCollectionsForSearch()
--  |
--  | Description:  Returns cloudId and collectionName for input criteria.
--	|				input specifies allowedSubclient, searchMode, sourceType and if case manager search is enabled.
--	|				For end user mode, userGuids which includes all delegated user guids
--	|
--  |      Output:  cloudId and collectionName matching input criteria
--  |
--  +========================================================================+
IF NOT EXISTS (SELECT * FROM systypes where name = 'IdList')
BEGIN
CREATE TYPE IdList AS TABLE
  (
      id integer
  )
END
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetCloudCollectionsForSearch')
BEGIN
	print '>>> Drop Stored Procedure: APPGetCloudCollectionsForSearch <<<'
	drop procedure APPGetCloudCollectionsForSearch
END
IF EXISTS (select * from GxQscripts where name='APPGetCloudCollectionsForSearch')
	delete from GxQscripts where name = 'APPGetCloudCollectionsForSearch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetCloudCollectionsForSearch')
	delete from GXDBVersions where aliasname = 'APPGetCloudCollectionsForSearch'
GO
print '... Creating Procedure: APPGetCloudCollectionsForSearch'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetCloudCollectionsForSearch
  @inXml Xml,
  @allowedSubclients IdList READONLY,
  @o_errorCode INT OUTPUT,
  @o_errorMessage nvarchar(max) OUTPUT
AS
BEGIN
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
  DECLARE @i_cloudId INT
  DECLARE @i_caseManagerSearch INT
  DECLARE @i_mode INT
  DECLARE @i_sourceType VARCHAR(200)
	SET @i_sourceType = (select ISNULL(t.x.value('@sourceType','varchar(200)'),'') from @inXml.nodes('/DM2ContentIndexing_GetCloudCollectionsForSearch') t(x))
	SET @i_cloudId= (select t.x.value('@cloudId','int') from @inXml.nodes('/DM2ContentIndexing_GetCloudCollectionsForSearch') t(x))
	IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
		DROP TABLE #getCollectionInfoOutTbl
	CREATE TABLE #getCollectionInfoOutTbl
	(
        DatasourceId INT,
		CloudId INT,
		CollectionName VARCHAR(128),
		SourceType VARCHAR(30),
		SubsourceType VARCHAR(30),
        IdxServerClientId INT
	)
	DECLARE @l_subSourceTypePropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyGuid= 'F3C96257-7468-41CD-B40D-CF6D0D945DD3')
	DECLARE @l_sourceTypePropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyGuid= '617BB3EF-65A9-49C1-BC60-8F3820149236')
	IF ( @i_sourceType='exchange')
	BEGIN
		DECLARE @l_backupsetguidPropId INT = (SELECT PropertyId FROM SEProperty WHERE PropertyGuid = 'A7B87E15-49B7-4090-A068-22B6CC6A9B5F')
		SET @i_mode= (select t.x.value('@mode','int') from @inXml.nodes('/DM2ContentIndexing_GetCloudCollectionsForSearch') t(x))
		SET @i_caseManagerSearch= (select t.x.value('@caseManager','int') from @inXml.nodes('/DM2ContentIndexing_GetCloudCollectionsForSearch/searchOptions') t(x))
		IF ( @i_mode <> 1 AND @i_mode<> 2 )
		BEGIN
			SET @o_errorCode = 1001 --invalid input
			SET @o_errorMessage = 'Invalid siteMode passed.'
			GOTO ERROR_EXIT
		END
		IF NOT EXISTS( SELECT 1 FROM @allowedSubclients)
		BEGIN
			SET @o_errorCode = 3013 --NO_ASSOCIATED_CLIENTS
			SET @o_errorMessage = 'The input table (allowedSubclients) is empty. Check if user has permission on any subclient to search'
			GOTO ERROR_EXIT
		END
		IF OBJECT_ID('tempdb.dbo.#tempCloudSearchUserGuids') IS NOT NULL
			DROP TABLE #tempCloudSearchUserGuids
		CREATE TABLE #tempCloudSearchUserGuids
		(
			userGUID VARCHAR(512)
		)
		CREATE INDEX Idx_tempCloudSearchUserGuids_UserGuid on #tempCloudSearchUserGuids(userGUID)
		IF OBJECT_ID('tempdb.dbo.#tempCloudSearchBkpSetInfo') IS NOT NULL
			DROP TABLE #tempCloudSearchBkpSetInfo
		CREATE TABLE #tempCloudSearchBkpSetInfo
		(
			BackupsetId INT,
		)
		CREATE INDEX Idx_tempCloudSearchBkpSetInfo_BackupsetId on #tempCloudSearchBkpSetInfo(BackupsetId)
		IF OBJECT_ID('tempdb.dbo.#tempCloudSearchDataSourceInfo') IS NOT NULL
			DROP TABLE #tempCloudSearchDataSourceInfo
		CREATE TABLE #tempCloudSearchDataSourceInfo
		(
			DataSourceId INT
		)
		CREATE INDEX Idx_tempCloudSearchDataSourceInfo_DataSourceId on #tempCloudSearchDataSourceInfo(DataSourceId)
		INSERT INTO #tempCloudSearchUserGuids
		SELECT REPLACE(ISNULL(x.y.value('@val','varchar(max)') ,''),'-','x')
		FROM @inXml.nodes('/DM2ContentIndexing_GetCloudCollectionsForSearch/userGuids') AS x ( y )
		--end user mode -only active backupsets
		--if userGuid specified, we try to get usermailbox backupset where the input user's mailbox are backed up
		-- if userGuid not specified, we get all journal or contentstore backupsets
		IF ( @i_mode = 1 )
		BEGIN
			IF EXISTS (SELECT 1 FROM #tempCloudSearchUserGuids )
			BEGIN
				INSERT INTO #tempCloudSearchBkpSetInfo
				SELECT distinct backupsetId FROM APP_EmailConfigPolicyAssoc
				where modified =0 AND
				userGuid in ( select userGuid from #tempCloudSearchUserGuids ) AND ( mailBoxType in ( 1) OR discoverByType = 12 )
			END
			ELSE
			BEGIN
				INSERT INTO #tempCloudSearchBkpSetInfo
				SELECT distinct backupsetId FROM APP_EmailConfigPolicyAssoc
				where modified =0
				AND  mailBoxType in ( 2,3) --journal or contentstorembx
			END
		END
		--compliance mode
		-- we get all usermailbox, journalmailbox and contentstore mailbox backupsets
		-- if caseManagerSearch enabled, get all caseManager backupsets also
		IF ( @i_mode = 2 )
		BEGIN
			INSERT INTO #tempCloudSearchBkpSetInfo
			select distinct backupsetId from APP_EmailConfigPolicyAssoc where mailBoxType in ( 1,2,3) OR discoverByType=12
			IF ( @i_caseManagerSearch = 1 )
			BEGIN
				INSERT INTO #tempCloudSearchBkpSetInfo
				SELECT A.backupSet from APP_Application A
				WHERE
				A.clientId in
				(
					SELECT DISTINCT clientId from CMDefinition
				)
			END
		END
		--remove from entries where user doesnt have permissions
		delete from #tempCloudSearchBkpSetInfo where BackupsetId NOT in ( select backupset from APP_Application where id in ( select Id from @allowedSubclients ) )
		--Exchange client <-> datasource association is set as backupsetguid property in SEDataSourceProperty
		INSERT INTO #tempCloudSearchDataSourceInfo
		SELECT DISTINCT DataSourceId
		FROM SEDataSourceProperty DS (NOLOCK)
		JOIN APP_BackupSetName B ON (DS.PropertyId = @l_backupsetguidPropId and CAST( B.GUID AS nvarchar(36)) = DS.PropertyValue)
									OR ( dbo.isBackupSetGuidExists(DS.DataSourceId,CAST( B.GUID AS VARCHAR(36))) = 1)
		JOIN #tempCloudSearchBkpSetInfo T ON B.id = T.BackupSetId
		--caseManager <-> datasource association is set as BackupSetPropetry in APP_BackupSetProp table
		INSERT INTO #tempCloudSearchDataSourceInfo
		SELECT CAST(attrVal AS INT) from APP_BackupSetProp
		WHERE componentNameId in ( select BackupsetId from #tempCloudSearchBkpSetInfo )
		AND attrName='Indexing datasource id'
		--we dont want metaInfo collection for searches.. so removing them
		DELETE FROM #tempCloudSearchDataSourceInfo
		WHERE DataSourceId in ( select DataSourceId from SEDataSourceProperty where PropertyId=@l_subSourceTypePropId AND PropertyValue='metainfo')
		INSERT INTO #getCollectionInfoOutTbl
		SELECT S.DataSourceId, SC.CloudID, SC.ActualCoreName,
		SourceType = (SELECT DSP.PropertyValue FROM SEDataSourceProperty AS DSP WHERE dsp.DataSourceId = S.DataSourceId AND DSP.PropertyId = @l_sourceTypePropId),
		SubSourceType = (SELECT DSP.PropertyValue FROM SEDataSourceProperty AS DSP WHERE dsp.DataSourceId = S.DataSourceId AND DSP.PropertyId = @l_subSourceTypePropId),
		SC.ClientId
		FROM SEDataSource S
		INNER JOIN SECollectionInfo SC on SC.CoreId = S.CoreId
		WHERE S.DataSourceId in ( Select  distinct DataSourceId from #tempCloudSearchDataSourceInfo ) AND SC.CloudID=@i_cloudId
		IF OBJECT_ID('tempdb.dbo.#tempCloudSearchUserGuids') IS NOT NULL
			DROP TABLE #tempCloudSearchUserGuids
		IF OBJECT_ID('tempdb.dbo.#tempCloudSearchBkpSetInfo') IS NOT NULL
			DROP TABLE #tempCloudSearchBkpSetInfo
		IF OBJECT_ID('tempdb.dbo.#tempCloudSearchDataSourceInfo') IS NOT NULL
			DROP TABLE #tempCloudSearchDataSourceInfo
	END
	ELSE
	BEGIN
		exec AppGetCloudCollectionInfo @i_cloudId, @i_sourceType, @i_shouldSelectOutput=0
	END
ERROR_EXIT:
	select * from #getCollectionInfoOutTbl
	IF OBJECT_ID('tempdb.dbo.#getCollectionInfoOutTbl') IS NOT NULL
			DROP TABLE #getCollectionInfoOutTbl
END

IF EXISTS (select * from GxQscripts where name = 'APPGetCloudCollectionsForSearch')
	delete from GxQscripts where name = 'APPGetCloudCollectionsForSearch'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetCloudCollectionsForSearch')
	delete from GXDBVersions where aliasname = 'APPGetCloudCollectionsForSearch'
GO

insert into GXDBVersions values(2, 'APPGetCloudCollectionsForSearch',  '00010001000200030000', 'APPGetCloudCollectionsForSearch', '00010001000200030000')
GO

