

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetClientPropsFromGUID.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGetClientPropsFromGUID')
BEGIN
	print '>>> Drop Stored Procedure: APPGetClientPropsFromGUID <<<'
	drop procedure APPGetClientPropsFromGUID
END
IF EXISTS (select * from GxQscripts where name='APPGetClientPropsFromGUID')
	delete from GxQscripts where name = 'APPGetClientPropsFromGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientPropsFromGUID')
	delete from GXDBVersions where aliasname = 'APPGetClientPropsFromGUID'
GO
print '... Creating Procedure: APPGetClientPropsFromGUID'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGetClientPropsFromGUID
  @xmlText XML
AS
DECLARE @clientGUID		varchar(1024)
DECLARE @appGUID		varchar(1024)
DECLARE @backupsetGUID	varchar(1024)
DECLARE @clientId		INT
DECLARE @outXML XML
SET @clientGUID		=  ISNULL((SELECT  ref.value('@clientGuid', 'varchar(1024)') AS clientGuid
					FROM    @xmlText.nodes('Indexing_GetClientPropsFromGUIDRequest') R ( ref )),'')
IF @clientGUID=''
BEGIN
	SET @appGUID		=  ISNULL((SELECT  ref.value('@appGuid', 'varchar(1024)') AS appGuid
						FROM    @xmlText.nodes('Indexing_GetClientPropsFromGUIDRequest') R ( ref )),'')
	IF @appGUID=''
	BEGIN
		SET @backupsetGUID		=  ISNULL((SELECT  ref.value('@backupsetGuid', 'varchar(1024)') AS backupsetGuid
								FROM    @xmlText.nodes('Indexing_GetClientPropsFromGUIDRequest') R ( ref )),'')
		IF @backupsetGUID=''
		BEGIN
			SET @clientId=0
		END
		ELSE
		BEGIN
			select @clientId=app.clientId from app_application app WITH(NOLOCK)
			join App_BackupsetName bsName WITH(NOLOCK) ON app.Backupset = bsName.id
			where bsName.guid=@backupsetGuid
		END
	END
	ELSE
	BEGIN
		select @clientId=clientId from app_application WITH(NOLOCK) where guid=@appGUID
	END
END
ELSE
BEGIN
	select @clientId=id from APP_CLIENT WITH(NOLOCK) where guid=@clientGUID
END
SET @outXML =	(SELECT id as '@clientId',
						origCCId as '@origCommCellId',
						simOperatingSystemId as '@osType',
						name as '@clientName'
						FROM App_Client(NOLOCK)
						WHERE id=@clientId
						FOR XML PATH('Indexing_GetClientEntityFromGUIDResp'))
IF @outXML IS NULL
	SET @outXML = '<Indexing_GetClientPropsFromGUIDResponse/>'
SELECT @outXML
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetClientPropsFromGUID')
	delete from GxQscripts where name = 'APPGetClientPropsFromGUID'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientPropsFromGUID')
	delete from GXDBVersions where aliasname = 'APPGetClientPropsFromGUID'
GO

insert into GXDBVersions values(2, 'APPGetClientPropsFromGUID',  '00000000000000000000', 'APPGetClientPropsFromGUID', '00000000000000000000')
GO

