

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetClientHierarchy.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetClientHierarchy.sp,v $ $Id: APPGetClientHierarchy.sp,v 1.1.2.24 2020/07/31 17:29:06 vthakur Exp $";
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetClientHierarchy')
BEGIN
	print '>>> Drop Stored Procedure: APPGetClientHierarchy <<<'
	drop procedure APPGetClientHierarchy
END
IF EXISTS (select * from GxQscripts where name='APPGetClientHierarchy')
	delete from GxQscripts where name = 'APPGetClientHierarchy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientHierarchy')
	delete from GXDBVersions where aliasname = 'APPGetClientHierarchy'
GO
print '... Creating Procedure: APPGetClientHierarchy'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetClientHierarchy
  @xmlText XML OUTPUT
AS
	DECLARE @localeId INT = 0
	DECLARE @errorCode INT = 0
	DECLARE @errorMessage VARCHAR(255) = 'Success'
    DECLARE @userId INT = 0
DECLARE @subclientStatus INT = CAST(0x100000 AS INT)|CAST(0x0800 AS INT)|CAST(0x00008 AS INT) |CAST(0x400000 AS INT) |CAST(0x40000 AS INT)
DECLARE @filterSubclient INT = CAST(0x0200 AS INT)
DECLARE @clientName NVARCHAR(1024) = ''
	DECLARE @clientId INT = 0
	DECLARE @withBackup INT = 0
	DECLARE @forBackup INT = 0
	DECLARE @appTypeId INT = 0
DECLARE @appTypeName NVARCHAR(1024) = ''
	DECLARE @hasAdminAssocAtCSLevel	INT = 0
	DECLARE @excludeEntity INT
	DECLARE @getDeleted  INT
	DECLARE @getDeconfigured INT
	DECLARE @isArchiverClient INT = 0
DECLARE @_EV_SCHEDULE_ADMIN			INT = POWER(2, 1-1)
DECLARE @_EV_MANAGE_APPLICATION		INT = POWER(2, 2-1)
DECLARE @_EV_SCHEDULE_APPLICATION	INT = POWER(2, 3-1)
DECLARE @_EV_MANAGE_ARCHIVES		INT = POWER(2, 4-1)
DECLARE @_EV_BACKUP					INT = POWER(2, 12-1)
DECLARE @_EV_BROWSE					INT = POWER(2, 13-1)
DECLARE @_EV_RESTORE_IN_PLACE		INT = POWER(2, 20-1)
DECLARE @_EV_RESTORE_OUTOF_PLACE	INT = POWER(2, 22-1)
	SELECT @clientName = ISNULL(en.value('@clientName', 'NVARCHAR(MAX)'), ''), @clientId = ISNULL(en.value('@clientId', 'INT'), 0), @withBackup = ISNULL(ref.value('@withBackup', 'INT'), 0),
			@appTypeName = ISNULL(en.value('@appName', 'NVARCHAR(MAX)'), ''), @appTypeId = ISNULL(en.value('@applicationId', 'INT'), 0), @forBackup = ISNULL(ref.value('@forBackup', 'INT'), 0),
			@excludeEntity = ISNULL(en.value('(flags/@exclude)[1]', 'int'),1),
			@getDeleted = ISNULL(en.value('(flags/@deleted)[1]', 'int'),@withBackup),
			@getDeconfigured = ISNULL(en.value('(flags/@disabled)[1]', 'int'), @withBackup),
			@isArchiverClient = ISNULL(ref.value('@isArchiverClient', 'INT'), 0)
			FROM @xmlText.nodes('App_GetEntityHierarchyRequest') R (ref)
			CROSS APPLY ref.nodes('./association/entity') E (en)
	SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'INT')
			FROM    @xmlText.nodes('App_GetEntityHierarchyRequest/processinginstructioninfo/locale') R ( ref )), @localeId)
	SET @userId = ISNULL((SELECT  ref.value('@userId', 'INT')
			FROM    @xmlText.nodes('App_GetEntityHierarchyRequest/processinginstructioninfo/user') R ( ref )), @userId)
	IF @clientId = 0
		SELECT @clientId = id FROM App_Client (NOLOCK) WHERE name = @clientName
	IF @clientId = 0
		SELECT @clientId = id FROM App_Client (NOLOCK) WHERE displayName = @clientName
	IF @clientId = 0 OR NOT EXISTS (SELECT id FROM App_Client (NOLOCK) WHERE id = @clientId)
	BEGIN
SET @errorCode = (1862 | (CAST(POWER(2, 24) AS BIGINT) * 35))
		IF @clientName <> ''
			SET @errorMessage = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = @errorCode AND [localeId] = @localeId)
		ELSE
			SET @errorMessage = 'Invalid client ID [' + CAST(@clientId AS VARCHAR(MAX)) +']'
		SET @xmlText =
					(SELECT
						(SELECT
							@errorCode AS '@errorCode',
							@errorMessage AS '@errorMessage'
						FOR XML PATH('error'), TYPE)
					FOR XML PATH(''), ROOT('App_GetEntityHierarchyResponse'))
		GOTO EXIT_PROC
	END
	IF @appTypeId = 0
		SELECT @appTypeId = type FROM APP_iDAType WITH (NOLOCK) WHERE displayName = @appTypeName AND @appTypeName <> ''
	IF object_id('tempdb.dbo.#entitiesWithCapability') is not null
		DROP TABLE #entitiesWithCapability
	IF OBJECT_ID('tempdb.dbo.#EntityHierarchy') IS NOT NULL
		DROP TABLE #EntityHierarchy
	CREATE TABLE #EntityHierarchy (
		subclientId             INT PRIMARY KEY,
subclientName           NVARCHAR(256),
		clientId                INT,
clientName              NVARCHAR(256),
		appTypeId				INT,
appName                 NVARCHAR(256),
		instanceId              INT,
instanceName            NVARCHAR(1024),
		backupsetId             INT,
backupsetName           NVARCHAR(256),
		subclientStatus			INT
	)
	IF OBJECT_ID('tempdb.dbo.#tempEntityHierarchy') IS NOT NULL
		DROP TABLE #tempEntityHierarchy
	CREATE TABLE #tempEntityHierarchy (
		subclientId             INT PRIMARY KEY,
subclientName           NVARCHAR(256),
		clientId                INT,
		appTypeId				INT,
		instanceId              INT,
		backupsetId             INT,
		subclientStatus			INT
	)
	IF OBJECT_ID('tempdb.dbo.#onePassAndArchiveSubclients') IS NOT NULL
		DROP TABLE #onePassAndArchiveSubclients
	CREATE TABLE #onePassAndArchiveSubclients (
            subclientId INT PRIMARY KEY
		)
create table  #entitiesWithCapability ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	EXEC sec_getUserObjects @userId, 0, 0, '#entitiesWithCapability'
	IF EXISTS(SELECT 1 FROM #entitiesWithCapability  sec
		WHERE (sec.capabilities&@_EV_MANAGE_APPLICATION <> 0) AND
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
	) -- USER HAS ASSOCIATION AT CC LEVEL
		SET @hasAdminAssocAtCSLevel = 1
		INSERT INTO #onePassAndArchiveSubclients
		SELECT APP.id							-- selecting archive subclients.
            FROM APP_Application APP WITH(NOLOCK)
                INNER JOIN APP_BackupsetProp BP WITH (NOLOCK)
                    ON BP.componentNameId = APP.backupset
AND BP.attrName = N'Is Archiving Enabled'
                    AND BP.attrVal = '1'
                    AND BP.modified = 0
			WHERE APP.clientId = @clientId
	IF @isArchiverClient = 1
	BEGIN
        INSERT INTO #onePassAndArchiveSubclients
            SELECT APP.id 						-- selecting onepass subclients.
            FROM APP_Application APP WITH(NOLOCK)
                INNER JOIN APP_SubclientProp SP (NOLOCK)
                    ON APP.id = SP.componentNameId
AND SP.attrName = N'Turbo Mode Enable Stubbing'
AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
                    AND SP.attrVal = '1'
                    AND SP.modified = 0
			LEFT JOIN #onePassAndArchiveSubclients ArchSC
				ON APP.id = ArchSC.subclientId
				WHERE APP.clientId = @clientId AND ArchSC.subclientId IS NULL
            UNION
            SELECT  APP.id 							-- selecting subclients which are associated with subclient policy with archiving rules enabled.
            FROM APP_Application APP WITH(NOLOCK)
                INNER JOIN APP_SubclientProp SCP_ASP WITH (NOLOCK)
                    ON APP.id = SCP_ASP.componentNameId
AND SCP_ASP.attrName = N'Associated subclient Policy'
AND SCP_ASP.cs_attrName = CHECKSUM(N'Associated subclient Policy')
                    AND SCP_ASP.attrVal <> '0'
                    AND SCP_ASP.modified = 0
                INNER JOIN APP_SubclientProp SP WITH (NOLOCK)
                    ON CAST(SCP_ASP.attrVal AS INT) = SP.componentNameId
AND SP.attrName = N'Turbo Mode Enable Stubbing'
AND SP.cs_attrName = CHECKSUM(N'Turbo Mode Enable Stubbing')
                    AND SP.attrVal = '1'
                    AND SP.modified = 0
			LEFT JOIN #onePassAndArchiveSubclients ArchSC
				ON APP.id = ArchSC.subclientId
            WHERE APP.clientId = @clientId AND ArchSC.subclientId IS NULL
	END
	IF @withBackup = 1
	BEGIN
SET @subclientStatus = @subclientStatus | 0x00002 | 0x00004
		INSERT INTO #tempEntityHierarchy
		(subclientId, subclientName, appTypeId, instanceId, backupsetId, subclientStatus)
		SELECT Q.id, Q.subclientName, Q.appTypeId, Q.instance, Q.backupSet, Q.subclientStatus
		FROM
		(
			SELECT subclient.id, subclient.subclientName, subclient.appTypeId, subclient.instance, subclient.backupSet, subclient.subclientStatus
			FROM APP_Application subclient WITH(NOLOCK) WHERE subclient.clientId = @clientId AND subclient.subclientStatus = 0
			UNION
			SELECT subclient.id, subclient.subclientName, subclient.appTypeId, subclient.instance, subclient.backupSet, subclient.subclientStatus
			FROM APP_Application subclient WITH(NOLOCK) WHERE subclient.clientId = @clientId AND subclient.subclientStatus&@subclientStatus <> 0
			AND subclient.subclientStatus & @filterSubclient = 0
AND NOT ((subclient.subclientStatus & 0x00010) <> 0 and @excludeEntity = 1) --CV_STATUS_DUMMY
AND NOT ((subclient.subclientStatus & 0x00020) <> 0 and @excludeEntity = 1) --CV_STATUS_HIDDEN
AND NOT ((subclient.subclientStatus & 0x00002)<> 0 and @getDeconfigured = 0)  --CV_STATUS_UNINSTALLED
AND NOT ((subclient.subclientStatus & 0x00004)<> 0 and @getDeleted = 0)  --CV_STATUS_DELETED
		) Q
		INSERT INTO #EntityHierarchy
		(subclientId, subclientName, clientId, clientName, appTypeId, appName, instanceId, instanceName, backupsetId, backupsetName, subclientStatus)
		SELECT DISTINCT T.subclientId, T.subclientName, T.clientId, T.name, agent.type, agent.name, instance.id, instance.name, T.backupsetId, T.backupsetName, T.subclientStatus
		FROM
		(
			SELECT Q.subclientId, Q.subclientName, Q.appTypeId, Q.instanceId, @clientId clientId, client.name, Q.subclientStatus, backupset.id backupsetId, backupset.name backupsetName
			FROM #tempEntityHierarchy Q
			JOIN APP_Client client (NOLOCK) ON client.id = @clientId
			JOIN APP_BackupSetName backupset (NOLOCK) ON backupset.id = Q.backupsetId
				AND
				(
					Q.appTypeId = @appTypeId
					OR
					@appTypeId = 0
				)
AND (backupset.status & 0x00010) <> 0x00010
			WHERE
			(
Q.appTypeId = 78
				AND
				(
backupset.status&0x80000=0x80000	--CV_STATUS_SP_OFFICE365_BSET
					OR
backupset.status&0x0800=0x0800	--CV_STATUS_SPDB_BSET
				)
			)
			OR
Q.appTypeId <> 78
		) T
		JOIN JMBkpStats bkp (NOLOCK) ON bkp.appId = T.subclientId AND bkp.status in (1, 3, 14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
        JOIN #entitiesWithCapability sec ON (
            (
                (capabilities&@_EV_RESTORE_IN_PLACE) <> 0 OR (capabilities&@_EV_RESTORE_OUTOF_PLACE) <> 0
            )
			AND
			(
				 --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
			    (
				    T.clientId = sec.clientId AND T.clientId <> 0
				    AND (T.appTypeId     = sec.appTypeId   OR (sec.appTypeId = 0 AND sec.clientId <> 0))
				    AND (T.instanceId    = sec.instanceId  OR (sec.instanceId = 0 AND sec.clientId <> 0))
				    AND (T.backupsetId   = sec.backupSetId OR (sec.backupSetId = 0 AND sec.clientId <> 0))
				    AND (T.subclientId   = sec.subClientId OR (sec.subClientId = 0 AND sec.clientId <> 0))
			    )
			    OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
			    (
                    @hasAdminAssocAtCSLevel = 1
			    )
			)
        )
		JOIN APP_iDAType agent (NOLOCK) ON T.appTypeId = agent.type
		JOIN APP_InstanceName instance (NOLOCK) ON T.instanceId = instance.id
		LEFT JOIN #onePassAndArchiveSubclients ArchSC ON T.subclientId = ArchSC.subclientId
		--JOIN APP_BackupSetName backupset (NOLOCK) ON T.backupSet = backupset.id
WHERE (T.appTypeId NOT IN (1000, 1030))
					AND (
							(@isArchiverClient = 1 AND ArchSC.subclientId IS NOT NULL)
										OR
							(@isArchiverClient = 0 AND ArchSC.subclientId IS NULL)
						)
	END
	ELSE
	BEGIN
		INSERT INTO #tempEntityHierarchy
		(subclientId, subclientName, appTypeId, instanceId, backupsetId, subclientStatus)
		SELECT Q.id, Q.subclientName, Q.appTypeId, Q.instance, Q.backupSet, Q.subclientStatus
		FROM
		(
			SELECT subclient.id, subclient.subclientName, subclient.appTypeId, subclient.instance, subclient.backupSet, subclient.subclientStatus
			FROM APP_Application subclient WITH(NOLOCK) WHERE subclient.clientId = @clientId AND subclient.subclientStatus = 0
			UNION
			SELECT subclient.id, subclient.subclientName, subclient.appTypeId, subclient.instance, subclient.backupSet, subclient.subclientStatus
			FROM APP_Application subclient WITH(NOLOCK) WHERE subclient.clientId = @clientId AND subclient.subclientStatus&@subclientStatus <> 0
			AND subclient.subclientStatus & @filterSubclient = 0
AND NOT ((subclient.subclientStatus & 0x00010) <> 0 and @excludeEntity = 1) --CV_STATUS_DUMMY
AND NOT ((subclient.subclientStatus & 0x00020) <> 0 and @excludeEntity = 1) --CV_STATUS_HIDDEN
AND NOT ((subclient.subclientStatus & 0x00002)<> 0 and @getDeconfigured = 0)  --CV_STATUS_UNINSTALLED
AND NOT ((subclient.subclientStatus & 0x00004)<> 0 and @getDeleted = 0)  --CV_STATUS_DELETED
		) Q
		INSERT INTO #EntityHierarchy
		(subclientId, subclientName, clientId, clientName, appTypeId, appName, instanceId, instanceName, backupsetId, backupsetName, subclientStatus)
		SELECT DISTINCT T.subclientId, T.subclientName, T.clientId, T.name, agent.type, agent.name, instance.id, instance.name, T.backupsetId, T.backupsetName, T.subclientStatus
		FROM
		(
			SELECT Q.subclientId, Q.subclientName, Q.appTypeId, Q.instanceId, @clientId clientId, client.name, Q.subclientStatus, backupset.id backupsetId, backupset.name backupsetName
			FROM #tempEntityHierarchy Q
			JOIN APP_Client client (NOLOCK) ON client.id = @clientId
			JOIN APP_BackupSetName backupset (NOLOCK) ON backupset.id = Q.backupsetId
				AND
				(
					Q.appTypeId = @appTypeId
					OR
					@appTypeId = 0
				)
AND (backupset.status & 0x00010) <> 0x00010
			WHERE
			(
Q.appTypeId = 78
				AND
				(
backupset.status&0x80000=0x80000	--CV_STATUS_SP_OFFICE365_BSET
					OR
backupset.status&0x0800=0x0800	--CV_STATUS_SPDB_BSET
				)
			)
			OR
Q.appTypeId <> 78
        ) T
        JOIN #entitiesWithCapability sec ON (
            (
                (@forBackup = 0 AND (capabilities&@_EV_MANAGE_APPLICATION) <> 0)
				OR
				(@forBackup = 1 AND (capabilities&@_EV_BACKUP) <> 0)
            )
			AND
			(
				 --CHECK USER HAVING ASSOCIATION FOR THE ENTITY
			    (
				    T.clientId = sec.clientId AND T.clientId <> 0
				    AND (T.appTypeId     = sec.appTypeId   OR (sec.appTypeId = 0 AND sec.clientId <> 0))
				    AND (T.instanceId    = sec.instanceId  OR (sec.instanceId = 0 AND sec.clientId <> 0))
				    AND (T.backupsetId   = sec.backupSetId OR (sec.backupSetId = 0 AND sec.clientId <> 0))
				    AND (T.subclientId   = sec.subClientId OR (sec.subClientId = 0 AND sec.clientId <> 0))
			    )
			    OR --CHECK FOR USER HAVING ASSOCIATION AT CC LEVEL
			    (
                    @hasAdminAssocAtCSLevel = 1
			    )
			)
        )
		JOIN APP_iDAType agent (NOLOCK) ON T.appTypeId = agent.type
		JOIN APP_InstanceName instance (NOLOCK) ON T.instanceId = instance.id
		LEFT JOIN #onePassAndArchiveSubclients ArchSC ON T.subclientId = ArchSC.subclientId
		--JOIN APP_BackupSetName backupset (NOLOCK) ON T.backupsetId = backupset.id
WHERE (T.appTypeId NOT IN (1000, 1030))
				AND (
							(@isArchiverClient = 1 AND ArchSC.subclientId IS NOT NULL)
										OR
							(@isArchiverClient = 0 AND ArchSC.subclientId IS NULL)
						)
	END
	--Remove DDB Backup subclient, Index Backup subclient
	DELETE #EntityHierarchy
	FROM
	(
		SELECT componentNameId
		FROM APP_SubClientProp (NOLOCK) P
		JOIN #EntityHierarchy E ON E.subclientId = P.componentNameId
		WHERE (attrName IN ('DDB Backup', 'Index SubClient') AND attrVal = '1' AND modified = 0)
	) T
	WHERE T.componentNameId = subclientId
	SET @xmlText =
			(SELECT
				(SELECT	subclientId AS '@subclientId',
						subclientName AS '@subclientName',
						clientId AS '@clientId',
						clientName	AS '@clientName',
						appTypeId AS '@applicationId',
						appName AS '@appName',
						instanceId AS '@instanceId',
						CASE CHARINDEX('', instanceName)
							WHEN 0 THEN	instanceName
							ELSE
								'|'+REPLACE(instanceName,
								'', '|#12!')
							END '@instanceName',
						backupsetId AS '@backupsetId',
						backupsetName AS '@backupsetName'
						FOR XML PATH('entity'), TYPE)
				FROM #EntityHierarchy
				FOR XML PATH(''), ROOT('App_GetEntityHierarchyResponse')
			)
EXIT_PROC:
	IF @xmlText IS NULL
		SET @xmlText = '<App_GetEntityHierarchyResponse/>'
	--SELECT @xmlText
	IF object_id('tempdb.dbo.#entitiesWithCapability') is not null
		DROP TABLE #entitiesWithCapability
    IF OBJECT_ID('tempdb.dbo.#EntityHierarchy') IS NOT NULL
        DROP TABLE #EntityHierarchy
	IF OBJECT_ID('tempdb.dbo.#tempEntityHierarchy') IS NOT NULL
		DROP TABLE #tempEntityHierarchy
	IF OBJECT_ID('tempdb.dbo.#onePassAndArchiveSubclients') IS NOT NULL
        DROP TABLE #onePassAndArchiveSubclients
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetClientHierarchy')
	delete from GxQscripts where name = 'APPGetClientHierarchy'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientHierarchy')
	delete from GXDBVersions where aliasname = 'APPGetClientHierarchy'
GO

insert into GXDBVersions values(2, 'APPGetClientHierarchy',  '00010001000200240000', 'APPGetClientHierarchy', '00010001000200240000')
GO

