

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetClientFromInstance.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetClientFromInstance <<<'

IF EXISTS (select * from sysobjects where name='APPGetClientFromInstance')
	drop procedure APPGetClientFromInstance
IF EXISTS (select * from GxQscripts where name='APPGetClientFromInstance')
	delete from GxQscripts where name = 'APPGetClientFromInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientFromInstance')
	delete from GXDBVersions where aliasname = 'APPGetClientFromInstance'
GO
print '... Creating Procedure: APPGetClientFromInstance'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetClientFromInstance
  @inputxml XML
AS
DECLARE @instanceName		varchar(1024)
DECLARE @instanceId AS INT
-- Output xml string.
DECLARE @rv				XML
-- Error handlers.
DECLARE @errorCode      INT = 0
DECLARE @errorString    NVARCHAR(1024) = N''
SET @instanceName		=  ISNULL((SELECT  ref.value('@instanceName', 'varchar(1024)')
							FROM    @inputxml.nodes('App_GetClientFromInstanceReq/instance') R ( ref )),'')
SET @instanceName = ( select dbo.DecodeInvalidXMLChar(@instanceName) )
SET @instanceId		    =  ISNULL((SELECT  ref.value('@instanceId', 'int')
							FROM    @inputxml.nodes('App_GetClientFromInstanceReq/instance') R ( ref )), 0)
IF (@instanceId = 0)
BEGIN
	SET @instanceId = ISNULL((SELECT TOP 1 id FROM APP_InstanceName WHERE name = @instanceName), 0)
END
IF (@instanceId = 0)
BEGIN
	SET @errorCode = 1
	SET @errorString = 'Instance not found'
    GOTO ERROR_EXIT
END
SET @rv		=	(SELECT DISTINCT
						App_Client.id as '@clientId',
						App_Client.name as '@clientName'
						FROM App_Client WITH (NOLOCK)
						INNER JOIN APP_Application WITH (NOLOCK)
						ON APP_Application.clientId = App_Client.id
						AND APP_Application.instance = @instanceId
						FOR XML PATH('client'), ROOT('App_GetClientFromInstanceResp'))
ERROR_EXIT:
        IF @errorCode <> 0
            SET @rv = (SELECT @errorCode AS '@errorCode', @errorString AS '@errorMessage'
                                FOR XML PATH('genericResp'),Root('App_GetClientFromInstanceResp'), Type)
IF @rv IS NULL
	SET @rv = '<App_GetClientFromInstanceResp/>'
SELECT @rv
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetClientFromInstance')
	delete from GxQscripts where name = 'APPGetClientFromInstance'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientFromInstance')
	delete from GXDBVersions where aliasname = 'APPGetClientFromInstance'
GO

insert into GXDBVersions values(2, 'APPGetClientFromInstance',  '00000000000000000000', 'APPGetClientFromInstance', '00000000000000000000')
GO

