

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetClientCertificates.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetClientCertificates.sp,v $ $Id: APPGetClientCertificates.sp,v 1.9.186.5 2018/09/18 18:18:15 vthakur Exp $";
-- =============================================
-- Author:		Sergio Bonilla
-- Create date: 04/30/2012
-- Description:	Get all client certificates
-- =============================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetClientCertificates <<<'

IF EXISTS (select * from sysobjects where name='APPGetClientCertificates')
	drop procedure APPGetClientCertificates
IF EXISTS (select * from GxQscripts where name='APPGetClientCertificates')
	delete from GxQscripts where name = 'APPGetClientCertificates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientCertificates')
	delete from GXDBVersions where aliasname = 'APPGetClientCertificates'
GO
print '... Creating Procedure: APPGetClientCertificates'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetClientCertificates
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @xmlText XML
AS
BEGIN
SET NOCOUNT ON
DECLARE @clientRotation INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WHERE name = 'ClientCertRotationPeriodMonths' AND modified = 0), 6)
DECLARE @CARotation INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WHERE name = 'CACertRotationPeriodYears' AND modified = 0), 5)
DECLARE @allowBuiltInCertificates INT = ISNULL((SELECT CAST(value AS INT) FROM GXGlobalParam WHERE name = 'CSAllowBuiltInCerts' AND modified = 0), 1)
DECLARE @sendLatestForClient INT = ISNULL (( SELECT ref.value('@sendLatestForClient', 'INT')
								FROM @xmlText.nodes ('GuiServer_CertificateReq') R(ref)), 0)
DECLARE @userId INT = ISNULL (( SELECT ref.value('@userId', 'INT')
								FROM @xmlText.nodes ('GuiServer_CertificateReq/processinginstructioninfo/user') R(ref)), 0)
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	IF object_id('tempdb.dbo.#clientCertTable') IS NOT Null
		DROP TABLE #clientCertTable
	CREATE TABLE #clientCertTable (authority INT, certId INT, clientId INT, created INT, expiration INT, status INT, name NVARCHAR(1024), id INT)
	CREATE UNIQUE INDEX tempclientCertTable_certId_clientId_Idx ON #clientCertTable (certId, clientId)
	IF object_id('tempdb.dbo.#tempCertificateSecurityObjects') IS NOT Null
		DROP TABLE #tempCertificateSecurityObjects
create table  #tempCertificateSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
	CREATE INDEX tempCertificateSecurityObjects_clientId_Idx on #tempCertificateSecurityObjects (clientId)
	EXEC sec_getUserObjects @userId, 2009, 0, '#tempCertificateSecurityObjects'
	INSERT INTO #clientCertTable
	SELECT DISTINCT CCER.authority, CCER.certId, CCER.clientId, CCER.created, CCER.expiration, CCER.status, CCER.name, CCER.id
	FROM (
		SELECT CER.authority, CER.certId, CER.clientId, CER.created, CER.expiration, CER.status, C.name, C.id
		FROM App_ClientCerts CER WITH (NOLOCK)
		LEFT OUTER JOIN APP_Client C WITH (NOLOCK) ON C.id=CER.clientId
		JOIN
		(
			SELECT CER.clientId, MAX(CER.expiration) AS expiration
			FROM App_ClientCerts CER WITH (NOLOCK)
			WHERE CER.status = 2
			GROUP BY CER.clientId
			UNION
			SELECT CER.clientId, MAX(CER.expiration) AS expiration
			FROM App_ClientCerts CER WITH (NOLOCK)
			JOIN APP_Client C WITH (NOLOCK) ON C.id=CER.clientId
			WHERE NOT EXISTS (SELECT 1 FROM App_ClientCerts CC WHERE CC.clientId=CER.clientId AND CC.status=2)
			GROUP BY CER.clientId
		) ACT ON ACT.clientId = CER.clientId AND (@sendLatestForClient = 0 OR ACT.expiration = CER.expiration)
	) CCER
	WHERE CCER.status < 9
	SET @xmlText = (
		SELECT @clientRotation '@ClientCertificateRotation', @CARotation '@CACertificateRotation',
			CASE @allowBuiltInCertificates WHEN 0 THEN 1
			ELSE 0
			END '@forceClientAuth',
			(SELECT RSP.certId '@id', RSP.authority '@authority', RSP.status '@status',
				( SELECT RSP.created as '@time', 56 '@_type_'
					FOR XML PATH('created'), TYPE),
				( SELECT RSP.expiration as '@time', 56 '@_type_'
					FOR XML PATH('expiration'), TYPE),
				(SELECT RSP.clientId '@clientId', RSP.name '@clientName', 3 '@_type_', ISNULL((client.displayName),'') '@displayName'
					FOR XML PATH ('client'), TYPE)/*,
				(SELECT CA.id '@id', CA.certKey '@key', CA.certKey '@certificate'
					FROM App_CACerts CA
					WHERE certId=CA.certId
					FOR XML PATH ('certificates'), TYPE)*/
					FROM (
						SELECT DISTINCT CCER.authority, CCER.certId, CCER.clientId, CCER.created, CCER.expiration, CCER.status, CCER.name, CCER.id
						FROM #clientCertTable CCER
						JOIN #tempCertificateSecurityObjects sec ON
						((capabilities&2) <> 0) AND
						(
								sec.clientId=CCER.clientId
						)
					UNION
						SELECT DISTINCT CCER.authority, CCER.certId, CCER.clientId, CCER.created, CCER.expiration, CCER.status, CCER.name, CCER.id
						FROM #clientCertTable CCER
						JOIN APP_ClientGroupAssoc CG (NOLOCK) ON CG.clientId = CCER.clientId
						JOIN #tempCertificateSecurityObjects sec ON
						((capabilities&2) <> 0) AND
						(
							sec.clientGroupId = CG.clientGroupId
						)
						WHERE CCER.id IS NOT NULL OR CCER.clientId = 0 -- NEED THIS CHECK FOR CA CERTIFICATE WHICH HAS CLIENTID=0 BUT TO NOT INCLUDE ENTRIES NOT IN APP_CLIENT TABLE
					UNION
						SELECT DISTINCT CCER.authority, CCER.certId, CCER.clientId, CCER.created, CCER.expiration, CCER.status, CCER.name, CCER.id
						FROM #clientCertTable CCER
						JOIN #tempCertificateSecurityObjects sec ON
						((capabilities&2) <> 0) AND
						(
sec.commCellId=2 AND sec.clientGroupId=0 AND sec.clientId=0 AND sec.appTypeId=0 AND sec.instanceId=0 AND sec.backupsetId=0 AND sec.subClientId=0 AND sec.mediaAgentId=0 AND sec.libraryId=0 AND sec.archGroupId=0 AND sec.vtContainerId=0 AND sec.vtPolicyId=0 AND sec.vtShelfId=0 AND sec.reviewSetId=0 AND sec.querySetId=0 AND sec.downloadSetId=0 AND sec.ermId=0 AND sec.legalHoldId=0 AND sec.tagId=0 AND sec.cdPolicyId=0 AND sec.complianceReportId=0 AND sec.taskId=0 AND sec.workflowId=0 AND sec.logMonitoringPolicyId=0 AND sec.arrayId=0 AND sec.cloudId=0 AND sec.userGroupId=0 AND sec.providerId=0 AND sec.entityId1=0 AND sec.entityId2=0 AND sec.entityId3=0 AND sec.entityId4=0 AND sec.entityId5=0									AND sec.entityId6=0 AND sec.entityId7=0 AND sec.entityId8=0 AND sec.entityId9=0
						)
					) RSP
					LEFT OUTER JOIN APP_Client client WITH(NOLOCK) ON RSP.clientId = client.id
					ORDER BY RSP.certId
				FOR XML PATH('certificates'), TYPE)
		FOR XML PATH('certificateInfo'),
		ROOT('GuiServer_CertificateResp'))
	SELECT @xmlText
	IF object_id('tempdb.dbo.#clientCertTable') IS NOT Null
		DROP TABLE #clientCertTable
	IF object_id('tempdb.dbo.#tempCertificateSecurityObjects') IS NOT Null
		DROP TABLE #tempCertificateSecurityObjects
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetClientCertificates')
	delete from GxQscripts where name = 'APPGetClientCertificates'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetClientCertificates')
	delete from GXDBVersions where aliasname = 'APPGetClientCertificates'
GO

insert into GXDBVersions values(2, 'APPGetClientCertificates',  '00010009018600050000', 'APPGetClientCertificates', '00010009018600050000')
GO

