

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetCCServicesProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetCCServicesProperties.sp,v $ $Id: APPGetCCServicesProperties.sp,v 1.6.50.1 2018/03/27 08:47:19 jiechen Exp $";
--
--  +====================================================================================+
--  |   Procedure:  APPGetCCServicesProperties()
--  |
--  | Description:  SP for retrieving the Cloud Connector Entity(user/userGroup) service
--  |
--  |       Input:  XML input containing user id, localeid, List of input entities
--  |      Output:  XML Output containing user account properties for input entities
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  riyer  To allow both Web Console and Java GUI to use the same SP
--  +====================================================================================+
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetCCServicesProperties <<<'

IF EXISTS (select * from sysobjects where name='APPGetCCServicesProperties')
	drop procedure APPGetCCServicesProperties
IF EXISTS (select * from GxQscripts where name='APPGetCCServicesProperties')
	delete from GxQscripts where name = 'APPGetCCServicesProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetCCServicesProperties')
	delete from GXDBVersions where aliasname = 'APPGetCCServicesProperties'
GO
print '... Creating Procedure: APPGetCCServicesProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetCCServicesProperties
  @i_xml XML	
AS
declare @userId int
declare @localeId int
DECLARE @r_capabilityId int
DECLARE @errorCode INT
declare @errorString nvarchar(max)
DECLARE @r_error XML
DECLARE @r_allErrors XML
DECLARE @inputEntity XML
DECLARE @idoc int
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
SET @userId = ISNULL((SELECT  ref.value('@userId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_CCGetEntityInfoRequest/processinginstructioninfo/user') R ( ref )),1)
SET @localeId = ISNULL((SELECT  ref.value('@localeId', 'int') AS Agent
                         FROM    @i_xml.nodes('App_CCGetEntityInfoRequest/processinginstructioninfo/locale') R ( ref )),0)
SET @r_capabilityId = ISNULL((SELECT  ref.value('@capabilityFlags', 'int') AS Agent
                         FROM    @i_xml.nodes('App_CCGetEntityInfoRequest/filterOptions') R ( ref )),0)
if @r_capabilityId=6
begin
	set @r_capabilityId = 2
end
declare @CloudConnectorEntityList table
(
	userId int,
	userGroupId int
)
declare @inputUserId int
declare @inputUserGroupId int
declare @allUserAccounts xml
declare @currentUserAccount xml
declare @allUserAccountsnvarchar nvarchar(max)
declare @currentAccountsEnabled xml
declare @currentAccountsDisabled xml
DECLARE @entityInfo XML
declare @capabilityString nvarchar(max)
declare @userLogin nvarchar(max)
declare @excludeFlags int
declare @canSeeAllUsers int
declare @canSeeAllGroups int
declare @currentUserAccountsList xml
set @excludeFlags = convert(int,0x200)| convert(int,0x004) | convert(int,0x080)
set @allUserAccountsnvarchar = ''
Insert into @CloudConnectorEntityList(userId,userGroupId)
SELECT  IsNull(ref.value('@userId', 'int'),0) AS col1,
		IsNull(ref.value('@userGroupId', 'int'),0) AS col2
FROM    @i_xml.nodes('App_CCGetEntityInfoRequest/entities/entity') R ( ref )
--select * from @CloudConnectorEntityList
SET @errorCode = 0
SET @errorString = ''
-------------------------------------------------------------------------------------------------------------------
if (not exists(Select 1 from UMUsers where id = @userId))
begin
	set @errorCode = -1
	set @errorString = ( select message from EvLocaleMsgs Where messageId=(475 | (CAST(POWER(2, 24) AS BIGINT) * 35))  AND [localeId] = @localeId)
	set @errorString = REPLACE(@errorString, '^1%s', @userId)
	set @r_error = (select @errorCode as '@errorCode',@errorString as '@errorString'
					for xml path('errors'))
	set @r_allErrors = convert(nvarchar(max),@r_error)
	goto GENERATE_OUTPUT
end
---------------------------------------------------------------------------------------------------------------
set @userLogin = (select Login from UMUsers where id = @userId)
set @capabilityString = (select Message
						 from EvLocaleMsgs
						 where MessageId in (select tokenId from UMCapability where id = @r_capabilityId) and [localeId] = @localeId)
-------------------------------------------------------------------------------------------------------------------
SET @inputEntity =(	select @userId as '@userId',
							13 as '@_type_'
					for xml path('entity'))
-- Now figure out all types and return only those which are selected for each user/[user Group] contained in the request.
declare @servicesAvailable table
(
	enumVal int,
	isSelected int
)
declare @cnt int
set @cnt = 1
while (1>0)
begin
	if exists(select 1 from App_CCUserServices where ( (servicesSelected & @cnt)>0 ) )
	begin
		Insert into @servicesAvailable
		select @cnt,0
	end
	else
	begin
		-- This means there are no more services available in selected
		if (not exists(select 1 from App_CCUserServices where servicesSelected > @cnt))
		begin
			break
		end
	end
	set @cnt = @cnt * 2
end
--select enumVal as 'service', isSelected as 'isSelected'
--from  @servicesAvailable
-------------------------------------------------------------------------------------------------
declare @inputEntityList table
(
	entityType	int,
	entityId	int
)
set @canSeeAllUsers = 0
set @canSeeAllGroups = 0
DECLARE @canManageAllUsers int = 0
EXEC sec_canManageAllUsers @userId, @canManageAllUsers OUTPUT
DECLARE @IsHideEnabled int = 0
IF @canManageAllUsers = 0
	EXEC sec_isHideEnabled @userId, 0, @IsHideEnabled OUTPUT
IF @canManageAllUsers <> 0	or @IsHideEnabled = 0
begin
	set @canSeeAllUsers	= 1
	set @canSeeAllGroups = 1
end
-----------------------------------------------------------------------------------------------------
--Before fetching any info, remove all empty entries from entity Table (ie. where user AND userGroup are both invalid)
delete from @CloudConnectorEntityList
where (userId IS NULL OR userId = 0) AND (userGroupId IS NULL OR userGroupId = 0)
--DECLARE @serviceTblCursor CURSOR
DECLARE @entitycur CURSOR
set @entitycur = CURSOR
	FOR	SELECT DISTINCT userId,userGroupId
	 FROM @CloudConnectorEntityList
		OPEN @entitycur
			FETCH NEXT FROM @entitycur INTO @inputUserId,@inputUserGroupId
			WHILE @@FETCH_STATUS = 0
			BEGIN
				declare @inputUserLogin nvarchar(max)
				declare @inputGroupLogin nvarchar(max)
				declare @isPeerUser int
				set @errorCode = 0         --for each entity
				set @errorString = ''
				set @isPeerUser = 0
				if @r_capabilityId = 0
				begin
					if @inputUserId > 0
					begin
						set @inputUserLogin = (select Login from UMUsers where id = @inputUserId)
						exec dbo.sec_isPeerUser @userId , @inputUserId , @isPeerUser output
						if @canSeeAllUsers = 0 and @isPeerUser = 0
						begin
							set @errorCode = -1
							set @errorString = ( select message from EvLocaleMsgs Where messageId= (1938 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND	[localeId] = @localeId)
							SET @errorString = REPLACE(@errorString, '^1%s', @userLogin)
							SET @errorString = REPLACE(@errorString, '^2%s', @inputUserLogin)
							goto CONTINUE_TO_NEXT_ROW
						end
					end
					else if @inputUserGroupId > 0
					begin
						set @inputGroupLogin = (select name from UMGroups where id = @inputUserGroupId)
						if @canSeeAllGroups = 0 and
							not exists( select 1 from UMUserGroup where userId = @userId and groupId = @inputUserGroupId)
						begin
							set @errorCode = -1
							set @errorString = ( select message from EvLocaleMsgs Where messageId=(1937 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND	[localeId] = @localeId)
							SET @errorString = REPLACE(@errorString, '^1%s', @userLogin)
							SET @errorString = REPLACE(@errorString, '^2%s', @inputGroupLogin)
							goto CONTINUE_TO_NEXT_ROW
						end
					end
				end
				delete from @inputEntityList
				if (@inputUserId > 0)    --if user, then take all user groups associated
				begin
					insert into @inputEntityList
					select 15 , groupId
					from   UMUserGroup
					where  userId = @inputUserId
				end
				else if (@inputUserGroupId>0)	--if user group, then take them as such
				begin
					insert into @inputEntityList
					select 15 , @inputUserGroupId
				end
				declare @servicesSelected table
				(
					servicesSelected int
				)
				insert into @servicesSelected
				select 	CCUS.servicesSelected
				from 	App_CCUserServices CCUS inner join @inputEntityList inputList on CCUS.entityType = inputList.entityType
				where	CCUS.id = inputList.entityId
				-- Update this for every user
				update 	@servicesAvailable
				set 	isSelected = 0
				--update table for services enabled
				update 	@servicesAvailable
				set 	isSelected = 1
				from 	@servicesSelected SS
				where 	((enumVal & SS.servicesSelected) > 0)
				set @entityInfo 	= (	select
											--1. Current User Entity
											(select @inputUserGroupId 	as '@userGroupId',
							                     @userId 			as '@userId'
												for xml path('userEntity'), type),
											--2. Current Accounts enabled for Entity(user/[user group])
											 ( select enumVal as '@val'
												from @servicesAvailable
												where isSelected=1
												for xml path('accountsEnabled'), type),
												--3. Current User Account list
											  ( select accountType as '@providerId',
														 creationDate as '@creationDate',
														 lastBackup as '@lastBackup',
														 userAccount as '@email'
												from App_CCUserAccounts
												where userId=@inputUserId
												for xml path('userAccounts'), type)
										 for xml path('entityInfo'))
			CONTINUE_TO_NEXT_ROW:
							set @r_error = ( select @errorCode as '@errorCode',
													@errorString as '@errorString',
													@inputEntity
									    	for xml path('response'))
						set @r_allErrors = (select @r_allErrors , @r_error for xml path(''))
				FETCH NEXT FROM @entitycur INTO @inputUserId,@inputUserGroupId
			END
			DEALLOCATE @entitycur
GENERATE_OUTPUT:
	 set @r_allErrors = (select @r_allErrors for xml path('errors'))
	 set @allUserAccounts = ( select @r_allErrors,@entityInfo for xml path(''),root('App_CCGetEntityInfoResponse'))
	select @allUserAccounts o_xmlText
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetCCServicesProperties')
	delete from GxQscripts where name = 'APPGetCCServicesProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetCCServicesProperties')
	delete from GXDBVersions where aliasname = 'APPGetCCServicesProperties'
GO

insert into GXDBVersions values(2, 'APPGetCCServicesProperties',  '00010006005000010000', 'APPGetCCServicesProperties', '00010006005000010000')
GO

