

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetBackupSetProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetBackupSetProperties.sp,v $ $Id: APPGetBackupSetProperties.sp,v 1.33.2.75 2020/10/17 01:57:06 rchandora Exp $";
--
--  +========================================================================+
--  |   Procedure:  APPGetBackupSetProperties()
--  |
--  | Description:  SP for retreiving backupset properties for XML based framework
--  |
--  |       Input:  XML input containing user id, localeid, List of input entities
--  |      Output:  XML Output containing backupset properties for input entities
--  |      Return:  xxx
--  |
--  |   Revisions  Author   Description
--  |   ---------  -------  ---------------------------------------------
--  +========================================================================+
-- 4 backupset types for SharePoint -- corresponding to enum SharepointBackupSetType
-------------------------------------------------------------------------------
--   PARAMETERS   &   OUTPUTS
-------------------------------------------------------------------------------
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetBackupSetProperties')
BEGIN
	print '>>> Drop Stored Procedure: APPGetBackupSetProperties <<<'
	drop procedure APPGetBackupSetProperties
END
IF EXISTS (select * from GxQscripts where name='APPGetBackupSetProperties')
	delete from GxQscripts where name = 'APPGetBackupSetProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetBackupSetProperties')
	delete from GXDBVersions where aliasname = 'APPGetBackupSetProperties'
GO
print '... Creating Procedure: APPGetBackupSetProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetBackupSetProperties
  @i_xml XML	
AS
--use CommServ
DECLARE @userId INT
DECLARE @localeId INT
DECLARE @propertyLevel INT
DECLARE @clientId INT
DECLARE @instancetId INT
DECLARE @appTypeId INT
DECLARE @inBackupSetId INT
DECLARE @errorCode INT
DECLARE @errorString NVARCHAR(MAX)
DECLARE @xmlResultError XML
DECLARE @errorXML xml
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('tempdb.dbo.#bkpSecurityTbl') IS NOT NULL
	DROP TABLE #bkpSecurityTbl
CREATE TABLE #bkpSecurityTbl (
	id				INT IDENTITY(1,1),
	returnedUserId	INT,
	nodeCapability	BIGINT,
	childCapability	BIGINT)
CREATE UNIQUE CLUSTERED INDEX bkpSecurityTbl_idx ON #bkpSecurityTbl (id DESC)
IF OBJECT_ID('tempdb.dbo.#i_backupList') IS NOT NULL
	DROP TABLE #i_backupList
CREATE TABLE #i_backupList
(
	clientId				INT,
	clientName				NVARCHAR(510),
	clientDisplayName		NVARCHAR(510),
	appTypeId				INT,
	appTypeName				NVARCHAR(255),
	instanceId				INT,
	instanceName			NVARCHAR(255),
	backupsetId				INT,
	backupSetName			NVARCHAR(510),
	modifiedTime			INT,
	lastBackupTime             INT DEFAULT 0,
	applicationSize            BIGINT DEFAULT 0,
	totalBackupSize            BIGINT DEFAULT 0,
	sizeOnMedia		           BIGINT DEFAULT 0,
	firstBackupTime			INT DEFAULT 0,
	dedupeRatio				FLOAT DEFAULT 0,
	errorCode				INT DEFAULT 0,
	errorString				NVARCHAR(510) DEFAULT N'',
	bkpstatus				INT,
	backupsetType			VARCHAR(40),
	backupSetEntity 		XML,
	commonBackupSetProps	XML,
	fsBackupSetProps		XML,
	exchangeBackupSetProps	XML,
	sharePointBackupSetProps	XML,
	db2BackupSetProps		XML,
	cloudConnectorBackupSetProps	XML,
	cloudAppsBackupSetProps	XML,
	sapHANABackupsetProps	XML,
	ibmBackupSetProps		XML,
	backupsetSecurityOld	XML,
	backupsetSecurityNew	XML,
	--Common properties START
	userDescription NVARCHAR(MAX),
	onDemandBackupset INT,
	isDedupBackupset INT,
	cDRFSDMBackupset INT,
	isDefaultBackupSet INT,
	associatedsubclientPolicy INT,
	associatedsubclientPolicyName NVARCHAR(255),
	siloCopyId INT,
	isMyBackupSet INT,
	isDeleted INT,
	isNasTurboBackupSet INT,
	isFanInBackupSet INT,
	isHidden INT,
	isLegalHoldBackupset INT DEFAULT 0,
	isWildCardContentBackupSet INT,
	isMining INT,
	dataMigratorILMCLASS INT,
	isUSeDCForBackup INT,
	decompressData INT,
	useChangeJournal INT,
	SLAStatus INT DEFAULT 3, --Excluded by default. For new backupsets, the subclient in it may not have an entry in RptSlaSubclient table.
	--Common properties END
	--FS backupset START
	preserveFileAccessTimes INT DEFAULT 0,
	useDCserviceForScan INT DEFAULT 1,
	netAppImageBackup INT,
	useArchiveBit INT,
	pre70SystemStateArchiveFilesExist INT,
	fLRrepSetId INT,
	fLRrepSetName NVARCHAR(255),
	isIndexingv2 INT,
	isTrueUpOptionEnabledForOnePass INT,
	runTrueUpJobAfterDaysForOnePass INT,
	customApplicationType INT,
	isUseBlockLevelBackup INT,
	isAdAppAwareBackupSet INT,
	hasOneTouchSubclient INT,
	hasBackupSystemStateSubclient INT,
	hadoopAppType INT,
	--FS backupset END
	--Exchange backupset START
	activeDirectoryGroupAutoDiscover INT,
	activeDirectoryWildCardAutoDiscover INT,
	dCDBFileLocation NVARCHAR(MAX),
	exchangeEnableDiscovery INT,
	storageGroupAutoDiscover INT,
	exchangeOnePassBackupsetType NVARCHAR(255),
	--Exchange backupset END
	--Sharepoint backupset START
	v2Backupset INT,
	isEnableArchiving INT,
	isEnableTier1Archiving INT,
	spBackupsetType INT,
	azureUsername NVARCHAR(MAX),
	azurePassword NVARCHAR(MAX),
	azureUserAccount NVARCHAR(MAX),
	azureAccountKey NVARCHAR(MAX),
	tenantUrlItem NVARCHAR(MAX),
	msCloudRegion INT,
	modernAuthEnabled INT,
	azureAppsXml Xml,
	serviceAccountsXml Xml,
	additionalUserAccounts xml,
	tenantName NVARCHAR(MAX),
	discoverState xml,
	--Sharepoint backupset END
	--DB2 backupset START
	dB2SQLConnect NVARCHAR(MAX),
	dB2DBStatus INT,
	dB2DefaultIndexSP INT,
	dB2DefaultIndexSPName NVARCHAR(288),
	dB2DefaultCommandSP INT,
	dB2DefaultCommandSPName NVARCHAR(288),
	dB2CatalogPartitionNumber INT,
	useSQLConnect INT,
	dB2AutoStorage INT,
	--DB2 backupset END
	--Cloud Connector backupset START
	cc_isAutoDiscoveryEnabled INT,
	cc_isEnterpriseFlag INT,
	cc_provider INT,
	cc_assocUserName NVARCHAR(MAX),
	cc_userId NVARCHAR(MAX),
	cc_domainName NVARCHAR(MAX),
	cc_emailID NVARCHAR(MAX),
	cc_appClientId NVARCHAR(MAX),
	cc_appEmailId NVARCHAR(MAX),
	cc_appKey NVARCHAR(MAX),
	--Cloud Connector backupset END
	indexServer XML,
	indexMAs XML,
	indexBkpSp XML,
	indexBkpEligibleSPs XML,
	--CloudApps backupset START
	clEnableREST INT,
	clDownloadCachePath NVARCHAR(MAX),
	clUserName NVARCHAR(MAX),
	clSyncDatabase XML,
	clDbRetentionDays INT,
	clEnableCatDbPurging INT,
	clMutualAuthCertPath NVARCHAR(MAX),
	--CloudApps backupset END
    -- Plan Association Details Start
    planId                  INT NULL,
    planType                INT NULL,
    planSubType             INT NULL,
    planName                NVARCHAR(1024) NULL,
	isContentFromPlan		INT NULL,
    -- Plan Association Details END
	-- SAP HANA Backupset START
	hanaUseHdbUserStoreKey	INT,
	hanaHdbUserStoreKey		NVARCHAR(1024),
	hanaDbInstanceNumber	NVARCHAR(32),
	hanaSapHANAUser			NVARCHAR(128),
	hanadbUser				NVARCHAR(128),
	hanaLogSP				INT,
	hanaCmdlineSP			INT,
	-- SAP HANA Backupset END
	guid uniqueidentifier,
	--Index Pruning
	indexPruning		INT DEFAULT 0,
	retDays				INT DEFAULT -1,
	retCycles 			INT DEFAULT -1,
	pruningType			INT DEFAULT 0,
	subclientList		XML NULL,
	isArchivingEnabled	INT DEFAULT 0
)
CREATE UNIQUE CLUSTERED INDEX i_backupList_backupsetId_idx ON #i_backupList (backupsetId DESC)
IF OBJECT_ID('tempdb.dbo.#i_backupListAssociatedEntities') IS NOT NULL
	DROP TABLE #i_backupListAssociatedEntities
CREATE TABLE #i_backupListAssociatedEntities
(
	clientId				INT,
	clientName				NVARCHAR(510),
	clientDisplayName		NVARCHAR(510),
	appTypeId				INT,
	appTypeName				NVARCHAR(255),
	instanceId				INT,
	instanceName			NVARCHAR(255),
	backupsetId				INT,
	backupSetName			NVARCHAR(510),
	errorCode				INT DEFAULT 0,
	errorString				NVARCHAR(510) DEFAULT N'',
	guid uniqueidentifier
	)
	DECLARE @ErrorTable TABLE ( clientid INT,
							   clientName NVARCHAR(255),
							   applicationId int,
							   appName NVARCHAR(256),
							   instanceId int,
							   instanceName			NVARCHAR(1024),
							   backupsetId int,
							   backupsetName			NVARCHAR(256),
							   errorCode INT,
							   errorString NVARCHAR(255))
--Temp table for better query execution
IF OBJECT_ID('tempdb.dbo.#subclientInfo') IS NOT NULL
	DROP TABLE #subclientInfo
CREATE TABLE #subclientInfo
(
	id							INT,
	backupset					INT,
	isSubClientPolicyContent	INT,
	appTypeId					INT
)
CREATE CLUSTERED INDEX subclientInfo_idx ON #subclientInfo (id)
DECLARE @FSContentInfo TABLE (
								backupsetId INT,
								type INT,
								content NVARCHAR(MAX),
								isSubclientPolicyContent BIT
								)
DECLARE @associatedEntitiesTable TABLE
(
	xmlval XML
)
IF OBJECT_ID('TempDb.dbo.#SCQuota') IS NOT NULL
       DROP TABLE #SCQuota
CREATE TABLE #SCQuota (
	   subclientId	 INT,
       backupset     INT,
       quota         BIGINT,
       aTime         INT,
	   firstBackupTime	INT,
	   totalBackupSize	BIGINT DEFAULT 0
)
CREATE CLUSTERED INDEX SCQuota_idx ON #SCQuota (backupset)
IF OBJECT_ID('TempDb.dbo.#SCBkpStats') IS NOT NULL
       DROP TABLE #SCBkpStats
CREATE TABLE #SCBkpStats (
	   subclientId	 INT,
	   firstBackupTime	INT,
	   totalBackupSize	BIGINT DEFAULT 0
)
		SELECT
				@propertyLevel = ISNULL(Tbl.Col.value('(filterOptions/@propertyLevel)[1]', 'INT') , 30),
				@localeId = ISNULL(Tbl.Col.value('(processinginstructioninfo/locale/@localeId)[1]', 'INT'), 0),
				@userId = ISNULL(Tbl.Col.value('(processinginstructioninfo/user/@userId)[1]', 'INT'), 0)
			FROM @i_xml.nodes('/App_GetBackupsetPropertiesRequest') as Tbl(Col)
		SET @inBackupSetId = ISNULL(@i_xml.value('(//./association/entity/@backupsetId)[1]','INT'), 0)
		IF (SELECT @i_xml.value('(//./association/entity/@backupsetId)[1]','INT')) <> '' AND (SELECT @i_xml.value('count(/App_GetBackupsetPropertiesRequest/association/entity)', 'INT')) = 1
		BEGIN
			SELECT 	@clientId = clientId,
					@instancetId = instance,
					@appTypeId = appTypeId
			FROM App_Application WHERE backupSet = @inBackupSetId
			IF( @instancetId IS NULL OR @appTypeId IS NULL OR @clientId IS NULL)
			BEGIN
SET @errorString = (select message from EvLocaleMsgs WITH (NOLOCK) Where messageId = (1859 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
				SET	@xmlResultError = (SELECT
(SELECT (1859 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AS '@errorCode',
													@errorString AS '@errorString'
											FOR XML PATH('errors'), TYPE)
										FOR XML PATH(''), ROOT('App_GetBackupsetPropertiesResponse'))
				SELECT @xmlResultError
				RETURN
			END
			INSERT INTO #bkpSecurityTbl EXEC	dbo.sec_iDaNodeAccess @userId, 2, @clientId, @appTypeId, @instancetId, @inBackupSetId, 0
			IF NOT EXISTS (SELECT returnedUserId FROM #bkpSecurityTbl WHERE returnedUserId = @userId )
			BEGIN
SET @errorString = (SELECT message FROM EvLocaleMsgs WITH (NOLOCK) WHERE messageId = (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND [localeId] = @localeId)
				SET @errorString = REPLACE(@errorString, '^1%s', ISNULL((SELECT login FROM UMUsers WITH (NOLOCK) WHERE id = @userId), @userId))
				SET @errorString = REPLACE(@errorString, '^2%s', dbo.fn_EvFormatEventMsgText(0,@localeId, (SELECT tokenId FROM UMCapability WITH (NOLOCK) WHERE id = 31), 0,2))
				SET @errorString = REPLACE(@errorString, '^3%s', 'backupset')
				SET	@xmlResultError = (SELECT
(SELECT (462 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AS '@errorCode',
													@errorString AS '@errorString'
											FOR XML PATH('errors'), TYPE)
										FOR XML PATH(''), ROOT('App_GetBackupsetPropertiesResponse'))
				SELECT @xmlResultError
				RETURN
			END
			INSERT INTO #i_backupList(clientId, clientName , clientDisplayName, appTypeId, appTypeName, instanceId, instanceName, backupsetId, backupSetName, guid)
			(SELECT client.id,
					client.name,
					client.displayName,
					ida.type,
					ida.displayName,
					instance.id,
					instance.name,
					backupset.id,
					backupset.name,
					backupset.GUID
					FROM APP_Application Subclient
					INNER JOIN APP_Client client ON Subclient.clientId = client.id
					INNER JOIN App_iDatype AS ida ON subclient.appTypeId = ida.type
					INNER JOIN APP_BackupSetName AS backupset ON subclient.backupSet = backupSet.id
					INNER JOIN APP_InstanceName AS instance ON subclient.instance = instance.id
					WHERE Subclient.backupSet = @inBackupSetId
					GROUP BY client.id, client.name, client.displayName, ida.type, ida.displayName, instance.id, instance.name, backupset.id, backupset.name, backupset.GUID
			)
			IF @propertyLevel >= 20
			BEGIN
			DECLARE @sizeONMEdia FLOAT=0
			DECLARE @totalUncompBytes FLOAT=0
			DECLARE @dedupePer FLOAT=0
			SELECT   @sizeONMEdia= ISNULL(SUM(SM.attributeValueInt),0), @totalUncompBytes =ISNULL(SUM(JMB.totalUncompBytes),0)
	        FROM JMBkpStats JMB WITH(NOLOCK)
					INNER JOIN JMJobOptions SM WITH(NOLOCK) ON JMB.jobId = SM.jobId
					AND JMB.commCellId = SM.commCellId
					AND SM.attributeId = 73
					AND JMB.status IN (1 ,3,14) -- JMSUCCESS, PARTIALSUCCESS, JMSUCCESSWITHWARNINGS
     				INNER JOIN APP_Application App ON App.id=appId AND App.backupSet=@inBackupSetId
     				LEFT OUTER JOIN APP_SubClientProp ASCP WITH(NOLOCK) ON ASCP.componentNameId = App.id
					AND ASCP.attrName IN (N'DDB Backup', N'Index SubClient')
					AND ASCP.cs_attrName IN (CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
					AND ASCP.modified = 0
					WHERE ASCP.componentNameId IS NULL
			IF(@totalUncompBytes<>0)
			BEGIN
				UPDATE T
					SET T.dedupeRatio=((@totalUncompBytes-@sizeONMEdia)/@totalUncompBytes)*100,
						T.sizeOnMedia=@sizeONMEdia
				FROM #i_backupList T
			END
			END
		END
		ELSE
		BEGIN
			DECLARE @associatedEntitiesRequest XML =	( SELECT 6 '@expandLevel',
															(SELECT
																(SELECT @userId '@userId'
																	FOR XML PATH('user'), TYPE)
																FOR XML PATH('processinginstructioninfo'), TYPE),
																ISNULL(@i_xml.query('App_GetBackupsetPropertiesRequest/association/entity'),'')
														FOR xml PATH('App_GetAssociatedEntities') )
			INSERT INTO @associatedEntitiesTable
			EXEC dbo.GetAssociatedEntities @associatedEntitiesRequest
			INSERT INTO #i_backupListAssociatedEntities(clientId, clientName , clientDisplayName, appTypeId, appTypeName, instanceId, instanceName, backupsetId, backupSetName, errorCode, errorString, guid)
									SELECT  resp.col.value('@clientId', 'INT'),
										resp.col.value('@clientName', 'NVARCHAR(510)'),
										resp.col.value('@clientDisplayName', 'NVARCHAR(510)'),
										resp.col.value('@applicationId', 'INT'),
										resp.col.value('@appName', 'NVARCHAR(256)'),
										resp.col.value('@instanceId', 'INT'),
										resp.col.value('@instanceName', 'NVARCHAR(1024)'),
										resp.col.value('@backupsetId', 'INT'),
										resp.col.value('@backupsetName', 'NVARCHAR(256)'),
										ISNULL(s.ref.value('@errorCode', 'INT'),0),
										s.ref.value('@errorString', 'NVARCHAR(256)'),
										resp.col.value('@backupsetGUID', 'VARCHAR(40)')
									FROM @associatedEntitiesTable AS response
										OUTER APPLY response.xmlval.nodes ('App_GenericResponse/response') as S(ref)
										OUTER APPLY ref.nodes('entity') resp(col)
			INSERT INTO @ErrorTable
			SELECT clientId, clientName, appTypeId,appTypeName, instanceId, instanceName, backupsetId, backupsetName, errorCode, errorString FROM #i_backupListAssociatedEntities WHERE errorCode <> 0
			INSERT INTO #i_backupList(clientId, clientName, clientDisplayName, appTypeId, appTypeName, instanceId, instanceName, backupsetId, backupsetName,  errorCode, errorString, guid)
			SELECT clientId, clientName, clientDisplayName, appTypeId,appTypeName, instanceId, instanceName, backupsetId, backupsetName, errorCode, errorString, guid
			FROM #i_backupListAssociatedEntities WHERE errorCode =0
		END
		IF NOT EXISTS(SELECT 1 FROM #i_backupList ) AND NOT EXISTS(SELECT TOP 1 1 FROM @ErrorTable)
		BEGIN
SET @errorString =(SELECT message FROM EvLocaleMsgs WHERE messageId = (3284 | (CAST(POWER(2, 24) AS BIGINT) * 35)) AND localeId = @localeId)
DECLARE @retval int = (3284 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			DECLARE @xmlResultErrorInValid XML
			SET	@xmlResultErrorInValid =
											(SELECT
												(SELECT
													@retval AS '@errorCode',
													@errorString AS '@errorString'
												FOR XML PATH('errors'), TYPE)
											FOR XML PATH(''), ROOT('App_GetBackupsetPropertiesResponse'))
			SELECT @xmlResultErrorInValid
			RETURN
		END
------------------------------------------------
--We have backupset entities, gather properties.
------------------------------------------------
--Identify backupset type
	UPDATE T
	SET
		T.backupsetType = (SELECT CASE
									WHEN(S.appTypeId IN(SELECT DISTINCT grpAssoc.appTypeId
															FROM APP_AppTypeGroupAssoc grpAssoc
															INNER JOIN APP_AppTypeGroup apptypeGrp ON apptypeGrp.appTypeGroupId = grpAssoc.appGroupId
															AND (apptypeGrp.groupName='APPGRP_NOTES_MAILS' or
																	apptypeGrp.groupName='APPGRP_NotesDb' or
																	apptypeGrp.groupName='APPGRP_NotesOnUnix' or
																	apptypeGrp.groupName='APPGRP_NotesDocDataMigrator' or
																	apptypeGrp.groupName='APPGRP_NotesDoc' or
																	apptypeGrp.groupName='APPGRP_NotesDb_Transaction_Log' or
																	apptypeGrp.groupName = 'APPGRP_NotesDb_Transaction_Log' )))
									THEN 'lotusnotesBackupSet'
									WHEN(S.appTypeId IN(SELECT DISTINCT grpAssoc.appTypeId
															FROM APP_AppTypeGroupAssoc grpAssoc
															INNER JOIN APP_AppTypeGroup apptypeGrp ON apptypeGrp.appTypeGroupId = grpAssoc.appGroupId
															AND (apptypeGrp.groupName='APPGRP_ExchangeMailboxArchiver' or
																	apptypeGrp.groupName='APPGRP_ExchangeComplainceArchiver' or
																	apptypeGrp.groupName='APPGRP_ExchangeMailbox' or
																	apptypeGrp.groupName='APPGRP_MS_EXCHANGE')))
									THEN 'exchangeBackupSet'
									WHEN(S.appTypeId IN(SELECT DISTINCT grpAssoc.appTypeId
															FROM APP_AppTypeGroupAssoc grpAssoc
															INNER JOIN APP_AppTypeGroup apptypeGrp ON apptypeGrp.appTypeGroupId = grpAssoc.appGroupId
															AND (apptypeGrp.groupName = 'APPGRP_FileReplicationAgent')))
									THEN 'filereplicationBackupSet'
									WHEN(S.appTypeId IN(SELECT DISTINCT grpAssoc.appTypeId
															FROM APP_AppTypeGroupAssoc grpAssoc
															INNER JOIN APP_AppTypeGroup apptypeGrp ON apptypeGrp.appTypeGroupId = grpAssoc.appGroupId
															AND (apptypeGrp.groupName='APPGRP_SharePointDB' or
																	apptypeGrp.groupName='APPGRP_SharePointDataMigratorIda' or
																	apptypeGrp.groupName='APPGRP_SharePointV2DocOrDataMigratorIda' or
																	apptypeGrp.groupName='APPGRP_SharePointDoc' or
																	apptypeGrp.groupName = 'APPGRP_MS_SHAREPOINT')))
									THEN 'sharepointBackupSet'
									WHEN(S.appTypeId IN(SELECT DISTINCT grpAssoc.appTypeId
															FROM APP_AppTypeGroupAssoc grpAssoc
															INNER JOIN APP_AppTypeGroup apptypeGrp ON apptypeGrp.appTypeGroupId = grpAssoc.appGroupId
															AND (apptypeGrp.groupName='APPGRP_DB2')))
									THEN 'db2BackupSet'
									WHEN(S.appTypeId IN(SELECT DISTINCT grpAssoc.appTypeId
															FROM APP_AppTypeGroupAssoc grpAssoc
															INNER JOIN APP_AppTypeGroup apptypeGrp ON apptypeGrp.appTypeGroupId = grpAssoc.appGroupId
															AND (apptypeGrp.groupName='APPGRP_FileSystemIDA' OR apptypeGrp.groupName = 'APPGRP_FileSystemLikeIDA'))
															OR EXISTS(SELECT 1 FROM APP_Client WHERE id = S.clientId AND simOperatingSystemId = 118))
									THEN 'fsbackupset'
WHEN S.appTypeId = 134
									THEN 'cloudAppsBackupset'
WHEN S.appTypeId = 135
									THEN 'sapHanaBackupset'
								 END
							)
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId
	--Get status of backupset
	UPDATE #i_backupList
	SET
		bkpstatus = S.status,
isDefaultBackupSet = (CASE (S.status & 0x00008) WHEN 0x00008 THEN 1 ELSE 0 END),
isMyBackupSet = (CASE (S.status & 0x0100) WHEN 0x0100 THEN 1 ELSE 0 END),
isDeleted = (CASE ((S.status & 0x00002) | (S.status & 0x00004)) WHEN 0 THEN 0 ELSE 1 END),
isFanInBackupSet = (CASE (S.status & 0x1000) WHEN 0x1000 THEN 1 ELSE 0 END),
isHidden = (CASE (S.status & 0x00020) WHEN 0x00020 THEN 1 ELSE 0 END),
isMining = (CASE (S.status & 0x80000) WHEN 0x80000 THEN 1 ELSE 0 END),
		modifiedTime = S.modified,
spBackupsetType = (CASE WHEN (S.status & 0x0800) = 0x0800 THEN 1
WHEN (S.status & 0x8000) = 0x8000 THEN 3
WHEN (S.status & 0x80000) = 0x80000 THEN 4
ELSE 2 END)
	FROM
		APP_BackupSetName S
	WHERE
		backupsetId = S.id
	-- no need to do below since getassociatedentities is already doing it
	--Remove Hidden/dummy backupsets
	-- DELETE #i_backupList
	-- WHERE (bkpstatus & CV_STATUS_HIDDEN) = CV_STATUS_HIDDEN
	--		OR (bkpstatus & CV_STATUS_DUMMY) = CV_STATUS_DUMMY
IF @propertyLevel >= 5 --Essential properties
BEGIN
	INSERT INTO #subclientInfo
		SELECT id,
			   backupset,
			   0 AS isSubclientPolicyContent,
			   APP.apptypeid
		FROM   app_application APP WITH(nolock)
			   INNER JOIN #i_backuplist bkpList WITH(nolock)
					   ON App.backupset = bkpList.backupsetid
		UNION
		SELECT Cast(SCP.attrval AS INT) AS id,
			   backupset,
			   1                        AS isSubclientPolicyContent,
			   App.apptypeid
		FROM   app_application App WITH(nolock)
			   INNER JOIN #i_backuplist bkpList
					   ON App.backupset = bkpList.backupsetid
			   INNER JOIN app_subclientprop SCP WITH(nolock)
					   ON SCP.componentnameid = App.id
						  AND SCP.attrname = N'Associated subclient Policy'
						  AND SCP.cs_attrname = Checksum(N'Associated subclient Policy')
						  AND SCP.modified = 0
			   LEFT OUTER JOIN APP_SubClientProp SCP2 WITH(NOLOCK)
					   ON SCP2.componentnameid = App.id
						  AND SCP2.attrname = N'Use Local Content'
						  AND SCP2.cs_attrname = ( Checksum(N'Use Local Content') )
						  AND SCP2.attrval = N'1'
						  AND SCP2.modified = 0
		WHERE SCP2.componentnameid is NULL
	INSERT INTO @FSContentInfo
		SELECT DISTINCT subclient.backupset,
				type,
				filename,
				subclient.isSubclientPolicyContent
		FROM APP_ScFilterFile ASFilter  WITH(NOLOCK)
										INNER JOIN #subclientInfo subclient
													ON ASFilter.componentNameId=subclient.id
													   AND ASFilter.modified = 0
										LEFT OUTER JOIN app_subclientprop ASCP WITH(nolock)
													ON ASCP.componentnameid = subclient.id
													   AND ASCP.attrname IN ( N'DDB Backup', N'Index SubClient'
																			)
													   AND ASCP.cs_attrname IN ( Checksum(N'DDB Backup'),
																				 Checksum(
																				 N'Index SubClient')
																			   )
													   AND ASCP.modified = 0
									   INNER JOIN app_apptypegroups ATG
											   ON subclient.apptypeid = ATG.apptypeid
												  AND ATG.app = 'file system'
												  AND ATG.osgroup IN ( 'Windows', 'Unix', 'NAS' )
		WHERE  ASCP.componentnameid IS NULL
			-- Sets the SLA status. 1 - Met, 2 - Missed, 3 - Exclude
			UPDATE T
			SET T.SLAStatus = (CASE WHEN Bpprops.SLAStatus = 1 THEN 1 WHEN Bpprops.SLAStatus = 2 THEN 2 ELSE 3 END)
			FROM #i_backupList T
			INNER JOIN (SELECT MAX(status) SLAStatus, backupSet
			FROM RptSLASubclient SLA
			INNER JOIN
			APP_Application AP
			ON SLA.appId = AP.id AND SLA.clientId = AP.clientId AND SLA.fullJobsOnly = 0
			GROUP BY backupset) BPProps
			ON BPProps.backupSet = T.backupsetId
			INSERT INTO #SCQuota(subclientId, backupset, quota, aTime)
				   SELECT
				   		  app.id,
						  app.backupset,
						  CAST(scp2.attrVal AS BIGINT) quota,
						  CAST(scp1.attrVal AS INT) atime
				   FROM APP_Application app WITH(NOLOCK)
						  INNER JOIN APP_SubClientProp scp1 WITH(NOLOCK) ON
								 scp1.componentNameId = app.id
								 AND scp1.modified = 0
								 AND scp1.cs_attrName = CHECKSUM(N'Last Data Protected Time')
								 AND scp1.attrName = N'Last Data Protected Time'
						  LEFT OUTER JOIN APP_SubClientProp scp2 WITH(NOLOCK) ON
								 scp2.componentNameId = app.id
								 AND scp2.modified = 0
								 AND scp2.cs_attrName = CHECKSUM(N'Application Size')
								 AND scp2.attrName = N'Application Size'
						  LEFT OUTER JOIN APP_SubClientProp ASCP WITH(NOLOCK) ON ASCP.componentNameId = app.id
								 AND ASCP.cs_attrName IN (CHECKSUM(N'DDB Backup'), CHECKSUM(N'Index SubClient'))
								 AND ASCP.modified = 0
					WHERE
						ASCP.componentNameId IS NULL
			UPDATE T
			SET T.applicationSize = ISNULL(BPProps.applicationSize, 0),
			T.lastBackupTime = ISNULL(BPProps.lastBackupTime, 0)
			FROM #i_backupList T
			INNER JOIN (
				SELECT
					   b.backupSet,
					   MAX(b.atime) AS lastBackupTime,
					   SUM(DISTINCT ISNULL(bsp.attrVal, 0) + ISNULL(b.quota,0) ) AS applicationSize
				FROM #SCQuota b
					   LEFT OUTER JOIN APP_BackupSetProp bsp WITH(NOLOCK) ON
							  b.backupSet = bsp.componentNameId
							  AND bsp.modified = 0
							  AND bsp.attrName = N'Application Size'
				GROUP BY
					   b.backupSet) BPProps
			on BPProps.backupset = T.backupsetId
END
--We need FirstBackupTime and TotalBackupSize only in higher property level.
IF @propertyLevel >= 30
BEGIN
	INSERT INTO #SCBkpStats
		SELECT JMB.appId, MIN(JMB.servEndDate) servEndDate, SUM(CAST(JMB.totalUnCompBytes AS BIGINT)) totalBackupSize
					FROM JMBkpStats JMB
						INNER JOIN #SCQuota scq ON
							JMB.appId = scq.subclientId
							AND JMB.status IN (1, 3, 14)
							AND JMB.dataStatus = 0
						GROUP BY JMB.appId
	UPDATE sc
	SET firstBackupTime = SCQ.firstBackupTime,
		totalBackupSize = SCQ.totalBackupSize
	FROM #SCQuota sc
		LEFT OUTER JOIN #SCBkpStats SCQ ON SCQ.subclientId = sc.subclientId
	UPDATE T
			SET
				T.firstBackupTime = ISNULL(BPProps.firstBackupTime, 0),
				T.totalBackupSize = ISNULL(BPProps.totalBackupSize, 0)
			FROM #i_backupList T
			LEFT OUTER JOIN (
				SELECT
					   b.backupSet,
					   MIN(b.firstBackupTime) firstBackupTime,
					   SUM(b.totalBackupSize) totalBackupSize
				FROM #SCQuota b
				GROUP BY
					   b.backupSet) BPProps
			on BPProps.backupset = T.backupsetId
END
IF @propertyLevel >= 10 --Basic Properties
BEGIN
	--Get Common Properties
	UPDATE #i_backupList
	SET
		userDescription = ISNULL([User Description], N''),
		onDemandBackupset = ISNULL([OnDemand Backupset], 0),
		isDedupBackupset = ISNULL([Dedup Backupset], 0),
		cDRFSDMBackupset = ISNULL([CDR FSDM Backupset], 0),
		associatedsubclientPolicy = ISNULL([Associated subclient Policy], 0),
		associatedsubclientPolicyName = (SELECT name FROM APP_BackupSetName WHERE id = ISNULL([Associated subclient Policy], 0)),
		siloCopyId = ISNULL([SILO Copy ID], 0),
		isNasTurboBackupSet = ISNULL([NAS Turbo Backupset], 0),
		isWildCardContentBackupSet = ISNULL([WildCard Content], 0),
		dataMigratorILMCLASS = ISNULL([Data Migrator ILM CLASS], 0),
		decompressData = ISNULL([Decompress Data], 0),
		useChangeJournal = ISNULL([Use Change Journal], 0),
		isUSeDCForBackup = ISNULL([Use DC for FS backups], 0),
		hadoopAppType = ISNULL([Hadoop App Type], 0),
		isArchivingEnabled = ISNULL([Is Archiving Enabled], 0)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal
		FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId AND prop.modified = 0
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ( [User Description], [OnDemand Backupset], [Dedup Backupset], [CDR FSDM Backupset], [Associated subclient Policy], [SILO Copy ID], [NAS Turbo Backupset],
		[WildCard Content],	[Data Migrator ILM CLASS], [Decompress Data], [Use Change Journal], [Use DC for FS backups], [Hadoop App Type], [Is Archiving Enabled]) --CV_IS_ARCHIVING_ENABLED_BACKUPSET
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	--isUSeDCForBackup has default value 1 for following apptypes.
	UPDATE #i_backupList
	SET
		isUSeDCForBackup = ISNULL([Use DC for FS backups], 1)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal
		FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
AND prop.modified = 0 AND bkpList.appTypeId IN(8,14, 54, 55,
35, 44, 46, 45, 56, 57,
67, 68, 82, 78,
89, 105)
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ( [Use DC for FS backups])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	--If status do not have isMyBackupSet bit then check for 'My BackupSet' property.
	UPDATE #i_backupList
	SET
		isMyBackupSet = ISNULL([My BackupSet], 0)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal
		FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.isMyBackupSet = 0
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ( [My BackupSet])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	UPDATE T
	SET
		T. isLegalHoldBackupset = 1
	FROM #i_backupList T
	INNER JOIN DM2CompliancePolicy S ON T.backupsetId = S.BackupsetId
	UPDATE T
	SET
		T.commonBackupSetProps = (SELECT
									(SELECT  S.userDescription '@userDescription',
											S.onDemandBackupset '@onDemandBackupset',
											S.isDedupBackupset '@isDedupBackupset',
											S.cDRFSDMBackupset '@cDRFSDMBackupset',
											S.isDefaultBackupSet '@isDefaultBackupSet',
											S.associatedsubclientPolicy '@associatedsubclientPolicy',
											S.associatedsubclientPolicyName '@associatedsubclientPolicyName',
											S.siloCopyId '@siloCopyId',
											S.isMyBackupSet '@isMyBackupSet',
											S.isDeleted '@isDeleted',
											S.isNasTurboBackupSet '@isNasTurboBackupSet',
											S.isFanInBackupSet '@isFanInBackupSet',
											S.isHidden '@isHidden',
											S.isLegalHoldBackupset '@isLegalHoldBackupset',
											S.isWildCardContentBackupSet '@isWildCardContentBackupSet',
											S.isMining '@isMining',
											S.dataMigratorILMCLASS '@dataMigratorILMCLASS',
											S.isUSeDCForBackup '@isUSeDCForBackup',
											S.decompressData '@decompressData',
											S.backupSetName '@newBackupSetName',
											S.isArchivingEnabled '@isArchivingEnabled',
											S.SLAStatus '@slaStatus'
										FOR xml PATH('commonBackupSet')))
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId
	-- Get Index server properties
	SELECT TOP 1 @clientId = clientId, @instancetId = instanceId, @appTypeId = appTypeId FROM #i_backupList
	IF (SELECT COUNT(*) FROM #i_backupList) = 1
		SELECT @inBackupSetId = T.backupsetId FROM #i_backupList T
	DECLARE @scIdxEnabled INT = ISNULL((SELECT 1 FROM APP_IDAName IDA WITH (NOLOCK) JOIN APP_IDAProp IDAP WITH (NOLOCK)
	ON IDA.id = IDAP.componentNameId AND IDA.clientId = @clientId AND IDA.appTypeId = @appTypeId AND IDAP.attrName = 'Subclient Index' and IDAP.attrVal = '1' and IDAP.modified = 0),0)
	DECLARE @pruningEnabled INT = 0
	CREATE TABLE #idxOpts(entityId INT, curIdxServer XML, indexMAs XML, indexBkpSp XML, indexBkpEligibleSPs XML, indexPruning INT DEFAULT 0, retDays	INT DEFAULT -1, retCycles INT DEFAULT -1, pruningType INT DEFAULT 0)
	INSERT INTO #idxOpts SELECT * FROM dbo.GetIndexServerOptions (@clientId, @instancetId, @appTypeId, @inBackupSetId, 0, 0, @propertyLevel)
	IF EXISTS (SELECT TOP 1 entityId FROM #idxOpts)
	BEGIN
		SELECT @pruningEnabled = CAST(ISNULL(value,0) AS INT) FROM GXGlobalParam WITH (NOLOCK) WHERE name = 'Enable Index Pruning' AND modified = 0
		UPDATE #i_backupList
		SET indexServer = T.curIdxServer, indexMAs = T.indexMAs, indexBkpSp = T.indexBkpSp, indexBkpEligibleSPs = T.indexBkpEligibleSPs, indexPruning = T.indexPruning, retDays = T.retDays, retCycles = T.retCycles, pruningType = T.pruningType
		FROM #idxOpts T WHERE backupsetId = T.entityId
	END
	DROP TABLE #idxOpts
	-- Get Plan details
    UPDATE backupList
    SET backupList.planId=AP.id,
    backupList.planType=AP.type,
    backupList.planSubType=AP.subType,
    backupList.planName=AP.name
    FROM #i_backupList backupList
    INNER JOIN APP_BackupSetProp ABP WITH(NOLOCK)
ON ABP.componentNameId=backupList.backupsetId AND ABP.attrName = 'Associated Plan' AND ABP.modified=0
    INNER JOIN App_Plan AP
ON AP.id=CAST(ABP.attrVal AS INT) AND ((AP.flag & 0x00004) = 0) AND ((AP.flag & 0x40000000) = 0)
END --@propertyLevel >= 10
IF @propertyLevel >= 20 --Extended properties
BEGIN
	UPDATE backupList
		SET backupList.isContentFromPlan=1
		FROM #i_backupList backupList
WHERE planId>0 AND planSubType IN (50331655, 33554437)
		AND CAST(associatedsubclientPolicy AS VARCHAR(32)) IN (
dbo.AppPlanGetEntityValueV2(planId, 'Subclient policy 2', default),
dbo.AppPlanGetEntityValueV2(planId, 'Subclient policy 3', default),
dbo.AppPlanGetEntityValueV2(planId, 'Subclient policy 4', default)
								   )
	--Get FS backupset properties
	UPDATE #i_backupList
	SET
		preserveFileAccessTimes = ISNULL([Reset File Access Times], 0)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
AND prop.modified = 0 AND bkpList.appTypeId = 105
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ( [Reset File Access Times])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	IF OBJECT_ID('tempdb.dbo.#AssociatedAppTypes') IS NOT NULL
		DROP TABLE #AssociatedAppTypes
	CREATE TABLE #AssociatedAppTypes
	(
		apptypeId int,
	)
	CREATE UNIQUE CLUSTERED INDEX AssociatedAppTypes_apptypeId_idx ON #AssociatedAppTypes (apptypeId DESC)
	INSERT INTO #AssociatedAppTypes(apptypeId)(SELECT DISTINCT appTypeId FROM dbo.GetAppTypesForAppGroup(35, 0))
	UPDATE #i_backupList
	SET
		preserveFileAccessTimes = ISNULL([Reset File Access Times], 0)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		INNER JOIN #AssociatedAppTypes AAT ON bkpList.appTypeId = AAT.apptypeId
		AND prop.modified = 0
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ( [Reset File Access Times])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	UPDATE #i_backupList
	SET
		preserveFileAccessTimes = ISNULL([Preserve File Access Times], 0)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.preserveFileAccessTimes = 0
AND bkpList.appTypeId IN (17, 18, 19, 20,
21, 29, 36, 38,
63, 64, 74)
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([Preserve File Access Times])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	UPDATE #i_backupList
	SET
		netAppImageBackup = ISNULL([NetApp Image Backup], 0),
		useArchiveBit =  ISNULL([Use Archive Bit], 0),
		pre70SystemStateArchiveFilesExist =  ISNULL([Pre 7.0 System State Archive Files Exist], 0),
		fLRrepSetId =  ISNULL([FS FileReplication RepSet], 0),
		fLRrepSetName = ISNULL((SELECT name FROM APP_BackupSetName where id = ISNULL([FS FileReplication RepSet], 0)),N''),
		isTrueUpOptionEnabledForOnePass = ISNULL([Is true up enabled for Onepass], 0),
		runTrueUpJobAfterDaysForOnePass = ISNULL([run true up after days for Onepass], 30),
		useDCserviceForScan = (CASE WHEN (useChangeJournal = 1 OR isUSeDCForBackup = 1) THEN 0 END),
		customApplicationType = ISNULL([Custom Application Type], 0),
		isAdAppAwareBackupSet = ISNULL([AD AppAware Backupset], 0)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.backupsetType = 'fsbackupset'
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([NetApp Image Backup], [Use Archive Bit], [Pre 7.0 System State Archive Files Exist], [FS FileReplication RepSet], [Is true up enabled for Onepass], [run true up after days for Onepass], [Custom Application Type], [AD AppAware Backupset])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	UPDATE BKP SET BKP.hasBackupSystemStateSubclient = 1
	FROM #i_backupList BKP
	INNER JOIN APP_Application APP WITH (NOLOCK)
		ON APP.backupSet = BKP.backupsetId
		INNER JOIN APP_SubClientProp SCP WITH (NOLOCK)
			ON SCP.componentNameId = APP.id
			AND (APP.subclientStatus & 4) <> 4
			AND SCP.cs_attrName = CHECKSUM(N'System State')
			AND SCP.attrVal = N'1'
			AND SCP.modified = 0
			AND BKP.backupsetType = 'fsbackupset'
	UPDATE BKP SET BKP.hasOneTouchSubclient = 1
	FROM #i_backupList BKP
	INNER JOIN APP_Application APP WITH (NOLOCK)
		ON APP.backupSet = BKP.backupsetId
			AND (APP.subclientStatus & 4) <> 4
AND (APP.subclientStatus & 0x0100) = 0x0100
			AND BKP.backupsetType = 'fsbackupset'
	--Get exchange backupset properties
	UPDATE #i_backupList
	SET
		activeDirectoryGroupAutoDiscover = ISNULL([Active Directory Group Auto Discover], 0),
		activeDirectoryWildCardAutoDiscover = ISNULL([Active Directory WildCard Auto Discover], 0),
		dCDBFileLocation = ISNULL([DC DB File Location], N''),
		exchangeEnableDiscovery = ISNULL([Enable Dicovery], 0),
		storageGroupAutoDiscover = ISNULL([Storage Group Auto Discover], 0),
		exchangeOnePassBackupsetType = ISNULL([Exchange OnePass BackupSet Type], N'')
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.backupsetType = 'exchangeBackupSet'
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([Active Directory Group Auto Discover], [Active Directory WildCard Auto Discover], [DC DB File Location],
										[Enable Dicovery], [Storage Group Auto Discover], [Exchange OnePass BackupSet Type])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	--Get Sharepoint backupset properties
	UPDATE #i_backupList
	SET
		v2Backupset = ISNULL([V2 Backupset], 0),
		isEnableArchiving = ISNULL([Enable Archiving], 0),
		isEnableTier1Archiving = ISNULL([Enable Tier 1 Archiving], 0),
		azureUserAccount = ISNULL([SP Office365 Azure User Account], N''),
		azureAccountKey = ISNULL([SP Office365 Azure Account Key], N''),
		tenantUrlItem = ISNULL([SP Office365 Tenant Url], N''),
		azureUsername = ISNULL([SP Office365 Username], N''),
		azurePassword = ISNULL([SP Office365 Password], N''),
		msCloudRegion = ISNULL([MSCloud Region Type], 1),
		modernAuthEnabled		= ISNULL([Sharepoint Modern Auth], 0),
		additionalUserAccounts = CAST(REPLACE([SP Additional Office365 Accounts],'UTF-8','UTF-16') as xml),
		azureAppsXml = CAST(REPLACE([Sharepoint Azure Connections],'UTF-8','UTF-16') as xml),
		serviceAccountsXml = CAST(REPLACE([Sharepoint Service Accounts],'UTF-8','UTF-16') as xml),
		tenantName = ISNULL([SharePoint Tenant Name], N''),
		discoverState = CAST(REPLACE([SharePoint Discovery State],'UTF-8','UTF-16') as xml)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.backupsetType = 'sharepointBackupSet'
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([V2 Backupset], [Enable Archiving], [Enable Tier 1 Archiving], [SP Office365 Azure User Account], [SP Office365 Azure Account Key], [SP Office365 Tenant Url], [SP Office365 Username], [SP Office365 Password], [MSCloud Region Type], [Sharepoint Modern Auth], [SP Additional Office365 Accounts], [Sharepoint Azure Connections], [Sharepoint Service Accounts], [SharePoint Tenant Name], [SharePoint Discovery State])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	--Get DB2 backupset properties
	UPDATE #i_backupList
	SET
		dB2SQLConnect = ISNULL([DB2 SQL Connect], N''),
		dB2DBStatus = ISNULL([DB2 DB Status], 0),
		dB2DefaultIndexSP = ISNULL([DB2 Default Index SP], 0),
		dB2DefaultIndexSPName = ISNULL((SELECT name FROM ArchGroup WHERE id = ISNULL([DB2 Default Index SP], 0)), N''),
		dB2DefaultCommandSP = ISNULL([DB2 Default Command SP], 0),
		dB2DefaultCommandSPName = ISNULL((SELECT name FROM ArchGroup WHERE id = ISNULL([DB2 Default Command SP], 0)), N''),
		dB2CatalogPartitionNumber = ISNULL([DB2 Catalog Partition Number], 0),
		useSQLConnect = ISNULL([use SQL Connect], 0),
		dB2AutoStorage = ISNULL([DB2 Auto Storage], 0)
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.backupsetType = 'db2BackupSet'
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([DB2 SQL Connect], [DB2 DB Status], [DB2 Default Index SP], [DB2 Default Command SP], [DB2 Catalog Partition Number],
										[use SQL Connect], [DB2 Auto Storage])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	--Get cloud connector backupset properties
	UPDATE #i_backupList
	SET
		cc_isAutoDiscoveryEnabled = ISNULL([Cloud Connector Auto Discovery], 0),
		cc_isEnterpriseFlag = ISNULL([Cloud Connector Enterprise BackupSet], 0),
		cc_provider = ISNULL([Cloud Connector Provider], 0),
		cc_assocUserName = ISNULL([Enterprise Admin User Name], N''),
		cc_userId = ISNULL([Enterprise User Id], N''),
		cc_domainName = ISNULL([Enterprise Domain Name], N''),
		cc_emailID = ISNULL([Enterprise email Id], N''),
		cc_appClientId = ISNULL([Enterprise App client Id], N''),
		cc_appEmailId = ISNULL([Enterprise App Email Id], N''),
		cc_appKey = ISNULL([Enterprise App Key], N'')
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.backupsetType = 'cloudconnectorBackupset'
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([Cloud Connector Auto Discovery], [Cloud Connector Enterprise BackupSet], [Cloud Connector Provider],
			[Enterprise Admin User Name], [Enterprise User Id], [Enterprise Domain Name], [Enterprise email Id], [Enterprise App client Id],
			[Enterprise App Email Id], [Enterprise App Key])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	--Get SAP HANA backupset properties
	UPDATE	#i_backupList
	SET
		hanaUseHdbUserStoreKey = ISNULL([Is Using HDB Store Key], 0),
		hanaHdbUserStoreKey = ISNULL([HDB User Store Key], N''),
		hanaDbInstanceNumber = ISNULL([DB Instance Number], N''),
		hanaSapHANAUser = ISNULL([User Name], N''),
		hanadbUser = ISNULL([DB User Name], N'')
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.backupsetType = 'sapHanaBackupset'
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([DB Instance Number], [Is Using HDB Store Key], [DB User Name],
			[HDB User Store Key], [User Name])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
	UPDATE	#i_backupList
	SET
		hanaCmdlineSP = (SELECT A.dataArchGrpId FROM APP_Application A WHERE A.backupSet = B.backupsetId AND A.subclientStatus = 0x0040),
		hanaLogSP = (SELECT A.logArchGrpID FROM APP_Application A WHERE A.backupSet = B.backupsetId AND A.subclientStatus = 0x1000)
	FROM #i_backupList B
	--Get salesforce backupset properties
	UPDATE #i_backupList
	SET
		clEnableREST = ISNULL([Salesforce Enable REST], 0),
		clDownloadCachePath = ISNULL([Salesforce Download Cache Path], N''),
		clUserName = ISNULL([Salesforce username], N''),
		clSyncDatabase = ISNULL([Salesforce Sync Database], N''),
		clDbRetentionDays = ISNULL([Salesforce Catalog DB Retention Days], 3650),
		clEnableCatDbPurging = ISNULL([Salesforce Catalog DB Purging], 0),
		clMutualAuthCertPath = ISNULL([Salesforce Mutual Auth Certificate], N'')
	FROM
	(
		SELECT  componentNameId, attrName, attrVal FROM APP_BackupSetProp prop
		INNER JOIN #i_backupList bkpList ON bkpList.backupsetId = prop.componentNameId
		AND prop.modified = 0 AND bkpList.backupsetType = 'cloudAppsBackupset'
	) AS backupSetProp
	PIVOT
	(
		MAX(attrVal) FOR attrName IN ([Salesforce username], [Salesforce Enable REST], [Salesforce Download Cache Path],
			[Salesforce Sync Database], [Salesforce API token], [Salesforce Catalog DB Retention Days], [Salesforce Catalog DB Purging],
			[Salesforce Mutual Auth Certificate])
	) AS P
	WHERE #i_backupList.backupsetId = componentNameId
END --IF propertyLevel >= 20
IF @propertyLevel >= 30 --All properties
BEGIN
	DECLARE @bkpSetSecurityOld XML
	DECLARE @bkpSetSecurityNEW XML
	DECLARE @r_clientId INT
	DECLARE @r_appTypeId INT
	DECLARE @r_instanceId INT
	DECLARE @r_backupSetId INT
	DECLARE @r_isIndexingv2 INT
	DECLARE @r_isUseBlockLevelBackup INT
	DECLARE @backupSetCur CURSOR
    SET @backupSetCur = CURSOR FOR (SELECT clientId, appTypeId, instanceId, backupsetId FROM #i_backupList)
        OPEN @backupSetCur
            FETCH NEXT FROM @backupSetCur INTO @r_clientId, @r_appTypeId, @r_instanceId, @r_backupSetId
            WHILE @@FETCH_STATUS = 0
            BEGIN
					SET @bkpSetSecurityOld = (SELECT
												 @r_appTypeId as '@applicationId',
												 @r_backupsetId as '@backupsetId',
												 @r_clientId as '@clientId',
												 @r_instanceId as '@instanceId'
												 FOR xml PATH('entity'))
					EXEC [dbo].[APPGetEntitySecurityXML] @bkpSetSecurityOld OUTPUT
                    SET @bkpSetSecurityNEW = ''
                    EXEC [dbo].[sec_getSecurityForEntity] @userId, @bkpSetSecurityNEW OUTPUT, 3, @r_clientId, 4, @r_appTypeId, 5, @r_instanceId, 6, @r_backupSetId
					SET @r_isIndexingv2 = ( SELECT attrVal FROM App_ClientProp WHERE componentNameId = @r_clientId and attrName = dbo.GetIndexingV2PropNameByAppType(@r_appTypeId) and modified=0 )
					DECLARE @i_getIndexingVersion XML
					DECLARE @o_getIndexingVersion XML
					IF @r_isIndexingv2 IS NULL
					BEGIN
						SET @i_getIndexingVersion = N'<Indexing_GetIndexingVersionReq clientId = "'+ CONVERT(varchar(10), @r_clientId) +'" backupsetId = "'+CONVERT(varchar(10), @r_backupSetId) +'" appTypeOverride= "' +CONVERT(varchar(10), @r_appTypeId) +'"/>'
						EXEC dbo.AppGetIndexingVersionForThisClient @i_getIndexingVersion , @o_getIndexingVersion OUTPUT
						IF ( @o_getIndexingVersion.value('(/Indexing_GetIndexingVersionResp/@indexingVersionId)[1]','int') = 2  )
							SET @r_isIndexingv2 = 1
						ELSE
							SET @r_isIndexingv2 = 0
					END
					SET @r_isUseBlockLevelBackup = ISNULL(( SELECT COUNT(*) FROM APP_SubClientProp P
															JOIN APP_Application A
															ON A.id = P.componentnameid
															WHERE backupSet = @r_backupSetId AND P.attrName = 'Use block level backup' AND P.modified = 0 AND P.attrVal = '1') , 0 )
                    UPDATE #i_backupList
                    SET backupsetSecurityNew = @bkpSetSecurityNEW, backupsetSecurityOld = @bkpSetSecurityOld, isIndexingv2 = @r_isIndexingv2, isUseBlockLevelBackup = @r_isUseBlockLevelBackup
                    WHERE backupsetId = @r_backupSetId
					IF @propertyLevel >= 40 --ExtendedProperties1
					BEGIN
						DECLARE @outputXML XML
						DECLARE @inputXML XML = (SELECT
												(SELECT
													(SELECT @userId AS '@userId'
													FOR xml PATH('user'), TYPE),
													(SELECT @localeId AS '@localeId'
													FOR xml PATH('locale'), TYPE)
													FOR xml PATH('processinginstructioninfo'), TYPE),
												(SELECT
													(SELECT
														7 AS '@_type',
														 @r_appTypeId as '@applicationId',
														 @r_backupsetId as '@backupsetId',
														 @r_clientId as '@clientId',
														 @r_instanceId as '@instanceId'
														 FOR xml PATH('entity'), TYPE)
													FOR xml PATH('association'), TYPE),
												(SELECT 10 AS '@propertyLevel'
													FOR xml PATH('filterOptions'), TYPE),
												(SELECT 1 AS '@includeDetailsFSResponse'
													FOR xml PATH('extendedFilter'), TYPE)
												  FOR xml PATH('App_GetSubClientPropertiesRequest'), TYPE)
						EXEC APPGetSubclientPropertiesWithOutputParam @inputXML, @userId, @localeId, 4 /*SUB_CLIENT_OPERATION_GET*/, @outputXML OUTPUT
						-- There is difference in XML object of App_GetSubClientPropertiesResponse and App_GetBackupsetPropertiesResponse
						SET @outputXML = REPLACE(REPLACE(CAST(@outputXML AS NVARCHAR(MAX)), '</subClientProperties>', '</subClientList>'), '<subClientProperties>', '<subClientList>')
						UPDATE #i_backupList
							SET subclientList = @outputXML
							WHERE backupsetId = @r_backupSetId
					END
				CONTINUE_NEXT_BACKUPSET:
                FETCH NEXT FROM @backupSetCur INTO @r_clientId, @r_appTypeId, @r_instanceId, @r_backupSetId
            END--END cursor fetch loop
		CLOSE @backupSetCur
        DEALLOCATE @backupSetCur
END--All properties
--Construct fs backupset properties xml
	UPDATE T
	SET
		T.fsBackupSetProps = (SELECT
								(SELECT  S.useArchiveBit '@useArchiveBit',
											S.preserveFileAccessTimes '@preserveFileAccessTimes',
											S.netAppImageBackup '@netAppImageBackup',
											S.useDCserviceForScan '@useDCserviceForScan',
											S.useChangeJournal '@useChangeJournal',
											S.pre70SystemStateArchiveFilesExist '@pre70SystemStateArchiveFilesExist',
											S.fLRrepSetId '@fLRrepSetId',
											S.flrRepSetName '@flrRepSetName',
											S.isIndexingv2 '@isIndexingV2',
											S.isTrueUpOptionEnabledForOnePass '@isTrueUpOptionEnabledForOnePass',
											S.runTrueUpJobAfterDaysForOnePass '@runTrueUpJobAfterDaysForOnePass',
											S.customApplicationType '@customApplicationType',
											S.isUseBlockLevelBackup '@isUseBlockLevelBackup',
											S.isAdAppAwareBackupSet '@isAdAppAwareBkpSet',
											S.hasBackupSystemStateSubclient '@hasBackupSystemStateSubclient',
											S.hasOneTouchSubclient '@hasOneTouchSubclient',
											S.hadoopAppType '@hadoopAppType'
								FOR xml PATH('fsBackupSet')))
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId AND T.backupsetType = 'fsbackupset'
--NULLIFY empty fsBackupSet
	DECLARE @fsBkpSet XML = '<fsBackupSet />'
	UPDATE #i_backupList
	SET fsBackupSetProps = NULL
	WHERE DATALENGTH (fsBackupSetProps) = DATALENGTH (@fsBkpSet)
--NULLIFY empty ibmBackupSet
	DECLARE @ibmBkpSet XML = '<ibmBackupset />'
	UPDATE #i_backupList
	SET ibmBackupSetProps = NULL
	WHERE DATALENGTH (ibmBackupSetProps) = DATALENGTH (@ibmBkpSet)
--Construct exchange backupset properties xml
	UPDATE T
	SET
		T.exchangeBackupSetProps = (SELECT
										(SELECT  S.activeDirectoryGroupAutoDiscover '@activeDirectoryGroupAutoDiscover',
													S.activeDirectoryWildCardAutoDiscover '@activeDirectoryWildCardAutoDiscover',
													S.dCDBFileLocation '@dCDBFileLocation' ,
													S.exchangeEnableDiscovery '@enableDiscovery',
													S.storageGroupAutoDiscover '@storageGroupAutoDiscover',
													(
														SELECT S.exchangeOnePassBackupsetType '@backupsetType'
														for xml path('onePassBackupSetProp'), type
													)
										FOR xml PATH('exchangeBackupSet')))
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId AND T.backupsetType = 'exchangeBackupSet'
--NULLIFY empty exchangeBackupSet
	DECLARE @exchBkpSet XML = '<exchangeBackupSet />'
	UPDATE #i_backupList
	SET exchangeBackupSetProps = NULL
	WHERE DATALENGTH (exchangeBackupSetProps) = DATALENGTH (@exchBkpSet)
--Construct Sharepoint backupset properties xml
	Update #i_backupList
	set
	additionalUserAccounts =(select ua.value('@userName','nvarchar(max)') as '@userName' from
									(select additionalUserAccounts from #i_backupList) UAPROP
									Cross apply UAPROP.additionalUserAccounts.nodes('App_SPAdditionalOffice365Credentials/additionalOffice365Credentials')p(ua)
									for xml path('additionalOffice365Credentials'),type),
	serviceAccountsXml =  (SELECT po.query('.') FROM
                                    (select serviceAccountsXml from #i_backupList) PROP
                                    CROSS APPLY PROP.serviceAccountsXml.nodes('./App_SharepointServiceAccounts/accounts') P(po)
                                    FOR XML PATH(''),TYPE),
	azureAppsXml =   (SELECT po.query('.') FROM
                                    (select azureAppsXml from #i_backupList) PROP
                                    CROSS APPLY PROP.azureAppsXml.nodes('./App_Office365AzureConnections/azureApps') P(po)
                                    FOR XML PATH(''),TYPE)
							where #i_backupList.backupsetId = @inBackupSetId and backupsetType = 'sharepointBackupSet'
	UPDATE #i_backupList
		SET serviceAccountsXml = '<App_SharepointServiceAccounts></App_SharepointServiceAccounts>'
	WHERE serviceAccountsXml IS NULL
	UPDATE #i_backupList
	SET azureAppsXml = '<App_Office365AzureConnections></App_Office365AzureConnections>'
	WHERE azureAppsXml IS NULL
	UPDATE #i_backupList
		SET azureAppsXml.modify('delete //@azureAppKeyValue'),
		serviceAccountsXml.modify('delete //@password')
WHERE appTypeId = 78
	UPDATE T
	SET
		T.sharePointBackupSetProps = (SELECT  S.spBackupsetType '@sharepointBackupSetType',
												S.v2Backupset '@forceUseOfV2APIs',
												S.isEnableArchiving '@enableArchiving',
												S.isEnableTier1Archiving '@enableTier1Archiving',
													(SELECT S.azureUserAccount '@azureUserAccount',
													--S.azureAccountKey '@azureAccountKey',
													S.tenantUrlItem '@tenantUrlItem',
													S.msCloudRegion '@cloudRegion',
													S.modernAuthEnabled '@isModernAuthEnabled',
													S.tenantName '@tenantName',
													(SELECT S.serviceAccountsXml as serviceAccounts FOR XML PATH(''),TYPE),
													(SELECT S.azureAppsXml as azureAppList FOR XML PATH(''),TYPE),
													(select S.additionalUserAccounts as additionalCredentials
															FOR XML PATH(''),TYPE),
													-- 9/30/2020, OVK: Matching OneDrive pattern - values in nodes, not attributes
													(SELECT
													   	S.discoverState.value('(App_Office365DiscoverState/@discoveredSites)[1]','int') as 'discoveredSites',
														S.discoverState.value('(App_Office365DiscoverState/@discoveryProgress)[1]','int') as 'discoveryProgress',
														S.discoverState.value('(App_Office365DiscoverState/@discoveryStatus)[1]','int') as 'discoveryStatus',
														S.discoverState.value('(App_Office365DiscoverState/@errorCode)[1]','int') as 'errorCode',
														S.discoverState.value('(App_Office365DiscoverState/@errorMessage)[1]','nVARCHAR(max)') as 'errorMessage',
														S.discoverState.value('(App_Office365DiscoverState/@errorTimestamp)[1]','varchar(125)') as 'errorTimestamp',
														S.discoverState.value('(App_Office365DiscoverState/@lastCacheSiteCount)[1]','int') as 'lastCacheSiteCount',
														S.discoverState.value('(App_Office365DiscoverState/@lastCacheUpdateTime)[1]','int') as 'lastCacheUpdateTime',
														S.discoverState.value('(App_Office365DiscoverState/@lastCacheSubsiteCount)[1]','int') as 'lastCacheSubsiteCount',
														S.discoverState.value('(App_Office365DiscoverState/@discoveredSubsites)[1]','int') as 'discoveredSubsites',
														S.discoverState.value('(App_Office365DiscoverState/@totalSites)[1]','int') as 'totalSites'
													FOR XML PATH('discoverState'),TYPE),
													(SELECT S.azureUsername '@userName'
														--azurePassword '@password'
														FOR xml PATH('office365Credentials'),TYPE)
													FOR xml PATH('spOffice365BackupSetProp'),TYPE)
										FOR xml PATH('sharepointBackupSet'))
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId AND T.backupsetType = 'sharepointBackupSet'
--NULLIFY empty sharepointBackupSet
	DECLARE @sharepointBkpSet XML = '<sharepointBackupSet />'
	UPDATE #i_backupList
	SET sharePointBackupSetProps = NULL
	WHERE DATALENGTH (sharePointBackupSetProps) = DATALENGTH (@sharepointBkpSet)
--Construct DB2 backupset properties xml
	UPDATE T
	SET
		T.db2BackupSetProps = (	SELECT  S.dB2DBStatus '@dB2DBStatus',
											S.dB2CatalogPartitionNumber '@dB2CatalogPartitionNumber',
											S.dB2AutoStorage '@dB2AutoStorage',
											S.useSQLConnect '@useSQLConnect',
											S.dB2DefaultIndexSP 'dB2DefaultIndexSP/@storagePolicyId',
											S.dB2DefaultIndexSPName 'dB2DefaultIndexSP/@storagePolicyName',
											S.dB2DefaultCommandSP 'dB2DefaultCommandSP/@storagePolicyId',
											S.dB2DefaultCommandSPName 'dB2DefaultCommandSP/@storagePolicyName',
											S.dB2SQLConnect 'db2SqlConnectInfo/@userName'
								FOR xml PATH('db2BackupSet'))
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId AND T.backupsetType = 'db2BackupSet'
--NULLIFY empty DB2
	DECLARE @db2BkpSet XML = '<db2BackupSet />'
	UPDATE #i_backupList
	SET db2BackupSetProps = NULL
	WHERE DATALENGTH (db2BackupSetProps) = DATALENGTH (@db2BkpSet)
--Construct cloud connector backupset properties xml
	UPDATE T
	SET
		T.cloudConnectorBackupSetProps =(SELECT  S.cc_isAutoDiscoveryEnabled '@isAutoDiscoveryEnabled',
													S.cc_isEnterpriseFlag '@isEnterpriseBS',
													S.cc_provider '@provider',
													S.cc_assocUserName '@associatedUsername',
													S.cc_userId '@userId',
													S.cc_domainName '@domainName',
													S.cc_emailID '@emailID',
													S.cc_appClientId '@appClientId',
													S.cc_appEmailId '@appEmailId',
													S.cc_appKey '@appKey'
											FOR xml PATH('cloudconnectorBackupSet'))
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId AND T.backupsetType = 'cloudconnectorBackupset'
--NULLIFY empty CloudConnector
	DECLARE @ccBkpSet XML = '<cloudconnectorBackupSet />'
	UPDATE #i_backupList
	SET cloudConnectorBackupSetProps = NULL
	WHERE DATALENGTH (cloudConnectorBackupSetProps) = DATALENGTH (@ccBkpSet)
--Construct Cloud Apps backupset properties xml
	UPDATE T
	SET
		T.cloudAppsBackupSetProps = (	SELECT 3 AS '@instanceType',
											(SELECT  S.clEnableREST '@enableREST',
											S.clDownloadCachePath '@downloadCachePath',
											S.clDbRetentionDays '@dbRetentionDays',
											S.clEnableCatDbPurging '@enableCatDBPurging',
											S.clMutualAuthCertPath '@mutualAuthPath',
											S.clUserName 'userPassword/@userName',
												(SELECT S.clSyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbEnabled)', 'integer') AS '@dbEnabled',
													S.clSyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbHost)', 'NVARCHAR(MAX)') AS '@dbHost',
													S.clSyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbInstance)', 'NVARCHAR(MAX)') AS '@dbInstance',
													S.clSyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbName)', 'NVARCHAR(MAX)') AS '@dbName',
													S.clSyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbPort)', 'integer') AS '@dbPort',
													S.clSyncDatabase.value('(/App_SalesforceSyncDatabase[1]/@dbType)', 'integer') AS '@dbType',
													S.clSyncDatabase.value('/App_SalesforceSyncDatabase[1]/dbUserPassword[1]/@userName', 'NVARCHAR(MAX)') AS 'dbUserPassword/@userName'
													FOR XML PATH('syncDatabase'), TYPE)
											FOR XML PATH('salesforceBackupSet'), TYPE)
									FOR XML PATH('cloudAppsBackupset'))
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId AND T.backupsetType = 'cloudAppsBackupset'
--NULLIFY empty CloudApps
	DECLARE @cloudAppsBkpSet XML = '<cloudAppsBackupset />'
	UPDATE #i_backupList
	SET cloudAppsBackupSetProps = NULL
	WHERE DATALENGTH (cloudAppsBackupSetProps) = DATALENGTH (@cloudAppsBkpSet)
--Construct SAP HANA backupset properties xml
	UPDATE T
	SET
		T.sapHANABackupsetProps = (	SELECT	S.backupSetName AS '@databaseName',
											S.hanaUseHdbUserStoreKey AS '@isUseHDBStoreKey',
											S.hanaHdbUserStoreKey AS '@hdbuserstorekey',
											S.hanaDbInstanceNumber AS '@dbInstanceNumber',
											S.hanadbUser AS 'dbUser/@userName',
											S.hanaSapHANAUser AS 'SAPHANAUser/@userName',
											S.hanaLogSP	AS 'saphanaStorageDevice/logBackupStoragePolicy/@storagePolicyId',
											S.hanaCmdlineSP AS 'saphanaStorageDevice/commandLineStoragePolicy/@storagePolicyId'
									FOR XML PATH('sapHanaBackupset'))
	FROM #i_backupList T
	INNER JOIN #i_backupList S
	ON T.backupsetId = S.backupsetId AND T.backupsetType = 'sapHanaBackupset'
	--NULLIFY empty HANA properties
	DECLARE @sapHanaBkpSet XML = '<sapHanaBackupset />'
	UPDATE #i_backupList
	SET sapHANABackupsetProps = NULL
	WHERE DATALENGTH (sapHANABackupsetProps) = DATALENGTH (@sapHanaBkpSet)
DECLARE @backupsetXML XML = (SELECT
								(SELECT	BackupSetListTBL.modifiedTime AS '@modifiedTime',
								BackupSetListTBL.isContentFromPlan AS '@isContentFromPlan',
								BackupSetListTBL.lastBackupTime AS '@lastBackupTime',
								BackupSetListTBL.applicationSize AS '@applicationSize',
								BackupSetListTBL.dedupeRatio    AS '@dedupeRatio',
								BackupSetListTBL.sizeOnMedia    AS '@sizeOnMedia',
								BackupSetListTBL.totalBackupSize    AS '@totalBackupSize',
								BackupSetListTBL.firstBackupTime AS '@firstBackupTime',
								@scIdxEnabled AS '@scIdxEnabled',
										(SELECT
											appTypeName AS '@appName',
											appTypeId AS '@applicationId',
											backupsetId AS '@backupsetId',
											backupSetName AS '@backupsetName',
											clientId AS '@clientId',
											clientName AS '@clientName',
											clientDisplayName as '@displayName',
											instanceId AS '@instanceId',
											dbo.EncodeInvalidXMLChar(instanceName) AS '@instanceName',
											6 AS '@_type_'
											,guid as '@backupsetGUID'
										FROM #i_backupList BackupSetEntitiesTBL
										WHERE BackupSetEntitiesTBL.backupsetId = BackupSetListTBL.backupsetId
										FOR XML PATH('backupSetEntity'), TYPE),
										BackupSetListTBL.commonBackupSetProps.query('/commonBackupSet'),
										BackupSetListTBL.fsBackupSetProps.query('/fsBackupSet'),
										BackupSetListTBL.exchangeBackupSetProps.query('/exchangeBackupSet'),
										BackupSetListTBL.sharePointBackupSetProps.query('/sharepointBackupSet'),
										BackupSetListTBL.db2BackupSetProps.query('/db2BackupSet'),
										BackupSetListTBL.cloudConnectorBackupSetProps.query('/cloudconnectorBackupSet'),
										BackupSetListTBL.cloudAppsBackupSetProps.query('/cloudAppsBackupset'),
										BackupSetListTBL.sapHANABackupsetProps.query('/sapHanaBackupset'),
										BackupSetListTBL.ibmBackupSetProps.query('/ibmBackupset'),
										BackupSetListTBL.backupsetSecurityOld AS 'backupsetSecurity',
										BackupSetListTBL.backupsetSecurityNew AS 'securityAssociations',
										BackupSetListTBL.subclientList.query('/App_GetSubClientPropertiesResponse/*'),
                                        (SELECT BackupSetListTBL.planId AS '@planId',
                                            BackupSetListTBL.planType AS '@planType',
                                            BackupSetListTBL.planSubType AS '@planSubtype',
                                            BackupSetListTBL.planName AS '@planName'
                                                FOR XML PATH('planEntity'),TYPE),
										--index settings
										-- current index server and list of MAs that qualify as index server for this backupset
										(CASE WHEN @scIdxEnabled = 0 THEN
										(SELECT @pruningEnabled AS '@isPruningEnabled',
										 BackupSetListTBL.indexPruning AS '@overrideIndexPruning',
										 BackupSetListTBL.retDays AS '@indexRetDays',
										 BackupSetListTBL.retCycles AS '@indexRetCycle',
										 BackupSetListTBL.pruningType AS '@indexPruningType',
										 BackupSetListTBL.indexServer.query('/currentIndexServer'),
										 BackupSetListTBL.indexMAs.query('/indexMAs/qualifyingIndexServers'),
										 BackupSetListTBL.indexBkpSp.query('/currentIndexBackupSP'),
										 BackupSetListTBL.indexBkpEligibleSPs.query('/indexBackupSPs/eligibleIndexBackupSP')
										 FOR XML PATH ('indexSettings'), TYPE) END),
										 ISNULL((SELECT [@path] = CASE WHEN (type = 1 AND isSubclientPolicyContent = 0) THEN content END,
										 [@subclientPolicyPath] = CASE WHEN (type = 1 AND isSubclientPolicyContent = 1) THEN content END,
										 [@excludePath] = CASE WHEN (type = 3 AND isSubclientPolicyContent = 0) THEN content END,
										 [@subclientPolicyExcludePath] = CASE WHEN (type = 3 AND isSubclientPolicyContent = 1) THEN content END
										 FROM (SELECT dbo.EncodeInvalidXMLChar(content) AS content , type, isSubclientPolicyContent
											from @FSContentInfo where backupsetId = BackupSetListTBL.backupsetId) T1
											for xml path ('content'), type), '<content/>')
									FROM #i_backupList BackupSetListTBL
									WHERE BackupSetListTBL.backupsetId = backupSetEntitesMain.backupsetId
								FOR XML PATH('backupsetProperties'), TYPE)
							FROM #i_backupList AS backupSetEntitesMain ORDER BY backupsetId ASC
							FOR XML PATH(''), type)
SET @errorXML = (SELECT errorString as '@errorString',
							errorCode as '@errorCode',
							(SELECT clientid as '@clientId',
									clientName as '@clientName',
									backupsetId AS '@backupsetId',
									backupsetName AS '@backupsetName',
									instanceId AS '@instanceId',
									instanceName AS '@instanceName',
									applicationId AS '@applicationId',
									appName AS '@appName'
									FOR XML PATH('entity'),TYPE)
					 FROM @ErrorTable
					 FOR XML PATH('errors'),TYPE)
SET @backupsetXML = (SELECT @backupsetXML,@errorXML
							FOR XML PATH(''), ROOT('App_GetBackupsetPropertiesResponse'))
SELECT @backupsetXML
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetBackupSetProperties')
	delete from GxQscripts where name = 'APPGetBackupSetProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetBackupSetProperties')
	delete from GXDBVersions where aliasname = 'APPGetBackupSetProperties'
GO

insert into GXDBVersions values(2, 'APPGetBackupSetProperties',  '00010033000200750000', 'APPGetBackupSetProperties', '00010033000200750000')
GO

