

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetApplicationLicenses.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetApplicationLicenses.sp,v $ $Id: APPGetApplicationLicenses.sp,v 1.88.2.43 2020/09/25 00:08:45 rshibu Exp $";
--	+===================================================================+
--	| APPGetApplicationLicenses - Get licenses for user					|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetApplicationLicenses')
BEGIN
	print '>>> Drop Stored Procedure: APPGetApplicationLicenses <<<'
	drop procedure APPGetApplicationLicenses
END
IF EXISTS (select * from GxQscripts where name='APPGetApplicationLicenses')
	delete from GxQscripts where name = 'APPGetApplicationLicenses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetApplicationLicenses')
	delete from GXDBVersions where aliasname = 'APPGetApplicationLicenses'
GO
print '... Creating Procedure: APPGetApplicationLicenses'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetApplicationLicenses
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @i_xmlText XML,
  @o_xmlText XML OUTPUT
-----------------------------------------------------------
AS
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
	DECLARE @userId					integer = 0
	DECLARE	@userGUID				VARCHAR(64)
	SET @userGUID = ISNULL (( SELECT ref.value('@userGUID', 'VARCHAR(64)')
							FROM @i_xmlText.nodes ('DM2ContentIndexing_ApplicationLicenseRequest/loginUser') R(ref)), '')
	IF (@userGUID <> '')
	BEGIN
		SET @userId = (SELECT top 1 id FROM UMUsers WHERE userGuid = @userGUID and enabled = 1)
	END
	SET @userId = ISNULL (( SELECT ref.value('@userId', 'INT')
					FROM @i_xmlText.nodes ('DM2ContentIndexing_ApplicationLicenseRequest/loginUser') R(ref)), @userId)
	IF (@userGUID = '' OR @userGUID IS NULL)--VALIDATE USER ID WHEN USER GUID WAS NOT PROVIDED
	BEGIN
		IF NOT EXISTS(SELECT top 1 id FROM UMUsers WHERE id = @userId and enabled = 1)
		BEGIN
				SET @o_xmlText = '<DM2ContentIndexing_ApplicationLicenseResponse/>'
				goto PROC_END
		END
	END
		-----------------------------------------------------------
		--- LOCALS                                              ---
		-----------------------------------------------------------
		DECLARE @errorCode		AS integer					= 0								-- BE OPTIMISTIC
		DECLARE @errorString	AS varchar(2048)			= ''
		DECLARE @brAlertTrace	AS varchar(256)				= (select value from gxglobalParam Where name = 'bralertTrace')
		DECLARE @dateTime		AS DATETIME					= getDate()
		DECLARE	@LAPTOP_BACKUP		INT = 1
DECLARE	@DOWNLOAD			INT = 2
		DECLARE	@VM_PROVISIONING	INT	= 3
		DECLARE	@REPORTS			INT = 4
		DECLARE	@PUSHINSTALL		INT = 5
		DECLARE	@VCENTER			INT = 6
		DECLARE	@COMPLIANCE_SEARCH	INT	= 7
		DECLARE	@DOCUMENTATION		INT	= 8
		DECLARE	@COMMCELL_CONSOLE	INT	= 9
		DECLARE	@CLOUDAPPS			INT	= 10
		DECLARE	@CUSTOMREPORTS		INT	= 11
		DECLARE	@CLIENTREGISTRATION	INT	= 12
		DECLARE @TIMEOFF_CAPABILITY INT = 13  -- 13 bit on CvFeaturesList in GxGlobalParam is being used for Time off.
		DECLARE @TIMESHEET_CAPABILITY INT = 17  -- 17 bit on CvFeaturesList in GxGlobalParam is being used for Time sheet.
		DECLARE @CVDRBACKUP_CAPABILITY INT = 18  -- 18 bit on CvFeaturesList in GxGlobalParam is being used for CV DR Backup.
		DECLARE	@EDC				INT	= 13  -- This is application ID and not capability bit on CvFeaturesList
		DECLARE @COLLABORATIVESHARE_DISABLE_CAPABILITY INT = 14 -- 14th bit on CvFeatureList in GxGlobalParam is being used to hide Collaborative share button.
		DECLARE	@SURVEY			    INT	= 14			-- This is application ID and not capability bit on CvFeaturesList
		DECLARE	@CONFIGURATIONREQUEST INT = 15
		DECLARE	@SYNCREQUEST INT = 16
		DECLARE	@GENERATEAUTHCODE INT = 17
		DECLARE @CVEVENT INT = 18
		DECLARE @MONITORINGCLOUDAPP		INT = 19
		DECLARE	@WORKFLOWFORM INT = 20
		DECLARE	@PSEECG INT = 21
		DECLARE	@DATABASES INT = 23
		DECLARE @PRIVACYCONTROLS INT = 26
		DECLARE @MDM INT = 27
		DECLARE	@LG_NEW_INDIVIDUAL_LICENSE INT = 29
		DECLARE	@LG_MODIFY_INDIVIDUAL_LICENSE INT = 30
		DECLARE	@STORAGE_PROVISIONING INT = 31
		DECLARE @STORAGE_REPLICATION_APP INT = 32
		DECLARE @ANALYTICS INT = 33
		DECLARE	@LG_CAPACITY_LICENSE INT = 34
		DECLARE @VMLABS INT = 38
		declare @WEBCONSOLE_SSO_APP		INT = 39
		DECLARE	@LG_NEW_LICENSE INT = 41
		DECLARE	@LG_MODIFY_LICENSE INT = 42
		DECLARE	@LG_IP_CHANGE_LICENSE INT = 43
		DECLARE	@LG_STAGING_LICENSE INT = 44
		DECLARE	@LG_DELETE_LICENSE INT = 45
		DECLARE	@LG_TRANSFER_LICENSE INT = 46
		DECLARE	@LG_VIEW_LICENSE INT = 47
		DECLARE @LMCLOUDAPP INT = 36
		DECLARE @RECORDSMANAGEMENT INT = 35
		DECLARE @SYSMONITORINGCLOUDAPP INT = 37
		DECLARE @Timeoff INT = 40
		DECLARE @COLLABORATIVESHARE_APP INT = 49
		DECLARE @CVLEGAL_APP INT = 50
		DECLARE @SoftwareStore INT = 51
		DECLARE @Timesheet INT = 52
		DECLARE @AppBuilder INT = 53
		DECLARE @CvDRBackup INT = 54
		DECLARE @WELLNESS_REPORT INT = 55						--If this is set the user can export wellness report
		DECLARE @CloudCapabilities int = 0
		DECLARE @COMMCELLCONSOLE_CAPABILITY INT = 1
		DECLARE @DOCUMENTATION_CAPABILITY INT = 2
		DECLARE @EDC_CAPABILITY INT = 3
		DECLARE @SERVEY_CAPABILITY INT = 4
		DECLARE @CONFIGURATIONREQUEST_CAPABILITY INT = 5
		DECLARE	@DOWNLOAD_HIDECAPABILITY			INT = 6
		DECLARE	@SYNC_HIDECAPABILITY			INT = 7 -- if this is set as 1 do not show sync features
		DECLARE @GENERATEAUTHCODE_CAPABILITY INT = 8
		DECLARE @PSEECG_CAPABILITY INT = 9
		DECLARE @LG_NEW_INDIVIDUAL_LICENSE_VISIBILITY INT = 12
		DECLARE @LG_MODIFY_INDIVIDUAL_LICENSE_VISIBILITY INT = 13
		DECLARE @LG_CAPACITY_LICENSE_VISIBILITY INT = 14
		DECLARE @LG_NEW_LICENSE_VISIBILITY INT = 15
		DECLARE @LG_MODIFY_LICENSE_VISIBILITY INT = 16
		DECLARE @LG_IP_CHANGE_VISIBILITY INT = 17
		DECLARE @LG_STAGING_LICENSE_VISIBILITY INT = 19
		DECLARE @LG_DELETE_LICENSE_VISIBILITY INT = 20
		DECLARE @LG_TRANSFER_LICENSE_VISIBILITY INT = 21
		DECLARE @LG_VIEW_LICENSE_VISIBILITY INT = 22
		DECLARE @WELLNESS_REPORT_CAPABILITY INT = 23
		DECLARE @cvFeatureCapabilities int = 0
		DECLARE @STORAGEREPLICATION_SHOW_CAPABILITY	INT = 10	-- If this is set to show replication app in web console
		DECLARE @COLLABORATIVESHARE_HIDE_CAPABILITY	INT = 14	-- If this is set do not show collaborative share create button in web console
		DECLARE @CVLEGALAPP_SHOW_CAPABILITY	INT = 15			-- If this is set show CVLEGAL app in web console.
		DECLARE @SOFTWARESTORE_HIDE_CAPABILITY	INT = 16		-- If this is set Software Store will be disabled for that user
		DECLARE @APPBUILDER_HIDE_CAPABILITY INT = 17			-- If this is set App Builder will be disabled for that user
		DECLARE @SurveyCapsAtCCGLevel BIGINT = 0
		if @brAlertTrace <> 0
		BEGIN
			DECLARE @input varchar(MAX) = CONVERT(varchar(MAX), @i_xmlText)
			exec br_ntTrace '.. APPGetApplicationLicenses', 0, @dateTime, 0, 0, @input
		END
		BEGIN TRY
			IF OBJECT_ID('tempdb.dbo.#permissionEntities') IS NOT Null DROP TABLE #permissionEntities
			CREATE TABLE #permissionEntities (entityType INT, permissionId INT, PRIMARY KEY(entityType,permissionId))
			----------------------------------------------------------
			---	HERE IS WHERE WE WILL EXTRACT THE XML TO:		   ---
			----------------------------------------------------------
			DECLARE @clientId				integer = 0
			DECLARE	@scope					integer = 1
			DECLARE	@skipContent			integer = 0
			DECLARE	@skipSchedules			integer = 1
			DECLARE @localeId				integer = 0
			DECLARE @appTable				TABLE (app int primary key, isLicense int)
			DECLARE @t_userCaps 			TABLE (caps bigint)
DECLARE @commcellId				INT = 2 --'DEFAULT_COMMCELL_ID
			DECLARE @userCaps 				bigint = 0
			DECLARE @userCapsAtCommcell 	bigint = 0
			DECLARE @userCapsAtForeignCommcell 	bigint = 0
			DECLARE @CvFeaturesList			BIGINT = -1 -- All
			DECLARE @auxApps				XML
			DECLARE	@appLicenses			XML
			------------------------------------------------------------------------------------
			---- CvFeaturesList
			------------------------------------------------------------------------------------
				--SET @DefaultCvFeaturesList = 0
				--SET @DefaultCvFeaturesList = POWER( 2, @LAPTOP_BACKUP - 1)
				--							| POWER( 2, @DOWNLOAD - 1)
				--							| POWER( 2, @VM_PROVISIONING - 1)
				--							| POWER( 2, @DOCUMENTATION - 1)
				--							| POWER( 2, @CLIENTREGISTRATION - 1)
				--							| POWER( 2, @REPORTS- 1)
			------------------------------------------------------------------------------------
			-----------------------------------------------
			--- EXTRACT FROM THE XML					---
			-----------------------------------------------
DECLARE @DefaultCvFeaturesList	INT = 1077968911
SET @CvFeaturesList = ISNULL((SELECT TOP 1 value FROM GXGlobalParam WHERE modified = 0 AND name = N'CvFeaturesList'), @DefaultCvFeaturesList)
--local user
IF OBJECT_ID ('tempdb.dbo.#usersProps') IS NOT NULL
	DROP TABLE #usersProps
CREATE TABLE #usersProps (componentNameId     integer, attrName        nvarchar (1024), attrVal         nvarchar(MAX) )
INSERT INTO #usersProps (componentNameId, attrName , attrVal)
SELECT componentNameId, attrname,    CAST(attrVal AS INT) attrVal
FROM UMUsersProp WITH(NOLOCK) WHERE componentNameId = @userId and modified = 0 and attrName IN(N'Cloud Capabilities',N'cvFeature Capabilities') 	AND ISNUMERIC(attrVal) = 1
--local groups
UNION ALL
SELECT componentNameId, attrname, 	CAST(attrVal AS INT) attrVal
FROM UMGroupsProp ug WITH(NOLOCK)
INNER JOIN  UMUserGroup umgroups WITH(NOLOCK) ON ug.componentNameId=umgroups.groupId and userId=@userid
			WHERE  ug.modified = 0  AND ug.attrName IN(N'Cloud Capabilities',N'cvFeature Capabilities') 	AND ISNUMERIC(attrVal) = 1
--Ad groups
UNION ALL
SELECT componentNameId,  attrname, CAST(attrVal AS INT) attrVal
FROM UMGroupsProp ug WITH(NOLOCK)
INNER JOIN  UMDSGroupMaps maps WITH(NOLOCK) ON ug.componentNameId=maps.umgroupId
INNER JOIN UMUserGroup umdsgroup WITH(NOLOCK) ON umdsgroup.groupId = maps.umDSgroupId AND umdsgroup.userId=@userid
		WHERE  ug.modified = 0  AND ug.attrName IN(N'Cloud Capabilities',N'cvFeature Capabilities') 	AND ISNUMERIC(attrVal) = 1
SELECT	@CloudCapabilities = (@CloudCapabilities | ISNULL(attrVal,0))
	FROM #usersProps WHERE attrName='Cloud Capabilities'
SELECT	@cvFeatureCapabilities = (@cvFeatureCapabilities | ISNULL(attrVal,0))
	FROM #usersProps WHERE attrName='cvFeature Capabilities'
-- CHECK FOR NULL VALUE AS ABOVE QUERY CAN RETURN NULL VALUE
IF @cvFeatureCapabilities IS NULL
	SET @cvFeatureCapabilities = 0
IF @CloudCapabilities IS NULL
	SET @CloudCapabilities = 0
drop table #usersProps
IF OBJECT_ID('tempdb.dbo.#tempAppGetApplicationSecurityObjects') IS NOT Null DROP TABLE #tempAppGetApplicationSecurityObjects
create table  #tempAppGetApplicationSecurityObjects ( [capabilities]  bigint	NOT null, [flag]		  int NOT null default 0, [commCellId]    int	NOT null default 2, [clientGroupId] int	NOT null default 0, [clientId]      int	NOT null default 0, [appTypeId]     int	NOT null default 0, [instanceId]    int	NOT null default 0, [backupsetId]   int	NOT null default 0, [subClientId]   int	NOT null default 0, [mediaAgentId]  int	NOT null default 0, [libraryId]     int	NOT null default 0, [archGroupId]   int	NOT null default 0, [vtContainerId] int	NOT null default 0, [vtPolicyId]    int	NOT null default 0, [vtShelfId]     int	NOT null default 0, [reviewSetId]   int	NOT null default 0, [querySetId]	  int	NOT null default 0, [downloadSetId] int	NOT null default 0, [ermId]   	  int	NOT null default 0, [legalHoldId]   int	NOT null default 0, [tagId]		  int	NOT null default 0, [cdPolicyId]    int	NOT null default 0, [complianceReportId]   int	NOT null default 0, [taskId]        int	NOT null default 0, [workflowId]    int	NOT null default 0, [logMonitoringPolicyId] int	NOT null default 0, [arrayId]       int	NOT null default 0, [cloudId]       int	NOT null default 0, [userGroupId]   int	NOT null default 0, [providerId]    int	NOT null default 0, [entityId1]     int	NOT null default 0, [entityId2]     int	NOT null default 0, [entityId3]     int	NOT null default 0, [entityId4]     int	NOT null default 0, [entityId5]     int	NOT null default 0, [entityId6]     int	NOT null default 0, [entityId7]     int	NOT null default 0, [entityId8]     int	NOT null default 0, [entityId9]     int	NOT null default 0  )
			-- Get the settings till client - commcell and client group
EXEC sec_getUserObjects @userId, 0, 0, '#tempAppGetApplicationSecurityObjects'
			SELECT @userCaps = @userCaps | ISNULL(capabilities,0)
FROM #tempAppGetApplicationSecurityObjects
			SET @userCaps=@userCaps|ISNULL((SELECT TOP(1) caps FROM @t_userCaps), 0)
			SELECT @userCapsAtCommcell = @userCapsAtCommcell | sec.capabilities
FROM #tempAppGetApplicationSecurityObjects sec
				WHERE		commCellId <> 0
							AND clientGroupId = 0 AND clientId = 0 AND appTypeId = 0
							AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0
							AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0
							AND vtPolicyId = 0 AND vtcontainerId = 0 AND vtShelfId = 0
							AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
							AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
							AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
							AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
							AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
							AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
							AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
			IF EXISTS (
				--User Client Association (either direct or using client group) is done for CommCell clients with report management capability
				SELECT sec.clientId
FROM #tempAppGetApplicationSecurityObjects sec
					INNER JOIN APP_Client c WITH (NOLOCK)
						ON c.id = sec.clientId
					INNER JOIN APP_CommCell cc WITH (NOLOCK)
						ON cc.clientId = c.id
				WHERE		commCellId <> 0
							AND sec.clientGroupId = 0 AND sec.clientId <> 0 AND appTypeId = 0
							AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0
							AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0
							AND vtPolicyId = 0 AND vtcontainerId = 0 AND vtShelfId = 0
							AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
							AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
							AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
							AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
							AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
							AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
							AND entityId6=0 AND entityId7=0 AND entityId8=0 AND entityId9=0
							AND (sec.capabilities & CONVERT(bigint, (POWER(2.0, 15.0-1)))) <> 0 --Report Management Capability is enabled
							)
				SET @SurveyCapsAtCCGLevel = 1 --Return as survey enabled for this user
			--Get Foreign Commcell level capablities
			SELECT @userCapsAtForeignCommcell = @userCapsAtForeignCommcell | sec.capabilities
FROM #tempAppGetApplicationSecurityObjects sec
				WHERE		commCellId <> 0
							AND clientGroupId = 0 AND clientId = 0 AND appTypeId = 0
							AND instanceId = 0 AND backupsetId = 0 AND subClientId = 0
							AND mediaAgentId = 0 AND libraryId = 0 AND archGroupId = 0
							AND vtPolicyId = 0 AND vtcontainerId = 0 AND vtShelfId = 0
							AND reviewSetId = 0 AND querySetId = 0 AND downloadSetId = 0
							AND tagId = 0 AND legalHoldId = 0 AND ermId = 0
							AND cdPolicyId = 0 AND complianceReportId = 0 AND taskId = 0
							AND workflowId=0 AND logMonitoringPolicyId=0 AND arrayId=0
							AND cloudId=0 AND userGroupId=0 AND providerId=0 AND entityId1=0
							AND entityId2=0 AND entityId3=0 AND entityId4=0 AND entityId5=0
							AND entityId6<>0 AND entityId7=0 AND entityId8=0 AND entityId9=0
			INSERT INTO #permissionEntities
			exec sec_getpermissionsonentitytype @userId,0
			IF (@CvFeaturesList & POWER(2, @LAPTOP_BACKUP - 1) <> 0) AND
			(   EXISTS(SELECT top 1 1 FROM UMOwnerCredentials WHERE userId = @userId)
OR (@userCaps & CONVERT(bigint, (POWER(2.0, 24-1))) <> 0) -- Used for Mail Box
			)
			BEGIN
				INSERT INTO @appTable
				VALUES (@LAPTOP_BACKUP, 1)
			END
            ELSE IF (@CvFeaturesList & POWER(2, @LAPTOP_BACKUP - 1) <> 0)
            BEGIN
					IF EXISTS (select distinct entitytype from #permissionEntities where permissionid in (65))
					BEGIN
                        INSERT INTO @appTable
                        VALUES (@LAPTOP_BACKUP, 1)
					END
			END
			IF EXISTS   (SELECT 1
						FROM APP_Application APP
						INNER JOIN APP_Client CL
							ON CL.id = APP.clientId AND CL.status & 0x40000000 = 0x40000000 -- Object Store CV_STATUS_SYSTEM_EDGE_DRIVE
						INNER JOIN APP_ClientProp CP
							ON CP.componentNameId = CL.id AND CP.modified = 0 AND CP.attrName = 'System Drive Type' AND CP.attrVal = '3' -- RecordsManager
						INNER JOIN APP_SubClientProp SP
							ON SP.componentNameId = APP.id AND SP.modified = 0 AND SP.attrName = 'Edge Drive User Id' AND SP.attrVal = CAST(@userId AS NVARCHAR(MAX))
						)
			BEGIN
				INSERT INTO @appTable
				VALUES (@RECORDSMANAGEMENT, 1)
			END
			-- Changes as per MR 158383
			-- if logged-in user has download center management permission OR
			-- if at-least one package exists and download center engine is configured then show download center link in web console
			IF (@CvFeaturesList & POWER(2, @DOWNLOAD - 1) <> 0) AND (@CloudCapabilities & POWER(2, @DOWNLOAD_HIDECAPABILITY - 1) <> POWER(2, @DOWNLOAD_HIDECAPABILITY - 1))
			BEGIN
IF (@userCaps & CONVERT(bigint, (POWER(2.0, 41-1))) <> 0) OR
					(EXISTS (SELECT TOP 1 id FROM GxGlobalParam WHERE name = 'DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID') AND EXISTS (SELECT TOP 1 PackageId FROM DCPackages))
				BEGIN
					INSERT INTO @appTable
					VALUES (@DOWNLOAD, 1)
				END
			END
		-- WE DONT NEED TO READ xml FOR EVERYONE AND rAJESH WILL FIX THis as a prop in sp11.11
		DECLARE @vmPolicyRows int = 0 --(SELECT count(id) FROM App_VmAllocationPolicy)
		-- IF (@vmPolicyRows > 1)
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#APPGetApplicationLicenses_VMPolicys') is not null DROP TABLE #APPGetApplicationLicenses_VMPolicys
			CREATE TABLE #APPGetApplicationLicenses_VMPolicys (vpId integer, policyType integer, alive int)
			INSERT INTO #APPGetApplicationLicenses_VMPolicys
			SELECT vp.id, 0 type, vp.alive alive
                           FROM App_VmAllocationPolicy AS VP
                           where dbo.AppCheckVMPolicySecurityPermissions(@userId, VP.id, 0)=1
			SET @vmPolicyRows = @@ROWCOUNT
			-- we should show virtual machines link when a VM is shared with a user even if the user is not part of any policy
			IF (@CvFeaturesList & POWER(2, @VM_PROVISIONING - 1) <> 0)
				AND
				(
@userCapsAtCommcell & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0
					OR
					(@vmPolicyRows > 0)
					OR EXISTS(		SELECT TOP 1 SVM.clientId FROM  sec_getClientOwnersExpandUG  UGA
							INNER JOIN App_VM SVM
							on UGA.clientID = SVM.clientId
							AND SVM.removalTimeStamp is NULL
							AND UGA.userId = @userId)
				)
			BEGIN
				IF (@CvFeaturesList & POWER(2, @VM_PROVISIONING - 1) <> 0)
					INSERT INTO @appTable
					VALUES (@VM_PROVISIONING, 1)
        		-- This will delay only admins
				UPDATE #APPGetApplicationLicenses_VMPolicys
				SET policyType = VP.vxml.value('policy[1]/entity[1]/@policyType','int')
				FROM App_VmAllocationPolicy AS VP
				WHERE VP.id = vpId
				IF EXISTS (SELECT TOP 1 1 FROM #APPGetApplicationLicenses_VMPolicys
				WHERE policyType IN  (1,5,6,12,13) AND alive=1)
						INSERT INTO @appTable
						VALUES (@VMLABS, 1)
			END
			IF (@CvFeaturesList & POWER(2, @VCENTER - 1) <> 0)
			AND
				 (@vmPolicyRows > 0)
			BEGIN
					INSERT INTO @appTable
					VALUES (@VCENTER, 1)
			END
		END
			IF (@CvFeaturesList & POWER(2, @REPORTS - 1) <> 0)
AND (EXISTS(SELECT TOP 1 1 FROM #tempAppGetApplicationSecurityObjects
WHERE capabilities&16384 <> 0) OR @userCapsAtForeignCommcell & CAST(POWER(2.0, 15  - 1) AS bigint) <> 0)
			BEGIN
				INSERT INTO @appTable
				VALUES (@REPORTS, 1)
			END
			--IF NOT EXISTS (SELECT TOP 1 1 FROM @appTable WHERE app = @REPORTS)
			ELSE
			BEGIN
--execute sec_userHasCapability @userId, 0, @o_userHasCapability OUTPUT, 0, 1, '121,122,123,124,125,126,127,128,129,130,131,132'
				IF EXISTS (select distinct entitytype from #permissionEntities where permissionid in (121,122,123,124,125,126,127,128,129,130,131,132))
					INSERT INTO @appTable VALUES (@REPORTS, 1)
			END
			IF (@CvFeaturesList & POWER(2, @STORAGE_PROVISIONING - 1) <> 0)
			BEGIN
IF EXISTS (select distinct entitytype from #permissionEntities where permissionid in (206,207))
				BEGIN
					INSERT INTO @appTable
					VALUES (@STORAGE_PROVISIONING, 1)
				END
			END
IF(@cvFeatureCapabilities & POWER(2, @STORAGEREPLICATION_SHOW_CAPABILITY - 1) = POWER(2, @STORAGEREPLICATION_SHOW_CAPABILITY - 1) OR (@userCapsAtCommcell & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0))
			BEGIN
				INSERT INTO @appTable
				VALUES (@STORAGE_REPLICATION_APP,1)
			END
			IF (@CvFeaturesList & POWER(2, @PUSHINSTALL - 1) <> 0)
			BEGIN
				INSERT INTO @appTable
				VALUES (@PUSHINSTALL, 1)
			END
			IF (@CvFeaturesList & POWER(2, @COMPLIANCE_SEARCH - 1) <> 0)
AND (@userCaps & CONVERT(bigint, (POWER(2.0, 25-1))) <> 0)
			BEGIN
				INSERT INTO @appTable
				VALUES (@COMPLIANCE_SEARCH, 1)
			END
			IF (@CloudCapabilities & POWER(2, @DOCUMENTATION_CAPABILITY - 1) <> 0)
			BEGIN
				INSERT INTO @appTable
				VALUES (@DOCUMENTATION, 1)
			END
			IF (@CloudCapabilities & POWER(2, @COMMCELLCONSOLE_CAPABILITY - 1) <> 0)
				AND ((SELECT value FROM GXGlobalParam WHERE modified = 0 AND name  = N'CommcellConsoleUrl') <> N'')
			BEGIN
				INSERT INTO @appTable
				VALUES (@COMMCELL_CONSOLE, 1)
			END
			IF ((@CvFeaturesList & POWER(2, @CLOUDAPPS - 1) <> 0) AND ((@CloudCapabilities & POWER(2, @EDC_CAPABILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @SERVEY_CAPABILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @CONFIGURATIONREQUEST_CAPABILITY - 1) <> 0) OR  (@CloudCapabilities & POWER(2, @PSEECG_CAPABILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_NEW_INDIVIDUAL_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_MODIFY_INDIVIDUAL_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_CAPACITY_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_NEW_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_MODIFY_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_IP_CHANGE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_STAGING_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_DELETE_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_TRANSFER_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @LG_VIEW_LICENSE_VISIBILITY - 1) <> 0) OR (@CloudCapabilities & POWER(2, @WELLNESS_REPORT_CAPABILITY - 1) <> 0)))
			BEGIN
				INSERT INTO @appTable
				VALUES (@CLOUDAPPS, 1)
				IF (@CloudCapabilities & POWER(2, @EDC_CAPABILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@EDC, 1)
				END
				IF (@CloudCapabilities & POWER(2, @CONFIGURATIONREQUEST_CAPABILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@CONFIGURATIONREQUEST, 1)
				END
				IF (@CloudCapabilities & POWER(2, @PSEECG_CAPABILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@PSEECG, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_NEW_INDIVIDUAL_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_NEW_INDIVIDUAL_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_MODIFY_INDIVIDUAL_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_MODIFY_INDIVIDUAL_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_CAPACITY_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_CAPACITY_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_NEW_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_NEW_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_MODIFY_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_MODIFY_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_IP_CHANGE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_IP_CHANGE_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_STAGING_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_STAGING_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_DELETE_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_DELETE_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_TRANSFER_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_TRANSFER_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @LG_VIEW_LICENSE_VISIBILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@LG_VIEW_LICENSE, 1)
				END
				IF (@CloudCapabilities & POWER(2, @WELLNESS_REPORT_CAPABILITY - 1) <> 0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@WELLNESS_REPORT, 1)
				END
			END
			IF (@CvFeaturesList & CAST(POWER(2.0, @TIMEOFF_CAPABILITY - 1) AS BIGINT)  <> 0)
			BEGIN
				INSERT INTO @appTable
				VALUES (@Timeoff, 1)
			END
			IF (@CvFeaturesList & CAST(POWER(2.0, @TIMESHEET_CAPABILITY - 1) AS BIGINT)  <> 0)
			BEGIN
				INSERT INTO @appTable
				VALUES (@Timesheet, 1)
			END
			IF (@CvFeaturesList & CAST(POWER(2.0, @CVDRBACKUP_CAPABILITY - 1) AS BIGINT)  <> 0)
			BEGIN
				INSERT INTO @appTable
				VALUES (@CvDRBackup, 1)
			END
IF(@SurveyCapsAtCCGLevel = 1 OR @CloudCapabilities & POWER(2, @SERVEY_CAPABILITY - 1) <> 0   OR ((SELECT COUNT(*) fRom simInstalledPackages WHERE simPackageID IN (727,1177)) > 0) AND (@userCapsAtCommcell & CAST(POWER(2.0, 15 - 1) AS bigint) <> 0 or @userCapsAtForeignCommcell & CAST(POWER(2.0, 15 - 1) AS bigint) <> 0))
			BEGIN
					INSERT INTO @appTable
					VALUES (@SURVEY, 1)
			END
			IF (@CvFeaturesList & POWER(2, @CUSTOMREPORTS - 1) <> 0)
AND @userCapsAtCommcell & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0
			BEGIN
IF @userCapsAtCommcell & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0
					INSERT INTO @appTable
					VALUES (@CUSTOMREPORTS, 1)
			END
			IF (@CvFeaturesList & POWER(2, @CLIENTREGISTRATION - 1) <> 0)
AND @userCapsAtCommcell & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0
			BEGIN
					INSERT INTO @appTable
					VALUES (@CLIENTREGISTRATION, 1)
			END
			IF EXISTS (SELECT entityId FROM APP_ADVANCESETTINGS WHERE entityId> 0 AND KeyName='showMDM' AND VALUE LIKE 'true' AND enabled='1')
			BEGIN
IF @userCapsAtCommcell & CAST(POWER(2.0, 1 - 1) AS bigint) <> 0
				OR EXISTS ( SELECT TOP 1 1 FROM UMOwnerCredentials UM INNER JOIN APP_Client C ON C.id = UM.clientId WHERE UM.userId = @userId AND status & 0x40000000 =0x40000000)
			INSERT INTO @appTable
			VALUES (@MDM,1)
			END
			--App Builder check
			/*
			NOTE: The AppBuilder uses a separate globalParam instead of a bit in @cvFeaturesList.
			This can be changed later to use @cvFeaturesList, once we fix any overflows that may be caused by this.
			*/
			DECLARE @isAppBuilderEnabled NVARCHAR(6) = ISNULL((SELECT value FROM GxGlobalParam WITH(NOLOCK) WHERE name = 'isAppBuilderEnabled' and modified = 0), 'true') --AppBuilde is enabled by default
			IF (@isAppBuilderEnabled = 'true')
				AND (@cvFeatureCapabilities & POWER(2, @APPBUILDER_HIDE_CAPABILITY - 1) <> POWER(2, @APPBUILDER_HIDE_CAPABILITY - 1))
			BEGIN
IF(EXISTS (select distinct entitytype from #permissionEntities where permissionid in (230,231,232,233)))
				BEGIN
					INSERT INTO @appTable
					VALUES (@AppBuilder, 1)
				END
				ELSE
				BEGIN
					DECLARE @isUserScheduleAdminForDefaultCommcell INT = 0
EXEC sec_checkPermissionOnEntity @userId, '1', @isUserScheduleAdminForDefaultCommcell OUTPUT, 1, 2
					IF(@isUserScheduleAdminForDefaultCommcell = 1)
					BEGIN
						INSERT INTO @appTable
						VALUES (@AppBuilder, 1)
					END
				END
			END
			-- combine this
			DECLARE @showLMapp INT
			DECLARE @showLMSystemMonitoringApp int
			EXEC LMIsApplicationLicenseValid @userId,1,@showLMApp out
			EXEC LMIsApplicationLicenseValid @userId,2,@showLMSystemMonitoringApp out
			IF(@showLMApp = 1 OR @showLMSystemMonitoringApp=1)
				INSERT INTO @appTable
				VALUES (@MONITORINGCLOUDAPP, 1)
			IF(@showLMapp = 1 )
				INSERT INTO @appTable
				VALUES (@LMCLOUDAPP, 1)
			IF(@showLMSystemMonitoringApp = 1 )
				INSERT INTO @appTable
				VALUES (@SYSMONITORINGCLOUDAPP, 1)
			DECLARE @two bigint =2
			IF object_id('tempdb.dbo.#APPGetApplicationLicenses_WorkflowObjects') is not null DROP TABLE #APPGetApplicationLicenses_WorkflowObjects
			CREATE TABLE #APPGetApplicationLicenses_WorkflowObjects (workflowId INT)
EXEC sec_getNonIdaObjectsForThisUser @userId, 83, 113, '#APPGetApplicationLicenses_WorkflowObjects'
			IF EXISTS (SELECT d.WorkflowId
						FROM WF_Definition d
						WHERE (
									--d.workFlowId IN (SELECT entityType FROM #permissionEntities WHERE entityType IN(0,3) and permissionId = 113)
									d.workFlowId IN (SELECT workflowId FROM #APPGetApplicationLicenses_WorkflowObjects)
								)
						AND d.WorkflowId in (Select WorkflowId From WF_Deploy))
			BEGIN
				INSERT INTO @appTable
				VALUES (@WORKFLOWFORM, 1)
			END
			ELSE
			BEGIN
				IF EXISTS(SELECT 1 FROM dbo.GetUserInteractions(@userId, 0))
				BEGIN
					INSERT INTO @appTable
					VALUES (@WORKFLOWFORM, 1)
				END
			END
			DROP TABLE #APPGetApplicationLicenses_WorkflowObjects
			DROP TABLE #permissionEntities
			IF (@CloudCapabilities & POWER(2, @GENERATEAUTHCODE_CAPABILITY - 1) <> 0 AND (SELECT value FROM GXGlobalParam WHERE name = 'UserRegistration' AND modified=0)=1)
			BEGIN
				INSERT INTO @appTable
				VALUES (@GENERATEAUTHCODE, 1)
			END
			DECLARE		@numOfSqlClients	INT =0
			-- Get the number of SQL clients that the user is owner of
			SET @numOfSqlClients	=  (SELECT      top 1 1
										FROM        UMOwnerCredentials UM WITH(NOLOCK)
										INNER JOIN  APP_IDAName IDA WITH(NOLOCK) ON UM.clientId = IDA.clientId AND IDA.appTypeId in (81) --For MSSQL
										WHERE       UM.userId = @userId )
			--IF (@CvFeaturesList & POWER(2, @DATABASES - 1) <> 0)
			IF ( (@CvFeaturesList & POWER(2, @DATABASES - 1) <> 0) AND (@numOfSqlClients > 0) )
			BEGIN
				INSERT INTO @appTable
				VALUES (@DATABASES, 1)
			END
			-- COLLABORATIVESHARE CHECK
			IF ((@CvFeaturesList & POWER(2, @COLLABORATIVESHARE_DISABLE_CAPABILITY - 1) <> POWER(2, @COLLABORATIVESHARE_DISABLE_CAPABILITY - 1))
				AND (@cvFeatureCapabilities & POWER(2, @COLLABORATIVESHARE_HIDE_CAPABILITY - 1) <> POWER(2, @COLLABORATIVESHARE_HIDE_CAPABILITY - 1))
				AND EXISTS(SELECT DISTINCT 1 from WF_Deploy WD WITH(NOLOCK)
						JOIN WF_Definition WF WITH(NOLOCK) ON WF.WorkflowId = WD.WorkflowId
						WHERE Name = 'Create Collaborative Shares'))
			BEGIN
				INSERT INTO @appTable
				VALUES (@COLLABORATIVESHARE_APP, 1)
			END
			--CVLEGALAPP CHECK
			IF ((@cvFeatureCapabilities & POWER(2, @CVLEGALAPP_SHOW_CAPABILITY - 1) = POWER(2, @CVLEGALAPP_SHOW_CAPABILITY - 1))
				AND EXISTS(SELECT 1 from GXGlobalParam WHERE name = 'CvLegalAppShareId'))
			BEGIN
				INSERT INTO @appTable
				VALUES (@CVLEGAL_APP, 1)
			END
			--Sofware Store CHECK
			IF (NOT EXISTS(SELECT 1 FROM GXGlobalParam WHERE name = 'SWStoreAppDisabled' AND modified = 0 AND value = 'true')
			AND (@cvFeatureCapabilities & POWER(2, @SOFTWARESTORE_HIDE_CAPABILITY - 1) <> POWER(2, @SOFTWARESTORE_HIDE_CAPABILITY - 1)))
			BEGIN
				INSERT INTO @appTable
				VALUES (@SoftwareStore, 1)
			END
IF EXISTS (SELECT id FROM GXGlobalParam WHERE name = '3c8d1ac5575382ed39b961906a331a2ac82766fdcfa15580a' and value = '1' and modified =0)
			BEGIN
IF EXISTS (SELECT id FROM GXGlobalParam WHERE name = (SELECT csGUID FROM App_Commcell where id = 2) and value = '3b43937232ab5b572bf6bb373d33ca779a47427f93c82b196b881417e07eca1db3601baf45fe32f14'
				and modified =0)
				BEGIN
					INSERT INTO @appTable
					VALUES (@PRIVACYCONTROLS,1)
				END
			END
    			--For now, showing Webconsole SSO app to all the users only if Key is set.
			--Will be modified later to a more generalized approach by integrating completely with multicommcell login.
			IF EXISTS (SELECT id FROM GXGlobalParam WHERE name = 'showWebSsoApp' AND value = '1' AND modified =0)
			begin
			INSERT INTO @appTable
				VALUES (@WEBCONSOLE_SSO_APP,1)
			end
EXEC sec_getAuxApplications @userId, 1073741823, @auxApps output,@CvFeaturesList, @CloudCapabilities, @cvFeatureCapabilities
			IF   ISNULL (( SELECT ref.value('@IsEventOrganizer', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/analyticsApplications') R(ref)), 0) = 1
				INSERT INTO @appTable
				VALUES (@CVEVENT,1)
			IF   ISNULL (( SELECT ref.value('@IsFileAnalytics', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/analyticsApplications') R(ref)), 0) = 1
				OR ISNULL (( SELECT ref.value('@IsEmailAnalytics', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/analyticsApplications') R(ref)), 0) = 1
				OR ISNULL (( SELECT ref.value('@IsDataConnector', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/analyticsApplications') R(ref)), 0) = 1
				OR ISNULL (( SELECT ref.value('@IsWebAnalytics', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/analyticsApplications') R(ref)), 0) = 1
					INSERT INTO @appTable
					VALUES (@ANALYTICS,1)
			IF NOT EXISTS (SELECT TOP 1 1 FROM @appTable WHERE app = @LAPTOP_BACKUP)
			BEGIN
			IF  ISNULL (( SELECT ref.value('@IsDriveEnabled', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/myDataApplications') R(ref)), 0) = 1
				OR ISNULL (( SELECT ref.value('@IsSharesEnabled', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/myDataApplications') R(ref)), 0) = 1
				OR ISNULL (( SELECT ref.value('@IsComputersEnabled', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/myDataApplications') R(ref)), 0) = 1
				OR ISNULL (( SELECT ref.value('@IsVMEnabled', 'INT')
							FROM @auxApps.nodes ('auxiliaryAppLicenses/myDataApplications') R(ref)), 0) = 1
				INSERT INTO @appTable
				VALUES (@LAPTOP_BACKUP, 1)
			END
			SET @appLicenses =
				( SELECT app '@application', isLicense '@isLicensed' FROM @appTable
				FOR XML PATH ('applicationLicense'))
			IF @appLicenses IS NULL
				BEGIN
					SET @o_xmlText = '<DM2ContentIndexing_ApplicationLicenseResponse/>'
				END
				ELSE
					set @o_xmlText = (select @appLicenses, @auxApps for xml path(''), root('DM2ContentIndexing_ApplicationLicenseResponse'))
DROP TABLE #tempAppGetApplicationSecurityObjects
		END TRY
		--=====================================================================
		--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
		--=====================================================================
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			--do we need this?
DROP TABLE #tempAppGetApplicationSecurityObjects
			DROP TABLE #APPGetApplicationLicenses_VMPolicys
			SET @errorCode	 = ERROR_NUMBER()
			SET @errorString  = 'Procedure [' + ERROR_PROCEDURE() + '] Error Line [' +Convert(varchar(5), ERROR_LINE()) +']. ' +ERROR_MESSAGE()
			SET @o_xmlText =
					( SELECT	@errorCode			as 'errList/@errorCode',
					@errorString			as 'errList/@errLogMessage'
					FOR XML PATH(''), ROOT('DM2ContentIndexing_GenericResp'))
			--IF (@tranStart  = 1)
			--BEGIN
			--	ROLLBACK TRAN
			--END
		END CATCH
	PROC_END:
	SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetApplicationLicenses')
	delete from GxQscripts where name = 'APPGetApplicationLicenses'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetApplicationLicenses')
	delete from GXDBVersions where aliasname = 'APPGetApplicationLicenses'
GO

insert into GXDBVersions values(2, 'APPGetApplicationLicenses',  '00010088000200430000', 'APPGetApplicationLicenses', '00010088000200430000')
GO

