

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetAgentProperties.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
--
-- ----------------------------------------------------------------------*/
SET NOCOUNT ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPGetAgentProperties')
BEGIN
	print '>>> Drop Stored Procedure: APPGetAgentProperties <<<'
	drop procedure APPGetAgentProperties
END
IF EXISTS (select * from GxQscripts where name='APPGetAgentProperties')
	delete from GxQscripts where name = 'APPGetAgentProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetAgentProperties')
	delete from GXDBVersions where aliasname = 'APPGetAgentProperties'
GO
print '... Creating Procedure: APPGetAgentProperties'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetAgentProperties
  @i_clientId INT,
  @i_appTypeId INT,
  @i_commcellId INT
AS
DECLARE @r_OWAURLList	NVARCHAR(MAX);
DECLARE @r_OnlineCILocationShareName	NVARCHAR(MAX);
DECLARE @r_netHostName	NVARCHAR(MAX);
DECLARE @r_username		NVARCHAR(MAX);
DECLARE @r_NDSTreeName	NVARCHAR(MAX);
DECLARE @r_NTAPDMFilerName	NVARCHAR(MAX);
DECLARE @r_stubLocation	NVARCHAR(MAX);
DECLARE @r_releaseId	INT;
DECLARE @r_ADServerName NVARCHAR(MAX);
DECLARE @r_ADUsername		NVARCHAR(MAX);
DECLARE	@r_DataClassificationTagList	NVARCHAR(MAX);
DECLARE @id		INT;
DECLARE @r_instanceId	INT;
DECLARE @r_stubRetensionTime	NVARCHAR(MAX);
DECLARE @r_OnlineCILocShare		NVARCHAR(MAX);
DECLARE @r_CIOWAUrlList		NVARCHAR(MAX);
DECLARE @r_appTypeFlag	INT;
DECLARE @r_appId	INT;
DECLARE @r_backupLevel	NVARCHAR(MAX);
DECLARE @r_QNetRegStatus	INT=0;
DECLARE @r_AssocEntityID	INT;
DECLARE @r_AssocLevel	INT;
DECLARE @r_ListenPort	INT;
DECLARE @r_FirmwareRevision	NVARCHAR(MAX);
DECLARE @r_Vendor	NVARCHAR(MAX);
DECLARE @r_spVersion NVARCHAR(16);
SET @r_appTypeFlag = 0;
IF	object_id('tempdb.dbo.#TEMP_APP_AGENTEXTPROP') is not null DROP TABLE #TEMP_APP_AGENTEXTPROP
IF	object_id('tempdb.dbo.#TEMP_APP_NDSAGENTPROP') is not null DROP TABLE #TEMP_APP_NDSAGENTPROP
IF	object_id('tempdb.dbo.#TEMP_APP_FSDMAGENTPROP') is not null DROP TABLE #TEMP_APP_FSDMAGENTPROP
IF	object_id('tempdb.dbo.#TEMP_APP_NTAPDMAGENTPROP') is not null DROP TABLE #TEMP_APP_NTAPDMAGENTPROP
IF	object_id('tempdb.dbo.#TEMP_APP_DCAGENTPROP') is not null DROP TABLE #TEMP_APP_DCAGENTPROP
IF	object_id('tempdb.dbo.#TEMP_APP_NETWAREDMPROP') is not null DROP TABLE #TEMP_APP_NETWAREDMPROP
IF	object_id('tempdb.dbo.#TEMP_APP_LNDOCPROP') is not null DROP TABLE #TEMP_APP_LNDOCPROP
IF	object_id('tempdb.dbo.#TEMP_APP_GRANULARADPROP') is not null DROP TABLE #TEMP_APP_GRANULARADPROP
IF	object_id('tempdb.dbo.#TEMP_APP_FLRPROP') is not null DROP TABLE #TEMP_APP_FLRPROP
IF	object_id('tempdb.dbo.#TEMP_APP_SHAREPOINTPROP') is not null DROP TABLE #TEMP_APP_SHAREPOINTPROP
IF	object_id('tempdb.dbo.#TEMP_APP_SHAREPOINTV2PROP') is not null DROP TABLE #TEMP_APP_SHAREPOINTV2PROP
IF	object_id('tempdb.dbo.#TEMP_APP_SHAREPOINTDOCPROP') is not null DROP TABLE #TEMP_APP_SHAREPOINTDOCPROP
IF	object_id('tempdb.dbo.#TEMP_APP_EXCHPUBLICFOLDER') is not null DROP TABLE #TEMP_APP_EXCHPUBLICFOLDER
IF	object_id('tempdb.dbo.#TEMP_APP_EXCHPUBLICFOLDERUSERDEFINED') is not null DROP TABLE #TEMP_APP_EXCHPUBLICFOLDERUSERDEFINED
IF	object_id('tempdb.dbo.#TEMP_APP_SQL61PROP') is not null DROP TABLE #TEMP_APP_SQL61PROP
IF	object_id('tempdb.dbo.#TEMP_APP_ORACLE8PROP') is not null DROP TABLE #TEMP_APP_ORACLE8PROP
IF	object_id('tempdb.dbo.#TEMP_APP_DB2PROP') is not null DROP TABLE #TEMP_APP_DB2PROP
IF	object_id('tempdb.dbo.#TEMP_APP_EXCHDBPROPAGENT') is not null DROP TABLE #TEMP_APP_EXCHDBPROPAGENT
IF	object_id('tempdb.dbo.#TEMP_APP_EXCHDBPROP') is not null DROP TABLE #TEMP_APP_EXCHDBPROP
IF	object_id('tempdb.dbo.#TEMP_APP_NETWAREGROUPWISEPROP') is not null DROP TABLE #TEMP_APP_NETWAREGROUPWISEPROP
IF	object_id('tempdb.dbo.#TEMP_APP_DATAMIGRATORPROP') is not null DROP TABLE #TEMP_APP_DATAMIGRATORPROP
IF	object_id('tempdb.dbo.#TEMP_APP_DATAMIGRATORPROPAGENT') is not null DROP TABLE #TEMP_APP_DATAMIGRATORPROPAGENT
IF	object_id('tempdb.dbo.#TEMP_APP_EXCHARCHIVERPROP ') is not null DROP TABLE #TEMP_APP_EXCHARCHIVERPROP
IF	object_id('tempdb.dbo.#TEMP_APP_EXCHARCHIVERPROPAGENT') is not null DROP TABLE #TEMP_APP_EXCHARCHIVERPROPAGENT
IF	object_id('tempdb.dbo.#TEMP_APP_SHAREPOINTV2DOCPROP') is not null DROP TABLE #TEMP_APP_SHAREPOINTV2DOCPROP
IF	object_id('tempdb.dbo.#TEMP_APP_EXCHMBPROPAGENT') is not null DROP TABLE #TEMP_APP_EXCHMBPROPAGENT
IF	object_id('tempdb.dbo.#TEMP_APP_EXCHMBPROP') is not null DROP TABLE #TEMP_APP_EXCHMBPROP
IF	object_id('tempdb.dbo.#TEMP_APP_FASTTRAXEXCHPROP') is not null DROP TABLE #TEMP_APP_FASTTRAXEXCHPROP
IF	object_id('tempdb.dbo.#TEMP_APP_SHAREPOINTDBPROP') is not null DROP TABLE #TEMP_APP_SHAREPOINTDBPROP
IF	object_id('tempdb.dbo.#TEMP_APP_AZUREADPROP') is not null DROP TABLE #TEMP_APP_AZUREADPROP
DECLARE @nowTime	integer
SET                @nowTime        = dbo.GetUnixTime (GetUTCdate())
SET @id = (SELECT id
			FROM APP_IDAName
			WHERE clientId = @i_clientId
			AND appTypeId = @i_appTypeId)
-- lookupNASProperties
IF @i_appTypeId = 13
BEGIN
	SET @r_username	= ISNULL((SELECT Login FROM MMNDMPHostInfo WHERE ClientId = @i_clientId),N'')
	SET @r_ListenPort = ISNULL((SELECT ListenPort FROM MMNDMPHostInfo WHERE ClientId = @i_clientId),0)
	SET @r_FirmwareRevision = ISNULL((SELECT FirmwareRevision FROM MMNDMPHostInfo WHERE ClientId = @i_clientId),N'')
	SET @r_Vendor = ISNULL((SELECT attrVal FROM APP_ClientProp (NOLOCK) WHERE componentNameId = @i_clientID AND attrName = 'Hardware Info' AND modified = 0), N'')
	SELECT @i_appTypeId,@r_username,N'',@r_ListenPort,@r_FirmwareRevision,@r_Vendor
	RETURN
END
-- lookupNetwareFSProperties
IF @i_appTypeId = 86 OR @i_appTypeId = 12
BEGIN
	SELECT 	ISNULL([fs user id],N'') as Username
	INTO	#TEMP_APP_AGENTEXTPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[fs user id]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_AGENTEXTPROP) = 0
		SELECT @i_appTypeId,@r_username,''
	ELSE
		SELECT @i_appTypeId,@r_username,I.Username
			FROM #TEMP_APP_AGENTEXTPROP	 I
	RETURN
END
-- lookupNDSProperties
IF @i_appTypeId = 10
BEGIN
	SELECT 	ISNULL([fs user id],N'') as Username,
			ISNULL([treename],N'') as NDSTreeName
	INTO	#TEMP_APP_NDSAGENTPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[fs user id],
				[treename]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_NDSAGENTPROP) = 0
		SELECT @i_appTypeId,N'',N''
	ELSE
		SELECT @i_appTypeId,I.Username,I.NDSTreeName
			FROM #TEMP_APP_NDSAGENTPROP	I
	RETURN
END
--lookupNTAPDMProperties
IF @i_appTypeId = 73
BEGIN
	SELECT 	ISNULL([NTAP DM filer name],N'') as NTAPDMFilerName,
			ISNULL([NTAP DM user name],N'') as Username,
			ISNULL([NTAP DM stub location],N'') as stubLocation
	INTO	#TEMP_APP_NTAPDMAGENTPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[NTAP DM filer name],
				[NTAP DM user name],
				[NTAP DM stub location]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_NTAPDMAGENTPROP) = 0
		SELECT @i_appTypeId, N'',N'',N''
	ELSE
		SELECT @i_appTypeId, I.Username, I.NTAPDMFilerName,I.stubLocation
			FROM #TEMP_APP_NTAPDMAGENTPROP I
	RETURN
END
-- lookupFSDataMigratorProperties
IF @i_appTypeId = 58
BEGIN
	SET @r_releaseId = ISNULL((SELECT releaseId
						FROM APP_Client
						WHERE id =  @i_clientId),1)
	IF	@r_releaseId >= 12 -- SIM_ID_GX_REL70
	BEGIN
		SET @r_ADServerName = ISNULL((SELECT attrVal
							FROM APP_IDAProp
							WHERE attrName = 'AD Server Name'
							AND modified = 0
							AND componentNameId = @id),N'')
		SET @r_ADUsername = ISNULL((SELECT attrVal
							FROM APP_IDAProp
							WHERE attrName = 'AD User Name'
							AND modified = 0
							AND componentNameId = @id),N'')
	END
	SELECT 	ISNULL([Proxy File Expiration],N'120') as proxyFileExpiration,
			ISNULL([Proxy File Prune Interval],N'60') as proxyFilePruneInterval,
			ISNULL([Enable NFS Share for EMC],N'0') as isEnableNFSShareForEMC,
			ISNULL([FSDM User Name],N'') as proxyUsername,
			ISNULL([FSDM Enable End User Erase],N'0') as isEndUserEraseEnabled,
			ISNULL([FSDM End User Erase Folder List],N'') as EndUserFolderList
	INTO	#TEMP_APP_FSDMAGENTPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[Proxy File Expiration],
				[Proxy File Prune Interval],
				[Enable NFS Share for EMC],
				[FSDM User Name],
				[FSDM Enable End User Erase],
				[FSDM End User Erase Folder List]
			)
	) AS pvt
--	UPDATE 	#TEMP_APP_FSDMAGENTPROP
--	SET isEnableNFSShareForEMC = (CASE isEnableNFSShareForEMC
--									WHEN '1' THEN 'true'
--									WHEN '0' THEN 'false'
--									ELSE 'false'
--									END),
--
--		isEndUserEraseEnabled = (CASE isEndUserEraseEnabled
--									WHEN '1' THEN 'true'
--									WHEN '0' THEN 'false'
--									ELSE 'false'
--									END)
	IF (SELECT COUNT(*) from #TEMP_APP_FSDMAGENTPROP) = 0
		SELECT @i_appTypeId,@r_releaseId,@r_ADServerName,@r_ADUsername,N'120',
			N'60',N'0',N'',N'0',N''
	ELSE
		SELECT @i_appTypeId,@r_releaseId,@r_ADServerName,@r_ADUsername,I.proxyFileExpiration,
			I.proxyFilePruneInterval,I.isEnableNFSShareForEMC,I.proxyUsername,I.isEndUserEraseEnabled,
			I.EndUserFolderList
			FROM #TEMP_APP_FSDMAGENTPROP I
	RETURN
END
-- lookupDataClassificationProperties
IF @i_appTypeId = 85
BEGIN
	SELECT 	ISNULL([Data Class Meta Data Location],N'') as MetaDataFileLocation,
		ISNULL([Data Class Enabled],N'1') as isDataClassificationEnabled,
		ISNULL([Data Class Online],N'0') as isOnline,
		ISNULL([Data Class Client Priority],N'2') as clientPriority,
		ISNULL([Data Class Update Interval],N'') as updateInterval,
		ISNULL([Data Class Inactive Period],N'0') as InactivityPeriod,
		ISNULL([AD Server Name],N'') as ADServerName,
		ISNULL([AD User Name],N'') as	ADUsername
	INTO	#TEMP_APP_DCAGENTPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[Data Class Meta Data Location],
				[Data Class Enabled],
				[Data Class Online],
				[Data Class Client Priority],
				[Data Class Update Interval],
				[Data Class Inactive Period],
				[AD Server Name],
				[AD User Name]
			)
	) AS pvt
	IF (SELECT updateInterval from #TEMP_APP_DCAGENTPROP) = N''
	BEGIN
		UPDATE #TEMP_APP_DCAGENTPROP
		SET updateInterval = ISNULL((SELECT value
									FROM GxGlobalParam
									WHERE name = 'Data Classification Update Interval Minutes' AND modified = 0),N'')
--			isDataClassificationEnabled = (CASE isDataClassificationEnabled
--									WHEN '1' THEN 'true'
--									WHEN '0' THEN 'false'
--									ELSE 'false'
--									END),
--
--			isOnline = (CASE isOnline
--									WHEN '1' THEN 'true'
--									WHEN '0' THEN 'false'
--									ELSE 'false'
--									END)
		IF (SELECT updateInterval from #TEMP_APP_DCAGENTPROP) = N''
		BEGIN
		    Insert into GXGlobalParam(name, value, created, modified) VALUES ('Data Classification Update Interval Minutes','5', @nowTime, 0)
			UPDATE #TEMP_APP_DCAGENTPROP
			SET updateInterval = '15'
		END
	END
	SET @r_DataClassificationTagList = ISNULL((SELECT attrVal
												FROM APP_ExtendedProperties
												WHERE appTypeId = @i_appTypeId
													AND clientId = @i_clientId
													AND attrName = 'Data Classifier Tag Name'
													AND modified  = 0),N''
												)
	IF (SELECT COUNT(*) from #TEMP_APP_DCAGENTPROP) = 0
			SELECT N'',N'1',N'0',N'2',N'',N'0',N'',N'',@r_DataClassificationTagList
	ELSE
		SELECT @i_appTypeId,MetaDataFileLocation,isDataClassificationEnabled,isOnline,clientPriority,
				updateInterval,InactivityPeriod,ADServerName,ADUsername,@r_DataClassificationTagList
					FROM #TEMP_APP_DCAGENTPROP
	RETURN
END
-- lookupNetwareDataMigratorProperties
IF @i_appTypeId = 83
BEGIN
	SELECT 	ISNULL([fs user id],N'') as Username
	INTO	#TEMP_APP_NETWAREDMPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[fs user id]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_NETWAREDMPROP) = 0
			SELECT @i_appTypeId,N''
	ELSE
		SELECT @i_appTypeId,I.Username
			FROM #TEMP_APP_NETWAREDMPROP I
	RETURN
END
-- lookupWin2KProperties
IF	@i_appTypeId = 11 OR
@i_appTypeId = 91	OR
@i_appTypeId = 93
BEGIN
	SET @r_OnlineCILocationShareName = ISNULL((SELECT attrVal
										FROM APP_ExtendedProperties
										WHERE clientId = @i_clientId
										AND appTypeId = @i_appTypeId
										AND attrName = 'Context Indexing List'
										AND modified  = 0),N'')
	SET @r_OWAURLList = ISNULL((SELECT attrVal
										FROM APP_ExtendedProperties
										WHERE clientId = @i_clientId
										AND appTypeId = @i_appTypeId
										AND attrName = 'OWA URL list'
										AND modified  = 0),N'')
	SELECT @i_appTypeId,@r_OnlineCILocationShareName,@r_OWAURLList
END
-- lookupWinDotNet32Properties
--IF	@i_appTypeId = LEGACY_CV_APPTYPE_WIN2003_32BIT
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupWinDotNet64Properties
--IF	@i_appTypeId = LEGACY_CV_APPTYPE_WIN2003_64BIT
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupWinXP32Properties
--IF	@i_appTypeId = CV_APPTYPE_WINDOWS_FILESYSTEM
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupWinXP64Properties
--IF	@i_appTypeId = LEGACY_CV_APPTYPE_XP64_BIT
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupRecoveryDirectorProperties
--IF	@i_appTypeId = CV_APPTYPE_RECOVERY_DIRECTOR
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupProxyHostProperties
--IF	@i_appTypeId = LEGACY_CV_APPTYPE_PROXYHOST OR
--		@i_appTypeId = CV_APPTYPE_PROXYHOST_IMAGELEVEL
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupSanVolProperties
--IF	@i_appTypeId = UNUSED_CV_APPTYPE_24
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupSanVolUnixProperties
--IF	@i_appTypeId = UNUSED_CV_APPTYPE_48
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupReplicationProperties
IF	@i_appTypeId = 50 OR
@i_appTypeId = 47
BEGIN
		SELECT	id,(LEFT(attrName,PATINDEX('% %',attrName)-1)),
				(LEFT(attrVal, charindex(CHAR(0x15),attrVal)-1) ),
				(RIGHT(attrVal, LEN(attrVal) - charindex(CHAR(0x15), attrVal, charindex(CHAR(0x15),attrVal)+1)))
				 FROM APP_IDAProp
			WHERE attrName like '%credentials%' AND modified = 0
END
--lookupLotusNotesDocProperties
IF	@i_appTypeId = 7 OR
@i_appTypeId = 52 OR
@i_appTypeId = 60 OR
@i_appTypeId = 90
BEGIN
		SELECT 	ISNULL([LMDM Restore to Revocered Items Folder],N'') as RestoreToRecoveredItems
	INTO	#TEMP_APP_LNDOCPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[LMDM Restore to Revocered Items Folder]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_LNDOCPROP) = 0
			SELECT @i_appTypeId,N''
	ELSE
		SELECT @i_appTypeId,RestoreToRecoveredItems
			FROM #TEMP_APP_LNDOCPROP I
	RETURN
END
--lookupLotusNotesDbProperties
--IF	@i_appTypeId = UNUSED_CV_APPTYPE_6 OR
--		@i_appTypeId = UNUSED_CV_APPTYPE_51 OR
--		@i_appTypeId = CV_APPTYPE_LOTUS_DOMINO6_DATABASE OR
--		@i_appTypeId = CV_APPTYPE_UNIX_LOTUSNOTES6_DB
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupGranADProperties
IF @i_appTypeId = 41
BEGIN
	SELECT 	ISNULL([AD User Name],N'') as Username
	INTO	#TEMP_APP_GRANULARADPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[AD User Name]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_GRANULARADPROP) = 0
			SELECT @i_appTypeId,N''
	ELSE
		SELECT @i_appTypeId,I.Username
			FROM #TEMP_APP_GRANULARADPROP I
	RETURN
END
-- lookupFileSystemProperties
--IF	@i_appTypeId = UNUSED_CV_APPTYPE_1
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupFileReplicationProperties
IF 	@i_appTypeId = 84 OR
@i_appTypeId = 107
BEGIN
	SELECT 	ISNULL([FLR Dest User Name],N'') as Username,
			ISNULL([FLR Log Filepath],N'') as FileLogPath,
			ISNULL([FLR Dest Log Volume Throttle PerCent],N'25') as LogVolThrottlePercent,
			ISNULL([FLR Dest Log Volume Stop Logs PerCent],N'15') as LogVolStopLogsPercent,
			ISNULL([FLR Replication Options],N'0') as FLRReplicationOptions,
			ISNULL([FLR Src  Log Volume Abort PerCent],N'15') as SrcLogVolAbortPercent,
			ISNULL([FLR Default OS Priority],N'') as FLRDefualtOSPriority,
			ISNULL([FLR Logfile Flush Wait Time Minutes],N'3') as FLRLogFlushWaitTime,
			ISNULL([FLR Xfer Rate MB per Sec],N'0') as FLRTransferRate,
			ISNULL([FLR ONTAP User Name],N'') as FLRONTAPUsername
	INTO	#TEMP_APP_FLRPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[FLR Dest User Name],
				[FLR Log Filepath],
				[FLR Dest Log Volume Throttle PerCent],
				[FLR Dest Log Volume Stop Logs PerCent],
				[FLR Replication Options],
				[FLR Src  Log Volume Abort PerCent],
				[FLR Default OS Priority],
				[FLR Logfile Flush Wait Time Minutes],
				[FLR Xfer Rate MB per Sec],
				[FLR ONTAP User Name]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_FLRPROP) = 0
			SELECT @i_appTypeId,N'',N'',N'25', N'15',N'0',N'15',N'',N'3',N'0',N''
	ELSE
		SELECT @i_appTypeId,Username,FileLogPath,LogVolThrottlePercent,LogVolStopLogsPercent,
				FLRReplicationOptions,SrcLogVolAbortPercent,FLRDefualtOSPriority,FLRLogFlushWaitTime,
				FLRTransferRate,FLRONTAPUsername
		FROM	#TEMP_APP_FLRPROP
	RETURN
END
-- lookupSharepointDocProperties
IF 	@i_appTypeId = 46 OR
@i_appTypeId = 78 OR
@i_appTypeId = 89
BEGIN
	SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = 42 AND A.clientId = 2
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
END
IF 	@i_appTypeId = 46
BEGIN
	SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
	SELECT 	ISNULL([User Name],N'') as Username,
			ISNULL([Server Name],N'') as ServerName
	INTO	#TEMP_APP_SHAREPOINTPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_InstanceProp
				WHERE componentNameId = @r_instanceId
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[User Name],
				[Server Name]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_SHAREPOINTPROP) = 0
			SELECT @i_appTypeId,N'',N'','4294967295','','','',N'' --StubRetentiontime this variable is not used but
						 --passed here so we can reuse the structure defined
	ELSE
		SELECT @i_appTypeId,I.Username,I.ServerName,
			'4294967295','','','',N'' --StubRetentiontime this variable is not used but
						 --passed here so we can reuse the structure defined
			FROM #TEMP_APP_SHAREPOINTPROP I
	RETURN
END
IF	@i_appTypeId = 78 OR
@i_appTypeId = 89
BEGIN
	SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
	SELECT 	ISNULL([SharePoint Remote SQL user name],N'') as Username
	INTO	#TEMP_APP_SHAREPOINTDOCPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[SharePoint Remote SQL user name]
			)
	) AS pvt1
	SELECT 	ISNULL([Server Name],N'') as ServerName
	INTO	#TEMP_APP_SHAREPOINTV2PROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_InstanceProp
				WHERE componentNameId = @r_instanceId
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[Server Name]
			)
	) AS pvt1
IF @i_appTypeId = 89 AND
		(SELECT releaseId from APP_Client WHERE Id = @i_clientId) > 12
	BEGIN
		SET @r_spVersion = ISNULL((SELECT agentProp.attrVal
								FROM APP_IDAName agent
									INNER JOIN APP_IDAProp agentProp ON agent.id = agentProp.componentNameId
WHERE agent.clientId = @i_clientId AND agent.appTypeId = 89
									AND agentProp.attrName = N'IDA Version' AND agentProp.modified = 0), N'0')
		SET @r_stubRetensionTime = ISNULL((SELECT attrVal
											FROM APP_IDAProp
				WHERE componentNameId = @id AND attrName='Stub Retention Time'
				AND	modified = 0),N'4294967295')
		IF (SELECT COUNT(*) from #TEMP_APP_SHAREPOINTV2PROP) = 0 OR
			(SELECT COUNT(*) from #TEMP_APP_SHAREPOINTDOCPROP) = 0
			BEGIN
				SELECT @i_appTypeId,N'',N'',@r_stubRetensionTime,'','','',N'', @r_spVersion
				RETURN
			END
		IF (SELECT COUNT(*) from #TEMP_APP_SHAREPOINTV2PROP) = 0 OR
		   (SELECT COUNT(*) from #TEMP_APP_SHAREPOINTDOCPROP) > 0
			BEGIN
				SELECT @i_appTypeId,Username,N'',@r_stubRetensionTime,'','','',UserName, @r_spVersion
					FROM #TEMP_APP_SHAREPOINTDOCPROP
				RETURN
			END
		IF (SELECT COUNT(*) from #TEMP_APP_SHAREPOINTV2PROP) > 0 OR
		   (SELECT COUNT(*) from #TEMP_APP_SHAREPOINTDOCPROP) = 0
			BEGIN
				SELECT @i_appTypeId,N'',ServerName,@r_stubRetensionTime,'','','',N'', @r_spVersion
					FROM #TEMP_APP_SHAREPOINTV2PROP
				RETURN
			END
		SELECT @i_appTypeId,D.Username,I.ServerName,@r_stubRetensionTime,'','','',D.UserName, @r_spVersion
			FROM #TEMP_APP_SHAREPOINTV2PROP I, #TEMP_APP_SHAREPOINTDOCPROP D
		RETURN
	END
END
IF	@i_appTypeId = 78 AND
	(SELECT releaseId from APP_Client WHERE Id = @i_clientId) > 12
BEGIN
	SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
	SELECT 	ISNULL([Release Topology lock],N'1') as ReleaseTopologyLock,
			ISNULL([SharePoint Remote Index Backup Restore Path],N'') as RestorePath,
			ISNULL([SharePoint Is Remote SQL server],N'0') as isRemoteSQLServer
	INTO	#TEMP_APP_SHAREPOINTV2DOCPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[Release Topology lock],
				[SharePoint Remote Index Backup Restore Path],
				[SharePoint Is Remote SQL server]
			)
	) AS pvt
	SET @r_username = (SELECT attrVal
						FROM APP_InstanceProp
						WHERE attrName = 'User Name'
						AND componentNameId = @r_instanceId
						AND	modified = 0)
	UPDATE #TEMP_APP_SHAREPOINTV2DOCPROP
	SET	ReleaseTopologyLock  = (case
     		WHEN (SELECT ReleaseTopologyLock from #TEMP_APP_SHAREPOINTV2DOCPROP) = '1' THEN '1'
     		ELSE '0' END),
     isRemoteSQLServer  = (case
     		WHEN (SELECT isRemoteSQLServer from #TEMP_APP_SHAREPOINTV2DOCPROP) = '1' THEN '1'
     		ELSE '0' END)
	SET @r_spVersion = ISNULL((SELECT agentProp.attrVal
								FROM APP_IDAName agent
									INNER JOIN APP_IDAProp agentProp ON agent.id = agentProp.componentNameId
WHERE agent.clientId = @i_clientId AND agent.appTypeId = 78
									AND agentProp.attrName = N'IDA Version' AND agentProp.modified = 0), N'0')
    IF (SELECT COUNT(*) from #TEMP_APP_SHAREPOINTV2DOCPROP,#TEMP_APP_SHAREPOINTV2PROP V,#TEMP_APP_SHAREPOINTDOCPROP D) = 0
			SELECT @i_appTypeId,@r_username,'','4294967295',N'1',N'',N'0',N'', @r_spVersion
	ELSE
		SELECT @i_appTypeId,@r_username,'',
			'4294967295', --StubRetentiontime this variable is not used but
						 --passed here so we can reuse the structure defined
			I.ReleaseTopologyLock,I.RestorePath,
			I.isRemoteSQLServer,D.UserName, @r_spVersion
			FROM #TEMP_APP_SHAREPOINTV2DOCPROP I,#TEMP_APP_SHAREPOINTV2PROP V,#TEMP_APP_SHAREPOINTDOCPROP D
	RETURN
END
--TODO
--lookupExchangePublicFolderProperties
IF	@i_appTypeId = 82 OR
@i_appTypeId = 35 OR
@i_appTypeId = 44 OR
@i_appTypeId = 55
BEGIN
		SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
		SELECT 	ISNULL([User Name],N'') as Username,
				ISNULL([Server Name],N'') as ServerName,
				ISNULL([Profile Name],N'') as ProfileName,
				ISNULL([Mailbox Name],N'') as MailBoxName,
				ISNULL([Backup deleted item retention],N'0') as BackupDeleted,
				ISNULL([Use CSVDE for AD mailbox discovery],N'') as UseCSVDEDiscovery,
				ISNULL([Backup hidden mailbox],N'0') as BackupHiddenMailBox
		INTO	#TEMP_APP_EXCHPUBLICFOLDER
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_InstanceProp
					WHERE componentNameId = @r_instanceId
					AND	modified = 0
		)	AS	IDAs
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[User Name],
					[Server Name],
					[Profile Name],
					[Mailbox Name],
					[Backup deleted item retention],
					[Use CSVDE for AD mailbox discovery],
					[Backup hidden mailbox]
				)
		) AS pvt
		-- hasExchangeDMAddinRecoveryMessages
IF	@i_appTypeId = 45 OR
@i_appTypeId = 56	OR
@i_appTypeId = 82	OR
@i_appTypeId = 57
		BEGIN
			SELECT 	ISNULL([Magnetic Library Recover Message],
							N'Your file is currently being recalled from remote storage.') as MagneticLib,
				ISNULL([Tape Library Recover Message],
						N'Your file is currently being recalled from remote storage and the process may take several minutes to complete.  Thank-you for your patience.') as TapeLib,
				ISNULL([Media Offline Recover Message],
				N'Your request has been cancelled because the file is currently stored in offline media.  A restore request is pending, please check back in 24 hours.') as OfflineMedia
			INTO	#TEMP_APP_EXCHPUBLICFOLDERUSERDEFINED
			FROM
			(
					SELECT componentNameId, attrName, attrVal
						FROM APP_InstanceProp
						WHERE componentNameId = @r_instanceId
						AND	modified = 0
			)	AS	IDA1s
			PIVOT
			(
					max(attrVal)
					FOR attrName IN
					(
						[Magnetic Library Recover Message],
						[Tape Library Recover Message],
						[Media Offline Recover Message]
					)
			) AS pvt1
			IF (SELECT COUNT(*) from #TEMP_APP_EXCHPUBLICFOLDER) = 0 AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHPUBLICFOLDERUSERDEFINED) = 0
			BEGIN
				SELECT @i_appTypeId, N'',N'',N'',N'',N'0',N'',N'0','','','',
				'','','','','','','','','','',''
				RETURN
			END
			IF (SELECT COUNT(*) from #TEMP_APP_EXCHPUBLICFOLDER) > 0 AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHPUBLICFOLDERUSERDEFINED) = 0
			BEGIN
				SELECT @i_appTypeId, I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,'','','',
				'','','','','','','','','','',''
				FROM #TEMP_APP_EXCHPUBLICFOLDER I
				RETURN
			END
			IF (SELECT COUNT(*) from #TEMP_APP_EXCHPUBLICFOLDER) = 0 AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHPUBLICFOLDERUSERDEFINED) > 0
			BEGIN
				SELECT @i_appTypeId, N'',N'',N'',N'',N'false',N'',N'false',A.MagneticLib,
					A.TapeLib,A.OfflineMedia,'','','','','','','','','','',''
				FROM #TEMP_APP_EXCHPUBLICFOLDERUSERDEFINED A
				RETURN
			END
				SELECT @i_appTypeId, I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,A.MagneticLib,
					A.TapeLib,A.OfflineMedia,'','','','','','','','','','',''
					FROM #TEMP_APP_EXCHPUBLICFOLDER I,#TEMP_APP_EXCHPUBLICFOLDERUSERDEFINED A
			RETURN
		END
--		UPDATE #TEMP_APP_EXCHPUBLICFOLDER
--		SET	BackupDeleted  = (case	BackupDeleted
-- 				WHEN  '1' THEN 'true'
--				WHEN '0' THEN 'false'
--				ELSE 'false' END),
--
--		 BackupHiddenMailBox  = (case	BackupHiddenMailBox
--				WHEN '1' THEN 'true'
--				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
		 IF (SELECT COUNT(*) from #TEMP_APP_EXCHPUBLICFOLDER) = 0
			SELECT @i_appTypeId, N'',N'',N'',N'',N'0',N'',N'0','','','',
					'','','','','','','','','','',''
		ELSE
			SELECT @i_appTypeId, I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,'','','',
					'','','','','','','','','','',''
				FROM #TEMP_APP_EXCHPUBLICFOLDER I
		RETURN
END
--lookupDataMigratorProperties
IF	@i_appTypeId = 45 OR
@i_appTypeId = 56 OR
@i_appTypeId = 57
BEGIN
		SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
		SELECT 	ISNULL([User Name],N'') as Username,
				ISNULL([Server Name],N'') as ServerName,
				ISNULL([Profile Name],N'') as ProfileName,
				ISNULL([Mailbox Name],N'') as MailBoxName,
				ISNULL([Backup deleted item retention],N'0') as BackupDeleted,
				ISNULL([Use CSVDE for AD mailbox discovery],N'') as UseCSVDEDiscovery,
				ISNULL([Backup hidden mailbox],N'0') as BackupHiddenMailBox,
				ISNULL([Magnetic Library Recover Message],
						N'Your file is currently being recalled from remote storage.') as MagneticLib,
				ISNULL([Tape Library Recover Message],
						N'Your file is currently being recalled from remote storage and the process may take several minutes to complete.  Thank-you for your patience.') as TapeLib,
				ISNULL([Media Offline Recover Message],
						N'Your request has been cancelled because the file is currently stored in offline media.  A restore request is pending, please check back in 24 hours.') as OfflineMedia,
				ISNULL([Journal Threshold],N'-1') as JournalThreshold,
				ISNULL([Associated AD Server List],N'') as ADServerList,
				ISNULL([Force Recall for Outlook Addin User],N'0') as isForceRecallOutlookAddin,
				ISNULL([Force Recall for OWA User],N'0') as isForceRecallOWAUser
		INTO	#TEMP_APP_DATAMIGRATORPROP
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_InstanceProp
					WHERE componentNameId = @r_instanceId
					AND	modified = 0
		)	AS	IDAs
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[User Name],
					[Server Name],
					[Profile Name],
					[Mailbox Name],
					[Backup deleted item retention],
					[Use CSVDE for AD mailbox discovery],
					[Backup hidden mailbox],
					[Magnetic Library Recover Message],
					[Tape Library Recover Message],
					[Media Offline Recover Message],
					[Journal Threshold],
					[Associated AD Server List],
					[Force Recall for Outlook Addin User],
					[Force Recall for OWA User]
				)
		) AS pvt
		SELECT 	ISNULL([Auto Discovery Enabled],N'0') as isAutoDiscoveryEnabled,
				ISNULL([Manage content automatically],N'1') as canManageContentAutomatically,
				ISNULL([Optimized Data for Search],N'1') as isOptimizeDataForSearchEnabled,
				ISNULL([IDA Version],N'1') as AgentVersion
		INTO	#TEMP_APP_DATAMIGRATORPROPAGENT
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_IDAProp
					WHERE componentNameId = @id
					AND	modified = 0
		)	AS	IDA1s
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[Auto Discovery Enabled],
					[Manage content automatically],
					[Optimized Data for Search],
					[IDA Version]
				)
		) AS pvt1
--		UPDATE #TEMP_APP_DATAMIGRATORPROP
--		SET	BackupDeleted  = (case	BackupDeleted
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
--		 BackupHiddenMailBox  = (case	BackupHiddenMailBox
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		isForceRecallOutlookAddin  = (case	isForceRecallOutlookAddin
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		isForceRecallOWAUser  = (case	isForceRecallOWAUser
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
--
-- 		UPDATE #TEMP_APP_DATAMIGRATORPROPAGENT
--
-- 		SET	isAutoDiscoveryEnabled  = (case	isAutoDiscoveryEnabled
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
--		 canManageContentAutomatically  = (case	canManageContentAutomatically
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		isOptimizeDataForSearchEnabled  = (case	isOptimizeDataForSearchEnabled
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
		IF (SELECT COUNT(*) from #TEMP_APP_DATAMIGRATORPROP) = 0 AND
		(SELECT COUNT(*) from #TEMP_APP_DATAMIGRATORPROPAGENT) = 0
			BEGIN
				SELECT @i_appTypeId, N'',N'',N'',N'',
					N'0',N'',N'0',N'',N'',N'',N'-1',N'',
					N'0',N'0',N'1',N'1',N'1',
					N'',N'',N'',N''
				RETURN
			END
		IF (SELECT COUNT(*) from #TEMP_APP_DATAMIGRATORPROP) > 0 AND
		(SELECT COUNT(*) from #TEMP_APP_DATAMIGRATORPROPAGENT) = 0
			BEGIN
				SELECT @i_appTypeId, I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,I.MagneticLib,
					I.TapeLib,I.OfflineMedia,I.JournalThreshold,I.ADServerList,
					I.isForceRecallOutlookAddin,I.isForceRecallOWAUser,N'0',N'1',N'1',N'1',
					'','',''
					FROM #TEMP_APP_DATAMIGRATORPROP I
				RETURN
			END
		IF (SELECT COUNT(*) from #TEMP_APP_DATAMIGRATORPROP) = 0 AND
		(SELECT COUNT(*) from #TEMP_APP_DATAMIGRATORPROPAGENT) > 0
			BEGIN
				SELECT @i_appTypeId, N'',N'',N'',N'',
					N'0',N'',N'0',N'',N'',N'',N'-1',N'',N'0',
					N'0',A.isAutoDiscoveryEnabled,
					A.canManageContentAutomatically,A.isOptimizeDataForSearchEnabled,A.AgentVersion,
					'','',''
				FROM #TEMP_APP_DATAMIGRATORPROPAGENT A
				RETURN
			END
		SELECT @i_appTypeId, I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,I.MagneticLib,
					I.TapeLib,I.OfflineMedia,I.JournalThreshold,I.ADServerList,
					I.isForceRecallOutlookAddin,I.isForceRecallOWAUser,A.isAutoDiscoveryEnabled,
					A.canManageContentAutomatically,A.isOptimizeDataForSearchEnabled,A.AgentVersion,
					'','',''
				FROM #TEMP_APP_DATAMIGRATORPROP I,#TEMP_APP_DATAMIGRATORPROPAGENT A
		RETURN
END
--lookupExchangeArchiverProperties
IF	@i_appTypeId = 67 OR
@i_appTypeId = 68
BEGIN
		SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
		SELECT 	ISNULL([User Name],N'') as Username,
				ISNULL([Server Name],N'') as ServerName,
				ISNULL([Profile Name],N'') as ProfileName,
				ISNULL([Mailbox Name],N'') as MailBoxName,
				ISNULL([Backup deleted item retention],N'0') as BackupDeleted,
				ISNULL([Use CSVDE for AD mailbox discovery],N'') as UseCSVDEDiscovery,
				ISNULL([Backup hidden mailbox],N'0') as BackupHiddenMailBox,
				ISNULL([Journal Threshold],N'-1') as JournalThreshold,
				ISNULL([Associated AD Server List],N'') as ADServerList
		INTO	#TEMP_APP_EXCHARCHIVERPROP
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_InstanceProp
					WHERE componentNameId = @r_instanceId
					AND	modified = 0
		)	AS	IDAs
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[User Name],
					[Server Name],
					[Profile Name],
					[Mailbox Name],
					[Backup deleted item retention],
					[Use CSVDE for AD mailbox discovery],
					[Backup hidden mailbox],
					[Journal Threshold],
					[Associated AD Server List]
				)
		) AS pvt
		SELECT 	ISNULL([Hosted exchange],N'0') as isHostedExchange,
				ISNULL([Manage content automatically],N'1') as canManageContentAutomatically,
				ISNULL([Optimized Data for Search],N'1') as isOptimizeDataForSearchEnabled,
				ISNULL([IDA Version],N'1') as IDAVersion
		INTO	#TEMP_APP_EXCHARCHIVERPROPAGENT
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_IDAProp
					WHERE componentNameId = @id
					AND	modified = 0
		)	AS	IDA1s
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[Hosted exchange],
					[Manage content automatically],
					[Optimized Data for Search],
					[IDA Version]
				)
		) AS pvt1
--		UPDATE #TEMP_APP_EXCHARCHIVERPROP
--		SET	BackupDeleted  = (case	BackupDeleted
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
--		 BackupHiddenMailBox  = (case	BackupHiddenMailBox
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
--
--
-- 		UPDATE #TEMP_APP_EXCHARCHIVERPROPAGENT
--
--		SET canManageContentAutomatically  = (case	canManageContentAutomatically
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		isOptimizeDataForSearchEnabled  = (case	isOptimizeDataForSearchEnabled
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		 isHostedExchange  = (case	isHostedExchange
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
		IF (SELECT COUNT(*) from #TEMP_APP_EXCHARCHIVERPROP) = 0	AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHARCHIVERPROPAGENT) = 0
		BEGIN
			SELECT @i_appTypeId, N'',N'',N'',N'',N'0',N'',N'0','','','',
					N'-1',N'','','','',	N'1',N'1',N'1',N'0','',''
			RETURN
		END
		IF (SELECT COUNT(*) from #TEMP_APP_EXCHARCHIVERPROP) > 0	AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHARCHIVERPROPAGENT) = 0
		BEGIN
			SELECT @i_appTypeId, I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,'','','',
					I.JournalThreshold,I.ADServerList,'','','',N'1',N'1',N'1',N'0','',''
				FROM #TEMP_APP_EXCHARCHIVERPROP I
			RETURN
		END
			IF (SELECT COUNT(*) from #TEMP_APP_EXCHARCHIVERPROP) = 0	AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHARCHIVERPROPAGENT) > 0
		BEGIN
			SELECT @i_appTypeId, N'',N'',N'',N'',N'0',N'',N'0','','','',
					N'-1',N'','','','',	A.canManageContentAutomatically,
					A.isOptimizeDataForSearchEnabled,A.IDAVersion,A.isHostedExchange,'',''
				FROM #TEMP_APP_EXCHARCHIVERPROPAGENT A
			RETURN
		END
		SELECT @i_appTypeId, I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,'','','',
					I.JournalThreshold,I.ADServerList,'','','',
					A.canManageContentAutomatically,A.isOptimizeDataForSearchEnabled,A.IDAVersion,
					A.isHostedExchange,'',''
				FROM #TEMP_APP_EXCHARCHIVERPROP I,#TEMP_APP_EXCHARCHIVERPROPAGENT A
		RETURN
END
--lookupExchangeMBProperties
IF	@i_appTypeId = 8 OR
@i_appTypeId = 14 OR
@i_appTypeId = 54 OR
@i_appTypeId = 105 OR
@i_appTypeId = 137
BEGIN
	SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
									AND (I.status & 0x00010) <> 0x00010
									AND (I.status &  0x00002) <>  0x00002
									AND (I.status & 0x00020) <> 0x00020),1)
		SELECT 	ISNULL([User Name],N'') as Username,
				ISNULL([Server Name],N'') as ServerName,
				ISNULL([Profile Name],N'') as ProfileName,
				ISNULL([Mailbox Name],N'') as MailBoxName,
				ISNULL([Backup deleted item retention],N'0') as BackupDeleted,
				ISNULL([Use CSVDE for AD mailbox discovery],N'') as UseCSVDEDiscovery,
				ISNULL([Backup hidden mailbox],N'0') as BackupHiddenMailBox,
				ISNULL([Journal Threshold],N'-1') as JournalThreshold,
				ISNULL([Associated AD Server List],N'') as ADServerList
		INTO	#TEMP_APP_EXCHMBPROP
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_InstanceProp
					WHERE componentNameId = @r_instanceId
					AND	modified = 0
		)	AS	IDAs
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[User Name],
					[Server Name],
					[Profile Name],
					[Mailbox Name],
					[Backup deleted item retention],
					[Use CSVDE for AD mailbox discovery],
					[Backup hidden mailbox],
					[Journal Threshold],
					[Associated AD Server List]
				)
		) AS pvt
		SELECT 	ISNULL([Hosted exchange],N'0') as isHostedExchange,
				ISNULL([Manage content automatically],N'1') as canManageContentAutomatically,
				ISNULL([Optimized Data for Search],N'1') as isOptimizeDataForSearchEnabled,
				ISNULL([IDA Version],N'1') as IDAVersion
		INTO	#TEMP_APP_EXCHMBPROPAGENT
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_IDAProp
					WHERE componentNameId = @id
					AND	modified = 0
		)	AS	IDA1s
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[Hosted exchange],
					[Manage content automatically],
					[Optimized Data for Search],
					[IDA Version]
				)
		) AS pvt1
--		UPDATE #TEMP_APP_EXCHMBPROP
--		SET	BackupDeleted  = (case	BackupDeleted
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
--		 BackupHiddenMailBox  = (case BackupHiddenMailBox
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
--
--
-- 		UPDATE #TEMP_APP_EXCHMBPROPAGENT
--
--		SET canManageContentAutomatically  = (case	canManageContentAutomatically
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		isOptimizeDataForSearchEnabled  = (case	isOptimizeDataForSearchEnabled
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		 isHostedExchange  = (case	isHostedExchange
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
 		SET @r_OnlineCILocShare = ISNULL((SELECT TOP 1 attrVal
 									FROM APP_ExtendedProperties
 									WHERE attrName = 'Context Indexing List'
 									AND clientId = @i_clientId
 									AND appTypeId = @i_appTypeId
									AND modified  = 0),N'')
 		SET @r_CIOWAUrlList = ISNULL((SELECT TOP 1 attrVal
 									FROM APP_ExtendedProperties
 									WHERE attrName = 'OWA URL list'
 									AND clientId = @i_clientId
 									AND appTypeId = @i_appTypeId
									AND modified  = 0),N'')
 	IF (SELECT COUNT(*) from #TEMP_APP_EXCHMBPROPAGENT) = 0 AND
 		(SELECT COUNT(*) from #TEMP_APP_EXCHMBPROP) = 0
 	BEGIN
		SELECT @i_appTypeId, N'',N'',N'',N'',N'0',N'',N'0','','','',
					N'-1',N'','','','',	N'1',N'1',1,N'0',@r_OnlineCILocShare,@r_CIOWAUrlList
		RETURN
	END
	IF (SELECT COUNT(*) from #TEMP_APP_EXCHMBPROPAGENT) > 0 AND
 		(SELECT COUNT(*) from #TEMP_APP_EXCHMBPROP) = 0
 	BEGIN
		SELECT @i_appTypeId, N'',N'',N'',N'',N'0',N'',N'0','','','',
					N'-1',N'','','','',	N'1',A.isOptimizeDataForSearchEnabled,A.IDAVersion,
					A.isHostedExchange,@r_OnlineCILocShare,@r_CIOWAUrlList
					FROM #TEMP_APP_EXCHMBPROPAGENT A
		RETURN
	END
 	IF (SELECT COUNT(*) from #TEMP_APP_EXCHMBPROPAGENT) = 0 AND
 		(SELECT COUNT(*) from #TEMP_APP_EXCHMBPROP) > 0
 	BEGIN
		SELECT @i_appTypeId,I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,'','','',
					I.JournalThreshold,I.ADServerList,'','','',N'1',1,N'0','',
					@r_OnlineCILocShare,@r_CIOWAUrlList
					FROM #TEMP_APP_EXCHMBPROP I
		RETURN
	END
 		SELECT @i_appTypeId, I.UserName,I.ServerName,I.ProfileName,I.MailBoxName,
					I.BackupDeleted,I.UseCSVDEDiscovery,I.BackupHiddenMailBox,'','','',
					I.JournalThreshold,I.ADServerList,'','','',
					A.canManageContentAutomatically,A.isOptimizeDataForSearchEnabled,A.IDAVersion,
					A.isHostedExchange,@r_OnlineCILocShare,@r_CIOWAUrlList
					FROM #TEMP_APP_EXCHMBPROPAGENT A, #TEMP_APP_EXCHMBPROP I
		RETURN
END
-- lookupImageWinFSProperties
--IF	@i_appTypeId = CV_APPTYPE_IMAGE_WINFS_IDA
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
-- lookupImageUNIXFSProperties
--IF	@i_appTypeId = CV_APPTYPE_IMAGE_UNIXFS_IDA
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupNetwareGroupwiseProperties
IF	@i_appTypeId = 71
BEGIN
	SELECT 	ISNULL([fs user id],N'') as Username
	INTO	#TEMP_APP_NETWAREGROUPWISEPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[fs user id]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_NETWAREGROUPWISEPROP) = 0
		SELECT @i_appTypeId,N''
	ELSE
		SELECT @i_appTypeId, I.Username
			FROM #TEMP_APP_NETWAREGROUPWISEPROP I
	RETURN
END
--lookupSybaseProperties
--IF	@i_appTypeId = CV_APPTYPE_SYBASE OR
--		@i_appTypeId = CV_APPTYPE_POSTGRESS OR
--		@i_appTypeId = CV_APPTYPE_SYBASE_IQ OR
--		@i_appTypeId = CV_APPTYPE_EXTERNAL_DATA_CONNECTOR
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupMySqlProperties
IF	@i_appTypeId =  104
BEGIN
	DECLARE @TEMP_APP_MYSQLPROP TABLE (isAutoDiscoverEnabled NVARCHAR(MAX))
	INSERT INTO	@TEMP_APP_MYSQLPROP
	SELECT	attrVal
	FROM	APP_IDAProp
	WHERE	componentNameId = @id
		AND	attrName = 'Auto Discover MySQL instance'
		AND	modified = 0
 	IF (SELECT COUNT(*) from @TEMP_APP_MYSQLPROP) = 0
 		SELECT @i_appTypeId,N'0'
 	ELSE
 		SELECT @i_appTypeId,I.isAutoDiscoverEnabled
 			FROM @TEMP_APP_MYSQLPROP I
 	RETURN
END
--lookupPostgresProperties
IF	@i_appTypeId =  125
BEGIN
	DECLARE @TEMP_APP_POSTGRESPROP TABLE (isAutoDiscoverEnabled NVARCHAR(MAX))
	INSERT INTO	@TEMP_APP_POSTGRESPROP
	SELECT	attrVal
	FROM	APP_IDAProp
	WHERE	componentNameId = @id
		AND	attrName = 'Auto Discover PostgreSQL instance'
		AND	modified = 0
 	IF (SELECT COUNT(*) from @TEMP_APP_POSTGRESPROP) = 0
 		SELECT @i_appTypeId,N'0'
 	ELSE
 		SELECT @i_appTypeId,I.isAutoDiscoverEnabled
 			FROM @TEMP_APP_POSTGRESPROP I
 	RETURN
END
--lookupExchangeDBProperties
IF	@i_appTypeId = 9 OR
@i_appTypeId = 15 OR
@i_appTypeId = 53 OR
@i_appTypeId = 69
BEGIN
		SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
		SET @r_appId = ISNULL((SELECT TOP 1 id
						FROM APP_APPLICATION
						WHERE	backupSet = (SELECT TOP 1 backupSet
									FROM APP_Application
									WHERE instance = @r_instanceId
									AND appTypeId = @i_appTypeId)
AND ((subclientStatus & 0x00004) <> 0x00004)),
						0)
		IF @r_appId <> 0
		BEGIN
			SET @r_backupLevel = ISNULL((SELECT attrVal
										FROM APP_SubclientProp
										WHERE attrName = 'Backup Level'
										AND componentNameId = @r_appId
										AND modified = 0),N'2')
		END
		SELECT 	ISNULL([Backup From Replica],N'0') as isBackupFromReplica,
				ISNULL([Continue Backups From Replica After Failover],N'0') as isContinueFromReplicaAfterFallover,
				ISNULL([Copy Backup Enabled],N'0') as isOptimizeDataForSearchEnabled,
				ISNULL([IDA Version],1) as IDAVersion,
				ISNULL([DAG Name],N'') as DagName,
				ISNULL([Generate Exchange Activity Log],N'0') as generateExchActivityLog,
				ISNULL([Exchange Mailbox Log Locatiion],N'') as exchMBLogLocation,
				ISNULL([Manage content automatically],N'1') as manageContentAutomatically,
				ISNULL([Exchange change journal log username],N'') as exchJournalLogUsername,
				ISNULL([Release Topology lock],N'1') as releaseTopologyLock,
				ISNULL([SharePoint Remote Index Backup Restore Path],N'') as remoteIndexBackupRestorePath,
				ISNULL([SharePoint Is Remote SQL server],N'0') as isRemoteSQLServer,
				ISNULL([SharePoint Remote SQL user name],N'') as RemoteSQLServerUsername
		INTO	#TEMP_APP_EXCHDBPROPAGENT
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_IDAProp
					WHERE componentNameId = @id
					AND	modified = 0
		)	AS	IDAs
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[Backup From Replica],
					[Continue Backups From Replica After Failover],
					[Copy Backup Enabled],
					[IDA Version],
					[DAG Name],
					[Generate Exchange Activity Log],
					[Exchange Mailbox Log Locatiion],
					[Manage content automatically],
					[Exchange change journal log username],
					[Release Topology lock],
					[SharePoint Remote Index Backup Restore Path],
					[SharePoint Is Remote SQL server],
					[SharePoint Remote SQL user name]
				)
		) AS pvt
		IF (SELECT isBackupFromReplica FROM #TEMP_APP_EXCHDBPROPAGENT)  = N'1'
		BEGIN
SET @r_appTypeFlag = @r_appTypeFlag | 0x1
		END
		IF (SELECT isContinueFromReplicaAfterFallover FROM #TEMP_APP_EXCHDBPROPAGENT) = N'1'
		BEGIN
SET @r_appTypeFlag = @r_appTypeFlag | 0x2
		END
IF (SELECT IDAVersion FROM #TEMP_APP_EXCHDBPROPAGENT ) <> 1000
		BEGIN
			UPDATE #TEMP_APP_EXCHDBPROPAGENT
				SET #TEMP_APP_EXCHDBPROPAGENT.DagName = N''
		END
--		UPDATE #TEMP_APP_EXCHDBPROPAGENT
--		SET isOptimizeDataForSearchEnabled  = (case	isOptimizeDataForSearchEnabled
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		generateExchActivityLog  = (case generateExchActivityLog
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
-- 		 manageContentAutomatically  = (case manageContentAutomatically
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END),
--
--		 isRemoteSQLServer  = (case	isRemoteSQLServer
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
		SELECT 	ISNULL([User Name],N'') as Username,
				ISNULL([Exchange DB Throttling Parameter],N'') as ExchDBThrottling,
				ISNULL([Server Name],N'') as ServerName
		INTO	#TEMP_APP_EXCHDBPROP
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_InstanceProp
					WHERE componentNameId = @r_instanceId
					AND	modified = 0
		)	AS	IDAs
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[User Name],
					[Exchange DB Throttling Parameter],
					[Server Name]
				)
		) AS pvt
		IF (SELECT COUNT(*) from #TEMP_APP_EXCHDBPROPAGENT) = 0	AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHDBPROP) = 0
		BEGIN
 			SELECT 	@i_appTypeId,N'',N'',N'',N'0',1,N'',N'0',N'',N'1',
				N'',N'1',N'',N'0',N'',@r_backupLevel,@r_appTypeFlag
			RETURN
		END
		IF (SELECT COUNT(*) from #TEMP_APP_EXCHDBPROPAGENT) > 0	AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHDBPROP) = 0
		BEGIN
 			SELECT 	@i_appTypeId,N'',N'',N'',I.isOptimizeDataForSearchEnabled,I.IDAVersion,I.DagName,
 					I.generateExchActivityLog,I.exchMBLogLocation,I.manageContentAutomatically,
					I.exchJournalLogUsername,I.releaseTopologyLock,I.remoteIndexBackupRestorePath,
					I.isRemoteSQLServer,I.RemoteSQLServerUsername,@r_backupLevel,@r_appTypeFlag
					FROM #TEMP_APP_EXCHDBPROPAGENT I
			RETURN
		END
		IF (SELECT COUNT(*) from #TEMP_APP_EXCHDBPROPAGENT) = 0	AND
			(SELECT COUNT(*) from #TEMP_APP_EXCHDBPROP) > 0
		BEGIN
 			SELECT 	@i_appTypeId,A.Username,A.ExchDBThrottling,A.ServerName,N'0',1,
 					N'',N'0',N'',N'1',N'',N'1',N'',N'1',N'',@r_backupLevel,@r_appTypeFlag
 					FROM #TEMP_APP_EXCHDBPROP A
			RETURN
		END
		SELECT 	@i_appTypeId,A.Username,A.ExchDBThrottling,A.ServerName,
				I.isOptimizeDataForSearchEnabled,I.IDAVersion,I.DagName,I.generateExchActivityLog,I.exchMBLogLocation,I.manageContentAutomatically,
				I.exchJournalLogUsername,I.releaseTopologyLock,I.remoteIndexBackupRestorePath,I.isRemoteSQLServer,
				I.RemoteSQLServerUsername,@r_backupLevel,@r_appTypeFlag
				FROM #TEMP_APP_EXCHDBPROPAGENT I, #TEMP_APP_EXCHDBPROP A
		RETURN
END
--lookupFastraxForExchangeProperties
IF	@i_appTypeId = 27 OR
@i_appTypeId = 31
BEGIN
		SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
		SET @r_appId = ISNULL((SELECT TOP 1 id
						FROM APP_APPLICATION
						WHERE	backupSet = (SELECT TOP 1 backupSet
									FROM APP_Application
									WHERE instance = @r_instanceId
									AND appTypeId = @i_appTypeId)
AND ((subclientStatus & 0x00004) <> 0x00004)),
						0)
		IF @r_appId <> 0
		BEGIN
			SET @r_backupLevel = ISNULL((SELECT attrVal
										FROM APP_SubclientProp
										WHERE attrName = 'Backup Level'
										AND componentNameId = @r_appId
										AND modified = 0),N'0x0002')
		END
		SELECT 	ISNULL([User Name],N'') as Username,
				ISNULL([Server Name],N'') as ServerName
		INTO	#TEMP_APP_FASTTRAXEXCHPROP
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_InstanceProp
					WHERE componentNameId = @r_instanceId
					AND	modified = 0
		)	AS	IDAs
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[User Name],
					[Server Name]
				)
		) AS pvt
		IF (SELECT COUNT(*) from #TEMP_APP_FASTTRAXEXCHPROP) = 0
 			SELECT @i_appTypeId,N'',N'',@r_backupLevel
 		ELSE
			SELECT 	@i_appTypeId,I.Username,I.ServerName,@r_backupLevel
				FROM	#TEMP_APP_FASTTRAXEXCHPROP I
		RETURN
END
--lookupSharePointDBProperties
IF	@i_appTypeId = 32
BEGIN
		SET @r_instanceId = ISNULL((SELECT TOP (1) I.id
									FROM APP_InstanceName I
									INNER JOIN APP_Application A
										ON I.id = A.instance
									WHERE A.appTypeId = @i_appTypeId AND A.clientId = @i_clientId
AND (I.status & 0x00010) <> 0x00010
AND (I.status &  0x00002) <>  0x00002
AND (I.status & 0x00020) <> 0x00020),1)
		SET @r_appId = ISNULL((SELECT TOP 1 id
						FROM APP_APPLICATION
						WHERE	backupSet = (SELECT TOP 1 backupSet
									FROM APP_Application
									WHERE instance = @r_instanceId
									AND appTypeId = @i_appTypeId)
AND ((subclientStatus & 0x00004) <> 0x00004)),
						0)
		IF @r_appId <> 0
		BEGIN
			SET @r_backupLevel = ISNULL((SELECT attrVal
										FROM APP_SubclientProp
										WHERE attrName = 'Backup Level'
										AND componentNameId = @r_appId
										AND modified = 0),N'0x0002')
		END
		SELECT 	ISNULL([User Name],N'') as Username,
				ISNULL([Server Name],N'') as ServerName
		INTO	#TEMP_APP_SHAREPOINTDBPROP
		FROM
		(
				SELECT componentNameId, attrName, attrVal
					FROM APP_InstanceProp
					WHERE componentNameId = @r_instanceId
					AND	modified = 0
		)	AS	IDAs
		PIVOT
		(
				max(attrVal)
				FOR attrName IN
				(
					[User Name],
					[Server Name]
				)
		) AS pvt
		IF (SELECT COUNT(*) from #TEMP_APP_SHAREPOINTDBPROP) = 0
 			SELECT @i_appTypeId,N'',N'',@r_backupLevel
 		ELSE
			SELECT 	@i_appTypeId,I.Username,I.ServerName,@r_backupLevel
				FROM	#TEMP_APP_SHAREPOINTDBPROP	I
		RETURN
END
--lookupVirtualServerProperties
--IF	@i_appTypeId = CV_APPTYPE_VIRTUAL_SERVER
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupInformixProperties
--IF	@i_appTypeId = CV_APPTYPE_INFORMIX
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupSAPProperties
--IF	@i_appTypeId = CV_APPTYPE_INFORMIX
--BEGIN
	--Currently there are no agent specific properties, so empty
--END
--lookupOracle8Properties
IF	@i_appTypeId = 22 OR
@i_appTypeId = 80
BEGIN
	SELECT 	ISNULL([Auto discover Oracle Instance],N'0') as isAutoDiscoverEnabled,
			ISNULL([Oracle Agent Data SP],N'1') as dataSP,
			ISNULL([Oracle Agent Log SP],N'1') as logSP
	INTO	#TEMP_APP_ORACLE8PROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[Auto discover Oracle Instance],
				[Oracle Agent Data SP],
				[Oracle Agent Log SP]
			)
	) AS pvt
--	UPDATE #TEMP_APP_ORACLE8PROP
--		SET isAutoDiscoverEnabled = (case	isAutoDiscoverEnabled
-- 				WHEN '1' THEN 'true'
-- 				WHEN '0' THEN 'false'
-- 				ELSE 'false' END)
 	IF (SELECT COUNT(*) from #TEMP_APP_ORACLE8PROP) = 0
 		SELECT @i_appTypeId,N'0',N'1',N'1'
 	ELSE
 		SELECT @i_appTypeId,I.isAutoDiscoverEnabled, I.dataSP, I.logSP
 			FROM #TEMP_APP_ORACLE8PROP I
 	RETURN
END
--lookupDb2Properties
IF	@i_appTypeId =  37 OR
@i_appTypeId = 62 OR
@i_appTypeId =  103
BEGIN
	SELECT 	ISNULL([Auto discover DB2 Instance],N'0') as isAutoDiscoverEnabled
	INTO	#TEMP_APP_DB2PROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[Auto discover DB2 Instance]
			)
	) AS pvt
 	IF (SELECT COUNT(*) from #TEMP_APP_DB2PROP) = 0
 		SELECT @i_appTypeId,N'0'
 	ELSE
 		SELECT @i_appTypeId,I.isAutoDiscoverEnabled
 			FROM #TEMP_APP_DB2PROP I
 	RETURN
END
--lookupSQL61Properties
IF	@i_appTypeId = 81
BEGIN
	SET @r_QNetRegStatus = 0
     SELECT ISNULL([MSSQL Override Global Authentication],N'0') as overrideGlobalAuthentication,
			ISNULL([MSSQL Use Windows Authentication],N'1') as useLocalSystemAccount,
			ISNULL([NULL],N'0') as impersonateUser,
			ISNULL([MSSQL username],N'') as userName,
			ISNULL(dbo.pswConvertV5ToV3([MSSQL password]),N'') as password,
			ISNULL([Auto discover SQL Instance],N'0') as isAutoDiscoverSQLInstances,
			ISNULL([Staging Path For Restores Enabled],N'0') as isStagingPathForRestoresEnabled,
			ISNULL([Staging Path],N'') as stagingPath,
			ISNULL([Manage content automatically],N'0') as canManageContentAutomaticallyFlag,
			ISNULL([Is Azure Configured],N'0') as isAzureConfigured,
			ISNULL([Azure Tenant Id],N'') as azureTenantId,
			ISNULL([Azure Client Id],N'') as azureClientId,
			ISNULL([Azure Subscription Id],N'') as azureSubscriptionId,
			ISNULL([Azure Storage Connection String],N'') as azureStorageConnectionString,
			ISNULL([Azure Authentication Method],N'') as azureAuthenticationMethod,
			ISNULL([Azure Username],N'') as azureUsername,
			ISNULL(dbo.pswConvertV5ToV3([Azure Password]),N'') as azurePassword,
			ISNULL([Azure SQL Instance Username],N'') as azureSQLUsername,
			ISNULL(dbo.pswConvertV5ToV3([Azure SQL Instance Password]),N'') as azureSQLPassword,
			ISNULL([Azure Certificate Thumbprint],N'') as thumbprint,
			ISNULL([Is Aws Configured],N'0') as isAwsConfigured,
			ISNULL([Aws Access Key],N'') as awsAccessKey,
			ISNULL([Aws Secret Key],N'') as awsSecretKey,
			ISNULL([S3 Bucket Name],N'') as s3BucketName,
			ISNULL([Aws SQL Instance Username],N'') as awsSqlInstanceUsername,
			ISNULL(dbo.pswConvertV5ToV3([Aws SQL Instance Password]), N'') as awsSqlInstancePassword,
			ISNULL([Cloud Proxy Servers],N'') as proxies
	INTO	#TEMP_APP_SQL61PROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[MSSQL Override Global Authentication],
				[MSSQL Use Windows Authentication],
				[NULL],
				[MSSQL username],
				[MSSQL password],
				[Auto discover SQL Instance],
				[Staging Path For Restores Enabled],
				[Staging Path],
				[Manage content automatically],
				[Is Azure Configured],
				[Azure Tenant Id],
				[Azure Client Id],
				[Azure Subscription Id],
				[Azure Storage Connection String],
				[Azure Authentication Method],
				[Azure Username],
				[Azure Password],
				[Azure SQL Instance Username],
				[Azure SQL Instance Password],
				[Azure Certificate Thumbprint],
				[Is Aws Configured],
				[Aws Access Key],
				[Aws Secret Key],
				[S3 Bucket Name],
				[Aws SQL Instance Username],
				[Aws SQL Instance Password],
				[Cloud Proxy Servers]
			)
	) AS pvt
	--UPDATE #TEMP_APP_SQL61PROP
	--SET isOverrideGlobalAuthentication = (case	isOverrideGlobalAuthentication
 	--			WHEN '1' THEN 'true'
 	--			WHEN '0' THEN 'false'
 	--			ELSE 'false' END),
 	--	isUseWindowsAuthentication = (case	isUseWindowsAuthentication
 	--			WHEN '1' THEN 'true'
 	--			WHEN '0' THEN 'false'
 	--			ELSE 'false' END),
 	--	isAutoDiscoverSQLInstances = (case	isAutoDiscoverSQLInstances
 	--			WHEN '1' THEN 'true'
 	--			WHEN '0' THEN 'false'
 	--			ELSE 'false' END),
	--	isStagingPathForRestoresEnabled = (case	isStagingPathForRestoresEnabled
 	--			WHEN '1' THEN 'true'
 	--			WHEN '0' THEN 'false'
 	--			ELSE 'false' END),
 	--	canManageContentAutomaticallyFlag = (case	canManageContentAutomaticallyFlag
 	--			WHEN '1' THEN 'true'
 	--			WHEN '0' THEN 'false'
 	--			ELSE 'false' END)
     --IF ( SELECT useLocalSystemAccount FROM #TEMP_APP_SQL61PROP ) = '0'
     --BEGIN
		-- This property needs to be set so that
		-- the stored procedure, AppGetSqlAuth does not fail
	--	INSERT INTO APP_IDAProp values (@id,'MSSQL Use Windows Authentication',
	--							2,'0',dbo.GetUnixTime(GETDATE()),0,0)
	--
     --END
     IF @r_QNetRegStatus =0
		BEGIN
			IF (SELECT COUNT(*) from #TEMP_APP_SQL61PROP) > 0
				SELECT @i_appTypeId,I.overrideGlobalAuthentication,I.useLocalSystemAccount,I.impersonateUser,I.userName,I.password,
				I.isAutoDiscoverSQLInstances,
				I.isStagingPathForRestoresEnabled,
				I.stagingPath,
				I.canManageContentAutomaticallyFlag,
				I.isAzureConfigured,
				I.azureTenantId,
				I.azureClientId,
				I.azureSubscriptionId,
				I.azureStorageConnectionString,
				I.azureAuthenticationMethod,
				I.azureUsername,
				I.azurePassword,
				I.azureSQLUsername,
				I.azureSQLPassword,
				I.thumbprint,
				I.isAwsConfigured,
				I.awsAccessKey,
				I.awsSecretKey,
				I.s3BucketName,
				I.awsSqlInstanceUsername,
				I.awsSqlInstancePassword,
				I.proxies,
				1,
				'',
      			(SELECT r_AssocLevel = (CASE WHEN @r_AssocLevel IS null THEN 0
      				ELSE @r_AssocLevel
      				END)
      			)
				FROM #TEMP_APP_SQL61PROP I
      	END
      	IF (SELECT COUNT(*) from #TEMP_APP_SQL61PROP) = 0
      		SELECT @i_appTypeId, N'1',N'0', N'0',N'',N'',N'0',N'0',N'', N'0', N'0', N'', N'', N'', N'', N'1', N'', N'', N'', N'', N'', N'0', N'', N'', N'', N'', N'', N'', 0, '', ''
     RETURN
END
--lookupUnixProxyHostProperties
--IF	@i_appTypeId = LEGACY_CV_APPTYPE_UNIX_PROXYHOST OR
--		@i_appTypeId = CV_APPTYPE_PROXYHOST_IMAGELEVEL_UNIX OR
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupLINUXProperties
--IF	@i_appTypeId = CV_APPTYPE_LINUX_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupSolarisProperties
--IF	@i_appTypeId = CV_APPTYPE_SOLARIS_FS OR
--		@i_appTypeId = CV_APPTYPE_FREE_BSD
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupSGIProperties
--IF	@i_appTypeId = CV_APPTYPE_SGI_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupAppleProperties
--IF	@i_appTypeId = CV_APPTYPE_APPLEMAC_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupHPUXProperties
--IF	@i_appTypeId = CV_APPTYPE_HPUX_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupAIXProperties
--IF	@i_appTypeId = CV_APPTYPE_AIX_FS
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
--lookupUNIXTru64Properties
--IF	@i_appTypeId = CV_APPTYPE_UNIX_TRU64_FS_64
--BEGIN
		--Currently there are no agent specific properties, so empty
--END
-- lookupAzureADProperties
IF @i_appTypeId = 139
BEGIN
	SELECT (
			SELECT
			(
				SELECT po.query('.')
				FROM
				(
					SELECT CAST(REPLACE([AD Azure Connections],'UTF-8','UTF-16') AS XML) azureConnections
				) PROP
				CROSS APPLY PROP.azureConnections.nodes('./App_Office365AzureConnections/azureApps') P(po)
				FOR XML PATH(''),TYPE
			)
		) as azureAppList,
	   (
			SELECT
			(
				SELECT po.query('.')
				FROM
				(
					SELECT CAST(REPLACE([Azure AD Admin Accounts],'UTF-8','UTF-16') AS XML) serviceAccounts
				) PROP
				CROSS APPLY PROP.serviceAccounts.nodes('./App_AzureADServiceAccounts/accounts') P(po)
				FOR XML PATH(''),TYPE
			)
		) as serviceAccounts,
	   ISNULL([Azure AD Member Servers],N'') as memberServers,
	   ISNULL([Azure AD Index Server],N'') as indexServerId,
	   ISNULL((SELECT name FROM app_client WITH(NOLOCK) WHERE id = [Azure AD Index Server]),N'') as indexServerName,
	   ISNULL([MSCloud Region Type],N'0') as msCloudRegion
	INTO	#TEMP_APP_AZUREADPROP
	FROM
	(
			SELECT componentNameId, attrName, attrVal
				FROM APP_IDAProp WITH(NOLOCK)
				WHERE componentNameId = @id
				AND	modified = 0
	)	AS	IDAs
	PIVOT
	(
			max(attrVal)
			FOR attrName IN
			(
				[AD Azure Connections],
				[Azure AD Admin Accounts],
				[Azure AD Member Servers],
				[Azure AD Index Server],
				[MSCloud Region Type]
			)
	) AS pvt
	IF (SELECT COUNT(*) from #TEMP_APP_AZUREADPROP) = 0
		SELECT @i_appTypeId, NULL, NULL, N'', N'0',N'',N'0'
	ELSE
		SELECT @i_appTypeId, azureAppList, serviceAccounts, memberServers, indexServerId, indexServerName, msCloudRegion
		FROM #TEMP_APP_AZUREADPROP
	RETURN
END


IF EXISTS (select * from GxQscripts where name = 'APPGetAgentProperties')
	delete from GxQscripts where name = 'APPGetAgentProperties'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetAgentProperties')
	delete from GXDBVersions where aliasname = 'APPGetAgentProperties'
GO

insert into GXDBVersions values(2, 'APPGetAgentProperties',  '00000000000000000000', 'APPGetAgentProperties', '00000000000000000000')
GO

