

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGetActivityControl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGetActivityControl.sp,v $ $Id: APPGetActivityControl.sp,v 1.8.2.5 2018/06/01 13:03:48 dpark Exp $";
--	+===================================================================+
--	| APPGetActivityControl - PRIMARY ENTRY POINT FOR ALL CCP OPS			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGetActivityControl <<<'

IF EXISTS (select * from sysobjects where name='APPGetActivityControl')
	drop procedure APPGetActivityControl
IF EXISTS (select * from GxQscripts where name='APPGetActivityControl')
	delete from GxQscripts where name = 'APPGetActivityControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetActivityControl')
	delete from GXDBVersions where aliasname = 'APPGetActivityControl'
GO
print '... Creating Procedure: APPGetActivityControl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGetActivityControl
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @ownerID int,
  @xmlString varchar(MAX)
-----------------------------------------------------------
AS
SET NOCOUNT ON
DECLARE	@function        AS varchar(80)                = 'APPGetActivityControl'
DECLARE @errorCode		 AS integer					   = 0
DECLARE @errorString	 AS varchar(2048)			   = ''
DECLARE @brAlertTrace	 AS varchar(256)               = (select value from gxglobalParam Where name = 'bralertTrace')
DECLARE @dateTime		AS DATETIME = getDate()
if @brAlertTrace <> 0
	exec br_ntTrace '.. APPGetActivityControl', 0, @dateTime, 0, 0, @xmlString
BEGIN TRY
----------------------------------------------------------
---	HERE IS WHERE WE WILL EXTRACT THE XML TO:		   ---
----------------------------------------------------------
DECLARE @iDoc			integer
DECLARE	@commcellId		integer
DECLARE @clientId		integer
DECLARE @appTypeId		integer
DECLARE @clientGroupId	integer
DECLARE @appId 			integer
DECLARE @drSubclientId	integer
DECLARE @instanceID		INTEGER
DECLARE @drInstanceID	INTEGER
DECLARE @defaultCSID	as integer = 2
----------------------------------------------------------
--<App_ActivityControlAdvancedListReq><entity applicationId="33" clientId="2" commCellId="0" /></App_ActivityControlAdvancedListReq>'
-----------------------------------------------
--- EXTRACT FROM THE XML					---
-----------------------------------------------
	exec sp_xml_preparedocument @iDoc OUTPUT, @xmlString
	set @drSubclientId  =  ISNULL((select top 1 id from APP_Application
where appTypeId= 1000),1)
	set @drInstanceID  =  ISNULL((select top 1 instance from APP_Application
where appTypeId= 1000),1)
	set @commCellId		=  ISNULL((select * from OPENXML(@iDoc, 'App_ActivityControlAdvancedListReq/entity', @defaultCSId)
							WITH (commCellId int '@commCellId')), 0)
	set @clientId		=  ISNULL((select * from OPENXML(@iDoc, 'App_ActivityControlAdvancedListReq/entity', 0)
							WITH (clientId int '@clientId')), 1)  -- 1 is 'all clients' in jmJobActionTable
	set @appTypeId		=  ISNULL((select * from OPENXML(@iDoc, 'App_ActivityControlAdvancedListReq/entity', 0)
							WITH (applicationId int '@applicationId')), 0)
	set @clientGroupId	=  ISNULL((select * from OPENXML(@iDoc, 'App_ActivityControlAdvancedListReq/entity', 0)
							WITH (clientGroupId int '@clientGroupId')), 0)
	set @appId 			= 	ISNULL((select * from OPENXML(@iDoc, 'App_ActivityControlAdvancedListReq/entity', 0)
							WITH (AppId int '@appId')),@drSubclientId)
	set @instanceID 		= 	ISNULL((select * from OPENXML(@iDoc, 'App_ActivityControlAdvancedListReq/entity', 0)
							WITH (InstanceID int '@instanceId')),@drInstanceID)
	IF @commcellId = 0						-- Per Anil P., 9.0 GUI may still send 0 for commcellId, so we need to "fix it" here
		SET @commcellId = @defaultCSID
--	Select step = 'debug', commCellId=@commCellId, clientId=@clientId, appTypeId=@appTypeId, clientGroupId=@clientGroupId
	EXEC sp_xml_removedocument @idoc
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
--------------------------------------------
-- THIS IS THE RESPONSE IF ALL WENT WELL ----
---------------------------------------------
SELECT  1       as TAG,
    NuLL        as Parent,
    NuLL        as [App_ActivityControlAdvancedListResp!1],
    NuLL		as [acObjects!2!activityType],
    NuLL		as [acObjects!2!enabled],
    NuLL		as [acObjects!2!reenableTimeZone],
    NuLL		as [acObjects!2!reEnableTime],
    NuLL		as [acObjects!2!noSchedEnable]
UNION ALL
SELECT 2, 1, NulL,
	CASE optype
	  WHEN     4 then    1	-- Backup
	  WHEN     5 then    2	-- Restore
	  WHEN    13 then    4	-- Aux Copy
	  WHEN    11 then    8	-- DR Backup
	  WHEN    10 then   16	-- Archive Prune
	  WHEN     9 then   32	-- Media Recycle
	  WHEN    14 then   64	-- Synthetic Full
	  WHEN     1 then  128  -- All Activity
	  WHEN    28 then  256	-- Schedule
	  WHEN    57 then  512	-- ContentIndexin (online?)
	  WHEN    53 then 1024	-- ContentIndexing Offline
	  WHEN   100 then 2048	-- DDB Activity
	  WHEN   31  then 8192  -- Data Verification
	  ELSE optype * -1
	END,
	CASE action
	  when 2 then 0
	  else 1
	END,
	enableTimeZone,
	UNCenableTime,
	CASE enableTime
		when 0 then 1
		else 0
	END
FROM JMJobAction WITH (NOLOCK)
WHERE clientId = @clientId
      AND mediaAgentID	= 1  -- Always?
      AND appType		= @appTypeId
      AND clientGroupId = @clientGroupId
      AND appId 		= @appId
	  AND instanceID	= @instanceID
      AND optype in ( 4,5, 13, 11 , 10, 9 ,14 ,1 , 28, 57 , 53, 100, 31 )
FOR XML EXPLICIT
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGetActivityControl')
	delete from GxQscripts where name = 'APPGetActivityControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGetActivityControl')
	delete from GXDBVersions where aliasname = 'APPGetActivityControl'
GO

insert into GXDBVersions values(2, 'APPGetActivityControl',  '00010008000200050000', 'APPGetActivityControl', '00010008000200050000')
GO

