

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGet3dfsExports.sp] ---------- 

-- This will generate the revision for the stored procedure. Don't remove this line!!!
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGet3dfsExports.sp,v $ $Id: APPGet3dfsExports.sp,v 1.1.2.12 2020/11/13 20:05:06 snashikkar Exp $";
-- Name of the stored procedure
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPGet3dfsExports')
BEGIN
	print '>>> Drop Stored Procedure: APPGet3dfsExports <<<'
	drop procedure APPGet3dfsExports
END
IF EXISTS (select * from GxQscripts where name='APPGet3dfsExports')
	delete from GxQscripts where name = 'APPGet3dfsExports'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGet3dfsExports')
	delete from GXDBVersions where aliasname = 'APPGet3dfsExports'
GO
print '... Creating Procedure: APPGet3dfsExports'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPGet3dfsExports
-- Input variables of the stored procedure
  @xmlRequest XML
-- Tell the AWK processor that body of query starts here
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
IF OBJECT_ID('temp.dbo.#userClients') IS NOT NULL DROP TABLE #userClients
CREATE TABLE #userClients
(
    clientId INT, appTypeId INT, instanceId INT, backupsetId INT, subclientId INT
)
DECLARE @xmlResult XML
DECLARE @operationType INT = ISNULL((SELECT @xmlRequest.value('(/App_Get3DFSShareReq/@opType)[1]','INT')), 0)
DECLARE @userId INT = ISNULL((SELECT @xmlRequest.value('(/App_Get3DFSShareReq/processinginstructioninfo/user/@userId)[1]','INT')),0)
DECLARE @shareId INT = ISNULL((SELECT @xmlRequest.value('(/App_Get3DFSShareReq/@shareId)[1]','INT')),0)
DECLARE @clientId INT = ISNULL((SELECT @xmlRequest.value('(/App_Get3DFSShareReq/@clientId)[1]','INT')),0)
DECLARE @subclientId INT = ISNULL((SELECT @xmlRequest.value('(/App_Get3DFSShareReq/subclient/@subclientId)[1]','INT')),0)
DECLARE @backupsetId INT = ISNULL((SELECT @xmlRequest.value('(/App_Get3DFSShareReq/backupset/@backupsetId)[1]','INT')),0)
-- Share ID is required for operations Get3DFSShareForShareId
IF (@operationType = 1 AND @shareId <= 0)
BEGIN
	SET	@xmlResult =
				(SELECT
					(SELECT 1 as '@errorCode',
						    'Error: Share ID is required for the Operation: ' + CAST(@operationType AS NVARCHAR(3)) as '@errorMessage'
					FOR XML PATH('errorResp'), TYPE)
				FOR XML PATH('App_Get3DFSShareResp'), TYPE)
	GOTO EXIT_PROCEDURE
END
-- Client ID is required for operations Get3DFSSharesForClientId
IF (@operationType = 2 AND @clientId <= 0)
BEGIN
	SET	@xmlResult =
				(SELECT
					(SELECT 1 as '@errorCode',
						    'Error: Client ID is required for the Operation: ' + CAST(@operationType AS NVARCHAR(3)) as '@errorMessage'
					FOR XML PATH('errorResp'), TYPE)
				FOR XML PATH('App_Get3DFSShareResp'), TYPE)
	GOTO EXIT_PROCEDURE
END
-- Subclient ID is required for operations Get3DFSSharesForSubClientId
IF (@operationType = 3 AND @subclientId <= 0)
BEGIN
	SET	@xmlResult =
				(SELECT
					(SELECT 1 as '@errorCode',
						    'Error: Subclient ID is required for the Operation: ' + CAST(@operationType AS NVARCHAR(3)) as '@errorMessage'
					FOR XML PATH('errorResp'), TYPE)
				FOR XML PATH('App_Get3DFSShareResp'), TYPE)
	GOTO EXIT_PROCEDURE
END
-- backupset ID is required for operations Get3DFSSharesForBackupSetId
IF (@operationType = 8 AND @backupsetId <= 0)
BEGIN
	SET	@xmlResult =
				(SELECT
					(SELECT 1 as '@errorCode',
						    'Error: Backupset ID is required for the Operation: ' + CAST(@operationType AS NVARCHAR(3)) as '@errorMessage'
					FOR XML PATH('errorResp'), TYPE)
				FOR XML PATH('App_Get3DFSShareResp'), TYPE)
	GOTO EXIT_PROCEDURE
END
DECLARE @isIDAConfigured INT = 1
IF(@userID<>0)
BEGIN
	EXEC sec_getIdaObjectsForUser @userId, 7 /*SUBCLIENT_ENTITY*/ , 0, 0, '#userClients'
	-- Check if userClients table is empty. If sec_getIdaObjectsForUser output
	-- does have any associations of subclient and backupSet with the userid, it means
	-- IDA is not configured for clientId being queried for 3dfs shares.
	-- If IDA is not configured, generate the userClients table using CLIENT_ENTITY (3)
	IF (@operationType = 2)
	BEGIN
		DECLARE @ObjectsForClient VARCHAR(1024)
		SET @ObjectsForClient = (SELECT DISTINCT clientId FROM #userClients where clientId=@clientId)
		IF @ObjectsForClient IS NULL
		BEGIN
			EXEC sec_getIdaObjectsForUser @userId, 3 /*CLIENT_ENTITY*/ , 0, 0, '#userClients'
			SET @isIDAConfigured = 0
		END
	END
END
IF (@isIDAConfigured = 1)
BEGIN
	SET @xmlResult = (SELECT
						(SELECT
							exp.id as '@shareId',
							exp.shareName as '@shareName',
							exp.foreverShare as '@isForeverShare',
							exp.copyPrecedence as '@copyPrecedence',
							exp.showDeleted as '@showDeleted',
							exp.isReadOnly as '@isReadOnly',
							exp.serverShareId as '@serverShareId',
							exp.objectGUID as '@objectGUID',
							exp.acl as '@acl',
							exp.status as '@status',
							exp.jobId as '@jobId',
							exp.fsmType as '@fsmType',
							exp.fsmSubtype as '@fsmSubtype',
							(SELECT exp.toTime as '@time'
							FOR XML PATH('toTime'), TYPE),
							(SELECT cl.id as '@mediaAgentId',
								cl.name as '@mediaAgentName'
							FOR XML PATH('tdfsServer'), TYPE),
							(SELECT
								app.id as '@subclientId',
								app.subclientName as '@subclientName',
								scBkp.name as '@backupsetName',
								scCl.id as '@clientId',
								scCl.name as '@clientName'
							FOR XML PATH('subclient'), TYPE),
							(SELECT
								bkp.id as '@backupsetId',
								bkp.name as '@backupsetName',
								ubkp.instanceId as '@instanceId',
								ubkp.appTypeId as '@applicationId',
								ubkp.clientId as '@clientId',
								bkpCl.name as '@clientName'
							FOR XML PATH('backupSet'), TYPE),
							(SELECT clIdx.id as '@mediaAgentId',
								clIdx.name as '@mediaAgentName'
							FOR XML PATH('indexingServer'), TYPE),
							(SELECT ip.data as '@val'
							FROM dbo.split(exp.nfsClients, ',') ip
							FOR XML PATH('nfsClients'), TYPE),
							(SELECT  exp.customParam.query('.')
							FOR XML PATH(''), TYPE)
						FROM APP_3DFSExportProps exp
							LEFT JOIN (SELECT DISTINCT clientId FROM #userClients) uCl ON uCl.clientId = exp.tdfsServerId
							LEFT JOIN APP_Client cl ON cl.id = uCl.clientId
							LEFT JOIN (SELECT DISTINCT clientId FROM #userClients) uClIdx ON uClIdx.clientId = exp.indexingMA
							LEFT JOIN APP_Client clIdx ON clIdx.id = uClIdx.clientId
							LEFT JOIN #userClients usc ON ( usc.subclientId = exp.subclientId ) --Dont select share if subclient is not visible
							LEFT JOIN (SELECT DISTINCT  backupsetid, instanceId, appTypeId, clientId FROM #userClients) ubkp ON ( ubkp.backupsetId = exp.backupsetId ) --Dont select share if backupSet is not visible
							LEFT JOIN APP_Application app ON app.id = exp.subclientId
							LEFT JOIN APP_BackupSetName bkp ON bkp.id = exp.backupsetId
							LEFT JOIN APP_BackupSetName scBkp ON scBkp.id = app.backupSet
							LEFT JOIN APP_Client scCl ON scCl.id = app.clientId
							LEFT JOIN APP_Client bkpCl ON bkpCl.id = ubkp.clientId
						WHERE
							((@operationType = 0 AND (exp.status & 0x08) = 0)				--GetAll3DFSShare
							OR (@operationType = 1 AND @shareId = exp.id) 					--Get3DFSShareForShareId
							OR (@operationType = 2 AND @clientId = cl.id) 					-- Get3DFSSharesForClientId
							OR (@operationType = 3 AND @subclientId = app.id AND (exp.status & 0x08) = 0) 	-- Get3DFSSharesForSubClientId
							OR (@operationType = 8 AND @backupsetId = bkp.id AND (exp.status & 0x08) = 0)) 	-- Get3DFSSharesForBackupSetId
							AND(
								(CASE WHEN exp.subclientId IS NOT NULL
						    		THEN (usc.subclientId)
								ELSE (ubkp.backupsetId) END IS NOT NULL) OR @operationType = 1)
						FOR XML PATH('tdfsShares'), TYPE)
					FOR XML PATH('App_Get3DFSShareResp'), TYPE)
END
ELSE
BEGIN
	SET @xmlResult = (SELECT
					(SELECT
						exp.id as '@shareId',
						exp.shareName as '@shareName',
						exp.foreverShare as '@isForeverShare',
						exp.copyPrecedence as '@copyPrecedence',
						exp.showDeleted as '@showDeleted',
						exp.isReadOnly as '@isReadOnly',
						exp.serverShareId as '@serverShareId',
						exp.objectGUID as '@objectGUID',
						exp.acl as '@acl',
						exp.status as '@status',
						exp.jobId as '@jobId',
						exp.fsmType as '@fsmType',
						exp.fsmSubtype as '@fsmSubtype',
						(SELECT exp.toTime as '@time'
						FOR XML PATH('toTime'), TYPE),
						(SELECT cl.id as '@mediaAgentId',
							cl.name as '@mediaAgentName'
						FOR XML PATH('tdfsServer'), TYPE),
						(SELECT
							app.id as '@subclientId',
							app.subclientName as '@subclientName',
							scBkp.name as '@backupsetName',
							scCl.id as '@clientId',
							scCl.name as '@clientName'
						FOR XML PATH('subclient'), TYPE),
						(SELECT
							bkp.id as '@backupsetId',
							bkp.name as '@backupsetName',
							ubkp.instance as '@instanceId',
							ubkp.appTypeId as '@applicationId',
							ubkp.clientId as '@clientId',
							bkpCl.name as '@clientName'
						FOR XML PATH('backupSet'), TYPE),
						(SELECT clIdx.id as '@mediaAgentId',
							clIdx.name as '@mediaAgentName'
						FOR XML PATH('indexingServer'), TYPE),
						(SELECT ip.data as '@val'
						FROM dbo.split(exp.nfsClients, ',') ip
						FOR XML PATH('nfsClients'), TYPE),
						(SELECT  exp.customParam.query('.')
						FOR XML PATH(''), TYPE)
					FROM APP_3DFSExportProps exp
						LEFT JOIN (SELECT DISTINCT clientId FROM #userClients) uCl ON uCl.clientId = exp.tdfsServerId
						LEFT JOIN APP_Client cl ON cl.id = uCl.clientId
						LEFT JOIN (SELECT DISTINCT clientId FROM #userClients) uClIdx ON uClIdx.clientId = exp.indexingMA
						LEFT JOIN APP_Client clIdx ON clIdx.id = uClIdx.clientId
						LEFT JOIN APP_Application app ON app.id = exp.subclientId
						LEFT JOIN APP_BackupSetName scBkp ON scBkp.id = app.backupSet
						LEFT JOIN APP_Client scCl ON scCl.id = app.clientId
						LEFT JOIN APP_BackupSetName bkp ON bkp.id = exp.backupsetId
						LEFT JOIN (select DISTINCT backupSet, instance, appTypeId, clientId from APP_Application) ubkp ON ( ubkp.backupset = exp.backupsetId)
						LEFT JOIN APP_Client bkpCl ON bkpCl.id = ubkp.clientId
					WHERE
						((@operationType = 2 AND @clientId = cl.id))  		-- Get3DFSSharesForClientId
					FOR XML PATH('tdfsShares'), TYPE)
				FOR XML PATH('App_Get3DFSShareResp'), TYPE)
END
EXIT_PROCEDURE:
	SELECT @xmlResult
GO

IF EXISTS (select * from GxQscripts where name = 'APPGet3dfsExports')
	delete from GxQscripts where name = 'APPGet3dfsExports'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGet3dfsExports')
	delete from GXDBVersions where aliasname = 'APPGet3dfsExports'
GO

insert into GXDBVersions values(2, 'APPGet3dfsExports',  '00010001000200120000', 'APPGet3dfsExports', '00010001000200120000')
GO

