

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPGeneratePassword.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPGeneratePassword.sp,v $ $Id: APPGeneratePassword.sp,v 1.1.2.1 2018/05/02 21:32:55 nramalingam Exp $";
-- ===================================================================================================================================================
-- Author: Niresh Ramalingam
-- Description:	Random generation of password based on the complexity defined in globalparam (pulled code from sec_createEncryptedPwd.sp)
-- ===================================================================================================================================================
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPGeneratePassword <<<'

IF EXISTS (select * from sysobjects where name='APPGeneratePassword')
	drop procedure APPGeneratePassword
IF EXISTS (select * from GxQscripts where name='APPGeneratePassword')
	delete from GxQscripts where name = 'APPGeneratePassword'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGeneratePassword')
	delete from GXDBVersions where aliasname = 'APPGeneratePassword'
GO
print '... Creating Procedure: APPGeneratePassword'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPGeneratePassword
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
--
--   PARAMETERS   &   OUTPUTS
--
--+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+-+
  @o_password NVARCHAR(8) ='' OUTPUT
AS
-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
BEGIN
	DECLARE @alphaU varchar(28) = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
	DECLARE @alphaL varchar(28) = 'abcdefghijklmnopqrstuvwxyz'
	DECLARE @numbers varchar(10) = '0123456789'
	DECLARE @specialChars NVARCHAR(28) = '!@#$%^&*()_+=.,;:''"`~<>?/'
	DECLARE @COMPLEXITY_LEVEL_NO INT = 1
	DECLARE @COMPLEXITY_LEVEL_MEDIUM INT = 2
	DECLARE @COMPLEXITY_LEVEL_STRONG INT = 3
	DECLARE @passwordComplexityLevel INT = ISNULL((SELECT value FROM GXGlobalParam WHERE name = 'passwordComplexityLevel'), @COMPLEXITY_LEVEL_NO)
	SET @o_password =''
	IF @passwordComplexityLevel = @COMPLEXITY_LEVEL_NO
	BEGIN
		SET @o_password = (select substring(@alphaL, convert(int, rand()*24+1), 1) + substring(@alphaL, convert(int, rand()*24+1), 1)
		+  substring(@alphaL, convert(int, rand()*24+1), 1) + substring(@alphaL, convert(int, rand()*24+1), 1)
		+ substring(@alphaL, convert(int, rand()*24+1), 1) + substring(@alphaL, convert(int, rand()*24+1), 1) )
	END
	ELSE IF @passwordComplexityLevel = @COMPLEXITY_LEVEL_MEDIUM
	BEGIN
		SET @o_password = (select substring(@alphaL, convert(int, rand()*24+1), 1) + substring(@alphaL, convert(int, rand()*24+1), 1)
		+ substring(@alphaU, convert(int, rand()*24+1), 1) + substring(@alphaL, convert(int, rand()*24+1), 1)
		+ substring(@numbers, convert(int, rand()*8+1), 1) +  substring(@alphaL, convert(int, rand()*24+1), 1)
		+ substring(@specialChars, convert(int, rand()*24+1), 1) +  substring(@alphaL, convert(int, rand()*24+1), 1))
	END
	ELSE IF @passwordComplexityLevel = @COMPLEXITY_LEVEL_STRONG
	BEGIN
		SET @o_password = (select substring(@alphaL, convert(int, rand()*24+1), 1) + substring(@alphaL, convert(int, rand()*24+1), 1)
		+ substring(@alphaU, convert(int, rand()*24+1), 1) + substring(@alphaU, convert(int, rand()*24+1), 1)
		+ substring(@numbers, convert(int, rand()*8+1), 1) + substring(@numbers, convert(int, rand()*8+1), 1)
		+ substring(@specialChars, convert(int, rand()*24+1), 1) + substring(@specialChars, convert(int, rand()*24+1), 1) )
	END
END
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPGeneratePassword')
	delete from GxQscripts where name = 'APPGeneratePassword'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPGeneratePassword')
	delete from GXDBVersions where aliasname = 'APPGeneratePassword'
GO

insert into GXDBVersions values(2, 'APPGeneratePassword',  '00010001000200010000', 'APPGeneratePassword', '00010001000200010000')
GO

