

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPComputeClientGroupScope.sp] ---------- 

-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPComputeClientGroupScope.sp,v $ $Id: APPComputeClientGroupScope.sp,v 1.1.2.6 2020/11/20 15:38:43 jswaminathan Exp $";
-- 	+-----------------------------------------------------------------------------------+
--	| 			Procedure : "AppComputeClientGroupScope"
--	|	This Procedure is used to compute max SCG scope of a user - CC, company, UG, user.
-- 	+-----------------------------------------------------------------------------------+
SET ANSI_NULLS ON
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPComputeClientGroupScope')
BEGIN
	print '>>> Drop Stored Procedure: APPComputeClientGroupScope <<<'
	drop procedure APPComputeClientGroupScope
END
IF EXISTS (select * from GxQscripts where name='APPComputeClientGroupScope')
	delete from GxQscripts where name = 'APPComputeClientGroupScope'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPComputeClientGroupScope')
	delete from GXDBVersions where aliasname = 'APPComputeClientGroupScope'
GO
print '... Creating Procedure: APPComputeClientGroupScope'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPComputeClientGroupScope
-- Input arguments
  @i_userId INT, 
  @o_scopeEntityType INT OUTPUT,
  @o_scopeEntityId INT OUTPUT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @r_RuleData XML;
BEGIN
	SET NOCOUNT ON
	DECLARE @cgScopeType INT = NULL		-- EntityType: Commcell (CS Admin), Provider (Tenant-Admin), User (regular user)
	DECLARE @cgScopeId INT = NULL		-- EntityId: Commcell Id(2), Provider Id, User Id
	-- Rewriting the previous code to use Sec SP to check for Commcell permissions.
	-- If user has Agent Management + Change Security permission on Commcell, then his default scope is Commcell.
	BEGIN
		DECLARE @userHasCommcellPermissions INT = 0
		EXEC sec_checkPermissionOnEntity	@userId = @i_userId,
@permissionIdList = '2, 107',			-- (2,107)
											@isAllowed = @userHasCommcellPermissions OUTPUT,
@entityType1 = 1,
@entityId1 = 2,
											@AndOperation = 1
		IF @userHasCommcellPermissions = 1
SET @cgScopeType = 1
	END
	IF (@cgScopeType IS NULL)
	BEGIN
		-- Get list of companies which user has Agent Managment + change security permissions.
		-- Going forward, this is the correct way to check, instead of just checking for Tenant Admin user group membership.
		-- This way, tenant admins, operators, and any other UGs in future will get covered.
		IF OBJECT_ID('tempdb.dbo.#getNameServers_AgentMgmt') IS NOT NULL
			DROP TABLE #getNameServers_AgentMgmt
		CREATE TABLE #getNameServers_AgentMgmt
		(
			entityId INT PRIMARY KEY
		)
		IF OBJECT_ID('tempdb.dbo.#getNameServers_UserMgmt') IS NOT NULL
			DROP TABLE #getNameServers_UserMgmt
		CREATE TABLE #getNameServers_UserMgmt
		(
			entityId INT PRIMARY KEY
		)
		-- Get only those Companies on which User has both the permissions. We need to call the Security SP twice to get this, no other way arnd.
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 61, 2, '#getNameServers_AgentMgmt'
EXEC sec_getNonIdaObjectsForThisUser @i_userId, 61, 107, '#getNameServers_UserMgmt'
		SELECT TOP 1
			@cgScopeType = 61,
			@cgScopeId = AMNS.entityId
		FROM #getNameServers_AgentMgmt AMNS
			INNER JOIN #getNameServers_UserMgmt UMNS
				ON AMNS.entityId = UMNS.entityId
			INNER JOIN UMDSProviders P (NOLOCK)
				ON AMNS.entityId = P.id AND P.serviceType = 5
		ORDER BY AMNS.entityId ASC
		IF (@cgScopeType IS NULL)
		BEGIN
			-- Still not set then a regular user
			-- Now need to check if User has user group rights
			-- Aligning this with Get SCG Scope Entities For User SP. Get only the member UGs.
			IF OBJECT_ID('tempdb.dbo.#userGroupId') IS NOT NULL		-- a well known extenral temp table to be passed to get member user groups SP.
				DROP TABLE #userGroupId
			CREATE TABLE #userGroupId
			(
				userGroupId INT
			)
			EXEC sec_getMemberUserGroups @i_userId
			DECLARE @gid INT = NULL
			SELECT TOP (1)
				@gid = userGroupId
			FROM #userGroupId
			IF (@gid IS NOT NULL AND @gid > 0)
			BEGIN
				-- Can see user groups
				SET @cgScopeType = 15		-- USERGROUP_ENTITY
				SET @cgScopeId = @gid
			END
			ELSE
			BEGIN
				SET @cgScopeType = 13		-- USER_ENTITY
				SET @cgScopeId = @i_userId
			END
		END
	END
	ELSE
	BEGIN
		SET @cgScopeId = 2	-- User is CS Admin so scope is Commcell
	END
	-- Return OUTPUT Arguments
	SET @o_scopeEntityType = @cgScopeType
	SET @o_scopeEntityId = @cgScopeId
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPComputeClientGroupScope')
	delete from GxQscripts where name = 'APPComputeClientGroupScope'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPComputeClientGroupScope')
	delete from GXDBVersions where aliasname = 'APPComputeClientGroupScope'
GO

insert into GXDBVersions values(2, 'APPComputeClientGroupScope',  '00010001000200060000', 'APPComputeClientGroupScope', '00010001000200060000')
GO

