

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCheckLoginRequiredForUser.sp] ---------- 

--	+================================================================================================================================+
--	| APPCheckLoginRequiredForUser - Gets userId for a given username or checks if login for the username is needed to pulldown user.|
--	+================================================================================================================================+
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPCheckLoginRequiredForUser')
BEGIN
	print '>>> Drop Stored Procedure: APPCheckLoginRequiredForUser <<<'
	drop procedure APPCheckLoginRequiredForUser
END
IF EXISTS (select * from GxQscripts where name='APPCheckLoginRequiredForUser')
	delete from GxQscripts where name = 'APPCheckLoginRequiredForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCheckLoginRequiredForUser')
	delete from GXDBVersions where aliasname = 'APPCheckLoginRequiredForUser'
GO
print '... Creating Procedure: APPCheckLoginRequiredForUser'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCheckLoginRequiredForUser
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
  @username nvarchar(256)
-----------------------------------------------------------
AS
  DECLARE @userId int 
  DECLARE @isLoginRequired int 
	SET NOCOUNT ON
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
declare @substring nvarchar(256)
declare @id int
declare @componentID table(id integer)
SET @isLoginRequired = 0
SET @userId = 0
IF @username <> ''
BEGIN
select top 1 @userId = id from UMUSERS where login = @username or email = @username order by id asc -- handle for multiple users with same email.
if @userId is null or @userId = 0 -- No existing user with same username or email.
BEGIN
	IF CHARINDEX('@', @username, 1) > 0 -- Check for email.
	BEGIN
		SET @substring = SUBSTRING(@username, CHARINDEX('@', @username, 1) + 1, LEN(@username)) -- Email extension.
		insert into @componentID exec AppGetComponentIdForEmailExt @substring -- Check if email extension exists in APP_ComponentProp table.
		SELECT @id = ID from @componentID
		IF (@id is null or @id < 0) -- If no such extension exists in APP_ClientProp table.
		BEGIN
			-- Check user group emails
			select @id = id from UMGroups where email like Concat('%', SUBSTRING(@username, CHARINDEX('@', @username, 1) , LEN(@username))) AND umdsProviderId > 0
			IF (@id is null or @id <= 0) -- Nothing is found in groups, We have no match for the user's email
			BEGIN
			-- Check user group emails
				SET @isLoginRequired = 0
			END
			ELSE -- Atleast one group has same email extension as user's email, Login is needed to pull down information.
			BEGIN
				SET @isLoginRequired = 1
			END
		END
		else
		BEGIN
			SET @isLoginRequired = 1 -- Extension exists in APP_ClientProp table. Login is needed to pull down info.
		END
	END
	ELSE IF CHARINDEX('\', @username, 1) > 0 -- DOmain login.
	BEGIN
		SET @substring = SUBSTRING(@username, 0, CHARINDEX('\', @username, 1)) -- Get domain name.
		IF EXISTS(SELECT ID from UMDSProviders where domainName = @substring and enabled = 1 ) -- If the domain name is registered,
		BEGIN
			SET @isLoginRequired = 1 -- Then login is needed for user's information
		END
		ELSE
		BEGIN
			SET @isLoginRequired = 0 -- Else don't bother
		END
	END
END
END
select @userId, @isLoginRequired
GO

IF EXISTS (select * from GxQscripts where name = 'APPCheckLoginRequiredForUser')
	delete from GxQscripts where name = 'APPCheckLoginRequiredForUser'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCheckLoginRequiredForUser')
	delete from GXDBVersions where aliasname = 'APPCheckLoginRequiredForUser'
GO

insert into GXDBVersions values(2, 'APPCheckLoginRequiredForUser',  '00000000000000000000', 'APPCheckLoginRequiredForUser', '00000000000000000000')
GO

