

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCheckIndexServerDelDependency.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
SET ANSI_NULLS ON
SET NOCOUNT ON
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPCheckIndexServerDelDependency')
BEGIN
	print '>>> Drop Stored Procedure: APPCheckIndexServerDelDependency <<<'
	drop procedure APPCheckIndexServerDelDependency
END
IF EXISTS (select * from GxQscripts where name='APPCheckIndexServerDelDependency')
	delete from GxQscripts where name = 'APPCheckIndexServerDelDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCheckIndexServerDelDependency')
	delete from GXDBVersions where aliasname = 'APPCheckIndexServerDelDependency'
GO
print '... Creating Procedure: APPCheckIndexServerDelDependency'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPCheckIndexServerDelDependency
  @i_indexServerClientId INT,
  @i_roleIDList VARCHAR(255)='',
  @i_localeId INT = 0,
  @o_errorCode INT		OUTPUT,
  @o_errorStr VARCHAR(512) OUTPUT
AS
DECLARE @entityNames	nvarchar(max)
DECLARE @msgId	INT = 0
SET @o_errorCode = 0
--check if forceDeleteIndexServer is enabled
--Skip dependency check
IF EXISTS (SELECT TOP 1 1 FROM GXGlobalParam (NOLOCK) WHERE NAME ='forceDeleteIndexServer' AND VALUE ='1')
RETURN;
DECLARE @componentId INT
--check if input client is index server client
IF OBJECT_ID('tempdb.dbo.#associatedClients') IS NOT NULL     DROP TABLE #associatedClients
CREATE TABLE #associatedClients
                    (
                            entityName NVARCHAR(256)
                    )
--input roleId
IF OBJECT_ID('tempdb.dbo.#roleIdsTbl') IS NOT NULL     DROP TABLE #roleIdsTbl
CREATE TABLE #roleIdsTbl    ( roleId INT)
--check if input client is index server client
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL     DROP TABLE #getIndexServers
CREATE TABLE #getIndexServers
                    (     serverURL NVARCHAR(512),
                            clientId INT,
                            clientName NVARCHAR(256),
                            cloudId INT,
                            hostName NVARCHAR(256),
                            basePort INT,
                            engineName  NVARCHAR(256),
                            serverType INT,
                            indexServerClientId INT,
                            internalCloudName NVARCHAR(256)
                    )
EXEC DM2GetIndexServers '', @i_indexServerClientId
--Check if index server has associated to given roles
IF @i_roleIDList != ''
BEGIN
	INSERT INTO #roleIdsTbl
	SELECT _ID
	FROM dbo.splitIds(@i_roleIDList) T
	JOIN DM2CloudCoreRole R (NOLOCK) ON T._ID = R.roleId
	JOIN #getIndexServers S ON R.cloudId = S.cloudId
END
--index server is configured
IF EXISTS(SELECT TOP 1 1 FROM #getIndexServers)
BEGIN
	-- check if index server is associated to any other client
	--exchange agent
IF @i_roleIDList = '' OR EXISTS (SELECT TOP 1 1 FROM #roleIdsTbl WHERE roleId = 12)
	BEGIN
		INSERT INTO #associatedClients (entityName)
		SELECT DISTINCT C.name
		FROM  App_IdaProp IP (NOLOCK)
		JOIN  APP_IDAName IDN (NOLOCK) ON IP.componentNameId = IDN.ID
		JOIN  APP_Client C (NOLOCK) ON IDN.clientId = C.id
		JOIN  #getIndexServers S ON S.indexServerClientId = CAST (IP.AttrVal AS INT)
		WHERE  IP.attrName = 'OnePass Index Server' AND  IP.modified = 0
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (3639 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
	END
	--DC Plan
IF @i_roleIDList = '' OR EXISTS (SELECT TOP 1 1 FROM #roleIdsTbl WHERE roleId = 17 )
	BEGIN
		INSERT INTO #associatedClients (entityName)
		SELECT DISTINCT PL.name
		FROM  App_PlanProp PROP (NOLOCK)
		JOIN  App_Plan PL (NOLOCK) ON PROP.componentNameId = PL.ID
		JOIN  #getIndexServers S ON S.indexServerClientId = CAST (PROP.AttrVal AS INT)
		WHERE  PROP.attrName = 'Analytics Index Server Id' AND PROP.modified = 0
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (3636 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
		--delete previous entries
		DELETE FROM #associatedClients
		--File indexing is enabled on VMgroup [name]. Please disable it and try again.
		--Allow deletion of index server if VM subclient is already deleted
		INSERT INTO #associatedClients (entityName)
		SELECT DISTINCT S.subClientName
		FROM  App_SubClientProp PROP (NOLOCK)
		JOIN  #getIndexServers SRV ON SRV.indexServerClientId = CAST (PROP.AttrVal AS INT)
		JOIN APP_Application S (NOLOCK) ON PROP.componentNameid = S.id
		LEFT OUTER JOIN APP_ClientProp ACP (NOLOCK)  ON ACP.componentNameId=S.clientId AND ACP.attrName='Virtual Server Discovered Clients' AND ACP.attrVal='1' AND ACP.modified=0
WHERE  PROP.attrName = 'Associated index server id' AND PROP.modified = 0 AND (S.subclientStatus & 0x00004) =0
				AND ACP.id IS NULL
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (4392 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
	END
	--Edge Drive
IF @i_roleIDList = '' OR EXISTS (SELECT TOP 1 1 FROM #roleIdsTbl WHERE roleId = 7 )
	BEGIN
		INSERT INTO #associatedClients (entityName)
		SELECT DISTINCT C.Name
		FROM  App_EdgeDriveAssociation EDGE (NOLOCK)
		JOIN  APP_Client C (NOLOCK) ON EDGE.clientId = C.id
		JOIN  #getIndexServers S ON S.indexServerClientId = EDGE.entityId
		WHERE  EDGE.entityType = 3
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (3638 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
	END
	--FileSystem Index
IF @i_roleIDList = '' OR EXISTS (SELECT TOP 1 1 FROM #roleIdsTbl WHERE roleId = 15 )
	BEGIN
		INSERT INTO #associatedClients (entityName)
		SELECT DISTINCT  C.name
		FROM App_IndexDBInfo idx (NOLOCK)
		JOIN App_Application P (NOLOCK) ON idx.backupSetId = P.backupSet
		JOIN App_Client C (NOLOCK) ON C.Id = P.clientId
		JOIN  #getIndexServers S ON S.indexServerClientId = idx.currentIdxServer
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (3641 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
	END
/*	TO do
	--DownLoad Center
IF @i_roleIDList = '' OR EXISTS (SELECT TOP 1 1 FROM #roleIdsTbl WHERE roleId = 4 )
	BEGIN
		INSERT INTO #associatedClients (entityName)
		SELECT  S.clientName
		FROM GXGlobalParam G (NOLOCK)
		JOIN  #getIndexServers S ON S.indexServerClientId = CAST (G.value AS INT)
		WHERE G.name = 'DOWNLOAD_CENTER_INDEX_SERVER_CLIENTID'
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (3637 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
	END
	*/
	--ReviewSet
IF @i_roleIDList = '' OR EXISTS (SELECT TOP 1 1 FROM #roleIdsTbl WHERE roleId = 8 )
	BEGIN
		--there can be lots of reviewsets, just show top 5 recent ones in the error message
		INSERT INTO #associatedClients (entityName)
		SELECT TOP 5 C.containerName
		FROM DM2Container C (NOLOCK)
		JOIN  #getIndexServers S ON S.cloudId = C.cloudId
		ORDER BY createTime DESC
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (3643 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
	END
	--log monitoring
IF @i_roleIDList = '' OR EXISTS (SELECT TOP 1 1 FROM #roleIdsTbl WHERE roleId = 3 )
	BEGIN
		INSERT INTO #associatedClients (entityName)
		SELECT  DISTINCT MP.MonitorPolicyName
		FROM APP_MonitoringPolicyProp MPROP (NOLOCK)
		JOIN APP_MonitoringPolicy MP (NOLOCK) ON MP.monitorPolicyId = MPROP.monitorPolicyId
		JOIN  #getIndexServers S ON S.cloudId = CAST (MPROP.attrVal AS INT)
		WHERE MPROP.attrName = 'Cloud Id' AND MP.status = 0
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (3642 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
	END
	--Data Analytics schedule
IF @i_roleIDList = '' OR EXISTS (SELECT TOP 1 1 FROM #roleIdsTbl WHERE roleId = 2 )
	BEGIN
		INSERT INTO #associatedClients (entityName)
		SELECT DISTINCT ST.subTaskName
		FROM TM_SubTask ST WITH (NOLOCK)
			JOIN TM_Task T WITH (NOLOCK)  ON ST.taskId = T.taskId
			JOIN TM_SubTaskOptions SO WITH (NOLOCK) ON ST.subTaskId = SO.subTaskId AND SO.optionId = 2101836446 /*--INDEXSERVER_CLIENT_ID*/ AND SO.value = @i_indexServerClientId
WHERE ST.operationType = 4022 AND T.disabled = 0 AND T.deleted = 0 AND T.taskType = 2
		IF EXISTS (SELECT TOP 1 1 FROM #associatedClients)
		BEGIN
SET @msgId = (3640 | (CAST(POWER(2, 24) AS BIGINT) * 35))
			SET @o_errorCode = 12710  --CLOUD_DELETE_FAILED
			SELECT @entityNames = COALESCE(@entityNames+',' ,'') + entityName FROM  #associatedClients
			GOTO error_exit
		END
	END
END
IF OBJECT_ID('tempdb.dbo.#getIndexServers') IS NOT NULL    DROP TABLE #getIndexServers
IF OBJECT_ID('tempdb.dbo.#associatedClients') IS NOT NULL     DROP TABLE #associatedClients
IF OBJECT_ID('tempdb.dbo.#roleIdsTbl') IS NOT NULL     DROP TABLE #roleIdsTbl
--OUTPUT
error_exit:
SELECT @o_errorStr = dbo.fn_EvFormatEventMsgText(0, @i_localeId, @msgId, 0,2)
SET  @o_errorStr = REPLACE(@o_errorStr, '[]', '[' + @entityNames +']')
RETURN;
-- Tell the AWK processor that there are no more input lines to scan
GO

IF EXISTS (select * from GxQscripts where name = 'APPCheckIndexServerDelDependency')
	delete from GxQscripts where name = 'APPCheckIndexServerDelDependency'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCheckIndexServerDelDependency')
	delete from GXDBVersions where aliasname = 'APPCheckIndexServerDelDependency'
GO

insert into GXDBVersions values(2, 'APPCheckIndexServerDelDependency',  '00000000000000000000', 'APPCheckIndexServerDelDependency', '00000000000000000000')
GO

