

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCheckActivityControl.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCheckActivityControl.sp,v $ $Id: APPCheckActivityControl.sp,v 1.11.60.6 2020/04/22 04:28:17 rengu Exp $";
--	+===================================================================+
--	| APPCheckActivityControl - PRIMARY ENTRY POINT FOR ALL CCP OPS			|
--	+===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPCheckActivityControl')
BEGIN
	print '>>> Drop Stored Procedure: APPCheckActivityControl <<<'
	drop procedure APPCheckActivityControl
END
IF EXISTS (select * from GxQscripts where name='APPCheckActivityControl')
	delete from GxQscripts where name = 'APPCheckActivityControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCheckActivityControl')
	delete from GXDBVersions where aliasname = 'APPCheckActivityControl'
GO
print '... Creating Procedure: APPCheckActivityControl'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCheckActivityControl
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS							---
-----------------------------------------------------------
  @options int
-----------------------------------------------------------
AS
SET NOCOUNT ON
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED
DECLARE @errorCode		 AS integer					   = 0
DECLARE @errorString	 AS varchar(2048)			   = ''
DECLARE	@function        AS varchar(80)                = 'APPCheckActivityControl'
DECLARE @brAlertTrace	 AS varchar(256)               = ISNULL((select value from gxglobalParam Where name = 'bralertTrace'),'0')
DECLARE @messBuf		 AS varchar(2048) 			   = ''
DECLARE @dateTime		AS DATETIME = getDate()
if @brAlertTrace > 1						-- Since this is is called often, raise debug level
BEGIN
	SET @messBuf = 'Options: ' + convert(varchar(20), @options)
	exec br_ntTrace '.. APPCheckActivityControl', 0, @dateTime, 0, 0, @messBuf
END
BEGIN TRY
----------------------------------------------------------
---	LOCAL VARIABLES									------
----------------------------------------------------------
DECLARE     @nowTime        AS Integer = dbo.GetUnixTime (GetUTCdate())
DECLARE		@xmlForOscWQ XML = NULL
DECLARE		@workQueueOutput XML
----------------------------------------------------------
	IF object_id('tempdb.dbo.#JMJobActionEnabled') is not null
		DROP TABLE #JMJobActionEnabled
	CREATE TABLE #JMJobActionEnabled
	(
		clientId            integer,
		appType             integer,
		opType              integer,
		clientGroupId       integer,
		instanceID			integer,
		subClientID			integer,
		objectName			varchar(1024),
		commCellID			integer
	)
	DECLARE @drSubclientId INTEGER      =  ISNULL((select top 1 id from APP_Application
where appTypeId= 1000),1)
	DECLARE @drInstanceID      INTEGER =  ISNULL((select top 1 instance from APP_Application
where appTypeId= 1000),1)
	IF object_id('tempdb.dbo.#EnabledEntities') is not null
		DROP TABLE #EnabledEntities
	CREATE TABLE #EnabledEntities
	(
		clientId INT,
		opType INT,
		oldAction INT,
		newAction INT,
		appId INT,
		clientGroupId INT,
		instanceID INT
	)
	IF OBJECT_ID('tempdb.dbo.#DumpingClients') IS NOT NULL
		DROP TABLE #DumpingClients
	CREATE TABLE #DumpingClients (
		clientId INT
	);
--	--------------------------------------------------------------
--	FIND  WHICH ACTIVITIES ARE ELIGIBLE TO BE RE-ACTIVATED:	--
--	--------------------------------------------------------------
	INSERT #JMJobActionEnabled
		SELECT clientId, appType, opType, clientGroupId,instanceID,appid, '',2
		FROM JMJobAction WITH (NOLOCK)
		WHERE action = 1 AND UNCenableTime <> 0 AND UNCenableTime < @nowTime
	UPDATE #JMJobActionEnabled
		SET objectName = (select Name from app_client where id = clientId)
		WHERE clientId <> 1
	UPDATE #JMJobActionEnabled
		SET objectName = (Select aliasName from APP_CommCell where id=2)
		WHERE clientId = 1 and clientGroupId = 0
	UPDATE #JMJobActionEnabled
		SET objectName = (Select Name from App_ClientGroup where id = clientGroupId)
		WHERE clientGroupId <> 0
	UPDATE #JMJobActionEnabled
		SET objectName = (Select name from App_InstanceName where id = instanceID)
		WHERE instanceID <> 0 and instanceID <> @drInstanceID
	UPDATE #JMJobActionEnabled
		SET objectName = (Select subClientName from App_Application where id = subClientID),commCellID = (Select commCellID from App_Application where id = subClientID)
		WHERE subClientID <> 0 and subClientID <> @drSubclientId
if @options = 0
	UPDATE JMJobAction
		SET action =2, enabletimeZone = 0, enableTime=0, UNCenableTime=0
		OUTPUT inserted.clientId, inserted.opType, deleted.action, inserted.action, inserted.appId, inserted.clientGroupId, inserted.instanceID
		INTO #EnabledEntities
		WHERE action = 1 AND UNCenableTime <> 0 AND UNCenableTime < @nowTime
	-- For 1 min RPO we need to send work tokens to clients to stop dumping when acticity is disabled
	IF EXISTS (SELECT 1 FROM #EnabledEntities)
	BEGIN
		INSERT INTO #DumpingClients
		SELECT APP.clientId FROM APP_Application APP WITH(NOLOCK)
			INNER JOIN APP_SubclientToMountpathMapping SCM WITH(NOLOCK) ON SCM.subClientId = APP.id
			LEFT JOIN APP_ClientGroupAssoc ACGA WITH(NOLOCK) ON ACGA.clientId = APP.clientId
			INNER JOIN #EnabledEntities EE ON
			(
				(EE.appId = APP.id OR EE.appId = @drSubclientId)
				AND (EE.clientGroupId = ACGA.clientGroupId OR EE.clientGroupId = 0)
				AND (EE.clientId = APP.clientId OR EE.clientId > 1)
				AND (EE.instanceID = APP.instance OR EE.instanceID = @drInstanceID)
			)
			WHERE EE.opType IN (1,4) AND EE.clientId > 1 AND EE.oldAction = 1 AND EE.newAction = 2
		UNION
		SELECT APP.clientId FROM APP_Application APP WITH(NOLOCK)
			INNER JOIN APP_SubclientToMountpathMapping SMM WITH(NOLOCK) ON APP.id = SMM.subClientId
			INNER JOIN #EnabledEntities EE ON EE.clientId = 1
			WHERE EE.opType IN (1,4) AND EE.oldAction = 1 AND EE.newAction = 2
		SET @xmlForOscWQ = ( SELECT 61/*WORK_TOKEN_BACKUP_ACTIVITY_CHANGED*/ '@workToken',  -- OSC Work token
							(
								(
									SELECT clientId '@clientId'
									FROM #DumpingClients
									FOR XML PATH('entityList'),TYPE
								)
							)
							FOR XML PATH('App_SubmitWorkQueueReq')
						)
		EXEC AppWorkQueueSubmitRequestXMLOUTPUT @xmlForOscWQ, @workQueueOutput output
		SELECT @errorCode = ISNULL(attr.value('@errorCode', 'INT'),0),
				@errorString = ISNULL(attr.value('@errorMessage', 'NVARCHAR(1024)'),'')
		FROM
			@workQueueOutput.nodes('App_GenericResp') tci(attr)
		IF @errorCode <> 0
			GOTO ERR_EXIT
	END
--	------------------------------------------------------------------
--	-- FOR RE-ACTIVATED CLIENT GROUPS, REMOVE FROM JMJobAction Table--
--	------------------------------------------------------------------
	SELECT  1      as TAG,
		NuLL        as Parent,
		NuLL        as [App_ActivityControlEnabledListResp!1],
		NuLL		as [enabledEntities!2!clientId],
		NuLL		as [enabledEntities!2!appType],
		NuLL		as [enabledEntities!2!clientGroupId],
		NuLL		as [enabledEntities!2!opType],                   -- We are actually returning activity type here
		NuLL		as [enabledEntities!2!clientName],
    	NULL 		as [enabledEntities!2!instanceID],
    	NULL 		as [enabledEntities!2!subClientID],
    	NULL 		as [enabledEntities!2!commCellID]
	UNION ALL
	SELECT 2, 1, NulL,
		clientId, appType, clientGroupId, opType, objectName,instanceID,subClientID,commCellID
		FROM #JMJobActionEnabled
	FOR XML EXPLICIT
END TRY
--=====================================================================
--==============  COME HERE IF THERE WAS A PROBLEM!     ===============
--=====================================================================
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
	SET @errorCode	 = 1
	SET @errorString = 'Problems Executing [' + @function +'] Error Message [' + ERROR_MESSAGE() + '].'
END CATCH
ERR_EXIT:
IF @errorCode <> 0
	SELECT  1                    as TAG,
        null                 as Parent,
		@errorCode               as [CVGui_GenericResp!1!errorCode],
		@errorString             as [CVGui_GenericResp!1!errorMessage]
	FOR XML EXPLICIT
-----------------------------------------------------------
---  DROP ANY TEMPORARY TABLES THAT STILL EXIST AND		---
---  CLEAN UP ANY CURSORS LEFT OPEN						---
-----------------------------------------------------------
	IF object_id('tempdb.dbo.#JMJobActionEnabled') is not null
		DROP TABLE #JMJobActionEnabled
	IF object_id('tempdb.dbo.#EnabledEntities') is not null
		DROP TABLE #EnabledEntities
	IF OBJECT_ID('tempdb.dbo.#DumpingClients') IS NOT NULL
		DROP TABLE #DumpingClients
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPCheckActivityControl')
	delete from GxQscripts where name = 'APPCheckActivityControl'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCheckActivityControl')
	delete from GXDBVersions where aliasname = 'APPCheckActivityControl'
GO

insert into GXDBVersions values(2, 'APPCheckActivityControl',  '00010011006000060000', 'APPCheckActivityControl', '00010011006000060000')
GO

