

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSRefreshGroupCfg.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSRefreshGroupCfg.sp,v $ $Id: APPCCSRefreshGroupCfg.sp,v 1.1.2.5.8.1 2021/01/12 23:53:13 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPCCSRefreshGroupCfg')
BEGIN
	print '>>> Drop Stored Procedure: APPCCSRefreshGroupCfg <<<'
	drop procedure APPCCSRefreshGroupCfg
END
IF EXISTS (select * from GxQscripts where name='APPCCSRefreshGroupCfg')
	delete from GxQscripts where name = 'APPCCSRefreshGroupCfg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSRefreshGroupCfg')
	delete from GXDBVersions where aliasname = 'APPCCSRefreshGroupCfg'
GO
print '... Creating Procedure: APPCCSRefreshGroupCfg'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPCCSRefreshGroupCfg
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @rcnt INT = 0
	IF OBJECT_ID('tempdb.dbo.#Clients') IS NOT NULL
		DROP TABLE #Clients
	CREATE TABLE #Clients (
		clientId	INT PRIMARY KEY,
		ccsEnabled	INT
	)
	INSERT INTO #Clients (clientId, ccsEnabled)
		SELECT DISTINCT
			c.clientId,
			c.ccsEnabled
		FROM APP_ClientGroupAssoc cga WITH(NOLOCK)
			INNER JOIN ClientsWithValidCCSCfgsView c WITH(NOLOCK) ON
				c.clientId = cga.clientId
				AND c.GESP12Version >= 14		-- V11 SP14+ required for CCS Software support
			-- Only want to know if the row exist or not and do not care what it is configured too if it exist.
			LEFT OUTER JOIN APP_AdvanceSettings adv WITH(NOLOCK) ON
				adv.keyName = N'sCCSDbStatus'
				AND adv.entityType = 3		-- client
				AND adv.entityId = c.clientId
		WHERE
			adv.id IS NULL		-- needs to be configured.  Do not touch existing configurations (enabled, disabled, whatever)
			--OR CAST(adv.value AS NVARCHAR(32)) = N'LOAD'	-- may need WQ re-configured if LOAD here and no WQ Row  -- TO DO THIS need a timestamp on the setting and re-do if pass time limit
	SET @rcnt = @@ROWCOUNT
	IF (@rcnt = 0)
	BEGIN
		RETURN
	END
	-- Now update the following tables accordingly for each CCS Client's re-configuration settings.
	DECLARE	@currentTime	INT = DATEDIFF(second, '01/01/1970', GETUTCDATE())
	BEGIN TRY
		BEGIN TRANSACTION CCSGroupRefresh
		--====== APP_ClientProp Table Processing
		MERGE INTO APP_ClientProp cp
			USING #Clients c ON
				c.clientId = cp.componentNameId
				AND cp.attrName = N'CCS Enabled'
				AND cp.modified = 0
			WHEN NOT MATCHED THEN
				INSERT (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					VALUES(c.clientId,  N'CCS Enabled', 2, N'1', @currentTime, 0, 0)
			WHEN MATCHED		-- should never be the case (should have been deleted) but safety check
					AND cp.attrVal = N'0'
				THEN
					UPDATE
						SET attrVal = N'1',
							created = @currentTime;
		--====== APP_AdvanceSettings Table Processing
		IF OBJECT_ID('tempdb.dbo.#wqOperations') IS NOT NULL
			DROP TABLE #wqOperations
		CREATE TABLE #wqOperations (
			clientId	INT PRIMARY KEY,
			asId		INT
		)
		-- Already configured entries do not change, only inserting new entries
		INSERT INTO APP_AdvanceSettings (entityId, keyName, type, relativePath, value, enabled, deleted, entityType, sourceId, sourceEntityType)
			OUTPUT INSERTED.entityId, INSERTED.id
				INTO #wqOperations (clientId, asId)
			SELECT
				c.clientId,
				N'sCCSDbStatus',
				N'STRING',
				N'iDataAgent',
				N'LOAD',
				1,
				0,
				3 /* client */,
				0,
				0
			FROM #Clients c
				LEFT OUTER JOIN APP_AdvanceSettings adv WITH(NOLOCK) ON		-- safety check
					c.clientId = adv.entityId
					AND adv.entityType = 3		-- client
					AND adv.keyName = N'sCCSDbStatus'
			WHERE
				adv.id IS NULL
		-- Hide sCCSDbStatus keyname rows
		INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)
			SELECT
				wqo.asId,
				N'',
				1
			FROM #wqOperations wqo
		--====== APP_WorkQueueRequest Table Processing
		DECLARE @wkToken49		INT = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
		INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
			SELECT
				wq.clientId,
				-1,
				@wkToken49,
				'LOAD',
				@currentTime,
				0,
				0,
				0
			FROM #wqOperations wq
				LEFT OUTER JOIN APP_WorkQueueRequest r WITH(NOLOCK) ON
					r.clientId = wq.clientId
					AND r.workToken = @wkToken49
			WHERE
				r.clientId IS NULL
			COMMIT TRANSACTION CCSGroupRefresh
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		ROLLBACK TRANSACTION CCSGroupRefresh
		RAISERROR('APPCCSRefreshGroupCfg: Exception trapped', 16, 1) WITH NOWAIT
	END CATCH
	RETURN
END

IF EXISTS (select * from GxQscripts where name = 'APPCCSRefreshGroupCfg')
	delete from GxQscripts where name = 'APPCCSRefreshGroupCfg'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSRefreshGroupCfg')
	delete from GXDBVersions where aliasname = 'APPCCSRefreshGroupCfg'
GO

insert into GXDBVersions values(2, 'APPCCSRefreshGroupCfg',  'v1.1.2.5.8.1', 'APPCCSRefreshGroupCfg', 'v1.1.2.5.8.1')
GO

