

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSOSCFilterContentUpdateXMLDocument.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSOSCFilterContentUpdateXMLDocument.sp,v $ $Id: APPCCSOSCFilterContentUpdateXMLDocument.sp,v 1.1.2.1 2018/09/29 21:28:57 logeshg Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPCCSOSCFilterContentUpdateXMLDocument <<<'

IF EXISTS (select * from sysobjects where name='APPCCSOSCFilterContentUpdateXMLDocument')
	drop procedure APPCCSOSCFilterContentUpdateXMLDocument
IF EXISTS (select * from GxQscripts where name='APPCCSOSCFilterContentUpdateXMLDocument')
	delete from GxQscripts where name = 'APPCCSOSCFilterContentUpdateXMLDocument'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSOSCFilterContentUpdateXMLDocument')
	delete from GXDBVersions where aliasname = 'APPCCSOSCFilterContentUpdateXMLDocument'
GO
print '... Creating Procedure: APPCCSOSCFilterContentUpdateXMLDocument'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCCSOSCFilterContentUpdateXMLDocument
--  User Input arguments
  @inSubClientId INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @contentXml XML;
-- Caller must check for exists of child node before passing to CCS Processing /ccsTableUpdates/clientConfigStoreUpdate
BEGIN
	SET NOCOUNT ON
	-- Is CCS Functionality enabled on the CommServer?
    DECLARE @ccsEnabled INT = 0
    SELECT @ccsEnabled = CAST(value AS INT) FROM GXGlobalParam WITH(NOLOCK) WHERE name = 'CommServCCSEnabled'
	IF (@ccsEnabled = 0)
	BEGIN
		SET @contentXml = '<ccsTableUpdates/>'
		GOTO END_OF_PROC
	END
	-- Verify Client is a CCS Laptop, if not done
	IF EXISTS (
		SELECT
			1
		FROM APP_Application a WITH(NOLOCK)
			LEFT OUTER JOIN APP_ClientProp cp WITH(NOLOCK) ON
				cp.componentNameId = a.clientId
				AND cp.attrName = N'CCS Enabled'
				AND cp.modified = 0
		WHERE
			a.id = @inSubClientId
			AND (
				cp.id IS NULL
				OR cp.attrVal = N'0'
			)
	)
	BEGIN
		SET @contentXml = '<ccsTableUpdates/>'
		GOTO END_OF_PROC
	END
	DECLARE @scpId INT = 0
	SELECT
		@scpId = scp.attrVal
	FROM APP_SubClientProp scp WITH(NOLOCK)
	WHERE
		scp.componentNameId = @inSubClientId
		AND scp.attrName = N'Associated subclient Policy'
		--AND scp.cs_attrName = CHECKSUM(N'Associated subclient Policy')
		AND scp.modified = 0
	IF NOT EXISTS (
		SELECT TOP 1
			1
		FROM APP_ScFilterFile ff WITH(NOLOCK)
		WHERE
			ff.componentNameId IN (@inSubClientId,@scpId)
	)
	BEGIN
		SET @contentXml = '<ccsTableUpdates/>'
		GOTO END_OF_PROC
	END
	SET @contentXml = (
		SELECT
			1 'tableInfo/@sequenceNumber',	-- Table Update Seq Number
			17 'tableInfo/@tableType',		-- APP_ScFilterFile Table Type
			1 'tableInfo/@tableOpCode',		-- update operation
			(
				SELECT
					scFilterFileTableRowList.id,
					scFilterFileTableRowList.componentNameId,
					scFilterFileTableRowList.type,
					dbo.EncodeInvalidXMLChar(scFilterFileTableRowList.fileName) fileName,
					scFilterFileTableRowList.created,
					scFilterFileTableRowList.modified,
					scFilterFileTableRowList.ccpId,
					scFilterFileTableRowList.cs_fileName
				FROM APP_ScFilterFile scFilterFileTableRowList WITH(NOLOCK)
				WHERE
					scFilterFileTableRowList.componentNameId IN (@inSubClientId,@scpId)
				ORDER BY scFilterFileTableRowList.id
				FOR XML AUTO, TYPE
			)
		FOR XML PATH('clientConfigStoreUpdate'), ROOT('ccsTableUpdates'), TYPE
	)
END_OF_PROC:
	SELECT @contentXml contentXml
	RETURN
END

IF EXISTS (select * from GxQscripts where name = 'APPCCSOSCFilterContentUpdateXMLDocument')
	delete from GxQscripts where name = 'APPCCSOSCFilterContentUpdateXMLDocument'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSOSCFilterContentUpdateXMLDocument')
	delete from GXDBVersions where aliasname = 'APPCCSOSCFilterContentUpdateXMLDocument'
GO

insert into GXDBVersions values(2, 'APPCCSOSCFilterContentUpdateXMLDocument',  '00010001000200010000', 'APPCCSOSCFilterContentUpdateXMLDocument', '00010001000200010000')
GO

