

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSMd5TableHashCompare.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSMd5TableHashCompare.sp,v $ $Id: APPCCSMd5TableHashCompare.sp,v 1.1.2.3 2020/07/15 21:38:35 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPCCSMd5TableHashCompare')
BEGIN
	print '>>> Drop Stored Procedure: APPCCSMd5TableHashCompare <<<'
	drop procedure APPCCSMd5TableHashCompare
END
IF EXISTS (select * from GxQscripts where name='APPCCSMd5TableHashCompare')
	delete from GxQscripts where name = 'APPCCSMd5TableHashCompare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSMd5TableHashCompare')
	delete from GXDBVersions where aliasname = 'APPCCSMd5TableHashCompare'
GO
print '... Creating Procedure: APPCCSMd5TableHashCompare'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCCSMd5TableHashCompare
-- Input arguments
  @clientId INT,
  @tableType INT,
  @outIsMatch INT OUTPUT,
-- Event Log Level
  @logLevel INT = 0
AS
BEGIN
	SET NOCOUNT ON
	-- Debug and execution time messages
	DECLARE @timers TINYINT = 0
	IF (@logLevel >= 8)
	BEGIN
		SET @timers = 1
	END
	DECLARE @sdt DATETIME2
	DECLARE @edt DATETIME2
	IF (@timers > 0)
	BEGIN
		SET @sdt = SYSDATETIME()
		PRINT 'APPCCSMd5TableHashCompare Start: ClientId[' + CAST(@clientId AS VARCHAR(12)) + '] TableType[' + CAST(@tableType AS VARCHAR(12)) + '] Time ' + CAST(@sdt AS VARCHAR(128))
	END
	DECLARE @md5Query		NVARCHAR(MAX)
	DECLARE @paramDefs		NVARCHAR(MAX)
	DECLARE @at1030			INT = -1
	DECLARE @rc				INT = 0
	DECLARE @hashRows		INT = 0
	DECLARE @ccsRows		INT = 0
	-- Determine if Client is Pre-SP18
	DECLARE @isClientPreSP18 TINYINT = 0
	SELECT
		@isClientPreSP18 = CASE
								WHEN MAX(HighestSP) < 18 THEN 1
								ELSE 0
							END
	FROM simInstalledPackages ip WITH(NOLOCK)
	WHERE clientId = @clientId
	-- Max table chunks preSP18
	DECLARE @tblChunks TABLE (
		tableType		INT PRIMARY KEY,
		maxChunks		INT
	)
	DECLARE @maxChunkSize INT = (((8 - 1) * 8000) + 1)		-- SP18+ fixed max hash chunks, 8, for all tables
	IF (@isClientPreSP18 = 1)
	BEGIN
		-- Insert all for now
		INSERT @tblChunks (tableType, maxChunks) VALUES
			(1,3),
			(2,4),
			(3,2),
			(4,2),
			(5,4),
			(6,2),
			(7,4),
			(8,2),
			(10,2),
			(11,2),
			(12,2),
			(13,2),
			(14,2),
			(15,4),
			(16,4),
			(17,4),
			(18,2),
			(19,4),
			(20,4),
			(21,7),
			(23,2),
			(24,2),
			(25,4),
			(26,2)
		SELECT
			@maxChunkSize = (((maxChunks - 1) * 8000) + 1)
		FROM @tblChunks
		WHERE tableType = @tableType
	END
	--ELSE
	--BEGIN
	--	INSERT @tblChunks (tableType, maxChunks)
	--		SELECT
	--			id,
	--			8			-- fixed number of chunks starting SP18
	--		FROM APP_CCSXMLMapping WITH(NOLOCK)
	--		WHERE
	--			id = @tableType
	--END
	-- Determine if the Client is using Associated Subclient Policies?
	-- A number of Hash Queries will need to know if these rows need to be part of the hash computation.
	SELECT TOP 1
		@at1030 = 1030
	FROM APP_Application a WITH(NOLOCK)
		INNER JOIN APP_SubClientProp cp WITH(NOLOCK) ON
			a.clientId = @clientId
			AND cp.componentNameId = a.id
			AND cp.attrName = N'Associated subclient Policy'
			--== NOTE: Could have been previously assocaited - grey area to investigate and test were hashes may mis-match
			--AND cp.modified = 0
			AND cp.cs_attrName = CHECKSUM( N'Associated subclient Policy')
	-- Used to store computed hashes from executed hash table queries
	IF OBJECT_ID('tempdb.dbo.#md5CSHash') IS NOT NULL
		DROP TABLE #md5CSHash
	CREATE TABLE #md5CSHash (
		tableType		INT,
		chunk			INT,
		value			VARBINARY(128),
		bytes			INT,
		PRIMARY KEY (tableType, chunk)
	)
	SET @paramDefs = N'@inClientId INT, @inAT1030 INT, @tt INT'
	-- MD5 Hash handles upto 8 8000 byte chunks - should be large enough to handle any table rows concatenated together for CCS Laptop data.
	DECLARE @hashSqlCmd	NVARCHAR(MAX) = N'
DECLARE @chkStr VARCHAR(MAX) = ''''
SELECT
	@chkStr = v.value(''.'', ''VARCHAR(MAX)'')
FROM @textNode.nodes(''/text'') d(v)
DECLARE @bytes INT = LEN(@chkStr)
IF (@bytes > 64000)
BEGIN
	-- Print warning message that length has been exceeded
	PRINT ''APPCCSMd5TableHashCompare: Warning ClientId['' + CAST(@inClientId AS VARCHAR(12)) + ''] TableType['' + CAST(@tt AS VARCHAR(12)) + ''] exceeded hash string length > 64K len['' + CAST(@bytes AS VARCHAR(12)) + '']''
END
INSERT INTO #md5CSHash (tableType, chunk, value, bytes)
	SELECT
		@tt,
		chunk,
		value,
		bytes
	FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
'
	-- Get the CCS Table MD5 Hash Query
	SELECT
		@md5Query = t.md5Query + @hashSqlCmd
	FROM APP_CCSXMLMapping t WITH(NOLOCK)
	WHERE
			t.id = @tableType
			AND t.md5Query <> N''
	-- Execute the SQL command to retreive the rows needed and perform the MD5 hash on the client's table data
	EXEC @rc = sp_executesql @stmt = @md5Query,
								@params = @paramDefs,
								@inClientId = @clientId,
								@inAT1030 = @at1030,
								@tt = @tableType
	-- Compare Table CS MD5 Hash with Stored CCS MD5 Hash
	SELECT
		@hashRows = COUNT(*)
	FROM #md5CSHash
	SELECT
		@ccsRows = COUNT(*)
	FROM  APP_CCSTableHashes h WITH(NOLOCK)
	WHERE
		h.clientId = @clientId
		AND h.tableType = @tableType
	DECLARE @match INT = 1
	IF (@hashRows <> @ccsRows)
	BEGIN
		-- Hash Row Count NOT equal so no match
		SET @match = 0
	END
	IF (@match = 1)
	BEGIN
		-- Are MD5 Hash equal?
		SELECT TOP 1
			@match = 0
		FROM APP_CCSTableHashes h WITH(NOLOCK)
			INNER JOIN #md5CSHash t ON
				t.tableType = h.tableType
				AND h.chunk = t.chunk
		WHERE
			h.clientId = @clientId
			AND (
				t.bytes <> h.ccsBytes
				OR master.dbo.FN_VARBINTOHEXSTR(t.value) <> h.ccsHash
			)
			AND t.chunk <= @maxChunkSize		-- Limit to the max hash chunks supported by the client's software, since the CS is now SP18+ for backward compatiblity
	END
	SET @outIsMatch = @match
	IF (@logLevel >= 5)
	BEGIN
		PRINT 'APPCCSMd5TableHashCompare: ClientId[' + CAST(@clientId AS VARCHAR(12)) + '] TableType[' + CAST(@tableType AS VARCHAR(12)) + '] Hash IsMatch[' + CAST(@outIsMatch AS VARCHAR(12)) + ']'
	END
	IF (@timers > 0)
	BEGIN
		SET @edt = SYSDATETIME()
		PRINT 'APPCCSMd5TableHashCompare End: ClientId[' + CAST(@clientId AS VARCHAR(12)) + '] TableType[' + CAST(@tableType AS VARCHAR(12)) + '] Time ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPCCSMd5TableHashCompare')
	delete from GxQscripts where name = 'APPCCSMd5TableHashCompare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSMd5TableHashCompare')
	delete from GXDBVersions where aliasname = 'APPCCSMd5TableHashCompare'
GO

insert into GXDBVersions values(2, 'APPCCSMd5TableHashCompare',  '00010001000200030000', 'APPCCSMd5TableHashCompare', '00010001000200030000')
GO

