

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSMd5TableHash.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSMd5TableHash.sp,v $ $Id: APPCCSMd5TableHash.sp,v 1.1.2.7.16.1 2021/02/26 03:37:16 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPCCSMd5TableHash')
BEGIN
	print '>>> Drop Stored Procedure: APPCCSMd5TableHash <<<'
	drop procedure APPCCSMd5TableHash
END
IF EXISTS (select * from GxQscripts where name='APPCCSMd5TableHash')
	delete from GxQscripts where name = 'APPCCSMd5TableHash'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSMd5TableHash')
	delete from GXDBVersions where aliasname = 'APPCCSMd5TableHash'
GO
print '... Creating Procedure: APPCCSMd5TableHash'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPCCSMd5TableHash
-- Input arguments
  @haxhXML XML
AS
  DECLARE @xmlText XML = NULL;
BEGIN
	SET NOCOUNT ON
	-- Debug and execution time messages
	DECLARE @timers TINYINT = 0
	DECLARE @sdt DATETIME2
	DECLARE @edt DATETIME2
	IF (@timers > 0)
	BEGIN
		SET @sdt = SYSDATETIME()
		PRINT 'APPCCSMd5TableHash Start: ' + CAST(@sdt AS VARCHAR(128))
	END
	--IF (@@TRANCOUNT > 0)
	--BEGIN
	--	--== May require special handling for some of the operations below were using TRY CATCH Blocks
	--	PRINT 'WARNING APPCCSMd5TableHash has an outside TRANSACTION started!'
	--END
	DECLARE @outXML			XML
	DECLARE @md5Query		NVARCHAR(MAX)
	DECLARE @sqlCmd			NVARCHAR(MAX)
	DECLARE @errMsg			NVARCHAR(1024) = N''
	DECLARE @paramDefs		NVARCHAR(MAX)
	DECLARE @tableType		INT
	DECLARE @rc				INT
	DECLARE @rwcnt			INT
	DECLARE @at1030			INT = -1			-- Is the Client associated with an Assocaited Subclient Policy?
	DECLARE @nowTime		BIGINT
	-- md5HashError:
	--	1001 - Missing clientId
	--	1002 - Invalid clientId or not CCS Enabled
	--	1003 - MD5 Hash Processing Error
	--	1004 - CS / CCS MD5 Table Hash Mismatch Warning
	DECLARE @clientId		INT = 0
	SELECT
		@clientId = c.value('@clientId', 'INT')
	FROM @haxhXML.nodes('/TMMsg_CCSTableHashUpdateReq') d(c)
	IF (@clientId = 0)
	BEGIN
		SET @outXML = (
			SELECT
				1001 '@errorCode',
				'Missing clientId' '@errorMessage'
			FOR XML PATH('md5HashError'), ROOT('TMMsg_CCSTableHashUpdateResp'), TYPE
		)
		SELECT @outXML xmlText
		RETURN
	END
	-- Does client exist and CCS Enabled set
	IF NOT EXISTS (
		SELECT 1
		FROM APP_Client c WITH(NOLOCK)
			INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
				(c.status & (2|4)) = 0		-- installed
				AND c.id = @clientId
				AND cp.componentNameId = @clientId
				AND cp.attrName = N'CCS Enabled'
				AND cp.modified = 0
				AND cp.attrVal = N'1'
	)
	BEGIN
		SET @outXML = (
			SELECT
				@clientId '@clientId',
				(
					SELECT
						1002 '@errorCode',
						'Invalid clientId or not CCS Enabled' '@errorMessage'
					FOR XML PATH('md5HashError'), TYPE
				)
			FOR XML PATH('TMMsg_CCSTableHashUpdateResp'), TYPE
		)
		SELECT @outXML xmlText
		RETURN
	END
	-- Determine if Client is Pre-SP18 software still installed, the CS is at SP18 now
	DECLARE @isClientPreSP18 TINYINT = 0
	SELECT
		@isClientPreSP18 = CASE
								WHEN MAX(HighestSP) < 18 THEN 1
								ELSE 0
							END
	FROM simInstalledPackages ip WITH(NOLOCK)
	WHERE clientId = @clientId
	-- Max table chunks preSP18
	DECLARE @tblChunks TABLE (
		tableType		INT PRIMARY KEY,
		maxChunks		INT
	)
	IF (@isClientPreSP18 = 1)
	BEGIN
		-- Insert all table types for now and associated max hash chunks for SP16 /17
		INSERT @tblChunks (tableType, maxChunks) VALUES
			(1,3),
			(2,4),
			(3,2),
			(4,2),
			(5,4),
			(6,2),
			(7,4),
			(8,2),
			(10,2),
			(11,2),
			(12,2),
			(13,2),
			(14,2),
			(15,4),
			(16,4),
			(17,4),
			(18,2),
			(19,4),
			(20,4),
			(21,7),
			(23,2),
			(24,2),
			(25,4),
			(26,2)
	END
	-- default to max value above
	--ELSE
	--BEGIN
	--	INSERT @tblChunks (tableType, maxChunks)
	--		SELECT
	--			id,
	--			8			-- fixed number of chunks starting SP18
	--		FROM APP_CCSXMLMapping WITH(NOLOCK)
	--		WHERE
	--			id = @tableType
	--END
	IF OBJECT_ID('tempdb.dbo.#md5HashTable') IS NOT NULL
		DROP TABLE #md5HashTable
	CREATE TABLE #md5HashTable (
		tableType		INT,
		chunk			INT,
		hashTime		BIGINT NULL,
		md5Hash			VARCHAR(128) NULL,
		md5HashBin		VARBINARY(128) NULL,
		md5bytes		INT NULL,
		ssMd5Hash		VARCHAR(128) NULL DEFAULT NULL,
		ssMd5HashBin	VARBINARY(128) NULL DEFAULT NULL,
		ssMd5Bytes		INT NULL DEFAULT NULL,
		ssHashTime		BIGINT NULL DEFAULT NULL,
		match			INT NULL DEFAULT NULL,
		PRIMARY KEY (tableType, chunk)
	)
	-- Extact XML Data to table
	INSERT INTO #md5HashTable (tableType, chunk, hashTime, md5Hash, md5HashBin, md5bytes)
		SELECT
			h.value('../@type', 'INT'),
			h.value('@offset', 'INT'),
			h.value('../../@hashTime', 'BIGINT'),
			'0x' + h.value('@md5', 'VARCHAR(128)'),		-- prefix to match SQL Server
			CONVERT(VARBINARY(128), ('0x' + h.value('@md5', 'VARCHAR(128)')), 1),		-- prefix to match SQL Server
			h.value('../@bytes', 'INT')
		FROM @haxhXML.nodes('/TMMsg_CCSTableHashUpdateReq/table/chunk') d(h)
	SET @rwcnt = @@ROWCOUNT
	IF (@rwcnt = 0)
	BEGIN
		-- Nothing to do in the received request
		GOTO END_OF_PROC
	END
	-- Determine if the Client is using Associated Subclient Policies?
	-- A number of Hash Queries will need to know if these rows need to be part of the hash computation.
	SELECT TOP 1
		@at1030 = 1030
	FROM APP_Application a WITH(NOLOCK)
		INNER JOIN APP_SubClientProp cp WITH(NOLOCK) ON
			a.clientId = @clientId
			AND cp.componentNameId = a.id
			AND cp.attrName = N'Associated subclient Policy'
			--== NOTE: Could have been previously assocaited - grey area to investigate and test were hashes may mis-match
			--AND cp.modified = 0
			AND cp.cs_attrName = CHECKSUM( N'Associated subclient Policy')
	-- Used to store computed hashes from executed hash table queries
	IF OBJECT_ID('tempdb.dbo.#md5CSHash') IS NOT NULL
		DROP TABLE #md5CSHash
	CREATE TABLE #md5CSHash (
		tableType		INT,
		chunk			INT,
		value			VARBINARY(128),
		bytes			INT,
		PRIMARY KEY (tableType, chunk)
	)
	-- Update temp table with SQL Server MD5 Hashes for this client
	BEGIN TRY
		IF (CURSOR_STATUS('local', 'md5Cursor') >= 0)
			CLOSE md5Cursor
		IF (CURSOR_STATUS('local', 'md5Cursor') = -1)
			DEALLOCATE md5Cursor
		SET @paramDefs = N'@inClientId INT, @inAT1030 INT, @tt INT'
		-- MD5 Hash handles upto 4 8000 byte chunks - should be large enough to handle any table rows concatenated together for CCS Laptop data.
		DECLARE @hashSqlCmd	NVARCHAR(MAX) = N'
DECLARE @chkStr NVARCHAR(MAX) = ''''
SELECT
	@chkStr = v.value(''.'', ''NVARCHAR(MAX)'')
FROM @textNode.nodes(''/text'') d(v)
DECLARE @bytes INT = LEN(@chkStr)
IF (@bytes > 64000)
BEGIN
	-- Print warning message that length has been exceeded
	PRINT ''APPCCSMd5TableHash: Warning ClientId['' + CAST(@inClientId AS VARCHAR(12)) + ''] TableType['' + CAST(@tt AS VARCHAR(12)) + ''] exceeded hash string length > 64K len['' + CAST(@bytes AS VARCHAR(12)) + '']''
END
INSERT INTO #md5CSHash (tableType, chunk, value, bytes)
	SELECT
		@tt,
		chunk,
		value,
		bytes
	FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
'
		DECLARE md5Cursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
			SELECT DISTINCT
				t.tableType,
				q.md5Query + @hashSqlCmd
			FROM #md5HashTable t
				INNER JOIN APP_CCSXMLMapping q ON
					t.tableType = q.id
					AND q.md5Query <> N''
		OPEN md5Cursor
		IF (@timers > 0)
		BEGIN
			SET @edt = SYSDATETIME()
			PRINT 'APPCCSMd5TableHash Cursor Start: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
		END
		FETCH NEXT FROM md5Cursor
			INTO @tableType, @md5Query
		WHILE @@FETCH_STATUS = 0
		BEGIN
			--PRINT @md5Query
			-- Execute the SQL command to retreive the rows needed and perform the MD5 hash on the client's table data
			EXEC @rc = sp_executesql @stmt = @md5Query,
									 @params = @paramDefs,
									 @inClientId = @clientId,
									 @inAT1030 = @at1030,
									 @tt = @tableType
			IF (@timers > 0)
			BEGIN
				SET @edt = SYSDATETIME()
				PRINT 'APPCCSMd5TableHash TableType[' + CAST(@tableType AS VARCHAR(12)) + ']: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
			END
			FETCH NEXT FROM md5Cursor
				INTO @tableType, @md5Query
		END
		IF (@timers > 0)
		BEGIN
			SET @edt = SYSDATETIME()
			PRINT 'APPCCSMd5TableHash Cursor End: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
		END
		CLOSE md5Cursor
		DEALLOCATE md5Cursor
	END TRY
	BEGIN CATCH
		IF (CURSOR_STATUS('local', 'md5Cursor') >= 0)
			CLOSE md5Cursor
		IF (CURSOR_STATUS('local', 'md5Cursor') = -1)
			DEALLOCATE md5Cursor
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @outXML = (
			SELECT
				@clientId '@clientId',
				(
					SELECT
						1003 '@errorCode',
						'MD5 Hash Processing Error' '@errorMessage'
					FOR XML PATH('md5HashError'), TYPE
				)
			FOR XML PATH('TMMsg_CCSTableHashUpdateResp'), TYPE
		)
		SELECT @outXML xmlText
		RETURN
	END CATCH
	-- Compare CS and CCS hashes
	SET @nowTime = dbo.GetUnixTimeBig(GETUTCDATE())
	UPDATE ht
		SET ssMd5Hash = master.dbo.FN_VARBINTOHEXSTR(ch.value),
			ssMd5HashBin = ch.value,
			ssMd5Bytes = ch.bytes,
			ssHashTime = @nowTime,
			match = CASE
						WHEN ch.bytes = 0 AND ht.md5bytes = 0 THEN 1	-- No data in table CCS and CS MD5 Hash Equal!
						WHEN ch.value = ht.md5HashBin THEN 1			-- CCS and CS MD5 Hash Equal we have a match! Cannot compare string lenght Chinese may have mutliple bytes for 1 character
						ELSE 0											-- MD5 Hash does NOT MATCH!
					END
	FROM #md5HashTable ht
		LEFT OUTER JOIN #md5CSHash ch ON
			ch.tableType = ht.tableType
			AND ch.chunk = ht.chunk
	-- CS hashes not found a match against CCS hashes
	INSERT INTO #md5HashTable (tableType, chunk, hashTime, md5Hash, md5HashBin, md5Bytes, ssMd5Hash, ssMd5HashBin, ssMd5Bytes, ssHashTime, match)
		SELECT
			ch.tableType,
			ch.chunk,
			NULL,
			NULL,
			NULL,
			ISNULL(b.md5Bytes, 0),		-- default to other row size for the given table type
			master.dbo.FN_VARBINTOHEXSTR(ch.value),
			ch.value,
			ch.bytes,
			@nowTime,
			(
				CASE
					WHEN @isClientPreSP18 = 0 THEN 0
					WHEN @isClientPreSP18 = 1 AND b.md5Bytes IS NOT NULL AND b.md5Bytes = ch.bytes AND ch.chunk > c.maxChunkSize THEN 1
					ELSE 0
				END
			)
		FROM #md5CSHash ch
			LEFT OUTER JOIN  #md5HashTable ht ON
				ch.tableType = ht.tableType
				AND ch.chunk = ht.chunk
			OUTER APPLY (
				SELECT MAX(a.md5Bytes) md5Bytes FROM #md5HashTable a WHERE a.tableType = ch.tableType
			) b
			OUTER APPLY (
				-- Compute last chunk size supported pre SP18
				SELECT
					(((maxChunks - 1) * 8000) + 1) maxChunkSize
				FROM @tblChunks
				WHERE
					tableType = ch.tableType
					AND @isClientPreSP18 = 1
			) c
		WHERE
			ht.tableType IS NULL
	--select * from #md5HashTable
	--== NOTE: Do I need a transaction wrapper here for these UPDATE and INSERT Ops?
	-- Update hash status table
	UPDATE h
		SET ccsHash = ISNULL(t.md5Hash, ''),
			ccsBytes = ISNULL(t.md5Bytes, 0),
			ccsTime = ISNULL(t.hashTime, 0),
			csHash = ISNULL(t.ssMd5Hash, ''),
			csBytes = ISNULL(t.ssMd5Bytes, 0),
			csTime = ISNULL(t.ssHashTime, 0),
			matched = t.match,
			attempts = (CASE t.match -- If matched clear value, else increment if not matched to count the attempts / hashes for CCSDb Table Updates.
							WHEN 1 THEN 0
							ELSE (
								CASE
									WHEN h.attempts < 0 THEN 1		-- possible reload performed and a new hash check being performed
									ELSE h.attempts + 1				-- set reload to -10 and this was counting up / incrementing from -10
								END
							)
						END)
	FROM APP_CCSTableHashes h
		INNER JOIN #md5HashTable t ON
			t.tableType = h.tableType
			AND t.chunk = h.chunk
	WHERE h.clientId = @clientId
	-- Insert new rows
	INSERT INTO APP_CCSTableHashes (clientId, tableType, chunk, csHash, csTime, csBytes, ccsHash, ccsTime, ccsBytes, matched, attempts)
		SELECT
			@clientId,
			t.tableType,
			t.chunk,
			ISNULL(t.ssMd5Hash, ''),
			ISNULL(t.ssHashTime, 0),
			ISNULL(t.ssMd5Bytes, 0),
			ISNULL(t.md5Hash, ''),
			ISNULL(t.hashTime, 0),
			ISNULL(t.md5Bytes, ''),
			t.match,
			(CASE t.match WHEN 1 THEN 0 ELSE 1 END)
		FROM #md5HashTable t
			LEFT OUTER JOIN APP_CCSTableHashes h ON
				h.clientId = @clientId
				AND h.tableType = t.tableType
				AND h.chunk = t.chunk
		WHERE
			h.clientId IS NULL
	-- Delete rows no longer needed
	DELETE h
	FROM APP_CCSTableHashes h
		INNER JOIN (
				SELECT
					-- Get all rows / chunks for client and table type
					h.clientId,
					h.tableType,
					h.chunk
				FROM APP_CCSTableHashes h
					INNER JOIN #md5HashTable t ON
						h.clientId = @clientId
						AND h.tableType = t.tableType
				EXCEPT
				SELECT
					-- Get all rows / chunks from the input to remove data rows above to keep. The remaining should be deleted.
					@clientId,
					t.tableType,
					t.chunk
				FROM #md5HashTable t
			) d ON
				d.clientId = h.clientId
				AND d.tableType = h.tableType
				AND d.chunk = h.chunk
END_OF_PROC:
	-- Now check for any non-matches and seend status back
	DECLARE @mismatched	XML = NULL
	SET @mismatched = (
				SELECT
					t.tableType '@val'
				FROM  #md5HashTable t
				WHERE t.match = 0		-- false did not match
				FOR XML PATH('tableMismatch'), TYPE
			)
	IF (@mismatched IS NOT NULL)
	BEGIN
		-- Warning message is not necessary an error that the data is wrong there could
		-- be table rows in progress of being pushed to the CCS Client when the Hash Operation execution.
		SET @outXML = (
			SELECT
				@clientId '@clientId',
				@mismatched,
				(
					SELECT
						1004 '@errorCode',
						'CS / CCS MD5 Table Hash Mismatch Warning' '@errorMessage'
					FOR XML PATH('md5HashError'), TYPE
				)
			FOR XML PATH('TMMsg_CCSTableHashUpdateResp'), TYPE
		)
	END
	ELSE
	BEGIN
		SET @outXML = (
			SELECT
				@clientId '@clientId',
				(
					SELECT
						0 '@errorCode',
						'Success' '@errorMessage'
					FOR XML PATH('md5HashError'), TYPE
				)
			FOR XML PATH('TMMsg_CCSTableHashUpdateResp'), TYPE
		)
	END
	SELECT @outXML xmlText
	--PRINT 'APPCCSMd5TableHash: ' + CAST(@outXML AS VARCHAR(MAX))
	IF (@timers > 0)
	BEGIN
		SET @edt = SYSDATETIME()
		PRINT 'APPCCSMd5TableHash End: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPCCSMd5TableHash')
	delete from GxQscripts where name = 'APPCCSMd5TableHash'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSMd5TableHash')
	delete from GXDBVersions where aliasname = 'APPCCSMd5TableHash'
GO

insert into GXDBVersions values(2, 'APPCCSMd5TableHash',  'v1.1.2.7.16.1', 'APPCCSMd5TableHash', 'v1.1.2.7.16.1')
GO

