

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSMd5ASCPTableHashCompare.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSMd5ASCPTableHashCompare.sp,v $ $Id: APPCCSMd5ASCPTableHashCompare.sp,v 1.1.2.3 2019/08/08 22:17:10 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPCCSMd5ASCPTableHashCompare')
BEGIN
	print '>>> Drop Stored Procedure: APPCCSMd5ASCPTableHashCompare <<<'
	drop procedure APPCCSMd5ASCPTableHashCompare
END
IF EXISTS (select * from GxQscripts where name='APPCCSMd5ASCPTableHashCompare')
	delete from GxQscripts where name = 'APPCCSMd5ASCPTableHashCompare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSMd5ASCPTableHashCompare')
	delete from GXDBVersions where aliasname = 'APPCCSMd5ASCPTableHashCompare'
GO
print '... Creating Procedure: APPCCSMd5ASCPTableHashCompare'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCCSMd5ASCPTableHashCompare
  @inAppId INT,
  @inTableType INT,
-- usually called with a start time
  @inStartTime INT,
  @outIsMatch INT OUTPUT,
-- Event Log Level
  @logLevel INT = 0
AS
-- Following are the "columns" returned, in the order in which they are declared
BEGIN
	SET NOCOUNT ON
SET @outIsMatch = 0
	-- Purpose of the SP is to compute MD5 Hash for all Assocaited Subclient Policy Table Rows
	-- Debug and execution time messages
	DECLARE @timers TINYINT = 0
	IF (@logLevel >= 8)
	BEGIN
		SET @timers = 1
	END
	DECLARE @sdt DATETIME2
	DECLARE @edt DATETIME2
	IF (@timers > 0)
	BEGIN
		SET @sdt = SYSDATETIME()
		PRINT 'APPCCSMd5ASCPTableHashCompare Start: ' + CAST(@sdt AS VARCHAR(128))
	END
	DECLARE @textNode	XML
	DECLARE @chkStr		VARCHAR(MAX)
	DECLARE @bytes		INT
	DECLARE @appId		INT
	DECLARE @instId		INT
	DECLARE @bsId		INT
	-- Get App Info
	SELECT
		@appId = a.id,
		@instId = a.instance,
		@bsId = a.backupSet
	FROM APP_Application a WITH(NOLOCK)
	WHERE
		a.id = @inAppId
	IF (@appId IS NULL OR @appId = 0)
	BEGIN
		 PRINT 'APPCCSMd5ASCPTableHashCompare: Bad @inAppId inputted [' + CAST(@sdt AS VARCHAR(128)) + ']'
		 RETURN
	END
	IF OBJECT_ID('tempdb.dbo.#md5CSHash') IS NOT NULL
		DROP TABLE #md5CSHash
	CREATE TABLE #md5CSHash (
		ascpId			INT,
		tableType		INT,
		chunk			INT,
		value			VARBINARY(128),
		bytes			INT,
		PRIMARY KEY (tableType, chunk, ascpId)
	)
	IF (@inTableType = 4)
	BEGIN
		--=======================================================================
		--#### APP_Application
		SET @textNode = (
			SELECT
				CAST(a.id AS NVARCHAR(MAX))
				+ CAST(a.clientId AS NVARCHAR(MAX))
				+ CAST(a.appTypeId AS NVARCHAR(MAX))
				+ CAST(a.instance AS NVARCHAR(MAX))
				+ CAST(a.backupSet AS NVARCHAR(MAX))
				+ CAST(a.appNumber AS NVARCHAR(MAX))
				+ CAST(a.dataArchGrpID AS NVARCHAR(MAX))
				+ CAST(a.logArchGrpID AS NVARCHAR(MAX))
				+ CAST(a.refTime AS NVARCHAR(MAX))
				+ CAST(a.modified AS NVARCHAR(MAX))
				+ CAST(a.subclientName AS NVARCHAR(MAX))
				+ CAST(a.subclientStatus AS NVARCHAR(MAX))
				+ CAST(a.ccpId AS NVARCHAR(MAX))
				+ CAST(a.ccpTime AS NVARCHAR(MAX))
				+ CAST(a.origCCId AS NVARCHAR(MAX))
				+ CAST(a.GUID AS NVARCHAR(MAX))
			FROM APP_Application a WITH(NOLOCK)
			WHERE
				a.id = @appId
			--ORDER BY a.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 8)
	BEGIN
		--=======================================================================
		--#### APP_iDAType
		SET @textNode = (
			SELECT
				 CAST(type AS NVARCHAR(MAX))
				+ CAST(name AS NVARCHAR(MAX))
				+ CAST(treeType AS NVARCHAR(MAX))
				+ CAST(AppGroup1 AS NVARCHAR(MAX))
				+ CAST(priority AS NVARCHAR(MAX))
				+ CAST(caseSensitivity AS NVARCHAR(MAX))
				+ CAST(dirOrder AS NVARCHAR(MAX))
				+ CAST(dirDelim AS NVARCHAR(MAX))
				+ CAST(updateRecoSec AS NVARCHAR(MAX))
				+ CAST(chunkSizeMB AS NVARCHAR(MAX))
				+ CAST(updateIntervalSec AS NVARCHAR(MAX))
				+ CAST(ccpType AS NVARCHAR(MAX))
				+ CAST(isCWEjobValid AS NVARCHAR(MAX))
				+ CAST(displayName AS NVARCHAR(MAX))
				+ CAST(indexSpaceSaver AS NVARCHAR(MAX))
			FROM APP_iDAType WITH(NOLOCK)
			WHERE type = 1030
			--ORDER BY type ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 13)
	BEGIN
		--=======================================================================
		--#### APP_InstanceName
		SET @textNode = (
			SELECT
				CAST(i.id AS NVARCHAR(MAX))
				+ CAST(i.name AS NVARCHAR(MAX))
				+ CAST(i.refTime AS NVARCHAR(MAX))
				+ CAST(i.modified AS NVARCHAR(MAX))
				+ CAST(i.status AS NVARCHAR(MAX))
				+ CAST(i.ccpId AS NVARCHAR(MAX))
				+ CAST(i.ccpTime AS NVARCHAR(MAX))
				+ CAST(i.origCCId AS NVARCHAR(MAX))
				+ CAST(i.GUID AS NVARCHAR(MAX))
			FROM APP_InstanceName i WITH(NOLOCK)
			WHERE
				i.id = @instId
			--ORDER BY i.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 11)
	BEGIN
		--=======================================================================
		--#### APP_BackupSetName
		SET @textNode  = (
			SELECT
				CAST(bs.id AS NVARCHAR(MAX))
				+ CAST(bs.name AS NVARCHAR(MAX))
				+ CAST(bs.refTime AS NVARCHAR(MAX))
				+ CAST(bs.modified AS NVARCHAR(MAX))
				+ CAST(bs.status AS NVARCHAR(MAX))
				+ CAST(bs.ccpId AS NVARCHAR(MAX))
				+ CAST(bs.ccpTime AS NVARCHAR(MAX))
				+ CAST(bs.origCCId AS NVARCHAR(MAX))
				+ CAST(bs.GUID AS NVARCHAR(MAX))
			FROM APP_BackupSetName bs WITH(NOLOCK)
			WHERE
				bs.id = @bsId
			--ORDER BY bs.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 14)
	BEGIN
		--=======================================================================
		--#### APP_InstanceProp
		SET @textNode = (
			SELECT
				CAST(p.id AS NVARCHAR(MAX))
				+ CAST(p.componentNameId AS NVARCHAR(MAX))
				+ CAST(p.attrName AS  NVARCHAR(MAX))
				+ CAST(p.attrType AS NVARCHAR(MAX))
				+ CAST(p.attrVal AS NVARCHAR(MAX))
				+ CAST(p.created AS NVARCHAR(MAX))
				+ CAST(p.modified AS NVARCHAR(MAX))
				+ CAST(p.ccpId AS NVARCHAR(MAX))
			FROM APP_InstanceProp p WITH(NOLOCK)
			WHERE
				p.componentNameId = @instId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						p.modified = 0
						AND p.created <= @inStartTime
					)
					OR (
						p.modified <> 0
						AND p.modified <= @inStartTime
					)
				)
			ORDER BY p.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 12)
	BEGIN
		--=======================================================================
		--#### APP_BackupSetProp
		SET @textNode = (
			SELECT
				CAST(p.id AS NVARCHAR(MAX))
				+ CAST(p.componentNameId AS NVARCHAR(MAX))
				+ CAST(p.attrName AS  NVARCHAR(MAX))
				+ CAST(p.attrType AS NVARCHAR(MAX))
				+ CAST(p.attrVal AS NVARCHAR(MAX))
				+ CAST(p.created AS NVARCHAR(MAX))
				+ CAST(p.modified AS NVARCHAR(MAX))
				+ CAST(p.ccpId AS NVARCHAR(MAX))
			FROM APP_BackupSetProp p WITH(NOLOCK)
			WHERE
				p.componentNameId = @bsId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						p.modified = 0
						AND p.created <= @inStartTime
					)
					OR (
						p.modified <> 0
						AND p.modified <= @inStartTime
					)
				)
				AND p.attrName NOT IN (
					SELECT
						f.value('@value', 'NVARCHAR(128)') filter
					FROM APP_CCSXMLMapping WITH(NOLOCK)
						CROSS APPLY filters.nodes('/Filters/Column/Filter') n(f)
					WHERE
						id = 12
						AND f.value('../@name', 'NVARCHAR(128)') = 'attrName'
						AND f.value('../@opType', 'NVARCHAR(128)') = 'EXCLUDE'
					)
			ORDER BY p.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 5)
	BEGIN
		--=======================================================================
		--#### APP_SubClientProp
		SET @textNode = (
			SELECT
				CAST(scp.id AS NVARCHAR(MAX))
				+ CAST(scp.componentNameId AS NVARCHAR(MAX))
				+ CAST(scp.attrName AS  NVARCHAR(MAX))
				+ CAST(scp.attrType AS NVARCHAR(MAX))
				+ CAST(scp.attrVal AS NVARCHAR(MAX))
				+ CAST(scp.created AS NVARCHAR(MAX))
				+ CAST(scp.modified AS NVARCHAR(MAX))
				+ CAST(scp.cs_attrName AS NVARCHAR(MAX))
				+ CAST(scp.ccpId AS NVARCHAR(MAX))
			FROM APP_SubClientProp scp WITH(NOLOCK)
			WHERE
				scp.componentNameId = @appId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						scp.modified = 0
						AND scp.created <= @inStartTime
					)
					OR (
						scp.modified <> 0
						AND scp.modified <= @inStartTime
					)
				)
				AND scp.attrName NOT IN (
					SELECT
						f.value('@value', 'NVARCHAR(128)') filter
					FROM APP_CCSXMLMapping WITH(NOLOCK)
						CROSS APPLY filters.nodes('/Filters/Column/Filter') n(f)
					WHERE
						id = 5
						AND f.value('../@name', 'NVARCHAR(128)') = 'attrName'
						AND f.value('../@opType', 'NVARCHAR(128)') = 'EXCLUDE'
					)
			ORDER BY scp.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 16)
	BEGIN
		--=======================================================================
		--#### APP_InstFilterFile
		SET @textNode = (
			SELECT
				CAST(f.id AS NVARCHAR(MAX))
				+ CAST(f.componentNameId AS NVARCHAR(MAX))
				+ CAST(f.type AS  NVARCHAR(MAX))
				+ CAST(f.fileName AS NVARCHAR(MAX))
				+ CAST(f.created AS NVARCHAR(MAX))
				+ CAST(f.modified AS NVARCHAR(MAX))
			FROM APP_InstFilterFile f WITH(NOLOCK)
			WHERE
				f.componentNameId = @instId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						f.modified = 0
						AND f.created <= @inStartTime
					)
					OR (
						f.modified <> 0
						AND f.modified <= @inStartTime
					)
				)
			ORDER BY f.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 15)
	BEGIN
		--=======================================================================
		--#### APP_BackupSetFilterFile
		SET @textNode  = (
			SELECT
				CAST(f.componentNameId AS NVARCHAR(MAX))
				+ CAST(f.type AS  NVARCHAR(MAX))
				+ CAST(f.fileName AS NVARCHAR(MAX))
				+ CAST(f.created AS NVARCHAR(MAX))
				+ CAST(f.modified AS NVARCHAR(MAX))
			FROM APP_BackupSetFilterFile f WITH(NOLOCK)
			WHERE
				f.componentNameId = @bsId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						f.modified = 0
						AND f.created <= @inStartTime
					)
					OR (
						f.modified <> 0
						AND f.modified <= @inStartTime
					)
				)
			ORDER BY f.created ASC,
				f.fileName COLLATE Latin1_General_CS_AS ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END ELSE IF (@inTableType = 17)
	BEGIN
		--=======================================================================
		--#### APP_ScFilterFile
		SET @textNode = (
			SELECT
				CAST(f.id AS NVARCHAR(MAX))
				+ CAST(f.componentNameId AS NVARCHAR(MAX))
				+ CAST(f.type AS  NVARCHAR(MAX))
				+ CAST(f.fileName AS NVARCHAR(MAX))
				+ CAST(f.created AS NVARCHAR(MAX))
				+ CAST(f.modified AS NVARCHAR(MAX))
				+ CAST(f.ccpId AS NVARCHAR(MAX))
				+ CAST(f.cs_fileName AS NVARCHAR(MAX))
			FROM APP_SCFilterFile f WITH(NOLOCK)
			WHERE
				f.componentNameId = @appId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						f.modified = 0
						AND f.created <= @inStartTime
					)
					OR (
						f.modified <> 0
						AND f.modified <= @inStartTime
					)
				)
			ORDER BY f.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
	END
	-- Compute MD5 Hash and save it
	SET @chkStr = ''
	SELECT
		@chkStr = v.value('.', 'VARCHAR(MAX)')
	FROM @textNode.nodes('/text') d(v)
	SET @bytes = LEN(@chkStr)
	IF (@bytes > 64000)
	BEGIN
		-- Print warning message that length has been exceeded
		PRINT 'APPCCSMd5ASCPTableHashCompare: TableType[' + CAST(@inTableType AS VARCHAR(12)) + '] exceeded hash string length > 64K len[' + CAST(@bytes AS VARCHAR(12)) + ']'
	END
	INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
		SELECT
			@appId,
			@inTableType,
			chunk,
			value,
			bytes
		FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
	-- Compare Table CS MD5 Hash with Stored CCS MD5 Hash
	DECLARE @hashRows	INT = 0
	DECLARE @csRows	INT = 0
	SELECT
		@hashRows = COUNT(*)
	FROM #md5CSHash
	SELECT
		@csRows = COUNT(*)
	FROM  APP_CCSASCPTableHashes h WITH(NOLOCK)
	WHERE
		h.ascpId = @inAppId
		AND h.tableType = @inTableType
	DECLARE @match INT = 1
	IF (@hashRows <> @csRows)
	BEGIN
		-- Hash Row Count NOT equal so no match
		SET @match = 0
	END
	IF (@match = 1)
	BEGIN
		-- Are MD5 Hash equal?
		SELECT TOP 1
			@match = 0
		FROM APP_CCSASCPTableHashes h WITH(NOLOCK)
			INNER JOIN #md5CSHash t ON
				t.tableType = h.tableType
				AND h.chunk = t.chunk
		WHERE
			h.ascpId = @inAppId
			AND (
				t.bytes <> h.csBytes
				OR master.dbo.FN_VARBINTOHEXSTR(t.value) <> h.csHash
			)
	END
	SET @outIsMatch = @match
	IF (@timers > 0)
	BEGIN
		SET @edt = SYSDATETIME()
		PRINT 'APPCCSMd5ASCPTableHashCompare End: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPCCSMd5ASCPTableHashCompare')
	delete from GxQscripts where name = 'APPCCSMd5ASCPTableHashCompare'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSMd5ASCPTableHashCompare')
	delete from GXDBVersions where aliasname = 'APPCCSMd5ASCPTableHashCompare'
GO

insert into GXDBVersions values(2, 'APPCCSMd5ASCPTableHashCompare',  '00010001000200030000', 'APPCCSMd5ASCPTableHashCompare', '00010001000200030000')
GO

