

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSMd5ASCPTableHash.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSMd5ASCPTableHash.sp,v $ $Id: APPCCSMd5ASCPTableHash.sp,v 1.1.2.3.48.1 2021/02/26 03:37:10 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='APPCCSMd5ASCPTableHash')
BEGIN
	print '>>> Drop Stored Procedure: APPCCSMd5ASCPTableHash <<<'
	drop procedure APPCCSMd5ASCPTableHash
END
IF EXISTS (select * from GxQscripts where name='APPCCSMd5ASCPTableHash')
	delete from GxQscripts where name = 'APPCCSMd5ASCPTableHash'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSMd5ASCPTableHash')
	delete from GXDBVersions where aliasname = 'APPCCSMd5ASCPTableHash'
GO
print '... Creating Procedure: APPCCSMd5ASCPTableHash'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure APPCCSMd5ASCPTableHash
  @outErrorCode INT OUTPUT,
  @outErrorMsg NVARCHAR(1024) OUTPUT,
-- inStartTime of 0 indicate MD5 Hash all SCP Table Rows no time filtering
  @inStartTime INT,
-- ascpId > 0 then only refresh MD5 Hashes for this one
  @inAscpId INT = 0,
-- inNoResults > 0 then NO result set is returned
  @inNoResults INT = 0,
-- Event Log Level
  @logLevel INT = 0
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_errorCode INT = 0
  DECLARE @o_errorCodeMsg NVARCHAR(1024) = ''
BEGIN
	SET NOCOUNT ON
	-- Purpose of the SP is to compute MD5 Hash for all Assocaited Subclient Policy Table Rows
	-- Debug and execution time messages
	DECLARE @timers TINYINT = 0
	IF (@logLevel >= 8)
	BEGIN
		SET @timers = 1
	END
	DECLARE @sdt DATETIME2
	DECLARE @edt DATETIME2
	IF (@timers > 0)
	BEGIN
		SET @sdt = SYSDATETIME()
		PRINT 'APPCCSMd5ASCPTableHash Start: ' + CAST(@sdt AS VARCHAR(128))
	END
	--#### Start Block for Compute ASCP Hashes ==========================================
	IF OBJECT_ID('tempdb.dbo.#ASCPs') IS NOT NULL
		DROP TABLE #ASCPs
	CREATE TABLE #ASCPs (
		clientId		INT,
		appTypeId		INT,
		instance		INT,
		backupSet		INT,
		ascpId			INT,
		PRIMARY KEY (clientId, ascpId)
	)
	IF (@inAscpId > 0)
	BEGIN
		INSERT INTO #ASCPs
			SELECT
				a.clientId,
				a.appTypeId,
				a.instance,
				a.backupset,
				a.id ascpId
			FROM APP_Application a WITH(NOLOCK)
			WHERE
				a.appTypeId = 1030
				AND a.clientId = 2		-- CS Id
				AND a.id = @inAscpId
	END
	ELSE
	BEGIN
		-- Determine all ASCPs to refresh
		INSERT INTO #ASCPs
			SELECT
				a.clientId,
				a.appTypeId,
				a.instance,
				a.backupset,
				a.id ascpId
			FROM APP_Application a WITH(NOLOCK)
			WHERE
				a.appTypeId = 1030
				AND a.clientId = 2		-- CS Id
	END
	IF OBJECT_ID('tempdb.dbo.#md5CSHash') IS NOT NULL
		DROP TABLE #md5CSHash
	CREATE TABLE #md5CSHash (
		ascpId			INT,
		tableType		INT,
		chunk			INT,
		value			VARBINARY(128),
		bytes			INT,
		PRIMARY KEY (tableType, chunk, ascpId)
	)
	DECLARE @textNode	XML
	DECLARE @chkStr		NVARCHAR(MAX)
	DECLARE @bytes		INT
	DECLARE @tt			INT
	DECLARE @appId		INT
	DECLARE @instId		INT
	DECLARE @bsId		INT
	DECLARE @maxStrSize	INT = 64000		-- max string length that can be successfully hashed with 8 hash buckets
	DECLARE ASCPCursor CURSOR LOCAL FORWARD_ONLY READ_ONLY FOR
		SELECT DISTINCT
			ascp.ascpId,
			ascp.instance,
			ascp.backupSet
		FROM #ASCPs ascp
	OPEN ASCPCursor
	FETCH NEXT FROM ASCPCursor
		INTO @appId, @instId, @bsId
	WHILE @@FETCH_STATUS = 0
	BEGIN
		--=======================================================================
		--#### APP_Application
		SET @textNode = (
			SELECT
				CAST(a.id AS NVARCHAR(MAX))
				+ CAST(a.clientId AS NVARCHAR(MAX))
				+ CAST(a.appTypeId AS NVARCHAR(MAX))
				+ CAST(a.instance AS NVARCHAR(MAX))
				+ CAST(a.backupSet AS NVARCHAR(MAX))
				+ CAST(a.appNumber AS NVARCHAR(MAX))
				+ CAST(a.dataArchGrpID AS NVARCHAR(MAX))
				+ CAST(a.logArchGrpID AS NVARCHAR(MAX))
				+ CAST(a.refTime AS NVARCHAR(MAX))
				+ CAST(a.modified AS NVARCHAR(MAX))
				+ CAST(a.subclientName AS NVARCHAR(MAX))
				+ CAST(a.subclientStatus AS NVARCHAR(MAX))
				+ CAST(a.ccpId AS NVARCHAR(MAX))
				+ CAST(a.ccpTime AS NVARCHAR(MAX))
				+ CAST(a.origCCId AS NVARCHAR(MAX))
				+ CAST(a.GUID AS NVARCHAR(MAX))
			FROM APP_Application a WITH(NOLOCK)
			WHERE
				a.id = @appId
			--ORDER BY a.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 4
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_iDAType
		SET @textNode = (
			SELECT
				 CAST(type AS NVARCHAR(MAX))
				+ CAST(name AS NVARCHAR(MAX))
				+ CAST(treeType AS NVARCHAR(MAX))
				+ CAST(AppGroup1 AS NVARCHAR(MAX))
				+ CAST(priority AS NVARCHAR(MAX))
				+ CAST(caseSensitivity AS NVARCHAR(MAX))
				+ CAST(dirOrder AS NVARCHAR(MAX))
				+ CAST(dirDelim AS NVARCHAR(MAX))
				+ CAST(updateRecoSec AS NVARCHAR(MAX))
				+ CAST(chunkSizeMB AS NVARCHAR(MAX))
				+ CAST(updateIntervalSec AS NVARCHAR(MAX))
				+ CAST(ccpType AS NVARCHAR(MAX))
				+ CAST(isCWEjobValid AS NVARCHAR(MAX))
				+ CAST(displayName AS NVARCHAR(MAX))
				+ CAST(indexSpaceSaver AS NVARCHAR(MAX))
			FROM APP_iDAType WITH(NOLOCK)
			WHERE type = 1030
			--ORDER BY type ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 8
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_InstanceName
		SET @textNode = (
			SELECT
				CAST(i.id AS NVARCHAR(MAX))
				+ CAST(i.name AS NVARCHAR(MAX))
				+ CAST(i.refTime AS NVARCHAR(MAX))
				+ CAST(i.modified AS NVARCHAR(MAX))
				+ CAST(i.status AS NVARCHAR(MAX))
				+ CAST(i.ccpId AS NVARCHAR(MAX))
				+ CAST(i.ccpTime AS NVARCHAR(MAX))
				+ CAST(i.origCCId AS NVARCHAR(MAX))
				+ CAST(i.GUID AS NVARCHAR(MAX))
			FROM APP_InstanceName i WITH(NOLOCK)
			WHERE
				i.id = @instId
			--ORDER BY i.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 13
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_BackupSetName
		SET @textNode  = (
			SELECT
				CAST(bs.id AS NVARCHAR(MAX))
				+ CAST(bs.name AS NVARCHAR(MAX))
				+ CAST(bs.refTime AS NVARCHAR(MAX))
				+ CAST(bs.modified AS NVARCHAR(MAX))
				+ CAST(bs.status AS NVARCHAR(MAX))
				+ CAST(bs.ccpId AS NVARCHAR(MAX))
				+ CAST(bs.ccpTime AS NVARCHAR(MAX))
				+ CAST(bs.origCCId AS NVARCHAR(MAX))
				+ CAST(bs.GUID AS NVARCHAR(MAX))
			FROM APP_BackupSetName bs WITH(NOLOCK)
			WHERE
				bs.id = @bsId
			--ORDER BY bs.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 11
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_InstanceProp
		SET @textNode = (
			SELECT
				CAST(p.id AS NVARCHAR(MAX))
				+ CAST(p.componentNameId AS NVARCHAR(MAX))
				+ CAST(p.attrName AS  NVARCHAR(MAX))
				+ CAST(p.attrType AS NVARCHAR(MAX))
				+ CAST(p.attrVal AS NVARCHAR(MAX))
				+ CAST(p.created AS NVARCHAR(MAX))
				+ CAST(p.modified AS NVARCHAR(MAX))
				+ CAST(p.ccpId AS NVARCHAR(MAX))
			FROM APP_InstanceProp p WITH(NOLOCK)
			WHERE
				p.componentNameId = @instId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						p.modified = 0
						AND p.created <= @inStartTime
					)
					OR (
						p.modified <> 0
						AND p.modified <= @inStartTime
					)
				)
			ORDER BY p.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 14
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_BackupSetProp
		SET @textNode = (
			SELECT
				CAST(p.id AS NVARCHAR(MAX))
				+ CAST(p.componentNameId AS NVARCHAR(MAX))
				+ CAST(p.attrName AS  NVARCHAR(MAX))
				+ CAST(p.attrType AS NVARCHAR(MAX))
				+ CAST(p.attrVal AS NVARCHAR(MAX))
				+ CAST(p.created AS NVARCHAR(MAX))
				+ CAST(p.modified AS NVARCHAR(MAX))
				+ CAST(p.ccpId AS NVARCHAR(MAX))
			FROM APP_BackupSetProp p WITH(NOLOCK)
			WHERE
				p.componentNameId = @bsId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						p.modified = 0
						AND p.created <= @inStartTime
					)
					OR (
						p.modified <> 0
						AND p.modified <= @inStartTime
					)
				)
				AND p.attrName NOT IN (
					SELECT
						f.value('@value', 'NVARCHAR(128)') filter
					FROM APP_CCSXMLMapping WITH(NOLOCK)
						CROSS APPLY filters.nodes('/Filters/Column/Filter') n(f)
					WHERE
						id = 12
						AND f.value('../@name', 'NVARCHAR(128)') = 'attrName'
						AND f.value('../@opType', 'NVARCHAR(128)') = 'EXCLUDE'
					)
			ORDER BY p.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 12
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_SubClientProp
		SET @textNode = (
			SELECT
				CAST(scp.id AS NVARCHAR(MAX))
				+ CAST(scp.componentNameId AS NVARCHAR(MAX))
				+ CAST(scp.attrName AS  NVARCHAR(MAX))
				+ CAST(scp.attrType AS NVARCHAR(MAX))
				+ CAST(scp.attrVal AS NVARCHAR(MAX))
				+ CAST(scp.created AS NVARCHAR(MAX))
				+ CAST(scp.modified AS NVARCHAR(MAX))
				+ CAST(scp.cs_attrName AS NVARCHAR(MAX))
				+ CAST(scp.ccpId AS NVARCHAR(MAX))
			FROM APP_SubClientProp scp WITH(NOLOCK)
			WHERE
				scp.componentNameId = @appId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						scp.modified = 0
						AND scp.created <= @inStartTime
					)
					OR (
						scp.modified <> 0
						AND scp.modified <= @inStartTime
					)
				)
				AND scp.attrName NOT IN (
					SELECT
						f.value('@value', 'NVARCHAR(128)') filter
					FROM APP_CCSXMLMapping WITH(NOLOCK)
						CROSS APPLY filters.nodes('/Filters/Column/Filter') n(f)
					WHERE
						id = 5
						AND f.value('../@name', 'NVARCHAR(128)') = 'attrName'
						AND f.value('../@opType', 'NVARCHAR(128)') = 'EXCLUDE'
					)
			ORDER BY scp.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 5
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_InstFilterFile
		SET @textNode = (
			SELECT
				CAST(f.id AS NVARCHAR(MAX))
				+ CAST(f.componentNameId AS NVARCHAR(MAX))
				+ CAST(f.type AS  NVARCHAR(MAX))
				+ CAST(f.fileName AS NVARCHAR(MAX))
				+ CAST(f.created AS NVARCHAR(MAX))
				+ CAST(f.modified AS NVARCHAR(MAX))
			FROM APP_InstFilterFile f WITH(NOLOCK)
			WHERE
				f.componentNameId = @instId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						f.modified = 0
						AND f.created <= @inStartTime
					)
					OR (
						f.modified <> 0
						AND f.modified <= @inStartTime
					)
				)
			ORDER BY f.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 16
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_BackupSetFilterFile
		SET @textNode  = (
			SELECT
				CAST(f.componentNameId AS NVARCHAR(MAX))
				+ CAST(f.type AS  NVARCHAR(MAX))
				+ CAST(f.fileName AS NVARCHAR(MAX))
				+ CAST(f.created AS NVARCHAR(MAX))
				+ CAST(f.modified AS NVARCHAR(MAX))
			FROM APP_BackupSetFilterFile f WITH(NOLOCK)
			WHERE
				f.componentNameId = @bsId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						f.modified = 0
						AND f.created <= @inStartTime
					)
					OR (
						f.modified <> 0
						AND f.modified <= @inStartTime
					)
				)
			ORDER BY f.created ASC,
				f.fileName COLLATE Latin1_General_CS_AS ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 15
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		--=======================================================================
		--#### APP_ScFilterFile
		SET @textNode = (
			SELECT
				CAST(f.id AS NVARCHAR(MAX))
				+ CAST(f.componentNameId AS NVARCHAR(MAX))
				+ CAST(f.type AS  NVARCHAR(MAX))
				+ CAST(f.fileName AS NVARCHAR(MAX))
				+ CAST(f.created AS NVARCHAR(MAX))
				+ CAST(f.modified AS NVARCHAR(MAX))
				+ CAST(f.ccpId AS NVARCHAR(MAX))
				+ CAST(f.cs_fileName AS NVARCHAR(MAX))
			FROM APP_SCFilterFile f WITH(NOLOCK)
			WHERE
				f.componentNameId = @appId
				AND (		-- avoid missing an update to CCSDb if rows changed just before and after start time
					@inStartTime = 0		-- no time filter, get all rows
					OR (
						f.modified = 0
						AND f.created <= @inStartTime
					)
					OR (
						f.modified <> 0
						AND f.modified <= @inStartTime
					)
				)
			ORDER BY f.id ASC
			FOR XML PATH(''), ROOT('text'), TYPE
		)
		SET @chkStr = ''
		SELECT
			@chkStr = v.value('.', 'NVARCHAR(MAX)')
		FROM @textNode.nodes('/text') d(v)
		SET @bytes = LEN(@chkStr)
		SET @tt = 17
		IF (@bytes > @maxStrSize)
		BEGIN
			-- Print warning message that length has been exceeded
			PRINT 'APPCCSMd5ASCPTableHash: TableType[' + CAST(@tt AS VARCHAR(12)) + '] exceeded hash string length > ' + CAST(@maxStrSize AS VARCHAR(12)) + ' len[' + CAST(@bytes AS VARCHAR(12)) + ']'
		END
		INSERT INTO #md5CSHash (ascpId, tableType, chunk, value, bytes)
			SELECT
				@appId,
				@tt,
				chunk,
				value,
				bytes
			FROM dbo.CCSComputeTableHashRows(@bytes, @chkStr)
		FETCH NEXT FROM ASCPCursor
			INTO @appId, @instId, @bsId
	END
	CLOSE ASCPCursor
	DEALLOCATE ASCPCursor
	--=========================================================================
	-- From here on actual database updates take place to APP_CCSASCPTableHashes
	--=========================================================================
	DECLARE @opSuccessful	TINYINT = 0
	DECLARE @tranCnt		INT = @@TRANCOUNT
	IF (@tranCnt > 0)
	BEGIN
		PRINT 'APPCCSMd5ASCPTableHash: Warning transaction started outside of SP, TransactionCount[' + CAST(@tranCnt AS VARCHAR(120)) + ']!'
	END
	DECLARE @nowTime	BIGINT = dbo.GetUnixTimeBig(GETUTCDATE())
	BEGIN TRY
		BEGIN TRANSACTION Update_ASCPHashes
		UPDATE d
			SET d.csHash = master.dbo.FN_VARBINTOHEXSTR(s.value),
				d.csBytes = s.bytes,
				d.csTime = @nowTime
		FROM APP_CCSASCPTableHashes d
			INNER JOIN #md5CSHash s ON
				d.ascpId = s.ascpId
				AND d.tableType =  s.tableType
				AND d.chunk = s.chunk
		WHERE
			d.csHash <> master.dbo.FN_VARBINTOHEXSTR(s.value)
			OR d.csBytes <> s.bytes
		INSERT INTO APP_CCSASCPTableHashes (ascpId, tableType, chunk, csHash, csTime, csBytes)
			SELECT
				s.ascpId,
				s.tableType,
				s.chunk,
				master.dbo.FN_VARBINTOHEXSTR(s.value),
				@nowTime,
				s.bytes
			FROM #md5CSHash s
				LEFT OUTER JOIN APP_CCSASCPTableHashes d ON
					d.ascpId = s.ascpId
					AND d.tableType =  s.tableType
					AND d.chunk = s.chunk
			WHERE
				d.ascpId IS NULL
		-- Delete rows no longer needed
		DELETE h
		FROM APP_CCSASCPTableHashes h
			INNER JOIN (
					SELECT
						-- Get all rows / chunks for client and table type
						h.ascpId,
						h.tableType,
						h.chunk
					FROM APP_CCSASCPTableHashes h
						INNER JOIN #md5CSHash t ON
							h.ascpId = t.ascpId
							AND h.tableType = t.tableType
					EXCEPT
					SELECT
						-- Get all rows / chunks from the input to remove data rows above to keep. The remaining should be deleted.
						t.ascpId,
						t.tableType,
						t.chunk
					FROM #md5CSHash t
				) d ON
					d.ascpId = h.ascpId
					AND d.tableType = h.tableType
					AND d.chunk = h.chunk
		COMMIT TRANSACTION Update_ASCPHashes
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @o_errorCode = 1
		SET @o_errorCodeMsg = 'APP_CCSASCPTableHashes table row update failed'
		ROLLBACK TRANSACTION Update_ASCPHashes
	END CATCH
	IF (@inNoResults = 0)
	BEGIN
		-- Return result set
		SELECT @o_errorCode o_errorCode, @o_errorCodeMsg o_errorCodeMsg
	END
	SET @outErrorCode = @o_errorCode
	SET @outErrorMsg = @o_errorCodeMsg
	IF (@timers > 0)
	BEGIN
		SET @edt = SYSDATETIME()
		PRINT 'APPCCSMd5ASCPTableHash End: ' + CAST(@edt AS VARCHAR(128)) + '  TimeMS: ' + CAST(DATEDIFF(ms, @sdt, @edt) AS VARCHAR(24))
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPCCSMd5ASCPTableHash')
	delete from GxQscripts where name = 'APPCCSMd5ASCPTableHash'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSMd5ASCPTableHash')
	delete from GXDBVersions where aliasname = 'APPCCSMd5ASCPTableHash'
GO

insert into GXDBVersions values(2, 'APPCCSMd5ASCPTableHash',  'v1.1.2.3.48.1', 'APPCCSMd5ASCPTableHash', 'v1.1.2.3.48.1')
GO

