

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSDbStatus.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSDbStatus.sp,v $ $Id: APPCCSDbStatus.sp,v 1.4.12.12 2018/10/27 03:47:25 logeshg Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPCCSDbStatus')
BEGIN
	print '>>> Drop Stored Procedure: APPCCSDbStatus <<<'
	drop procedure APPCCSDbStatus
END
IF EXISTS (select * from GxQscripts where name='APPCCSDbStatus')
	delete from GxQscripts where name = 'APPCCSDbStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSDbStatus')
	delete from GXDBVersions where aliasname = 'APPCCSDbStatus'
GO
print '... Creating Procedure: APPCCSDbStatus'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCCSDbStatus
--  User Input arguments
  @regInfo XML
AS
	-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @outputXml XML = NULL;
BEGIN
	SET NOCOUNT ON
	DECLARE @workToken INT = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
	DECLARE @regWorkToken INT = 6	-- WORK_TOKEN_REGISTRY
	DECLARE @workQueueReq XML
	DECLARE @workQueueOutput XML
	DECLARE @errorCode INT = 0
	DECLARE @errorString NVARCHAR(1024) = N'Success'
	-- <TBL_CCSDbStatusReq opType="SETDB" clientId="4" dbStatus="ONLINE" />
	IF (@regInfo IS NULL)
	BEGIN
		SET @outputXml = (SELECT
							3 AS 'opStatus/@errorCode',
							'XML Input is NULL' AS 'opStatus/@errorMessage'
						FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
		GOTO END_OF_PROC
	END
	DECLARE @opType VARCHAR(128) = NULL
	DECLARE @clientId INT = NULL
	DECLARE @dbStatus NVARCHAR(128) = NULL
	DECLARE @clientName NVARCHAR(256) = NULL
	SELECT
		@opType = attr.value('@opType', 'NVARCHAR(128)'),
		@clientId = attr.value('@clientId', 'INT'),
		@clientName = attr.value('@clientName', 'NVARCHAR(128)'),
		@dbStatus = attr.value('@dbStatus', 'NVARCHAR(128)')
	FROM
		@regInfo.nodes('TBL_CCSDbStatusReq') tci(attr)
	IF (@opType IS NULL OR @opType NOT IN ('GETDB', 'SETDB', 'GETCCS','SETLOADREQ'))
	BEGIN
		SET @outputXml = (SELECT
							4 AS 'opStatus/@errorCode',
							'Requested OpType is invalid' AS 'opStatus/@errorMessage'
						FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
		GOTO END_OF_PROC
	END
	BEGIN TRY
		IF ((@clientId IS NULL AND @clientName IS NULL) OR @clientId < 1 OR @clientName = '')
		BEGIN
			SET @outputXml = (SELECT
									2 AS 'opStatus/@errorCode',
									'Clientname lookup not found' AS 'opStatus/@errorMessage'
								FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			GOTO END_OF_PROC
		END
		IF ((@clientId IS NULL OR @clientId < 1) AND @clientName IS NOT NULL AND @clientName <> '')
		BEGIN
			SET @clientId = NULL
			SELECT
				@clientId = c.id
			FROM APP_Client c WITH(NOLOCK)
			WHERE
				c.name = @clientName
				AND (c.status & 2) = 0
			IF (@clientId IS NULL)
			BEGIN
				SET @outputXml = (SELECT
										2 AS 'opStatus/@errorCode',
										'Clientname lookup not found' AS 'opStatus/@errorMessage'
									FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
				GOTO END_OF_PROC
			END
		END
		ELSE
		BEGIN
			IF NOT EXISTS (SELECT
							c.id
						FROM APP_Client c WITH(NOLOCK)
						WHERE
							c.id = @clientId
							AND (c.status & 2) = 0)
			BEGIN
				SET @outputXml = (SELECT
										8 AS 'opStatus/@errorCode',
										'Clientid lookup not found' AS 'opStatus/@errorMessage'
									FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
				GOTO END_OF_PROC
			END
		END
		IF (@dbStatus IS NOT NULL AND @dbStatus NOT IN ('ONLINE', 'OFFLINE', 'LOAD', 'CREATE', 'DISABLED'))
		BEGIN
			SET @outputXml = (SELECT
									@dbStatus AS '@dbStatus',
									6 AS 'opStatus/@errorCode',
									'Invalid database status' AS 'opStatus/@errorMessage'
								FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			GOTO END_OF_PROC
		END
		-- Is Client configured properly for CCS Usage?
		IF @dbStatus <> 'DISABLED' AND NOT EXISTS (SELECT 1 FROM dbo.IsCCSSoftwareUsageValidForClient(@clientId))
		BEGIN
			-- invalid client configuration
			SET @outputXml = (SELECT
									9 AS 'opStatus/@errorCode',
									'Invalid client configuration for CCS usage' AS 'opStatus/@errorMessage'
								FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			GOTO END_OF_PROC
		END
		IF (@opType = 'SETDB')
		BEGIN
			DECLARE @asId INT = NULL
			SELECT
				@asId = s.id
			FROM APP_AdvanceSettings s WITH(NOLOCK)
			WHERE
				s.entityType = 3
				AND s.entityId = @clientId
				AND s.keyName = N'sCCSDbStatus'
				AND s.relativePath = N'iDataAgent'
				AND CAST(s.value AS NVARCHAR(128)) <> @dbStatus
			IF (@asId IS NOT NULL)
			BEGIN
				UPDATE APP_AdvanceSettings
					SET [value] = @dbStatus,
						[enabled] = 1,
						[deleted] = 0
				WHERE
					id = @asId
			END
			-- If client disabling CCS indicates a configuration change, so disable 'CCS Enabled' for the client.
			IF (@dbStatus = 'DISABLED')
			BEGIN
				UPDATE cp
					SET attrVal = N'0'
				FROM APP_ClientProp cp
				WHERE
					cp.componentNameId =  @clientId
					AND cp.attrName = N'CCS Enabled'
					AND cp.modified = 0
					AND cp.attrVal <> N'0'
			END
			IF (@asId IS NOT NULL)
			BEGIN
				-- Setup WorkToken 6 to re-populate the Advance Setting Cache file on the client
				-- so that it does not reset the sCCSDbStatus regkey back to load every hour on refresh!!!!
				SET @workQueueReq = (
					SELECT
						@regWorkToken as '@workToken',
						'' '@workTokenParams',
						@clientId as 'client/@clientId'
					FOR XML PATH('App_SubmitWorkQueueReq')
				)
				EXEC AppWorkQueueSubmitRequestXMLOUTPUT @workQueueReq, @workQueueOutput output
				SELECT @errorCode = ISNULL(attr.value('@errorCode', 'INT'),0),
						@errorString = ISNULL(attr.value('@errorMessage', 'NVARCHAR(1024)'),'')
				FROM
					@workQueueOutput.nodes('App_GenericResp') tci(attr)
			END
			SET @outputXml = (SELECT
									@dbStatus AS '@dbStatus',
									@errorCode AS 'opStatus/@errorCode',
									@errorString AS 'opStatus/@errorMessage'
								FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			GOTO END_OF_PROC
		END
		IF (@opType = 'GETDB')
		BEGIN
			DECLARE @getDbStatus NVARCHAR(128) = ''
			SELECT
				@getDbStatus = CAST(s.value AS NVARCHAR(128))
			FROM APP_AdvanceSettings s WITH(NOLOCK)
			WHERE
				s.entityType = 3
				AND s.entityId = @clientId
				AND s.keyName = 'sCCSDbStatus'
				AND s.relativePath = N'iDataAgent'
			IF (@getDbStatus = '')
			BEGIN
				SET @outputXml = (SELECT
										100 AS 'opStatus/@errorCode',
										'No data row found' AS 'opStatus/@errorMessage'
									FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			END
			ELSE
			BEGIN
				SET @outputXml = (SELECT
										@getDbStatus AS '@dbStatus',
										0 AS 'opStatus/@errorCode',
										'Success' AS 'opStatus/@errorMessage'
									FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			END
			GOTO END_OF_PROC
		END
		IF (@opType = 'GETCCS')
		BEGIN
			DECLARE @csCCSEnabled	INT = 0
			DECLARE @cpValue	NVARCHAR(128) = NULL
			SELECT @csCCSEnabled = CAST(value AS INT) FROM GXGlobalParam WHERE name = 'CommServCCSEnabled'
			IF (@csCCSEnabled = 1)
			BEGIN
				SELECT
					@cpValue = cp.attrVal
				FROM APP_Client c WITH(NOLOCK)
					INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName = N'CCS Enabled'
						AND cp.modified = 0
				WHERE
					c.id = @clientId
					AND (c.status & 4096) > 0		-- laptop configured
					AND (c.status & (2|4)) = 0		-- client not uninstalled or deleted
			END
			ELSE
			BEGIN
				SET @cpValue = '0'	-- client should be OFFLINE if overall CS CCS Disabled
			END
			IF (@cpValue IS NULL)
			BEGIN
				SET @outputXml = (SELECT
										0 AS '@ccsStatus',
										7 AS 'opStatus/@errorCode',
										'Client ''CCS Enabled'' property not configured' AS 'opStatus/@errorMessage'
									FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			END
			ELSE
			BEGIN
				SET @outputXml = (SELECT
										CAST(@cpValue AS INT) AS '@ccsStatus',
										0 AS 'opStatus/@errorCode',
										'Success' AS 'opStatus/@errorMessage'
									FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			END
			GOTO END_OF_PROC
		END
		IF (@opType = 'SETLOADREQ')
		BEGIN
			IF EXISTS (
				SELECT
					1
				FROM APP_ClientProp cp WITH(NOLOCK)
				WHERE
					cp.componentNameId =  @clientId
					AND cp.attrName = N'CCS Enabled'
					AND cp.modified = 0
					AND cp.attrVal = N'1'
			)
			BEGIN
				-- CCS is enabled
				set @workQueueReq = (
					select @workToken as '@workToken'
						, '' '@workTokenParams'
						, @clientId as 'client/@clientId'
					for xml path('App_SubmitWorkQueueReq')--,root('App_SubmitWorkQueueReq')
				)
				exec AppWorkQueueSubmitRequestXMLOUTPUT @workQueueReq,@workQueueOutput output
				SELECT @errorCode = ISNULL(attr.value('@errorCode', 'INT'),0),
						@errorString = ISNULL(attr.value('@errorMessage', 'NVARCHAR(MAX)'),'')
				FROM
					@workQueueOutput.nodes('App_GenericResp') tci(attr)
			END
			ELSE
			BEGIN
				-- Error - CCS is not enabled
				SET @errorCode = 10
				SET @errorString = 'Client is NOT enabled for CCS Operations.'
			END
			IF @errorCode <> 0
			BEGIN
				SET @outputXml = (SELECT
									@errorCode AS 'opStatus/@errorCode',
									@errorString AS 'opStatus/@errorMessage'
								FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			END
			ELSE
			BEGIN
				SET @outputXml = (SELECT
									0 AS 'opStatus/@errorCode',
									'Success' AS 'opStatus/@errorMessage'
								FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
			END
			GOTO END_OF_PROC
		END
		SET @outputXml = (SELECT
							5 AS 'opStatus/@errorCode',
							'Invalid configured request' AS 'opStatus/@errorMessage'
						FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @outputXml = (SELECT
								1 AS 'opStatus/@errorCode',
								'Catch Block Error Incurred' AS 'opStatus/@errorMessage'
							FOR XML PATH('TBL_CCSDbStatusResp'), TYPE)
	END CATCH
END_OF_PROC:
	SELECT @outputXml outputXml
	RETURN
END

IF EXISTS (select * from GxQscripts where name = 'APPCCSDbStatus')
	delete from GxQscripts where name = 'APPCCSDbStatus'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSDbStatus')
	delete from GXDBVersions where aliasname = 'APPCCSDbStatus'
GO

insert into GXDBVersions values(2, 'APPCCSDbStatus',  '00010004001200120000', 'APPCCSDbStatus', '00010004001200120000')
GO

