

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSDRSetClientLOADState.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSDRSetClientLOADState.sp,v $ $Id: APPCCSDRSetClientLOADState.sp,v 1.1.2.1 2018/09/11 02:10:43 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: APPCCSDRSetClientLOADState <<<'

IF EXISTS (select * from sysobjects where name='APPCCSDRSetClientLOADState')
	drop procedure APPCCSDRSetClientLOADState
IF EXISTS (select * from GxQscripts where name='APPCCSDRSetClientLOADState')
	delete from GxQscripts where name = 'APPCCSDRSetClientLOADState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSDRSetClientLOADState')
	delete from GXDBVersions where aliasname = 'APPCCSDRSetClientLOADState'
GO
print '... Creating Procedure: APPCCSDRSetClientLOADState'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCCSDRSetClientLOADState
-- Input arguments
-- Default 0 means all clients
  @clientId INT = 0
AS
BEGIN
	SET NOCOUNT ON
	IF EXISTS (
		SELECT 1
		FROM GXGlobalParam gp WITH(NOLOCK)
		WHERE
			name = N'CommServCCSEnabled'
			AND value = N'1'		-- CCS is enabled on the CS
	)
	BEGIN
		DECLARE @now INT = dbo.GetUnixTime(GETUTCDATE())
		IF (@clientId > 0)
		BEGIN
			-- Reload specific client
			-- Delete 49 CCS WorkTokens for Client - do not duplicate rows in table
			DELETE FROM APP_WorkQueueRequest
			WHERE
				clientId = @clientId
				AND workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
				AND workTokenParams <> N'DISABLED'	-- leave disabled row
			INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
				SELECT
					cp.componentNameId clientId,
					-1 remoteClient,
					49 workToken,		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
					'LOAD' workTokenParams,
					@now createTime,
					0 lastUpdateTime,
					0 retryCount,
					0 flag
				FROM APP_ClientProp cp WITH(NOLOCK)
					INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
						s.entityId = cp.componentNameId
						AND s.entityType = 3		-- Client Type
						AND s.keyName = N'sCCSDbStatus'
					LEFT OUTER JOIN APP_WorkQueueRequest wqr WITH(NOLOCK) ON		-- make sure we did not leave a DISABLED row
						wqr.clientId = cp.componentNameId
						AND wqr.workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
				WHERE
					wqr.clientId IS NULL
					AND cp.componentNameId = @clientId
					AND cp.attrName = N'CCS Enabled'
					AND cp.modified = 0
					AND cp.attrVal = N'1'
					AND CAST(s.value AS NVARCHAR(MAX)) = N'ONLINE'
		END
		ELSE
		BEGIN
			-- Force a Reload of all CCS Laptop Clients that are ONLINE
			-- Delete ALL 49 CCS WorkTokens - do not duplicate rows in table
			DELETE FROM APP_WorkQueueRequest
			WHERE
				workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
				AND workTokenParams <> N'DISABLED'	-- leave disabled rows
			INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
				SELECT
					cp.componentNameId clientId,
					-1 remoteClient,
					49 workToken,		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
					'LOAD' workTokenParams,
					@now createTime,
					0 lastUpdateTime,
					0 retryCount,
					0 flag
				FROM APP_ClientProp cp WITH(NOLOCK)
					INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
						s.entityId = cp.componentNameId
						AND s.entityType = 3		-- Client Type
						AND s.keyName = N'sCCSDbStatus'
					LEFT OUTER JOIN APP_WorkQueueRequest wqr WITH(NOLOCK) ON		-- make sure we did not leave a DISABLED row
						wqr.clientId = cp.componentNameId
						AND wqr.workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
				WHERE
					wqr.clientId IS NULL
					AND cp.attrName = N'CCS Enabled'
					AND cp.modified = 0
					AND cp.attrVal = N'1'
					AND CAST(s.value AS NVARCHAR(MAX)) = N'ONLINE'
		END
	END
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPCCSDRSetClientLOADState')
	delete from GxQscripts where name = 'APPCCSDRSetClientLOADState'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSDRSetClientLOADState')
	delete from GXDBVersions where aliasname = 'APPCCSDRSetClientLOADState'
GO

insert into GXDBVersions values(2, 'APPCCSDRSetClientLOADState',  '00010001000200010000', 'APPCCSDRSetClientLOADState', '00010001000200010000')
GO

