

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSControls.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSControls.sp,v $ $Id: APPCCSControls.sp,v 1.5.12.15 2019/04/30 19:31:12 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPCCSControls')
BEGIN
	print '>>> Drop Stored Procedure: APPCCSControls <<<'
	drop procedure APPCCSControls
END
IF EXISTS (select * from GxQscripts where name='APPCCSControls')
	delete from GxQscripts where name = 'APPCCSControls'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSControls')
	delete from GXDBVersions where aliasname = 'APPCCSControls'
GO
print '... Creating Procedure: APPCCSControls'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCCSControls
--  User Input arguments
  @opCode INT = 0,
  @clientId INT = NULL,
  @force INT = 0,
-- Internal use only - Input and Output Variables!
  @value1 INT = NULL,
  @value2 VARCHAR(128) = NULL,
  @setOutValues INT = NULL,
  @outValue1 INT = NULL OUTPUT,
  @silentMode INT = 0,		-- no select rows outputted for status, being used by another SP
  @clientGroupId INT = NULL,
  @blockEnabledCount INT = NULL	-- Number clients to enable CCS on due to need to throttle network activity: value 50 to 500
AS
BEGIN
	SET NOCOUNT ON
	IF (@opCode = 0)
	BEGIN
		PRINT 'Usage: APPCCSControls @opCode=0, @clientId=NULL, @force=0, @silentMode=0'
		PRINT '   Opcode=0: help message'
		PRINT '   Opcode=1: Get list of clients with ''CCS Enabled'' property'
		PRINT '   Opcode=2: Get CommServer ''CCS Enabled'' property'
		PRINT '   Opcode=3: CCS Trigger Status'
		--PRINT '   Opcode=4: Insert Client CCS Enabled Property for @clientId'
		PRINT '   Opcode=5: Delete CCS (WorkToken 19 | 49) Work Queue operations for @clientId'
		PRINT '   Opcode=6: Disable CS CCS Enabled Property [@force=1]'
		PRINT '   Opcode=7: Enable CS CCS Enabled Property [@force=1]'
		PRINT '   Opcode=8: Get Client CCS Enabled Property for @clientId'
		PRINT '   Opcode=9: Disable Client CCS Enabled Property for @clientId [@force=1]'
		PRINT '   Opcode=10: Enable Client CCS Enabled Property for @clientId [@force=1]'
		PRINT '   Opcode=11: Change CCSDbStatus to LOAD for @clientId'
		PRINT '   Opcode=12: Check for problem CCS Clients in WorkQueue'
		--PRINT '   Opcode=13: Disable ClientGroup CCS Enabled Property for @clientGroupId [@force=1]'
		--PRINT '   Opcode=14: Enable ClientGroup CCS Enabled Property for @clientGroupId [@force=1]'
		PRINT '   Opcode=15: Get Clients with ''CCS Enabled'' Property by client group or for specific @clientGroupId'
		--PRINT '   Opcode=16: Disable ALL Clients with ''CCS Enabled'' that have more than Filesystem Core / MA Core and Laptop Configuration installed'
		--PRINT '   Opcode=17: Disable ALL Clients with CCS Enabled Property enabled'
		RETURN 0
	END
	--SELECT @opCode AS opCode, 'STARTED'
	-- Drop temp tables if they exist
	IF OBJECT_ID('tempdb.dbo.#CCSClients') IS NOT NULL
		DROP TABLE #CCSClients
	-- Local Variables
	DECLARE @exitCode		INT = 0
	DECLARE @rc				INT = 0
	--DECLARE @transStarted	INT = 0
	DECLARE @cpOutValue		INT = NULL
	--DECLARE @transLogging	INT = 0
	DECLARE @rowCnt			INT = 0
	DECLARE @cursorNonCfg	TINYINT = 0
	DECLARE @nowTime		INT = dbo.GetUnixTime(GetUTCDate())			-- only get time once for entire SP
	DECLARE @wkToken49		INT = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
	DECLARE @wkToken19		INT = 19		-- WORK_TOKEN_CCS_DB_UPDATE
	DECLARE @clientErrorMsg					VARCHAR(128) = '@clientId is NULL, required input.'
	DECLARE @clientGroupErrorMsg			VARCHAR(128) = '@clientGroupId is NULL, required input.'
	DECLARE @blockEnabledCountMsg			VARCHAR(128) = '@blockEnabledCount is invalid value, required input of a value between 50 and 500.'
	DECLARE @clientInvalidCfgErrorMsg		VARCHAR(128) = 'Client software configuration is invalid for CCS usage.'
	DECLARE @errorMessage					VARCHAR(1024) = ''
	--DECLARE @transName						VARCHAR(32) = 'CCSTrans_' + CAST(@opCode AS VARCHAR(12)) + '_' + CAST(@nowTime AS VARCHAR(12))
	DECLARE @ccsDbStatus					VARCHAR(24)
	-- Get CS Global CCS Setting
	DECLARE @isCSCCSEnabled	INT = NULL
	SELECT
		@isCSCCSEnabled = CAST(p.value AS INT)
	FROM GXGlobalParam p WITH(NOLOCK)
	WHERE
		name = 'CommServCCSEnabled'
	IF (@isCSCCSEnabled IS NULL)
	BEGIN
		SET @errorMessage = 'GXGlobalParam ''CommServCCSEnabled'' Property row not found.'
		SET @exitCode = 1
		GOTO END_OF_PROC
	END
	-- Make sure operation is compatible with CommServer CCS Setting
	IF (@isCSCCSEnabled = 0)
	BEGIN
		IF (@opCode IN (4, 10, 11, 14))
		BEGIN
			SET @errorMessage = 'Invalid operation requested, CommServer has CCS functionality disabled. Enable CommServCCSEnabled first, opCode=7, and try again.'
			SET @exitCode = 1
			GOTO END_OF_PROC
		END
	END
	BEGIN TRY
		--BEGIN TRANSACTION @transName
		--SET @transStarted = 1
		--IF (@transLogging > 0) SELECT @opCode AS opCode, 'TRANS STARTED', @transName
		--================================================================
		-- User OpCodes
		--================================================================
		--================================================================
		-- Operation 1:
		--		Get list of clients
		IF (@opCode = 1)
		BEGIN
			IF (@silentMode = 0)
			BEGIN
				SELECT
					@opCode AS opCode, c.id, c.name, cp.attrName, cp.attrVal, s.keyName, CAST(s.value AS NVARCHAR(32)) keyValue
				FROM APP_Client c WITH(NOLOCK)
					INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName = 'CCS Enabled'
						AND cp.modified = 0
					INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
						s.entityId = cp.componentNameId
						AND s.entityType = 3
						AND s.keyName = N'sCCSDbStatus'
				WHERE
					(c.status & (2|4)) = 0	-- client is not uninstalled
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 2:
		--		CommServer CCS Enabled
		IF (@opCode = 2)
		BEGIN
			IF (@setOutValues IS NULL OR (@setOutValues IS NOT NULL AND @setOutValues = 0))
			BEGIN
				IF (@silentMode = 0)
				BEGIN
					SELECT
						@opCode AS opCode,
						CASE
							WHEN @value2 IS NULL THEN 'Current'
							ELSE @value2
						END AS state,
						p.id, p.name, p.value
					FROM GXGlobalParam p WITH(NOLOCK)
					WHERE
						name = 'CommServCCSEnabled'
				END
			END
			ELSE
			BEGIN
				DECLARE @gpId		INT
				DECLARE @gpName		NVARCHAR(128)
				DECLARE @gpValue	NVARCHAR(128)
				SELECT
					@gpId = p.id,
					@gpName = p.name,
					@gpValue = p.value
				FROM GXGlobalParam p WITH(NOLOCK)
				WHERE
					name = 'CommServCCSEnabled'
				SET @outValue1 = CAST(@gpValue AS INT)
				IF (@silentMode = 0)
				BEGIN
					SELECT
						@opCode AS opCode,
						CASE
							WHEN @value2 IS NULL THEN 'Current'
							ELSE @value2
						END AS state,
						@gpId AS id,
						@gpName AS name,
						@gpValue AS value
				END
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 3:
		--		Get all CCS Trigger Status
		IF (@opCode = 3)
		BEGIN
			IF (@silentMode = 0)
			BEGIN
				SELECT
					@opCode AS opCode, name, is_disabled
				FROM sys.triggers WITH(NOLOCK)
				WHERE
					name LIKE 'APP_CCS%TableChange'
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 5:
		--		Delete Client CCS Work Queue operations
		IF (@opCode = 5)
		BEGIN
			IF (@clientId IS NULL)
			BEGIN
				SET @errorMessage = @clientErrorMsg
				SET @exitCode = 1
				GOTO END_OF_PROC
			END
			DELETE FROM APP_WorkQueueRequest
			WHERE
				workToken IN (@wkToken19, @wkToken49)
				AND clientId = @clientId
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 6/7:
		--		Change CS CCS Enabled Property
		IF (@opCode IN (6,7))
		BEGIN
			DECLARE @csOutValue INT = NULL
			DECLARE @csEnabled INT = 0
			SELECT @csEnabled = 1 WHERE @opCode = 7
			EXEC @rc = APPCCSControls @opCode=2, @value2='Current', @setOutValues=1, @outValue1=@csOutValue OUTPUT, @silentMode=@silentMode
			IF (@rc <> 0)
			BEGIN
				SET @errorMessage = 'SP Failure: APPCCSControls opCode=2'
				SET @exitCode = @rc
				GOTO END_OF_PROC
			END
			IF (@csEnabled <> @csOutValue OR @force > 0)
			BEGIN
				UPDATE GXGlobalParam
					SET value = CAST(@csEnabled AS VARCHAR(12))
				WHERE
					name = 'CommServCCSEnabled'
				EXEC @rc = APPCCSControls @opCode=2, @value2='New', @silentMode=@silentMode
				IF (@rc <> 0)
				BEGIN
					SET @errorMessage = 'SP Failure: APPCCSControls opCode=2'
					SET @exitCode = @rc
					GOTO END_OF_PROC
				END
				-- Toggle the CCS Triggers to match CS CCS Functionality
				IF (@@TRANCOUNT = 0)
				BEGIN
					-- Only change trigger status if NO Transaction started!
					-- This can cause massive blocking changes and deadlocks
					DECLARE @triggerOpCode INT = 1001
					SELECT @triggerOpCode = 1002 WHERE @opCode = 7
					EXEC @rc = APPCCSControls @opCode=@triggerOpCode, @silentMode=@silentMode
					IF (@rc <> 0)
					BEGIN
						SET @errorMessage = 'SP Failure: APPCCSControls opCode=' + CAST(@triggerOpCode AS VARCHAR(12))
						SET @exitCode = @rc
						GOTO END_OF_PROC
					END
				END
				-- match current to new setting
				IF ((@isCSCCSEnabled = 0 AND @csEnabled = 1) OR (@isCSCCSEnabled = 1 AND @csEnabled = 0) OR @force > 0)
				BEGIN
					IF (@csEnabled = 1) SET @csEnabled += 1		-- goto LOAD state instead, need to re-load the CCSDbs on the clients
					EXEC @rc = APPCCSControls @opCode=2000, @value1=@csEnabled, @silentMode=@silentMode
					IF (@rc <> 0)
					BEGIN
						SET @errorMessage = 'SP Failure: APPCCSControls opCode=2000'
						SET @exitCode = @rc
						GOTO END_OF_PROC
					END
				END
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 8:
		--		Get Client CCS Enabled property
		IF (@opCode = 8)
		BEGIN
			IF (@clientId IS NULL)
			BEGIN
				SET @errorMessage = @clientErrorMsg
				SET @exitCode = 1
				GOTO END_OF_PROC
			END
			IF (@setOutValues IS NULL OR (@setOutValues IS NOT NULL AND @setOutValues = 0))
			BEGIN
				IF (@silentMode = 0)
				BEGIN
					SELECT
						@opCode AS opCode,
						CASE
							WHEN @value2 IS NULL THEN 'Current'
							ELSE @value2
						END AS state,
						c.id, c.name, cp.attrName, cp.attrVal, s.keyName, CAST(s.value AS NVARCHAR(32)) keyValue
					FROM APP_Client c WITH(NOLOCK)
						INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
							cp.componentNameId = c.id
							AND cp.attrName = N'CCS Enabled'
						INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
							s.entityId = cp.componentNameId
							AND s.entityType = 3
							AND s.keyName = N'sCCSDbStatus'
					WHERE
						c.id = @clientID
						AND (c.status & (2|4)) = 0
				END
			END
			ELSE
			BEGIN
				DECLARE @cId		INT = NULL
				DECLARE @cName		NVARCHAR(256)
				DECLARE @cpName		NVARCHAR(128)
				DECLARE @cpValue	NVARCHAR(128)
				DECLARE @asName		NVARCHAR(128)
				DECLARE @asValue	NVARCHAR(32)
				SELECT
					@cId = c.id,
					@cName = c.name,
					@cpName = cp.attrName,
					@cpValue = cp.attrVal,
					@asName = s.keyName,
					@asValue = CAST(s.value AS NVARCHAR(32))
				FROM APP_Client c WITH(NOLOCK)
					INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName = N'CCS Enabled'
					INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
						s.entityId = cp.componentNameId
						AND s.entityType = 3
						AND s.keyName = N'sCCSDbStatus'
				WHERE
					c.id = @clientID
					AND (c.status & (2|4)) = 0
				IF (@cId IS NULL)
				BEGIN
					SET @errorMessage = 'Client ''CCS Enabled'' Property not found for @clientId=' + CAST(@clientId AS VARCHAR(12)) + '!'
					SET @exitCode = 1
					GOTO END_OF_PROC
				END
				SET @outValue1 = CAST(@cpValue AS INT)
				IF (@silentMode = 0)
				BEGIN
					SELECT
						@opCode AS opCode,
						CASE
							WHEN @value2 IS NULL THEN 'Current'
							ELSE @value2
						END AS state,
						@cId AS id,
						@cName AS name,
						@cpName AS attrName,
						@cpValue AS attrVal,
						@asName AS keyName,
						@asValue AS keyValue
				END
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 9/10:
		--		Change Client CCS Enabled Property
		IF (@opCode IN (9,10))
		BEGIN
			IF (@clientId IS NULL)
			BEGIN
				SET @errorMessage = @clientErrorMsg
				SET @exitCode = 1
				GOTO END_OF_PROC
			END
			IF NOT EXISTS (SELECT 1 FROM dbo.IsCCSSoftwareUsageValidForClient(@clientId))
			BEGIN
				SET @errorMessage = @clientInvalidCfgErrorMsg
				SET @exitCode = 1
				GOTO END_OF_PROC
			END
			SET @cpOutValue = NULL
			EXEC @rc = APPCCSControls @opCode=8, @clientId=@clientId, @value2='Current', @setOutValues=1, @outValue1=@cpOutValue OUTPUT, @silentMode=@silentMode
			IF (@rc <> 0)
			BEGIN
				SET @errorMessage = 'SP Failure: Current APPCCSControls opCode=8'
				SET @exitCode = @rc
				GOTO END_OF_PROC
			END
			DECLARE @ccsEnabled INT = 0
			SELECT @ccsEnabled = 1 WHERE @opCode = 10
			IF (@cpOutValue <> @ccsEnabled OR @force > 0)
			BEGIN
				UPDATE cp
					SET cp.attrVal = CAST(@ccsEnabled AS NVARCHAR(12)),
						cp.created = @nowTime
				FROM APP_Client c
					INNER JOIN APP_ClientProp cp ON
						cp.componentNameId = c.id
						AND cp.attrName = N'CCS Enabled'
						AND cp.modified = 0
				WHERE
					c.id = @clientID
					AND (c.status & (2|4)) = 0	-- client not uninstalled or deleted
					AND (c.status & 4096) > 0	-- Laptop Configured
				EXEC @rc = APPCCSControls @opCode=8, @clientId=@clientId, @value2='New', @silentMode=@silentMode
				IF (@rc <> 0)
				BEGIN
					SET @errorMessage = 'SP Failure: New APPCCSControls opCode=8'
					SET @exitCode = @rc
					GOTO END_OF_PROC
				END
				IF (@value1 IS NULL)
				BEGIN
					SELECT @ccsEnabled = 2 WHERE @opCode = 10	-- Set LOAD state to force a reload of the CCS Database
					EXEC @rc = APPCCSControls @opCode=1000, @clientId=@clientId, @value1=@ccsEnabled, @silentMode=@silentMode
					IF (@rc <> 0)
					BEGIN
						SET @errorMessage = 'SP Failure: APPCCSControls opCode=1000'
						SET @exitCode = @rc
						GOTO END_OF_PROC
					END
				END
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 11:
		--		Set client CCS Db Status to LOAD
		IF (@opCode = 11)
		BEGIN
			IF (@clientId IS NULL)
			BEGIN
				SET @errorMessage = @clientErrorMsg
				SET @exitCode = 1
				GOTO END_OF_PROC
			END
			IF NOT EXISTS (SELECT 1 FROM dbo.IsCCSSoftwareUsageValidForClient(@clientId))
			BEGIN
				SET @errorMessage = @clientInvalidCfgErrorMsg
				SET @exitCode = 1
				GOTO END_OF_PROC
			END
			EXEC @rc = APPCCSControls @opCode=10, @clientId=@clientId, @value1=2, @silentMode=@silentMode
			IF (@rc <> 0)
			BEGIN
				SET @errorMessage = 'SP Failure: APPCCSControls opCode=10'
				SET @exitCode = @rc
				GOTO END_OF_PROC
			END
			EXEC @rc = APPCCSControls @opCode=1000, @clientId=@clientId, @value1=2, @silentMode=@silentMode
			IF (@rc <> 0)
			BEGIN
				SET @errorMessage = 'SP Failure: APPCCSControls opCode=1000'
				SET @exitCode = @rc
				GOTO END_OF_PROC
			END
			IF (@silentMode = 0)
			BEGIN
				SELECT
					@opCode AS opCode,
					'Must update APP_AdvanceSettings and change sCCSDbStatus from LOAD to ONLINE after WorkQueueRequest processed by client, if client does not.'
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 12:
		--		Check for problem CCS Clients in WorkQueue
		IF (@opCode = 12)
		BEGIN
			IF (@silentMode = 0)
			BEGIN
				SELECT
					wq.workToken,
					wq.clientId,
					c.name clientName,
					COUNT(wq.clientId) wqRequestCount,
					SUM(wq.retryCount) totalRetryCount
				FROM
					APP_WorkQueueRequest wq WITH(NOLOCK)
					INNER JOIN APP_Client c WITH(NOLOCK) ON
						c.id = wq.clientId
				WHERE
					wq.workToken IN (@wkToken19, @wkToken49)
					AND wq.retryCount >= 5
				GROUP BY
					wq.workToken,
					wq.clientId,
					c.name
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 15:
		--		Get list of CCS clients for given clientGroupId
		IF (@opCode = 15)
		BEGIN
			IF (@clientGroupId IS NULL)
			BEGIN
				IF (@silentMode = 0)
				BEGIN
					SELECT
						@opCode AS opCode, cg.id clientGroupId, cg.name clientGroupName, c.id clientId, c.name clientName, cp.attrName, cp.attrVal, s.keyName, CAST(s.value AS NVARCHAR(32)) keyValue
					FROM APP_Client c WITH(NOLOCK)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientId = c.id
						INNER JOIN APP_ClientGroup cg WITH(NOLOCK) ON
							cg.id = cga.clientGroupId
						INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
							cp.componentNameId = c.id
							AND cp.attrName = 'CCS Enabled'
							AND cp.modified = 0
						INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
							s.entityId = cp.componentNameId
							AND s.entityType = 3
							AND s.keyName = N'sCCSDbStatus'
					WHERE
						(c.status & (2|4)) = 0	-- client is not uninstalled
				END
			END
			ELSE
			BEGIN
				IF (@silentMode = 0)
				BEGIN
					SELECT
						@opCode AS opCode, cg.id clientGroupId, cg.name clientGroupName, c.id clientId, c.name clientName, cp.attrName, cp.attrVal, s.keyName, CAST(s.value AS NVARCHAR(32)) keyValue
					FROM APP_Client c WITH(NOLOCK)
						INNER JOIN APP_ClientGroupAssoc cga WITH(NOLOCK) ON
							cga.clientGroupId = @clientGroupId
							AND cga.clientId = c.id
						INNER JOIN APP_ClientGroup cg WITH(NOLOCK) ON
							cg.id = cga.clientGroupId
						INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
							cp.componentNameId = c.id
							AND cp.attrName = 'CCS Enabled'
							AND cp.modified = 0
						INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
							s.entityId = cp.componentNameId
							AND s.entityType = 3
							AND s.keyName = N'sCCSDbStatus'
					WHERE
						(c.status & (2|4)) = 0	-- client is not uninstalled
				END
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Internal OpCodes
		--================================================================
		--================================================================
		-- Operation 1000:
		--		Set sCCSDbRegistry Key
		IF (@opCode = 1000)
		BEGIN
			IF (@clientId IS NULL)
			BEGIN
				SET @errorMessage = @clientErrorMsg
				SET @exitCode = 1
				GOTO END_OF_PROC
			END
			IF (@value1 IS NULL)
			BEGIN
				SET @errorMessage = 'Internal Error: @value1 is NULL, required input.'
				SET @exitCode = 1
				GOTO END_OF_PROC
			END
			SET @ccsDbStatus = 'DISABLED'
			SELECT @ccsDbStatus = 'ONLINE' WHERE @value1 = 1
			SELECT @ccsDbStatus = 'LOAD' WHERE @value1 = 2
			IF (@ccsDbStatus <> 'DISABLED')
			BEGIN
				-- only check valid configurations for ONLINE and LOAD settings.  Let DISABLED go thru to update the client, could be an invalid configuration.
				IF NOT EXISTS (SELECT 1 FROM dbo.IsCCSSoftwareUsageValidForClient(@clientId))
				BEGIN
					SET @errorMessage = @clientInvalidCfgErrorMsg
					SET @exitCode = 1
					GOTO END_OF_PROC
				END
			END
			-- Does key currently exist?
			DECLARE @asId INT = NULL
			SELECT
				@asId = s.id
			FROM APP_AdvanceSettings s
			WHERE
				s.entityType = 3
				AND s.entityId = @clientId
				AND s.keyName = 'sCCSDbStatus'
				AND s.relativePath = N'iDataAgent'
			-- NOTE:	If client is being set to OFFLINE may need to delete all Client Token 19 in the WorkQueueRequest Table
			--			to keep from turning Db backup ONLINE automatically???
			-- Insert / Update Advance Settings for sCCSDbStatus registry key
			IF (@asId IS NULL)
			BEGIN
				INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
					VALUES(@clientId, N'sCCSDbStatus', N'STRING', N'iDataAgent', @ccsDbStatus, 1, 0, 3, 0, 0)
				SELECT @asId = SCOPE_IDENTITY()
				INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)
					VALUES (@asId, N'', 1)
			END
			ELSE
			BEGIN
				UPDATE APP_AdvanceSettings
					SET [value] = @ccsDbStatus,
						[enabled] = 1,
						[deleted] = 0
				WHERE
					entityType = 3
					AND entityId = @clientId
					AND keyName = N'sCCSDbStatus'
					AND relativePath = N'iDataAgent'
					AND (	-- avoid unnecessary updates
						CAST(value AS NVARCHAR(MAX)) <> @ccsDbStatus
						OR enabled <> 1
						OR deleted <> 0
					)
			END
			DECLARE @wqId BIGINT = NULL
			-- Create WorkQueue request to udpate sCCSDbStatus key on client
			INSERT INTO APP_WorkQueueRequest([clientId],[remoteClient],[workToken],[workTokenParams],[createTime],[lastUpdateTime],[retryCount],[flag])
			--	VALUES(@clientId, -1, 6, N'', @nowTime, 0, 0, 0)		-- old CCSDb Status operation
				VALUES(@clientId, -1, @wkToken49, @ccsDbStatus, @nowTime, 0, 0, 0)
			SELECT @wqId = SCOPE_IDENTITY()
			-- Display status rows
			IF (@silentMode = 0)
			BEGIN
				SELECT
					@opCode AS opCode,
					'APP_AdvanceSettings' AS tableUpdated,
					a.*
				FROM APP_AdvanceSettings a
				WHERE
					a.id = @asId
				SELECT
					@opCode AS opCode,
					'APP_WorkQueueRequest' AS tableUpdated,
					wq.*
				FROM APP_WorkQueueRequest wq
				WHERE
					wq.workQueueId = @wqId
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 1001 / 1002:
		--		Change CS CCS Triggers
		IF (@opCode IN (1001,1002))
		BEGIN
			DECLARE @triggerVal INT = 0
			SELECT @triggerVal = 1 WHERE @opCode = 1002
			IF (@@TRANCOUNT > 0)
			BEGIN
				-- Triggers should NOT be enabled / disabled under transaction control
				IF (@silentMode = 0)
				BEGIN
					SELECT 0 AS opCode, 'Manually Invoked (Under NO Transactions): EXEC AppCCSTriggerCtrl ' + CAST(@triggerVal AS VARCHAR(12)) AS triggerCommand
				END
			END
			ELSE
			BEGIN
				EXEC @exitCode = AppCCSTriggerCtrl @triggerVal
				IF (@silentMode = 0)
				BEGIN
					SELECT @opCode AS opCode, 'SP Invoked: AppCCSTriggerCtrl ' + CAST(@triggerVal AS VARCHAR(12)) AS triggerStatus
				END
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 2000:
		--	Set sCCSDbRegistry Key for all clients currently enabled for CCS, CS Functionality has toggled
		IF (@opCode = 2000)
		BEGIN
			SET @ccsDbStatus = 'DISABLED'
			SELECT @ccsDbStatus = 'ONLINE' WHERE @value1 = 1
			SELECT @ccsDbStatus = 'LOAD' WHERE @value1 = 2
			-- Client all clients with CCS Enabled (1)
			CREATE TABLE #CCSClients (
				clientId		INT
			)
			INSERT INTO #CCSClients(clientId)
				SELECT
					c.id
				FROM APP_Client c WITH(NOLOCK)
					INNER JOIN APP_ClientProp cp WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName = 'CCS Enabled'
						AND cp.attrVal = '1'
				WHERE
					(c.status & (2|4)) = 0
			-- Update registry key rows if found
			UPDATE rk
				SET rk.value = @ccsDbStatus,
					rk.enabled = 1,
					rk.deleted = 0
			FROM APP_AdvanceSettings rk
				INNER JOIN #CCSClients c ON
					rk.entityType = 3
					AND rk.entityId = c.clientId
			WHERE
				rk.keyName = N'sCCSDbStatus'
				AND rk.relativePath = N'iDataAgent'
			-- Insert registry key rows if not found
			IF OBJECT_ID('tempdb.dbo.#asRows') IS NOT NULL
				DROP TABLE #asRows
			CREATE TABLE #asRows (
				asId	INT PRIMARY KEY
			)
			INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
				OUTPUT INSERTED.id
					INTO #asRows (asId)
				SELECT c.clientId, N'sCCSDbStatus', N'STRING', N'iDataAgent', @ccsDbStatus, 1, 0, 3, 0, 0
				FROM APP_AdvanceSettings rk
					RIGHT OUTER JOIN #CCSClients c ON
						rk.entityType = 3
						AND rk.entityId = c.clientId
						AND rk.keyName = N'sCCSDbStatus'
						AND rk.relativePath = N'iDataAgent'
				WHERE
					rk.entityId IS NULL			-- row not found
			-- Hide sCCSDbStatus keyname rows
			INSERT INTO APP_AdvanceSettingsEx (keyId, details, hidden)
				SELECT
					a.asId,
					N'',
					1
				FROM #asRows a
			-- Create WorkQueue request to udpate sCCSDbStatus key on clients
			INSERT INTO APP_WorkQueueRequest([clientId],[remoteClient],[workToken],[workTokenParams],[createTime],[lastUpdateTime],[retryCount],[flag])
				SELECT
					--c.clientId, -1, 6, N'', @nowTime, 0, 0, 0		-- old CCSDb Status change implementation
					c.clientId, -1, @wkToken49, @ccsDbStatus, @nowTime, 0, 0, 0
				FROM #CCSClients c
			IF (@silentMode = 0)
			BEGIN
				SELECT
					@opCode AS opCode,
					c.id AS clientId,
					c.name AS clientName,
					@ccsDbStatus AS ccsDbStatus
				FROM #CCSClients ccs
					INNER JOIN APP_Client c WITH(NOLOCK) ON
						ccs.clientId = c.id
			END
			GOTO END_OF_PROC
		END
		--================================================================
		-- Operation 10000:
		--
		IF (@opCode = 10000)
		BEGIN
			IF OBJECT_ID('tempdb.dbo.#CCSClientsWQ') IS NOT NULL
				DROP TABLE #CCSClientsWQ
			CREATE TABLE #CCSClientsWQ (
				workToken		INT,
				ccsEnabled		INT,
				clientId		INT PRIMARY KEY,
				clientName		NVARCHAR(255),
				totalRequest	INT,
				totalRetries	INT
			)
			-- get all clients with workqueue issues
			INSERT INTO #CCSClientsWQ
				SELECT
					wq.workToken,
					cp.attrVal ccsEnabled,
					wq.clientId,
					c.name,
					COUNT(wq.clientId) totalRequest,
					SUM(wq.retryCount) totalRetries
				FROM APP_Client c WITH(NOLOCK)
					INNER JOIN APP_ClientProp cp  WITH(NOLOCK) ON
						cp.componentNameId = c.id
						AND cp.attrName = 'CCS Enabled'
					LEFT OUTER JOIN APP_WorkQueueRequest wq WITH(NOLOCK)ON
						c.id = wq.clientId
						AND wq.workToken IN (@wkToken19, @wkToken49)
						AND wq.retryCount > 0
				WHERE
					wq.clientId IS NOT NULL
				GROUP BY
					wq.workToken,
					cp.attrVal,
					wq.clientId,
					c.name
			IF (@silentMode = 0)
			BEGIN
				SELECT * FROM #CCSClientsWQ
			END
			SELECT @rowCnt = COUNT(*) FROM #CCSClientsWQ
			IF (@rowCnt > 0)
			BEGIN
				-- disable enabled CCS Clients
				UPDATE cp
					SET cp.attrVal = '0',
						cp.created = @nowTime
				FROM #CCSClientsWQ c
					INNER JOIN APP_ClientProp cp ON
						cp.componentNameId = c.clientId
						AND cp.attrName = 'CCS Enabled'
						AND cp.modified = 0
						AND cp.attrVal = '1'
				-- insert new registry key to OFFLINE for clients
				INSERT INTO APP_AdvanceSettings([entityId],[keyName],[type],[relativePath],[value],[enabled],[deleted],[entityType],[sourceId],[sourceEntityType])
					SELECT
						c.clientId, N'sCCSDbStatus', N'STRING', N'iDataAgent', 'OFFLINE', 1, 0, 3, 0, 0
					FROM #CCSClientsWQ c
						LEFT OUTER JOIN APP_AdvanceSettings a WITH(NOLOCK) ON
							a.entityId = c.clientId
							AND a.entityType = 3
					WHERE
						a.entityId IS NULL
				-- update registry key to OFFLINE for existing client rows
				UPDATE a
					SET [value] = 'OFFLINE',
						[enabled] = 1,
						[deleted] = 0
				FROM #CCSClientsWQ c
					INNER JOIN APP_AdvanceSettings a ON
						a.entityId = c.clientId
						AND a.entityType = 3
				-- insert registry workqueue request for clients
				INSERT INTO APP_WorkQueueRequest([clientId],[remoteClient],[workToken],[workTokenParams],[createTime],[lastUpdateTime],[retryCount],[flag])
					SELECT
						--c.clientId, -1, 6, N'', @nowTime, 0, 0, 0		-- old CCSDb Status change implementation
						c.clientId, -1, @wkToken49, N'OFFLINE', @nowTime, 0, 0, 0
					FROM #CCSClientsWQ c
				-- delete clients retry rows from workqueue
				DELETE FROM wq
				FROM #CCSClientsWQ c
					INNER JOIN  APP_WorkQueueRequest wq ON
						c.clientId = wq.clientId
						AND wq.workToken IN (@wkToken19, @wkToken49)
						AND wq.retryCount > 0
			END
			GOTO END_OF_PROC
		END
		SET @errorMessage = 'Unsupported opCode=' + CAST(@opCode AS VARCHAR(12))
		SET @exitCode = 1
	END TRY
	BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
		SET @exitCode = 1
		SET @errorMessage = 'Catch Block: APPCCSControls @opCode=' + CAST(@opCode AS VARCHAR(12))
		IF (@clientId IS NOT NULL)
		BEGIN
			SET @errorMessage += ', @clientId=' + CAST(@clientId AS VARCHAR(12))
		END
	END CATCH
END_OF_PROC:
	IF (@exitCode > 0)
	BEGIN
		IF (@silentMode = 0)
		BEGIN
			SELECT
				@opCode AS opCode,
				@exitCode AS exitCode,
				@errorMessage AS errorMessage
		END
		--IF (@transStarted = 1)
		--BEGIN
		--	IF EXISTS(SELECT * FROM sys.dm_tran_active_transactions WHERE name = @transName)
		--	BEGIN
		--		-- activity to rollback
		--		ROLLBACK TRANSACTION @transName
		--		IF (@transLogging > 0) SELECT @opCode AS opCode, 'TRANS ROLLBACK', @transName
		--	END
		--	ELSE
		--	BEGIN
		--		-- no activity to commit but need to close started transaction, since rollback incurrs try catch block for no activity
		--		COMMIT TRANSACTION @transName
		--		IF (@transLogging > 0) SELECT @opCode AS opCode, 'TRANS COMMITTED NoActivity', @transName
		--	END
		--END
	END
	ELSE
	BEGIN
		IF (@silentMode = 0)
		BEGIN
			SELECT
				@opCode AS opCode,
				@exitCode AS exitCode,
				'Success' AS errorMessage
		END
		--IF (@transStarted = 1)
		--BEGIN
		--	COMMIT TRANSACTION @transName
		--	IF (@transLogging > 0) SELECT @opCode AS opCode, 'TRANS COMMITTED', @transName
		--END
	END
	-- Drop temp tables if they exist
	IF OBJECT_ID('tempdb.dbo.#CCSClients') IS NOT NULL
		DROP TABLE #CCSClients
	IF OBJECT_ID('tempdb.dbo.#CCSClientsWQ') IS NOT NULL
		DROP TABLE #CCSClientsWQ
	IF OBJECT_ID('tempdb.dbo.#CCSDisableAll') IS NOT NULL
		DROP TABLE #CCSDisableAll
	IF OBJECT_ID('tempdb.dbo.#CCSDEnableBlock') IS NOT NULL
		DROP TABLE #CCSDEnableBlock
	IF OBJECT_ID('tempdb.dbo.#CCSDEnableBlockAS') IS NOT NULL
		DROP TABLE #CCSDEnableBlockAS
	IF OBJECT_ID('tempdb.dbo.#CCSDEnableBlockWQ') IS NOT NULL
		DROP TABLE #CCSDEnableBlockWQ
	RETURN @exitCode
END

IF EXISTS (select * from GxQscripts where name = 'APPCCSControls')
	delete from GxQscripts where name = 'APPCCSControls'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSControls')
	delete from GXDBVersions where aliasname = 'APPCCSControls'
GO

insert into GXDBVersions values(2, 'APPCCSControls',  '00010005001200150000', 'APPCCSControls', '00010005001200150000')
GO

