

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPCCSClientFailedSyncCheck.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPCCSClientFailedSyncCheck.sp,v $ $Id: APPCCSClientFailedSyncCheck.sp,v 1.1.2.4 2020/06/28 18:53:21 abilbrey Exp $";
-- Procedure Name
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPCCSClientFailedSyncCheck')
BEGIN
	print '>>> Drop Stored Procedure: APPCCSClientFailedSyncCheck <<<'
	drop procedure APPCCSClientFailedSyncCheck
END
IF EXISTS (select * from GxQscripts where name='APPCCSClientFailedSyncCheck')
	delete from GxQscripts where name = 'APPCCSClientFailedSyncCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSClientFailedSyncCheck')
	delete from GXDBVersions where aliasname = 'APPCCSClientFailedSyncCheck'
GO
print '... Creating Procedure: APPCCSClientFailedSyncCheck'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPCCSClientFailedSyncCheck
-- Input arguments
  @startTime INT
AS
-- Following are the "columns" returned, in the order in which they are declared
  DECLARE @o_reloadedClients int = 0
  DECLARE @o_reloadXml nvarchar(max) = N''
BEGIN
	SET NOCOUNT ON
	SET @o_reloadedClients = 0
	IF EXISTS (
		SELECT 1
		FROM GXGlobalParam gp WITH(NOLOCK)
		WHERE
			name = N'CommServCCSEnabled'
			AND value = N'1'		-- CCS is enabled on the CS
	)
	BEGIN
		--=============================================================================================
		-- Note1: This SP does most of it work up front computing what needs to be updated and storing
		-- it in temp tables and when this work is done it proceeds to perform all the database table
		-- update operations at the bottomm of the SP so they are grouped together.  This avoids
		-- any session blocking during the time computing what needs to be updated.
		--
		-- Note2: This SP normally should not be called with a started transaction from the
		-- application code.
		--=============================================================================================
		DECLARE @rcnt INT = 0
		IF (@startTime = 0)
		BEGIN
			-- set to current time
			SET @startTime = dbo.GetUnixTime(GETUTCDATE()) - 2		-- move back 2 second so that transaction activity does not allow mid-second updates to slip thru filtering
		END
		-- Prune Deconfigured clients from the APP_CCSTableHashes
		IF object_id('tempdb.dbo.#DeconfigCCSClients') IS NOT NULL
			DROP TABLE #DeconfigCCSClients
		CREATE TABLE #DeconfigCCSClients (
			clientId		INT PRIMARY KEY
		)
		-- Create list of deleted clients
		INSERT INTO #DeconfigCCSClients (clientId)
			SELECT
				h.clientId
			FROM (
					SELECT DISTINCT
						h.clientId
					FROM APP_CCSTableHashes h WITH(NOLOCK)
				) h
				LEFT OUTER JOIN APP_Client c WITH(NOLOCK) ON
					h.clientId = c.id
			WHERE
				c.id IS NULL	-- client deleted
		--== APP_CCSTableHashes Op2:
		-- Determine if there are any hash mismatches and the clients need to be reloaded
		IF OBJECT_ID('tempdb.dbo.#clientReload') IS NOT NULL
			DROP TABLE #clientReload
		CREATE TABLE #clientReload (
			clientId		INT PRIMARY KEY,
			reloadXML		XML DEFAULT NULL,		-- <CCSClientReload lastAttemptTime='<UNIX Time>' numberOfAttempts='<number of attempts>' />
			reload			INT DEFAULT 0,
			attempted		INT DEFAULT 0,
			disabled		TINYINT DEFAULT 0
		)
		IF OBJECT_ID('tempdb.dbo.#HashUpdates') IS NOT NULL
			DROP TABLE #HashUpdates
		CREATE TABLE #HashUpdates (
			clientId		INT,
			tableType		INT,
			chunk			INT,
			PRIMARY KEY (clientId, tableType, chunk)
		)
		IF object_id('tempdb.dbo.#ClientAttempts') IS NOT NULL
			DROP TABLE #ClientAttempts
		CREATE TABLE #ClientAttempts (
			clientId		INT PRIMARY KEY,
			reloadXML		XML
		)
		INSERT INTO #clientReload (clientId)
			SELECT
				h.clientId
			FROM APP_CCSTableHashes h WITH(NOLOCK)
			WHERE
				(
					h.attempts > 2					-- give mimimal of 3 attempts to resync in 2 minutes
					AND h.csTime < @startTime				-- want last sync times less then current time
					AND (@startTime - h.csTime) > 120		-- give up to 120 seconds to resync (at least 3 executions of Work Queue to attempt resync)
				) OR (
					h.attempts > 0					-- failed sync that is over 5 minutes old and appears will not be resolved
					AND h.csTime < @startTime				-- want last sync times less then current time
					AND (@startTime - h.csTime) > 300		-- 300 seconds
				)
			GROUP BY
				h.clientId
			EXCEPT
			SELECT	-- remove clients that have been disabled already
				cp.componentNameId
			FROM APP_ClientProp cp WITH(NOLOCK)
			WHERE
				cp.attrName = N'CCS Enabled'
				AND cp.modified = 0
				AND cp.attrVal = N'0'		-- disabled
		SET @rcnt = @@ROWCOUNT
		IF (@rcnt > 0)
		BEGIN
			-- Found CCS Clients where MD5 Hash is NOT matching - force CCSDb Reload for these clients
			-- Identify CCS Clients for Reload
			UPDATE cr
				SET reload = 1
			FROM #clientReload cr
				INNER JOIN (
					SELECT
						cr.clientId
					FROM APP_ClientProp cp WITH(NOLOCK)
						INNER JOIN #clientReload cr ON
							cr.clientId = cp.componentNameId
						INNER JOIN APP_AdvanceSettings s WITH(NOLOCK) ON
							s.entityId = cp.componentNameId
							AND s.entityType = 3		-- Client Type
							AND s.keyName = N'sCCSDbStatus'
						LEFT OUTER JOIN APP_WorkQueueRequest wqr WITH(NOLOCK) ON
							wqr.clientId = cp.componentNameId
							AND wqr.workToken = 49		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
					WHERE
						cp.attrName = N'CCS Enabled'
						AND cp.modified = 0
						AND cp.attrVal = N'1'
						AND CAST(s.value AS NVARCHAR(MAX)) = N'ONLINE'
						AND (
							wqr.clientId IS NULL
							OR wqr.workTokenParams NOT IN (N'LOAD', N'DISABLED', '')		-- If set nothing to insert.  If '' means an actual LOAD_REQUEST is inprogress on the client
						)
				) q ON
					q.clientId = cr.clientId
			-- Hash rows that need to be updated to -10, identify rows for later update operations below
			INSERT INTO #HashUpdates (clientId, tableType, chunk)
				SELECT
					h.clientId,
					h.tableType,
					h.chunk
				FROM APP_CCSTableHashes h WITH(NOLOCK)
					INNER JOIN #clientReload cr ON
						cr.clientId = h.clientId
						AND cr.reload = 1
				WHERE
					(
						h.attempts > 2							-- give mimimal of 3 attempts to resync in 2 minutes
						AND h.csTime < @startTime				-- want last sync times less then current time
						AND (@startTime - h.csTime) > 120		-- give up to 120 seconds to resync (at least 3 executions of Work Queue to attempt resync)
					) OR (
						h.attempts > 0							-- failed sync that is over 5 minutes old and appears will not be resolved
						AND h.csTime < @startTime				-- want last sync times less then current time
						AND (@startTime - h.csTime) > 300		-- 300 seconds
					)
			--== APP_CCSTableHashes Op1:
			-- Determine client reload attempts and if exceeded max attempts than disabled the client
			DECLARE @maxAttemptsAllowed		INT = 5		-- default 5 attempts to sync
			SELECT
				@maxAttemptsAllowed = gp.value
			FROM GXGlobalParam gp WITH(NOLOCK)
			WHERE
				name = N'CCS Max Reload Attempts'
			UPDATE cr
				SET reloadXML = CAST(attempts.attrVal AS XML)
			FROM #clientReload cr
				LEFT OUTER JOIN APP_ClientProp attempts WITH(NOLOCK) ON
					attempts.attrName = N'CCS Reload Attempts'
					AND attempts.modified = 0
					AND attempts.componentNameId = cr.clientId
			WHERE
				attempts.id IS NOT NULL		-- row exists, not found rows set to 0 values expected
			-- Parse Reload XML
			UPDATE cr
				SET attempted = r.value('@numberOfAttempts', 'INT'),
					disabled = CASE
									WHEN  r.value('@numberOfAttempts', 'INT') >= @maxAttemptsAllowed THEN 1		-- if exceeded, disabled next attempted reload operation
									ELSE 0
								END
			FROM #clientReload cr
				CROSS APPLY cr.reloadXML.nodes('/CCSClientReload') d(r)
			-- Database Operations below for the above computed operations that require data to be updated
			--== APP_ClientProp Op1-3:
			--== APP_AdvanceSettings Op1:
			--== APP_WorkQueueRequest Op1-2:
			-- Return list as XML for log message
			SET @o_reloadXml = CAST((
				SELECT
					cr.clientId '@id',
					CASE
						WHEN cr.disabled = 1 THEN cr.attempted
						ELSE cr.attempted + 1
					END '@attempts',
					cr.disabled '@disabled'
				FROM #clientReload cr
				WHERE
					cr.reload = 1
				FOR XML PATH('client'), ROOT('CCSLaptopReload')
			) AS NVARCHAR(MAX))
		END
		-- Determine if any clients needs attempted counts reset to 0 if no outstanding hash mismatches.
		SET @rcnt = 0
		INSERT INTO #ClientAttempts (clientId, reloadXML)
			SELECT DISTINCT
				cp.componentNameId,
				cp.attrVal
				--CAST(cp.attrVal AS XML)
			FROM APP_ClientProp cp WITH(NOLOCK)
				INNER JOIN APP_CCSTableHashes h WITH(NOLOCK) ON
					h.clientId = cp.componentNameId
					AND cp.modified = 0
					AND cp.attrName = N'CCS Reload Attempts'
					AND h.matched = 1		-- there are matched rows in the table
				LEFT OUTER JOIN APP_CCSTableHashes h2 WITH(NOLOCK) ON
					h2.clientId = cp.componentNameId
					AND h2.matched = 0		-- there are mismatched rows in the table
				LEFT OUTER JOIN #clientReload cr ON
					cr.clientId = cp.componentNameId
			WHERE
				h2.clientId IS NULL					-- no mismatched hashes
				AND cr.clientId IS NULL				-- Ignore current processed CCS Clients
				AND CAST(cp.attrVal AS XML).exist('/CCSClientReload[@numberOfAttempts="0"]') = 0	-- only process rows were previous reload attempts made
		SET @rcnt = @@ROWCOUNT
		IF (@rcnt > 0)
		BEGIN
			-- Delete rows that have NOT been stable for 24 hours yet after a reload
			DECLARE @t24Hours INT = (24 * 60 * 60)	-- hours in seconds -- should this be a tunable?
			DELETE ca
			FROM #ClientAttempts ca
				CROSS APPLY reloadXML.nodes('/CCSClientReload') t(d)
			WHERE (d.value('@lastAttemptTime', 'INT') + @t24Hours) > @startTime
			--== APP_ClientProp Op4:
		END
		--=============================================================================================
		-- START: Database Update Operations
		--
		--	Updating tables in an ordered fashion to avoid deadlocks and complete all update operations
		--	quickly to avoid any long blocking taking place.
		--=============================================================================================
		DECLARE @TranCnt INT = @@TRANCOUNT
		BEGIN TRY
			IF (@TranCnt = 0)
			BEGIN
				-- Start local transaction
				BEGIN TRANSACTION
			END
			--== APP_CCSTableHashes Op1:
			IF EXISTS (SELECT 1 FROM #HashUpdates)
			BEGIN
				-- Update attempts -10 for clients being reloaded so that they will not be processed again in a few minutes
				UPDATE h
					SET attempts = -10		-- client being reloaded due to this table hash not matching
				FROM APP_CCSTableHashes h
					INNER JOIN #HashUpdates hu ON
						hu.clientId = h.clientId
						AND hu.tableType = h.tableType
						AND hu.chunk = h.chunk
			END
			--== APP_AdvanceSettings Op1:
			IF EXISTS (SELECT 1 FROM #clientReload WHERE disabled = 1)
			BEGIN
				-- Update APP_AdvanceSettings for these disabled clients
				UPDATE adv
					SET value = N'DISABLED',
						enabled = 1,
						deleted = 0
				FROM APP_AdvanceSettings adv
					INNER JOIN #clientReload cr ON
						adv.entityType = 3		-- CLIENT
						AND adv.entityId = cr.clientId
						AND adv.keyName = N'sCCSDbStatus'
						AND adv.relativePath = N'iDataAgent'
						AND (	-- avoid unnecessary updates
							CAST(adv.value AS NVARCHAR(MAX)) <> N'DISABLED'
							OR adv.enabled <> 1
							OR adv.deleted <> 0
						)
				WHERE
					cr.disabled = 1
			END
			--== APP_ClientProp Op1-2:
			IF EXISTS (SELECT 1 FROM #clientReload WHERE disabled = 0 AND reload = 1)
			BEGIN
				-- update / insert attempt counts and reload time for clients needing to be reloaded
				UPDATE cp
					SET attrVal = CAST((
							SELECT
								@startTime '@lastAttemptTime',
								(cr.attempted + 1) '@numberOfAttempts'
							FOR XML PATH('CCSClientReload'), TYPE
						) AS NVARCHAR(MAX))
				FROM APP_ClientProp cp
					INNER JOIN #clientReload cr ON
						cr.clientId = cp.componentNameId
						AND cp.modified = 0
						AND cp.attrName = N'CCS Reload Attempts'
				WHERE
					cr.disabled = 0
					AND cr.reload = 1
				INSERT INTO APP_ClientProp (componentNameId, attrName, attrType, attrVal, created, modified, ccpId)
					SELECT
						cr.clientId,
						N'CCS Reload Attempts',
						2,
						CAST((
							SELECT
								@startTime '@lastAttemptTime',
								(cr.attempted + 1) '@numberOfAttempts'
							FOR XML PATH('CCSClientReload'), TYPE
						) AS NVARCHAR(MAX)),
						@startTime,
						0,
						0
					FROM #clientReload cr
						LEFT JOIN APP_ClientProp cp WITH(NOLOCK) ON
							cr.clientId = cp.componentNameId
							AND cp.modified = 0
							AND cp.attrName = N'CCS Reload Attempts'
					WHERE
						cp.id IS NULL		-- only insert where rows do not exist
						AND cr.reload = 1
			END
			--== APP_ClientProp Op3:
			IF EXISTS (SELECT 1 FROM #clientReload WHERE disabled = 1)
			BEGIN
				-- Disable CCS Laptop operation on clients marked to disable
				UPDATE cp
					SET attrVal = N'0'
				FROM APP_ClientProp cp
					INNER JOIN #clientReload cr ON
						cr.clientId = cp.componentNameId
						AND cp.modified = 0
						AND cp.attrName = N'CCS Enabled'
				WHERE
					cr.disabled = 1
			END
			--== APP_WorkQueueRequest Op1:
			IF EXISTS (SELECT 1 FROM #clientReload)
			BEGIN
				-- Delete outstanding Token 19 rows for clients being reloaded or disabled, no use pushing this data to clients
				DELETE wqr
				FROM APP_WorkQueueRequest wqr
					INNER JOIN #clientReload cr ON
						wqr.clientId = cr.clientId
						AND wqr.workToken = 19		-- WORK_TOKEN_CCS_DB_UPDATE
						AND (
							cr.reload = 1
							OR cr.disabled = 1
						)
				-- Insert Work Queue Request for CCS Laptops identified for Reload
				INSERT INTO APP_WorkQueueRequest(clientId, remoteClient, workToken, workTokenParams, createTime, lastUpdateTime, retryCount, flag)
					SELECT
						cr.clientId,
						-1 remoteClient,
						49 workToken,		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
						'LOAD' workTokenParams,				-- Attempt reload
						@startTime createTime,
						0 lastUpdateTime,
						0 retryCount,
						0 flag
					FROM #clientReload cr
					WHERE
						cr.reload = 1
						AND cr.disabled = 0		-- attempt reload
					UNION ALL
					SELECT
						cr.clientId,
						-1 remoteClient,
						49 workToken,		-- WORK_TOKEN_CCS_DB_CHANGE_STATE
						'RELOAD_DISABLED' workTokenParams,	-- Disabled CCS Operations on the client
						@startTime createTime,
						0 lastUpdateTime,
						0 retryCount,
						0 flag
					FROM #clientReload cr
					WHERE
						cr.disabled = 1
				SET @o_reloadedClients = @@ROWCOUNT
			END
			IF (@TranCnt = 0)
			BEGIN
				-- Commit local transaction
				COMMIT TRANSACTION
			END
		END TRY
		BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			IF (@TranCnt = 0)
			BEGIN
				ROLLBACK TRANSACTION
			END
			-- rethrow the exception to the application level
			;THROW;
		END CATCH
		DECLARE @TranCnt2 INT = @@TRANCOUNT
		BEGIN TRY
			-- This is in a separate transaction block since it is a cleanup operation and has no
			-- impact on CCS RELOAD or DISABLE Operations above and can be done in the next pass.
			IF (@TranCnt2 = 0)
			BEGIN
				-- Start local transaction
				BEGIN TRANSACTION
			END
			ELSE
			BEGIN
				SAVE TRANSACTION CCSSyncCheck
			END
			--== APP_CCSTableHashes Op2:
			IF EXISTS (SELECT 1 FROM #DeconfigCCSClients)
			BEGIN
				-- Cleanup APP_CCSTableHashes table for deconfigured clients
				DELETE h
				FROM APP_CCSTableHashes h
					INNER JOIN #DeconfigCCSClients d ON
						d.clientId = h.clientId
			END
			--== APP_ClientProp Op4:
			IF EXISTS (SELECT 1 FROM #ClientAttempts)
			BEGIN
				-- Reset CCS Laptops that are stable now after 24 hours
				UPDATE cp
					SET attrVal = CAST((
							SELECT
								d.value('@lastAttemptTime', 'INT') '@lastAttemptTime',		-- keep the last time reloaded
								0 '@numberOfAttempts'
							FOR XML PATH('CCSClientReload'), TYPE
						) AS NVARCHAR(MAX))
				FROM APP_ClientProp cp
					INNER JOIN #ClientAttempts ca ON
						ca.clientId = cp.componentNameId
						AND cp.modified = 0
						AND cp.attrName = N'CCS Reload Attempts'
					CROSS APPLY reloadXML.nodes('/CCSClientReload') t(d)
			END
			IF (@TranCnt2 = 0)
			BEGIN
				-- Commit local transaction
				COMMIT TRANSACTION
			END
		END TRY
		BEGIN CATCH
			PRINT 'APPCCSClientFailedSyncCheck: Cleanup Section'
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
			IF (@TranCnt2 = 0)
			BEGIN
				ROLLBACK TRANSACTION
			END
			ELSE
			BEGIN
				-- Rollback save point
				ROLLBACK TRANSACTION CCSSyncCheck
			END
			-- Do not need to rethrow the exception, since next pass will try again
		END CATCH
		--=============================================================================================
		-- END: Database Update Operations
		--=============================================================================================
	END
	SELECT @o_reloadedClients o_reloadedClients, @o_reloadXml o_reloadXml
END
GO

IF EXISTS (select * from GxQscripts where name = 'APPCCSClientFailedSyncCheck')
	delete from GxQscripts where name = 'APPCCSClientFailedSyncCheck'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPCCSClientFailedSyncCheck')
	delete from GXDBVersions where aliasname = 'APPCCSClientFailedSyncCheck'
GO

insert into GXDBVersions values(2, 'APPCCSClientFailedSyncCheck',  '00010001000200040000', 'APPCCSClientFailedSyncCheck', '00010001000200040000')
GO

