

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/APPAssociateCompanyClientToCompanyGroup.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/APPAssociateCompanyClientToCompanyGroup.sp,v $ $Id: APPAssociateCompanyClientToCompanyGroup.sp,v 1.1.2.5 2020/05/16 00:49:47 alakra Exp $";
--    +===================================================================+
--    | APPAssociateCompanyClientToCompanyGroup - For OneTouch set the owner for the new client                                |
--    +===================================================================+
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='APPAssociateCompanyClientToCompanyGroup')
BEGIN
	print '>>> Drop Stored Procedure: APPAssociateCompanyClientToCompanyGroup <<<'
	drop procedure APPAssociateCompanyClientToCompanyGroup
END
IF EXISTS (select * from GxQscripts where name='APPAssociateCompanyClientToCompanyGroup')
	delete from GxQscripts where name = 'APPAssociateCompanyClientToCompanyGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPAssociateCompanyClientToCompanyGroup')
	delete from GXDBVersions where aliasname = 'APPAssociateCompanyClientToCompanyGroup'
GO
print '... Creating Procedure: APPAssociateCompanyClientToCompanyGroup'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure APPAssociateCompanyClientToCompanyGroup
-----------------------------------------------------------
---    PARAMETERS   &   OUTPUTS                                         ---
  @userId integer,
  @clientId integer
-----------------------------------------------------------
AS
  DECLARE @o_errorCode integer
  DECLARE @o_errorString char(255)
SET NOCOUNT ON
SET @o_errorCode = 0
SET @o_errorString = ''
BEGIN TRY
	DECLARE @clientGroupId int = 0
	DECLARE @companyId int = -1
	DECLARE @ruleXML xml
	SET @companyId = dbo.AppGetOrganizationForUser(@userId)
	DECLARE @smartClientId int = 0
	SET @ruleXML = (SELECT scg.ruleXml FROM App_SCGRule scg
INNER JOIN App_CompanyProp prop ON prop.componentNameId=@companyId AND prop.attrName='Associated Smart Client Group' AND prop.modified=0 AND scg.scgId=prop.attrValInt AND prop.cs_attrName = CHECKSUM('Associated Smart Client Group'))
	SELECT @clientgroupId=A.val from (
	SELECT ref.value('@propID', 'INT') as propId, ref.value('@value', 'INT') as val
							FROM @ruleXML.nodes ('/scgRule/rules/rule/rules/rule') R(ref)) A
WHERE A.propid = 4
	--validate the client
	DECLARE @clientstatus int
	SELECT @clientstatus=status from APP_Client where id= @clientId --and status  &  4096 =0
	IF(@clientstatus is null)
	BEGIN
		SET @o_errorCode = 1
		SET @o_errorString = 'Client not found'
		GOTO PROC_EXIT
	END
IF(@clientstatus  &  0x1000 =0x1000)
	BEGIN
		SET @o_errorCode = 2
		SET @o_errorString = 'Client a laptop client.'
		GOTO PROC_EXIT
	END
	IF( @clientGroupId >0)
	BEGIN
	IF NOT EXISTS ( SELECT 1 FROM APP_ClientGroupAssoc WITH (NOLOCK) where clientGroupId = @clientGroupId AND clientId = @clientid)
	BEGIN
		INSERT INTO app_clientgroupassoc(clientGroupId, clientId)
		VALUES (@clientGroupId, @clientid)
		END
	END
	ELSE
	BEGIN
		SET @o_errorCode = 3
		SET @o_errorString = 'ClientGroupId not found'
	END
END TRY
BEGIN CATCH
PRINT  'INSIDE CATCH BLOCK WITH FOLLOWING ERROR:
	ERROR CODE: ' + CAST(ERROR_NUMBER() AS VARCHAR) + '
	PROC NAME: ' + ISNULL(ERROR_PROCEDURE(), '???') + '
	ERROR LINE NO: ' + CAST(ERROR_LINE() AS VARCHAR)  + '
	ERROR MESSAGE: ' + ERROR_MESSAGE() + '
	ERROR SEVERITY: ' + CAST(ERROR_SEVERITY() AS VARCHAR) +  '
	ERROR STATE: ' + CAST(ERROR_STATE() AS VARCHAR)
      SET @o_errorCode = ERROR_NUMBER()
      SET @o_errorString = ERROR_MESSAGE();
END CATCH
PROC_EXIT:
SELECT @o_errorCode,@o_errorString
SET NOCOUNT OFF
GO

IF EXISTS (select * from GxQscripts where name = 'APPAssociateCompanyClientToCompanyGroup')
	delete from GxQscripts where name = 'APPAssociateCompanyClientToCompanyGroup'
GO

IF EXISTS (select * from GXDBVersions where aliasname='APPAssociateCompanyClientToCompanyGroup')
	delete from GXDBVersions where aliasname = 'APPAssociateCompanyClientToCompanyGroup'
GO

insert into GXDBVersions values(2, 'APPAssociateCompanyClientToCompanyGroup',  '00010001000200050000', 'APPAssociateCompanyClientToCompanyGroup', '00010001000200050000')
GO

