

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkVerifyGetReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkVerifyGetReaders.sp,v $ $Id: AMChunkVerifyGetReaders.sp,v 1.3.12.2 2018/03/20 19:59:53 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AMChunkVerifyGetReaders <<<'

IF EXISTS (select * from sysobjects where name='AMChunkVerifyGetReaders')
	drop procedure AMChunkVerifyGetReaders
IF EXISTS (select * from GxQscripts where name='AMChunkVerifyGetReaders')
	delete from GxQscripts where name = 'AMChunkVerifyGetReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkVerifyGetReaders')
	delete from GXDBVersions where aliasname = 'AMChunkVerifyGetReaders'
GO
print '... Creating Procedure: AMChunkVerifyGetReaders'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AMChunkVerifyGetReaders
  @i_adminJobId int,
  @i_archGroupId int,
  @i_archCopyId int,
  @i_streamReaderId int,
  @i_status int,
  @i_markInited int
AS
  DECLARE @o_StreamReaderId int;
  DECLARE @o_Status int;
  DECLARE @o_StoragePolicyId int;
  DECLARE @o_StoragePolicyName NVARCHAR(64)
  DECLARE @o_SrcCopyId int;
  DECLARE @o_SrcCopyName NVARCHAR(64);
  DECLARE @o_SrcCopyFlags int;
  DECLARE @o_SrcCopyDedupeFlags int;
  DECLARE @o_SrcStreamNum int;
  DECLARE @o_SrcMediaAgentId int;
  DECLARE @o_SrcMediaAgentName NVARCHAR(255);
  DECLARE @o_SrcDrivePoolId int;
  DECLARE @o_SrcDrivePoolType int;
  DECLARE @o_SrcMediaGroupId int;
  DECLARE @o_SrcReservationId int;
  DECLARE @o_SrcRCId int;
  DECLARE @o_DestCopyId int;
  DECLARE @o_DestCopyName NVARCHAR(64);
  DECLARE @o_DestCopyFlags int;
  DECLARE @o_DestCopyDedupeFlags int;
  DECLARE @o_DestMediaAgentId int;
  DECLARE @o_DestMediaAgentName NVARCHAR(255);
  DECLARE @o_DestDrivePoolId int;
  DECLARE @o_DestDrivePoolType int;
  DECLARE @o_DestStreamNum int;
  DECLARE @o_DestMediaGroupId int;
  DECLARE @o_DestReservationId int;
  DECLARE @o_DestRCId int;
  DECLARE @o_CurrentSegmentId int;
  DECLARE @o_CurrentVolumeId int;
  DECLARE @o_CurrentChunkId int;
  DECLARE @o_CommcellId int;
  DECLARE @o_DestEncType int;
  DECLARE @o_DestEncKeyLen int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Decide what to return based on input
	DECLARE @streamReaderTbl TABLE (jobId int, StreamReaderId int)
	-- If there is given StreamReaderId, return that only
	IF @i_streamReaderId > 0
	BEGIN
		SET @i_archGroupId = 0
		SET @i_archCopyId = 0
		SET @i_status = 0
		INSERT INTO @streamReaderTbl (jobId, StreamReaderId)
		SELECT	DISTINCT JobId, StreamReaderId
		FROM	ArchJobStreamStatus
		WHERE	JobId = @i_adminJobId
		AND		StreamReaderId = @i_streamReaderId
		--AND		((@i_status = 0 AND Status = STREAM_READER_STATUS_NOT_USED) OR (Status = @i_status ))
	END
	-- Return only for the given source copy id based on the status
	ELSE IF @i_archCopyId > 0
	BEGIN
		SET @i_archGroupId = 0
		INSERT INTO @streamReaderTbl (jobId, StreamReaderId)
		SELECT	DISTINCT JobId, StreamReaderId
		FROM	ArchJobStreamStatus
		WHERE	JobId = @i_adminJobId
		AND		SrcCopyId = @i_archCopyId
AND		((@i_status = 0 AND Status = 0x00) OR (Status = @i_status ))
	END
	-- Return for the given storage policy based on the status
	ELSE IF @i_archGroupId > 0
	BEGIN
		INSERT INTO @streamReaderTbl (jobId, StreamReaderId)
		SELECT	DISTINCT JobId, StreamReaderId
		FROM	ArchJobStreamStatus
		WHERE	JobId = @i_adminJobId
		AND		SrcCopyId IN (SELECT DISTINCT Id FROM ArchGroupCopy WITH (NOLOCK) WHERE ArchGroupId = @i_archGroupId)
AND		((@i_status = 0 AND Status = 0x00) OR (Status = @i_status ))
	END
	ELSE
	BEGIN
		INSERT INTO @streamReaderTbl (jobId, StreamReaderId)
		SELECT	DISTINCT JobId, StreamReaderId
		FROM	ArchJobStreamStatus
		WHERE	JobId = @i_adminJobId
AND		((@i_status = 0 AND Status = 0x00) OR (Status = @i_status ))
	END
-- Delete any unreserved StreamReaders.
-- This will release the assigned segments and make sure any new request (getnextchunk or getnextReader) will be able to pick them.
	--DELETE	FROM ArchJobStreamStatus
	--WHERE	JobId = @i_adminJobId
	--AND		(Status = 1 /*reserved*/)
-- Use job id, copy id to get list of uninitialized stream readers, which have resources reserved already.
-- The retrun values will be list stream reader ids along with new chunks from current segment.
	SELECT	DISTINCT
			a.StreamReaderId, a.Status,
			sp.Id, sp.name,
			SrcCopyId, ISNULL(srcCopy.name, ''), ISNULL(srcCopy.Flags, 0), ISNULL(srcCopy.DedupeFlags, 0), SrcStreamNum,
			SrcMAId, ISNULL(srcMA.name, ''),
			SrcDrivePoolId, ISNULL(srcDP.DrivePoolType, 0),
			ISNULL(srcStream.MediaGroupId, 0), SrcReservationId, ISNULL(srcRes.RCId, a.SrcRCId),
			0, '', 0, 0, /*DestCopyId, ISNULL(destCopy.name, ''), ISNULL(destCopy.Flags, 0), ISNULL(destCopy.DedupeFlags, 0),*/
			DestMAId, ISNULL(destMA.name, ''),
			DestDrivePoolId, ISNULL(destDP.DrivePoolType, 0),
			0, 0, 0, 0, /*DestStreamNum, ISNULL(destStream.MediaGroupId, 0), DestReservationId, ISNULL(destRes.RCId, 0),*/
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			0, 0 /*ISNULL(destCopy.encType, 0), ISNULL(destCopy.encKeyLen, 0)*/
	FROM	@streamReaderTbl readers
			LEFT JOIN ArchJobStreamStatus a ON readers.JobId = a.JobId AND readers.StreamReaderId = a.StreamReaderId
			LEFT JOIN MMResourceToJob srcRes WITH (NOLOCK) ON readers.jobId = srcRes.JobId_l AND srcRes.RCID = a.SrcRCId
			--LEFT JOIN MMResourceToJob destRes WITH (NOLOCK) ON readers.jobId = destRes.JobId_l AND destRes.RCID = a.DestRCId
			LEFT JOIN ArchGroupCopy srcCopy WITH (NOLOCK) ON a.SrcCopyId = srcCopy.Id
			--LEFT JOIN ArchGroupCopy destCopy WITH (NOLOCK) ON a.DestCopyId = destCopy.Id
			LEFT JOIN App_Client srcMA WITH (NOLOCK) ON a.SrcMAId = srcMA.Id
			LEFT JOIN App_Client destMA WITH (NOLOCK) ON a.DestMAId = destMA.Id
			LEFT JOIN MMDrivePool srcDP WITH (NOLOCK) ON a.SrcDrivePoolId = srcDP.DrivePoolId
			LEFT JOIN MMDrivePool destDP WITH (NOLOCK) ON a.DestDrivePoolId = destDP.DrivePoolId
			LEFT JOIN ArchGroup sp WITH (NOLOCK) ON srcCopy.ArchGroupId = sp.Id
			LEFT JOIN ArchStream srcStream WITH (NOLOCK) ON a.SrcCopyId = srcStream.ArchGroupCopyId AND a.SrcStreamNum = srcStream.Stream
			--LEFT JOIN ArchStream destStream WITH (NOLOCK) ON a.DestCopyId = destStream.ArchGroupCopyId AND a.DestStreamNum = destStream.Stream
	ORDER BY a.StreamReaderId, SrcCopyId, SrcStreamNum --, DestCopyId, DestStreamNum
	IF (@i_markInited IS NOT NULL AND @i_markInited > 0)
	BEGIN
		UPDATE	ArchJobStreamStatus
SET		Status = 0x02 /*initialized*/
		FROM	@streamReaderTbl a, ArchJobStreamStatus b
		WHERE	a.JobId = b.jobId
		AND		a.StreamReaderId = b.StreamReaderId
AND		(b.Status = 0x01)
AND		(b.Status != 0x02)
		UPDATE a
		SET		a.SrcStreamNum = b.SrcStreamNum, a.SrcMAId = b.SrcMAId, a.SrcDrivePoolId = b.SrcDrivePoolId,
				a.SrcReservationId = b.SrcReservationId, a.srcRCId = b.srcRCId,
				a.Status = b.Status
		FROM	ArchJobStreamStatusHistory a, ArchJobStreamStatus b, @streamReaderTbl c
		WHERE	b.JobId = c.jobId
		AND		b.StreamReaderId = c.StreamReaderId
AND		b.Status = 0x02
		AND		a.JobId = b.JobId
		AND		a.StreamReaderId = b.StreamReaderId
	END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkVerifyGetReaders')
	delete from GxQscripts where name = 'AMChunkVerifyGetReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkVerifyGetReaders')
	delete from GXDBVersions where aliasname = 'AMChunkVerifyGetReaders'
GO

insert into GXDBVersions values(2, 'AMChunkVerifyGetReaders',  '00010003001200020000', 'AMChunkVerifyGetReaders', '00010003001200020000')
GO

