

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkVerify2CreateNewStream.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkVerify2CreateNewStream.sp,v $ $Id: AMChunkVerify2CreateNewStream.sp,v 1.1.2.5 2020/12/19 16:11:12 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AMChunkVerify2CreateNewStream')
BEGIN
	print '>>> Drop Stored Procedure: AMChunkVerify2CreateNewStream <<<'
	drop procedure AMChunkVerify2CreateNewStream
END
IF EXISTS (select * from GxQscripts where name='AMChunkVerify2CreateNewStream')
	delete from GxQscripts where name = 'AMChunkVerify2CreateNewStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkVerify2CreateNewStream')
	delete from GXDBVersions where aliasname = 'AMChunkVerify2CreateNewStream'
GO
print '... Creating Procedure: AMChunkVerify2CreateNewStream'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AMChunkVerify2CreateNewStream
  @i_adminJobId int,
  @i_jobToken varchar(128),
  @i_archGroupId int,
  @i_archCopyId int,
  @i_noOfStreams int,
  @i_checkIsNewStreamReaderPossible int = 0
AS
  DECLARE @o_streamReaderId int;
  DECLARE @o_ErrorCode int;
DECLARE @NOW INTEGER;
SET		@NOW = dbo.GetUnixTime(GetUTCDate())
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
DECLARE @BACKUP			integer	= 4
DECLARE @RESTORE		integer	= 5
DECLARE @INDEXRESTORE	integer	= 12
DECLARE @AUXCOPY		integer	= 13
DECLARE @SYNTHFULL		integer	= 14
DECLARE @ARCHIVECHECK	integer	= 31
DECLARE @OFFLINECI		integer	= 53
DECLARE @MEDIAREFRESH	integer	= 74
DECLARE @DEDUPDBSYNC	integer	= 80
DECLARE @AUXCOPY2		integer	= 104
DECLARE @DEDUPDBSYNC2	integer	= 131
DECLARE @ARCHIVECHECK2	integer = 106
-- define constants
declare @CVDP_REGULAR integer
declare @CVDP_NAS integer
declare @CVDP_NRS integer
set @CVDP_REGULAR = 0
set @CVDP_NAS = 1
set @CVDP_NRS = 2
SET @o_ErrorCode = 0
-- Create new stream readers based on request from Media Agent side.
-- Use job id, copy id to figure out which segment can be readed from table ArchChunkToVerify2 and then create new stream reader entries.
-- The new stream reader entries will be stored in table ArchJobStreamStatus with reservation status as false.
-- Later reservation logic will process such stream readers and try to allocate resources for each one of them.
-- The retrun values will be list newly created stream reader ids.
-- ArchGroupId and ArchCopyId will be used to identify which storage policy or source copy need to be processed during this call.
-- If neither of them are set, then we consider for the current job instead. The source copy will be multiple based on current job type (parallel or single stream).
	-- Remove all the processed StreamReader but wtih no valid RCId
	if (OBJECT_ID('tempdb.dbo.#AMCV_ArchJobStreamStatus') IS NOT NULL) DROP TABLE #AMCV_ArchJobStreamStatus
	CREATE TABLE #AMCV_ArchJobStreamStatus
	(
		JobId				integer,
		JobToken			varchar(128),
		SrcCopyId			integer,
		SrcStreamNum		integer,
		SrcReservationId	integer,
		SrcRCId				integer,
		SrcMAId				integer,
		SrcDrivePoolId		integer,
		DestCopyId			integer,
		DestStreamNum		integer,
		DestReservationId	integer,
		DestRCId			integer,
		DestMAId			integer,
		DestDrivePoolId		integer,
		StreamReaderId		integer,
		SegmentId			integer default 0,
		FirstVolumeId		integer,
		FirstChunkId		integer,
		CommCellId			integer,
		Status				integer,
		ModifiedTime		integer,
		ReservationRequestId	integer default 0,
		TotalSizeToProcess	bigint,
		TotalSizeProcessed	bigint,
		destSIDBStoreId 	integer default 0,
	primary key (JobId, StreamReaderId, DestCopyId)
	);;
	INSERT INTO #AMCV_ArchJobStreamStatus
	SELECT	*
	FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
	WHERE	JobId = @i_adminJobId
	DELETE FROM #AMCV_ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		(
Status = 0x08
				OR
Status = 0x04
				OR
Status = 0x00
				AND ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
				OR
				-- Clean up the streams created in previous phases or attempts.
				ModifiedTime < (SELECT ISNULL(MAX(endTime), 0) from JMAdminJobAttemptInfoTable where jobid = @i_adminJobId)
			)
	DECLARE @maxStreamReaderId int
	SELECT @maxStreamReaderId = ISNULL ((SELECT MAX(StreamReaderId) FROM ArchJobStreamStatusHistory WITH (NOLOCK) WHERE JobId = @i_adminJobId AND JobToken = @i_JobToken), 0)
    DECLARE @jobType		INT
    DECLARE @jobSubOpType	INT
    DECLARE @jobPhase		INT
	DECLARE @ddbVerificationLevel INT
	DECLARE @sidbStoreId	INT = 0
	DECLARE @copyId			INT = 0
    IF	@i_adminJobId > 0
    BEGIN
        SET @jobType= dbo.GetJobTypeForJobID(@i_adminJobId)
        -- Double check if the job is synthetic full or backup
        SELECT @jobSubOpType = ISNULL(subOpType, 0), @jobPhase = ISNULL(currentPhase, 0),
                @jobType = CASE WHEN optype = @SYNTHFULL THEN optype ELSE @jobType END
        FROM jmjobinfo WITH (NOLOCK)
		WHERE jobId = @i_adminJobId
SELECT  @ddbVerificationLevel = (CASE WHEN optionId = 1616894445  THEN CAST(value AS INT) ELSE @ddbVerificationLevel END),
@sidbStoreId = (CASE WHEN optionId = 229570007 THEN CAST(value AS INT) ELSE @sidbStoreId END)
		FROM    dbo.GetAllJobOptions(@i_adminJobId)
WHERE    optionId IN (1616894445, 229570007)
    END
	IF @sidbStoreId <= 0
	BEGIN
SET @o_ErrorCode = 20109
		GOTO EXIT_RETURN
	END
    DECLARE @dedupeValidate INT = 0
	DECLARE @dataValidate INT = 0
    DECLARE @defragment INT = 0
    DECLARE @orphanListing INT = 0
    DECLARE	@opId INT = 0
    IF (@jobType =  @ARCHIVECHECK)
    BEGIN
        SELECT	@opId = id
        FROM	JMOpTable WITH (READUNCOMMITTED)
        WHERE	operation=31 /*ARCHIVECHECK*/
		SELECT	@dedupeValidate = [Validate Dedupe Data],
				@dataValidate =  [Verify Data],
				@orphanListing = [Orphan Chunk listing],
				@defragment = [Defragment Data]
		FROM
			(SELECT	phase, name
			FROM	JMPhase WITH (READUNCOMMITTED)
			WHERE	opTableId = @opId) AS JP
			PIVOT
			(
			MAX(phase)
			FOR name IN ([Validate Dedupe Data], [Verify Data], [Orphan Chunk listing], [Defragment Data])
			) p;
    END
	SELECT	@copyId = MIN(CopyId)
	FROM	ArchCopySIDBStore copy with (READUNCOMMITTED)
	WHERE	copy.SIDBStoreId = @sidbStoreId
	DECLARE @maxConcurrency		int = 0
	DECLARE @noOfStreamReaders	int = 0
SET @maxConcurrency = CAST((CASE (CAST(dbo.GetJobOption(@i_adminJobId, 1109628066) as int))
WHEN 0 THEN (CAST(dbo.GetJobOption(@i_adminJobId, 2105046087) as int))
	 							ELSE 0
	 						   END) AS INT)
    SELECT @noOfStreamReaders = COUNT(DISTINCT StreamReaderId)
	FROM #AMCV_ArchJobStreamStatus WITH (NOLOCK)
	WHERE JobId = @i_adminJobId
	AND JobToken = @i_JobToken
AND	(Status = 0x01 OR Status = 0x02) /*RESERVED, NITIALIZED*/
    /*DEDUPVALIDATE, ORPHANLISTING, DEFRAGMENT*/
    IF (@jobPhase = @dedupeValidate OR @jobPhase = @defragment)
    BEGIN
		IF (@maxConcurrency = 0)
		BEGIN
SET @maxConcurrency = 5
			SELECT	@maxConcurrency = IIF(value > 0, value, @maxConcurrency)
			FROM	MMConfigs WITH (NOLOCK)
			WHERE	Name = 'MMCONFIG_THREAD_COUNT_DURING_VALIDATE_DDB'
		END
		SELECT	@maxConcurrency = (CASE WHEN value < @maxConcurrency THEN value ELSE @maxConcurrency END)
		FROM	MMConfigs WITH (NOLOCK)
		WHERE	Name = 'MMCONFIG_THREAD_COUNT_ON_DDB_VERIFICATION_JOB'
       	IF @maxConcurrency > 0 AND @maxConcurrency <= @noOfStreamReaders
        BEGIN
SET @o_ErrorCode = 20054
            GOTO EXIT_RETURN
        END
    END
    ELSE IF @jobPhase =  @orphanListing
    BEGIN
        SET @maxConcurrency = 1
        IF @maxConcurrency > 0 AND @maxConcurrency <= @noOfStreamReaders
        BEGIN
SET @o_ErrorCode = 20054
            GOTO EXIT_RETURN
        END
    END
	IF @maxConcurrency > 0 AND @i_noOfStreams > (@maxConcurrency - @noOfStreamReaders)
	BEGIN
		SET @i_noOfStreams = @maxConcurrency - @noOfStreamReaders
	END
	DECLARE @tblStreamReaderDetails TABLE (
		RowNum			int,
		SrcCopyId		int,
		SrcStreamNum	int,
		SrcMediaAgentId	int,
		DestCopyId		int,
		DestStreamNum	int,
		SegmentId		int,
		CommCellId		int,
		FirstChunkId	int,
		ChunkCommCellId	int,
		FirstVolumeId	int,
		IsMultiWrite	int,
		StreamReaderId	int,
		TotalSizeToProcess	bigint
	)
    -- 1. Check the media agent online status
    -- 2. Check the configuration allowed for media agent
    -- 3. Decide the no of stream on each media agent until reach the required stream count
    -- 4. General row in ArchJobStreamStatus table with no VOlume info
    DECLARE @tblPreferedDrivePool TABLE (DrivePoolId int)
    DECLARE @tblNameId TABLE (Name varchar(16), id int)
    IF @jobType IN (@ARCHIVECHECK)
	AND EXISTS (
			SELECT * FROM JMJobOptions WITH (NOLOCK)
		 	WHERE jobId = @i_adminJobId AND commcellId = 2
AND attributeId = 41
			--AND attributeName = JM_STORE_BASED_DV_JOB_MEDIAAGENT_NAME
		)
    BEGIN
        insert	into @tblNameId
select	'MEDIA_AGENT_ID', cast(dbo.GetJobOption(@i_adminJobId, 1564054677) as integer)
        if not exists (select * from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
            INSERT INTO @tblNameId
            SELECT	'MEDIA_AGENT_ID', CAST(attributeValueInt AS INT)
            FROM	JMJobOptions WITH (NOLOCK)
            WHERE	jobId = @i_adminJobId AND commcellId = 2
AND	attributeId = 41
            --AND attributeName = JM_STORE_BASED_DV_JOB_MEDIAAGENT_NAME
            AND	attributeValueInt > 0
    END
    ELSE IF @jobType in (@ARCHIVECHECK)
    BEGIN
        insert	into @tblNameId
select	'MEDIA_AGENT_ID', cast(dbo.GetJobOption(@i_adminJobId, 1564054677) as integer)
    END
    IF EXISTS (select * from @tblNameId where name = 'MEDIA_AGENT_ID' and id > 0)
    BEGIN
        INSERT	INTO @tblPreferedDrivePool
        SELECT	DISTINCT DrivePoolId
        FROM	MMDrivePool WITH (NOLOCK)
        WHERE	ClientId = (SELECT top 1 Id FROM @tblNameId WHERE name = 'MEDIA_AGENT_ID' AND id > 0)
		IF NOT EXISTS (SELECT 1 FROM @tblPreferedDrivePool)
		BEGIN
			-- no drivepool is configured for the preferred MA
SET @o_ErrorCode = 322
			goto EXIT_RETURN
		END
    END
	if (OBJECT_ID('tempdb.dbo.#tmpDrivePool') IS NOT NULL) DROP TABLE #tmpDrivePool
    -- this table will contain all available drivepools
    create table #tmpDrivePool
    (
    -- drive pool
        DrivePoolId			int,
        DrivePoolType		int,
        DrivePoolSoftState	int,
        DrivePoolEnabled	int,
    -- master pool
        MasterPoolId		int,
        MasterPoolSoftState	int,
        MasterPoolEnabled	int,
        TotalDrives			int,
    -- library
        LibraryId			int,
        LibraryTypeId		int,
        LibrarySoftState	int,
        LibraryEnabled		int,
        LibraryBroken		int,
        LibraryAttribute	int,
        ExtendedAttributes	int,
LibraryName			varchar(128),
LibraryAliasName	nvarchar(128),
    -- host
        ClientId			int,
        NDMPHostId			int,
        ClientReleaseId		int,
        ClientStatus		int,
        MmHostSoftState		int,
        HostOfflineReason	int,
        MmHostEnabled		int,
        NasClientid			int,
        Attribute			int,
NetHostName			varchar(1024),
NasFilerName		varchar(1024),
    -- idx access path
        IdxAccessPathId		int,
        AccessPathEnabled	int,
        AccessPathSoftState	int,
        OrderBy				int,
        isPreferredMAForMP	int
    )
    IF EXISTS (SELECT 1 FROM @tblPreferedDrivePool)
    BEGIN
         INSERT	into #tmpDrivePool
        SELECT	distinct DP.DrivePoolId, DP.DrivePoolType, DP.DrivePoolSoftState, DP.DrivePoolEnabled,
                MP.MasterPoolId, MP.MasterPoolSoftState, MP.MasterPoolEnabled, MP.TotalDrives,
                MP.LibraryId, 0, 0, 0, 0, 0, 0, '', '',
                DP.ClientId, DP.NDMPHostId, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0
        FROM	@tblPreferedDrivePool T, MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK), MMHost Host WITH (NOLOCK), MMDataPath datapath WITH (NOLOCK)
        WHERE	T.DrivePoolId = DP.DrivePoolId
		AND		DP.MasterPoolId = MP.MasterPoolId and MP.TotalDrives > 0
		AND		DP.ClientId = Host.ClientId
		AND		DP.DrivePoolId = datapath.DrivePoolId
		AND		datapath.CopyId = @copyId
		AND
		-- Media Agent online
		(	host.mmhostsoftstate = 1 /* AND
				(  host.OfflineReason <> @HOST_STATUS_POWER_MANAGED_VM OR
				-- Consider the MA as offline, only if it is not power vm and softstate is 0 and also
				-- if MA is power vm then assume it as offline if power on req is failed even after 3 retries by MM
					(
						host.OfflineReason = @HOST_STATUS_POWER_MANAGED_VM AND
						EXISTS( SELECT 1 FROM MMVMPowerMgmtReq VM WITH (NOLOCK)
										INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON VM.RequestId = VMMAP.RequestId
	WHERE VM.HostId = host.ClientId AND VM.FailureReason = 2 AND VMMAP.EntityId = @i_adminJobId AND VMMAP.EntityType = 1
								)
					)
					OR @isPowerVMFeatureEnabled = 0
					)	or host.mmhostenabled = 0
					*/
			and host.mmhostenabled = 1
		)
	END
    ELSE
    BEGIN
       INSERT	into #tmpDrivePool
        SELECT	distinct DP.DrivePoolId, DP.DrivePoolType, DP.DrivePoolSoftState, DP.DrivePoolEnabled,
                MP.MasterPoolId, MP.MasterPoolSoftState, MP.MasterPoolEnabled, MP.TotalDrives,
                MP.LibraryId, 0, 0, 0, 0, 0, 0, '', '',
                DP.ClientId, DP.NDMPHostId, 0, 0, 0, 0, 0, 0, 0, '', '', 0, 0, 0, 0, 0
        FROM	MMDrivePool DP WITH (NOLOCK), MMMasterPool MP WITH (NOLOCK), MMHost Host WITH (NOLOCK), MMDataPath datapath WITH (NOLOCK)
        WHERE	DP.MasterPoolId = MP.MasterPoolId and MP.TotalDrives > 0
		AND		DP.ClientId = Host.ClientId
		AND		DP.DrivePoolId = datapath.DrivePoolId
		AND		datapath.CopyId = @copyId
		AND
		-- Media Agent online
		(	host.mmhostsoftstate = 1 /* AND
				(  host.OfflineReason <> @HOST_STATUS_POWER_MANAGED_VM OR
				-- Consider the MA as offline, only if it is not power vm and softstate is 0 and also
				-- if MA is power vm then assume it as offline if power on req is failed even after 3 retries by MM
					(
						host.OfflineReason = @HOST_STATUS_POWER_MANAGED_VM AND
						EXISTS( SELECT 1 FROM MMVMPowerMgmtReq VM WITH (NOLOCK)
										INNER JOIN MMPowerMgmtJobToVMMap VMMAP WITH(NOLOCK) ON VM.RequestId = VMMAP.RequestId
	WHERE VM.HostId = host.ClientId AND VM.FailureReason = 2 AND VMMAP.EntityId = @i_adminJobId AND VMMAP.EntityType = 1
								)
					)
					OR @isPowerVMFeatureEnabled = 0
					)	or host.mmhostenabled = 0
					*/
			and host.mmhostenabled = 1
		)
	END
	IF NOT EXISTS (SELECT 1 FROM #tmpDrivePool)
	BEGIN
SET @o_ErrorCode = 371
        goto EXIT_RETURN
	END
    declare @maxMediaAgentsTobeSelected integer = 0
declare @maxMediaAgentsTobeUsed integer = 5
    select	@maxMediaAgentsTobeUsed = value
    from	MMConfigs
    where	name = 'MMCONFIG_MA_COUNT_DURING_VALIDATE_DDB'
    declare @allowedMediaAgents table (clientId integer)
	declare @preferredDestClientId int = 0
	declare @current_stream_count int = 1
	/* REVISIT */
	declare @dataPathType integer
	set @dataPathType = @CVDP_REGULAR
	declare @preferMAPreferredToMP integer
	--Prefer MA preferred to mount path over load balance if config param is set.
	set @preferMAPreferredToMP = 1
	WHILE (@current_stream_count <= @i_noOfStreams)
	BEGIN
		set @preferredDestClientId = 0
		insert INTO @allowedMediaAgents
		select	distinct tmp.ClientID
		from	#tmpdrivepool tmp,
				(select	distinct stream.SrcMAId from #AMCV_ArchJobStreamStatus stream with (nolock)  where stream.jobId = @i_adminJobId) T
		where	tmp.clientID = T.SrcMAId
		SET @maxMediaAgentsTobeSelected = @maxMediaAgentsTobeUsed - (select count(*) FROM @allowedMediaAgents)
		--If the number mediaagent used is less then maxallowed then select different MA
		if (@maxMediaAgentsTobeSelected > 0)
		begin
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp LEFT OUTER JOIN @allowedMediaAgents A ON tmp.clientId = A.ClientId
			WHERE	a.ClientId IS NULL
			-- Less used Media Agent first
			order by --(case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
					--(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(ReservationId) from MMResource WITH (nolock) where ClientId = tmp.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(tmp.ClientId, 1 /*notReserved*/),
					tmp.isPreferredMAForMP desc
		end
		--If the number mediaagent used is greater or equal then maxallowed then select used MA
		if (@preferredDestClientId = 0)
		begin
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp INNER JOIN @allowedMediaAgents A ON tmp.clientId = A.ClientId
			-- Less used Media Agent first
			order by --(case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
					--(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(ReservationId) from MMResource WITH (nolock) where ClientId = tmp.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(tmp.ClientId, 1 /*notReserved*/),
					tmp.isPreferredMAForMP desc
		end
		--if nothing is selected pick any MA
		if (@preferredDestClientId = 0)
		begin
			select top 1 @preferredDestClientId = isnull(tmp.ClientId, 0)
			from	#tmpdrivepool tmp
			-- Less used Media Agent first
			order by --(case when exists(select 1 from #destClientIds where (@dataPathType = @CVDP_NAS and destclientId = tmp.nasClientId) or (@dataPathType != @CVDP_NAS and destclientId = tmp.clientId)) then 0 else 1 end),
					--(case when @preferMAPreferredToMP = 1 then tmp.isPreferredMAForMP else 0 end) desc,
					(select count(ReservationId) from MMResource WITH (nolock) where ClientId = tmp.ClientId) + dbo.MMS2FUNC_GetReadStreamCountForMA(tmp.ClientId, 1 /*notReserved*/),
					tmp.isPreferredMAForMP desc
		end
		if (@preferredDestClientId > 0)
		begin
			INSERT	INTO @tblStreamReaderDetails
			SELECT	@current_stream_count, @copyId, 0, @preferredDestClientId,
					0, 0,
					0,
					2, 0, 2,
					0, 0,
					(@current_stream_count + @maxStreamReaderId) as StreamReaderId,
					0
		end
		else
		begin
			-- This should not happen right now, since we don't check limit on each media agent
			break;
		end
		SET @current_stream_count = @current_stream_count + 1
	END
EXIT_RETURN:
	if (OBJECT_ID('tempdb.dbo.#AMCV_ArchJobStreamStatus') IS NOT NULL) DROP TABLE #AMCV_ArchJobStreamStatus
	IF (@i_checkIsNewStreamReaderPossible = 1)
	BEGIN
		SELECT ISNULL((SELECT MAX(RowNum) FROM @tblStreamReaderDetails), 0), @o_ErrorCode
		RETURN
	END
	-- Remove all the processed StreamReader but wtih no valid RCId
	INSERT INTO ArchJobStreamStatusHistory (
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		ModifiedTime,
		ReservationRequestId,
		ModifiedReason
	)
	SELECT
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		dbo.GetUnixTime(getutcdate()),
		ReservationRequestId,
'DELETE DUE TO ' + CASE WHEN Status = 0x08	THEN 'STREAM RELEASED'
WHEN Status = 0x04	THEN 'STREAM FAILURE'
WHEN Status = 0x00	THEN 'RESERVATION REQUEST TIMEOUT'
								ELSE	'RESERVATION INVALID' END
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		(
Status = 0x08
				OR
Status = 0x04
				OR
Status = 0x00
				AND ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	DELETE FROM ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		(
Status = 0x08
				OR
Status = 0x04
				OR
Status = 0x00
				AND ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	IF EXISTS (SELECT * FROM @tblStreamReaderDetails)
	BEGIN
		INSERT INTO ArchJobStreamStatus (
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			ModifiedTime,
			ReservationRequestId,
			TotalSizeToProcess, TotalSizeProcessed
		)
		SELECT
			@i_adminJobId, @i_jobToken,
			SrcCopyId, SrcStreamNum, 0, 0, SrcMediaAgentId, 0,
			DestCopyId, DestStreamNum, 0, 0, 0, 0,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, ChunkCommCellId,
			0 /*NOT RESERVED, NOT INITIALIZED*/,
			dbo.GetUnixTime(getutcdate()),
0x00,
			TotalSizeToProcess, 0
		FROM	@tblStreamReaderDetails
		--WHERE	(@i_archCopyId = 0 OR @i_archCopyId = SrcCopyId)
		INSERT INTO ArchJobStreamStatusHistory (
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			ModifiedTime,
			ReservationRequestId,
			ModifiedReason
		)
		SELECT
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			dbo.GetUnixTime(getutcdate()),
			ReservationRequestId,
			'CREATE'
		FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
		WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
AND		Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
		SELECT	DISTINCT StreamReaderId, 0
		FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
		WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
AND		Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
	END
	ELSE
	BEGIN
		SELECT 0, @o_ErrorCode
	END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkVerify2CreateNewStream')
	delete from GxQscripts where name = 'AMChunkVerify2CreateNewStream'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkVerify2CreateNewStream')
	delete from GXDBVersions where aliasname = 'AMChunkVerify2CreateNewStream'
GO

insert into GXDBVersions values(2, 'AMChunkVerify2CreateNewStream',  '00010001000200050000', 'AMChunkVerify2CreateNewStream', '00010001000200050000')
GO

