

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkSynFullGetNextChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkSynFullGetNextChunks.sp,v $ $Id: AMChunkSynFullGetNextChunks.sp,v 1.3.2.14 2018/03/24 14:27:53 pnara Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AMChunkSynFullGetNextChunks <<<'

IF EXISTS (select * from sysobjects where name='AMChunkSynFullGetNextChunks')
	drop procedure AMChunkSynFullGetNextChunks
IF EXISTS (select * from GxQscripts where name='AMChunkSynFullGetNextChunks')
	delete from GxQscripts where name = 'AMChunkSynFullGetNextChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkSynFullGetNextChunks')
	delete from GXDBVersions where aliasname = 'AMChunkSynFullGetNextChunks'
GO
print '... Creating Procedure: AMChunkSynFullGetNextChunks'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AMChunkSynFullGetNextChunks
  @i_adminJobId int,
  @i_archGroupId int,
  @i_archCopyId int,
  @i_streamReaderId int,
  @i_segmentId int
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;				
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_srcEncKeyType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_subClientName NVARCHAR(128);
  DECLARE @o_extraFlags integer;
  DECLARE @o_destPhysicalSize bigint;
  DECLARE @o_destLogicalSize bigint;
  DECLARE @o_destDrivePoolId integer;
  DECLARE @o_destAFCopyFlags integer;
  DECLARE @o_destEncKeyType integer;
  DECLARE @o_encKeyCreated integer;
  DECLARE @o_unCompBytesSize bigint;
IF @i_streamReaderId IS NULL
	SET @i_streamReaderId = 0
IF @i_archCopyId IS NULL
	SET @i_archCopyId = 0
IF @i_segmentId IS NULL
	SET @i_segmentId = 0
-- Select next chunk list based on the given stream reader id.
-- Use job id, copy id and stream reader id to identify current in use reader from table ArchJobStreamStatus.
-- It will give current segmentId, which can be used to figure out the next chunk/volume list from table ArchChunkToSF.
-- The return value will be list of uncopied chunks for the given stream reader.
DECLARE @NOW INTEGER;
SET		@NOW = dbo.GetUnixTime(GetUTCDate())
IF @i_streamReaderId = 0 AND @i_segmentId = 0
	GOTO ERROR_EXIT
DECLARE @MAX_CHUNK_PER_REQ	INT = 10
SET @MAX_CHUNK_PER_REQ = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMS2_CONFIG_STRING_AUXCOPY_MAX_CHUNKS_PER_COPY_REQ'), 10)
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
DECLARE @commCellId				integer = 0
DECLARE @isMultiCopies			integer = 0
DECLARE @currentSourceVolumeId	integer = 0
DECLARE @currentSourceMAId		integer = 0
DECLARE @currentSourceDPId		integer = 0
DECLARE @currentReservationId	integer = 0
DECLARE @currentRCId			integer = 0
DECLARE @currentDestStreamNum	integer = 0
DECLARE @currentSrcStreamNum	integer = 0
DECLARE @currentSourceMediaId	integer = 0
DECLARE @currentSourceMountPathId	integer = 0
DECLARE @currentSourceDeviceId		integer = 0
DECLARE @oldSourceVolumeId		integer = 0
DECLARE @oldSourceMountPathId	integer = 0
DECLARE @oldSourceDeviceId		integer = 0
DECLARE @sourceLibraryVTLType	integer = 0
IF object_id('tempdb.dbo.#tblPartiallyCopiedChunk') IS  NOT null DROP TABLE #tblPartiallyCopiedChunk
CREATE TABLE #tblPartiallyCopiedChunk
(
	archCopyId		int,
	streamNum		int,
	mediaGroupId	int,
	destCopyId		int,
	destStream		int,
	commCellId		int,
	archChunkId		bigint,
	chunkCommCellId int,
	copiedBytes		bigint,
	copiedUnCompBytes bigint,
	isSnapCopy		int,
	primary key (destCopyId, destStream, archChunkId, commCellId)
)
IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
CREATE TABLE #tblArchChunk
(
	destCopyId			integer,
	destStreamNum		integer,
	srcCopyId			integer,
	srcStreamNum		integer,
	archChunkId			bigint,
	archFileId			integer,
	commCellId			integer,
	chunkCommCellId		integer,
	lastChunkNumber		integer,
	chunkNumber			integer,
	volumeId			integer,
	mediaId				integer,
	mediaGroupId		integer,
	segmentId			integer,
	ChunkNoRowNumber	integer,
	ChunkIdRowNumber	integer,
	primary key (archChunkId, archFileId, commCellId, chunkCommCellId, destCopyId)
)
--DECLARE @tblDestCopyList TABLE
--(
--	destCopyId			integer
--)
  DECLARE @getMAAndDPForVolumeResult TABLE (
	retCode			integer,
mediaAgentName	varchar(1024),
	clientId		integer,
	nasClientId		integer,
	clientReleaseId	integer,
filerName		varchar(1024),
	hostId			integer,
	drivepoolId		integer,
	drivepoolType	integer,
	libraryId		integer,
	libraryTypeId	integer,
	libraryAttribute integer,
libraryName			varchar(128),
libraryAliasName	nvarchar(128),
barcode			varchar(256),
	volumeId		integer,
	mediaLocation	integer,
	jobOpType		integer,
	failureType		integer
  )
  DELETE from @getMAAndDPForVolumeResult
DECLARE @tblExcludedSegmentId TABLE(
	segmentId		int,
	primary key (segmentId)
)
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
CREATE TABLE #tblNextSegments
(
	segmentId		int,
	destCopyId		int,
	destStreamNum	int,
	firstVolumeId	int,
	firstChunkId	int,
	primary key (segmentId, destCopyId)
)
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
CREATE TABLE #tblNextVolumes
(
	volumeId int,
	mediaId int,
	recordingFormatId int,
	libraryId int,
	libVTLType	int,
	mountPathId int,
	deviceId int,
	segmentId int,
	ChunkIdRowNumber int
)
CREATE CLUSTERED INDEX #tblNextVolumes_VolumeId_MediaId_Idx ON #tblNextVolumes (volumeId, mediaId)
-- For parallel copy, source info should be the same for all the destinations, but the current chunk and volume may be different among the destination copies.
-- TODO: How to handle request for multiple StreamReaderId?
SELECT TOP 1
		@i_streamReaderId = CASE WHEN @i_streamReaderId = 0 THEN StreamReaderId ELSE @i_streamReaderId END,
		@i_segmentId = CASE WHEN @i_segmentId = 0 THEN SegmentId ELSE @i_segmentId END,
		@i_archCopyId = CASE WHEN @i_archCopyId = 0 THEN SrcCopyId ELSE @i_archCopyId END,
		@currentReservationId = SrcReservationId,
		@currentRCId = SrcRCId,
		@currentSourceVolumeId = FirstVolumeId,
		@currentSourceMAId = SrcMAId,
		@currentSourceDPId = SrcDrivePoolId,
		@currentDestStreamNum = DestStreamNum,
		@currentSrcStreamNum = SrcStreamNum
FROM	ArchJobStreamStatus WITH (NOLOCK)
WHERE	JobId = @i_adminJobId
AND		(SrcCopyId = @i_archCopyId OR 0 = @i_archCopyId)
AND		(StreamReaderId = @i_streamReaderId OR @i_streamReaderId = 0)
AND		(SegmentId = @i_segmentId OR @i_segmentId = 0)
--AND		(Status & STREAM_READER_STATUS_RESERVED /*reserved*/) > 0
ORDER BY jobId, StreamReaderId, CommCellId, FirstChunkId
IF @i_segmentId = 0 OR @i_archCopyId = 0
	GOTO ERROR_EXIT
SELECT @currentSourceMediaId = MediaId
FROM	MMVolume WITH (NOLOCK)
WHERE	VolumeId = @currentSourceVolumeId
SELECT @currentSourceMountPathId = device.MountPathId, @currentSourceDeviceId = device.DeviceId
FROM	MMMediaSide side WITH (NOLOCK), MMMountPath mp WITH (NOLOCK), MMMountPathToStorageDevice device WITH (NOLOCK)
WHERE	side.MediaId = @currentSourceMediaId
AND		side.MediaSideId = mp.MediaSideId
AND		device.MountPathId = mp.MountPathId
--INSERT INTO @tblDestCopyList
--SELECT DISTINCT DestCopyId
--FROM	ArchJobStreamStatus WITH (NOLOCK)
--WHERE	JobId = @i_adminJobId
--AND		SrcCopyId = @i_archCopyId
----AND		StreamReaderId = @i_streamReaderId
--AND		SegmentId = @i_segmentId
--AND		Status = STREAM_READER_STATUS_INITED
--AND		EXISTS (SELECT * FROM MMResourceToJob WHERE RCId = ArchJobStreamStatus.DestRCId)
--SELECT @isMultiCopies = COUNT (DISTINCT DestCopyId)
--FROM	@tblDestCopyList
-- If using DSA, we don't knwo the source stream number at this point when reservation is just done and this is the first call for getNExtChuck.
-- Figure out a source number and use it directly
IF @currentSrcStreamNum = 0 -- AND @currentDestStreamNum = 0
BEGIN
	--DECLARE @maxConcurrency		int = 0
	--SET @maxConcurrency = cast(dbo.GetJobOption(@i_adminJobId, AUXCOPYOPTION_MAX_NUMBER_OF_STREAMS) as int)
	DECLARE @noOfStreamReaders	int = 0
	SELECT @noOfStreamReaders = COUNT(DISTINCT StreamReaderId)
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId
	AND		SrcStreamNum > 0
	AND		DestStreamNum = 0
	SELECT	TOP 1 @currentSrcStreamNum = stream
	FROM	ArchStream WITH (NOLOCK)
	WHERE	archGroupCopyId = @i_archCopyId
	AND		stream NOT IN (
							SELECT	SrcStreamNum
							FROM	ArchJobStreamStatus WITH (NOLOCK)
							WHERE	JobId = @i_adminJobId
							AND		SrcStreamNum > 0
							AND		DestStreamNum = 0
							AND		SrcCopyId = @i_archCopyId
						)
	ORDER BY stream
	IF @currentSrcStreamNum = 0
		SET @currentSrcStreamNum = @noOfStreamReaders + 1
ENd
-- Reset SKIPPED flag based on the destination stream for any failed count or time within the same segment.
-- The reason for doing it within the same segment is to reduce the possiblity of deadlock.
IF object_id('tempdb.dbo.#tblSkippedChunks') IS  NOT null DROP TABLE #tblSkippedChunks
CREATE TABLE #tblSkippedChunks(
	ArchChunkId				int,
	ChunkCommCellId		int,
	DataSizeToProcess	bigint
)
IF @currentSrcStreamNum > 0
BEGIN
	UPDATE ArchChunkToSF
SET		Status = 6
	FROM	ArchChunkToSF R, JMJobDataStats JDS
	WHERE	R.AdminJobId = @i_adminJobId
	AND		R.SrcCopyId = @i_archCopyId
	AND		R.SegmentId = @i_segmentId
ANd		R.Status IN ( 3, 0)
	AND		R.BackupJobId = JDS.JobID
	AND		R.SrcCopyId = JDS.archGrpCopyId
	AND		R.fileType = JDS.dataType
	AND		R.CommCellid = JDS.CommCellId
AND		((JDS.disabled & (8192 | 1)) = (8192 | 1)
OR (JDS.disabled & (256)) > 0)
	DELETE FROM #tblSkippedChunks
	INSERT INTO #tblSkippedChunks
	SELECT ArchChunkId, ChunkCommCellId, PhysicalSize
	FROM	ArchChunkToSF WITH (NOLOCK)
	WHERE	AdminJobId = @i_adminJobId
	AND		SrcCopyId = @i_archCopyId
	AND		SegmentId = @i_segmentId
AND		Status = 3 /*CVA_CHUNK_SKIPPED*/
	AND		(
				SrcStreamNum = @currentSrcStreamNum
			)
	-- AND		SkippedCount < @MAX_FAILURE_COUNT
	AND		(
				SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
				OR
				(Modified + SkippedForSeconds) < @NOW
			)
	IF EXISTS (SELECT * FROM #tblSkippedChunks)
	BEGIN
		UPDATE ArchChunkToSF
SET		Status = 0
		FROM	ArchChunkToSF a, #tblSkippedChunks b
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.SegmentId = @i_segmentId
AND		a.Status = 3 /*CVA_CHUNK_SKIPPED*/
		AND		a.ArchChunkId = b.ArchChunkId
		AND		a.ChunkCommCellId = b.ChunkCommCellId
		/* No need to do that. When DSA is enabled, the value is inaccureate anyway.
		UPDATE	ArchJobStreamStatus
		SET		TotalSizeToProcess = TotalSizeToProcess + (SELECT SUM(ISNULL(DataSizeToProcess, 0)) FROM  #tblSkippedChunks)
		WHERE	JobId = @i_adminJobId
		AND		SrcCopyId = @i_archCopyId
		AND		SegmentId = @i_segmentId
		*/
	END
END
IF @currentReservationId > 0
BEGIN
	SELECT @currentSourceVolumeId = VolumeId, @currentSourceMAId = clientId, @currentSourceDPId = DrivePoolId
	FROM	MMResource WITH (NOLOCK)
	WHERE	ReservationId = @currentReservationId
END
ELSE
BEGIN
	IF @currentSourceVolumeId = 0
		GOTO PICK_NEXT_SEGMENT
END
PICK_NEXT_CHUNK:
	-- Lookup partially copied chunks first
	-- Refer to stored procedure archChunkToCopyGetFirst.sp
	DECLARE	@oneConstReal REAL = 1.0
	DELETE #tblPartiallyCopiedChunk
	DELETE #tblArchChunk
	INSERT INTO #tblPartiallyCopiedChunk (
			archCopyId, streamNum, mediaGroupId, destCopyId, destStream, commCellId,
			archChunkId, chunkCommCellId,
			copiedBytes, copiedUnCompBytes,
			isSnapCopy
	)
	SELECT	A.SrcCopyId, A.SrcStreamNum, A.mediaGroupId, A.DestCopyId, A.DestStreamNum, A.commCellId,
			A.ArchChunkId, a.ChunkCommCellId,
			0 /*SUM(B.physicalSize - A.physicalOffset)*/ AS copiedBytes,
			0 /*CAST((SUM( CASE WHEN A.physicalSize = 0 THEN (B.physicalSize - A.physicalOffset)
							ELSE (((B.physicalSize - A.physicalOffset)*@oneConstReal*A.unCompBytesSize)/ A.physicalSize)
							END
					  )
				  ) AS BIGINT)*/ AS copiedUnCompBytes,
			CASE WHEN EXISTS (SELECT Id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = A.DestCopyId AND isSnapCopy = 1) THEN 1 ELSE 0 END
	FROM	ArchChunkToSF A WITH (NOLOCK), ArchChunkToSFArchFiles B WITH (NOLOCK)
	WHERE	A.AdminJobId = @i_adminJobId
	AND		A.SrcCopyId = @i_archCopyId
	AND		A.SegmentId = @i_segmentId
	AND		A.VolumeId = @currentSourceVolumeId
	AND		A.Status = 0
	AND		(
				A.SrcStreamNum > 0
			)
	AND		(
				A.archFileId = B.archFileId AND
				A.commCellId = B.commCellId AND
				A.AdminJobId = B.AdminJobId AND
				B.ProcessedItems > 0 AND B.ProcessedItems < B.TotalItems
			)
	GROUP BY A.SrcCopyId, A.SrcStreamNum, A.mediaGroupId, A.DestCopyId, A.DestStreamNum, A.commCellId,
			A.ArchChunkId, a.ChunkCommCellId
	IF EXISTS (SELECT * FROM #tblPartiallyCopiedChunk)
	BEGIN
		INSERT	INTO #tblArchChunk (
			destCopyId,	destStreamNum,
			srcCopyId,	srcStreamNum,
			archChunkId, archFileId, commCellId, chunkCommCellId,
			lastChunkNumber, chunkNumber,
			volumeId, mediaId, mediaGroupId,
			segmentId,
			ChunkNoRowNumber,
			ChunkIdRowNumber
		)
		SELECT	a.DestCopyId, a.DestStreamNum,
				a.SrcCopyId, a.SrcStreamNum,
				a.ArchChunkId, a.ArchFileId, a.CommCellId, a.chunkCommCellId,
				a.lastChunkNumber, a.ChunkNumber,
				a.volumeId, a.mediaId, a.MediaGroupId,
				a.segmentId,
				0, --ROW_NUMBER() OVER (PARTITION BY  a.VolumeId, a.SrcCopyId, a.DestCopyId ORDER BY a.commCellId, a.archFileId, a.chunkNumber) AS ChunkNoRowNumber,
				DENSE_RANK() OVER (ORDER BY a.commCellId, a.archFileId, a.chunkNumber) AS ChunkIdRowNumber
				--ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.archFileId, a.commCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
		FROM	ArchChunkToSF a WITH (NOLOCK), #tblPartiallyCopiedChunk b
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.SrcStreamNum = b.StreamNum
		AND		a.SegmentId = @i_segmentId
		--AND		a.DestCopyId = b.destCopyId
		--AND		a.DestStreamNum = b.destStream
		AND		a.MediaGroupId = b.mediaGroupId
		AND		a.ArchChunkId = b.archChunkId
		AND		a.chunkCommCellId = b.chunkCommCellId
		AND		a.VolumeId = @currentSourceVolumeId
AND		a.Status = 0
		-- send limit number of chunk info
		DELETE #tblArchChunk WHERE ChunkIdRowNumber > @MAX_CHUNK_PER_REQ
		GOTO SUCCESS_EXIT
	END
	-- Refer to stored procedure archChunkToCopyGetNext.sp
	INSERT	INTO #tblArchChunk (
		destCopyId,	destStreamNum,
		srcCopyId,	srcStreamNum,
		archChunkId, archFileId, commCellId, chunkCommCellId,
		lastChunkNumber, chunkNumber,
		volumeId, mediaId, mediaGroupId,
		segmentId,
		ChunkNoRowNumber,
		ChunkIdRowNumber
	)
	SELECT	a.DestCopyId, a.DestStreamNum,
			a.SrcCopyId, a.SrcStreamNum,
			a.ArchChunkId, a.ArchFileId, a.CommCellId, a.chunkCommCellId,
			a.lastChunkNumber, a.ChunkNumber,
			a.volumeId, a.mediaId, a.MediaGroupId,
			a.segmentId,
			0, --ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.DestCopyId ORDER BY a.archFileId, a.commCellId, a.chunkNumber) AS ChunkNoRowNumber,
			DENSE_RANK() OVER (ORDER BY a.commCellId, a.archFileId, a.chunkNumber) AS ChunkIdRowNumber
			--ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.archFileId, a.commCellId ORDER BY a.ChunkCommCellId, a.archChunkId) AS ChunkIdRowNumber
	FROM	ArchChunkToSF a WITH (NOLOCK)
	WHERE	a.AdminJobId = @i_adminJobId
	AND		a.SrcCopyId = @i_archCopyId
	AND		a.SegmentId = @i_segmentId
	AND		a.VolumeId = @currentSourceVolumeId
AND		a.Status = 0
	-- send limit number of chunk info
	DELETE #tblArchChunk WHERE ChunkIdRowNumber > @MAX_CHUNK_PER_REQ
	-- If there is chunk id in the segment smaller than the current selected ones,
	--- it means there is other volume contains the smaller chunk id in current segment.
	-- This volume should be processed first, because we need process chunk id in sequence regardless volume info.
	IF EXISTS (SELECT TOP 1 VolumeId
				FROM 	ArchChunkToSF a WITH (NOLOCK)
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = @i_segmentId
				AND		a.VolumeId != @currentSourceVolumeId
AND		a.Status = 0
			)
	BEGIN
		DELETE #tblArchChunk
		FROM	#tblArchChunk b left join ArchChunkToSF a WITH (NOLOCK)
		ON		a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.SegmentId = @i_segmentId
		AND		a.VolumeId != @currentSourceVolumeId
AND		a.Status = 0
		AND		a.chunkCommCellId = b.chunkCommCellId
		AND		b.ArchChunkId > a.ArchChunkId
		WHERE	a.ArchChunkId IS NOT NULL
	END
	IF EXISTS (SELECT * FROM #tblArchChunk)
		GOTO SUCCESS_EXIT
PICK_NEXT_VOLUME:
	-- If we cannot find more chunk for current volume,
	-- Check if there is more volume from the same segment (streamreader)
	-- If there is no more volume, pick a different segment
	IF NOT EXISTS (SELECT * FROM #tblArchChunk)
	BEGIN
		SET	@oldSourceVolumeId = @currentSourceVolumeId
		SET @oldSourceMountPathId = @currentSourceMountPathId
		SET @oldSourceDeviceId = @currentSourceDeviceId
		SET @currentSourceVolumeId = 0
		SET @currentSourceMountPathId = 0
		SET @currentSourceDeviceId = 0
		SELECT TOP 1 @currentSourceVolumeId = VolumeId
		FROM	ArchChunkToSF a WITH (NOLOCK)
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.SegmentId = @i_segmentId
AND		a.Status = 0
		ORDER BY ChunkCommCellId, ArchChunkId, VolumeId
		-- There is no more volume in current segment, pick next segment directly
		IF @currentSourceVolumeId = 0
			GOTO PICK_NEXT_SEGMENT
		SELECT @currentSourceMediaId = MediaId
		FROM	MMVolume WITH (NOLOCK)
		WHERE	VolumeId = @currentSourceVolumeId
		SELECT @currentSourceMountPathId = device.MountPathId, @currentSourceDeviceId = device.DeviceId
		FROM	MMMediaSide side WITH (NOLOCK), MMMountPath mp WITH (NOLOCK), MMMountPathToStorageDevice device WITH (NOLOCK)
		WHERE	side.MediaId = @currentSourceMediaId
		AND		side.MediaSideId = mp.MediaSideId
		AND		device.MountPathId = mp.MountPathId
		-- If the new volume is different from the old one and they don't have the same device or mount path,
		-- make sure current Media Agent can access the new volume.
		-- Always check for the non-magnetic volume.
		IF (@oldSourceMountPathId = 0 OR @currentSourceMountPathId = 0)
		OR (
				@oldSourceVolumeId != @currentSourceVolumeId
				AND	(@oldSourceMountPathId != @currentSourceMountPathId
					OR @oldSourceDeviceId != @currentSourceDeviceId)
			)
		BEGIN
			delete from @getMAAndDPForVolumeResult
			insert into @getMAAndDPForVolumeResult
			exec mms2getmaanddpforvolume @currentSourceVolumeId, 0, @currentSourceMAId, 0 /*@preferredDestCopyId*/, @i_adminJobId, 1
			if not exists (select * from @getMAAndDPForVolumeResult where retCode = 0 and clientId = @currentSourceMAId)
			begin
				SET @currentSourceVolumeId = 0
				SET @currentSourceMountPathId = 0
				SET @currentSourceDeviceId = 0
			end
		END
		-- Special case when using VTL library with Type as 4
		-- The old and new media should belong to the same type VTL library
		-- However, this should not happen here in the fist place because chunk/volume should be put into different segments at the beginning.
		select @sourceLibraryVTLType = lib.VTLType
		from	MMLibrary lib with (NOLOCK), MMVolume vol with (NOLOCK), MMMedia med with (NOLOCK)
		where	vol.VolumeId = @oldSourceVolumeId
		and		vol.MediaId = med.MediaId
		and		med.LibraryId = lib.LibraryId
		IF EXISTS(select 1
				from	MMLibrary lib with (NOLOCK), MMMedia med with (NOLOCK)
				where	lib.LibraryId = med.LibraryId and med.MediaId = @currentSourceMediaId
				and		(
							(@sourceLibraryVTLType = 4 and lib.VTLType != 4)
							or
							(@sourceLibraryVTLType != 4 and lib.VTLType = 4)
						)
				)
		BEGIN
			SET @currentSourceVolumeId = 0
		END
		IF @currentSourceVolumeId > 0
		BEGIN
			UPDATE	ArchJobStreamStatus
			SET		FirstVolumeId = @currentSourceVolumeId
			WHERE	jobId = @i_adminJobId
			AND		SrcCopyId = @i_archCopyId
			AND		StreamReaderId = @i_streamReaderId
			GOTO PICK_NEXT_CHUNK
		END
		ELSE
		BEGIN
			-- Return no more chunk for current reader/Media Agent
			-- New reader will create on different Media Agent and process the segment again.
			-- For current reader, we don't want to pick a new segment.
			DELETE #tblArchChunk
			GOTO PICK_NEXT_SEGMENT
		END
	END
PICK_NEXT_SEGMENT:
	IF NOT EXISTS (SELECT * FROM #tblArchChunk)
	BEGIN
		-- Reset SKIPPED flag based on the destination stream for any failed count or time for different segment but the same destination stream num
		-- The reason for doing it within the same segment is to reduce the possiblity of deadlock.
		IF @currentSrcStreamNum > 0
		BEGIN
			UPDATE	ArchChunkToSF
SET		Status = 6
			FROM	ArchChunkToSF R, JMJobDataStats JDS
			WHERE	R.AdminJobId = @i_adminJobId
			AND		R.SrcCopyId = @i_archCopyId
			AND		R.SegmentId = @i_segmentId
ANd		R.Status IN ( 3, 0)
			AND		R.BackupJobId = JDS.JobID
			AND		R.SrcCopyId = JDS.archGrpCopyId
			AND		R.fileType = JDS.dataType
			AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (8192 | 1)) = (8192 | 1)
			UPDATE ArchChunkToSF
SET		Status = 0
			WHERE	AdminJobId = @i_adminJobId
			AND		SrcCopyId = @i_archCopyId
			AND		SegmentId != @i_segmentId
AND		Status = 3 /*CVA_CHUNK_SKIPPED*/
			-- Reset all the chunk even if the destnation copy doesn't have reservation right now.
			--AND		NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = ArchChunkToSF.AdminJobId AND segmentId = ArchChunkToSF.SegmentId)
			AND		(
						--EXISTS (SELECT Id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = ArchChunkToSF.DestCopyId AND isSnapCopy = 1)
						--OR
						SrcStreamNum = @currentSrcStreamNum
					)
			AND		(
						SkippedCount < @MAX_FAILURE_COUNT
					--	AND SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)
					--	OR
					--	SkippedCount < 12 AND SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)
					)
			AND		(
						SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
						OR
						(Modified + SkippedForSeconds) < @NOW
					)
			IF NOT EXISTS (SELECT TOP 1 SegmentId FROM ArchChunkToSF WITH (NOLOCK)
							WHERE	AdminJobId = @i_adminJobId
							AND		SegmentId > 0
							AND		SrcCopyId = @i_archCopyId
							AND		SegmentId != @i_segmentId
AND		Status = 0 /*CVA_CHUNK_POPULATED*/
							AND		(
										SrcStreamNum = @currentSrcStreamNum
									)
						)
			BEGIN
				UPDATE ArchChunkToSF
SET		Status = 0, SkippedReason = 0, SkippedForSeconds = 0, ErrorCode = 0, Modified = @now
				WHERE	adminJobId = @i_adminJobId
				AND		SegmentId > 0
				AND		SrcCopyId = @i_archCopyId
				AND		SegmentId != @i_segmentId
				AND		(
							SrcStreamNum = @currentSrcStreamNum
						)
AND		Status = 3
AND		SkippedReason = 0X13
AND		ErrorCode = 20025
			END
		END
		-- Figure out the next volume or chunk, then the next segmentId
		-- Refer to auxcopymanager logic for getnextvolume and getnextchunk
		--SET @currentSourceVolumeId = 0, @currentSourceMAId = 0, @currentSourceDPId = 0
		DECLARE @currentMediaId				int	= 0
		DECLARE @currentRecordingFormatId	int = 0
		DECLARE @currentLibraryId			int = 0
		DECLARE @currentMasterPoolId		int = 0
		DECLARE @currentMountPathId			int = 0
		DECLARE @currentDeviceId			int = 0
		DECLARE @currentDeviceControllerId	int = 0
		SELECT	@currentMediaId = media.MediaId,
				@currentRecordingFormatId = volume.RecordingFormatId,
				@currentLibraryId = CASE WHEN media.LibraryId > 0 THEN media.LibraryId ELSE media.LastWriteLibraryId END
		FROM	MMMedia media WITH (NOLOCK), MMVolume volume WITH (NOLOCK)
		WHERE	volume.volumeId = @currentSourceVolumeId
		AND		volume.MediaId = media.MediaId
		IF @currentRecordingFormatId = 10001
		BEGIN
			SELECT @currentMasterPoolId = dp.MasterPoolId,
					@currentMountPathId = path.MountPathId,
					@currentDeviceId = device.DeviceId,
					@currentDeviceControllerId = ctrl.DeviceControllerId
			FROM	MMDrivePool dp WITH (NOLOCK), MMMediaSide side WITH (NOLOCK),
					MMMountPath path WITH (NOLOCK), MMMountPathToStorageDevice device WITH (NOLOCK), MMDeviceController ctrl WITH (NOLOCK)
			WHERE	dp.DrivePoolId = @currentSourceDPId
			AND		side.MediaId = @currentMediaId
			AND		side.MediaSideId = path.MediaSideId
			AND		path.MountPathId = device.MountPathId
			AND		device.DeviceId = ctrl.DeviceId
			ANd		ctrl.ClientId = dp.ClientId
		END
		ELSE
		BEGIN
			SELECT @currentMasterPoolId = MasterPoolId,
					@currentMountPathId = 0, @currentDeviceId = 0, @currentDeviceControllerId = 0
			FROM	MMDrivePool WITH (NOLOCK)
			WHERE	DrivePoolId = @currentSourceDPId
		END
		DELETE #tblNextSegments
		DELETE @tblExcludedSegmentId
		INSERT INTO @tblExcludedSegmentId
SELECT DISTINCT SegmentId FROM ArchChunkToSF WITH (READUNCOMMITTED) WHERE AdminJobId = @i_adminJobId AND Status = 1
		INSERT INTO #tblNextSegments
		SELECT	DISTINCT a.SegmentId, a.DestCopyId, 0, 0, 0
		FROM	ArchChunkToSF a WITH (READUNCOMMITTED)
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
AND		a.Status = 0
		AND		(a.SrcStreamNum = 0 OR a.SrcStreamNum = @currentSrcStreamNum)
		DELETE #tblNextSegments
		FROM #tblNextSegments b left join @tblExcludedSegmentId c ON c.segmentId = b.SegmentId
		WHERE EXISTS (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0 AND segmentId = b.SegmentId)
		OR	c.segmentId IS NOT NULL
		IF NOT EXISTS (SELECT * FROM #tblNextSegments)
			GOTO NO_MORE_CHUNK
		DELETE #tblNextVolumes
		-- Make sure the new segment has the same destination copy or same set of parallel copies.
		IF @currentRecordingFormatId = 10001
		BEGIN
			INSERT INTO #tblNextVolumes (volumeId, mediaId, recordingFormatId, libraryId, libVTLType, MountPathId, deviceId, segmentId, ChunkIdRowNumber)
			SELECT	DISTINCT a.VolumeId, a.MediaId, 0, 0, 0, 0, 0,
					0,
					ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archFileId, a.commCellId, a.ChunkCommCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
			FROM	ArchChunkToSF a WITH (READUNCOMMITTED), #tblNextSegments b
			WHERE	a.AdminJobId = @i_adminJobId
			AND		a.SrcCopyId = @i_archCopyId
			AND		a.segmentId = b.segmentId
			--AND		a.SegmentId NOT IN (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0)
AND		a.Status = 0
			UPDATE a
			SET		RecordingFormatId = volume.RecordingFormatId,
					libraryId = CASE WHEN media.LibraryId > 0 THEN media.LibraryId ELSE media.LastWriteLibraryId END,
					mountPathId = path.MountPathId,
					deviceId = device.DeviceId
			FROM	#tblNextVolumes a,
					MMVolume volume WITH (READUNCOMMITTED), MMMedia media WITH (READUNCOMMITTED), MMMediaSide side WITH (READUNCOMMITTED),
					MMMountPath path WITH (READUNCOMMITTED), MMMountPathToStorageDevice device WITH (READUNCOMMITTED)
			WHERE	a.VolumeId = volume.VolumeId
			AND		volume.MediaId = media.MediaId
			AND		volume.RecordingFormatId = 10001
			AND		media.MediaId = side.MediaId
			AND		side.MediaSideId = path.MediaSideId
			AND		path.MountPathId = device.MountPathId
		END
		ELSE
		BEGIN
			INSERT INTO #tblNextVolumes (volumeId, mediaId, recordingFormatId, libraryId, libVTLType, MountPathId, deviceId, segmentId, ChunkIdRowNumber)
			SELECT	DISTINCT a.VolumeId, a.MediaId, 0, 0, 0, 0, 0,
					0,
					ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archFileId, a.commCellId, a.ChunkCommCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
			FROM	ArchChunkToSF a WITH (READUNCOMMITTED), #tblNextSegments b
			WHERE	a.AdminJobId = @i_adminJobId
			AND		a.SrcCopyId = @i_archCopyId
			AND		a.segmentId = b.segmentId
			--AND		a.SegmentId NOT IN (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0)
AND		a.Status = 0
			UPDATE a
			SET		RecordingFormatId = volume.RecordingFormatId,
					libraryId = CASE WHEN media.LibraryId > 0 THEN media.LibraryId ELSE media.LastWriteLibraryId END
			FROM	#tblNextVolumes a,
					MMVolume volume WITH (READUNCOMMITTED), MMMedia media WITH (READUNCOMMITTED)
			WHERE	a.VolumeId = volume.VolumeId
			AND		volume.MediaId = media.MediaId
		END
		UPDATE	a
		SET		libVTLType = lib.VTLType
		FROM	#tblNextVolumes a, MMLibrary lib WITH (READUNCOMMITTED)
		WHERE	a.LibraryId = lib.LibraryId
		-- Special case when using VTL library with Type as 4
		-- The old and new media should belong to the same type VTL library
		select @sourceLibraryVTLType = lib.VTLType
		from	MMLibrary lib with (NOLOCK)
		where	lib.LibraryId = @currentLibraryId
		IF	@sourceLibraryVTLType = 4 OR
			EXISTS (SELECT 1 FROM #tblNextVolumes WHERE libVTLType = 4)
		BEGIN
			DELETE FROM #tblNextVolumes
			WHERE	(@sourceLibraryVTLType = 4 AND libVTLType != 4)
			OR		(@sourceLibraryVTLType != 4 and libVTLType = 4)
		END
		IF NOT EXISTS (SELECT * FROM #tblNextVolumes)
			GOTO NO_MORE_CHUNK
		DECLARE @nextVolumeId	int
		DECLARE @nextChunkId	int
		DECLARE @nextSegmentId	int
		SET @nextVolumeId = 0
		SET @nextChunkId = 0
		SET @nextSegmentId = 0
		SELECT TOP 1 @nextVolumeId = volumeId
		FROM #tblNextVolumes a
		ORDER BY
			CASE WHEN a.recordingFormatId = @currentRecordingFormatId THEN 0 ELSE 1 END,
			-- Finding the next volume which can be read with the same drive pool as the current volume.
			CASE WHEN a.mountPathId = 0 AND EXISTS (SELECT * FROM MMDrivePool dp WITH (NOLOCK), MMMasterPool master WITH (NOLOCK), MMRecFmtMedTyp FMT, MMDrive drive
														WHERE a.libraryId = master.LibraryId AND master.MasterPoolId = dp.MasterPoolId AND dp.DrivePoolId = @currentSourceDPId
														AND	master.MasterPoolId = drive.MasterPoolId AND FMT.DriveTypeId = drive.DriveTypeId
AND	FMT.RecordingFormatId = a.RecordingFormatId AND (FMT.CompatibilityType & 4) > 0)
				THEN 0
				WHEN a.mountPathId > 0 AND (mountPathId = @currentMountPathId OR deviceId = @currentDeviceId)
				THEN 0
				ELSE 1 END,
			-- Finding a volume which can be read from the same library as the current volume.
			CASE WHEN libraryId = @currentLibraryId THEN 0 ELSE 1 END,
			-- Finding a volume which can be read from the same media agent as the current volume.
			CASE WHEN a.mountPathId = 0 AND EXISTS (SELECT * FROM MMDrivePool dp WITH (NOLOCK), MMMasterPool master WITH (NOLOCK), MMRecFmtMedTyp FMT, MMDrive drive
														WHERE a.libraryId = master.LibraryId AND master.MasterPoolId = dp.MasterPoolId AND dp.ClientId = @currentSourceMAId
														AND	master.MasterPoolId = drive.MasterPoolId AND FMT.DriveTypeId = drive.DriveTypeId
AND	FMT.RecordingFormatId = a.RecordingFormatId AND (FMT.CompatibilityType & 4) > 0)
				THEN 0
				WHEN a.mountPathId > 0 AND EXISTS (SELECT * FROM MMDeviceController ctrl WITH (NOLOCK) WHERE ctrl.DeviceId = a.DeviceId AND ctrl.ClientId = @currentSourceMAId
														AND ctrl.DeviceControllerEnabled = 1 and ctrl.DeviceAccessible = 1)
				THEN 0
				ELSE 1 END,
			-- Finding a volume whose first chunk ID is the smallest.
			ChunkIdRowNumber,
			-- Finding a skipped volume whose first chunk ID is the smallest.
			-- Get next segment of chunks for this stream and push them into the stream volume list - DSA only
			a.VolumeId
		-- Select next chunk
		-- Select next segment
		IF @nextVolumeId > 0
		BEGIN
			delete from @getMAAndDPForVolumeResult
			insert into @getMAAndDPForVolumeResult
			exec mms2getmaanddpforvolume @nextVolumeId, 0, @currentSourceMAId, 0 /*@preferredDestCopyId*/, @i_adminJobId, 1
			if not exists (select * from @getMAAndDPForVolumeResult where retCode = 0 and clientId = @currentSourceMAId)
			begin
				SET @nextVolumeId = 0
				-- TODO: There should be multiple candidates, if one of volumes cannot be read, we need to provide the ability to check rest of them.
				GOTO NO_MORE_CHUNK
			end
			ELSE
			BEGIN
				SELECT TOP 1 @nextChunkId = ArchChunkId, @nextSegmentId = a.segmentId
				FROM	ArchChunkToSF a WITH (NOLOCK), #tblNextSegments b
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = b.segmentId
				--AND		a.SegmentId NOT IN (SELECT segmentId FROM ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0)
AND		a.Status = 0
				AND		a.VolumeId = @nextVolumeId
				ORDER BY BackupJobId
			END
		END
		IF @nextSegmentId > 0 AND @nextVolumeId > 0
		BEGIN
			SET @i_segmentId = @nextSegmentId
			SET @currentSourceVolumeId = @nextVolumeId
			IF NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK)
							WHERE	jobId = @i_adminJobId
							AND		SrcCopyId = @i_archCopyId
							AND		StreamReaderId = @i_streamReaderId
							AND		SegmentId = @nextSegmentId
							)
			BEGIN
				DECLARE @newSegmentTotalSize TABLE (
					segmentId	int,
					DestCopyId	int,
					TotalSize	bigint
				)
				DELETE @newSegmentTotalSize
				INSERT INTO @newSegmentTotalSize
				SELECT	a.SegmentId, a.DestCopyId, SUM(a.unCompBytesSize)
				FROM	ArchChunkToSF a WITH (NOLOCK), ArchJobStreamStatus b WITH (NOLOCK)
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
				AND		a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = @nextSegmentId
AND		a.Status IN (0, 3)
				AND		b.DestCopyId = a.DestCopyId
				GROUP BY a.SegmentId, a.DestCopyId
				UPDATE	b
				SET		SegmentId = @nextSegmentId, FirstVolumeId = @nextVolumeId, FirstChunkId = 0, CommCellId = 0, TotalSizeToProcess = a.TotalSize
				FROM	@newSegmentTotalSize a, ArchJobStreamStatus b
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
				AND		b.DestCopyId = a.DestCopyId
				/*
				UPDATE	ArchJobStreamStatus
				SET		SegmentId = @nextSegmentId, FirstVolumeId = @nextVolumeId, FirstChunkId = 0, CommCellId = 0, TotalSizeToProcess = 0
				FROM	ArchJobStreamStatus b
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
				*/
			END
			ELSE
			BEGIN
				UPDATE	ArchJobStreamStatus
				SET		FirstVolumeId = @nextVolumeId, FirstChunkId = 0, CommCellId = 0
				WHERE	jobId = @i_adminJobId
				AND		SrcCopyId = @i_archCopyId
				AND		StreamReaderId = @i_streamReaderId
			END
			-- After picking the new segment, set the source and destination stream number on all the chunk within the segment
			UPDATE ArchChunkToSF
			SET 	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END,
				DestStreamNum = @currentDestStreamNum
			FROM	ArchChunkToSF a
			WHERE	a.AdminJobId = @i_AdminJobId
			AND	a.SegmentId = @nextSegmentId
			GOTO PICK_NEXT_CHUNK
		END
		-- If current source ma and drive pool cannot access the next volume, reset the value.
		-- Pipeline should be dropped, or media agent send request for exchange volume?
	END
DECLARE @l_nAFChunk INT = 0
DECLARE @L_rowcount INT = 0
IF NOT EXISTS (SELECT * FROM #tblArchChunk)
	GOTO NO_MORE_CHUNK
-- If segmentId changes for the current StreamReader, update the table
-- Need more details on what to returned. Don't think all the information from mediamanager.x is needed.
-- When the process of populate table ArchChunkToSF is done, we can fill in more details
SUCCESS_EXIT:
UPDATE #tblArchChunk
SET		MediaGroupId = c.MediaGroupId
FROM	#tblArchChunk a, ArchJobStreamStatus b WITH (NOLOCK), ArchStream c WITH (NOLOCK)
WHERE	b.jobId = @i_adminJobId
AND		b.SrcCopyId = @i_archCopyId
AND		b.StreamReaderId = @i_streamReaderId
--AND		b.DestCopyId = a.DestCopyId
AND		a.SrcCopyId = @i_archCopyId
AND		b.DestCopyId = c.ArchGroupCopyId
AND		b.DestStreamNum = c.Stream
UPDATE ArchChunkToSF
SET Status = 1, MediaGroupId = b.MediaGroupId, Modified = @NOW,
	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END,
	DestStreamNum = @currentDestStreamNum,
	SrcMAId = @currentSourceMAId, SrcDrivePoolId = @currentSourceDPId,streamReaderId = @i_streamReaderId
FROM	ArchChunkToSF a, #tblArchChunk b
WHERE	a.AdminJobId = @i_AdminJobId
AND		a.ArchChunkId = b.archChunkId
AND		a.VolumeId = b.VolumeId
AND		a.SrcCopyId = b.SrcCopyId
AND		a.commCellId = b.commCellId
AND		a.ChunkCommCellId = b.ChunkCommCellId
AND		a.SegmentId = b.SegmentId
AND		a.DestCopyId = b.DestCopyid
-- If this is the first call for getchunks, set the source and destination stream number on all the chunk within the segment
UPDATE ArchChunkToSF
SET 	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END,
	DestStreamNum = @currentDestStreamNum
WHERE	AdminJobId = @i_AdminJobId
AND	SegmentId IN (SELECT DISTINCT SegmentId FROM #tblArchChunk)
AND	(SrcStreamNum = 0 OR DestStreamNum = 0)
SET	@l_nAFChunk = (SELECT COUNT(*) FROM #tblArchChunk)
SET	@l_rowcount = (SELECT COUNT(*) FROM #tblArchChunk)
/*
SELECT	0, 0, 0, 0, 0, 0, 0,
		0, @l_nAFChunk, 0, 0,
		@l_rowcount, 0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, '', 0,
		1, 0, 0, 0, 0, 0, 0
*/
SELECT	c.appId, S.appTypeId, S.ClientId, 0, c.backupJobId, 0 /*backupStartTime*/, 0 /*backupEndTime*/,
		a.archChunkId, a.archFileId, a.commCellId, a.destCopyId,
		c.DestStreamNum, c.fileType, c.archFileCopyFlags, c.encKeyType, a.lastChunkNumber,
		a.chunkNumber, c.physicalOffset, D.ProcessedItems, c.physicalSize, c.logicalSize,
		a.volumeId, a.mediaId, a.mediaGroupId, c.fileMarkerNo,
		c.chunkCreateTime, c.chunkVersion, c.chunkPhysicalSize, c.chunkLogicalSize, S.subclientName, 0,
		b.physicalSize, b.logicalSize, b.drivePoolId, b.flags, b.encKeyType,
		(case when b.physicalSize = 0 and b.encKey = '' then 0 else 1 end),
		c.unCompBytesSize
FROM	#tblArchChunk a
		left join
		archFileCopy b WITH (NOLOCK) on b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.SrcCopyId
		left join
		ArchChunkToSF c WITH (NOLOCK) on c.AdminJobId = @i_AdminJobId and a.archChunkId = c.ArchChunkId AND a.ChunkCommCellId = c.ChunkCommCellId
								and a.archFileId = C.archFileId AND a.commCellId = c.CommCellId AND a.SrcCopyId = c.SrcCopyId
		left join
		ArchChunkToSFArchFiles D WITH (NOLOCK) ON D.AdminJobId = c.AdminJobId and D.archFileId = C.archFileId AND D.commCellId = c.CommCellId AND D.SrcCopyId = c.SrcCopyId
		left join
		APP_Application S WITH (NOLOCK) ON c.AppId = S.id
ORDER BY a.SrcCopyId, a.archChunkId, a.archFileId
IF object_id('tempdb.dbo.#tblPartiallyCopiedChunk') IS  NOT null DROP TABLE #tblPartiallyCopiedChunk
IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
IF object_id('tempdb.dbo.#tblSkippedChunks') IS  NOT null DROP TABLE #tblSkippedChunks
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
RETURN;
NO_MORE_CHUNK:
ERROR_EXIT:
SELECT	0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, '', 0,
		1, 0, 0, 0, 0, 0, 0
--SELECT 0, 0
IF object_id('tempdb.dbo.#tblPartiallyCopiedChunk') IS  NOT null DROP TABLE #tblPartiallyCopiedChunk
IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
IF object_id('tempdb.dbo.#tblSkippedChunks') IS  NOT null DROP TABLE #tblSkippedChunks
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkSynFullGetNextChunks')
	delete from GxQscripts where name = 'AMChunkSynFullGetNextChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkSynFullGetNextChunks')
	delete from GXDBVersions where aliasname = 'AMChunkSynFullGetNextChunks'
GO

insert into GXDBVersions values(2, 'AMChunkSynFullGetNextChunks',  '00010003000200140000', 'AMChunkSynFullGetNextChunks', '00010003000200140000')
GO

