

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkSynFullCreateNewReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkSynFullCreateNewReaders.sp,v $ $Id: AMChunkSynFullCreateNewReaders.sp,v 1.7.2.18 2020/11/05 19:29:10 gstoops Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AMChunkSynFullCreateNewReaders')
BEGIN
	print '>>> Drop Stored Procedure: AMChunkSynFullCreateNewReaders <<<'
	drop procedure AMChunkSynFullCreateNewReaders
END
IF EXISTS (select * from GxQscripts where name='AMChunkSynFullCreateNewReaders')
	delete from GxQscripts where name = 'AMChunkSynFullCreateNewReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkSynFullCreateNewReaders')
	delete from GXDBVersions where aliasname = 'AMChunkSynFullCreateNewReaders'
GO
print '... Creating Procedure: AMChunkSynFullCreateNewReaders'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AMChunkSynFullCreateNewReaders
  @i_adminJobId int,
  @i_jobToken varchar(128),
  @i_archGroupId int,
  @i_archCopyId int,
  @i_noOfStreams int
AS
  DECLARE @o_streamReaderId int;
  DECLARE @o_ErrorCode int;
DECLARE @NOW INTEGER;
SET		@NOW = dbo.GetUnixTime(GetUTCDate())
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
SET @o_ErrorCode = 0
-- Create new stream readers based on request from Media Agent side.
-- Use job id, copy id to figure out which segment can be readed from table ArchChunkToSF and then create new stream reader entries.
-- The new stream reader entries will be stored in table ArchJobStreamStatus with reservation status as false.
-- Later reservation logic will process such stream readers and try to allocate resources for each one of them.
-- The retrun values will be list newly created stream reader ids.
-- ArchGroupId and ArchCopyId will be used to identify which storage policy or source copy need to be processed during this call.
-- If neither of them are set, then we consider for the current job instead. The source copy will be multiple based on current job type (parallel or single stream).
	-- Remove all the processed StreamReader but wtih no valid RCId
	INSERT INTO ArchJobStreamStatusHistory (
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		ModifiedTime,
		ReservationRequestId,
		ModifiedReason
	)
	SELECT
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		dbo.GetUnixTime(getutcdate()),
		ReservationRequestId,
'DELETE DUE TO ' + CASE WHEN Status = 0x08	THEN 'STREAM RELEASED'
WHEN Status = 0x04	THEN 'STREAM FAILURE'
WHEN Status = 0x00	THEN 'RESERVATION REQUEST TIMEOUT'
								ELSE	'RESERVATION INVALID' END
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		(
Status = 0x08
				OR
Status != 0x00
				AND		(
						DestRCId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCID = DestRCId)
						OR
						SrcRCId > 0 AND FirstVolumeId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCId = SrcRCId)
						)
				OR
Status = 0x04
				OR
Status = 0x00
				AND	ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	DELETE FROM ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		(
Status = 0x08
				OR
Status != 0x00
				AND		(
						DestRCId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCID = DestRCId)
						OR
						SrcRCId > 0 AND FirstVolumeId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCId = SrcRCId)
						)
				OR
Status = 0x04
				OR
Status = 0x00
				AND	ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	DECLARE @maxStreamReaderId int
	SELECT @maxStreamReaderId = ISNULL ((SELECT MAX(StreamReaderId) FROM ArchJobStreamStatusHistory WITH (NOLOCK) WHERE JobId = @i_adminJobId AND JobToken = @i_JobToken), 0)
	-- Logic for selecting which segment to be copied first.
	DECLARE @tblStreamReaderDetails TABLE (
		SrcCopyId		int,
		SrcStreamNum	int,
		DestCopyId		int,
		DestStreamNum	int,
		SegmentId		int,
		CommCellId		int,
		FirstChunkId	int,
		ChunkCommCellId	int,
		FirstVolumeId	int,
		IsMultiWrite	int,
		RowNum			int,
		TotalSizeToProcess	bigint
	)
	DECLARE @tblSegmentIdList TABLE (
		StreamReaderId	int IDENTITY,
		SegmentId		int,
		TotalSizeToProcess	bigint
	)
	DECLARE @tblCopyDetails TABLE (
		SrcCopyId		int,
		DestCopyId		int,
		SegmentId		int,
		IsMultiWrite	int,
		TotalSizeToProcess	bigint
	)
	DECLARE @tblPartiallyCopiedChunk TABLE(
		srcCopyId		int,
		srcStreamNum	int,
		mediaGroupId	int,
		destCopyId		int,
		destStreamNum	int,
		commCellId		int,
		archChunkId		int,
		chunkCommCellId	int,
		copiedBytes		bigint,
		copiedUnCompBytes bigint,
		segmentId		int,
		primary key (srcCopyId, destCopyId, destStreamNum, segmentId, archChunkId, chunkCommCellId)
	)
	DECLARE @tblExcludedSegmentId TABLE(
		segmentId		int,
		primary key (segmentId)
	)
	DECLARE @appId int = 0
	DECLARE @maxConcurrency		int = 0
	DECLARE @noOfStreamReaders	int = 0
	SELECT TOP 1 @appId = appId FROM	ArchChunkToSF WITH (NOLOCK)  WHERE	AdminJobId = @i_adminJobId
	-- Stream number will be set by JobManager in JMBkpJobInfo table as NumStreams.
	-- If the value is 0, job will try to usse the maximum stream nubmer. The actual nubmer will be determined by additional logic.
	SELECT @maxConcurrency = NumStreams FROM JMBkpJobInfo WITH (NOLOCK) WHERE jobId = @i_adminJobId
	IF @maxConcurrency = 0
	BEGIN
		SELECT	@maxConcurrency = 2 * ISNULL(CONVERT(INT, attrVal), 0)
		FROM	APP_SubClientProp WITH (NOLOCK)
		WHERE	componentnameId = @appId AND attrName = N'sys:nStreams' and modified = 0
		AND		cs_attrName = CheckSum(N'sys:nStreams')
		IF @maxConcurrency <= 0
		BEGIN
			DECLARE @subclientPolicy INT = 0
			SELECT @subclientPolicy = ISNULL(CONVERT(INT, attrVal), 0)
			FROM	APP_SubClientProp WITH (NOLOCK)
			WHERE	componentNameId = @appId and attrName = N'Associated subclient Policy' and modified = 0
			AND		cs_attrName = CheckSum(N'Associated subclient Policy')
			IF @subclientPolicy > 0
			BEGIN
				SELECT	@maxConcurrency = 2 * ISNULL(CONVERT(INT, attrVal), 0)
				FROM	App_subclientProp WITH (NOLOCK)
				WHERE	componentnameId = @subclientPolicy AND attrName = N'sys:nStreams' and modified = 0
				AND		cs_attrName = CheckSum(N'sys:nStreams')
			END
		END
	END
	IF EXISTS (SELECT subclient.Id
					FROM	APP_Application subclient WITH (NOLOCK), APP_ClientProp client WITH (NOLOCK)
					WHERE	subclient.id = @appId
					AND		subclient.clientId = client.componentNameId
					AND		client.modified = 0
					AND		client.attrName like '%IndexingV2_VSA%'
					AND		client.attrVal = '1'
					)
	-- If the subclient is VSA V2, set the max stream number to 1
	BEGIN
		SET @maxConcurrency = 1
	    SELECT  TOP 1 @maxConcurrency = ISNULL(value, 1)
	    FROM    MMConfigs WITH (NOLOCK)
	    WHERE   name = 'MMS2_CONFIG_VSA_SYNTHETIC_FULL_MAX_STREAM'
	END
	-- Both job side and subclient or subclient policy side do not have stream number set for the job to decide stream number.
	-- Since the option will be using maximum streams, change it to default maximum number.
	IF @maxConcurrency <= 0
	BEGIN
		SET @maxConcurrency = 0
	END
	SELECT @noOfStreamReaders = COUNT(DISTINCT StreamReaderId)
	FROM ArchJobStreamStatuS WITH (NOLOCK)
	WHERE JobId = @i_adminJobId
	AND JobToken = @i_JobToken
AND	(Status = 0x01 OR Status = 0x02) /*RESERVED, NITIALIZED*/
	IF @maxConcurrency > 0 AND @maxConcurrency <= @noOfStreamReaders
	BEGIN
SET @o_ErrorCode = 20054
		DELETE FROM @tblStreamReaderDetails
		GOTO EXIT_RETURN
	END
	ELSE IF @maxConcurrency > 0 AND @i_noOfStreams > (@maxConcurrency - @noOfStreamReaders)
	BEGIN
		SET @i_noOfStreams = @maxConcurrency - @noOfStreamReaders
	END
	UPDATE	ArchChunkToSF
SET		Status = 6
	FROM	ArchChunkToSF R, JMJobDataStats JDS WITH (READUNCOMMITTED)
	WHERE	R.AdminJobId = @i_adminJobId
	AND		(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
	AND		(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
	AND		R.SegmentId > 0
	AND		NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = R.AdminJobId AND segmentId = R.SegmentId)
ANd		R.Status IN ( 3, 0)
	AND		R.BackupJobId = JDS.JobID
	AND		R.SrcCopyId = JDS.archGrpCopyId
	AND		R.fileType = JDS.dataType
	AND		R.CommCellid = JDS.CommCellId
AND		((JDS.disabled & (8192 | 1)) = (8192 | 1)
OR (JDS.disabled & (256)) > 0)
	-- Reset SKIPPED flag based on the destination stream for any failed count or time
	UPDATE ArchChunkToSF
SET		Status = 0
	WHERE	AdminJobId = @i_adminJobId
	AND		(@i_archGroupId = 0 OR ArchGroupId = @i_archGroupId)
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		SegmentId > 0
	AND		NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = ArchChunkToSF.AdminJobId AND segmentId = ArchChunkToSF.SegmentId)
AND		Status = 3 /*CVA_CHUNK_SKIPPED*/
	AND		SrcCopyId > 0
	/*
	AND		(
				SkippedCount < @MAX_FAILURE_COUNT
			--	AND SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)
			--	OR
			--	SkippedCount < 12 AND SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)
			)
	*/
	AND		(
				SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
				OR
				(Modified + SkippedForSeconds) < @NOW
			)
AND	SkippedReason != 0X13
	IF NOT EXISTS (SELECT TOP 1 SegmentId FROM ArchChunkToSF a WITH (NOLOCK)
					WHERE	AdminJobId = @i_adminJobId
					AND		SegmentId > 0
AND		Status = 0 /*CVA_CHUNK_POPULATED*/
					AND		(@i_archGroupId = 0 OR a.ArchGroupId = @i_archGroupId)
					AND		(@i_archCopyId = 0 OR a.SrcCopyId = @i_archCopyId)
					AND		a.DestCopyId > 0 /*AND a.DestStreamNum = 0 AND a.SrcStreamNum = 0*/
					AND		SegmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId)
					)
	BEGIN
		UPDATE ArchChunkToSF
SET		Status = 0, SkippedReason = 0, SkippedForSeconds = 0, ErrorCode = 0, Modified = @now
		WHERE	adminJobId = @i_adminJobId
AND		Status = 3
AND		SkippedReason = 0X13
		AND		SegmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId)
	END
	DELETE FROM @tblExcludedSegmentId
	INSERT INTO @tblExcludedSegmentId
SELECT DISTINCT SegmentId FROM ArchChunkToSF WITH (NOLOCK) WHERE AdminJobId = @i_adminJobId AND Status = 1
	INSERT INTO @tblPartiallyCopiedChunk
	SELECT c.*
	FROM	(
				SELECT	DISTINCT a.SrcCopyId, a.SrcStreamNum, a.MediaGroupId, a.DestCopyId, a.DestStreamNum, a.CommCellId, a.ArchChunkId, a.ChunkCommCellId,
						SUM(a.PhysicalSize - a.PhysicalOffset) AS copiedBytes,
						0 /*CAST((SUM( CASE WHEN a.physicalSize = 0 THEN (b.physicalSize - a.physicalOffset) ELSE (((b.physicalSize - a.physicalOffset)*@oneConstReal*a.unCompBytesSize)/ a.physicalSize)  END)) AS BIGINT) AS copiedUnCompBytes*/ size,
						a.segmentId
				FROM	ArchChunkToSF a WITH (nolock), ArchChunkToSFArchFiles b WITH (nolock)
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SegmentId > 0
AND		a.Status = 0 /*CVA_CHUNK_POPULATED*/
				AND		(@i_archGroupId = 0 OR a.ArchGroupId = @i_archGroupId)
				AND		(@i_archCopyId = 0 OR a.SrcCopyId = @i_archCopyId)
				AND		a.DestCopyId > 0
				AND		(
							EXISTS (SELECT Id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = a.DestCopyId AND isSnapCopy = 1)
							OR
							(a.DestStreamNum > 0 AND a.SrcStreamNum > 0)
						)
				AND		NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = a.AdminJobId AND segmentId = a.SegmentId)
				AND		(
							a.ArchFileId = b.ArchFileId AND
							a.CommCellId = b.CommCellId AND
							a.SrcCopyId = b.SrcCopyId AND
							-- B.physicalSize > 0 AND B.physicalSize < (A.physicalOffset + A.PhysicalSize)
							--b.ProcessedAppSize < B.TotalAppSize
							(B.TotalItems > B.ProcessedItems AND B.ProcessedItems != -1)
							--a.PhysicalOffset = b.PhysicalOffset AND
							--b.isValid = 0
						)
				GROUP BY a.SrcCopyId, a.SrcstreamNum, a.mediaGroupId, a.DestCopyId, a.destStreamNum, a.commCellId, a.archChunkId, a.ChunkCommCellId, a.segmentId
			) as c left join @tblExcludedSegmentId d ON d.segmentId = c.SegmentId
	WHERE d.segmentId IS NULL
	IF EXISTS (SELECT * FROM @tblPartiallyCopiedChunk)
	BEGIN
		-- This is list of segments that for new readers
		INSERT INTO @tblSegmentIdList
		SELECT TOP (@i_noOfStreams) SegmentId, 0
		FROM	@tblPartiallyCopiedChunk
		GROUP BY SegmentId
		ORDER BY
			--COUNT(DISTINCT DestCopyId) DESC,
			MIN(chunkCommCellId), MIN(ArchChunkId) --, SUM(copiedBytes)
		-- This is the copy info for each segment. Some copies may already have data processed partially or completely.
		-- Therefore, for each segment it may or may not have data for all the copies.
		INSERT	INTO @tblStreamReaderDetails
		SELECT	DISTINCT b.srcCopyId, b.srcStreamNum, b.destCopyId, 0 /* b.destStreamNum*/,
				a.segmentId,
				b.CommCellId, b.ArchChunkId, b.chunkCommCellId,
				0, 0,
				(a.StreamReaderId + @maxStreamReaderId) as RowNum,
				0
		FROM	@tblSegmentIdList a,
				(
					SELECT srcCopyId, srcStreamNum, destCopyId, destStreamNum, seg.segmentId, CommCellId, ArchChunkId, ChunkCommCellId,
							ROW_NUMBER() OVER (PARTITION BY srcCopyId, /*srcStreamNum,*/ destCopyId, /*destStreamNum,*/ seg.segmentId, CommCellId ORDER BY ChunkCommCellId, ArchChunkId) as num
					FROM	ArchChunkToSF chunk WITH (NOLOCK), @tblSegmentIdList seg
					WHERE	seg.SegmentId = chunk.SegmentId
					AND		chunk.AdminJobId = @i_adminJobId
AND		chunk.Status = 0 /*CVA_CHUNK_POPULATED*/
					AND		(@i_archGroupId = 0 OR chunk.ArchGroupId = @i_archGroupId)
					AND		(@i_archCopyId = 0 OR chunk.SrcCopyId = @i_archCopyId)
				) b
		WHERE	a.SegmentId = b.SegmentId
		AND		b.num = 1
		SELECT @maxStreamReaderId = MAX(RowNum) FROM @tblStreamReaderDetails
	END
	DECLARE @streamCount int
	SET @streamCount = ISNULL((SELECT COUNT(*) FROM @tblStreamReaderDetails), 0)
	-- select new segment
	IF @i_noOfStreams - @streamCount > 0
	BEGIN
		DELETE FROM @tblSegmentIdList
		INSERT INTO @tblSegmentIdList
		SELECT TOP (@i_noOfStreams - @streamCount) b.SegmentId, 0
		FROM	(SELECT a.segmentId, MIN(a.chunkCommCellId) as commCellId, MIN(a.ArchChunkId) as chunkId
				FROM	ArchChunkToSF a WITH (READUNCOMMITTED)
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SegmentId > 0
AND		a.Status = 0 /*CVA_CHUNK_POPULATED*/
				AND		(@i_archGroupId = 0 OR a.ArchGroupId = @i_archGroupId)
				AND		(@i_archCopyId = 0 OR a.SrcCopyId = @i_archCopyId)
				AND		a.DestCopyId > 0 /*AND a.DestStreamNum = 0 AND a.SrcStreamNum = 0*/
				GROUP BY a.SegmentId
				 ) b left join @tblExcludedSegmentId c ON c.segmentId = b.SegmentId
		WHERE	b.SegmentId NOT IN (SELECT SegmentId FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = @i_adminJobId)
				AND		b.SegmentId NOT IN (SELECT SegmentId FROM @tblStreamReaderDetails)
				AND		c.segmentId IS NULL
		ORDER BY
			commCellId, chunkId
		/*
		INSERT INTO @tblSegmentIdList
		SELECT TOP (@i_noOfStreams - @streamCount) a.SegmentId, 0
		FROM	ArchChunkToSF a
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SegmentId > 0
AND		a.Status = 0 /*CVA_CHUNK_POPULATED*/
		AND		(@i_archGroupId = 0 OR a.ArchGroupId = @i_archGroupId)
		AND		(@i_archCopyId = 0 OR a.SrcCopyId = @i_archCopyId)
		AND		a.DestCopyId > 0 /*AND a.DestStreamNum = 0 AND a.SrcStreamNum = 0*/
		AND		NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = a.AdminJobId AND segmentId = a.SegmentId)
		AND		a.SegmentId NOT IN (SELECT SegmentId FROM @tblStreamReaderDetails)
AND		a.SegmentId NOT IN (SELECT DISTINCT SegmentId FROM ArchChunkToSF WITH (NOLOCK) WHERE AdminJobId = @i_adminJobId AND Status = 1)
		GROUP BY a.SegmentId
		ORDER BY
			--COUNT(DISTINCT DestCopyId) DESC,
			MIN(chunkCommCellId), MIN(a.ArchChunkId) --, SUM(copiedBytes)
		*/
		INSERT	INTO @tblStreamReaderDetails
		SELECT	DISTINCT b.srcCopyId, b.srcStreamNum, b.destCopyId, 0 /*b.destStreamNum*/,
				a.segmentId,
				b.CommCellId, b.ArchChunkId, b.chunkCommCellId,
				0, 0,
				(a.StreamReaderId + @maxStreamReaderId) as RowNum,
				0
		FROM	@tblSegmentIdList a,
				(
					SELECT srcCopyId, srcStreamNum, destCopyId, destStreamNum, seg.segmentId, CommCellId, ArchChunkId, ChunkCommCellId,
							ROW_NUMBER() OVER (PARTITION BY srcCopyId, /*srcStreamNum,*/ destCopyId, /*destStreamNum,*/ seg.segmentId, CommCellId ORDER BY ChunkCommCellId, ArchChunkId) as num
					FROM	ArchChunkToSF chunk WITH (NOLOCK), @tblSegmentIdList seg
					WHERE	seg.SegmentId = chunk.SegmentId
					AND		chunk.AdminJobId = @i_adminJobId
AND		chunk.Status = 0 /*CVA_CHUNK_POPULATED*/
					AND		(@i_archGroupId = 0 OR chunk.ArchGroupId = @i_archGroupId)
					AND		(@i_archCopyId = 0 OR chunk.SrcCopyId = @i_archCopyId)
				) b
		WHERE	a.SegmentId = b.SegmentId
		AND		b.num = 1
		DECLARE @currentSegmentId INT = 0
		DECLARE @currentCopyId INT = 0
		DECLARE @currentSrcStreamNum INT = 0
		DECLARE @currentStreamCount	INT = 0
		SELECT TOP 1 @currentSegmentId = SegmentId, @currentCopyId = SrcCopyId FROM @tblStreamReaderDetails WHERE	SegmentId > 0 AND SrcStreamNum = 0
		WHILE (@currentSegmentId > 0)
		BEGIN
			SELECT @currentStreamCount = COUNT(DISTINCT StreamReaderId)
			FROM	ArchJobStreamStatus WITH (NOLOCK)
			WHERE	JobId = @i_adminJobId
			AND		SrcStreamNum > 0
			--AND		DestStreamNum = 0
			AND		SrcCopyId = @currentCopyId
			SELECT	TOP 1 @currentSrcStreamNum = stream
			FROM	ArchStream WITH (NOLOCK)
			WHERE	archGroupCopyId = @currentCopyId
			AND		stream NOT IN (
									SELECT	SrcStreamNum
									FROM	ArchJobStreamStatus WITH (NOLOCK)
									WHERE	JobId = @i_adminJobId
									AND		SrcStreamNum > 0
									--AND		DestStreamNum = 0
									AND		SrcCopyId =  @currentCopyId
								)
			ORDER BY stream
			IF @currentSrcStreamNum = 0
				SET @currentSrcStreamNum = @noOfStreamReaders + 1
			UPDATE @tblStreamReaderDetails SET SrcStreamNum = @currentSrcStreamNum
			WHERE SegmentId = @currentSegmentId AND SrcCopyId = @currentCopyId
			SET @currentSegmentId = 0
			SET @currentCopyId = 0
			SET @currentSrcStreamNum = 0
			SET @currentStreamCount = 0
			SELECT TOP 1 @currentSegmentId = SegmentId, @currentCopyId = SrcCopyId FROM @tblStreamReaderDetails WHERE	SegmentId > 0 AND SrcStreamNum = 0
		END
	END
	UPDATE 	a
	SET		TotalSizeToProcess = ISNULL((SELECT	SUM(chunk.unCompBytesSize)
										FROM	ArchChunkToSF chunk WITH (READUNCOMMITTED)
										WHERE	chunk.AdminJobId = @i_adminJobId
AND		chunk.Status IN (0, 3)
										AND		a.SegmentId = chunk.SegmentId
										AND		a.SrcCopyId = chunk.srcCopyId
										AND		a.DestCopyId = chunk.destCopyId), 0)
	FROM	@tblStreamReaderDetails a
	--Do not populate volumeId for snap data
	UPDATE @tblStreamReaderDetails
	SET		FirstVolumeId = ISNULL(b.VolumeId, 0)
	FROM	@tblStreamReaderDetails a, ArchChunk b WITH (NOLOCK), ArchGroupCopy AGC WITH(READUNCOMMITTED)
	WHERE	a.ChunkCommCellId = b.CommcellId
	AND		a.FirstChunkId = b.Id
	AND		a.SrcCopyId = AGC.id
	AND		(AGC.isSnapCopy = 0 OR ( AGC.isSnapCopy = 1 AND a.SrcStreamNum = 1))   --StreamId will be greater than 1 for snap data
	UPDATE @tblStreamReaderDetails
SET		IsMultiWrite = CASE WHEN b.Flags & 2048 > 0 THEN 1 ELSE 0 END
	FROM	@tblStreamReaderDetails a, ArchGroupCopy b WITH (NOLOCK)
	WHERE	a.DestCopyId > 0
	AND		a.DestCopyId = b.Id
EXIT_RETURN:
	IF EXISTS (SELECT * FROM @tblStreamReaderDetails)
	BEGIN
		INSERT INTO ArchJobStreamStatus (
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			ModifiedTime,
			ReservationRequestId,
			TotalSizeToProcess, TotalSizeProcessed
		)
		SELECT
			@i_adminJobId, @i_jobToken,
			SrcCopyId, SrcStreamNum, 0, 0, 0, 0,
			DestCopyId, DestStreamNum, 0, 0, 0, 0,
			RowNum,
			SegmentId, FirstVolumeId, FirstChunkId, ChunkCommCellId,
			0 /*NOT RESERVED, NOT INITIALIZED*/,
			dbo.GetUnixTime(getutcdate()),
			0,
			TotalSizeToProcess, 0
		FROM	@tblStreamReaderDetails
		--WHERE	(@i_archCopyId = 0 OR @i_archCopyId = SrcCopyId)
		INSERT INTO ArchJobStreamStatusHistory (
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			ModifiedTime,
			ReservationRequestId,
			ModifiedReason
		)
		SELECT
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			dbo.GetUnixTime(getutcdate()),
			ReservationRequestId,
			'CREATE'
		FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
		WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
AND		Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
		SELECT	DISTINCT StreamReaderId, 0
		FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
		WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
AND		Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
	END
	ELSE
	BEGIN
		SELECT 0, @o_ErrorCode
	END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkSynFullCreateNewReaders')
	delete from GxQscripts where name = 'AMChunkSynFullCreateNewReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkSynFullCreateNewReaders')
	delete from GXDBVersions where aliasname = 'AMChunkSynFullCreateNewReaders'
GO

insert into GXDBVersions values(2, 'AMChunkSynFullCreateNewReaders',  '00010007000200180000', 'AMChunkSynFullCreateNewReaders', '00010007000200180000')
GO

