

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkReplicateSnapGetNextChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkReplicateSnapGetNextChunks.sp,v $ $Id: AMChunkReplicateSnapGetNextChunks.sp,v 1.1.4.16 2020/12/31 00:30:46 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AMChunkReplicateSnapGetNextChunks')
BEGIN
	print '>>> Drop Stored Procedure: AMChunkReplicateSnapGetNextChunks <<<'
	drop procedure AMChunkReplicateSnapGetNextChunks
END
IF EXISTS (select * from GxQscripts where name='AMChunkReplicateSnapGetNextChunks')
	delete from GxQscripts where name = 'AMChunkReplicateSnapGetNextChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateSnapGetNextChunks')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateSnapGetNextChunks'
GO
print '... Creating Procedure: AMChunkReplicateSnapGetNextChunks'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AMChunkReplicateSnapGetNextChunks
  @i_adminJobId int,
  @i_archGroupId int,
  @i_archCopyId int,
  @i_streamReaderId int,
  @i_segmentId int,
  @i_archFileId int,
  @i_commCellid int
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;				
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_srcEncKeyType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_chunkHwEncKey varchar(114);
  DECLARE @o_extraFlags integer;
  DECLARE @o_destPhysicalSize bigint;
  DECLARE @o_destLogicalSize bigint;
  DECLARE @o_destDrivePoolId integer;
  DECLARE @o_destAFCopyFlags integer;
  DECLARE @o_destEncKeyType integer;
  DECLARE @o_encKeyCreated integer;
  DECLARE @o_unCompBytesSize bigint;
  DECLARE @o_destSIDBStoreId integer;
  DECLARE @o_errorCode integer;
/* below defines are from enum : OpwindowRuleLevel*/
IF @i_streamReaderId IS NULL
	SET @i_streamReaderId = 0
IF @i_archCopyId IS NULL
	SET @i_archCopyId = 0
IF @i_segmentId IS NULL
	SET @i_segmentId = 0
-- Select next chunk list based on the given stream reader id.
-- Use job id, copy id and stream reader id to identify current in use reader from table ArchJobStreamStatus.
-- It will give current segmentId, which can be used to figure out the next chunk/volume list from table ArchChunkToReplicate.
-- The return value will be list of uncopied chunks for the given stream reader.
DECLARE @NOW INTEGER;
SET		@NOW = dbo.GetUnixTime(GetUTCDate())
IF @i_streamReaderId = 0 AND @i_segmentId = 0
	GOTO ERROR_EXIT
DECLARE @MAX_CHUNK_PER_REQ	INT = 20
SET @MAX_CHUNK_PER_REQ = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMS2_CONFIG_STRING_AUXCOPY_MAX_CHUNKS_PER_COPY_REQ'), 20)
DECLARE @MAX_FAILURE_COUNT INT = 3
SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
DECLARE @commCellId				integer = 0
DECLARE @isMultiCopies			integer = 0
DECLARE @currentSourceVolumeId	integer = 0
DECLARE @currentSourceMAId		integer = 0
DECLARE @currentSourceDPId		integer = 0
DECLARE @currentReservationId	integer = 0
DECLARE @currentRCId			integer = 0
DECLARE @currentDestStreamNum	integer = 0
DECLARE @currentSrcStreamNum	integer = 0
DECLARE @currentSourceMediaId	integer = 0
DECLARE @currentSourceMountPathId	integer = 0
DECLARE @currentSourceDeviceId		integer = 0
DECLARE @oldSourceVolumeId		integer = 0
DECLARE @oldSourceMountPathId	integer = 0
DECLARE @oldSourceDeviceId		integer = 0
DECLARE @isDedupeEnabledOnAnyDestCopy integer = 0
DECLARE @pickNextChunkOfAF		integer = 0
DECLARE @maxChunkNumber			integer = 0
DECLARE @destCopyId				integer = 0
DECLARE @taskId 				integer = 0
DECLARE @errorCode				INTEGER = 0
DECLARE @OPWindowClientId		INTEGER = 0
DECLARE @OPWindowRetCode		INTEGER = -1
SELECT TOP 1
		@i_streamReaderId = CASE WHEN @i_streamReaderId = 0 THEN StreamReaderId ELSE @i_streamReaderId END,
		@i_segmentId = CASE WHEN @i_segmentId = 0 THEN SegmentId ELSE @i_segmentId END,
		@i_archCopyId = CASE WHEN @i_archCopyId = 0 THEN SrcCopyId ELSE @i_archCopyId END,
		@currentReservationId = SrcReservationId,
		@currentRCId = SrcRCId,
		@currentSourceVolumeId = FirstVolumeId,
		@currentSourceMAId = SrcMAId,
		@currentSourceDPId = SrcDrivePoolId,
		@currentDestStreamNum = DestStreamNum,
		@currentSrcStreamNum = SrcStreamNum,
		@destCopyId = DestCopyId
FROM	ArchJobStreamStatus WITH (NOLOCK)
WHERE	JobId = @i_adminJobId
AND		(SrcCopyId = @i_archCopyId OR 0 = @i_archCopyId)
AND		(StreamReaderId = @i_streamReaderId OR @i_streamReaderId = 0)
AND		(SegmentId = @i_segmentId OR @i_segmentId = 0)
--AND		(Status & STREAM_READER_STATUS_RESERVED /*reserved*/) > 0
ORDER BY jobId, StreamReaderId, CommCellId, FirstChunkId
--NetApp SnapVault or SnapMirror are not supported yet
IF EXISTS(SELECT	*
		  FROM		archGroupCopy AGC
		  WHERE		AGC.id = @destCopyId
					AND AGC.isSnapCopy = 1
AND (AGC.extendedFlags & 512) = 0)
	GOTO NO_MORE_CHUNK
IF @currentSourceMAId = 0
	GOTO ERROR_EXIT
IF @currentSourceMAId > 0
BEGIN
	SET @taskId = ISNULL((SELECT TOP 1 jobReq.taskId FROM TM_Jobs jobs WITH(NOLOCK) INNER JOIN TM_JobRequest jobReq WITH(NOLOCK)
                                        ON jobs.jobId = @i_adminJobId AND jobs.jobRequestId = jobReq.jobRequestId ),0)
	SET @OPWindowRetCode = 	dbo.IsOperationAllowedV2(16 /*OPERATION_AUX_COPY*/, 2 /*CommCellId*/, @currentSourceMAId, 0 /*AppType*/, 0 /*InstanceId*/, 0 /*BackupsetId*/, 0 /*SubClientId*/,@taskId)
	IF( @OPWindowRetCode <> -1)
	BEGIN
		--  goto error_exit
		SET @OPWindowClientId = @currentSourceMAId
SET @errorCode =  CASE WHEN @OPWindowRetCode = 0 THEN 84001
WHEN @OPWindowRetCode = 1 THEN 84002
WHEN @OPWindowRetCode = 2 THEN 84003
WHEN @OPWindowRetCode = 3 THEN 84004
WHEN @OPWindowRetCode = 4 THEN 84005
WHEN @OPWindowRetCode = 5 THEN 84006
WHEN @OPWindowRetCode = 6 THEN 84007
WHEN @OPWindowRetCode = 7 THEN 84008
WHEN @OPWindowRetCode = 8 THEN 84009
ELSE 84001 END
		GOTO ERROR_EXIT
	END
END
DECLARE @tblNextChunks	TABLE (archChunkId bigint, chunkCommCellId INT, chunkIdRowNumber INT)
DECLARE @tblArchChunk TABLE
(
	destCopyId			integer,
	destStreamNum		integer,
	srcCopyId			integer,
	srcStreamNum		integer,
	archChunkId			bigint,
	archFileId			integer,
	commCellId			integer,
	chunkCommCellId		integer,
	lastChunkNumber		integer,
	chunkNumber			integer,
	volumeId			integer,
	mediaId				integer,
	mediaGroupId		integer,
	segmentId			integer,
	appId				integer,
	extraFlags			integer,
	ChunkNoRowNumber	integer,
	ChunkIdRowNumber	integer,
	primary key (archChunkId, archFileId, commCellId, chunkCommCellId, destCopyId)
)
DECLARE @tblDestCopyList TABLE
(
	destCopyId			integer
)
INSERT INTO @tblDestCopyList
SELECT DISTINCT DestCopyId
FROM	ArchJobStreamStatus WITH (NOLOCK)
WHERE	JobId = @i_adminJobId
AND		SrcCopyId = @i_archCopyId
AND		StreamReaderId = @i_streamReaderId
--AND		SegmentId = @i_segmentId
AND		Status = 0x02
PICK_NEXT_CHUNK:
	-- Refer to stored procedure archChunkToCopyGetNext.sp
	INSERT	INTO @tblArchChunk (
		destCopyId,	destStreamNum,
		srcCopyId,	srcStreamNum,
		archChunkId, archFileId, commCellId, chunkCommCellId,
		lastChunkNumber, chunkNumber,
		volumeId, mediaId, mediaGroupId,
		segmentId,
		appId,
		extraFlags,
		ChunkNoRowNumber,
		ChunkIdRowNumber
	)
	SELECT	a.DestCopyId, a.DestStreamNum,
			a.SrcCopyId, a.SrcStreamNum,
			a.ArchChunkId, a.ArchFileId, a.CommCellId, a.chunkCommCellId,
			a.lastChunkNumber, a.ChunkNumber,
			a.volumeId, a.mediaId, a.MediaGroupId,
			a.segmentId,
			a.appId,
			a.extraFlags,
			0, --ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.DestCopyId ORDER BY a.archFileId, a.commCellId, a.chunkNumber) AS ChunkNoRowNumber,
			DENSE_RANK() OVER (ORDER BY a.commCellId, a.backupJobId, a.archFileId, a.chunkNumber) AS ChunkIdRowNumber
			--ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.archFileId, a.commCellId ORDER BY a.ChunkCommCellId, a.archChunkId) AS ChunkIdRowNumber
	FROM	ArchChunkToReplicate a WITH (NOLOCK)
	WHERE	a.AdminJobId = @i_adminJobId
	AND		a.SrcCopyId = @i_archCopyId
	AND		a.SegmentId = @i_segmentId
	AND		a.SrcMAId = @currentSourceMAId
AND		a.Status = 0
	AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
	IF EXISTS (SELECT 1
				FROM	@tblArchChunk
WHERE	extraFlags & 128 > 0)
	BEGIN
		IF EXISTS (SELECT	1
			FROM	@tblArchChunk T, archChunkToReplicate R WITH (READUNCOMMITTED)
			WHERE	R.adminJobId = @i_adminJobId
					AND		R.SrcCopyId = T.SrcCopyId
					AND		R.DestCopyId = T.DestCopyId
					AND		R.appId = T.AppId
AND		R.extraFlags & 128 > 0
					AND		R.archFileId < T.archFileId
AND		R.Status IN ( 3, 5 )
			)
		BEGIN
			DECLARE @appIdTable TABLE(appId INT)
			-- If some appIds are marked as skipped, then mark newer jobs of those appIds as skipped
			UPDATE	ACR
			SET		DestStreamNum= B.DestStreamNum,
					SrcMAId = B.SrcMAId,
					MediaGroupId = B.MediaGroupId,
					SkippedCount = B.SkippedCount,
					SkippedForSeconds = B.SkippedForSeconds,
					SkippedReason = B.SkippedReason,
					ErrorCode = B.ErrorCode,
					Modified = B.Modified,
Status = 3,
					StreamReaderId = B.StreamReaderId
			OUTPUT	DELETED.AppId INTO @appIdTable
			FROM	ArchChunkToReplicate ACR INNER JOIN
					(
						SELECT	DISTINCT ACR.appId,
										MAX(ACR.DestStreamNum) DestStreamNum,
										MAX(ACR.SrcMAId) SrcMAId,
										MAX(ACR.MediaGroupId) MediaGroupId,
										MAX(ACR.SkippedCount) SkippedCount,
										MAX(ACR.SkippedForSeconds) SkippedForSeconds,
										MAX(ACR.SkippedReason) SkippedReason,
										MAX(ACR.ErrorCode) ErrorCode,
										MAX(ACR.Modified) Modified,
										MAX(ACR.StreamReaderId) StreamReaderId
						FROM	@tblArchChunk T, ArchChunkToReplicate ACR
						WHERE	ACR.AdminJobId = @i_adminJobId
								AND ACR.DestCopyId = @destCopyId
								AND ACR.SrcMAId > 0
								AND ACR.fileType = 1
								AND	ACR.SrcCopyId = T.SrcCopyId
								AND	ACR.DestCopyId = T.DestCopyId
								AND	ACR.appId = T.AppId
AND	ACR.extraFlags & 128 > 0
AND ACR.Status IN ( 3, 5 )
						GROUP BY ACR.appId
					) B ON ACR.appId = B.appId
			WHERE	ACR.AdminJobId = @i_adminJobId
					AND ACR.DestCopyId = @destCopyId
					AND ACR.fileType = 1
AND ACR.Status = 0
			DELETE  AC
			FROM	@tblArchChunk AC, @appIdTable A
			WHERE	AC.AppId = A.AppId
			IF NOT EXISTS(SELECT 1
						  FROM @tblArchChunk A)
				GOTO PICK_NEXT_CHUNK
		END
	END
DELETE FROM @tblNextChunks
INSERT INTO @tblNextChunks
SELECT	DISTINCT TOP(@MAX_CHUNK_PER_REQ) archChunkId, chunkCommCellId, ChunkIdRowNumber
			FROM	@tblArchChunk
ORDER BY ChunkIdRowNumber
IF EXISTS (SELECT * FROM @tblArchChunk)
	GOTO SUCCESS_EXIT
GOTO NO_MORE_CHUNK
DECLARE @l_nAFChunk INT = 0
DECLARE @L_rowcount INT = 0
IF NOT EXISTS (SELECT * FROM @tblArchChunk)
	GOTO NO_MORE_CHUNK
-- If segmentId changes for the current StreamReader, update the table
-- Need more details on what to returned. Don't think all the information from mediamanager.x is needed.
-- When the process of populate table ArchChunkToReplicate is done, we can fill in more details
SUCCESS_EXIT:
IF EXISTS(SELECT 1 FROM @tblArchChunk C, SMVolume SMV WITH (READUNCOMMITTED) WHERE C.VolumeId = SMV.SMVolumeID AND SMV.VolumeFlags & CAST( 4294967296 AS BIGINT) > 0)
BEGIN
	INSERT	INTO @tblArchChunk (
		destCopyId,	destStreamNum,
		srcCopyId,	srcStreamNum,
		archChunkId, archFileId, commCellId, chunkCommCellId,
		lastChunkNumber, chunkNumber,
		volumeId, mediaId, mediaGroupId,
		segmentId,
		appId,
		extraFlags,
		ChunkNoRowNumber,
		ChunkIdRowNumber
	)
	SELECT	a.DestCopyId, a.DestStreamNum,
			a.SrcCopyId, a.SrcStreamNum,
			a.ArchChunkId, a.ArchFileId, a.CommCellId, a.chunkCommCellId,
			a.lastChunkNumber, a.ChunkNumber,
			a.volumeId, a.mediaId, a.MediaGroupId,
			a.segmentId,
			a.appId,
			a.extraFlags,
			0, --ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.DestCopyId ORDER BY a.archFileId, a.commCellId, a.chunkNumber) AS ChunkNoRowNumber,
			DENSE_RANK() OVER (ORDER BY a.commCellId, a.backupJobId, a.archFileId, a.chunkNumber) AS ChunkIdRowNumber
			--ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.archFileId, a.commCellId ORDER BY a.ChunkCommCellId, a.archChunkId) AS ChunkIdRowNumber
	FROM	@tblArchChunk C
INNER JOIN SMVolume SMV WITH (READUNCOMMITTED) ON C.VolumeId = SMV.SMVolumeID AND SMV.VolumeFlags & CAST( 4294967296 AS BIGINT) > 0
			INNER JOIN SMVolume SMV2 WITH (READUNCOMMITTED) ON SMV.MasterJobId = SMV2.MasterJobId,
			ArchChunkToReplicate a WITH (READUNCOMMITTED)
	WHERE	a.AdminJobId = @i_adminJobId
	AND		a.SrcCopyId = @i_archCopyId
	AND		a.SegmentId = @i_segmentId
	AND		a.SrcMAId = @currentSourceMAId
AND		a.Status = 0
	AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
	AND		a.archFileId = SMV2.archFileId
	AND		a.commCellId = SMV2.commCellId
	AND		a.SrcCopyId = SMV2.CopyId
	AND		a.VolumeId = SMV2.SMVolumeId
	AND		NOT EXISTS (SELECT	1
						FROM	@tblArchChunk CI
						WHERE	C.archChunkId = CI.archChunkId
								AND C.archFileId = CI.archFileId
								AND C.commCellId = CI.commCellId
								AND C.chunkCommCellId = CI.chunkCommCellId
								AND C.destCopyId = CI.destCopyId)
END
UPDATE @tblArchChunk
SET		MediaGroupId = c.MediaGroupId
FROM	@tblArchChunk a, ArchJobStreamStatus b WITH (NOLOCK), ArchStream c WITH (NOLOCK)
WHERE	b.jobId = @i_adminJobId
AND		b.SrcCopyId = @i_archCopyId
AND		b.StreamReaderId = @i_streamReaderId
AND		b.DestCopyId = a.DestCopyId
AND		a.SrcCopyId = @i_archCopyId
AND		b.DestCopyId = c.ArchGroupCopyId
AND		b.DestStreamNum = c.Stream
UPDATE ArchChunkToReplicate
SET Status = 1, Modified = @NOW, streamReaderId = @i_streamReaderId
FROM	ArchChunkToReplicate a, @tblArchChunk b
WHERE	a.AdminJobId = @i_AdminJobId
AND		a.ArchChunkId = b.archChunkId
AND		a.VolumeId = b.VolumeId
AND		a.SrcCopyId = b.SrcCopyId
AND		a.archFileId = b.archFileId
AND		a.commCellId = b.commCellId
AND		a.ChunkCommCellId = b.ChunkCommCellId
AND		a.SegmentId = b.SegmentId
AND		a.DestCopyId = b.DestCopyid
SET	@l_nAFChunk = (SELECT COUNT(*) FROM @tblArchChunk)
SET	@l_rowcount = (SELECT COUNT(*) FROM @tblArchChunk)
/*
SELECT	0, 0, 0, 0, 0, 0, 0,
		0, @l_nAFChunk, 0, 0,
		@l_rowcount, 0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, '', 0,
		1, 0, 0, 0, 0, 0, 0
*/
SELECT	c.appId, 0, 0, 0, c.backupJobId, C.PhysicalStartOffset /*backupStartTime - Master Job id is sent for VSA V2*/, 0 /*backupEndTime*/,
		a.archChunkId, a.archFileId, a.commCellId, a.destCopyId,
		c.DestStreamNum, c.fileType, c.archFileCopyFlags, c.encKeyType, a.lastChunkNumber,
		a.chunkNumber, c.physicalOffset, c.logicalOffset, c.physicalSize, c.logicalSize,
		a.volumeId, a.mediaId, a.mediaGroupId, c.fileMarkerNo,
		c.chunkCreateTime, c.chunkVersion, c.chunkPhysicalSize, c.chunkLogicalSize, c.chunkHwEncKey,
c.extraFlags & (256|512),
		b.physicalSize, b.logicalSize, b.drivePoolId, b.flags, b.encKeyType,
		(case when b.physicalSize = 0 and b.encKey = '' then 0 else 1 end) encKeyCreated,
		c.unCompBytesSize, 0 destSIDBStoreId, 0 errorCode
FROM	@tblArchChunk a
		INNER join
		archFileCopy b WITH (NOLOCK) on b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.destCopyId
		left join
		ArchChunkToReplicate c WITH (NOLOCK) on c.AdminJobId = @i_AdminJobId and a.archChunkId = c.ArchChunkId AND a.ChunkCommCellId = c.ChunkCommCellId
												and a.archFileId = c.archFileId AND a.commCellId = c.commCellId AND a.destCopyId = c.DestCopyId
		left join
		@tblDestCopyList destCopy ON destCopy.destCopyId = a.destCopyId
ORDER BY a.destCopyId, a.archChunkId, a.archFileId
RETURN;
NO_MORE_CHUNK:
ERROR_EXIT:
SELECT  0, 0, @OPWindowClientId, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, '', 0,
		1, 0, 0, 0, 0, 0, 0, 0, @errorCode
--SELECT 0, 0
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkReplicateSnapGetNextChunks')
	delete from GxQscripts where name = 'AMChunkReplicateSnapGetNextChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateSnapGetNextChunks')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateSnapGetNextChunks'
GO

insert into GXDBVersions values(2, 'AMChunkReplicateSnapGetNextChunks',  '00010001000400160000', 'AMChunkReplicateSnapGetNextChunks', '00010001000400160000')
GO

