

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkReplicateRemoveUnreservedReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkReplicateRemoveUnreservedReaders.sp,v $ $Id: AMChunkReplicateRemoveUnreservedReaders.sp,v 1.8.2.7 2019/07/30 15:46:21 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AMChunkReplicateRemoveUnreservedReaders')
BEGIN
	print '>>> Drop Stored Procedure: AMChunkReplicateRemoveUnreservedReaders <<<'
	drop procedure AMChunkReplicateRemoveUnreservedReaders
END
IF EXISTS (select * from GxQscripts where name='AMChunkReplicateRemoveUnreservedReaders')
	delete from GxQscripts where name = 'AMChunkReplicateRemoveUnreservedReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateRemoveUnreservedReaders')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateRemoveUnreservedReaders'
GO
print '... Creating Procedure: AMChunkReplicateRemoveUnreservedReaders'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AMChunkReplicateRemoveUnreservedReaders
  @i_adminJobId int,
  @i_streamReaderIdList XML,
  @i_dummy INTEGER
AS
  DECLARE @o_noOfDeletedStreamReaders int;
  DECLARE @o_ErrorCode int;
SET @o_noOfDeletedStreamReaders = 0
SET @o_ErrorCode = 0
DECLARE @tblStreamReaders TABLE (Id int, destCopyId int)
INSERT INTO @tblStreamReaders
SELECT DISTINCT isnull(params.value('@id', 'int'), 0) as StreamReaderId, 0
FROM	@i_streamReaderIdList.nodes('/StreamReaderList/StreamReader') AS R(params)
SELECT @o_noOfDeletedStreamReaders = COUNT(*) FROM @tblStreamReaders WHERE Id > 0
IF @o_noOfDeletedStreamReaders = 0
BEGIN
	INSERT INTO @tblStreamReaders
	SELECT DISTINCT StreamReaderId, DestCopyId
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId
	AND		(
Status != 0x00
			AND		(
					DestRCId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCID = DestRCId)
					OR
					SrcRCId > 0 AND FirstVolumeId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCId = SrcRCId)
					)
			OR
Status = 0x00
			OR
Status = 0x04
			)
	INSERT INTO ArchJobStreamStatusHistory (
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		ModifiedTime,
		ReservationRequestId,
		ModifiedReason
	)
	SELECT
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		stream.DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		dbo.GetUnixTime(getutcdate()),
		ReservationRequestId,
		'DELETE'
	FROM	ArchJobStreamStatus stream WITH (NOLOCK), @tblStreamReaders b
	WHERE	stream.JobId = @i_adminJobId
	AND		stream.StreamReaderId = b.Id
	AND		stream.DestCopyId = b.DestCopyId
AND		Status != 0x00 AND Status != 0x04
	DELETE stream
	FROM	ArchJobStreamStatus stream, @tblStreamReaders b
	WHERE	stream.JobId = @i_adminJobId
	AND		stream.StreamReaderId = b.Id
	AND		stream.DestCopyId = b.DestCopyId
	SELECT @o_noOfDeletedStreamReaders = COUNT(distinct Id) FROM @tblStreamReaders WHERE Id > 0
END
ELSE
BEGIN
	DECLARE @tblSrcDestStreamReaders TABLE (Id int, srcCopyId int, destCopyId int)
	INSERT INTO @tblSrcDestStreamReaders
	SELECT DISTINCT stream.StreamReaderId, stream.srcCopyId, stream.destCopyId
	FROM	@tblStreamReaders tmpTbl, ArchJobStreamStatus stream
	WHERE	tmpTbl.Id = stream.StreamReaderId
	AND		stream.JobId = @i_adminJobId
AND	 	stream.Status IN (0x04)
	IF EXISTS (SELECT 1 FROM @tblSrcDestStreamReaders)
	BEGIN
		DELETE a
		FROM ArchJobStreamStatusHistory a, @tblSrcDestStreamReaders b
		WHERE	a.JobId = @i_adminJobId
		AND		a.StreamReaderId = b.Id
		AND		a.SrcCopyId = b.SrcCopyId
		AND		a.DestCopyId = b.DestCopyId
		AND		b.Id > 0
		DELETE stream
		FROM	ArchJobStreamStatus stream, @tblSrcDestStreamReaders b
		WHERE	stream.JobId = @i_adminJobId
		AND		stream.StreamReaderId = b.Id
		AND		stream.SrcCopyId = b.SrcCopyId
		AND		stream.DestCopyId = b.DestCopyId
	END
END
EXIT_RETURN:
	SELECT @o_noOfDeletedStreamReaders, @o_ErrorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkReplicateRemoveUnreservedReaders')
	delete from GxQscripts where name = 'AMChunkReplicateRemoveUnreservedReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateRemoveUnreservedReaders')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateRemoveUnreservedReaders'
GO

insert into GXDBVersions values(2, 'AMChunkReplicateRemoveUnreservedReaders',  '00010008000200070000', 'AMChunkReplicateRemoveUnreservedReaders', '00010008000200070000')
GO

