

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkReplicateGetReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkReplicateGetReaders.sp,v $ $Id: AMChunkReplicateGetReaders.sp,v 1.4.12.4 2018/03/22 01:18:53 jiechen Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AMChunkReplicateGetReaders <<<'

IF EXISTS (select * from sysobjects where name='AMChunkReplicateGetReaders')
	drop procedure AMChunkReplicateGetReaders
IF EXISTS (select * from GxQscripts where name='AMChunkReplicateGetReaders')
	delete from GxQscripts where name = 'AMChunkReplicateGetReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateGetReaders')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateGetReaders'
GO
print '... Creating Procedure: AMChunkReplicateGetReaders'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AMChunkReplicateGetReaders
  @i_adminJobId int,
  @i_archGroupId int,
  @i_archCopyId int,
  @i_streamReaderId int,
  @i_status int,
  @i_markInited int
AS
  DECLARE @o_StreamReaderId int;
  DECLARE @o_Status int;
  DECLARE @o_StoragePolicyId int;
  DECLARE @o_StoragePolicyName NVARCHAR(64)
  DECLARE @o_SrcCopyId int;
  DECLARE @o_SrcCopyName NVARCHAR(64);
  DECLARE @o_SrcCopyFlags int;
  DECLARE @o_SrcCopyDedupeFlags int;
  DECLARE @o_SrcStreamNum int;
  DECLARE @o_SrcMediaAgentId int;
  DECLARE @o_SrcMediaAgentName NVARCHAR(255);
  DECLARE @o_SrcDrivePoolId int;
  DECLARE @o_SrcDrivePoolType int;
  DECLARE @o_SrcMediaGroupId int;
  DECLARE @o_SrcReservationId int;
  DECLARE @o_SrcRCId int;
  DECLARE @o_SrcMaxMultiplex int;
  DECLARE @o_DestCopyId int;
  DECLARE @o_DestCopyName NVARCHAR(64);
  DECLARE @o_DestCopyFlags int;
  DECLARE @o_DestCopyDedupeFlags int;
  DECLARE @o_DestMediaAgentId int;
  DECLARE @o_DestMediaAgentName NVARCHAR(255);
  DECLARE @o_DestDrivePoolId int;
  DECLARE @o_DestDrivePoolType int;
  DECLARE @o_DestStreamNum int;
  DECLARE @o_DestMediaGroupId int;
  DECLARE @o_DestReservationId int;
  DECLARE @o_DestRCId int;
  DECLARE @o_CurrentSegmentId int;
  DECLARE @o_CurrentVolumeId int;
  DECLARE @o_CurrentChunkId int;
  DECLARE @o_CommcellId int;
  DECLARE @o_DestEncType int;
  DECLARE @o_DestEncKeyLen int;
  DECLARE @o_DestMaxMultiplex int;
--This will turn off message: "xxx rows affected".
SET NOCOUNT ON
	-- Decide what to return based on input
	DECLARE @streamReaderTbl TABLE (jobId int, StreamReaderId int)
	-- If there is given StreamReaderId, return that only
	IF @i_streamReaderId > 0
	BEGIN
		SET @i_archGroupId = 0
		SET @i_archCopyId = 0
		SET @i_status = 0
		INSERT INTO @streamReaderTbl (jobId, StreamReaderId)
		SELECT	DISTINCT JobId, StreamReaderId
		FROM	ArchJobStreamStatus
		WHERE	JobId = @i_adminJobId
		AND		StreamReaderId = @i_streamReaderId
		--AND		((@i_status = 0 AND Status = STREAM_READER_STATUS_NOT_USED) OR (Status = @i_status ))
	END
	-- Return only for the given source copy id based on the status
	ELSE IF @i_archCopyId > 0
	BEGIN
		SET @i_archGroupId = 0
		INSERT INTO @streamReaderTbl (jobId, StreamReaderId)
		SELECT	DISTINCT JobId, StreamReaderId
		FROM	ArchJobStreamStatus
		WHERE	JobId = @i_adminJobId
		AND		SrcCopyId = @i_archCopyId
AND		((@i_status = 0 AND Status = 0x00) OR (Status = @i_status ))
	END
	-- Return for the given storage policy based on the status
	ELSE IF @i_archGroupId > 0
	BEGIN
		INSERT INTO @streamReaderTbl (jobId, StreamReaderId)
		SELECT	DISTINCT JobId, StreamReaderId
		FROM	ArchJobStreamStatus
		WHERE	JobId = @i_adminJobId
		AND		SrcCopyId IN (SELECT DISTINCT Id FROM ArchGroupCopy WITH (NOLOCK) WHERE ArchGroupId = @i_archGroupId)
AND		((@i_status = 0 AND Status = 0x00) OR (Status = @i_status ))
	END
	ELSE
	BEGIN
		INSERT INTO @streamReaderTbl (jobId, StreamReaderId)
		SELECT	DISTINCT JobId, StreamReaderId
		FROM	ArchJobStreamStatus
		WHERE	JobId = @i_adminJobId
AND		((@i_status = 0 AND Status = 0x00) OR (Status = @i_status ))
	END
-- Delete any unreserved StreamReaders.
-- This will release the assigned segments and make sure any new request (getnextchunk or getnextReader) will be able to pick them.
	--DELETE	FROM ArchJobStreamStatus
	--WHERE	JobId = @i_adminJobId
	--AND		(Status = 1 /*reserved*/)
-- Use job id, copy id to get list of uninitialized stream readers, which have resources reserved already.
-- The retrun values will be list stream reader ids along with new chunks from current segment.
	SELECT	DISTINCT
			a.StreamReaderId, a.Status,
			sp.Id, sp.name,
			SrcCopyId, ISNULL(srcCopy.name, ''), ISNULL(srcCopy.Flags, 0), ISNULL(srcCopy.DedupeFlags, 0), SrcStreamNum,
			SrcMAId, ISNULL(srcMA.name, ''),
SrcDrivePoolId, ISNULL(srcDP.DrivePoolType, (CASE WHEN SrcDrivePoolId = 0 AND srcCopy.isSnapCopy = 1 THEN 100001 ELSE 0 END)),
			ISNULL(srcStream.MediaGroupId, 0), SrcReservationId, ISNULL(srcRes.RCId, a.SrcRCId),
(CASE WHEN (ISNULL(srcCopy.extendedFlags, 0) & 2) > 0 THEN (SELECT AGCI.maxMultiplex FROM archGroupCopy AGCI WHERE AGCI.id = srcCopy.destMediaCopyId) ELSE ISNULL(srcCopy.maxMultiplex, 0) END),
			DestCopyId, ISNULL(destCopy.name, ''), ISNULL(destCopy.Flags, 0), ISNULL(destCopy.DedupeFlags, 0),
			DestMAId, ISNULL(destMA.name, ''),
DestDrivePoolId, ISNULL(destDP.DrivePoolType, (CASE WHEN DestDrivePoolId = 0 AND destCopy.isSnapCopy = 1 THEN 100001 ELSE 0 END)),
			DestStreamNum, ISNULL(destStream.MediaGroupId, 0), DestReservationId, ISNULL(destRes.RCId, a.DestRCId),
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			ISNULL(destCopy.encType, 0), ISNULL(destCopy.encKeyLen, 0),
(CASE WHEN (ISNULL(destCopy.extendedFlags, 0) & 2) > 0 THEN (SELECT AGCI.maxMultiplex FROM archGroupCopy AGCI WHERE AGCI.id = destCopy.destMediaCopyId) ELSE ISNULL(destCopy.maxMultiplex, 0) END)
	FROM	@streamReaderTbl readers
			LEFT JOIN ArchJobStreamStatus a ON readers.JobId = a.JobId AND readers.StreamReaderId = a.StreamReaderId
			LEFT JOIN MMResourceToJob srcRes WITH (NOLOCK) ON readers.jobId = srcRes.JobId_l AND srcRes.RCID = a.SrcRCId
			LEFT JOIN MMResourceToJob destRes WITH (NOLOCK) ON readers.jobId = destRes.JobId_l AND destRes.RCID = a.DestRCId
			LEFT JOIN ArchGroupCopy srcCopy WITH (NOLOCK) ON a.SrcCopyId = srcCopy.Id
			LEFT JOIN ArchGroupCopy destCopy WITH (NOLOCK) ON a.DestCopyId = destCopy.Id
			LEFT JOIN App_Client srcMA WITH (NOLOCK) ON a.SrcMAId = srcMA.Id
			LEFT JOIN App_Client destMA WITH (NOLOCK) ON a.DestMAId = destMA.Id
			LEFT JOIN MMDrivePool srcDP WITH (NOLOCK) ON a.SrcDrivePoolId = srcDP.DrivePoolId AND SrcDP.DrivePoolId > 0
			LEFT JOIN MMDrivePool destDP WITH (NOLOCK) ON a.DestDrivePoolId = destDP.DrivePoolId AND destDP.DrivePoolId > 0
			LEFT JOIN ArchGroup sp WITH (NOLOCK) ON srcCopy.ArchGroupId = sp.Id
			LEFT JOIN ArchStream srcStream WITH (NOLOCK) ON a.SrcCopyId = srcStream.ArchGroupCopyId AND a.SrcStreamNum = srcStream.Stream
			LEFT JOIN ArchStream destStream WITH (NOLOCK) ON a.DestCopyId = destStream.ArchGroupCopyId AND a.DestStreamNum = destStream.Stream
	ORDER BY a.StreamReaderId, SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum
	IF (@i_markInited IS NOT NULL AND @i_markInited > 0)
	BEGIN
		UPDATE	ArchJobStreamStatus
SET		Status = 0x02 /*initialized*/
		FROM	@streamReaderTbl a, ArchJobStreamStatus b
		WHERE	a.JobId = b.jobId
		AND		a.StreamReaderId = b.StreamReaderId
AND		(b.Status = 0x01)
AND		(b.Status != 0x02)
		UPDATE a
		SET		a.SrcStreamNum = b.SrcStreamNum, a.SrcMAId = b.SrcMAId, a.SrcDrivePoolId = b.SrcDrivePoolId,
				a.SrcReservationId = b.SrcReservationId, a.srcRCId = b.srcRCId,
				a.DestStreamNum = b.DestStreamNum, a.DestMAId = b.DestMAId, a.DestDrivePoolId = b.DestDrivePoolId,
				a.DestReservationId = b.DestReservationId, a.destRCId = b.destRCId,
				a.Status = b.Status
		FROM	ArchJobStreamStatusHistory a, ArchJobStreamStatus b, @streamReaderTbl c
		WHERE	b.JobId = c.jobId
		AND		b.StreamReaderId = c.StreamReaderId
AND		b.Status = 0x02
		AND		a.JobId = b.JobId
		AND		a.StreamReaderId = b.StreamReaderId
	END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkReplicateGetReaders')
	delete from GxQscripts where name = 'AMChunkReplicateGetReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateGetReaders')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateGetReaders'
GO

insert into GXDBVersions values(2, 'AMChunkReplicateGetReaders',  '00010004001200040000', 'AMChunkReplicateGetReaders', '00010004001200040000')
GO

