

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkReplicateGetNextChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkReplicateGetNextChunks.sp,v $ $Id: AMChunkReplicateGetNextChunks.sp,v 1.23.2.50 2020/12/31 00:30:52 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AMChunkReplicateGetNextChunks')
BEGIN
	print '>>> Drop Stored Procedure: AMChunkReplicateGetNextChunks <<<'
	drop procedure AMChunkReplicateGetNextChunks
END
IF EXISTS (select * from GxQscripts where name='AMChunkReplicateGetNextChunks')
	delete from GxQscripts where name = 'AMChunkReplicateGetNextChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateGetNextChunks')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateGetNextChunks'
GO
print '... Creating Procedure: AMChunkReplicateGetNextChunks'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AMChunkReplicateGetNextChunks
  @i_adminJobId int,
  @i_archGroupId int,
  @i_archCopyId int,
  @i_streamReaderId int,
  @i_segmentId int,
  @i_archFileId int,
  @i_commCellid int
AS
  DECLARE @o_appId integer;
  DECLARE @o_appType integer;
  DECLARE @o_clientId integer;
  DECLARE @o_fullCycleNum integer;
  DECLARE @o_backupJobId integer;
  DECLARE @o_backupStartTime integer;
  DECLARE @o_backupEndTime integer;
  DECLARE @o_archChunkId bigint;
  DECLARE @o_archFileId integer;				
  DECLARE @o_commCellId integer;
  DECLARE @o_archCopyId integer;
  DECLARE @o_streamNum integer;
  DECLARE @o_fileType integer;
  DECLARE @o_archFileCopyFlags integer;
  DECLARE @o_srcEncKeyType integer;
  DECLARE @o_lastChunkNumber integer;
  DECLARE @o_chunkNumber integer;
  DECLARE @o_physicalOffset bigint;
  DECLARE @o_logicalOffset bigint;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_volumeId integer;
  DECLARE @o_mediaId integer;
  DECLARE @o_mediaGroupId integer;
  DECLARE @o_fileMarkerNo integer;
  DECLARE @o_chunkCreateTime integer;
  DECLARE @o_chunkVersion integer;
  DECLARE @o_chunkPhysicalSize bigint;
  DECLARE @o_chunkLogicalSize bigint;
  DECLARE @o_chunkHwEncKey varchar(114);
  DECLARE @o_extraFlags integer;
  DECLARE @o_destPhysicalSize bigint;
  DECLARE @o_destLogicalSize bigint;
  DECLARE @o_destDrivePoolId integer;
  DECLARE @o_destAFCopyFlags integer;
  DECLARE @o_destEncKeyType integer;
  DECLARE @o_encKeyCreated integer;
  DECLARE @o_unCompBytesSize bigint;
  DECLARE @o_destSIDBStoreId integer;
  DECLARE @o_errorCode integer;
/* below defines are from enum : OpwindowRuleLevel*/
IF @i_streamReaderId IS NULL
	SET @i_streamReaderId = 0
IF @i_archCopyId IS NULL
	SET @i_archCopyId = 0
IF @i_segmentId IS NULL
	SET @i_segmentId = 0
-- Select next chunk list based on the given stream reader id.
-- Use job id, copy id and stream reader id to identify current in use reader from table ArchJobStreamStatus.
-- It will give current segmentId, which can be used to figure out the next chunk/volume list from table ArchChunkToReplicate.
-- The return value will be list of uncopied chunks for the given stream reader.
DECLARE @NOW INTEGER;
SET		@NOW = dbo.GetUnixTime(GetUTCDate())
IF @i_streamReaderId = 0 AND @i_segmentId = 0
	GOTO ERROR_EXIT
DECLARE @MAX_CHUNK_PER_REQ	INT = 20
SET @MAX_CHUNK_PER_REQ = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMS2_CONFIG_STRING_AUXCOPY_MAX_CHUNKS_PER_COPY_REQ'), 20)
DECLARE @MAX_FAILURE_COUNT INT = 3
SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (READUNCOMMITTED)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
DECLARE @commCellId				integer = 0
DECLARE @isMultiCopies			integer = 0
DECLARE @currentSourceVolumeId	integer = 0
DECLARE @currentSourceMAId		integer = 0
DECLARE @currentSourceDPId		integer = 0
DECLARE @currentReservationId	integer = 0
DECLARE @currentDestReservationId	integer = 0
DECLARE @currentRCId			integer = 0
DECLARE @currentDestStreamNum	integer = 0
DECLARE @currentSrcStreamNum	integer = 0
DECLARE @currentSourceMediaId	integer = 0
DECLARE @currentSourceMountPathId	integer = 0
DECLARE @currentSourceDeviceId		integer = 0
DECLARE @oldSourceVolumeId		integer = 0
DECLARE @oldSourceMountPathId	integer = 0
DECLARE @oldSourceDeviceId		integer = 0
DECLARE @isDedupeEnabledOnAnyDestCopy integer = 0
DECLARE @isDedupeEnabledOnSrcCopy integer = 0
DECLARE @pickNextChunkOfAF		integer = 0
DECLARE @maxChunkNumber			integer = 0
DECLARE @archFileId				integer = 0
DECLARE @sourceLibraryVTLType	integer = 0
DECLARE @currestDestSIDBStoreId integer = 0
DECLARE @taskId 				integer = 0
DECLARE @errorCode				INTEGER = 0
DECLARE @OPWindowClientId		INTEGER = 0
DECLARE @OPWindowRetCode		INTEGER = -1
IF object_id('tempdb.dbo.#tblNextChunks') IS  NOT null DROP TABLE #tblNextChunks
IF object_id('tempdb.dbo.#tblPartiallyCopiedChunk') IS  NOT null DROP TABLE #tblPartiallyCopiedChunk
CREATE  TABLE #tblNextChunks(archChunkId bigint, chunkCommCellId INT, chunkIdRowNumber INT)
CREATE TABLE #tblPartiallyCopiedChunk
(
	archCopyId		int,
	streamNum		int,
	mediaGroupId	int,
	destCopyId		int,
	destStream		int,
	commCellId		int,
	archChunkId		bigint,
	chunkCommCellId int,
	copiedBytes		bigint,
	copiedUnCompBytes bigint,
	isSnapCopy		int,
	primary key (destCopyId, destStream, archChunkId, commCellId)
)
DECLARE @isIBMcopy BIT = 0
SET @isIBMcopy = (SELECT TOP 1 1 FROM  archGroup WITH (READUNCOMMITTED), JMAdminJobInfoTable WITH (READUNCOMMITTED)
WHERE jobId = @i_adminJobId AND archGrpID = id
AND flags & 67108864 > 0 )
-- Not a single reference to this table so commenting it out
/*
DECLARE @tblArchFileCopiedChunk TABLE
(
	archCopyId		int,
	streamNum		int,
	mediaGroupId	int,
	destCopyId		int,
	destStream		int,
	commCellId		int,
	archChunkId		bigint,
	chunkCommCellId int,
	chunkNumber		int,
	isSnapCopy		int,
	Status			int
	primary key (destCopyId, destStream, archChunkId, commCellId)
)
*/
IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
CREATE TABLE #tblArchChunk
(
	destCopyId			integer,
	destStreamNum		integer,
	srcCopyId			integer,
	srcStreamNum		integer,
	archChunkId			bigint,
	archFileId			integer,
	commCellId			integer,
	chunkCommCellId		integer,
	lastChunkNumber		integer,
	chunkNumber			integer,
	volumeId			integer,
	mediaId				integer,
	mediaGroupId		integer,
	segmentId			integer,
	ChunkNoRowNumber	integer,
	ChunkIdRowNumber	integer,
	primary key (archChunkId, archFileId, commCellId, chunkCommCellId, destCopyId)
)
DECLARE @tblDestCopyList TABLE
(
	destCopyId			integer,
	isDedupeEnabled		integer,
	extendedFlags		bigint,
	destSIDBStoreId		integer
)
  DECLARE @getMAAndDPForVolumeResult TABLE (
	retCode			integer,
mediaAgentName	varchar(1024),
	clientId		integer,
	nasClientId		integer,
	clientReleaseId	integer,
filerName		varchar(1024),
	hostId			integer,
	drivepoolId		integer,
	drivepoolType	integer,
	libraryId		integer,
	libraryTypeId	integer,
	libraryAttribute integer,
libraryName			varchar(128),
libraryAliasName	nvarchar(128),
barcode			varchar(256),
	volumeId		integer,
	mediaLocation	integer,
	jobOpType		integer,
	failureType		integer
  )
  DELETE from @getMAAndDPForVolumeResult
DECLARE @tblTriedVolumesList TABLE
(
	segmentId		integer,
	volumeId		integer,
	PRIMARY KEY (segmentId, volumeId)
)
DECLARE @tblTriedSegmentList TABLE
(
	segmentId		integer,
	primary key (segmentId)
)
DECLARE @tblExcludedSegmentId TABLE(
	segmentId		int,
	primary key (segmentId)
)
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
CREATE TABLE #tblNextSegments
(
	segmentId		int,
	destCopyId		int,
	destStreamNum	int,
	firstVolumeId	int,
	firstChunkId	int,
	skippedCount	int,
	primary key (segmentId, destCopyId)
)
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
CREATE TABLE #tblNextVolumes
(
	volumeId int,
	mediaId int,
	recordingFormatId int,
	libraryId int,
	libVTLType	int,
	mountPathId int,
	deviceId int,
	segmentId int,
	skippedCount int,
	ChunkIdRowNumber int
)
CREATE CLUSTERED INDEX #tblNextVolumes_VolumeId_MediaId_Idx ON #tblNextVolumes (volumeId, mediaId)
-- For parallel copy, source info should be the same for all the destinations, but the current chunk and volume may be different among the destination copies.
-- TODO: How to handle request for multiple StreamReaderId?
SELECT TOP 1
		@i_streamReaderId = CASE WHEN @i_streamReaderId = 0 THEN StreamReaderId ELSE @i_streamReaderId END,
		@i_segmentId = CASE WHEN @i_segmentId = 0 THEN SegmentId ELSE @i_segmentId END,
		@i_archCopyId = CASE WHEN @i_archCopyId = 0 THEN SrcCopyId ELSE @i_archCopyId END,
		@currentReservationId = SrcReservationId,
		@currentDestReservationId = DestReservationId,
		@currentRCId = SrcRCId,
		@currentSourceVolumeId = FirstVolumeId,
		@currentSourceMAId = SrcMAId,
		@currentSourceDPId = SrcDrivePoolId,
		@currentDestStreamNum = DestStreamNum,
		@currentSrcStreamNum = SrcStreamNum,
		@currestDestSIDBStoreId = destSIDBStoreId
FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
WHERE	JobId = @i_adminJobId
AND		(SrcCopyId = @i_archCopyId OR 0 = @i_archCopyId)
AND		(StreamReaderId = @i_streamReaderId OR @i_streamReaderId = 0)
AND		(SegmentId = @i_segmentId OR @i_segmentId = 0)
--AND		(Status & STREAM_READER_STATUS_RESERVED /*reserved*/) > 0
ORDER BY jobId, StreamReaderId, CommCellId, FirstChunkId
IF @i_segmentId = 0 OR @i_archCopyId = 0
	GOTO ERROR_EXIT
SELECT @currentSourceMediaId = MediaId
FROM	MMVolume WITH (READUNCOMMITTED)
WHERE	VolumeId = @currentSourceVolumeId
SELECT @currentSourceMountPathId = device.MountPathId, @currentSourceDeviceId = device.DeviceId
FROM	MMMediaSide side WITH (READUNCOMMITTED), MMMountPath mp WITH (READUNCOMMITTED), MMMountPathToStorageDevice device WITH (READUNCOMMITTED)
WHERE	side.MediaId = @currentSourceMediaId
AND		side.MediaSideId = mp.MediaSideId
AND		device.MountPathId = mp.MountPathId
INSERT INTO @tblDestCopyList
SELECT DISTINCT DestCopyId, 0, 0, destSIDBStoreId
FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
WHERE	JobId = @i_adminJobId
AND		SrcCopyId = @i_archCopyId
AND		StreamReaderId = @i_streamReaderId
--AND		SegmentId = @i_segmentId
AND		Status = 0x02
AND		(EXISTS (SELECT * FROM MMResourceToJob WITH (READUNCOMMITTED) WHERE RCId = ArchJobStreamStatus.DestRCId) OR
		(@currentDestStreamNum > 1 AND EXISTS (SELECT * FROM archGroupCopy WITH (READUNCOMMITTED) WHERE id = @i_archCopyId AND IsSnapCopy = 1)))
UPDATE 	@tblDestCopyList
SET		isDedupeEnabled = CASE WHEN (copy.dedupeFlags & 262144 /*CVA_SIDB_STORE_ENABLED_FLAG*/ > 0
and		copy.dedupeFlags & 1048576 /*CVA_DEDUP_INACTIVE_FLAG*/ = 0 )THEN 1 ELSE 0 END,
		extendedFlags = copy.extendedFlags
FROM	@tblDestCopyList dest, ArchGroupCopy copy with (READUNCOMMITTED)
where	dest.DestCopyId = copy.Id
SELECT @isMultiCopies = COUNT (DISTINCT DestCopyId), @isDedupeEnabledOnAnyDestCopy = (CASE WHEN SUM(isDedupeEnabled) = 0 THEN 0 ELSE 1 END)
FROM	@tblDestCopyList
SELECT	@isDedupeEnabledOnSrcCopy = (CASE WHEN (dedupeFlags & 262144) > 0 THEN 1 ELSE 0 END)
FROM	archGroupCopy WITH (READUNCOMMITTED)
WHERE	id = @i_archCopyId
-- Reset SKIPPED flag based on the destination stream for any failed count or time within the same segment.
-- The reason for doing it within the same segment is to reduce the possiblity of deadlock.
IF object_id('tempdb.dbo.#tblSkippedChunks') IS  NOT null DROP TABLE #tblSkippedChunks
CREATE TABLE #tblSkippedChunks (
	ArchChunkId				int,
	ChunkCommCellId		int,
	DataSizeToProcess	bigint
)
IF @currentDestStreamNum > 0
BEGIN
	UPDATE ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
	FROM	ArchChunkToReplicate R, JMJobDataStats JDS
	WHERE	R.AdminJobId = @i_adminJobId
	AND		R.SrcCopyId = @i_archCopyId
	AND		R.SegmentId = @i_segmentId
ANd		R.Status IN ( 5, 3, 0)
	AND		R.BackupJobId = JDS.JobID
	AND		R.destCopyId = JDS.archGrpCopyId
	AND		R.fileType = JDS.dataType
	AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
	-- fastcopy fix for ndmp clients were chunks might be invalidated after being committed
IF EXISTS( SELECT 1 FROM @tblDestCopyList where extendedFlags & 64 > 0)
		UPDATE	ArchChunkToReplicate
SET		Status = 6
		FROM	ArchChunkToReplicate R INNER JOIN archChunk AC WITH (READUNCOMMITTED)
				ON	R.archCHunkID = AC.id AND R.chunkCommCellid = AC.CommCellId, App_Application aa WITH (READUNCOMMITTED)
		WHERE   R.AdminJobId = @i_adminJobId
				AND		(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
				AND		(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
AND		R.Status IN ( 5, 3, 0)
AND		AC.flags & 256 > 0 AND AC.agedBy & 524288 > 0
AND 	R.ExtraFlags & 64 > 0
AND		R.appID = aa.id AND aa.appTypeId = 13
	DELETE FROM #tblSkippedChunks
	INSERT INTO #tblSkippedChunks
	SELECT ArchChunkId, ChunkCommCellId, PhysicalSize
	FROM	ArchChunkToReplicate WITH (READUNCOMMITTED)
	WHERE	AdminJobId = @i_adminJobId
	AND		SrcCopyId = @i_archCopyId
	AND		SegmentId = @i_segmentId
AND		Status = 3 /*CVA_CHUNK_SKIPPED*/
	-- Reset all the chunk even if the destnation copy doesn't have reservation right now.
	--AND		DestCopyId in (SELECT DestCopyId FROM @tblDestCopyList)
	AND		(
				EXISTS (SELECT Id FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE id = ArchChunkToReplicate.DestCopyId AND isSnapCopy = 1)
				OR
				DestStreamNum = @currentDestStreamNum
			)
AND		(SkippedCount < @MAX_FAILURE_COUNT OR ExtraFlags & 64 > 0)
	AND		(
				SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
				OR
				(Modified + SkippedForSeconds) < @NOW
			)
	IF EXISTS (SELECT * FROM #tblSkippedChunks)
	BEGIN
		UPDATE ArchChunkToReplicate
SET		Status = 0
		FROM	ArchChunkToReplicate a, #tblSkippedChunks b
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.SegmentId = @i_segmentId
AND		a.Status = 3 /*CVA_CHUNK_SKIPPED*/
		-- Reset all the chunk even if the destnation copy doesn't have reservation right now.
		--AND		a.DestCopyId in (SELECT DestCopyId FROM @tblDestCopyList)
		AND		a.ArchChunkId = b.ArchChunkId
		AND		a.ChunkCommCellId = b.ChunkCommCellId
		/* No need to do that. When DSA is enabled, the value is inaccureate anyway.
		UPDATE	ArchJobStreamStatus
		SET		TotalSizeToProcess = TotalSizeToProcess + (SELECT SUM(ISNULL(DataSizeToProcess, 0)) FROM  #tblSkippedChunks)
		WHERE	JobId = @i_adminJobId
		AND		SrcCopyId = @i_archCopyId
		AND		SegmentId = @i_segmentId
		*/
	END
END
if EXISTS (SELECT Id FROM ArchGroupCopy WITH (NOLOCK) WHERE id in (SELECT DestCopyId FROM @tblDestCopyList) AND isSnapCopy = 1) AND @currentDestStreamNum > 1
BEGIN
	EXEC AMChunkReplicateSnapGetNextChunks @i_adminJobId, @i_archGroupId, @i_archCopyId, @i_streamReaderId, @i_segmentId, @i_archFileId, @i_commCellid
	RETURN
END
IF @currentDestReservationId > 0
BEGIN
	DECLARE @currentDestMAId INTEGER = 0
	SELECT @currentDestMAId = clientId
	FROM	MMResource WITH (READUNCOMMITTED)
	WHERE	ReservationId = @currentDestReservationId
	SET @taskId = ISNULL((SELECT TOP 1 jobReq.taskId FROM TM_Jobs jobs WITH(NOLOCK) INNER JOIN TM_JobRequest jobReq WITH(NOLOCK)
                                        ON jobs.jobId = @i_adminJobId AND jobs.jobRequestId = jobReq.jobRequestId ),0)
	SET @OPWindowRetCode = 	dbo.IsOperationAllowedV2(16 /*OPERATION_AUX_COPY*/, 2 /*CommCellId*/, @currentDestMAId, 0 /*AppType*/, 0 /*InstanceId*/, 0 /*BackupsetId*/, 0 /*SubClientId*/,@taskId)
	IF( @OPWindowRetCode <> -1)
	BEGIN
		--  goto error_exit
		SET @OPWindowClientId =  @currentDestMAId
SET @errorCode =  CASE WHEN @OPWindowRetCode = 0 THEN 84001
WHEN @OPWindowRetCode = 1 THEN 84002
WHEN @OPWindowRetCode = 2 THEN 84003
WHEN @OPWindowRetCode = 3 THEN 84004
WHEN @OPWindowRetCode = 4 THEN 84005
WHEN @OPWindowRetCode = 5 THEN 84006
WHEN @OPWindowRetCode = 6 THEN 84007
WHEN @OPWindowRetCode = 7 THEN 84008
WHEN @OPWindowRetCode = 8 THEN 84009
ELSE 84001 END
		GOTO ERROR_EXIT
	END
END
IF @currentReservationId > 0
BEGIN
	SELECT @currentSourceVolumeId = VolumeId, @currentSourceMAId = clientId, @currentSourceDPId = DrivePoolId
	FROM	MMResource WITH (READUNCOMMITTED)
	WHERE	ReservationId = @currentReservationId
END
ELSE
BEGIN
	IF @currentSourceVolumeId = 0
		GOTO PICK_NEXT_SEGMENT
	-- If there is no source reservation, volume and MA and drive pool info should be stored in JobStream table for the given StreamReaderId
	-- If not, consider this as picking a new segemnt and volume
	/*
	SELECT TOP 1 @currentSourceVolumeId = volumeId, @currentSourceMAId = SrcMAId, @currentSourceDPId = SrcDrivePoolId
	FROM	ArchChunkToReplicate WITH (READUNCOMMITTED)
	WHERE	AdminJobId = @i_adminJobId
	AND		SrcCopyId = @i_archCopyId
	AND		SegmentId = @i_segmentId
	AND		ChunkNumber = lastChunkNumber
	*/
END
IF @currentSourceMAId > 0
BEGIN
	SET @taskId = ISNULL((SELECT TOP 1 jobReq.taskId FROM TM_Jobs jobs WITH(NOLOCK) INNER JOIN TM_JobRequest jobReq WITH(NOLOCK)
                                        ON jobs.jobId = @i_adminJobId AND jobs.jobRequestId = jobReq.jobRequestId ),0)
	SET @OPWindowRetCode = 	dbo.IsOperationAllowedV2(16 /*OPERATION_AUX_COPY*/, 2 /*CommCellId*/, @currentSourceMAId, 0 /*AppType*/, 0 /*InstanceId*/, 0 /*BackupsetId*/, 0 /*SubClientId*/,@taskId)
	IF( @OPWindowRetCode <> -1)
	BEGIN
		--  goto error_exit
		SET @OPWindowClientId =  @currentSourceMAId
SET @errorCode =  CASE WHEN @OPWindowRetCode = 0 THEN 84001
WHEN @OPWindowRetCode = 1 THEN 84002
WHEN @OPWindowRetCode = 2 THEN 84003
WHEN @OPWindowRetCode = 3 THEN 84004
WHEN @OPWindowRetCode = 4 THEN 84005
WHEN @OPWindowRetCode = 5 THEN 84006
WHEN @OPWindowRetCode = 6 THEN 84007
WHEN @OPWindowRetCode = 7 THEN 84008
WHEN @OPWindowRetCode = 8 THEN 84009
ELSE 84001 END
		GOTO ERROR_EXIT
	END
END
DECLARE @isSourceMagnetic INT = 0
DECLARE @currentArchiveFileId INT = 0
SELECT @isSourceMagnetic = CASE WHEN RecordingFormatId = 10001 THEN 1 ELSE 0 END
FROM MMVolume WITH (READUNCOMMITTED)
WHERE VolumeId = @currentSourceVolumeId
PICK_NEXT_CHUNK:
	DECLARE	@oneConstReal REAL = 1.0
	-- Lookup partially copied archivefile when destination is dedupe copy
	IF (EXISTS (SELECT DestCopyId FROM @tblDestCopyList WHERE isDedupeEnabled = 1)
		AND @i_ArchFileId > 0
		AND EXISTS (SELECT *
					FROM archChunkToReplicate A WITH (READUNCOMMITTED)
					WHERE A.AdminJobId = @i_adminJobId
						AND	A.SrcCopyId = @i_archCopyId
						AND	A.SegmentId = @i_segmentId
						AND A.archFileId = @i_ArchFileId
						AND A.commCellId = @i_CommCellId
AND Status NOT IN (2, 1, 9)))
	BEGIN
		SET @pickNextChunkOfAF = 1
		SELECT @maxChunkNumber = MAX(A.ChunkNumber)
			FROM archChunkToReplicate A WITH (READUNCOMMITTED)
			WHERE A.AdminJobId = @i_adminJobId
				AND	A.SrcCopyId = @i_archCopyId
				AND	A.SegmentId = @i_segmentId
				AND A.archFileId = @i_ArchFileId
				AND A.commCellId = @i_CommCellId
AND Status IN (2, 1, 9)
		-- This condition should never be true but can happen in case bug
		IF @maxChunkNumber IS NULL OR @maxChunkNumber = 0
			goto NO_MORE_CHUNK
		-- Get All Chunks, Status = Populated, volumes, mediagroupid = Same as previous Media GroupId for this archive file
		-- If next chunknumber from the same archfile is not available for some reason, just don't send any additional chunks and let the stream terminate.
		IF exists (select a.archchunkId
					FROM ArchChunkToReplicate a WITH (READUNCOMMITTED)
					WHERE	a.AdminJobId = @i_adminJobId
					AND		a.SrcCopyId = @i_archCopyId
					AND		a.SegmentId = @i_segmentId
					AND A.archFileId = @i_ArchFileId
					AND A.commCellId = @i_CommCellId
					and A.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
					and a.chunkNumber =  @maxChunkNumber+1
AND		a.Status <> 0
					)
			goto NO_MORE_CHUNK
		DELETE #tblArchChunk
		INSERT	INTO #tblArchChunk (
			destCopyId,	destStreamNum,
			srcCopyId,	srcStreamNum,
			archChunkId, archFileId, commCellId, chunkCommCellId,
			lastChunkNumber, chunkNumber,
			volumeId, mediaId, mediaGroupId,
			segmentId,
			ChunkNoRowNumber,
			ChunkIdRowNumber
		)
		SELECT	a.DestCopyId, a.DestStreamNum,
				a.SrcCopyId, a.SrcStreamNum,
				a.ArchChunkId, a.ArchFileId, a.CommCellId, a.chunkCommCellId,
				a.lastChunkNumber, a.ChunkNumber,
				a.volumeId, a.mediaId, a.MediaGroupId,
				a.segmentId,
				0, --ROW_NUMBER() OVER (PARTITION BY  a.VolumeId, a.SrcCopyId, a.DestCopyId ORDER BY a.commCellId, a.archFileId, a.chunkNumber) AS ChunkNoRowNumber,
				DENSE_RANK() OVER (ORDER BY a.commCellId, a.archFileId, a.chunkNumber) AS ChunkIdRowNumber
				--ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.archFileId, a.commCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
		FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED)
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.SegmentId = @i_segmentId
		AND A.archFileId = @i_ArchFileId
		AND A.commCellId = @i_CommCellId
		and A.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
		AND		(@isDedupeEnabledOnSrcCopy = 1 OR a.VolumeId = @currentSourceVolumeId)
AND		a.Status = 0
		delete #tblArchChunk
		where ChunkIdRowNumber != chunkNUmber - @maxChunkNumber
		IF EXISTS(SELECT * FROM #tblArchChunk)
		BEGIN
			-- send limit number of chunk info
			DELETE #tblArchChunk WHERE ChunkIdRowNumber > @MAX_CHUNK_PER_REQ
			GOTO SUCCESS_EXIT
		END
		else if exists (select *
						FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED)
						WHERE	a.AdminJobId = @i_adminJobId
								AND		a.SrcCopyId = @i_archCopyId
								AND		a.SegmentId = @i_segmentId
										AND A.archFileId = @i_ArchFileId
								AND A.commCellId = @i_CommCellId
								and A.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
								and a.chunkNumber =  @maxChunkNumber+1
								AND		a.VolumeId  <> @currentSourceVolumeId
								AND @isDedupeEnabledOnSrcCopy = 0)
		BEGIN
			DELETE #tblArchChunk
			GOTO PICK_NEXT_VOLUME
		END
		ELSE
			GOTO NO_MORE_CHUNK
	END
	-- Lookup partially copied chunks first
	-- Refer to stored procedure archChunkToCopyGetFirst.sp
	DELETE #tblPartiallyCopiedChunk
	DELETE #tblArchChunk
	INSERT INTO #tblPartiallyCopiedChunk (
			archCopyId, streamNum, mediaGroupId, destCopyId, destStream, commCellId,
			archChunkId, chunkCommCellId,
			copiedBytes, copiedUnCompBytes,
			isSnapCopy
	)
	SELECT	A.SrcCopyId, A.SrcStreamNum, A.mediaGroupId, A.DestCopyId, A.DestStreamNum, A.commCellId,
			A.ArchChunkId, a.ChunkCommCellId,
			0 /*SUM(B.physicalSize - A.physicalOffset)*/ AS copiedBytes,
			0 /*CAST((SUM( CASE WHEN A.physicalSize = 0 THEN (B.physicalSize - A.physicalOffset)
							ELSE (((B.physicalSize - A.physicalOffset)*@oneConstReal*A.unCompBytesSize)/ A.physicalSize)
							END
					  )
				  ) AS BIGINT)*/ AS copiedUnCompBytes,
			CASE WHEN EXISTS (SELECT Id FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE id = A.DestCopyId AND isSnapCopy = 1) THEN 1 ELSE 0 END
	FROM	ArchChunkToReplicate A WITH (READUNCOMMITTED), archFileCopy B WITH (READUNCOMMITTED)
	WHERE	A.AdminJobId = @i_adminJobId
	AND		A.SrcCopyId = @i_archCopyId
	AND		A.SegmentId = @i_segmentId
	AND		(@isDedupeEnabledOnSrcCopy = 1 OR A.VolumeId = @currentSourceVolumeId)
AND		A.Status = 0
	AND		A.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
	AND		(
				EXISTS (SELECT Id FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE id = A.DestCopyId AND isSnapCopy = 1)
				OR
				(A.DestStreamNum > 0 /*AND A.SrcStreamNum > 0*/)
			)
	AND		(
				A.archFileId = B.archFileId AND
				A.commCellId = B.commCellId AND
				A.destCopyId = B.archCopyId AND
(	((A.extraFlags & 4) > 0 AND B.LogicalSize > 0 AND B.LogicalSize < (A.LogicalOffset + A.LogicalSize))
					OR
((A.extraFlags & 4) = 0 AND B.physicalSize > 0 AND B.physicalSize < (A.physicalOffset + A.PhysicalSize))
				)
				--a.PhysicalOffset = b.PhysicalOffset AND
				--b.isValid = 0
			)
	AND		A.destCopyId = B.archCopyId
	GROUP BY A.SrcCopyId, A.SrcStreamNum, A.mediaGroupId, A.DestCopyId, A.DestStreamNum, A.commCellId,
			A.ArchChunkId, a.ChunkCommCellId
	IF EXISTS (SELECT * FROM #tblPartiallyCopiedChunk)
	BEGIN
		INSERT	INTO #tblArchChunk (
			destCopyId,	destStreamNum,
			srcCopyId,	srcStreamNum,
			archChunkId, archFileId, commCellId, chunkCommCellId,
			lastChunkNumber, chunkNumber,
			volumeId, mediaId, mediaGroupId,
			segmentId,
			ChunkNoRowNumber,
			ChunkIdRowNumber
		)
		SELECT	a.DestCopyId, a.DestStreamNum,
				a.SrcCopyId, a.SrcStreamNum,
				a.ArchChunkId, a.ArchFileId, a.CommCellId, a.chunkCommCellId,
				a.lastChunkNumber, a.ChunkNumber,
				a.volumeId, a.mediaId, a.MediaGroupId,
				a.segmentId,
				0, --ROW_NUMBER() OVER (PARTITION BY  a.VolumeId, a.SrcCopyId, a.DestCopyId ORDER BY a.commCellId, a.archFileId, a.chunkNumber) AS ChunkNoRowNumber,
				DENSE_RANK() OVER (ORDER BY a.commCellId, a.archFileId, a.chunkNumber) AS ChunkIdRowNumber
				--ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.archFileId, a.commCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
		FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), #tblPartiallyCopiedChunk b
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.SegmentId = @i_segmentId
		AND		a.DestCopyId = b.destCopyId
		AND		a.DestStreamNum = b.destStream
		AND		a.MediaGroupId = b.mediaGroupId
		AND		a.ArchChunkId = b.archChunkId
		AND		a.chunkCommCellId = b.chunkCommCellId
		AND		(@isDedupeEnabledOnSrcCopy = 1 OR a.VolumeId = @currentSourceVolumeId)
AND		a.Status = 0
		-- If there is chunk id in the segment smaller than the current selected ones,
		--- it means there is other volume contains the smaller chunk id in current segment.
		-- This volume should be processed first, because we need process chunk id in sequence regardless volume info.
		IF EXISTS (SELECT TOP 1 VolumeId
					FROM 	ArchChunkToReplicate a WITH (READUNCOMMITTED)
					WHERE	a.AdminJobId = @i_adminJobId
					AND		a.SrcCopyId = @i_archCopyId
					AND		a.SegmentId = @i_segmentId
					AND		a.VolumeId != @currentSourceVolumeId
					AND		@isDedupeEnabledOnSrcCopy = 0
AND		a.Status NOT IN (2, 1, 9)
					AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
				)
		BEGIN
			DELETE #tblArchChunk
			FROM	#tblArchChunk b left join ArchChunkToReplicate a WITH (READUNCOMMITTED)
			ON		a.AdminJobId = @i_adminJobId
			AND		a.SrcCopyId = @i_archCopyId
			AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
			AND		a.SegmentId = @i_segmentId
			AND		a.VolumeId != @currentSourceVolumeId
			AND		@isDedupeEnabledOnSrcCopy = 0
AND		a.Status NOT IN (2, 1, 9)
			AND		b.archFileId = a.archFileId
			AND		b.commCellid = a.commcellId
			AND		b.chunkNumber > a.chunkNumber
			WHERE	a.ArchChunkId IS NOT NULL
		END
		DELETE  #tblArchChunk
		FROM	#tblArchChunk T2,
				(SELECT	T.destCopyId, T.srcCopyId, T.archFileId, T.commCellId, MAX(chunkNumber) AS MaxChunkNumber,   MIN(T.chunkNumber) AS MinChunkNumber, COUNT(*) AS ChunkCount
				FROM	#tblArchChunk T
				GROUP BY T.destCopyId, T.srcCopyId, T.archFileId, T.commCellId) T3
		WHERE	T2.archFileId = T3.archFileId
				AND T2.commCellId = T3.commCellId
				AND ((MaxChunkNumber - MinChunkNumber + 1) != ChunkCount
					OR EXISTS (	SELECT *
								FROM	ArchChunkToReplicate R WITH (READUNCOMMITTED)
								WHERE	R.AdminJobId = @i_adminJobId AND R.archFileId = T3.ArchFileId AND R.commCellId = T3.commCellId
										AND	R.srcCopyId = T3.srcCopyId AND R.DestCopyId = T3.DestCopyId
										AND R.ChunkNumber < T3.MinChunkNumber
AND R.Status NOT IN (1, 2, 9)))
		-- send limit number of chunk info
		IF (@isDedupeEnabledOnAnyDestCopy = 0)
		BEGIN
			DELETE FROM #tblNextChunks
			INSERT INTO #tblNextChunks
			SELECT	DISTINCT TOP(@MAX_CHUNK_PER_REQ) archChunkId, chunkCommCellId, ChunkIdRowNumber
						FROM	#tblArchChunk
			ORDER BY ChunkIdRowNumber
			DELETE	#tblArchChunk
			FROM	#tblArchChunk C LEFT OUTER JOIN #tblNextChunks NC ON C.archChunkId = NC.archChunkId AND C.chunkCommCellId = NC.chunkCommCellId
			WHERE	NC.archChunkId IS NULL
			DELETE  #tblArchChunk
			FROM	#tblArchChunk T2,
					(SELECT	T.destCopyId, T.srcCopyId, T.archFileId, T.commCellId, MAX(chunkNumber) AS MaxChunkNumber,   MIN(T.chunkNumber) AS MinChunkNumber, COUNT(*) AS ChunkCount
					FROM	#tblArchChunk T
					GROUP BY T.destCopyId, T.srcCopyId, T.archFileId, T.commCellId) T3
			WHERE	T2.archFileId = T3.archFileId
					AND T2.commCellId = T3.commCellId
					AND ((MaxChunkNumber - MinChunkNumber + 1) != ChunkCount
						OR EXISTS (	SELECT *
									FROM	ArchChunkToReplicate R WITH (READUNCOMMITTED)
									WHERE	R.AdminJobId = @i_adminJobId AND R.archFileId = T3.ArchFileId AND R.commCellId = T3.commCellId
											AND	R.srcCopyId = T3.srcCopyId AND R.DestCopyId = T3.DestCopyId
											AND R.ChunkNumber < T3.MinChunkNumber
AND R.Status NOT IN (1, 2, 9)))
		END
		ELSE
		BEGIN
			IF EXISTS (SELECT 1 FROM #tblArchChunk A, archChunkToReplicate B WITH (READUNCOMMITTED)
						WHERE @i_adminJobId = B.AdminJobId
						AND		A.SrcCopyId = B.SrcCopyId
						ANd		A.segmentId = B.segmentId
						AND		A.ArchFileId = B.ArchFileId
						AND		A.volumeId != B.VolumeId
						ANd		A.commCellId = B.CommcellId
AND		B.Status NOT IN (2, 1, 9)
						AND		@isDedupeEnabledOnSrcCopy = 0
						)
			BEGIN
				SELECT @archFileId = MIN(B.ArchFileId), @CommCellId = MIN(B.CommCellId)
				 FROM #tblArchChunk A, archChunkToReplicate B WITH (READUNCOMMITTED)
						WHERE @i_adminJobId = B.AdminJobId
						AND		A.SrcCopyId = B.SrcCopyId
						ANd		A.segmentId = B.segmentId
						AND		A.ArchFileId = B.ArchFileId
						AND		A.volumeId != B.VolumeId
						ANd		A.commCellId = B.CommcellId
AND		B.Status NOT IN (2, 1, 9)
				delete #tblArchCHunk
				WHERE	archFileId > @archFileId
						AND CommCellId = @CommCellId
			END
			DELETE #tblArchChunk WHERE ChunkIdRowNumber > @MAX_CHUNK_PER_REQ
		END
		IF EXISTS (SELECT * FROM #tblArchChunk)
			GOTO SUCCESS_EXIT
	END
	-- Refer to stored procedure archChunkToCopyGetNext.sp
	INSERT	INTO #tblArchChunk (
		destCopyId,	destStreamNum,
		srcCopyId,	srcStreamNum,
		archChunkId, archFileId, commCellId, chunkCommCellId,
		lastChunkNumber, chunkNumber,
		volumeId, mediaId, mediaGroupId,
		segmentId,
		ChunkNoRowNumber,
		ChunkIdRowNumber
	)
	SELECT	a.DestCopyId, a.DestStreamNum,
			a.SrcCopyId, a.SrcStreamNum,
			a.ArchChunkId, a.ArchFileId, a.CommCellId, a.chunkCommCellId,
			a.lastChunkNumber, a.ChunkNumber,
			a.volumeId, a.mediaId, a.MediaGroupId,
			a.segmentId,
			0, --ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.DestCopyId ORDER BY a.archFileId, a.commCellId, a.chunkNumber) AS ChunkNoRowNumber,
			DENSE_RANK() OVER (ORDER BY a.commCellId, a.archFileId, a.chunkNumber) AS ChunkIdRowNumber
			--ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.SrcCopyId, a.archFileId, a.commCellId ORDER BY a.ChunkCommCellId, a.archChunkId) AS ChunkIdRowNumber
	FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), archFileCopy B WITH (READUNCOMMITTED)
	WHERE	a.AdminJobId = @i_adminJobId
	AND		a.SrcCopyId = @i_archCopyId
	AND		a.SegmentId = @i_segmentId
	AND		(@isDedupeEnabledOnSrcCopy = 1 OR a.VolumeId = @currentSourceVolumeId)
AND		a.Status = 0
	AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
	AND		A.archFileId = B.archFileId
	AND		A.commCellId = B.commCellId
	AND		A.destCopyId = B.archCopyId
AND		(	((A.extraFlags & 4) > 0 AND B.LogicalSize = 0)
				OR
((A.extraFlags & 4) = 0 AND B.physicalSize = 0)
			)
	-- If there is chunk id in the segment smaller than the current selected ones,
	--- it means there is other volume contains the smaller chunk id in current segment.
	-- This volume should be processed first, because we need process chunk id in sequence regardless volume info.
	IF EXISTS (SELECT TOP 1 VolumeId
				FROM 	ArchChunkToReplicate a WITH (READUNCOMMITTED)
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = @i_segmentId
				AND		a.VolumeId != @currentSourceVolumeId
				AND		@isDedupeEnabledOnSrcCopy = 0
AND		a.Status NOT IN (2, 1, 9)
				AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
			)
	BEGIN
		DELETE #tblArchChunk
		FROM	#tblArchChunk b left join ArchChunkToReplicate a WITH (READUNCOMMITTED)
		ON		a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
		AND		a.SegmentId = @i_segmentId
		AND		a.VolumeId != @currentSourceVolumeId
AND		a.Status NOT IN (2, 1, 9)
		AND		b.archFileId = a.archFileId
		AND		b.commCellid = a.commcellId
		AND		b.chunkNumber > a.chunkNumber
		WHERE	a.ArchChunkId IS NOT NULL
	END
	DELETE  #tblArchChunk
	FROM	#tblArchChunk T2,
			(SELECT	T.destCopyId, T.srcCopyId, T.archFileId, T.commCellId, MAX(chunkNumber) AS MaxChunkNumber,   MIN(T.chunkNumber) AS MinChunkNumber, COUNT(*) AS ChunkCount
			FROM	#tblArchChunk T
			GROUP BY T.destCopyId, T.srcCopyId, T.archFileId, T.commCellId) T3
	WHERE	T2.archFileId = T3.archFileId
			AND T2.commCellId = T3.commCellId
			AND ((MaxChunkNumber - MinChunkNumber + 1) != ChunkCount
				OR EXISTS (	SELECT *
							FROM	ArchChunkToReplicate R WITH (READUNCOMMITTED)
							WHERE	R.AdminJobId = @i_adminJobId AND R.archFileId = T3.ArchFileId AND R.commCellId = T3.commCellId
									AND	R.srcCopyId = T3.srcCopyId AND R.DestCopyId = T3.DestCopyId
									AND R.ChunkNumber < T3.MinChunkNumber
AND R.Status NOT IN (1, 2, 9)))
	-- send limit number of chunk info
	IF (@isDedupeEnabledOnAnyDestCopy = 0)
	BEGIN
		DELETE FROM #tblNextChunks
		INSERT INTO #tblNextChunks
		SELECT	DISTINCT TOP(@MAX_CHUNK_PER_REQ) archChunkId, chunkCommCellId, ChunkIdRowNumber
					FROM	#tblArchChunk
		ORDER BY ChunkIdRowNumber
		DELETE	#tblArchChunk
		FROM	#tblArchChunk C LEFT OUTER JOIN #tblNextChunks NC ON C.archChunkId = NC.archChunkId AND C.chunkCommCellId = NC.chunkCommCellId
		WHERE	NC.archChunkId IS NULL
		DELETE  #tblArchChunk
		FROM	#tblArchChunk T2,
				(SELECT	T.destCopyId, T.srcCopyId, T.archFileId, T.commCellId, MAX(chunkNumber) AS MaxChunkNumber,   MIN(T.chunkNumber) AS MinChunkNumber, COUNT(*) AS ChunkCount
				FROM	#tblArchChunk T
				GROUP BY T.destCopyId, T.srcCopyId, T.archFileId, T.commCellId) T3
		WHERE	T2.archFileId = T3.archFileId
				AND T2.commCellId = T3.commCellId
				AND ((MaxChunkNumber - MinChunkNumber + 1) != ChunkCount
					OR EXISTS (	SELECT *
								FROM	ArchChunkToReplicate R WITH (READUNCOMMITTED)
								WHERE	R.AdminJobId = @i_adminJobId AND R.archFileId = T3.ArchFileId AND R.commCellId = T3.commCellId
										AND	R.srcCopyId = T3.srcCopyId AND R.DestCopyId = T3.DestCopyId
										AND R.ChunkNumber < T3.MinChunkNumber
AND R.Status NOT IN (1, 2, 9)))
	END
	ELSE
	BEGIN
		IF EXISTS (SELECT 1 FROM #tblArchChunk A, archChunkToReplicate B WITH (READUNCOMMITTED)
							WHERE @i_adminJobId = B.AdminJobId
							AND		A.SrcCopyId = B.SrcCopyId
							ANd		A.segmentId = B.segmentId
							AND		A.ArchFileId = B.ArchFileId
							AND		A.volumeId != B.VolumeId
							AND		@isDedupeEnabledOnSrcCopy = 0
							ANd		A.commCellId = B.CommcellId
AND		B.Status NOT IN (2, 1, 9)
							)
		BEGIN
			SELECT @archFileId = MIN(B.ArchFileId), @commCellId = MIN(B.CommCellId)
				FROM #tblArchChunk A, archChunkToReplicate B WITH (READUNCOMMITTED)
					WHERE @i_adminJobId = B.AdminJobId
					AND		A.SrcCopyId = B.SrcCopyId
					ANd		A.segmentId = B.segmentId
					AND		A.ArchFileId = B.ArchFileId
					AND		A.volumeId != B.VolumeId
					ANd		A.commCellId = B.CommcellId
AND		B.Status NOT IN (2, 1, 9)
			delete #tblArchCHunk
			WHERE	archFileId > @archFileId
					AND CommCellId = @commCellId
		END
		DELETE #tblArchChunk WHERE ChunkIdRowNumber > @MAX_CHUNK_PER_REQ
	END
	IF EXISTS (SELECT * FROM #tblArchChunk)
		GOTO SUCCESS_EXIT
PICK_NEXT_VOLUME:
	-- If we cannot find more chunk for current volume,
	-- Check if there is more volume from the same segment (streamreader)
	-- If there is no more volume, pick a different segment
	IF NOT EXISTS (SELECT * FROM #tblArchChunk)
	BEGIN
		SET	@oldSourceVolumeId = @currentSourceVolumeId
		SET @oldSourceMountPathId = @currentSourceMountPathId
		SET @oldSourceDeviceId = @currentSourceDeviceId
		IF NOT EXISTS (SELECT * FROM @tblTriedVolumesList WHERE segmentId = @i_segmentId AND VolumeId = @oldSourceVolumeId)
			INSERT INTO @tblTriedVolumesList VALUES (@i_segmentId, @oldSourceVolumeId)
		SET @currentSourceVolumeId = 0
		SET @currentSourceMountPathId = 0
		SET @currentSourceDeviceId = 0
		IF (@pickNextChunkOfAF = 1)
		BEGIN
			SELECT TOP 1 @currentSourceVolumeId = VolumeId
			FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED)
			WHERE	a.AdminJobId = @i_adminJobId
			AND		a.SrcCopyId = @i_archCopyId
			AND		a.SegmentId = @i_segmentId
AND		a.Status = 0
			AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
			AND		a.archFileId = @i_ArchFileId
			AND		a.commCellId = @i_CommCellId
			AND		a.chunkNumber = (@maxChunkNumber + 1)
			-- We cannot copy next chunk of archive file, close the stream
			IF @currentSourceVolumeId = 0
				GOTO NO_MORE_CHUNK
		END
		ELSE
		BEGIN
			SELECT TOP 1 @currentSourceVolumeId = VolumeId
			FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED)
			WHERE	a.AdminJobId = @i_adminJobId
			AND		a.SrcCopyId = @i_archCopyId
			AND		a.SegmentId = @i_segmentId
AND		a.Status = 0
			AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
			AND		a.VolumeId NOT IN (SELECT VolumeID FROM @tblTriedVolumesList WHERE segmentId = @i_segmentId)
			ORDER BY a.SkippedCount, ChunkCommCellId, ArchChunkId, VolumeId
			-- There is no more volume in current segment, pick next segment directly
			IF @currentSourceVolumeId = 0
				GOTO PICK_NEXT_SEGMENT
		END
		SELECT @currentSourceMediaId = MediaId
		FROM	MMVolume WITH (READUNCOMMITTED)
		WHERE	VolumeId = @currentSourceVolumeId
		SELECT @currentSourceMountPathId = device.MountPathId, @currentSourceDeviceId = device.DeviceId
		FROM	MMMediaSide side WITH (READUNCOMMITTED), MMMountPath mp WITH (READUNCOMMITTED), MMMountPathToStorageDevice device WITH (READUNCOMMITTED)
		WHERE	side.MediaId = @currentSourceMediaId
		AND		side.MediaSideId = mp.MediaSideId
		AND		device.MountPathId = mp.MountPathId
		-- If the new volume is different from the old one and they don't have the same device or mount path,
		-- make sure current Media Agent can access the new volume.
		-- Always check for the non-magnetic volume.
		IF (@oldSourceMountPathId = 0 OR @currentSourceMountPathId = 0)
		OR (
				@oldSourceVolumeId != @currentSourceVolumeId
				AND	(@oldSourceMountPathId != @currentSourceMountPathId
					OR @oldSourceDeviceId != @currentSourceDeviceId)
			)
		BEGIN
			delete from @getMAAndDPForVolumeResult
			insert into @getMAAndDPForVolumeResult
			exec mms2getmaanddpforvolume @currentSourceVolumeId, 0, @currentSourceMAId, 0 /*@preferredDestCopyId*/, @i_adminJobId, 1
			if not exists (select 1 from @getMAAndDPForVolumeResult where retCode = 0 and clientId = @currentSourceMAId)
			begin
				SET @currentSourceVolumeId = 0
				SET @currentSourceMountPathId = 0
				SET @currentSourceDeviceId = 0
IF EXISTS(SELECT 1 from @getMAAndDPForVolumeResult where retCode IN (84001,84002,84003,84004,84005,84006,84007,84008,84009) and clientId = @currentSourceMAId)
				BEGIN
					SELECT @errorCode = retCode FROM @getMAAndDPForVolumeResult WHERE clientId = @currentSourceMAId
					SET @OPWindowClientId = @currentSourceMAId
				END
			END
		END
		-- Special case when using VTL library with Type as 4
		-- The old and new media should belong to the same type VTL library
		-- However, this should not happen here in the fist place because chunk/volume should be put into different segments at the beginning.
		select @sourceLibraryVTLType = lib.VTLType
		from	MMLibrary lib with (NOLOCK), MMVolume vol with (NOLOCK), MMMedia med with (NOLOCK)
		where	vol.VolumeId = @oldSourceVolumeId
		and		vol.MediaId = med.MediaId
		and		med.LibraryId = lib.LibraryId
		IF EXISTS(select 1
				from	MMLibrary lib with (NOLOCK), MMMedia med with (NOLOCK)
				where	lib.LibraryId = med.LibraryId and med.MediaId = @currentSourceMediaId
				and		(
							(@sourceLibraryVTLType = 4 and lib.VTLType != 4)
							or
							(@sourceLibraryVTLType != 4 and lib.VTLType = 4)
						)
				)
		BEGIN
			SET @currentSourceVolumeId = 0
		END
		IF @currentSourceVolumeId > 0
		BEGIN
			UPDATE	ArchJobStreamStatus
			SET		FirstVolumeId = @currentSourceVolumeId
			WHERE	jobId = @i_adminJobId
			AND		SrcCopyId = @i_archCopyId
			AND		StreamReaderId = @i_streamReaderId
			GOTO PICK_NEXT_CHUNK
		END
		ELSE
		BEGIN
			-- Return no more chunk for current reader/Media Agent
			-- New reader will create on different Media Agent and process the segment again.
			-- For current reader, we don't want to pick a new segment.
			DELETE #tblArchChunk
			IF (@pickNextChunkOfAF = 1)
				GOTO NO_MORE_CHUNK
			ELSE
				GOTO PICK_NEXT_SEGMENT
		END
	END
PICK_NEXT_SEGMENT:
	IF NOT EXISTS (SELECT * FROM #tblArchChunk)
	BEGIN
		-- Reset SKIPPED flag based on the destination stream for any failed count or time for different segment but the same destination stream num
		-- The reason for doing it within the same segment is to reduce the possiblity of deadlock.
		IF @currentDestStreamNum > 0
		BEGIN
			UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
			FROM	ArchChunkToReplicate R, JMJobDataStats JDS
			WHERE	R.AdminJobId = @i_adminJobId
			AND		R.SrcCopyId = @i_archCopyId
			AND		R.SegmentId = @i_segmentId
ANd		R.Status IN ( 5, 3, 0)
			AND		R.BackupJobId = JDS.JobID
			AND		R.destCopyId = JDS.archGrpCopyId
			AND		R.fileType = JDS.dataType
			AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
			UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
			FROM	ArchChunkToReplicate R, JMJobDataStats JDS
			WHERE	R.AdminJobId = @i_adminJobId
			AND		R.SrcCopyId = @i_archCopyId
			AND		R.SegmentId = @i_segmentId
ANd		R.Status IN ( 5, 3, 0)
			AND		R.BackupJobId = JDS.JobID
			AND		R.SrcCopyId = JDS.archGrpCopyId
			AND		R.fileType = JDS.dataType
			AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
			-- fastcopy fix for ndmp clients were chunks might be invalidated after being committed
IF EXISTS( SELECT 1 FROM @tblDestCopyList where extendedFlags & 64 > 0)
				UPDATE	ArchChunkToReplicate
SET		Status = 6
				FROM	ArchChunkToReplicate R INNER JOIN archChunk AC WITH (READUNCOMMITTED)
						ON	R.archCHunkID = AC.id AND R.chunkCommCellid = AC.CommCellId, App_Application aa WITH (READUNCOMMITTED)
				WHERE   R.AdminJobId = @i_adminJobId
						AND		(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
						AND		(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
AND		R.Status IN ( 5, 3, 0)
AND		AC.flags & 256 > 0 AND AC.agedBy & 524288 > 0
AND 	R.ExtraFlags & 64 > 0
AND		R.appID = aa.id AND aa.appTypeId = 13
			-- Reset SKIPPED FOR RESOURCE flag based on the destination stream for all reader id gone
			UPDATE ArchChunkToReplicate
SET		Status = 0
			WHERE	AdminJobId = @i_adminJobId
			AND		SrcCopyId = @i_archCopyId
			AND		SegmentId != @i_segmentId
			AND		NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = ArchChunkToReplicate.AdminJobId AND StreamReaderId = ArchChunkToReplicate.StreamReaderId)
AND		Status = 5 /*CVA_CHUNK_SKIPPED*/
			AND		(Modified + SkippedForSeconds) < @NOW
AND		(SkippedCount < @MAX_FAILURE_COUNT OR ExtraFlags & 64 > 0)
			UPDATE ArchChunkToReplicate
SET		Status = 0
			WHERE	AdminJobId = @i_adminJobId
			AND		SrcCopyId = @i_archCopyId
			AND		SegmentId != @i_segmentId
AND		Status = 3 /*CVA_CHUNK_SKIPPED*/
			-- Reset all the chunk even if the destnation copy doesn't have reservation right now.
			--AND		DestCopyId in (SELECT DestCopyId FROM @tblDestCopyList)
			AND			DestCopyId > 0
			--AND		NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE jobId = ArchChunkToReplicate.AdminJobId AND segmentId = ArchChunkToReplicate.SegmentId)
			AND		(
						EXISTS (SELECT Id FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE id = ArchChunkToReplicate.DestCopyId AND isSnapCopy = 1)
						OR
						DestStreamNum = @currentDestStreamNum
					)
			AND		(
SkippedCount < @MAX_FAILURE_COUNT OR ExtraFlags & 64 > 0
					)
			AND		(
						SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
						OR
						(Modified + SkippedForSeconds) < @NOW
					)
			IF NOT EXISTS (SELECT TOP 1 SegmentId FROM ArchChunkToReplicate WITH (READUNCOMMITTED)
							WHERE	AdminJobId = @i_adminJobId
							AND		SegmentId > 0
							AND		SrcCopyId = @i_archCopyId
							AND		SegmentId != @i_segmentId
AND		Status = 0 /*CVA_CHUNK_POPULATED*/
							AND		DestCopyId > 0 /*AND a.DestStreamNum = 0 AND a.SrcStreamNum = 0*/
							AND		(
										EXISTS (SELECT Id FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE id = ArchChunkToReplicate.DestCopyId AND isSnapCopy = 1)
										OR
										DestStreamNum = @currentDestStreamNum
									)
					)
			BEGIN
				UPDATE ArchChunkToReplicate
SET		Status = 0, SkippedReason = 0, SkippedForSeconds = 0, ErrorCode = 0, Modified = @now
				WHERE	adminJobId = @i_adminJobId
				AND		SegmentId > 0
				AND		SrcCopyId = @i_archCopyId
				AND		SegmentId != @i_segmentId
				AND		DestCopyId > 0 /*AND a.DestStreamNum = 0 AND a.SrcStreamNum = 0*/
				AND		(
							EXISTS (SELECT Id FROM ArchGroupCopy WITH (READUNCOMMITTED) WHERE id = ArchChunkToReplicate.DestCopyId AND isSnapCopy = 1)
							OR
							DestStreamNum = @currentDestStreamNum
						)
AND		Status = 3
AND		SkippedReason = 0X13
AND		ErrorCode = 20025
			END
		END
		-- Figure out the next volume or chunk, then the next segmentId
		-- Refer to auxcopymanager logic for getnextvolume and getnextchunk
		--SET @currentSourceVolumeId = 0, @currentSourceMAId = 0, @currentSourceDPId = 0
		DECLARE @currentMediaId				int	= 0
		DECLARE @currentRecordingFormatId	int = 0
		DECLARE @currentLibraryId			int = 0
		DECLARE @currentMasterPoolId		int = 0
		DECLARE @currentMountPathId			int = 0
		DECLARE @currentDeviceId			int = 0
		DECLARE @currentDeviceControllerId	int = 0
		SELECT	@currentMediaId = media.MediaId,
				@currentRecordingFormatId = volume.RecordingFormatId,
				@currentLibraryId = CASE WHEN media.LibraryId > 0 THEN media.LibraryId ELSE media.LastWriteLibraryId END
		FROM	MMMedia media WITH (READUNCOMMITTED), MMVolume volume WITH (READUNCOMMITTED)
		WHERE	volume.volumeId = @currentSourceVolumeId
		AND		volume.MediaId = media.MediaId
		IF @currentRecordingFormatId = 10001
		BEGIN
			SELECT @currentMasterPoolId = dp.MasterPoolId,
					@currentMountPathId = path.MountPathId,
					@currentDeviceId = device.DeviceId,
					@currentDeviceControllerId = ctrl.DeviceControllerId
			FROM	MMDrivePool dp WITH (READUNCOMMITTED), MMMediaSide side WITH (READUNCOMMITTED),
					MMMountPath path WITH (READUNCOMMITTED), MMMountPathToStorageDevice device WITH (READUNCOMMITTED), MMDeviceController ctrl WITH (READUNCOMMITTED)
			WHERE	dp.DrivePoolId = @currentSourceDPId
			AND		side.MediaId = @currentMediaId
			AND		side.MediaSideId = path.MediaSideId
			AND		path.MountPathId = device.MountPathId
			AND		device.DeviceId = ctrl.DeviceId
			ANd		ctrl.ClientId = dp.ClientId
		END
		ELSE
		BEGIN
			SELECT @currentMasterPoolId = MasterPoolId,
					@currentMountPathId = 0, @currentDeviceId = 0, @currentDeviceControllerId = 0
			FROM	MMDrivePool WITH (READUNCOMMITTED)
			WHERE	DrivePoolId = @currentSourceDPId
		END
		DELETE #tblNextSegments
		IF @i_segmentId > 0 AND NOT EXISTS (SELECT 1 FROM @tblTriedSegmentList WHERE segmentId = @i_segmentId)
			INSERT INTO @tblTriedSegmentList VALUES (@i_segmentId)
		DELETE @tblExcludedSegmentId
		INSERT INTO @tblExcludedSegmentId
SELECT DISTINCT SegmentId FROM ArchChunkToReplicate WITH (READUNCOMMITTED) WHERE AdminJobId = @i_adminJobId AND Status = 1
		INSERT INTO #tblNextSegments
		SELECT	a.SegmentId, a.DestCopyId, 0, 0, 0, MIN(a.skippedCount)
		FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), @tblDestCopyList DC
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
AND		a.Status = 0
		AND		a.DestCopyId = DC.DestCopyId
		AND		a.destSIDBStoreId = DC.destSIDBStoreId
		AND		(a.DestStreamNum = 0 OR a.DestStreamNum = @currentDestStreamNum)
		GROUP BY a.SegmentId, a.DestCopyId
		DELETE #tblNextSegments
		FROM #tblNextSegments b left join @tblExcludedSegmentId c ON c.segmentId = b.SegmentId
		WHERE EXISTS (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0 AND segmentId = b.SegmentId)
		OR	c.segmentId IS NOT NULL
		OR	EXISTS (SELECT 1 FROM @tblTriedSegmentList WHERE segmentId = b.segmentId)
		-- The next segment must contains the same or subset of current destination copy reservations. Otherwise, we cannot do parallel copy
		IF EXISTS (SELECT * FROM #tblNextSegments)
		BEGIN
			DELETE #tblNextSegments
			FROM	#tblNextSegments a LEFT JOIN @tblDestCopyList b
					ON a.DestCopyId = b.DestCopyId
			WHERE	b.DestCopyId IS NULL
		END
		-- Make sure not copy the data to the same library is the option is set on copy.
		IF EXISTS (SELECT * FROM #tblNextSegments)
		AND	EXISTS (SELECT	dest.DestCopyId
					FROM	@tblDestCopyList dest, ArchGroupCopy copy with (READUNCOMMITTED)
					where	dest.DestCopyId = copy.Id
and		copy.Flags & 65536 > 0)
		BEGIN
			-- check destincation volume and library
			declare @destinationLibraryId int = 0
			select @destinationLibraryId = ISNULL(med.LibraryId, 0)
			from	(
						select TOP 1 res.VolumeId from ArchJobStreamStatus stream with (READUNCOMMITTED), MMResource res with (READUNCOMMITTED)
						where	stream.DestReservationId = res.ReservationId
						and		JobId = @i_adminJobId
						AND		StreamReaderId = @i_streamReaderId
					) a,
					MMVolume vol with (READUNCOMMITTED), MMMedia med with (READUNCOMMITTED)
			where	a.VolumeId = vol.VolumeId
			and		vol.MediaId = med.MediaId
			if @destinationLibraryId > 0
			begin
				UPDATE nextSegments
				SET 	firstChunkId = minChunk.archChunkId
				from	#tblNextSegments nextSegments,
						(
							SELECT a.segmentId as segmentId, MIN(b.archChunkId) as archChunkId
							from #tblNextSegments a, ArchChunkToReplicate b WITH (READUNCOMMITTED)
							where	b.AdminJobId = @i_adminJobId
							AND		b.SrcCopyId = @i_archCopyId
							AND		b.segmentId = a.segmentId
AND		b.Status = 0
							GROUP BY a.segmentId
						) minChunk
				WHERE nextSegments.segmentId = minChunk.segmentId
				DELETE #tblNextSegments
				FROM	#tblNextSegments a, ArchChunk chunk with (READUNCOMMITTED), MMVolume vol with (READUNCOMMITTED), MMMedia med with (READUNCOMMITTED)
				WHERE	a.firstChunkId > 0
				AND		a.firstChunkId = chunk.id
				AND		chunk.VolumeId = vol.VolumeId
				AND		vol.MediaId = med.MediaId
				AND		med.LibraryId = @destinationLibraryId
			end
		END
		IF NOT EXISTS (SELECT * FROM #tblNextSegments)
			GOTO NO_MORE_CHUNK
		DELETE #tblNextVolumes
		-- Make sure the new segment has the same destination copy or same set of parallel copies.
		IF @currentRecordingFormatId = 10001
		BEGIN
			INSERT INTO #tblNextVolumes (volumeId, mediaId, recordingFormatId, libraryId, libVTLType, MountPathId, deviceId, segmentId, skippedCount, ChunkIdRowNumber)
			SELECT	DISTINCT a.VolumeId, a.MediaId, 0, 0, 0, 0, 0,
					0, 0,
					ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archFileId, a.commCellId, a.ChunkCommCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
			FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), #tblNextSegments b
			WHERE	a.AdminJobId = @i_adminJobId
			AND		a.SrcCopyId = @i_archCopyId
			AND		a.segmentId = b.segmentId
			--AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
			--AND		a.SegmentId NOT IN (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0)
AND		a.Status = 0
			UPDATE vol
			SET		skippedCount = c.skippedCount
			FROM	#tblNextVolumes vol,
					(
						SELECT	a.VolumeId, MIN(a.skippedCount) skippedCount
						FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), #tblNextSegments b
						WHERE	a.AdminJobId = @i_adminJobId
						AND		a.SrcCopyId = @i_archCopyId
						AND		a.segmentId = b.segmentId
AND		a.Status = 0
						GROUP BY a.VolumeId
					) c
			WHERE	vol.volumeId = c.VolumeId
			UPDATE a
			SET		RecordingFormatId = volume.RecordingFormatId,
					libraryId = CASE WHEN media.LibraryId > 0 THEN media.LibraryId ELSE media.LastWriteLibraryId END,
					mountPathId = path.MountPathId,
					deviceId = device.DeviceId
			FROM	#tblNextVolumes a,
					MMVolume volume WITH (READUNCOMMITTED), MMMedia media WITH (READUNCOMMITTED), MMMediaSide side WITH (READUNCOMMITTED),
					MMMountPath path WITH (READUNCOMMITTED), MMMountPathToStorageDevice device WITH (READUNCOMMITTED)
			WHERE	a.VolumeId = volume.VolumeId
			AND		volume.MediaId = media.MediaId
			AND		volume.RecordingFormatId = 10001
			AND		media.MediaId = side.MediaId
			AND		side.MediaSideId = path.MediaSideId
			AND		path.MountPathId = device.MountPathId
		END
		ELSE
		BEGIN
			INSERT INTO #tblNextVolumes (volumeId, mediaId, recordingFormatId, libraryId, libVTLType, MountPathId, deviceId, segmentId, skippedCount, ChunkIdRowNumber)
			SELECT	DISTINCT a.VolumeId, a.MediaId, 0, 0, 0, 0, 0,
					0, 0,
					ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archFileId, a.commCellId, a.ChunkCommCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
			FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), #tblNextSegments b
			WHERE	a.AdminJobId = @i_adminJobId
			AND		a.SrcCopyId = @i_archCopyId
			AND		a.segmentId = b.segmentId
			--AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
			--AND		a.SegmentId NOT IN (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0)
AND		a.Status = 0
			UPDATE vol
			SET		skippedCount = c.skippedCount
			FROM	#tblNextVolumes vol,
					(
						SELECT	a.VolumeId, MIN(a.skippedCount) skippedCount
						FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), #tblNextSegments b
						WHERE	a.AdminJobId = @i_adminJobId
						AND		a.SrcCopyId = @i_archCopyId
						AND		a.segmentId = b.segmentId
AND		a.Status = 0
						GROUP BY a.VolumeId
					) c
			WHERE	vol.volumeId = c.VolumeId
			UPDATE a
			SET		RecordingFormatId = volume.RecordingFormatId,
					libraryId = CASE WHEN media.LibraryId > 0 THEN media.LibraryId ELSE media.LastWriteLibraryId END
			FROM	#tblNextVolumes a,
					MMVolume volume WITH (READUNCOMMITTED), MMMedia media WITH (READUNCOMMITTED)
			WHERE	a.VolumeId = volume.VolumeId
			AND		volume.MediaId = media.MediaId
		END
		UPDATE	a
		SET		libVTLType = lib.VTLType
		FROM	#tblNextVolumes a, MMLibrary lib WITH (READUNCOMMITTED)
		WHERE	a.LibraryId = lib.LibraryId
		-- Special case when using VTL library with Type as 4
		-- The old and new media should belong to the same type VTL library
		select @sourceLibraryVTLType = lib.VTLType
		from	MMLibrary lib with (NOLOCK)
		where	lib.LibraryId = @currentLibraryId
		IF	@sourceLibraryVTLType = 4 OR
			EXISTS (SELECT 1 FROM #tblNextVolumes WHERE libVTLType = 4)
		BEGIN
			DELETE FROM #tblNextVolumes
			WHERE	(@sourceLibraryVTLType = 4 AND libVTLType != 4)
			OR		(@sourceLibraryVTLType != 4 and libVTLType = 4)
		END
		IF NOT EXISTS (SELECT * FROM #tblNextVolumes)
			GOTO NO_MORE_CHUNK
		DECLARE @nextVolumeId	int
		DECLARE @nextChunkId	int
		DECLARE @nextSegmentId	int
		SET @nextVolumeId = 0
		SET @nextChunkId = 0
		SET @nextSegmentId = 0
		SELECT TOP 1 @nextVolumeId = volumeId
		FROM #tblNextVolumes a
		ORDER BY
			CASE WHEN a.recordingFormatId = @currentRecordingFormatId THEN 0 ELSE 1 END,
			-- Finding the next volume which can be read with the same drive pool as the current volume.
			CASE WHEN a.mountPathId = 0 AND EXISTS (SELECT * FROM MMDrivePool dp WITH (READUNCOMMITTED), MMMasterPool master WITH (READUNCOMMITTED), MMRecFmtMedTyp FMT, MMDrive drive
														WHERE a.libraryId = master.LibraryId AND master.MasterPoolId = dp.MasterPoolId AND dp.DrivePoolId = @currentSourceDPId
														AND	master.MasterPoolId = drive.MasterPoolId AND FMT.DriveTypeId = drive.DriveTypeId
AND	FMT.RecordingFormatId = a.RecordingFormatId AND (FMT.CompatibilityType & 4) > 0)
				THEN 0
				WHEN a.mountPathId > 0 AND (mountPathId = @currentMountPathId OR deviceId = @currentDeviceId)
				THEN 0
				ELSE 1 END,
			-- Finding a volume which can be read from the same library as the current volume.
			CASE WHEN libraryId = @currentLibraryId THEN 0 ELSE 1 END,
			-- Finding a volume which can be read from the same media agent as the current volume.
			CASE WHEN a.mountPathId = 0 AND EXISTS (SELECT * FROM MMDrivePool dp WITH (READUNCOMMITTED), MMMasterPool master WITH (READUNCOMMITTED), MMRecFmtMedTyp FMT, MMDrive drive
														WHERE a.libraryId = master.LibraryId AND master.MasterPoolId = dp.MasterPoolId AND dp.ClientId = @currentSourceMAId
														AND	master.MasterPoolId = drive.MasterPoolId AND FMT.DriveTypeId = drive.DriveTypeId
AND	FMT.RecordingFormatId = a.RecordingFormatId AND (FMT.CompatibilityType & 4) > 0)
				THEN 0
				WHEN a.mountPathId > 0 AND EXISTS (SELECT * FROM MMDeviceController ctrl WITH (READUNCOMMITTED) WHERE ctrl.DeviceId = a.DeviceId AND ctrl.ClientId = @currentSourceMAId
														AND ctrl.DeviceControllerEnabled = 1 and ctrl.DeviceAccessible = 1)
				THEN 0
				ELSE 1 END,
			-- Finding the chunk skipped count and select ones with less process count first
			skippedCount,
			-- Finding a volume whose first chunk ID is the smallest.
			ChunkIdRowNumber,
			-- Finding a skipped volume whose first chunk ID is the smallest.
			-- Get next segment of chunks for this stream and push them into the stream volume list - DSA only
			a.VolumeId
		-- Select next chunk
		-- Select next segment
		IF @nextVolumeId > 0
		BEGIN
			delete from @getMAAndDPForVolumeResult
			insert into @getMAAndDPForVolumeResult
			exec mms2getmaanddpforvolume @nextVolumeId, 0, @currentSourceMAId, 0 /*@preferredDestCopyId*/, @i_adminJobId, 1
			if not exists (select * from @getMAAndDPForVolumeResult where retCode = 0 and clientId = @currentSourceMAId)
			begin
				SET @nextVolumeId = 0
				-- TODO: There should be multiple candidates, if one of volumes cannot be read, we need to provide the ability to check rest of them.
IF EXISTS(SELECT 1 from @getMAAndDPForVolumeResult where retCode IN (84001,84002,84003,84004,84005,84006,84007,84008,84009) and clientId = @currentSourceMAId)
				BEGIN
					SELECT @errorCode = retCode FROM @getMAAndDPForVolumeResult WHERE clientId = @currentSourceMAId
					SET @OPWindowClientId = @currentSourceMAId
				END
				GOTO NO_MORE_CHUNK
			end
			ELSE
			BEGIN
				SELECT TOP 1 @nextChunkId = ArchChunkId, @nextSegmentId = a.segmentId
				FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), #tblNextSegments b
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = b.segmentId
				--AND		a.SegmentId NOT IN (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0)
				--AND		a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
AND		a.Status = 0
				AND		a.VolumeId = @nextVolumeId
				ORDER BY b.skippedCount, BackupJobId
			END
		END
		IF @nextSegmentId > 0 AND @nextVolumeId > 0
		BEGIN
			SET @i_segmentId = @nextSegmentId
			SET @currentSourceVolumeId = @nextVolumeId
			IF NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (READUNCOMMITTED)
							WHERE	jobId = @i_adminJobId
							AND		SrcCopyId = @i_archCopyId
							AND		StreamReaderId = @i_streamReaderId
							AND		SegmentId = @nextSegmentId
							)
			BEGIN
				DECLARE @newSegmentTotalSize TABLE (
					segmentId	int,
					DestCopyId	int,
					TotalSize	bigint,
					IsNew		int
				)
				DELETE @newSegmentTotalSize
				INSERT INTO @newSegmentTotalSize
				SELECT	a.SegmentId, a.DestCopyId, SUM(a.unCompBytesSize), 1
				FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), ArchJobStreamStatus b
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
				AND		a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = @nextSegmentId
AND		a.Status IN (0, 3)
				AND		b.DestCopyId = a.DestCopyId
				GROUP BY a.SegmentId, a.DestCopyId
				INSERT INTO @newSegmentTotalSize
				SELECT	a.SegmentId, a.DestCopyId, SUM(a.unCompBytesSize), 0
				FROM	ArchChunkToReplicate a WITH (READUNCOMMITTED), ArchJobStreamStatus b
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
				AND		a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = b.SegmentId
AND		a.Status IN (0, 3)
				AND		b.DestCopyId = a.DestCopyId
				GROUP BY a.SegmentId, a.DestCopyId
				UPDATE	b
				SET		SegmentId = @nextSegmentId, FirstVolumeId = @nextVolumeId, FirstChunkId = 0, CommCellId = 0, TotalSizeToProcess = TotalSizeToProcess + a.TotalSize - ISNULL(c.TotalSize, 0)
				FROM	@newSegmentTotalSize a LEFT OUTER JOIN @newSegmentTotalSize c ON c.DestCopyId = a.DestCopyId AND c.IsNew = 0,
						ArchJobStreamStatus b
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
				AND		b.DestCopyId = a.DestCopyId
				AND		a.IsNew = 1
				/*
				UPDATE	ArchJobStreamStatus
				SET		SegmentId = @nextSegmentId, FirstVolumeId = @nextVolumeId, FirstChunkId = 0, CommCellId = 0, TotalSizeToProcess = 0
				FROM	ArchJobStreamStatus b
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
				*/
				IF(@isIBMcopy = 1)
				BEGIN
					DECLARE @retVal INT = 0
					DECLARE @magneticBytes BIGINT = 0
					IF OBJECT_ID('tempdb.dbo.#ToBeAgedAFC') IS NOT NULL DROP TABLE #ToBeAgedAFC
					IF OBJECT_ID('tempdb.dbo.#AFCInfo') IS NOT NULL DROP TABLE #AFCInfo
					CREATE TABLE #ToBeAgedAFC (
					archFileId INT, commCellId INT, archCopyId INT,
					PRIMARY KEY (archFileId, commCellId, archCopyId))
					CREATE TABLE #AFCInfo (
					archFileId INT, commCellId INT, archCopyId INT, flags INT, streamNum INT, encRSA INT, encKeyType INT, encKey INT, encKeyId INT )
					INSERT	INTO #AFCInfo
					OUTPUT INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId INTO #ToBeAgedAFC
					SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.flags , AFC.streamNum , AFC.encRSA , AFC.encKeyType , AFC.encKey , AFC.encKeyId
					FROM    archFileCopy AFC WITH (READUNCOMMITTED),archChunkToReplicate A  WITH (READUNCOMMITTED)
					WHERE 	A.AdminJobId = @i_adminJobId
						AND A.SrcCopyId = @i_archCopyId
						AND A.SegmentId = @nextSegmentId
AND A.Status IN (0, 3)
						AND AFC.archFileId = A.ArchFileId
						AND AFC.commCellId = A.commCellId
						AND AFC.archCopyId = A.DestCopyId
						AND AFC.isValid = 0
						AND AFC.physicalSize > 0
					IF EXISTS (SELECT * FROM #ToBeAgedAFC)
					BEGIN
EXEC @retVal = archFileSetAgedViaTable 17179869184, @now
						IF (@retVal = 0)
							EXEC @retVal = archFileDeleteViaTable 0, @magneticBytes OUTPUT
						UPDATE ArchChunkToReplicate
SET     Status = 0, Modified = @now
						FROM #ToBeAgedAFC A, ArchChunkToReplicate R
						WHERE   R.adminJobId = @i_adminJobId
							AND A.archFileId = R.ArchFileId
							AND A.commCellId = R.commCellId
							AND A.archCopyId = R.DestCopyId
						INSERT INTO archFileCopy
						SELECT archFileId, commCellId, archCopyId, flags, 0, streamNum, 0, 0, 0, 0, encRSA, encKeyType, encKey, @now, 0, 0, encKeyId, -1
						FROM #AFCInfo
					END
				END
			END
			ELSE
			BEGIN
				UPDATE	ArchJobStreamStatus
				SET		FirstVolumeId = @nextVolumeId, FirstChunkId = 0, CommCellId = 0
				WHERE	jobId = @i_adminJobId
				AND		SrcCopyId = @i_archCopyId
				AND		StreamReaderId = @i_streamReaderId
			END
			-- After picking the new segment, set the source and destination stream number on all the chunk within the segment
			UPDATE ArchChunkToReplicate
			SET 	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END,
				DestStreamNum = @currentDestStreamNum
			FROM	ArchChunkToReplicate a
			WHERE	a.AdminJobId = @i_AdminJobId
			AND	a.SegmentId = @nextSegmentId
			AND	a.DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
			DELETE @tblTriedVolumesList
			GOTO PICK_NEXT_CHUNK
		END
		-- If current source ma and drive pool cannot access the next volume, reset the value.
		-- Pipeline should be dropped, or media agent send request for exchange volume?
	END
DECLARE @l_nAFChunk INT = 0
DECLARE @L_rowcount INT = 0
IF NOT EXISTS (SELECT * FROM #tblArchChunk)
	GOTO NO_MORE_CHUNK
-- If segmentId changes for the current StreamReader, update the table
-- Need more details on what to returned. Don't think all the information from mediamanager.x is needed.
-- When the process of populate table ArchChunkToReplicate is done, we can fill in more details
SUCCESS_EXIT:
UPDATE #tblArchChunk
SET		MediaGroupId = c.MediaGroupId
FROM	#tblArchChunk a, ArchJobStreamStatus b WITH (READUNCOMMITTED), ArchStream c WITH (READUNCOMMITTED)
WHERE	b.jobId = @i_adminJobId
AND		b.SrcCopyId = @i_archCopyId
AND		b.StreamReaderId = @i_streamReaderId
AND		b.DestCopyId = a.DestCopyId
AND		a.SrcCopyId = @i_archCopyId
AND		b.DestCopyId = c.ArchGroupCopyId
AND		b.DestStreamNum = c.Stream
UPDATE ArchChunkToReplicate
SET Status = 1, MediaGroupId = b.MediaGroupId, Modified = @NOW,
	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END,
	DestStreamNum = @currentDestStreamNum,
	SrcMAId = @currentSourceMAId, SrcDrivePoolId = @currentSourceDPId, streamReaderId = @i_streamReaderId
FROM	ArchChunkToReplicate a, #tblArchChunk b
WHERE	a.AdminJobId = @i_AdminJobId
AND		a.ArchChunkId = b.archChunkId
AND		a.VolumeId = b.VolumeId
AND		a.SrcCopyId = b.SrcCopyId
AND		a.archFileId = b.archFileId
AND		a.commCellId = b.commCellId
AND		a.ChunkCommCellId = b.ChunkCommCellId
AND		a.SegmentId = b.SegmentId
AND		a.DestCopyId = b.DestCopyid
-- If this is the first call for getchunks, set the source and destination stream number on all the chunk within the segment
UPDATE ArchChunkToReplicate
SET 	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END,
	DestStreamNum = @currentDestStreamNum
WHERE	AdminJobId = @i_AdminJobId
AND	SegmentId IN (SELECT DISTINCT SegmentId FROM #tblArchChunk)
AND	DestCopyId IN (SELECT DestCopyId FROM @tblDestCopyList)
AND	(SrcStreamNum = 0 OR DestStreamNum = 0)
---- Chunks from the same segmentId but different destination copy may not be in the list.
---- It is because reservation on that particular destination copy may not be created.
---- Even though we don't need to send those chunks for destination copy has no reservation,
---- it is better set the same destination stream info just in caes.
--UPDATE ArchChunkToReplicate
--SET --Status = CVA_CHUNK_SENT,
--	MediaGroupId = stream.MediaGroupId,
--	Modified = @NOW,
--	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END,
--	DestStreamNum = @currentDestStreamNum /* NO NEED TO SET SOURCE INFO,
--	SrcMAId = @currentSourceMAId, SrcDrivePoolId = @currentSourceDPId*/
--
--FROM	ArchChunkToReplicate a, #tblArchChunk b, ArchStream stream WITH (READUNCOMMITTED)
--WHERE	a.AdminJobId = @i_AdminJobId
--AND		a.ArchChunkId = b.archChunkId
--AND		a.VolumeId = b.VolumeId
--AND		a.SrcCopyId = b.SrcCopyId
--AND		a.commCellId = b.commCellId
--AND		a.ChunkCommCellId = b.ChunkCommCellId
--AND		a.SegmentId = b.SegmentId
--AND		a.DestCopyId != b.DestCopyid
--AND		a.DestCopyId = stream.ArchGroupCopyId
--AND		stream.Stream = @currentDestStreamNum
SET	@l_nAFChunk = (SELECT COUNT(*) FROM #tblArchChunk)
SET	@l_rowcount = (SELECT COUNT(*) FROM #tblArchChunk)
/*
SELECT	0, 0, 0, 0, 0, 0, 0,
		0, @l_nAFChunk, 0, 0,
		@l_rowcount, 0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, '', 0,
		1, 0, 0, 0, 0, 0, 0
*/
SELECT	c.appId, 0, 0, 0, c.backupJobId, 0 /*backupStartTime*/, 0 /*backupEndTime*/,
		a.archChunkId, a.archFileId, a.commCellId, a.destCopyId,
		c.DestStreamNum, c.fileType, c.archFileCopyFlags, c.encKeyType, a.lastChunkNumber,
		a.chunkNumber, c.physicalOffset, c.logicalOffset, c.physicalSize, c.logicalSize,
		a.volumeId, a.mediaId, a.mediaGroupId, c.fileMarkerNo,
		c.chunkCreateTime, c.chunkVersion, c.chunkPhysicalSize, c.chunkLogicalSize, c.chunkHwEncKey,
c.extraFlags & (256|512),
		b.physicalSize, b.logicalSize, b.drivePoolId, b.flags, b.encKeyType,
		(case when b.physicalSize = 0 and b.encKey = '' then 0 else 1 end) encKeyCreated,
		c.unCompBytesSize, destCopy.destSIDBStoreId, 0
FROM	#tblArchChunk a
		INNER join
		archFileCopy b WITH (READUNCOMMITTED) on b.archFileId = a.archFileId AND b.commCellId = a.commCellId AND b.archCopyId = a.destCopyId
		left join
		ArchChunkToReplicate c WITH (READUNCOMMITTED) on c.AdminJobId = @i_AdminJobId and a.archChunkId = c.ArchChunkId AND a.ChunkCommCellId = c.ChunkCommCellId
												and a.archFileId = c.archFileId AND a.commCellId = c.commCellId AND a.destCopyId = c.DestCopyId
		left join
		@tblDestCopyList destCopy ON destCopy.destCopyId = a.destCopyId
ORDER BY a.destCopyId,
		 CASE WHEN @isDedupeEnabledOnAnyDestCopy = 0 THEN a.archChunkId ELSE a.archFileId END,
		 CASE WHEN @isDedupeEnabledOnAnyDestCopy = 0 THEN a.archFileId ELSE a.chunkNumber END
IF object_id('tempdb.dbo.#tblNextChunks') IS  NOT null DROP TABLE #tblNextChunks
IF object_id('tempdb.dbo.#tblPartiallyCopiedChunk') IS  NOT null DROP TABLE #tblPartiallyCopiedChunk
IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
IF object_id('tempdb.dbo.#tblSkippedChunks') IS  NOT null DROP TABLE #tblSkippedChunks
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
RETURN;
NO_MORE_CHUNK:
ERROR_EXIT:
SELECT  0, 0, @OPWindowClientId, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0, '', 0,
		1, 0, 0, 0, 0, 0, 0, 0, @errorCode
--SELECT 0, 0
IF object_id('tempdb.dbo.#tblNextChunks') IS  NOT null DROP TABLE #tblNextChunks
IF object_id('tempdb.dbo.#tblPartiallyCopiedChunk') IS  NOT null DROP TABLE #tblPartiallyCopiedChunk
IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
IF object_id('tempdb.dbo.#tblSkippedChunks') IS  NOT null DROP TABLE #tblSkippedChunks
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkReplicateGetNextChunks')
	delete from GxQscripts where name = 'AMChunkReplicateGetNextChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateGetNextChunks')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateGetNextChunks'
GO

insert into GXDBVersions values(2, 'AMChunkReplicateGetNextChunks',  '00010023000200500000', 'AMChunkReplicateGetNextChunks', '00010023000200500000')
GO

