

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkReplicateGetJobStreamProgress.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkReplicateGetJobStreamProgress.sp,v $ $Id: AMChunkReplicateGetJobStreamProgress.sp,v 1.2.84.2 2017/02/10 20:59:45 sjohnson Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AMChunkReplicateGetJobStreamProgress <<<'

IF EXISTS (select * from sysobjects where name='AMChunkReplicateGetJobStreamProgress')
	drop procedure AMChunkReplicateGetJobStreamProgress
IF EXISTS (select * from GxQscripts where name='AMChunkReplicateGetJobStreamProgress')
	delete from GxQscripts where name = 'AMChunkReplicateGetJobStreamProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateGetJobStreamProgress')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateGetJobStreamProgress'
GO
print '... Creating Procedure: AMChunkReplicateGetJobStreamProgress'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AMChunkReplicateGetJobStreamProgress
  @i_adminJobId int,
  @i_archCopyId int,
  @i_archStream int,
  @i_streamReaderId int,
  @i_rcId int
AS
  DECLARE @ArchGroupId int;
  DECLARE @SourceCopyId int;
  DECLARE @SourceStream int;
  DECLARE @SourceRCId int;
  DECLARE @DestinationCopyId int;
  DECLARE @DestinationStream int;
  DECLARE @DestinationRCId int;
  DECLARE @TotalData bigint;
  DECLARE @TotalDataProcessed bigint;
  DECLARE @TotalDataTobeProcessed bigint;
-- Chunk status
/*
--Values for Status column in archChunkToReplicate table
*/
declare @BACKUP			integer
declare @RESTORE		integer
declare @INDEXRESTORE	integer
declare @AUXCOPY		integer
declare @SYNTHFULL		integer
declare @ARCHIVECHECK	integer
declare @OFFLINECI		integer
declare @MEDIAREFRESH	integer
declare @DEDUPDBSYNC	integer
declare @AUXCOPY2		integer
set @BACKUP			= 4
set @RESTORE		= 5
set @INDEXRESTORE	= 12
set @AUXCOPY		= 13
set @SYNTHFULL		= 14
set @ARCHIVECHECK	= 31
set @OFFLINECI		= 53
set @MEDIAREFRESH	= 74
set @DEDUPDBSYNC	= 80
set @AUXCOPY2		= 101
declare @jobOpType			int
set @jobOpType = dbo.GetJobTypeForJobID(@i_adminJobId)
DECLARE @tblTotalDataToProcessByCopyStream	TABLE (
	SourceCopyId		int,
	SourceStream		int,
	SourceRCId			int,
	DestinationCopyId	int,
	DestinationStream	int,
	DestinationRCId		int,
	TotalData			bigint,
	TotalDataProcessed	bigint,
	TotalDataTobeProcessed	bigint
)
DELETE @tblTotalDataToProcessByCopyStream
DECLARE @tblCopyStreams		TABLE (
	SourceCopyId		int,
	SourceStream		int,
	DestinationCopyId	int,
	DestinationStream	int
)
DELETE @tblCopyStreams
IF @jobOpType = @AUXCOPY2
BEGIN
	-- Lookup by RCID
	IF @i_rcId > 0 AND EXISTS (SELECT * FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCId = @i_rcId)
	BEGIN
		INSERT INTO @tblCopyStreams
		SELECT DISTINCT
				ISNULL(jobstream.SrcCopyId, 0), ISNULL(jobstream.SrcStreamNum, 0),
				ISNULL(jobstream.DestCopyId, res.CopyId), ISNULL(jobstream.DestStreamNum, res.StreamId)
		FROM	MMResourceToJob restojob WITH (NOLOCK)
				LEFT JOIN ArchJobStreamStatus jobstream WITH (NOLOCK)
					ON restojob.RCID = @i_rcId AND restojob.RCID = jobstream.DestRCID
						AND restojob.JobId_l = @i_adminJobId AND jobstream.JobId = @i_adminJobId
				LEFT JOIN MMResource res WITH (NOLOCK)
					ON restojob.ReservationId = res.ReservationId
		WHERE jobstream.SrcCopyId > 0 OR jobstream.DestCopyId > 0
	END
	-- Look up by one destination CopyId
	ELSE IF @i_archCopyId > 0 AND EXISTS (SELECT * FROM ArchChunkToReplicate WITH (NOLOCK) WHERE AdminJobId = @i_adminJobId AND DestCopyId = @i_archCopyId)
	BEGIN
		INSERT INTO @tblCopyStreams
		SELECT DISTINCT SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum
		FROM	ArchChunkToReplicate WITH (NOLOCK)
		WHERE	AdminJobId = @i_adminJobId AND DestCopyId = @i_archCopyId
		AND		(@i_archStream = 0 OR @i_archStream = DestStreamNum)
	END
	-- Lookup by Stream Reader Id for multiple destination copies
	ELSE IF @i_streamReaderId > 0 AND EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId AND StreamReaderId = @i_streamReaderId)
	BEGIN
		INSERT INTO @tblCopyStreams
		SELECT DISTINCT chunks.SrcCopyId, chunks.SrcStreamNum, chunks.DestCopyId, chunks.DestStreamNum
		FROM	ArchChunkToReplicate chunks WITH (NOLOCK), ArchJobStreamStatus jobstream WITH (NOLOCK)
		WHERE	jobstream.JobId = @i_adminJobId
		AND		jobstream.StreamReaderId = @i_streamReaderId
		AND		jobstream.DestCopyId = chunks.DestCopyId
		AND		jobstream.DestStreamNum = chunks.DestStreamNum
	END
	-- Lookup by job Id for multiple source copies and destination copies
	ELSE IF EXISTS (SELECT * FROM ArchChunkToReplicate WITH (NOLOCK) WHERE AdminJobId = @i_adminJobId)
	BEGIN
		INSERT INTO @tblCopyStreams
		SELECT DISTINCT SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum
		FROM	ArchChunkToReplicate WITH (NOLOCK)
		WHERE	AdminJobId = @i_adminJobId
	END
END
ELSE
-- Assume other job type will also use ArchChunkToReplicate table
BEGIN
	INSERT INTO @tblCopyStreams
	SELECT DISTINCT SrcCopyId, SrcStreamNum, DestCopyId, DestStreamNum
	FROM	ArchChunkToReplicate WITH (NOLOCK)
	WHERE	AdminJobId = @i_adminJobId
END
DECLARE	@oneConstReal REAL = 1.0
-- Update Based on destination copy for each stream number. If the stream number is 0, that is unidentified stream. It's data size is unknown at this point.
INSERT INTO @tblTotalDataToProcessByCopyStream
SELECT	copystream.SourceCopyId, copystream.SourceStream, 0, copystream.DestinationCopyId, copystream.DestinationStream, 0,
		SUM(
CASE WHEN (R.extraFlags & 4) > 0 THEN
			(CASE WHEN (R.PhysicalStartOffset > R.LogicalOffSet) THEN (R.LogicalOffSet + R.LogicalSize - R.PhysicalStartOffset) ELSE R.LogicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.LogicalSize > 0 THEN R.LogicalSize ELSE 1 END)
		ELSE
			(CASE WHEN (R.PhysicalStartOffset > R.PhysicalOffset) THEN (R.PhysicalOffset + R.PhysicalSize - R.PhysicalStartOffset) ELSE R.PhysicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.PhysicalSize > 0 THEN R.PhysicalSize ELSE 1 END)
		END
		) as TotalData,
		SUM(
CASE WHEN (R.extraFlags & 4) > 0 THEN
			(CASE WHEN (R.PhysicalStartOffset > R.LogicalOffSet) THEN
				(CASE WHEN (AFC.LogicalSize < R.PhysicalStartOffset) THEN 0
						WHEN ((AFC.LogicalSize - R.PhysicalStartOffset) > (R.LogicalSize + R.LogicalOffSet - R.PhysicalStartOffset)) THEN (R.LogicalSize + R.LogicalOffSet - R.PhysicalStartOffset)
						ELSE (AFC.LogicalSize - R.PhysicalStartOffset)
				END)
			ELSE
				(CASE WHEN (AFC.LogicalSize < R.LogicalOffSet ) THEN 0
						WHEN (AFC.LogicalSize - R.LogicalOffSet > R.LogicalSize) THEN R.LogicalSize
						ELSE AFC.LogicalSize - R.LogicalOffSet END)
			END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.LogicalSize > 0 THEN R.LogicalSize ELSE 1 END)
		ELSE
			(CASE WHEN (R.PhysicalStartOffset > R.PhysicalOffset) THEN
				(CASE WHEN (AFC.physicalSize < R.PhysicalStartOffset) THEN 0
						WHEN ((AFC.physicalSize - R.PhysicalStartOffset) > (R.physicalSize + R.physicalOffSet - R.PhysicalStartOffset)) THEN (R.physicalSize + R.physicalOffSet - R.PhysicalStartOffset)
						ELSE (AFC.physicalSize - R.PhysicalStartOffset)
				END)
			ELSE
				(CASE WHEN (AFC.physicalSize < R.physicalOffSet ) THEN 0
						WHEN (AFC.physicalSize - R.physicalOffSet > R.physicalSize) THEN R.physicalSize
						ELSE AFC.physicalSize - R.physicalOffSet END)
			END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.PhysicalSize > 0 THEN R.PhysicalSize ELSE 1 END)
		END
		) as TotalDataProcessed,
		-1
FROM	@tblCopyStreams copystream,
		ArchChunkToReplicate R WITH (NOLOCK),
		archFileCopy AFC WITH (NOLOCK)
WHERE	R.AdminJobId = @i_adminJobId
AND		copystream.DestinationCopyId > 0
AND		copystream.DestinationStream > 0
AND		R.DestCopyId = copystream.DestinationCopyId
AND		R.DestStreamNum = copystream.DestinationStream
AND		R.archFileId = AFC.archFileId
AND		R.commCellId = AFC.commCellId
AND		R.destCopyId = AFC.archCopyId
GROUP BY copystream.SourceCopyId, copystream.SourceStream, copystream.DestinationCopyId, copystream.DestinationStream
INSERT INTO @tblTotalDataToProcessByCopyStream
SELECT	copystream.SourceCopyId, copystream.SourceStream, 0, copystream.DestinationCopyId, copystream.DestinationStream, 0,
		SUM(
CASE WHEN (R.extraFlags & 4) > 0 THEN
			(CASE WHEN (R.PhysicalStartOffset > R.LogicalOffSet) THEN (R.LogicalOffSet + R.LogicalSize - R.PhysicalStartOffset) ELSE R.LogicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.LogicalSize > 0 THEN R.LogicalSize ELSE 1 END)
		ELSE
			(CASE WHEN (R.PhysicalStartOffset > R.PhysicalOffset) THEN (R.PhysicalOffset + R.PhysicalSize - R.PhysicalStartOffset) ELSE R.PhysicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.PhysicalSize > 0 THEN R.PhysicalSize ELSE 1 END)
		END
		) as TotalData,
		0,
		-1
FROM	@tblCopyStreams copystream,
		ArchChunkToReplicate R WITH (NOLOCK),
		archFileCopy AFC WITH (NOLOCK)
WHERE	R.AdminJobId = @i_adminJobId
AND		copystream.DestinationCopyId > 0
AND		copystream.DestinationStream = 0
AND		R.DestCopyId = copystream.DestinationCopyId
AND		R.DestStreamNum = 0
AND		R.archFileId = AFC.archFileId
AND		R.commCellId = AFC.commCellId
AND		R.destCopyId = AFC.archCopyId
GROUP BY copystream.SourceCopyId, copystream.SourceStream, copystream.DestinationCopyId, copystream.DestinationStream
IF EXISTS (SELECT * FROM @tblTotalDataToProcessByCopyStream WHERE DestinationCopyId = 0 AND SourceCopyId > 0)
BEGIN
	INSERT INTO @tblTotalDataToProcessByCopyStream
	SELECT	copystream.SourceCopyId, copystream.SourceStream, 0, copystream.DestinationCopyId, copystream.DestinationStream, 0,
			SUM(
CASE WHEN (R.extraFlags & 4) > 0 THEN
				(CASE WHEN (R.PhysicalStartOffset > R.LogicalOffSet) THEN (R.LogicalOffSet + R.LogicalSize - R.PhysicalStartOffset) ELSE R.LogicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.LogicalSize > 0 THEN R.LogicalSize ELSE 1 END)
			ELSE
				(CASE WHEN (R.PhysicalStartOffset > R.PhysicalOffset) THEN (R.PhysicalOffset + R.PhysicalSize - R.PhysicalStartOffset) ELSE R.PhysicalSize END)*@oneConstReal*unCompBytesSize/(CASE WHEN R.PhysicalSize > 0 THEN R.PhysicalSize ELSE 1 END)
			END
			) as TotalData,
			0,
			-1
	FROM	@tblCopyStreams copystream,
			ArchChunkToReplicate R WITH (NOLOCK),
			archFileCopy AFC WITH (NOLOCK)
	WHERE	R.AdminJobId = @i_adminJobId
	AND		R.SrcCopyId = copystream.SourceCopyId
	AND		R.SrcStreamNum = copystream.sourceStream
	AND		R.archFileId = AFC.archFileId
	AND		R.commCellId = AFC.commCellId
	AND		R.SrcCopyId = AFC.archCopyId
	GROUP BY copystream.SourceCopyId, copystream.SourceStream, copystream.DestinationCopyId, copystream.DestinationStream
END
UPDATE @tblTotalDataToProcessByCopyStream SET TotalDataTobeProcessed = TotalData - TotalDataProcessed
-- If DSA is enabled, remove the previous reservation attempts from JMJobStreams table if the RCID doesn't exist in MMREsourceToJob table.
UPDATE a
SET		SourceRCId = jobstream.SrcRCId, DestinationRCId = jobstream.DestRCId
FROM	@tblTotalDataToProcessByCopyStream a, ArchJobStreamStatus jobstream WITH (NOLOCK)
WHERE	jobstream.JobId = @i_adminJobId
AND		(jobstream.SrcRCId > 0 OR jobstream.DestRCId > 0)
AND		a.SourceCopyId = jobstream.SrcCopyId
AND		a.SourceStream = jobstream.SrcStreamNum
AND		a.DestinationCopyId = jobstream.DestCopyId
AND		a.DestinationStream = jobstream.DestStreamNum
UPDATE a
SET		SourceRCId = jobstream.SrcRCId, DestinationRCId = jobstream.DestRCId
FROM	@tblTotalDataToProcessByCopyStream a, JMJobStreams jobstream WITH (NOLOCK)
WHERE	jobstream.JobId = @i_adminJobId
AND		a.SourceRCId = 0 AND a.DestinationRCId = 0
AND		(jobstream.SrcRCId > 0 OR jobstream.DestRCId > 0)
AND		a.SourceCopyId = jobstream.SrcCopyId
AND		a.SourceStream = jobstream.streamNum
AND		a.DestinationCopyId = jobstream.DestCopyId
AND		a.DestinationStream = jobstream.DestStreamNum
SELECT copy.ArchGroupId, a.*
FROM @tblTotalDataToProcessByCopyStream a, ArchGroupCopy copy WITH (NOLOCK)
WHERE a.SourceCopyId = copy.Id
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkReplicateGetJobStreamProgress')
	delete from GxQscripts where name = 'AMChunkReplicateGetJobStreamProgress'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateGetJobStreamProgress')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateGetJobStreamProgress'
GO

insert into GXDBVersions values(2, 'AMChunkReplicateGetJobStreamProgress',  '00010002008400020000', 'AMChunkReplicateGetJobStreamProgress', '00010002008400020000')
GO

