

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkReplicateCreateNewReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkReplicateCreateNewReaders.sp,v $ $Id: AMChunkReplicateCreateNewReaders.sp,v 1.16.2.33.4.2 2021/04/27 22:43:08 pnara Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AMChunkReplicateCreateNewReaders')
BEGIN
	print '>>> Drop Stored Procedure: AMChunkReplicateCreateNewReaders <<<'
	drop procedure AMChunkReplicateCreateNewReaders
END
IF EXISTS (select * from GxQscripts where name='AMChunkReplicateCreateNewReaders')
	delete from GxQscripts where name = 'AMChunkReplicateCreateNewReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateCreateNewReaders')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateCreateNewReaders'
GO
print '... Creating Procedure: AMChunkReplicateCreateNewReaders'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AMChunkReplicateCreateNewReaders
  @i_adminJobId int,
  @i_jobToken varchar(128),
  @i_archGroupId int,
  @i_archCopyId int,
  @i_noOfStreams int,
  @i_checkIsNewStreamReaderPossible int = 0
AS
  DECLARE @o_streamReaderId int;
  DECLARE @o_ErrorCode int;
DECLARE @isIBMcopy BIT = 0
SET @isIBMcopy = (SELECT TOP 1 1 FROM  archGroup WITH (READUNCOMMITTED), JMAdminJobInfoTable WITH (READUNCOMMITTED)
WHERE jobId = @i_adminJobId AND archGrpID = id
AND flags & 67108864 > 0 )
IF OBJECT_ID('tempdb.dbo.#tblChunksSkippedDueToMediaOutisde') IS NOT NULL DROP TABLE #tblChunksSkippedDueToMediaOutisde
CREATE TABLE #tblChunksSkippedDueToMediaOutisde (adminJobId int,archFileiD int, CommcellId int, destCopyId int, BarCode varchar(256) )
DECLARE @NOW INTEGER;
SET		@NOW = dbo.GetUnixTime(GetUTCDate())
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
SET @o_ErrorCode = 0
-- Create new stream readers based on request from Media Agent side.
-- Use job id, copy id to figure out which segment can be readed from table ArchChunkToReplicate and then create new stream reader entries.
-- The new stream reader entries will be stored in table ArchJobStreamStatus with reservation status as false.
-- Later reservation logic will process such stream readers and try to allocate resources for each one of them.
-- The retrun values will be list newly created stream reader ids.
-- ArchGroupId and ArchCopyId will be used to identify which storage policy or source copy need to be processed during this call.
-- If neither of them are set, then we consider for the current job instead. The source copy will be multiple based on current job type (parallel or single stream).
if (OBJECT_ID('tempdb.dbo.#AMCR_ArchJobStreamStatus') IS NOT NULL) DROP TABLE #AMCR_ArchJobStreamStatus
	CREATE TABLE #AMCR_ArchJobStreamStatus
	(
	JobId				integer,
	JobToken			varchar(128),
	SrcCopyId			integer,
	SrcStreamNum		integer,
	SrcReservationId	integer,
	SrcRCId				integer,
	SrcMAId				integer,
	SrcDrivePoolId		integer,
	DestCopyId			integer,
	DestStreamNum		integer,
	DestReservationId	integer,
	DestRCId			integer,
	DestMAId			integer,
	DestDrivePoolId		integer,
	StreamReaderId		integer,
	SegmentId			integer default 0,
	FirstVolumeId		integer,
	FirstChunkId		integer,
	CommCellId			integer,
	Status				integer,
	ModifiedTime		integer,
	ReservationRequestId	integer default 0,
	TotalSizeToProcess	bigint,
	TotalSizeProcessed	bigint,
	destSIDBStoreId 	integer default 0,
	primary key (JobId, StreamReaderId, DestCopyId)
	);;
	INSERT INTO #AMCR_ArchJobStreamStatus
	SELECT	*
	FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
	WHERE	JobId = @i_adminJobId
	DELETE FROM #AMCR_ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		(
Status = 0x08
				OR
Status != 0x00
				AND		(
						DestRCId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCID = DestRCId)
						OR
						SrcRCId > 0 AND FirstVolumeId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCId = SrcRCId)
						)
				OR
Status = 0x04
				OR
Status = 0x00
				AND	ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	DECLARE @maxStreamReaderId int
	SELECT @maxStreamReaderId = ISNULL ((SELECT MAX(StreamReaderId) FROM ArchJobStreamStatusHistory WITH (NOLOCK) WHERE JobId = @i_adminJobId AND JobToken = @i_JobToken), 0)
	IF EXISTS (SELECT StreamReaderId FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId AND JobToken = @i_JobToken AND StreamReaderId > @maxStreamReaderId)
	BEGIN
		SELECT @maxStreamReaderId = ISNULL ((SELECT MAX(StreamReaderId) FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId AND JobToken = @i_JobToken), 0)
	END
	-- Logic for selecting which segment to be copied first.
	DECLARE @tblStreamReaderDetails TABLE (
		SrcCopyId		int,
		SrcStreamNum	int,
		DestCopyId		int,
		DestStreamNum	int,
		SegmentId		int,
		CommCellId		int,
		FirstChunkId	int,
		ChunkCommCellId	int,
		FirstVolumeId	int,
		IsMultiWrite	int,
		RowNum			int,
		TotalSizeToProcess	bigint,
		destSIDBStoreId int
	)
	DECLARE @tblSegmentIdList TABLE (
		StreamReaderId	int IDENTITY,
		SegmentId		int,
		TotalSizeToProcess	bigint
	)
	DECLARE @tblCopyDetails TABLE (
		SrcCopyId		int,
		DestCopyId		int,
		SegmentId		int,
		IsMultiWrite	int,
		TotalSizeToProcess	bigint
	)
	DECLARE @tblPartiallyCopiedChunk TABLE(
		srcCopyId		int,
		srcStreamNum	int,
		mediaGroupId	int,
		destCopyId		int,
		destStreamNum	int,
		commCellId		int,
		archChunkId		int,
		chunkCommCellId	int,
		copiedBytes		bigint,
		copiedUnCompBytes bigint,
		segmentId		int,
		skippedCount	int,
		selectOrder		int,
		primary key (srcCopyId, destCopyId, destStreamNum, segmentId, archChunkId, chunkCommCellId)
	)
	DECLARE @tblExcludedSegmentId TABLE(
		segmentId		int,
		primary key (segmentId)
	)
	DECLARE @maxConcurrency		int = 0
	DECLARE @noOfStreamReaders	int = 0
SET @maxConcurrency = CAST((CASE (CAST(dbo.GetJobOption(@i_adminJobId, 1109628066) as int))
WHEN 0 THEN (CAST(dbo.GetJobOption(@i_adminJobId, 2105046087) as int))
								ELSE 0
							   END) AS INT)
	SELECT @noOfStreamReaders = COUNT(DISTINCT StreamReaderId)
	FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK)
	WHERE JobId = @i_adminJobId
	AND JobToken = @i_JobToken
AND	(Status = 0x01 OR Status = 0x02) /*RESERVED, NITIALIZED*/
	IF @maxConcurrency > 0 AND @maxConcurrency <= @noOfStreamReaders
	BEGIN
SET @o_ErrorCode = 20054
		DELETE FROM @tblStreamReaderDetails
		GOTO EXIT_RETURN
	END
	ELSE IF @maxConcurrency > 0 AND @i_noOfStreams > (@maxConcurrency - @noOfStreamReaders)
	BEGIN
		SET @i_noOfStreams = @maxConcurrency - @noOfStreamReaders
	END
	UPDATE	ArchChunkToReplicate
SET		Status = (CASE WHEN JDS.disabled & (8192 | 256) > 0 THEN 6 ELSE 7 END)
	FROM	ArchChunkToReplicate R WITH (NOLOCK), JMJobDataStats JDS WITH (READUNCOMMITTED)
	WHERE	R.AdminJobId = @i_adminJobId
	AND		(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
	AND		(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
	AND		R.SegmentId > 0
	AND		NOT EXISTS (SELECT * FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = R.AdminJobId AND segmentId = R.SegmentId)
ANd		R.Status IN ( 5, 3, 0)
	AND		R.BackupJobId = JDS.JobID
	AND		R.destCopyId = JDS.archGrpCopyId
	AND		R.fileType = JDS.dataType
	AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (1 | 256)) > 0
	/* Duplicate statement to above
	UPDATE	ArchChunkToReplicate
SET		Status = 6
	FROM	ArchChunkToReplicate R WITH (NOLOCK), JMJobDataStats JDS WITH (READUNCOMMITTED)
	WHERE	R.AdminJobId = @i_adminJobId
	AND		(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
	AND		(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
	AND		R.SegmentId > 0
	AND		NOT EXISTS (SELECT * FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = R.AdminJobId AND segmentId = R.SegmentId)
ANd		R.Status IN ( 5, 3, 0)
	AND		R.BackupJobId = JDS.JobID
	AND		R.SrcCopyId = JDS.archGrpCopyId
	AND		R.fileType = JDS.dataType
	AND		R.CommCellid = JDS.CommCellId
AND		(JDS.disabled & (256)) > 0
	*/
	UPDATE	ArchChunkToReplicate
SET		Status = 6
	FROM	ArchChunkToReplicate R WITH (READUNCOMMITTED) LEFT OUTER JOIN ArchFileCopy AFC WITH (READUNCOMMITTED)
			ON	R.srcCopyId = AFC.archCopyId
				AND		R.archFileId = AFC.archFileId
				AND		R.CommCellid = AFC.CommCellId
	WHERE   R.AdminJobId = @i_adminJobId
AND		R.Status IN ( 5, 3, 0)
			AND		(AFC.archFileId IS NULL
OR		(AFC.flags & 256) > 0)
			AND 	R.segmentID > 0
	/*commenting this out as this check should suffice when done from amchunkreplicategetnext itself
	-- fastcopy fix for ndmp clients were chunks might be invalidated after being committed
	IF EXISTS( SELECT 1 FROM ArchChunkToReplicate R WITH (READUNCOMMITTED), App_Application aa WITH (READUNCOMMITTED)
				WHERE R.AdminJobId = @i_adminJobId
				AND		(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
				AND		(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
AND	R.appID = aa.id AND aa.appTypeId = 13
AND R.ExtraFlags & 64 > 0
AND	R.Status IN ( 5, 3, 0)
			)
		UPDATE	ArchChunkToReplicate
SET		Status = 6
		FROM	ArchChunkToReplicate R INNER JOIN archChunk AC WITH (READUNCOMMITTED)
				ON	R.archCHunkID = AC.id AND R.chunkCommCellid = AC.CommCellId, App_Application aa WITH (READUNCOMMITTED)
		WHERE   R.AdminJobId = @i_adminJobId
				AND		(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
				AND		(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
AND		R.Status IN ( 5, 3, 0)
AND		AC.flags & 256 > 0 AND AC.agedBy & 524288 > 0
AND 	R.ExtraFlags & 64 > 0
AND		R.appID = aa.id AND aa.appTypeId = 13
	*/
	-- Reset SKIPPED FOR RESOURCE flag based on the destination stream for all reader id gone
	UPDATE ArchChunkToReplicate
SET		Status = 0
	WHERE	AdminJobId = @i_adminJobId
	AND		(@i_archGroupId = 0 OR ArchGroupId = @i_archGroupId)
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		SegmentId > 0
	AND		NOT EXISTS (SELECT * FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = ArchChunkToReplicate.AdminJobId AND StreamReaderId = ArchChunkToReplicate.StreamReaderId)
AND		Status = 5 /*CVA_CHUNK_SKIPPED*/
	AND		DestCopyId > 0
	AND		(Modified + SkippedForSeconds) < @NOW
AND		(SkippedCount < @MAX_FAILURE_COUNT OR ExtraFlags & 64 > 0)
	-- Reset SKIPPED flag based on the destination stream for any failed count or time
	UPDATE ArchChunkToReplicate
SET		Status = 0
	WHERE	AdminJobId = @i_adminJobId
	AND		(@i_archGroupId = 0 OR ArchGroupId = @i_archGroupId)
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		SegmentId > 0
	AND		NOT EXISTS (SELECT * FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = ArchChunkToReplicate.AdminJobId AND segmentId = ArchChunkToReplicate.SegmentId)
AND		Status = 3 /*CVA_CHUNK_SKIPPED*/
	AND		DestCopyId > 0
	--AND		(
	--			EXISTS (SELECT Id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = ArchChunkToReplicate.DestCopyId AND isSnapCopy = 1)
	--			OR
	--			DestStreamNum > 0
	--		)
	AND		(
SkippedCount < @MAX_FAILURE_COUNT OR ExtraFlags & 64 > 0
			)
	AND		(
				SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
				OR
				(Modified + SkippedForSeconds) < @NOW
			)
	--AND	SkippedReason != CVA_AUXCOPY_RESERVATION_FAILURE
	IF EXISTS(	SELECT  1
				FROM    MMConfigs WITH (NOLOCK)
				WHERE   name = 'MMCONFIG_AUXCOPY_SKIP_UNAVAILABLE_MEDIA'
						AND value = 1)
	BEGIN
		INSERT INTO #tblChunksSkippedDueToMediaOutisde
		SELECT	DISTINCT R.adminJobId, R.archFileId, R.commCellId, R.destCopyId, M.BarCode
		FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
		WHERE	R.adminJobId = @i_adminJobId
AND R.Status IN (0, 3)
				AND R.MediaType != 10001
				AND R.MediaId = M.MediaId
				AND M.MediaLocation NOT IN (1,2) /*LOCATION_SLOT, LOCATION_DRIVE*/
		IF @@ROWCOUNT > 0
		BEGIN
			UPDATE	R
SET		Status = 8,
					Modified = @now
			FROM	archChunkToReplicate R,
					(SELECT	DISTINCT adminJobId, archFileId, commCellId, destCopyId
					FROM	#tblChunksSkippedDueToMediaOutisde
							) T
			WHERE	R.adminJobID = T.adminJobId
					AND R.archFileId = T.archFileId
					AND R.commCellId = T.commCellId
					AND R.destCopyId = T.destCopyId
AND R.Status IN (0, 3)
			DECLARE @NextEvIDTable      TABLE (id int)
			DECLARE @paramEvMsgId INT = 0
			INSERT INTO @NextEvIDTable
				EXECUTE GetNextEventId
			SELECT @paramEvMsgId = id FROM  @NextEvIDTable
			INSERT INTO EvMsg (id, TimeSource, TimeServer, Severity, Ack, Acked, Type,
				ParamNum, MessageId, JobId_h, JobId_l, ClientId, CommcellId,
				UserId, SubSystemId, Client, CommCell, UserName, SubSystem,
				MsgEnglish, RepeatCount, LastOccurrence, NextPost,
				mediaId, driveId, libraryId, maClientId)
				SELECT  @paramEvMsgId, @now, @now, 0, 0, 0, 0,
1, (2722 | (CAST(POWER(2, 24) AS BIGINT) * 62)), 0, @i_adminJobId, 0, 2,
					1, 0, '', 0, 0, 'JobManager', --user ID is always admin since it's an admin job
					'', 1, @now, 1,
					0, 0, 0, 0
			DECLARE @BarCodes VARCHAR(8000)
			SELECT @BarCodes = COALESCE(@BarCodes + ', ', '') + BarCode
			FROM (SELECT DISTINCT BarCode FROM #tblChunksSkippedDueToMediaOutisde) a
			INSERT INTO EvParam(EvMsgId, EventId, Position, Type, Size, Data)
SELECT @paramEvMsgId, (2722 | (CAST(POWER(2, 24) AS BIGINT) * 62)), 1, 0, 0, @BarCodes
		END
		UPDATE	R
SET		Status = 0,
				Modified = @now
		FROM	archChunkToReplicate R,
				(SELECT	R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
				FROM	archChunkToReplicate R WITH (READUNCOMMITTED), MMMedia M WITH (READUNCOMMITTED)
				WHERE	R.adminJobId = @i_adminJobId
						-- AND	(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
						-- AND	(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
AND R.Status = 8
						AND R.MediaType != 10001
						AND R.MediaId = M.MediaId
				GROUP BY R.adminJobId, R.archFileId, R.commCellId, R.destCopyId
				HAVING MIN(M.MediaLocation) IN (1,2) AND MAX(MediaLocation) IN (1,2) /*LOCATION_SLOT, LOCATION_DRIVE*/
						) T
		WHERE	R.adminJobID = T.adminJobId
				AND R.archFileId = T.archFileId
				AND R.commCellId = T.commCellId
				AND R.destCopyId = T.destCopyId
AND R.Status  = 8
	END
	IF NOT EXISTS (SELECT TOP 1 SegmentId FROM ArchChunkToReplicate a WITH (NOLOCK)
					WHERE	AdminJobId = @i_adminJobId
					AND		SegmentId > 0
AND		Status = 0 /*CVA_CHUNK_POPULATED*/
					AND		(@i_archGroupId = 0 OR a.ArchGroupId = @i_archGroupId)
					AND		(@i_archCopyId = 0 OR a.SrcCopyId = @i_archCopyId)
					AND		a.DestCopyId > 0 /*AND a.DestStreamNum = 0 AND a.SrcStreamNum = 0*/
					AND		SegmentId NOT IN (SELECT SegmentId FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId)
				)
	BEGIN
		UPDATE ArchChunkToReplicate
SET		Status = 0, SkippedReason = 0, SkippedForSeconds = 0, ErrorCode = 0, Modified = @now
		WHERE	adminJobId = @i_adminJobId
AND		Status = 3
AND		SkippedReason = 0X13
		AND		SegmentId NOT IN (SELECT SegmentId FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId)
	END
	DELETE FROM @tblExcludedSegmentId
	INSERT INTO @tblExcludedSegmentId
SELECT DISTINCT SegmentId FROM ArchChunkToReplicate WITH (NOLOCK) WHERE AdminJobId = @i_adminJobId AND Status = 1
	INSERT INTO @tblPartiallyCopiedChunk
	SELECT c.*
	FROM	(
				SELECT	DISTINCT a.SrcCopyId, a.SrcStreamNum, a.MediaGroupId, a.DestCopyId, a.DestStreamNum, a.CommCellId, a.ArchChunkId, a.ChunkCommCellId,
SUM(CASE WHEN (a.extraFlags & 4) > 0 THEN a.LogicalSize - a.LogicalOffset ELSE a.PhysicalSize - a.PhysicalOffset END) AS copiedBytes,
						0 /*CAST((SUM( CASE WHEN a.physicalSize = 0 THEN (b.physicalSize - a.physicalOffset) ELSE (((b.physicalSize - a.physicalOffset)*@oneConstReal*a.unCompBytesSize)/ a.physicalSize)  END)) AS BIGINT) AS copiedUnCompBytes*/ size,
						a.segmentId, MAX(a.skippedCount) as skippedCount,
						-- If the destination stream is set and same stream number reserved already, skip current segment for disk media as the reservation will fail later.
						MAX(CASE WHEN reserved.DestCopyId IS NULL OR reserved.DestStreamNum IS NULL OR a.MediaType != 10001 THEN 0 ELSE 1 END) as selectOrder
				FROM	ArchChunkToReplicate a WITH (nolock)
						LEFT JOIN (SELECT DISTINCT DestCopyId, DestStreamNum, JobId FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = @i_adminJobId) reserved
						ON reserved.DestCopyId = a.DestCopyId AND reserved.DestStreamNum = a.DestStreamNum AND reserved.jobId = a.AdminJobId,
						archFileCopy b WITH (nolock)
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SegmentId > 0
AND		a.Status = 0 /*CVA_CHUNK_POPULATED*/
				AND		(@i_archGroupId = 0 OR a.ArchGroupId = @i_archGroupId)
				AND		(@i_archCopyId = 0 OR a.SrcCopyId = @i_archCopyId)
				AND		a.DestCopyId > 0
				AND		(
							EXISTS (SELECT Id FROM ArchGroupCopy WITH (NOLOCK) WHERE id = a.DestCopyId AND isSnapCopy = 1)
							OR
							(a.DestStreamNum > 0 AND a.SrcStreamNum > 0)
						)
				AND		NOT EXISTS (SELECT 1 FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = a.AdminJobId AND segmentId = a.SegmentId)
				AND		(
							a.ArchFileId = b.ArchFileId AND
							a.CommCellId = b.CommCellId AND
							a.DestCopyId = b.ArchCopyId AND
(	((a.extraFlags & 4) > 0 AND B.LogicalSize > 0 AND B.LogicalSize < (A.LogicalOffset + A.LogicalSize))
								OR
((a.extraFlags & 4) = 0 AND B.physicalSize > 0 AND B.physicalSize < (A.physicalOffset + A.PhysicalSize))
							)
							--a.PhysicalOffset = b.PhysicalOffset AND
							--b.isValid = 0
						)
				GROUP BY a.SrcCopyId, a.SrcstreamNum, a.mediaGroupId, a.DestCopyId, a.destStreamNum, a.commCellId, a.archChunkId, a.ChunkCommCellId, a.segmentId
			) as c left join @tblExcludedSegmentId d ON d.segmentId = c.SegmentId
	WHERE d.segmentId IS NULL
	IF EXISTS (SELECT * FROM @tblPartiallyCopiedChunk)
	BEGIN
		-- This is list of segments that for new readers
		INSERT INTO @tblSegmentIdList
		SELECT TOP (@i_noOfStreams) SegmentId, 0
		FROM	@tblPartiallyCopiedChunk a LEFT JOIN
				(SELECT DestCopyId, COUNT(DISTINCT StreamReaderId) as noOfReserves FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId GROUP BY DestCopyId) b
				ON a.DestCopyId = b.DestCopyId
		GROUP BY SegmentId
		ORDER BY
			MAX(a.selectOrder),
			MAX(a.skippedCount),
			MAX(ISNULL(b.noOfReserves, 0)) ,
			COUNT(DISTINCT a.DestCopyId) DESC,
			MIN(chunkCommCellId), MIN(ArchChunkId) --, SUM(copiedBytes)
		-- This is the copy info for each segment. Some copies may already have data processed partially or completely.
		-- Therefore, for each segment it may or may not have data for all the copies.
		INSERT	INTO @tblStreamReaderDetails
		SELECT	DISTINCT b.srcCopyId, b.srcStreamNum, b.destCopyId, b.destStreamNum,
				a.segmentId,
				b.CommCellId, b.ArchChunkId, b.chunkCommCellId,
				0, 0,
				(a.StreamReaderId + @maxStreamReaderId) as RowNum,
				0,
				b.destSIDBStoreId
		FROM	@tblSegmentIdList a,
				(
					SELECT srcCopyId, srcStreamNum, destCopyId, destStreamNum, seg.segmentId, CommCellId, ArchChunkId, ChunkCommCellId,
							ROW_NUMBER() OVER (PARTITION BY srcCopyId, /*srcStreamNum,*/ destCopyId, destStreamNum, seg.segmentId, CommCellId ORDER BY ChunkCommCellId, ArchChunkId) as num,
							chunk.destSIDBStoreId
					FROM	ArchChunkToReplicate chunk WITH (NOLOCK), @tblSegmentIdList seg
					WHERE	seg.SegmentId = chunk.SegmentId
					AND		chunk.AdminJobId = @i_adminJobId
AND		chunk.Status = 0 /*CVA_CHUNK_POPULATED*/
					AND		(@i_archGroupId = 0 OR chunk.ArchGroupId = @i_archGroupId)
					AND		(@i_archCopyId = 0 OR chunk.SrcCopyId = @i_archCopyId)
				) b
		WHERE	a.SegmentId = b.SegmentId
		AND		b.num = 1
		SELECT @maxStreamReaderId = MAX(RowNum) FROM @tblStreamReaderDetails
	END
	DECLARE @streamCount int
	SET @streamCount = ISNULL((SELECT COUNT(*) FROM @tblStreamReaderDetails), 0)
	-- select new segment
	IF @i_noOfStreams - @streamCount > 0
	BEGIN
		DELETE FROM @tblSegmentIdList
		INSERT INTO @tblSegmentIdList
		SELECT TOP (@i_noOfStreams - @streamCount) segment.SegmentId, 0
		FROM	(SELECT a.SegmentId, a.MediaType,
				MAX(ISNULL(b.noOfReserves, 0)) as noOfRes,
				COUNT(DISTINCT a.DestCopyId) as copyCount, MIN(a.chunkCommCellId) as commCellId, MIN(a.ArchChunkId) as chunkId,
				MAX(a.SkippedCount) skippedCount,
				MAX(a.DestCopyId) DestCopyId,
				MAX(a.DestStreamNum) DestStreamNum
				FROM	ArchChunkToReplicate a WITH (NOLOCK) LEFT JOIN
						(SELECT DestCopyId, JobId, COUNT(DISTINCT StreamReaderId) as noOfReserves FROM #AMCR_ArchJobStreamStatus  WITH (NOLOCK) WHERE JobId = @i_adminJobId GROUP BY DestCopyId, JobId) b
						ON a.DestCopyId = b.DestCopyId AND a.adminJobId = b.JobId
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SegmentId > 0
AND		a.Status = 0 /*CVA_CHUNK_POPULATED*/
				AND		(@i_archGroupId = 0 OR a.ArchGroupId = @i_archGroupId)
				AND		(@i_archCopyId = 0 OR a.SrcCopyId = @i_archCopyId)
				AND		a.DestCopyId > 0 /*AND a.DestStreamNum = 0 AND a.SrcStreamNum = 0*/
				GROUP BY a.SegmentId, a.MediaType
				) segment
				LEFT JOIN @tblExcludedSegmentId excluded ON excluded.segmentId = segment.SegmentId
				LEFT JOIN (SELECT DISTINCT segmentId FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = @i_adminJobId) reserved ON reserved.segmentId = segment.SegmentId
				-- If the destination stream is set and same stream number reserved already, skip current segment for disk media as the reservation will fail later.
				LEFT JOIN (SELECT DISTINCT DestCopyId, DestStreamNum FROM #AMCR_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = @i_adminJobId) stream ON stream.DestCopyId = segment.DestCopyId AND stream.DestStreamNum = segment.DestStreamNum
		WHERE   segment.SegmentId NOT IN (SELECT SegmentId FROM @tblStreamReaderDetails)
		AND		excluded.segmentId IS NULL
		AND		reserved.segmentId IS NULL
		ORDER BY
			CASE WHEN stream.DestCopyId IS NULL OR stream.DestStreamNum IS NULL OR segment.MediaType != 10001 THEN 0 ELSE 1	 END,
			segment.skippedCount, segment.noOfRes, segment.copyCount DESC, segment.commcellId, segment.chunkId
		INSERT	INTO @tblStreamReaderDetails
		SELECT	DISTINCT b.srcCopyId, b.srcStreamNum, b.destCopyId, b.destStreamNum,
				a.segmentId,
				b.CommCellId, b.ArchChunkId, b.chunkCommCellId,
				0, 0,
				(a.StreamReaderId + @maxStreamReaderId) as RowNum,
				0,
				b.destSIDBStoreId
		FROM	@tblSegmentIdList a,
				(
					SELECT srcCopyId, srcStreamNum, destCopyId, destStreamNum, seg.segmentId, CommCellId, ArchChunkId, ChunkCommCellId,
							ROW_NUMBER() OVER (PARTITION BY srcCopyId, /*srcStreamNum,*/ destCopyId, destStreamNum, seg.segmentId, CommCellId ORDER BY ChunkCommCellId, ArchChunkId) as num,
							chunk.destSIDBStoreId
					FROM	ArchChunkToReplicate chunk WITH (NOLOCK), @tblSegmentIdList seg
					WHERE	seg.SegmentId = chunk.SegmentId
					AND		chunk.AdminJobId = @i_adminJobId
AND		chunk.Status = 0 /*CVA_CHUNK_POPULATED*/
					AND		(@i_archGroupId = 0 OR chunk.ArchGroupId = @i_archGroupId)
					AND		(@i_archCopyId = 0 OR chunk.SrcCopyId = @i_archCopyId)
				) b
		WHERE	a.SegmentId = b.SegmentId
		AND		b.num = 1
	END
	UPDATE 	a
	SET		TotalSizeToProcess = ISNULL((SELECT	SUM(chunk.unCompBytesSize)
										FROM	ArchChunkToReplicate chunk  WITH (READUNCOMMITTED)
										WHERE	chunk.AdminJobId = @i_adminJobId
AND		chunk.Status IN (0, 3)
										AND		a.SegmentId = chunk.SegmentId
										AND		a.SrcCopyId = chunk.srcCopyId
										AND		a.DestCopyId = chunk.destCopyId), 0)
	FROM	@tblStreamReaderDetails a
	--Do not populate volumeId for snap data
	UPDATE @tblStreamReaderDetails
	SET		FirstVolumeId = ISNULL(b.VolumeId, 0)
	FROM	@tblStreamReaderDetails a, ArchChunk b WITH (NOLOCK), ArchGroupCopy AGC WITH(READUNCOMMITTED)
	WHERE	a.ChunkCommCellId = b.CommcellId
	AND		a.FirstChunkId = b.Id
	AND		a.SrcCopyId = AGC.id
	AND		(AGC.isSnapCopy = 0 OR ( AGC.isSnapCopy = 1 AND a.SrcStreamNum = 1))   --StreamId will be greater than 1 for snap data
	UPDATE @tblStreamReaderDetails
SET		IsMultiWrite = CASE WHEN b.Flags & 2048 > 0 THEN 1 ELSE 0 END
	FROM	@tblStreamReaderDetails a, ArchGroupCopy b WITH (NOLOCK)
	WHERE	a.DestCopyId > 0
	AND		a.DestCopyId = b.Id
EXIT_RETURN:
if (OBJECT_ID('tempdb.dbo.#AMCR_ArchJobStreamStatus') IS NOT NULL) DROP TABLE #AMCR_ArchJobStreamStatus
	IF (@i_checkIsNewStreamReaderPossible = 1)
	BEGIN
		SELECT ISNULL((SELECT MAX(RowNum) FROM @tblStreamReaderDetails), 0), @o_ErrorCode
		RETURN
	END
	-- Remove all the processed StreamReader but wtih no valid RCId
	INSERT INTO ArchJobStreamStatusHistory (
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		ModifiedTime,
		ReservationRequestId,
		ModifiedReason,
		destSIDBStoreId
	)
	SELECT
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		dbo.GetUnixTime(getutcdate()),
		ReservationRequestId,
'DELETE DUE TO ' + CASE WHEN Status = 0x08	THEN 'STREAM RELEASED'
WHEN Status = 0x04	THEN 'STREAM FAILURE'
WHEN Status = 0x00	THEN 'RESERVATION REQUEST TIMEOUT'
								ELSE	'RESERVATION INVALID' END,
		destSIDBStoreId
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		(
Status = 0x08
				OR
Status != 0x00
				AND		(
						DestRCId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCID = DestRCId)
						OR
						SrcRCId > 0 AND FirstVolumeId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCId = SrcRCId)
						)
				OR
Status = 0x04
				OR
Status = 0x00
				AND	ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	DELETE FROM ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
	AND		(@i_archCopyId = 0 OR SrcCopyId = @i_archCopyId)
	AND		(
Status = 0x08
				OR
Status != 0x00
				AND		(
						DestRCId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCID = DestRCId)
						OR
						SrcRCId > 0 AND FirstVolumeId > 0 AND NOT EXISTS (SELECT RCID FROM MMResourceToJob WITH (NOLOCK) WHERE JobId_l = @i_adminJobId AND RCId = SrcRCId)
						)
				OR
Status = 0x04
				OR
Status = 0x00
				AND	ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	IF EXISTS (SELECT * FROM @tblStreamReaderDetails)
	BEGIN
		INSERT INTO ArchJobStreamStatus (
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			ModifiedTime,
			ReservationRequestId,
			TotalSizeToProcess, TotalSizeProcessed,
			destSIDBStoreId
		)
		SELECT
			@i_adminJobId, @i_jobToken,
			SrcCopyId, SrcStreamNum, 0, 0, 0, 0,
			DestCopyId, DestStreamNum, 0, 0, 0, 0,
			RowNum,
			SegmentId, FirstVolumeId, FirstChunkId, ChunkCommCellId,
			0 /*NOT RESERVED, NOT INITIALIZED*/,
			dbo.GetUnixTime(getutcdate()),
			0,
			TotalSizeToProcess, 0,
			destSIDBStoreId
		FROM	@tblStreamReaderDetails
		--WHERE	(@i_archCopyId = 0 OR @i_archCopyId = SrcCopyId)
		INSERT INTO ArchJobStreamStatusHistory (
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			ModifiedTime,
			ReservationRequestId,
			ModifiedReason,
			destSIDBStoreId
		)
		SELECT
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			dbo.GetUnixTime(getutcdate()),
			ReservationRequestId,
			'CREATE',
			destSIDBStoreId
		FROM	ArchJobStreamStatus  WITH (NOLOCK)
		WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
AND		Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
		SELECT	DISTINCT StreamReaderId, 0
		FROM	ArchJobStreamStatus  WITH (NOLOCK)
		WHERE	JobId = @i_adminJobId AND JobToken = @i_JobToken
AND		Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
	END
	ELSE
	BEGIN
		-- When dash copy or auxcopy job does interruption, and new data reader cannot be created, interrupted resource will be kept in database.
		-- Since there is no reservation attempt, such resouces cannot be used any jobs until current one completes or does reservations again.
		-- That may put a long delay especially using tape library. Here is to remove any interrupted resources.
		IF EXISTS (SELECT 1 FROM MMResource with (readuncommitted) where HasJobInterrupted = 1 and ReservationId in
  					 (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @i_adminJobId))
		BEGIN
			-- check if interrupted resource can be claimed
			-- There is no need to check the status in MMResource, as long as the entry MMResourceToJob is marked released for interrupted jobs.
			--if exists (select * from MMResource with (readuncommitted) where intrjobid_l = @jobId and Released = 0)
			if not exists (select 1 from MMResourceToJob with (readuncommitted) where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @i_adminJobId)
and NOT (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0))))
and not exists (select 1 from MMResource with (readuncommitted) where intrjobid_l = @i_adminJobId and DriveId in (select DriveId from MMDrive with (readuncommitted) where MountStatus in (2, 3)))
			begin
				declare @interruptResId table (id integer)
				-- release interrupted resource
				delete from MMresourceToJob
				where ReservationId in (select ReservationId from MMResource with (readuncommitted) where intrjobid_l = @i_adminJobId)
and (releasetime != 0 and (inuse = 0 OR (ReserveBitMask & (~2) = 0)))
				delete from MMResource where intrjobid_l = @i_adminJobId
				-- to make thing simpler, just delete all the reservations for the job, and re-reserve again
				-- those are place holder anyway, also we will have to check availability of everything
				insert into @interruptResId
				select reservationid from MMResource with (readuncommitted) where ReservationId in (select ReservationId from MMResourceToJob with (readuncommitted) where JobId_l = @i_adminJobId)  and HasJobInterrupted = 1
				delete from MMResourceToJob where ReservationId in (select id from @interruptResId)
				delete from MMResource where ReservationId in (select id from @interruptResId)
			END
		END
		SELECT 0, @o_ErrorCode
	END
IF (@isIBMcopy = 1)
BEGIN
	DECLARE @retVal INT = 0
	DECLARE @magneticBytes BIGINT = 0
	IF OBJECT_ID('tempdb.dbo.#ToBeAgedAFC') IS NOT NULL DROP TABLE #ToBeAgedAFC
	IF OBJECT_ID('tempdb.dbo.#AFCInfo') IS NOT NULL DROP TABLE #AFCInfo
	CREATE TABLE #ToBeAgedAFC (
    archFileId INT, commCellId INT, archCopyId INT,
    PRIMARY KEY (archFileId, commCellId, archCopyId))
	CREATE TABLE #AFCInfo (
    archFileId INT, commCellId INT, archCopyId INT, flags INT, streamNum INT, encRSA INT, encKeyType INT, encKey INT, encKeyId INT )
	INSERT	INTO #AFCInfo
	OUTPUT INSERTED.archFileId, INSERTED.commCellId, INSERTED.archCopyId INTO #ToBeAgedAFC
	SELECT	DISTINCT AFC.archFileId, AFC.commCellId, AFC.archCopyId, AFC.flags , AFC.streamNum , AFC.encRSA , AFC.encKeyType , AFC.encKey , AFC.encKeyId
	FROM    ArchJobStreamStatus AJS WITH (READUNCOMMITTED) , archChunkToReplicate A WITH (READUNCOMMITTED), archFileCopy AFC WITH (READUNCOMMITTED)
	WHERE   AJS.JobId = @i_adminJobId
		AND AJS.JobToken = @i_JobToken
AND AJS.Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
        AND AJS.JobId = A.adminJobId
        AND AJS.srcCopyId = A.SrcCopyId
        AND AJS.destCopyId = A.destCopyId
        AND AJS.segmentId = A.segmentId
AND A.Status IN (0, 3)
        AND A.archFileId = AFC.archFileId
        AND A.commCellId = AFC.CommCellId
        AND A.destCopyId = AFC.archCopyId
        AND AFC.isValid = 0
        AND AFC.physicalSize > 0
	IF EXISTS (SELECT * FROM #ToBeAgedAFC)
	BEGIN
EXEC @retVal = archFileSetAgedViaTable 17179869184, @now
		IF (@retVal = 0)
			EXEC @retVal = archFileDeleteViaTable 0, @magneticBytes OUTPUT
		UPDATE ArchChunkToReplicate
SET     Status = 0, Modified = @now
		FROM #ToBeAgedAFC A, ArchChunkToReplicate R
		WHERE   R.adminJobId = @i_adminJobId
			AND A.archFileId = R.ArchFileId
			AND A.commCellId = R.commCellId
			AND A.archCopyId = R.DestCopyId
		INSERT INTO archFileCopy
		SELECT archFileId, commCellId, archCopyId, flags, 0, streamNum, 0, 0, 0, 0, encRSA, encKeyType, encKey, @now, 0, 0, encKeyId, -1
		FROM #AFCInfo
	END
END
IF OBJECT_ID('tempdb.dbo.#tblChunksSkippedDueToMediaOutisde') IS NOT NULL DROP TABLE #tblChunksSkippedDueToMediaOutisde
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkReplicateCreateNewReaders')
	delete from GxQscripts where name = 'AMChunkReplicateCreateNewReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkReplicateCreateNewReaders')
	delete from GXDBVersions where aliasname = 'AMChunkReplicateCreateNewReaders'
GO

insert into GXDBVersions values(2, 'AMChunkReplicateCreateNewReaders',  'v1.16.2.33.4.2', 'AMChunkReplicateCreateNewReaders', 'v1.16.2.33.4.2')
GO

