

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkRecoverDDBRemoveUnreservedReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkRecoverDDBRemoveUnreservedReaders.sp,v $ $Id: AMChunkRecoverDDBRemoveUnreservedReaders.sp,v 1.1.2.3 2019/05/03 14:56:14 cliu Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF

IF EXISTS (select * from sysobjects where name='AMChunkRecoverDDBRemoveUnreservedReaders')
BEGIN
	print '>>> Drop Stored Procedure: AMChunkRecoverDDBRemoveUnreservedReaders <<<'
	drop procedure AMChunkRecoverDDBRemoveUnreservedReaders
END
IF EXISTS (select * from GxQscripts where name='AMChunkRecoverDDBRemoveUnreservedReaders')
	delete from GxQscripts where name = 'AMChunkRecoverDDBRemoveUnreservedReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkRecoverDDBRemoveUnreservedReaders')
	delete from GXDBVersions where aliasname = 'AMChunkRecoverDDBRemoveUnreservedReaders'
GO
print '... Creating Procedure: AMChunkRecoverDDBRemoveUnreservedReaders'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AMChunkRecoverDDBRemoveUnreservedReaders
  @i_adminJobId int,
  @i_streamReaderIdList XML,
  @i_dummy INTEGER
AS
  DECLARE @o_noOfDeletedStreamReaders int;
  DECLARE @o_ErrorCode int;
SET @o_noOfDeletedStreamReaders = 0
SET @o_ErrorCode = 0
DECLARE @tblStreamReaders TABLE (Id int)
INSERT INTO @tblStreamReaders
SELECT DISTINCT isnull(params.value('@id', 'int'), 0) as StreamReaderId
FROM	@i_streamReaderIdList.nodes('/StreamReaderList/StreamReader') AS R(params)
SELECT @o_noOfDeletedStreamReaders = COUNT(*) FROM @tblStreamReaders WHERE Id > 0
IF @o_noOfDeletedStreamReaders = 0
BEGIN
	INSERT INTO @tblStreamReaders
	SELECT DISTINCT StreamReaderId
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId
	AND		(
Status != 0x00 AND	SrcRCId = 0
			OR
Status = 0x00
			OR
Status = 0x04
			)
	INSERT INTO ArchJobStreamStatusHistory (
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		ModifiedTime,
		ReservationRequestId,
		ModifiedReason
	)
	SELECT
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		dbo.GetUnixTime(getutcdate()),
		ReservationRequestId,
		'DELETE'
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId
	AND		StreamReaderId IN (select Id from @tblStreamReaders)
AND		Status != 0x00 AND Status != 0x04
	DELETE FROM ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId
	AND		StreamReaderId IN (select Id from @tblStreamReaders)
	SELECT @o_noOfDeletedStreamReaders = COUNT(*) FROM @tblStreamReaders WHERE Id > 0
END
ELSE
BEGIN
	DELETE tmpTbl
	FROM	@tblStreamReaders tmpTbl, ArchJobStreamStatus stream WITH (NOLOCK)
	WHERE	tmpTbl.Id = stream.StreamReaderId
	AND		stream.JobId = @i_adminJobId
AND	 	stream.Status NOT IN (0x00, 0x04)
	DELETE FROM ArchJobStreamStatusHistory
	WHERE JobId = @i_adminJobId
	AND		StreamReaderId IN (SELECT Id FROM @tblStreamReaders WHERE Id > 0)
	DELETE FROM ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId
	AND		StreamReaderId IN (SELECT Id FROM @tblStreamReaders WHERE Id > 0)
END
EXIT_RETURN:
	SELECT @o_noOfDeletedStreamReaders, @o_ErrorCode
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkRecoverDDBRemoveUnreservedReaders')
	delete from GxQscripts where name = 'AMChunkRecoverDDBRemoveUnreservedReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkRecoverDDBRemoveUnreservedReaders')
	delete from GXDBVersions where aliasname = 'AMChunkRecoverDDBRemoveUnreservedReaders'
GO

insert into GXDBVersions values(2, 'AMChunkRecoverDDBRemoveUnreservedReaders',  '00010001000200030000', 'AMChunkRecoverDDBRemoveUnreservedReaders', '00010001000200030000')
GO

