

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkRecoverDDBGetNextChunks.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkRecoverDDBGetNextChunks.sp,v $ $Id: AMChunkRecoverDDBGetNextChunks.sp,v 1.1.2.13 2020/11/09 08:57:07 sjohnson Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON


IF EXISTS (select * from sysobjects where name='AMChunkRecoverDDBGetNextChunks')
BEGIN
	print '>>> Drop Stored Procedure: AMChunkRecoverDDBGetNextChunks <<<'
	drop procedure AMChunkRecoverDDBGetNextChunks
END
IF EXISTS (select * from GxQscripts where name='AMChunkRecoverDDBGetNextChunks')
	delete from GxQscripts where name = 'AMChunkRecoverDDBGetNextChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkRecoverDDBGetNextChunks')
	delete from GXDBVersions where aliasname = 'AMChunkRecoverDDBGetNextChunks'
GO
print '... Creating Procedure: AMChunkRecoverDDBGetNextChunks'
GO
SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON
GO
create procedure AMChunkRecoverDDBGetNextChunks
  @i_adminJobId int,
  @i_streamReaderId int
AS
  DECLARE @o_volumeId integer;
  DECLARE @o_minChunkId bigint;
  DECLARE @o_maxChunkId bigint;
  DECLARE @o_curChunkId bigint;
  DECLARE @o_mountPathId integer;
  DECLARE @o_cacheMountPathId integer;
  DECLARE @o_chunkId bigint;
  DECLARE @o_chunkCommCellId integer;
  DECLARE @o_physicalSize bigint;
  DECLARE @o_logicalSize bigint;
  DECLARE @o_applicationSize bigint;
  DECLARE @o_volBlockSize integer;
DECLARE @i_archGroupId		int = 0
DECLARE @i_archCopyId		int = 0
DECLARE @i_segmentId		int = 0
-- Select next chunk list based on the given stream reader id.
-- Use job id, copy id and stream reader id to identify current in use reader from table ArchJobStreamStatus.
-- It will give current segmentId, which can be used to figure out the next chunk/volume list from table ArchChunkToRecoverDDB.
-- The return value will be list of uncopied chunks for the given stream reader.
DECLARE @NOW INTEGER;
SET		@NOW = dbo.GetUnixTime(GetUTCDate())
IF @i_streamReaderId = 0
	GOTO ERROR_EXIT
DECLARE @MAX_CHUNK_PER_REQ	INT = 10
SET @MAX_CHUNK_PER_REQ = ISNULL( (SELECT Value FROM MMConfigs WHERE NAME = 'MMS2_CONFIG_STRING_AUXCOPY_MAX_CHUNKS_PER_COPY_REQ'), 10)
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
DECLARE @commCellId				integer = 0
DECLARE @currentSourceVolumeId	integer = 0
DECLARE @currentSourceMAId		integer = 0
DECLARE @currentSourceDPId		integer = 0
DECLARE @currentReservationId	integer = 0
DECLARE @currentRCId			integer = 0
DECLARE @currentDestStreamNum	integer = 0
DECLARE @currentSrcStreamNum	integer = 0
DECLARE @currentSourceMediaId	integer = 0
DECLARE @currentSourceMountPathId	integer = 0
DECLARE @currentSourceCacheMountPathId	integer = 0
DECLARE @currentSourceDeviceId		integer = 0
DECLARE @oldSourceVolumeId		integer = 0
DECLARE @oldSourceMountPathId	integer = 0
DECLARE @oldSourceDeviceId		integer = 0
  DECLARE @getMAAndDPForVolumeResult TABLE (
	retCode			integer,
mediaAgentName	varchar(1024),
	clientId		integer,
	nasClientId		integer,
	clientReleaseId	integer,
filerName		varchar(1024),
	hostId			integer,
	drivepoolId		integer,
	drivepoolType	integer,
	libraryId		integer,
	libraryTypeId	integer,
	libraryAttribute integer,
libraryName			varchar(128),
libraryAliasName	nvarchar(128),
barcode			varchar(256),
	volumeId		integer,
	mediaLocation	integer,
	jobOpType		integer,
	failureType		integer
  )
  DELETE from @getMAAndDPForVolumeResult
DECLARE @tblTriedVolumesList TABLE
(
	segmentId		integer,
	volumeId		integer,
	PRIMARY KEY (segmentId, volumeId)
)
DECLARE @tblTriedSegmentList TABLE
(
	segmentId		integer,
	primary key (segmentId)
)
DECLARE @tblExcludedSegmentId TABLE(
	segmentId		int,
	primary key (segmentId)
)
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
CREATE TABLE #tblNextSegments
(
	segmentId		int,
	destCopyId		int,
	destStreamNum	int,
	firstVolumeId	int,
	firstChunkId	int,
	primary key (segmentId, destCopyId)
)
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
CREATE TABLE #tblNextVolumes
(
	volumeId int,
	mediaId int,
	recordingFormatId int,
	libraryId int,
	mountPathId int,
	deviceId int,
	segmentId int,
	ChunkIdRowNumber int
)
CREATE CLUSTERED INDEX #tblNextVolumes_VolumeId_MediaId_Idx ON #tblNextVolumes (volumeId, mediaId)
-- For parallel copy, source info should be the same for all the destinations, but the current chunk and volume may be different among the destination copies.
-- TODO: How to handle request for multiple StreamReaderId?
SELECT TOP 1
		@i_streamReaderId = CASE WHEN @i_streamReaderId = 0 THEN StreamReaderId ELSE @i_streamReaderId END,
		@i_segmentId = CASE WHEN @i_segmentId = 0 THEN SegmentId ELSE @i_segmentId END,
		@i_archCopyId = CASE WHEN @i_archCopyId = 0 THEN SrcCopyId ELSE @i_archCopyId END,
		@currentReservationId = SrcReservationId,
		@currentRCId = SrcRCId,
		@currentSourceVolumeId = FirstVolumeId,
		@currentSourceMAId = SrcMAId,
		@currentSourceDPId = SrcDrivePoolId,
		@currentDestStreamNum = DestStreamNum,
		@currentSrcStreamNum = SrcStreamNum
FROM	ArchJobStreamStatus WITH (NOLOCK)
WHERE	JobId = @i_adminJobId
AND		StreamReaderId = @i_streamReaderId
ORDER BY jobId, StreamReaderId, CommCellId, FirstChunkId
IF @i_segmentId = 0 OR @i_archCopyId = 0
	GOTO ERROR_EXIT
SELECT @currentSourceMediaId = MediaId
FROM	MMVolume WITH (NOLOCK)
WHERE	VolumeId = @currentSourceVolumeId
SELECT @currentSourceMountPathId = device.MountPathId, @currentSourceDeviceId = device.DeviceId
FROM	MMMediaSide side WITH (NOLOCK), MMMountPath mp WITH (NOLOCK), MMMountPathToStorageDevice device WITH (NOLOCK)
WHERE	side.MediaId = @currentSourceMediaId
AND		side.MediaSideId = mp.MediaSideId
AND		device.MountPathId = mp.MountPathId
-- If using DSA, we don't knwo the source stream number at this point when reservation is just done and this is the first call for getNExtChuck.
-- Figure out a source number and use it directly
IF @currentSrcStreamNum = 0 -- AND @currentDestStreamNum = 0
BEGIN
	DECLARE @noOfStreamReaders	int = 0
	SELECT @noOfStreamReaders = COUNT(DISTINCT StreamReaderId)
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId
	AND		SrcStreamNum > 0
	AND		DestStreamNum = 0
	SELECT	TOP 1 @currentSrcStreamNum = stream
	FROM	ArchStream WITH (NOLOCK)
	WHERE	archGroupCopyId = @i_archCopyId
	AND		stream NOT IN (
							SELECT	SrcStreamNum
							FROM	ArchJobStreamStatus WITH (NOLOCK)
							WHERE	JobId = @i_adminJobId
							AND		SrcStreamNum > 0
							AND		DestStreamNum = 0
							AND		SrcCopyId = @i_archCopyId
						)
	ORDER BY stream
	IF @currentSrcStreamNum = 0
		SET @currentSrcStreamNum = @noOfStreamReaders + 1
ENd
IF @currentSrcStreamNum > 0
BEGIN
	UPDATE ArchChunkToRecoverDDB
SET		Status = 0
	FROM	ArchChunkToRecoverDDB a
	WHERE	a.AdminJobId = @i_adminJobId
	AND		a.SrcCopyId = @i_archCopyId
	AND		a.SegmentId = @i_segmentId
AND		a.Status = 3 /*CVA_CHUNK_SKIPPED*/
	AND		(
				a.SrcStreamNum = @currentSrcStreamNum
			)
	--AND		a.SkippedCount < @MAX_FAILURE_COUNT
	AND		(
				a.SkippedForSeconds = 0 AND (a.Modified + @RETRY_TIME_INTERVAL) < @NOW
				OR
				(a.Modified + a.SkippedForSeconds) < @NOW
			)
END
IF @currentReservationId > 0
BEGIN
	SELECT @currentSourceVolumeId = VolumeId, @currentSourceMAId = clientId, @currentSourceDPId = DrivePoolId
	FROM	MMResource WITH (NOLOCK)
	WHERE	ReservationId = @currentReservationId
END
ELSE
BEGIN
	IF @currentSourceVolumeId = 0
		GOTO PICK_NEXT_SEGMENT
END
PICK_NEXT_CHUNK:
	-- Lookup partially copied chunks first
	-- Refer to stored procedure archChunkToCopyGetFirst.sp
	DECLARE	@oneConstReal REAL = 1.0
	IF EXISTS (	SELECT TOP 1 VolumeId
				FROM ArchChunkToRecoverDDB R WITH (NOLOCK)
				WHERE	R.AdminJobId = @i_adminJobId
						AND		R.SrcCopyId = @i_archCopyId
						AND		R.SegmentId = @i_segmentId
AND		R.Status = 0)
		GOTO SUCCESS_EXIT
PICK_NEXT_SEGMENT:
	BEGIN
		-- Reset SKIPPED flag based on the destination stream for any failed count or time for different segment but the same destination stream num
		-- The reason for doing it within the same segment is to reduce the possiblity of deadlock.
		IF @currentSrcStreamNum > 0
		BEGIN
			UPDATE ArchChunkToRecoverDDB
SET		Status = 0
			WHERE	AdminJobId = @i_adminJobId
			AND		SrcCopyId = @i_archCopyId
			AND		SegmentId != @i_segmentId
AND		Status = 3 /*CVA_CHUNK_SKIPPED*/
			-- Reset all the chunk even if the destnation copy doesn't have reservation right now.
			--AND		NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = ArchChunkToRecoverDDB.AdminJobId AND segmentId = ArchChunkToRecoverDDB.SegmentId)
			AND		(
						SrcStreamNum = @currentSrcStreamNum
					)
			/*
			AND		(
						SkippedCount < @MAX_FAILURE_COUNT
					--	AND SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)
					--	OR
					--	SkippedCount < 12 AND SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)
					)
			*/
			AND		(
						SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
						OR
						(Modified + SkippedForSeconds) < @NOW
					)
			IF NOT EXISTS (SELECT TOP 1 SegmentId FROM ArchChunkToRecoverDDB WITH (NOLOCK)
							WHERE	AdminJobId = @i_adminJobId
							AND		SegmentId > 0
							AND		SrcCopyId = @i_archCopyId
							AND		SegmentId != @i_segmentId
AND		Status = 0 /*CVA_CHUNK_POPULATED*/
							AND		(
										SrcStreamNum = @currentSrcStreamNum
									)
						)
			BEGIN
				UPDATE ArchChunkToRecoverDDB
SET		Status = 0, SkippedReason = 0, SkippedForSeconds = 0, ErrorCode = 0, Modified = @now
				WHERE	adminJobId = @i_adminJobId
				AND		SegmentId > 0
				AND		SrcCopyId = @i_archCopyId
				AND		SegmentId != @i_segmentId
				AND		(
							SrcStreamNum = @currentSrcStreamNum
						)
AND		Status = 3
AND		SkippedReason = 0X13
AND		ErrorCode = 20025
			END
		END
		-- Figure out the next volume or chunk, then the next segmentId
		-- Refer to auxcopymanager logic for getnextvolume and getnextchunk
		--SET @currentSourceVolumeId = 0, @currentSourceMAId = 0, @currentSourceDPId = 0
		DECLARE @currentMediaId				int	= 0
		DECLARE @currentRecordingFormatId	int = 0
		DECLARE @currentLibraryId			int = 0
		DECLARE @currentMasterPoolId		int = 0
		DECLARE @currentMountPathId			int = 0
		DECLARE @currentDeviceId			int = 0
		DECLARE @currentDeviceControllerId	int = 0
		SELECT	@currentMediaId = media.MediaId,
				@currentRecordingFormatId = volume.RecordingFormatId,
				@currentLibraryId = CASE WHEN media.LibraryId > 0 THEN media.LibraryId ELSE media.LastWriteLibraryId END
		FROM	MMMedia media WITH (NOLOCK), MMVolume volume WITH (NOLOCK)
		WHERE	volume.volumeId = @currentSourceVolumeId
		AND		volume.MediaId = media.MediaId
		IF @currentRecordingFormatId = 10001
		BEGIN
			SELECT @currentMasterPoolId = dp.MasterPoolId,
					@currentMountPathId = path.MountPathId,
					@currentDeviceId = device.DeviceId,
					@currentDeviceControllerId = ctrl.DeviceControllerId
			FROM	MMDrivePool dp WITH (NOLOCK), MMMediaSide side WITH (NOLOCK),
					MMMountPath path WITH (NOLOCK), MMMountPathToStorageDevice device WITH (NOLOCK), MMDeviceController ctrl WITH (NOLOCK)
			WHERE	dp.DrivePoolId = @currentSourceDPId
			AND		side.MediaId = @currentMediaId
			AND		side.MediaSideId = path.MediaSideId
			AND		path.MountPathId = device.MountPathId
			AND		device.DeviceId = ctrl.DeviceId
			ANd		ctrl.ClientId = dp.ClientId
		END
		DELETE #tblNextSegments
		IF @i_segmentId > 0 AND NOT EXISTS (SELECT 1 FROM @tblTriedSegmentList WHERE segmentId = @i_segmentId)
			INSERT INTO @tblTriedSegmentList VALUES (@i_segmentId)
		DELETE @tblExcludedSegmentId
		INSERT INTO @tblExcludedSegmentId
SELECT DISTINCT SegmentId FROM ArchChunkToRecoverDDB WITH (READUNCOMMITTED) WHERE AdminJobId = @i_adminJobId AND Status = 1
		INSERT INTO #tblNextSegments
		SELECT	DISTINCT a.SegmentId, 0, 0, 0, 0
		FROM	ArchChunkToRecoverDDB a WITH (READUNCOMMITTED)
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
AND		a.Status = 0
		AND		(a.SrcStreamNum = 0 OR a.SrcStreamNum = @currentSrcStreamNum)
		DELETE #tblNextSegments
		FROM #tblNextSegments b left join @tblExcludedSegmentId c ON c.segmentId = b.SegmentId
		WHERE EXISTS (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0 AND segmentId = b.SegmentId)
		OR	c.segmentId IS NOT NULL
		OR EXISTS (SELECT 1 FROM @tblTriedSegmentList WHERE segmentId = b.segmentId)
		IF NOT EXISTS (SELECT * FROM #tblNextSegments)
			GOTO NO_MORE_CHUNK
		/*
		DELETE #tblNextVolumes
		IF @currentRecordingFormatId = 10001
		BEGIN
			INSERT INTO #tblNextVolumes (volumeId, mediaId, recordingFormatId, libraryId, MountPathId, deviceId, segmentId, ChunkIdRowNumber)
			SELECT	DISTINCT a.VolumeId, a.MediaId, RecordingFormatId, 0, MountPathId, 0,
					0,
					ROW_NUMBER() OVER (PARTITION BY a.VolumeId, a.archFileId, a.commCellId, a.ChunkCommCellId ORDER BY a.archChunkId) AS ChunkIdRowNumber
			FROM	ArchChunkToRecoverDDB a WITH (READUNCOMMITTED), #tblNextSegments b
			WHERE	a.AdminJobId = @i_adminJobId
			AND		a.SrcCopyId = @i_archCopyId
			AND		a.segmentId = b.segmentId
			--AND		a.SegmentId NOT IN (SELECT segmentId FROM ArchJobStreamStatus WITH (READUNCOMMITTED) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0)
AND		a.Status = 0
			UPDATE a
			SET		RecordingFormatId = volume.RecordingFormatId,
					libraryId = CASE WHEN media.LibraryId > 0 THEN media.LibraryId ELSE media.LastWriteLibraryId END,
					mountPathId = path.MountPathId,
					deviceId = device.DeviceId
			FROM	#tblNextVolumes a,
					MMVolume volume WITH (READUNCOMMITTED), MMMedia media WITH (READUNCOMMITTED), MMMediaSide side WITH (READUNCOMMITTED),
					MMMountPath path WITH (READUNCOMMITTED), MMMountPathToStorageDevice device WITH (READUNCOMMITTED)
			WHERE	a.VolumeId = volume.VolumeId
			AND		volume.MediaId = media.MediaId
			AND		volume.RecordingFormatId = 10001
			AND		media.MediaId = side.MediaId
			AND		side.MediaSideId = path.MediaSideId
			AND		path.MountPathId = device.MountPathId
		END
		IF NOT EXISTS (SELECT * FROM #tblNextVolumes)
			GOTO NO_MORE_CHUNK
		*/
		DECLARE @nextVolumeId	int
		DECLARE @nextChunkId	int
		DECLARE @nextSegmentId	int
		SET @nextVolumeId = 0
		SET @nextChunkId = 0
		SET @nextSegmentId = 0
		SELECT TOP 1 @nextChunkId = a.CurrChunkId, @nextSegmentId = a.segmentId, @nextVolumeId = a.volumeId
		FROM	ArchChunkToRecoverDDB a WITH (NOLOCK), #tblNextSegments b
		WHERE	a.AdminJobId = @i_adminJobId
		AND		a.SrcCopyId = @i_archCopyId
		AND		a.SegmentId = b.segmentId
AND		a.Status = 0
		ORDER BY (CASE WHEN (a.mountPathId = @currentMountPathId) THEN 0 ELSE 1 END), a.segmentId
		/*
		SELECT TOP 1 @nextVolumeId = volumeId
		FROM #tblNextVolumes a
		ORDER BY
			CASE WHEN a.recordingFormatId = @currentRecordingFormatId THEN 0 ELSE 1 END,
			-- Finding the next volume which can be read with the same drive pool as the current volume.
			CASE WHEN a.mountPathId = 0 AND EXISTS (SELECT * FROM MMDrivePool dp WITH (NOLOCK), MMMasterPool master WITH (NOLOCK), MMRecFmtMedTyp FMT, MMDrive drive
														WHERE a.libraryId = master.LibraryId AND master.MasterPoolId = dp.MasterPoolId AND dp.DrivePoolId = @currentSourceDPId
														AND	master.MasterPoolId = drive.MasterPoolId AND FMT.DriveTypeId = drive.DriveTypeId
AND	FMT.RecordingFormatId = a.RecordingFormatId AND (FMT.CompatibilityType & 4) > 0)
				THEN 0
				WHEN a.mountPathId > 0 AND (mountPathId = @currentMountPathId OR deviceId = @currentDeviceId)
				THEN 0
				ELSE 1 END,
			-- Finding a volume which can be read from the same library as the current volume.
			CASE WHEN libraryId = @currentLibraryId THEN 0 ELSE 1 END,
			-- Finding a volume which can be read from the same media agent as the current volume.
			CASE WHEN a.mountPathId = 0 AND EXISTS (SELECT * FROM MMDrivePool dp WITH (NOLOCK), MMMasterPool master WITH (NOLOCK), MMRecFmtMedTyp FMT, MMDrive drive
														WHERE a.libraryId = master.LibraryId AND master.MasterPoolId = dp.MasterPoolId AND dp.ClientId = @currentSourceMAId
														AND	master.MasterPoolId = drive.MasterPoolId AND FMT.DriveTypeId = drive.DriveTypeId
AND	FMT.RecordingFormatId = a.RecordingFormatId AND (FMT.CompatibilityType & 4) > 0)
				THEN 0
				WHEN a.mountPathId > 0 AND EXISTS (SELECT * FROM MMDeviceController ctrl WITH (NOLOCK) WHERE ctrl.DeviceId = a.DeviceId AND ctrl.ClientId = @currentSourceMAId
														AND ctrl.DeviceControllerEnabled = 1 and ctrl.DeviceAccessible = 1)
				THEN 0
				ELSE 1 END,
			-- Finding a volume whose first chunk ID is the smallest.
			ChunkIdRowNumber,
			-- Finding a skipped volume whose first chunk ID is the smallest.
			-- Get next segment of chunks for this stream and push them into the stream volume list - DSA only
			a.VolumeId
		-- Select next chunk
		-- Select next segment
		IF @nextVolumeId > 0
		BEGIN
			delete from @getMAAndDPForVolumeResult
			insert into @getMAAndDPForVolumeResult
			exec mms2getmaanddpforvolume @nextVolumeId, 0, @currentSourceMAId, 0 /*@preferredDestCopyId*/, @i_adminJobId, 1
			if not exists (select * from @getMAAndDPForVolumeResult where retCode = 0 and clientId = @currentSourceMAId)
			begin
				SET @nextVolumeId = 0
				-- TODO: There should be multiple candidates, if one of volumes cannot be read, we need to provide the ability to check rest of them.
				GOTO NO_MORE_CHUNK
			end
			ELSE
			BEGIN
				SELECT TOP 1 @nextChunkId = ArchChunkId, @nextSegmentId = a.segmentId
				FROM	ArchChunkToRecoverDDB a WITH (NOLOCK), #tblNextSegments b
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = b.segmentId
				--AND		a.SegmentId NOT IN (SELECT segmentId FROM ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId AND SrcCopyId = @i_archCopyId AND StreamReaderId > 0)
AND		a.Status = 0
				AND		a.VolumeId = @nextVolumeId
				ORDER BY BackupJobId
			END
		END
		*/
		IF @nextSegmentId > 0 AND @nextVolumeId > 0
		BEGIN
			SET @i_segmentId = @nextSegmentId
			SET @currentSourceVolumeId = @nextVolumeId
			IF NOT EXISTS (SELECT * FROM ArchJobStreamStatus WITH (NOLOCK)
							WHERE	jobId = @i_adminJobId
							AND		SrcCopyId = @i_archCopyId
							AND		StreamReaderId = @i_streamReaderId
							AND		SegmentId = @nextSegmentId
							)
			BEGIN
				DECLARE @newSegmentTotalSize TABLE (
					segmentId	int,
					DestCopyId	int,
					TotalSize	bigint
				)
				DELETE @newSegmentTotalSize
				INSERT INTO @newSegmentTotalSize
				SELECT	a.SegmentId, 0/*a.DestCopyId*/, SUM(a.unCompBytesSize)
				FROM	ArchChunkToRecoverDDB a WITH (NOLOCK), ArchJobStreamStatus b WITH (NOLOCK)
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
				AND		a.AdminJobId = @i_adminJobId
				AND		a.SrcCopyId = @i_archCopyId
				AND		a.SegmentId = @nextSegmentId
AND		a.Status IN (0, 3)
				GROUP BY a.SegmentId
				UPDATE	b
				SET		SegmentId = @nextSegmentId, FirstVolumeId = @nextVolumeId, FirstChunkId = 0, CommCellId = 0, TotalSizeToProcess = a.TotalSize
				FROM	@newSegmentTotalSize a, ArchJobStreamStatus b
				WHERE	b.jobId = @i_adminJobId
				AND		b.SrcCopyId = @i_archCopyId
				AND		b.StreamReaderId = @i_streamReaderId
			END
			ELSE
			BEGIN
				UPDATE	ArchJobStreamStatus
				SET		FirstVolumeId = @nextVolumeId, FirstChunkId = 0, CommCellId = 0
				WHERE	jobId = @i_adminJobId
				AND		SrcCopyId = @i_archCopyId
				AND		StreamReaderId = @i_streamReaderId
			END
			-- After picking the new segment, set the source and destination stream number on all the chunk within the segment
			UPDATE ArchChunkToRecoverDDB
			SET 	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END /*,	DestStreamNum = @currentDestStreamNum */
			FROM	ArchChunkToRecoverDDB a
			WHERE	a.AdminJobId = @i_AdminJobId
			AND	a.SegmentId = @nextSegmentId
			DELETE @tblTriedVolumesList
			GOTO PICK_NEXT_CHUNK
		END
		-- If current source ma and drive pool cannot access the next volume, reset the value.
		-- Pipeline should be dropped, or media agent send request for exchange volume?
	END
DECLARE @l_nAFChunk INT = 0
DECLARE @L_rowcount INT = 0
IF NOT EXISTS (	SELECT TOP 1 VolumeId
			FROM ArchChunkToRecoverDDB R WITH (NOLOCK)
			WHERE	R.AdminJobId = @i_adminJobId
					AND		R.SrcCopyId = @i_archCopyId
					AND		R.SegmentId = @i_segmentId
AND		R.Status = 0)
	GOTO NO_MORE_CHUNK
-- If segmentId changes for the current StreamReader, update the table
-- Need more details on what to returned. Don't think all the information from mediamanager.x is needed.
-- When the process of populate table ArchChunkToRecoverDDB is done, we can fill in more details
SUCCESS_EXIT:
UPDATE ArchChunkToRecoverDDB
SET Status = 1, /*MediaGroupId = b.MediaGroupId, */ Modified = @NOW,
	SrcStreamNum = CASE WHEN @currentSrcStreamNum > 0 THEN @currentSrcStreamNum ELSE @currentDestStreamNum END,
	/*DestStreamNum = @currentDestStreamNum, */
	SrcMAId = @currentSourceMAId, SrcDrivePoolId = @currentSourceDPId,streamReaderId = @i_streamReaderId
FROM	ArchChunkToRecoverDDB a
WHERE	a.AdminJobId = @i_AdminJobId
AND		a.SegmentId = @i_segmentId
AND		a.Status = 0
SELECT @currentSourceCacheMountPathId = ISNULL (MAP.CacheMountPathId, 0)
FROM	MMCloudVolCacheMountPath MAP
WHERE	MAP.VolumeId = @currentSourceVolumeId
/*
SELECT	0, 0, 0, 0,
		0, 0,
		0, 0, 0, 0, 0
*/
IF EXISTS (SELECT 1
	FROM	ArchChunkToRecoverDDB R WITH (READUNCOMMITTED)
	WHERE	R.AdminJobId = @i_AdminJobId
			AND	R.SegmentId = @i_segmentId
			AND R.MinChunkId = 0)
BEGIN
	SELECT	R.VolumeId,	R.MinChunkId, R.MaxChunkId, R.CurrChunkId,
			R.MountPathId, @currentSourceCacheMountPathId,
			0, 0, 1, 1, 1, (V.FlushBlockSizeKB *1024)
	FROM	ArchChunkToRecoverDDB R WITH (READUNCOMMITTED)
	JOIN 	MMVolume V WITH (READUNCOMMITTED) ON R.VolumeId = V.VolumeiD
	WHERE	R.AdminJobId = @i_AdminJobId
			AND	R.SegmentId = @i_segmentId
			AND R.MinChunkId = 0
END
ELSE
BEGIN
	IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
	CREATE TABLE #tblArchChunk
	(
		VolumeId			integer,
		MinChunkId			BIGINT,
		MaxChunkId			BIGINT,
		CurrChunkId			BIGINT,
		MountPathId			INT,
		ChunkId				BIGINT,
		chunkCommCellId		integer,
		chunkNumber			INT,
		physicalSize		BIGINT,
		logicalSize			BIGINT,
		unCompSize			BIGINT,
		volBlockSize		integer,
		archFileId			integer,
		commCellId			integer,
		archCopyId			integer,
		primary key (archFileId, commCellId, archCopyId, ChunkId, chunkCommCellId)
	)
	INSERT INTO #tblArchChunk
	SELECT	R.VolumeId,	R.MinChunkId, R.MaxChunkId, R.CurrChunkId,
			R.MountPathId,
			ISNULL(AC.id, 0), ISNULL(AC.CommCellId, 0), ISNULL(ACM.chunkNumber, 0),	ISNULL(AC.physicalSize, 0),	ISNULL(AC.logicalSize, 0),
			(CASE WHEN ACM.unCompSize > 0 THEN ACM.unCompSize
					WHEN ACM.logicalSize > 0 THEN ACM.logicalSize
					WHEN ACM.physicalSize > 0 THEN ACM.physicalSize
					ELSE 1
			END),
			(V.FlushBlockSizeKB * 1024),
			ACM.archFileId, ACM.CommCellId, ACM.archCopyId
	FROM	ArchChunkToRecoverDDB R WITH (READUNCOMMITTED)
				INNER JOIN archChunk AC WITH (READUNCOMMITTED) ON AC.id BETWEEN R.CurrChunkId AND R.MaxChunkId AND R.chunkCommCellId = AC.commCellId AND R.volumeId = AC.volumeId
				INNER JOIN archChunkMapping ACM WITH (READUNCOMMITTED) ON AC.id = ACM.archChunkId AND AC.CommCellId = ACM.chunkCommCellId
				INNER JOIN MMVolume V WITH (READUNCOMMITTED) ON R.VolumeId = V.VolumeId
	WHERE	R.AdminJobId = @i_AdminJobId
			AND	R.SegmentId = @i_segmentId
AND R.Status = 1
	ORDER BY AC.VolumeId, AC.id
	DELETE	S
	FROM	#tblArchChunk S,
			archFileCopyDedup D LEFT OUTER JOIN archFileSubStore AFSS
				ON	AFSS.archFileId	= D.archFileId
					AND	AFSS.CommCellId	= D.CommCellId
					AND AFSS.SIDBStoreId	= D.SIDBStoreId
	WHERE	S.archFileId	= D.archFileId
			AND S.CommCellId	= D.CommCellId
			AND S.archCopyId	= D.archCopyId
			AND D.primaryObjects = 0
			AND D.secondaryObjects = 0
			AND ISNULL(AFSS.primaryObjects, 0) = 0
			AND ISNULL(AFSS.secondaryObjects, 0) = 0
			AND S.chunkNumber > 0
	IF NOT EXISTS(SELECT 1 FROM #tblArchChunk)
	BEGIN
		UPDATE	R
SET		Status = 2,
				processedChunksCount = chunksCount,
				processedUnCompBytesSize = unCompBytesSize,
				Modified = @NOW
		FROM	ArchChunkToRecoverDDB R
		WHERE	R.AdminJobId = @i_AdminJobId
				AND		R.SegmentId = @i_segmentId
AND		R.Status = 1
		GOTO PICK_NEXT_SEGMENT
	END
	UPDATE	R
	SET		MaxChunkId = T.curMaxChunkId
	FROM	ArchChunkToRecoverDDB R,
			(SELECT	S.VolumeId, S.MinChunkId, S.MaxChunkId, MAX(S.chunkId) curMaxChunkId
			FROM	#tblArchChunk S
			GROUP BY S.VolumeId, S.MinChunkId, S.MaxChunkId
			HAVING	S.MaxChunkId != MAX(S.chunkId)) T
	WHERE	R.AdminJobId = @i_AdminJobId
		AND		R.SegmentId = @i_segmentId
AND		R.Status = 1
		AND		R.VolumeId = T.VolumeId
		AND		R.MinChunkId = T.MinChunkId
		AND		R.MaxChunkId = T.MaxChunkId
	SELECT	DISTINCT S.VolumeId, S.MinChunkId, S.MaxChunkId, S.CurrChunkId, S.MountPathId, @currentSourceCacheMountPathId, S.ChunkId, S.chunkCommCellId, S.physicalSIze, S.logicalSize, S.unCompSize, S.volBlockSize
	FROM	#tblArchChunk S
END
IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
IF object_id('tempdb.dbo.#tblSkippedChunks') IS  NOT null DROP TABLE #tblSkippedChunks
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
RETURN;
NO_MORE_CHUNK:
ERROR_EXIT:
SELECT	0, 0, 0, 0,
		0, 0, 0, 0,
		0, 0, 0, 0
--SELECT 0, 0
IF object_id('tempdb.dbo.#tblArchChunk') IS  NOT null DROP TABLE #tblArchChunk
IF object_id('tempdb.dbo.#tblSkippedChunks') IS  NOT null DROP TABLE #tblSkippedChunks
IF object_id('tempdb.dbo.#tblNextSegments') IS  NOT null DROP TABLE #tblNextSegments
IF object_id('tempdb.dbo.#tblNextVolumes') IS  NOT null DROP TABLE #tblNextVolumes
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkRecoverDDBGetNextChunks')
	delete from GxQscripts where name = 'AMChunkRecoverDDBGetNextChunks'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkRecoverDDBGetNextChunks')
	delete from GXDBVersions where aliasname = 'AMChunkRecoverDDBGetNextChunks'
GO

insert into GXDBVersions values(2, 'AMChunkRecoverDDBGetNextChunks',  '00010001000200130000', 'AMChunkRecoverDDBGetNextChunks', '00010001000200130000')
GO

