

--  ------------  Generated from [../../../Source/CommServer/Db/Sp/AMChunkRecoverDDBCreateNewReaders.sp] ---------- 

-- ----------------------------------------------------------------------
--
--           Copyright (c) 1998  CommVault Systems, Inc.
--                  All rights reserved.
--
--
--        This is unpublished proprietary source code of CommVault
--        Systems, Inc. The copyright notice above does not evidence
--        any actual or intended publication of such source code.
-- ----------------------------------------------------------------------*/
-- dataServer_h_rcsid[]="@(#)$Source: /cvs/cvsrepro/GX/vaultcx/Source/CommServer/Db/Sp/AMChunkRecoverDDBCreateNewReaders.sp,v $ $Id: AMChunkRecoverDDBCreateNewReaders.sp,v 1.1.2.5 2018/09/08 03:03:33 chandru Exp $";
-- Following Line Indicates new Class.  It should be identical to filename!
SET QUOTED_IDENTIFIER OFF
print '>>> Drop Stored Procedure: AMChunkRecoverDDBCreateNewReaders <<<'

IF EXISTS (select * from sysobjects where name='AMChunkRecoverDDBCreateNewReaders')
	drop procedure AMChunkRecoverDDBCreateNewReaders
IF EXISTS (select * from GxQscripts where name='AMChunkRecoverDDBCreateNewReaders')
	delete from GxQscripts where name = 'AMChunkRecoverDDBCreateNewReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkRecoverDDBCreateNewReaders')
	delete from GXDBVersions where aliasname = 'AMChunkRecoverDDBCreateNewReaders'
GO
print '... Creating Procedure: AMChunkRecoverDDBCreateNewReaders'
GO
SET QUOTED_IDENTIFIER ON
GO
create procedure AMChunkRecoverDDBCreateNewReaders
  @i_adminJobId int,
  @i_noOfStreams int
AS
  DECLARE @o_streamReaderId int;
  DECLARE @o_ErrorCode int;
DECLARE @NOW INTEGER;
SET		@NOW = dbo.GetUnixTime(GetUTCDate())
DECLARE @MAX_FAILURE_COUNT INT = 3
    SELECT  TOP 1 @MAX_FAILURE_COUNT = ISNULL(value, 3)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMS2_CONFIG_AUXCOPY_STREAM_RETRY_COUNT'
DECLARE @RETRY_TIME_INTERVAL INT = 180 -- SECONDS
    SELECT  TOP 1 @RETRY_TIME_INTERVAL = ISNULL(value, 180)
    FROM    MMConfigs WITH (NOLOCK)
    WHERE   name = 'MMCONFIG_AUXCOPY_RETRY_STREAM_INTERVAL_MINUTES'
SET @o_ErrorCode = 0
-- Create new stream readers based on request from Media Agent side.
-- Use job id, copy id to figure out which segment can be readed from table ArchChunkToRecoverDDB and then create new stream reader entries.
-- The new stream reader entries will be stored in table ArchJobStreamStatus with reservation status as false.
-- Later reservation logic will process such stream readers and try to allocate resources for each one of them.
-- The retrun values will be list newly created stream reader ids.
-- ArchGroupId and ArchCopyId will be used to identify which storage policy or source copy need to be processed during this call.
-- If neither of them are set, then we consider for the current job instead. The source copy will be multiple based on current job type (parallel or single stream).
if (OBJECT_ID('tempdb.dbo.#AMCRDDB_ArchJobStreamStatus') IS NOT NULL) DROP TABLE #AMCRDDB_ArchJobStreamStatus
	CREATE TABLE #AMCRDDB_ArchJobStreamStatus
	(
		JobId				integer,
		JobToken			varchar(128),
		SrcCopyId			integer,
		SrcStreamNum		integer,
		SrcReservationId	integer,
		SrcRCId				integer,
		SrcMAId				integer,
		SrcDrivePoolId		integer,
		DestCopyId			integer,
		DestStreamNum		integer,
		DestReservationId	integer,
		DestRCId			integer,
		DestMAId			integer,
		DestDrivePoolId		integer,
		StreamReaderId		integer,
		SegmentId			integer default 0,
		FirstVolumeId		integer,
		FirstChunkId		integer,
		CommCellId			integer,
		Status				integer,
		ModifiedTime		integer,
		ReservationRequestId	integer default 0,
		TotalSizeToProcess	bigint,
		TotalSizeProcessed	bigint,
		destSIDBStoreId 	integer default 0,
		PRIMARY KEY (JobId, StreamReaderId, DestCopyId)
	);;
	INSERT INTO #AMCRDDB_ArchJobStreamStatus
	SELECT	*
	FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
	WHERE	JobId = @i_adminJobId
	DELETE FROM #AMCRDDB_ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId
			AND
			(
Status = 0x08
				OR
Status = 0x04
				OR
Status = 0x00
				AND	ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	DECLARE @maxStreamReaderId int
	SELECT @maxStreamReaderId = ISNULL ((SELECT MAX(StreamReaderId) FROM ArchJobStreamStatusHistory WITH (NOLOCK) WHERE JobId = @i_adminJobId), 0)
	IF EXISTS (SELECT StreamReaderId FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId AND StreamReaderId > @maxStreamReaderId)
	BEGIN
		SELECT @maxStreamReaderId = ISNULL ((SELECT MAX(StreamReaderId) FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId), 0)
	END
	-- Logic for selecting which segment to be copied first.
	DECLARE @tblStreamReaderDetails TABLE (
		SrcCopyId		int,
		SrcStreamNum	int,
		DestCopyId		int,
		DestStreamNum	int,
		SegmentId		int,
		CommCellId		int,
		FirstChunkId	int,
		ChunkCommCellId	int,
		FirstVolumeId	int,
		IsMultiWrite	int,
		RowNum			int,
		TotalSizeToProcess	bigint
	)
	DECLARE @tblSegmentIdList TABLE (
		StreamReaderId	int IDENTITY,
		SegmentId		int,
		TotalSizeToProcess	bigint
	)
	DECLARE @tblCopyDetails TABLE (
		SrcCopyId		int,
		DestCopyId		int,
		SegmentId		int,
		IsMultiWrite	int,
		TotalSizeToProcess	bigint
	)
	/* Not required for DDB recon job
	DECLARE @tblPartiallyCopiedChunk TABLE(
		srcCopyId		int,
		srcStreamNum	int,
		mediaGroupId	int,
		destCopyId		int,
		destStreamNum	int,
		commCellId		int,
		archChunkId		int,
		chunkCommCellId	int,
		copiedBytes		bigint,
		copiedUnCompBytes bigint,
		segmentId		int,
		primary key (srcCopyId, destCopyId, destStreamNum, segmentId, archChunkId, chunkCommCellId)
	)
	*/
	DECLARE @tblExcludedSegmentId TABLE(
		segmentId		int,
		primary key (segmentId)
	)
	DECLARE @maxConcurrency		int = 0
	DECLARE @noOfStreamReaders	int = 0
SET @maxConcurrency = CAST((CASE (CAST(dbo.GetJobOption(@i_adminJobId, 2101419249) as int))
WHEN 0 THEN (CAST(dbo.GetJobOption(@i_adminJobId, 1149828289) as int))
								ELSE 0
							   END) AS INT)
	IF @maxConcurrency <= 0
	BEGIN
		-- Set the default stream count to 50 (or configuration) if there is no job option
SELECT @maxConcurrency = (CASE Value WHEN 0 THEN 50 ELSE Value END)
		FROM MMConfigs WITH (NOLOCK) WHERE Name = 'MMCONFIG_DDB_RECONSTRUCTDEDUPDBOPTIONS_MAX_NO_OF_STREAMS'
	END
	SELECT @maxConcurrency = Value
	FROM MMConfigs WITH (NOLOCK)
	WHERE Name = 'MMCONFIG_RESOURCEMANAGER_MAXIMUM_ALLOWED_CONNECTION_PER_DDB'
			AND Value > 0
			AND Value < @maxConcurrency
	SELECT @noOfStreamReaders = COUNT(DISTINCT StreamReaderId)
	FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK)
	WHERE JobId = @i_adminJobId
AND	(Status = 0x01 OR Status = 0x02) /*RESERVED, NITIALIZED*/
	IF @maxConcurrency > 0 AND @maxConcurrency <= @noOfStreamReaders
	BEGIN
SET @o_ErrorCode = 20054
		DELETE FROM @tblStreamReaderDetails
		GOTO EXIT_RETURN
	END
	ELSE IF @maxConcurrency > 0 AND @i_noOfStreams > (@maxConcurrency - @noOfStreamReaders)
	BEGIN
		SET @i_noOfStreams = @maxConcurrency - @noOfStreamReaders
	END
	/* TO BE REMOVED
	UPDATE	ArchChunkToRecoverDDB
SET		Status = 6
	FROM	ArchChunkToRecoverDDB R, JMJobDataStats JDS WITH (READUNCOMMITTED)
	WHERE	R.AdminJobId = @i_adminJobId
	AND		(@i_archGroupId = 0 OR R.ArchGroupId = @i_archGroupId)
	AND		(@i_archCopyId = 0 OR R.SrcCopyId = @i_archCopyId)
	AND		R.SegmentId > 0
	AND		NOT EXISTS (SELECT * FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = R.AdminJobId AND segmentId = R.SegmentId)
ANd		R.Status IN ( 3, 0)
	AND		R.BackupJobId = JDS.JobID
    AND     R.srcCopyId = JDS.archGrpCopyId
	AND		R.fileType = JDS.dataType
	AND		R.CommCellid = JDS.CommCellId
AND		((JDS.disabled & (8192 | 1)) = (8192 | 1)
OR (JDS.disabled & (256)) > 0)
	UPDATE	ArchChunkToRecoverDDB
SET		Status = 6
	FROM	ArchChunkToRecoverDDB R LEFT OUTER JOIN ArchFileCopy AFC WITH (READUNCOMMITTED)
			ON	R.srcCopyId = AFC.archCopyId
				AND		R.archFileId = AFC.archFileId
				AND		R.CommCellid = AFC.CommCellId
	WHERE   R.AdminJobId = @i_adminJobId
AND		(R.Status = 3 OR R.Status = 0)
			AND		(AFC.archFileId IS NULL
OR		(AFC.flags & 256) > 0)
	*/
	-- Reset SKIPPED flag based on the destination stream for any failed count or time
	UPDATE ArchChunkToRecoverDDB
SET		Status = 0
	WHERE	AdminJobId = @i_adminJobId
	AND		SegmentId > 0
	AND		NOT EXISTS (SELECT * FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = ArchChunkToRecoverDDB.AdminJobId AND segmentId = ArchChunkToRecoverDDB.SegmentId)
AND		Status = 3 /*CVA_CHUNK_SKIPPED*/
	/*
	AND		(
				SkippedCount < @MAX_FAILURE_COUNT
			--	AND SkippedReason IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)
			--	OR
			--	SkippedCount < 12 AND SkippedReason NOT IN (CVA_READ_SOURCE_DATA_ERROR, CVA_AUXCOPY_SOURCE_MEDIA_ERROR)
			)
	*/
	AND		(
				SkippedForSeconds = 0 AND (Modified + @RETRY_TIME_INTERVAL) < @NOW
				OR
				(Modified + SkippedForSeconds) < @NOW
			)
AND	SkippedReason != 0X13
	IF NOT EXISTS (SELECT TOP 1 SegmentId FROM ArchChunkToRecoverDDB a WITH (NOLOCK)
					WHERE	AdminJobId = @i_adminJobId
					AND		SegmentId > 0
AND		Status = 0 /*CVA_CHUNK_POPULATED*/
					AND		SegmentId NOT IN (SELECT SegmentId FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId)
					)
	BEGIN
		UPDATE ArchChunkToRecoverDDB
SET		Status = 0, SkippedReason = 0, SkippedForSeconds = 0, ErrorCode = 0, Modified = @now
		WHERE	adminJobId = @i_adminJobId
AND		Status = 3
AND		SkippedReason = 0X13
		AND		SegmentId NOT IN (SELECT SegmentId FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK) WHERE JobId = @i_adminJobId)
	END
	DELETE FROM @tblExcludedSegmentId
	INSERT INTO @tblExcludedSegmentId
SELECT DISTINCT SegmentId FROM ArchChunkToRecoverDDB WITH (NOLOCK) WHERE AdminJobId = @i_adminJobId AND Status = 1
	/* Partial need not be handled with special conditions
	INSERT INTO @tblPartiallyCopiedChunk
	SELECT c.*
	FROM	(
				SELECT	DISTINCT a.SrcCopyId, a.SrcStreamNum, a.MediaGroupId, 0 DestCopyId, 0 DestStreamNum, a.CommCellId, a.CurrChunkId, a.ChunkCommCellId,
						SUM(a.PhysicalSize - a.PhysicalOffset) AS copiedBytes,
						0 size,
						a.segmentId
				FROM	ArchChunkToRecoverDDB a WITH (nolock), archFileCopy b WITH (nolock)
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SegmentId > 0
AND		a.Status = 0
				AND		(@i_archGroupId = 0 OR a.ArchGroupId = @i_archGroupId)
				AND		(@i_archCopyId = 0 OR a.SrcCopyId = @i_archCopyId)
				AND		NOT EXISTS (SELECT * FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = a.AdminJobId AND segmentId = a.SegmentId)
				AND		(
							a.ArchFileId = b.ArchFileId AND
							a.CommCellId = b.CommCellId AND
							a.SrcCopyId = b.ArchCopyId AND
							B.physicalSize > 0 AND B.physicalSize < (A.physicalOffset + A.PhysicalSize)
							--a.PhysicalOffset = b.PhysicalOffset AND
							--b.isValid = 0
						)
				GROUP BY a.SrcCopyId, a.SrcstreamNum, a.mediaGroupId,  a.commCellId, a.CurrChunkId, a.ChunkCommCellId, a.segmentId
			) as c left join @tblExcludedSegmentId d on c.segmentId = d.segmentId
	WHERE	d.segmentId IS NULL
	IF EXISTS (SELECT * FROM @tblPartiallyCopiedChunk)
	BEGIN
		-- This is list of segments that for new readers
		INSERT INTO @tblSegmentIdList
		SELECT TOP (@i_noOfStreams) SegmentId, 0
		FROM	@tblPartiallyCopiedChunk
		GROUP BY SegmentId
		ORDER BY
			COUNT(DISTINCT SrcCopyId) DESC,
			MIN(chunkCommCellId), MIN(CurrChunkId) --, SUM(copiedBytes)
		-- This is the copy info for each segment. Some copies may already have data processed partially or completely.
		-- Therefore, for each segment it may or may not have data for all the copies.
		INSERT	INTO @tblStreamReaderDetails
		SELECT	DISTINCT b.srcCopyId, b.srcStreamNum, b.destCopyId, b.destStreamNum,
				a.segmentId,
				b.CommCellId, b.CurrChunkId, b.chunkCommCellId,
				0, 0,
				(a.StreamReaderId + @maxStreamReaderId) as RowNum,
				0
		FROM	@tblSegmentIdList a,
				(
					SELECT srcCopyId, srcStreamNum, 0, 0, seg.segmentId, CommCellId, CurrChunkId, ChunkCommCellId,
							ROW_NUMBER() OVER (PARTITION BY srcCopyId, seg.segmentId, CommCellId ORDER BY ChunkCommCellId, CurrChunkId) as num
					FROM	ArchChunkToRecoverDDB chunk WITH (NOLOCK), @tblSegmentIdList seg
					WHERE	seg.SegmentId = chunk.SegmentId
					AND		chunk.AdminJobId = @i_adminJobId
AND		chunk.Status = 0
					AND		(@i_archGroupId = 0 OR chunk.ArchGroupId = @i_archGroupId)
					AND		(@i_archCopyId = 0 OR chunk.SrcCopyId = @i_archCopyId)
				) b
		WHERE	a.SegmentId = b.SegmentId
		AND		b.num = 1
		SELECT @maxStreamReaderId = MAX(RowNum) FROM @tblStreamReaderDetails
	END
	*/
	DECLARE @streamCount int
	SET @streamCount = ISNULL((SELECT COUNT(*) FROM @tblStreamReaderDetails), 0)
	-- select new segment
	IF @i_noOfStreams - @streamCount > 0
	BEGIN
		DELETE FROM @tblSegmentIdList
		INSERT INTO @tblSegmentIdList
		SELECT TOP (@i_noOfStreams - @streamCount) b.SegmentId, 0
		FROM	(SELECT	a.SegmentId, COUNT(DISTINCT a.SrcCopyId) as copyCount, MIN(a.chunkCommCellId) as commCellId, MIN(a.CurrChunkId) as chunkId
				FROM	ArchChunkToRecoverDDB a WITH (READUNCOMMITTED)
				WHERE	a.AdminJobId = @i_adminJobId
				AND		a.SegmentId > 0
AND		a.Status = 0 /*CVA_CHUNK_POPULATED*/
				GROUP BY a.SegmentId ) b left join @tblExcludedSegmentId c ON b.segmentId = c.segmentId
		WHERE	b.SegmentId NOT IN (SELECT SegmentId FROM #AMCRDDB_ArchJobStreamStatus WITH (NOLOCK) WHERE jobId = @i_adminJobId)
				AND		b.SegmentId NOT IN (SELECT SegmentId FROM @tblStreamReaderDetails)
				AND		c.segmentId IS NULL
		ORDER BY
			copyCount DESC,
			commCellId, chunkId
		INSERT	INTO @tblStreamReaderDetails
		SELECT	DISTINCT b.srcCopyId, b.srcStreamNum, 0, 0,
				a.segmentId,
				b.CommCellId, b.CurrChunkId, b.chunkCommCellId,
				0, 0,
				(a.StreamReaderId + @maxStreamReaderId) as RowNum,
				0
		FROM	@tblSegmentIdList a,
				(
					SELECT srcCopyId, srcStreamNum, seg.segmentId, 0 CommCellId, CurrChunkId, ChunkCommCellId,
							ROW_NUMBER() OVER (PARTITION BY srcCopyId, /*srcStreamNum, destCopyId, destStreamNum,*/ seg.segmentId /*, CommCellId*/ ORDER BY ChunkCommCellId, CurrChunkId) as num
					FROM	ArchChunkToRecoverDDB chunk WITH (NOLOCK), @tblSegmentIdList seg
					WHERE	seg.SegmentId = chunk.SegmentId
					AND		chunk.AdminJobId = @i_adminJobId
AND		chunk.Status = 0 /*CVA_CHUNK_POPULATED*/
				) b
		WHERE	a.SegmentId = b.SegmentId
		AND		b.num = 1
		DECLARE @currentSegmentId INT = 0
		DECLARE @currentCopyId INT = 0
		DECLARE @currentSrcStreamNum INT = 0
		DECLARE @currentStreamCount	INT = 0
		SELECT TOP 1 @currentSegmentId = SegmentId, @currentCopyId = SrcCopyId FROM @tblStreamReaderDetails WHERE	SegmentId > 0 AND SrcStreamNum = 0
		WHILE (@currentSegmentId > 0)
		BEGIN
			SELECT @currentStreamCount = COUNT(DISTINCT StreamReaderId)
			FROM	#AMCRDDB_ArchJobStreamStatus WITH (NOLOCK)
			WHERE	JobId = @i_adminJobId
			AND		SrcStreamNum > 0
			--AND		DestStreamNum = 0
			AND		SrcCopyId = @currentCopyId
			SELECT	TOP 1 @currentSrcStreamNum = stream
			FROM	ArchStream WITH (NOLOCK)
			WHERE	archGroupCopyId = @currentCopyId
			AND		stream NOT IN (
									SELECT	SrcStreamNum
									FROM	#AMCRDDB_ArchJobStreamStatus WITH (NOLOCK)
									WHERE	JobId = @i_adminJobId
									AND		SrcStreamNum > 0
									--AND		DestStreamNum = 0
									AND		SrcCopyId =  @currentCopyId
									UNION
									SELECT	SrcStreamNum
									FROM	@tblStreamReaderDetails
									WHERE	SrcCopyId = @currentCopyId
								)
			ORDER BY stream
			IF @currentSrcStreamNum = 0
				SET @currentSrcStreamNum = @noOfStreamReaders + 1
			UPDATE @tblStreamReaderDetails SET SrcStreamNum = @currentSrcStreamNum
			WHERE SegmentId = @currentSegmentId AND SrcCopyId = @currentCopyId
			SET @currentSegmentId = 0
			SET @currentCopyId = 0
			SET @currentSrcStreamNum = 0
			SET @currentStreamCount = 0
			SELECT TOP 1 @currentSegmentId = SegmentId, @currentCopyId = SrcCopyId FROM @tblStreamReaderDetails WHERE	SegmentId > 0 AND SrcStreamNum = 0
		END
	END
	UPDATE 	a
	SET		TotalSizeToProcess = ISNULL((SELECT	SUM(chunk.unCompBytesSize)
										FROM	ArchChunkToRecoverDDB chunk WITH (READUNCOMMITTED)
										WHERE	chunk.AdminJobId = @i_adminJobId
AND		chunk.Status IN (0, 3)
										AND		a.SegmentId = chunk.SegmentId
										AND		a.SrcCopyId = chunk.srcCopyId
										/*AND		a.DestCopyId = chunk.destCopyId*/), 0)
	FROM	@tblStreamReaderDetails a
	UPDATE @tblStreamReaderDetails
	SET		FirstVolumeId = ISNULL(b.VolumeId, 0)
	FROM	@tblStreamReaderDetails a, ArchChunkToRecoverDDB b WITH (NOLOCK)
	WHERE	b.AdminJobId = @i_adminJobId
	AND		a.ChunkCommCellId = b.ChunkCommCellId
	AND		a.FirstChunkId = b.CurrChunkId
	/* Not applicable for DDB recon job
	UPDATE @tblStreamReaderDetails
SET		IsMultiWrite = CASE WHEN b.Flags & 2048 > 0 THEN 1 ELSE 0 END
	FROM	@tblStreamReaderDetails a, ArchGroupCopy b WITH (NOLOCK)
	WHERE	a.SrcCopyId > 0
	AND		a.SrcCopyId = b.Id
	*/
EXIT_RETURN:
	if (OBJECT_ID('tempdb.dbo.#AMCRDDB_ArchJobStreamStatus') IS NOT NULL) DROP TABLE #AMCRDDB_ArchJobStreamStatus
	-- Remove all the processed StreamReader but wtih no valid RCId
	INSERT INTO ArchJobStreamStatusHistory (
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		ModifiedTime,
		ReservationRequestId,
		ModifiedReason
	)
	SELECT
		JobId, JobToken,
		SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
		DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
		StreamReaderId,
		SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
		Status,
		dbo.GetUnixTime(getutcdate()),
		ReservationRequestId,
'DELETE DUE TO ' + CASE WHEN Status = 0x08	THEN 'STREAM RELEASED'
WHEN Status = 0x04	THEN 'STREAM FAILURE'
WHEN Status = 0x00	THEN 'RESERVATION REQUEST TIMEOUT'
								ELSE	'RESERVATION INVALID' END
	FROM	ArchJobStreamStatus WITH (NOLOCK)
	WHERE	JobId = @i_adminJobId
	AND		(
Status = 0x08
				OR
Status = 0x04
				OR
Status = 0x00
				AND ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	DELETE FROM ArchJobStreamStatus
	WHERE	JobId = @i_adminJobId
	AND		(
Status = 0x08
				OR
Status = 0x04
				OR
Status = 0x00
				AND ReservationRequestId = 0 AND (ModifiedTime + @RETRY_TIME_INTERVAL) < @NOW
			)
	IF EXISTS (SELECT * FROM @tblStreamReaderDetails)
	BEGIN
		INSERT INTO ArchJobStreamStatus (
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			ModifiedTime,
			ReservationRequestId,
			TotalSizeToProcess, TotalSizeProcessed
		)
		SELECT
			@i_adminJobId, '',
			SrcCopyId, SrcStreamNum, 0, 0, 0, 0,
			DestCopyId, DestStreamNum, 0, 0, 0, 0,
			RowNum,
			SegmentId, FirstVolumeId, FirstChunkId, ChunkCommCellId,
			0 /*NOT RESERVED, NOT INITIALIZED*/,
			dbo.GetUnixTime(getutcdate()),
			0,
			TotalSizeToProcess, 0
		FROM	@tblStreamReaderDetails
		INSERT INTO ArchJobStreamStatusHistory (
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			ModifiedTime,
			ReservationRequestId,
			ModifiedReason
		)
		SELECT
			JobId, JobToken,
			SrcCopyId, SrcStreamNum, SrcReservationId, SrcRCId, SrcMAId, SrcDrivePoolId,
			DestCopyId, DestStreamNum, DestReservationId, DestRCId, DestMAId, DestDrivePoolId,
			StreamReaderId,
			SegmentId, FirstVolumeId, FirstChunkId, CommCellId,
			Status,
			dbo.GetUnixTime(getutcdate()),
			ReservationRequestId,
			'CREATE'
		FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
		WHERE	JobId = @i_adminJobId
AND		Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
		SELECT	DISTINCT StreamReaderId, 0
		FROM	ArchJobStreamStatus WITH (READUNCOMMITTED)
		WHERE	JobId = @i_adminJobId
AND		Status = 0x00 /*NOT RESERVED, NOT INITIALIZED*/
	END
	ELSE
	BEGIN
		SELECT 0, @o_ErrorCode
	END
RETURN;
GO

IF EXISTS (select * from GxQscripts where name = 'AMChunkRecoverDDBCreateNewReaders')
	delete from GxQscripts where name = 'AMChunkRecoverDDBCreateNewReaders'
GO

IF EXISTS (select * from GXDBVersions where aliasname='AMChunkRecoverDDBCreateNewReaders')
	delete from GXDBVersions where aliasname = 'AMChunkRecoverDDBCreateNewReaders'
GO

insert into GXDBVersions values(2, 'AMChunkRecoverDDBCreateNewReaders',  '00010001000200050000', 'AMChunkRecoverDDBCreateNewReaders', '00010001000200050000')
GO

