

--  ------------  Generated from [../../../Source/CommServer/Db/Function/simGetClientPropPackagesForClient.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: simGetClientPropPackagesForClient'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[simGetClientPropPackagesForClient]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[simGetClientPropPackagesForClient]
  delete from GXDBVersions where name = 'simGetClientPropPackagesForClient' and type = 5
END
GO

CREATE FUNCTION [dbo].[simGetClientPropPackagesForClient](@inClientId integer)
RETURNS TABLE
AS
RETURN
	SELECT 	cpname.simPackageId as t_packageId,
			acp.attrName as t_attrName,
			acp.attrVal as t_configuredState
	FROM app_clientProp acp WITH (NOLOCK)
	JOIN SIMGetClientPropInstalledNames(DEFAULT) cpname ON acp.attrName = cpname.attrName
	JOIN app_client ac WITH (NOLOCK) ON acp.componentNameId = ac.id
	JOIN simoperatingsystem sos ON ac.simOperatingSystemId = sos.id
	WHERE acp.componentNameId = @inClientId
	AND acp.modified = 0
	AND (cpname.simpackageid >
			CASE sos.Type
				WHEN 'Windows' THEN 0
				WHEN 'UNIX' THEN 1000
				WHEN 'NetWare' THEN 2000
			END
		AND cpname.simpackageId <
			CASE sos.Type
				WHEN 'Windows' THEN 1000
				WHEN 'UNIX' THEN 2000
				WHEN 'NetWare' THEN 3000
			END
		OR sos.subType = 'Linux' AND cpname.simpackageid > 850 AND cpname.simpackageid < 900)


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [simGetClientPropPackagesForClient]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'simGetClientPropPackagesForClient' AND revision = '1.1.2.1.84.1')

  insert into GXDBVersions values(5, 'simGetClientPropPackagesForClient',  '1.1.2.1.84.1', 'simGetClientPropPackagesForClient', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
