

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sfIsUserWorkFlowOwner.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sfIsUserWorkFlowOwner'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sfIsUserWorkFlowOwner]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sfIsUserWorkFlowOwner]
  delete from GXDBVersions where name = 'sfIsUserWorkFlowOwner' and type = 5
END
GO

	CREATE FUNCTION sfIsUserWorkFlowOwner(@workFlowId integer, @operation varchar(8), @loginName nvarchar(255) )
	RETURNS INTEGER
	AS
	BEGIN
	--Requirement - Client should have at least one owner as user
	DECLARE @includeUsersFlags int = -1;
	SET @includeUsersFlags = ( CAST (0x001 AS INT) ) --( CAST (USERS_VALID AS INT) )
	DECLARE @result integer = 0
	IF Exists(SELECT * FROM WF_Definition (nolock) WF,
	(SELECT distinct id  FROM UMUsers with(nolock)  WHERE flags & @includeUsersFlags <> 0 AND
	((@operation = 'LIKE' AND login LIKE '%' + @loginName + '%') OR
	(@operation = 'N_LIKE' AND login NOT LIKE '%' + @loginName + '%') OR
	(@operation = '=' AND login = @loginName) OR
	(@operation = '!=' AND login <> @loginName) OR
	(@operation = 'S_WITH' AND login LIKE  @loginName + '%'	) OR
	(@operation = 'E_WITH' AND login LIKE   '%' + @loginName 	)
	)) u
	WHERE WF.workFlowId = @workFlowId AND u.id = WF.userId )
		SET @result = 1
	RETURN @result
	END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sfIsUserWorkFlowOwner]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sfIsUserWorkFlowOwner' AND revision = '1.4.42.1')

  insert into GXDBVersions values(5, 'sfIsUserWorkFlowOwner',  '1.4.42.1', 'sfIsUserWorkFlowOwner', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
