

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sfGetClientGroupCompanyName.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sfGetClientGroupCompanyName'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sfGetClientGroupCompanyName]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sfGetClientGroupCompanyName]
  delete from GXDBVersions where name = 'sfGetClientGroupCompanyName' and type = 5
END
GO

SET QUOTED_IDENTIFIER ON
GO
/*************************************************************************************************************************************************
   FUNCTION: sfGetClientGroupCompanyName
   INPUT   : clientGroupId
   OUTPUT  : name of the company to which the client belongs
			 1. Check if the clientGroup is the default created clientgroup of a company with property 'Associated Smart Client Group'
			 2. If it is not default created, check if the clientGroup is created by  a user/usergroup who belongs to a company and
				return the company's  name
 **************************************************************************************************************************************************/
CREATE FUNCTION sfGetClientGroupCompanyName(@clientGroupId integer)
RETURNS NVARCHAR(max)
AS
BEGIN
	DECLARE @companyId INT = 0
	DECLARE @companyName NVARCHAR(510) = ''
	--check if this client is autocreated when a company is created
	SET @companyId = ISNULL((SELECT TOP(1) componentNameId FROM App_CompanyProp WITH(NOLOCK) WHERE attrname = 'Associated Smart Client Group' AND attrValInt = @clientGroupId AND cs_attrName=checksum('Associated Smart Client Group') AND modified = 0 ),0)
	-- if it is not a default created company , check it in umsecurityassociations
	IF @companyId = 0
SET @companyId = ISNULL((SELECT TOP(1) companyId FROM UMSecurityAssociations WITH(NOLOCK) WHERE entityType1 = 28 AND entityId1 = @clientGroupId AND isCreator = 1),0)
	IF @companyId > 0
		SET @companyName = (SELECT hostname FROM UMDSProviders WITH(NOLOCK) WHERE id = @companyId)
	RETURN @companyName
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sfGetClientGroupCompanyName]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sfGetClientGroupCompanyName' AND revision = '')

  insert into GXDBVersions values(5, 'sfGetClientGroupCompanyName',  '', 'sfGetClientGroupCompanyName', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
