

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_isUserOperator.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: sec_isUserOperator'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_isUserOperator]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_isUserOperator]
  delete from GXDBVersions where name = 'sec_isUserOperator' and type = 5
END
GO

CREATE FUNCTION sec_isUserOperator(@userId INT, @companyId INT)
RETURNS INT
AS
BEGIN
	DECLARE @returnVal INT = 0
	-- Check if user is directly operator of the company.
	SELECT @returnVal = 1
	FROM UMOperators (NOLOCK)
	WHERE
		isUser = 1 AND userOrGroupId = @userId
		AND companyId = @companyId
	IF @returnVal IS NULL OR @returnVal = 0
	BEGIN
		-- Check if his user group is the operator.
		SELECT @returnVal = 1
		FROM UMOperators (NOLOCK) UMO
			INNER JOIN UMUserGroup (NOLOCK) UG
				ON UMO.isUser = 0 AND UMO.userOrGroupId = UG.groupId
			INNER JOIN UMGroups (NOLOCK) G
				ON G.id = UG.groupId
		WHERE
			UMO.companyId = @companyId
			AND UG.userId = @userId
AND G.groupFlags & 0x0001 <> 0
		IF @returnVal IS NULL OR @returnVal = 0
		BEGIN
			-- Check if his higher level user group is the operator.
			SELECT @returnVal = 1
			FROM UMOperators (NOLOCK) UMO
				INNER JOIN UMDSGroupMaps (NOLOCK) GM
					ON UMO.isUser = 0 AND UMO.userOrGroupId = GM.umGroupId
				INNER JOIN UMUserGroup (NOLOCK) UG
					ON GM.umdsGroupId = UG.groupId
				INNER JOIN UMGroups (NOLOCK) G1					-- local group
					ON G1.id = GM.umGroupId
				INNER JOIN UMGroups (NOLOCK) G2					-- AD group
					ON G2.id = GM.umdsGroupId
			WHERE
				UMO.companyId = @companyId
				AND UG.userId = @userId
AND G1.groupFlags & 0x0001 <> 0		-- Both local and AD group should be enabled.
AND G2.groupFlags & 0x0001 <> 0
		END
	END
	IF @returnVal = 0 OR @returnVal IS NULL
	BEGIN
		-- Handling Master users as default operators for all companies.
		DECLARE @masterGroupId INT = dbo.GetMasterGroupId()
		IF EXISTS (SELECT 1
				   FROM UMUserGroup (NOLOCK)
				   WHERE
						userId = @UserId AND groupId = @masterGroupId
				   UNION ALL
				   SELECT 1
				   FROM UMUserGroup (NOLOCK)
						INNER JOIN UMDSGroupMaps (NOLOCK)
							ON umdsGroupId = groupId
				   WHERE
						userId = @userId AND umGroupId = @masterGroupId)
		BEGIN
			SET @returnVal = 1
		END
	END
	IF @returnVal IS NULL
		SET @returnVal = 0
	RETURN @returnVal
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_isUserOperator]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_isUserOperator' AND revision = '')

  insert into GXDBVersions values(5, 'sec_isUserOperator',  '', 'sec_isUserOperator', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
