

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getPermissionForEntityTypeCreator.func] ---------- 


SET QUOTED_IDENTIFIER OFF

SET NOCOUNT ON


print '... Creating Function: sec_getPermissionForEntityTypeCreator'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getPermissionForEntityTypeCreator]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getPermissionForEntityTypeCreator]
  delete from GXDBVersions where name = 'sec_getPermissionForEntityTypeCreator' and type = 5
END
GO

	CREATE FUNCTION sec_getPermissionForEntityTypeCreator (
		@entityType INTEGER
	)
	RETURNS @PermissionRoleTable TABLE (
		roleId          INTEGER,
		permissionId    INTEGER
	)
	AS
	BEGIN
		DECLARE @roleId INTEGER = 0
		IF @entityType =  28
		BEGIN
		    INSERT INTO @PermissionRoleTable
				SELECT id, 0
				FROM UMRoles
				WHERE name = 'Client Group Creator'
		END
		ELSE
		IF (@entityType =  9 or @entityType =  17)
		BEGIN
		    INSERT INTO @PermissionRoleTable
				SELECT 0, 10
		END
		ELSE
		IF @entityType =  90
		BEGIN
		    INSERT INTO @PermissionRoleTable
				SELECT 0, 31
				UNION
				SELECT 0, 109
				UNION
				SELECT 0, 111
				UNION
				SELECT 0, 110
				UNION
				SELECT 0, 107
		END
		ELSE
		IF @entityType =  35
		BEGIN
			SET @roleId = ISNULL((SELECT id FROM UMRoles WHERE name = 'Schedule Policy Creator'), 0)
			IF @roleId <> 0
				INSERT INTO @PermissionRoleTable
					SELECT @roleId, 0
			ELSE
				INSERT INTO @PermissionRoleTable
					SELECT 0, 116
					UNION
					SELECT 0, 117
					UNION
					SELECT 0, 118
		END
		ELSE
		IF @entityType =  130
		BEGIN
		    INSERT INTO @PermissionRoleTable
				SELECT 0, 26
		END
		ELSE
		IF @entityType =  83
		BEGIN
		    INSERT INTO @PermissionRoleTable
				SELECT 0, 31
				UNION
				SELECT 0, 112
				UNION
				SELECT 0, 113
				UNION
				SELECT 0, 114
				UNION
				SELECT 0, 16
				UNION
				SELECT 0, 107
		END
		ELSE
		IF @entityType =  64
		BEGIN
		    INSERT INTO @PermissionRoleTable
				SELECT id, 0
				FROM UMRoles
				WHERE name = 'Alert Owner'
		END
		ELSE
		IF @entityType =  132 OR @entityType = 133 OR @entityType = 157
		BEGIN
		    INSERT INTO @PermissionRoleTable
				SELECT 0, 201
				UNION
				SELECT 0, 202
				UNION
				SELECT 0, 203
				UNION
				SELECT 0, 204
				UNION
				SELECT 0, 107
		END
		RETURN
    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getPermissionForEntityTypeCreator]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getPermissionForEntityTypeCreator' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getPermissionForEntityTypeCreator',  '', 'sec_getPermissionForEntityTypeCreator', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
