

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getCreatorIdForEntity.func] ---------- 


SET QUOTED_IDENTIFIER ON

SET NOCOUNT ON


print '... Creating Function: sec_getCreatorIdForEntity'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getCreatorIdForEntity]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getCreatorIdForEntity]
  delete from GXDBVersions where name = 'sec_getCreatorIdForEntity' and type = 5
END
GO

CREATE FUNCTION sec_getCreatorIdForEntity (@entityType1 INT, @entityId1 INT, @entityType2 INT, @entityId2 INT, @entityType3 INT, @entityId3 INT, @entityType4 INT, @entityId4 INT, @entityType5 INT, @entityId5 INT)
RETURNS @CreatorInfo Table(creatorUserId INT, creatorUserGroupId INT)
AS
    BEGIN
        DECLARE @creatorUserId INT
        DECLARE @creatorUserGroupId INT
		SELECT TOP 1 @creatorUserId = (CASE WHEN isUser = 1 THEN userOrGroupId ELSE 0 END),
					 @creatorUserGroupId = (CASE WHEN isUser = 0 THEN userOrGroupId ELSE 0 END)
		FROM UMSecurityAssociations WITH(NOLOCK)
		WHERE entityType1 = @entityType1 AND entityId1 = @entityId1
										 AND entityType2 = @entityType2 AND entityId2 = @entityId2
										 AND entityType3 = @entityType3 AND entityId3 = @entityId3
										 AND entityType4 = @entityType4 AND entityId4 = @entityId4
										 AND entityType5 = @entityType5 AND entityId5 = @entityId5
										 AND isCreator = 1
		IF @creatorUserId IS NULL SET @creatorUserID = 0
		IF @creatorUserGroupID IS NULL SET @creatorUserGroupId = 0
IF EXISTS (SELECT 1 FROM UMUsers (NOLOCK) WHERE id = @creatorUserID AND flags & 0x8000 <> 0) -- 0x8000
		BEGIN
			SELECT @creatorUserId = attrVal
			FROM UMUsersProp (NOLOCK)
			WHERE
				componentNameId = @creatorUserID
AND attrName = 'Original Reseller User Id'			-- 'Original Reseller User Id'
				AND modified = 0
		END
		INSERT INTO @CreatorInfo
		SELECT @creatorUserId, @creatorUserGroupID
        RETURN
    END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getCreatorIdForEntity]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getCreatorIdForEntity' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getCreatorIdForEntity',  '', 'sec_getCreatorIdForEntity', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
