

--  ------------  Generated from [../../../Source/CommServer/Db/Function/sec_getCommvaultResellersForCompany.func] ---------- 


SET QUOTED_IDENTIFIER ON
SET NOCOUNT ON

SET NOCOUNT ON


print '... Creating Function: sec_getCommvaultResellersForCompany'
GO

if exists (select * from sysobjects where id = object_id(N'[dbo].[sec_getCommvaultResellersForCompany]') and (OBJECTPROPERTY(id, N'IsInlineFunction') = 1 OR OBJECTPROPERTY(id, N'IsTableFunction') = 1 OR OBJECTPROPERTY(id, N'IsScalarFunction') = 1))
BEGIN
  drop function [dbo].[sec_getCommvaultResellersForCompany]
  delete from GXDBVersions where name = 'sec_getCommvaultResellersForCompany' and type = 5
END
GO

CREATE FUNCTION sec_getCommvaultResellersForCompany(@companyId INT)
RETURNS
@resellerInfo TABLE
(
	userId INT,
	login NVARCHAR(MAX),
	fullName NVARCHAR(MAX),
	email NVARCHAR(MAX),
	userGroupId INT,
	userGroupName NVARCHAR(MAX),
	roleId INT,
	roleName NVARCHAR(MAX)
)
AS
BEGIN
	INSERT INTO @resellerInfo
		SELECT U.id, U.login, U.name, U.email, 0, '', R.id, R.name
		FROM UMOperators UMO (NOLOCK)
			INNER JOIN UMUsers U (NOLOCK)
				ON UMO.isUser = 1 AND UMO.userOrGroupId = U.id
			INNER JOIN UMRoles R (NOLOCK)
				ON R.id = UMO.roleId
		WHERE
			UMO.companyId = @companyId
		UNION
		SELECT 0, '', '', '', G.id, CASE WHEN G.umdsProviderId = 0 THEN G.name ELSE Providers.domainName + '\' + G.name END, R.id, R.name
		FROM UMOperators UMO (NOLOCK)
			INNER JOIN UMRoles R (NOLOCK)
				ON R.id = UMO.roleId
			INNER JOIN UMGroups G (NOLOCK)
				ON UMO.isUser = 0 AND UMO.userOrGroupId = G.id
			LEFT JOIN UMDSProviders Providers (NOLOCK)
				ON G.umdsProviderId = Providers.id
		WHERE
			UMO.companyId = @companyId
	RETURN
END


GO
declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 04 Function [sec_getCommvaultResellersForCompany]'
END
GO


if NOT EXISTS (SELECT * FROM GXDBVersions WHERE type = 5 AND name = 'sec_getCommvaultResellersForCompany' AND revision = '')

  insert into GXDBVersions values(5, 'sec_getCommvaultResellersForCompany',  '', 'sec_getCommvaultResellersForCompany', '')
GO

declare @retCode integer		-- Now do Error Check
set @retCode = @@error
if (@retCode <> 0)
BEGIN
	set @retCode = @@error;
	print 'RETVAL: 10 Table [GXDBVersions]'
END
GO


SET NOCOUNT OFF
